<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_dw_list = new packing_dw_list();

// Run the page
$packing_dw_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_dw_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_dw->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpacking_dwlist = currentForm = new ew.Form("fpacking_dwlist", "list");
fpacking_dwlist.formKeyCountName = '<?php echo $packing_dw_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpacking_dwlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_dwlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_dwlist.lists["x_product"] = <?php echo $packing_dw_list->product->Lookup->toClientList() ?>;
fpacking_dwlist.lists["x_product"].options = <?php echo JsonEncode($packing_dw_list->product->lookupOptions()) ?>;
fpacking_dwlist.lists["x_rid"] = <?php echo $packing_dw_list->rid->Lookup->toClientList() ?>;
fpacking_dwlist.lists["x_rid"].options = <?php echo JsonEncode($packing_dw_list->rid->lookupOptions()) ?>;
fpacking_dwlist.lists["x_packing_type"] = <?php echo $packing_dw_list->packing_type->Lookup->toClientList() ?>;
fpacking_dwlist.lists["x_packing_type"].options = <?php echo JsonEncode($packing_dw_list->packing_type->lookupOptions()) ?>;
fpacking_dwlist.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_dwlist.lists["x_godown"] = <?php echo $packing_dw_list->godown->Lookup->toClientList() ?>;
fpacking_dwlist.lists["x_godown"].options = <?php echo JsonEncode($packing_dw_list->godown->lookupOptions()) ?>;

// Form object for search
var fpacking_dwlistsrch = currentSearchForm = new ew.Form("fpacking_dwlistsrch");

// Validate function for search
fpacking_dwlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpacking_dwlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_dwlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_dwlistsrch.lists["x_product"] = <?php echo $packing_dw_list->product->Lookup->toClientList() ?>;
fpacking_dwlistsrch.lists["x_product"].options = <?php echo JsonEncode($packing_dw_list->product->lookupOptions()) ?>;
fpacking_dwlistsrch.lists["x_rid"] = <?php echo $packing_dw_list->rid->Lookup->toClientList() ?>;
fpacking_dwlistsrch.lists["x_rid"].options = <?php echo JsonEncode($packing_dw_list->rid->lookupOptions()) ?>;

// Filters
fpacking_dwlistsrch.filterList = <?php echo $packing_dw_list->getFilterList() ?>;

// Init search panel as collapsed
fpacking_dwlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_dw->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($packing_dw_list->TotalRecs > 0 && $packing_dw_list->ExportOptions->visible()) { ?>
<?php $packing_dw_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_dw_list->ImportOptions->visible()) { ?>
<?php $packing_dw_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_dw_list->SearchOptions->visible()) { ?>
<?php $packing_dw_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($packing_dw_list->FilterOptions->visible()) { ?>
<?php $packing_dw_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$packing_dw->isExport() || EXPORT_MASTER_RECORD && $packing_dw->isExport("print")) { ?>
<?php
if ($packing_dw_list->DbMasterFilter <> "" && $packing_dw->getCurrentMasterTable() == "packing_process_shortage") {
	if ($packing_dw_list->MasterRecordExists) {
		include_once "packing_process_shortagemaster.php";
	}
}
?>
<?php } ?>
<?php
$packing_dw_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$packing_dw->isExport() && !$packing_dw->CurrentAction) { ?>
<form name="fpacking_dwlistsrch" id="fpacking_dwlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($packing_dw_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpacking_dwlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="packing_dw">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$packing_dw_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$packing_dw->RowType = ROWTYPE_SEARCH;

// Render row
$packing_dw->resetAttributes();
$packing_dw_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($packing_dw->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $packing_dw->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php $packing_dw->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$packing_dw->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_dw" data-field="x_product" data-value-separator="<?php echo $packing_dw->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $packing_dw->product->editAttributes() ?>>
		<?php echo $packing_dw->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $packing_dw->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($packing_dw->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $packing_dw->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_dw" data-field="x_rid" data-value-separator="<?php echo $packing_dw->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $packing_dw->rid->editAttributes() ?>>
		<?php echo $packing_dw->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $packing_dw->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $packing_dw_list->showPageHeader(); ?>
<?php
$packing_dw_list->showMessage();
?>
<?php if ($packing_dw_list->TotalRecs > 0 || $packing_dw->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($packing_dw_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> packing_dw">
<?php if (!$packing_dw->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$packing_dw->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_dw_list->Pager)) $packing_dw_list->Pager = new PrevNextPager($packing_dw_list->StartRec, $packing_dw_list->DisplayRecs, $packing_dw_list->TotalRecs, $packing_dw_list->AutoHidePager) ?>
<?php if ($packing_dw_list->Pager->RecordCount > 0 && $packing_dw_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_dw_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_dw_list->pageUrl() ?>start=<?php echo $packing_dw_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_dw_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_dw_list->pageUrl() ?>start=<?php echo $packing_dw_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_dw_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_dw_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_dw_list->pageUrl() ?>start=<?php echo $packing_dw_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_dw_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_dw_list->pageUrl() ?>start=<?php echo $packing_dw_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_dw_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_dw_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_dw_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_dw_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_dw_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_dw_list->TotalRecs > 0 && (!$packing_dw_list->AutoHidePageSizeSelector || $packing_dw_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_dw">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_dw_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_dw_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_dw_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_dw_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_dw_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_dw->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_dw_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpacking_dwlist" id="fpacking_dwlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_dw_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_dw_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_dw">
<?php if ($packing_dw->getCurrentMasterTable() == "packing_process_shortage" && $packing_dw->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="packing_process_shortage">
<input type="hidden" name="fk_tmp_lot" value="<?php echo $packing_dw->tmp_lot->getSessionValue() ?>">
<?php } ?>
<div id="gmp_packing_dw" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($packing_dw_list->TotalRecs > 0 || $packing_dw->isGridEdit()) { ?>
<table id="tbl_packing_dwlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$packing_dw_list->RowType = ROWTYPE_HEADER;

// Render list options
$packing_dw_list->renderListOptions();

// Render list options (header, left)
$packing_dw_list->ListOptions->render("header", "left");
?>
<?php if ($packing_dw->id->Visible) { // id ?>
	<?php if ($packing_dw->sortUrl($packing_dw->id) == "") { ?>
		<th data-name="id" class="<?php echo $packing_dw->id->headerCellClass() ?>"><div id="elh_packing_dw_id" class="packing_dw_id"><div class="ew-table-header-caption"><?php echo $packing_dw->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $packing_dw->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->id) ?>',2);"><div id="elh_packing_dw_id" class="packing_dw_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_dw->dated->Visible) { // dated ?>
	<?php if ($packing_dw->sortUrl($packing_dw->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $packing_dw->dated->headerCellClass() ?>"><div id="elh_packing_dw_dated" class="packing_dw_dated"><div class="ew-table-header-caption"><?php echo $packing_dw->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $packing_dw->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->dated) ?>',2);"><div id="elh_packing_dw_dated" class="packing_dw_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_dw->product->Visible) { // product ?>
	<?php if ($packing_dw->sortUrl($packing_dw->product) == "") { ?>
		<th data-name="product" class="<?php echo $packing_dw->product->headerCellClass() ?>"><div id="elh_packing_dw_product" class="packing_dw_product"><div class="ew-table-header-caption"><?php echo $packing_dw->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $packing_dw->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->product) ?>',2);"><div id="elh_packing_dw_product" class="packing_dw_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_dw->rid->Visible) { // rid ?>
	<?php if ($packing_dw->sortUrl($packing_dw->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $packing_dw->rid->headerCellClass() ?>"><div id="elh_packing_dw_rid" class="packing_dw_rid"><div class="ew-table-header-caption"><?php echo $packing_dw->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $packing_dw->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->rid) ?>',2);"><div id="elh_packing_dw_rid" class="packing_dw_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_dw->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($packing_dw->sortUrl($packing_dw->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $packing_dw->tmp_lot->headerCellClass() ?>"><div id="elh_packing_dw_tmp_lot" class="packing_dw_tmp_lot"><div class="ew-table-header-caption"><?php echo $packing_dw->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $packing_dw->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->tmp_lot) ?>',2);"><div id="elh_packing_dw_tmp_lot" class="packing_dw_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_dw->packing_type->Visible) { // packing_type ?>
	<?php if ($packing_dw->sortUrl($packing_dw->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $packing_dw->packing_type->headerCellClass() ?>"><div id="elh_packing_dw_packing_type" class="packing_dw_packing_type"><div class="ew-table-header-caption"><?php echo $packing_dw->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $packing_dw->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->packing_type) ?>',2);"><div id="elh_packing_dw_packing_type" class="packing_dw_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_dw->IN->Visible) { // IN ?>
	<?php if ($packing_dw->sortUrl($packing_dw->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $packing_dw->IN->headerCellClass() ?>"><div id="elh_packing_dw_IN" class="packing_dw_IN"><div class="ew-table-header-caption"><?php echo $packing_dw->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $packing_dw->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->IN) ?>',2);"><div id="elh_packing_dw_IN" class="packing_dw_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_dw->packets->Visible) { // packets ?>
	<?php if ($packing_dw->sortUrl($packing_dw->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $packing_dw->packets->headerCellClass() ?>"><div id="elh_packing_dw_packets" class="packing_dw_packets"><div class="ew-table-header-caption"><?php echo $packing_dw->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $packing_dw->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->packets) ?>',2);"><div id="elh_packing_dw_packets" class="packing_dw_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_dw->godown->Visible) { // godown ?>
	<?php if ($packing_dw->sortUrl($packing_dw->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $packing_dw->godown->headerCellClass() ?>"><div id="elh_packing_dw_godown" class="packing_dw_godown"><div class="ew-table-header-caption"><?php echo $packing_dw->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $packing_dw->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_dw->SortUrl($packing_dw->godown) ?>',2);"><div id="elh_packing_dw_godown" class="packing_dw_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_dw->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_dw->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_dw->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$packing_dw_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($packing_dw->ExportAll && $packing_dw->isExport()) {
	$packing_dw_list->StopRec = $packing_dw_list->TotalRecs;
} else {

	// Set the last record to display
	if ($packing_dw_list->TotalRecs > $packing_dw_list->StartRec + $packing_dw_list->DisplayRecs - 1)
		$packing_dw_list->StopRec = $packing_dw_list->StartRec + $packing_dw_list->DisplayRecs - 1;
	else
		$packing_dw_list->StopRec = $packing_dw_list->TotalRecs;
}
$packing_dw_list->RecCnt = $packing_dw_list->StartRec - 1;
if ($packing_dw_list->Recordset && !$packing_dw_list->Recordset->EOF) {
	$packing_dw_list->Recordset->moveFirst();
	$selectLimit = $packing_dw_list->UseSelectLimit;
	if (!$selectLimit && $packing_dw_list->StartRec > 1)
		$packing_dw_list->Recordset->move($packing_dw_list->StartRec - 1);
} elseif (!$packing_dw->AllowAddDeleteRow && $packing_dw_list->StopRec == 0) {
	$packing_dw_list->StopRec = $packing_dw->GridAddRowCount;
}

// Initialize aggregate
$packing_dw->RowType = ROWTYPE_AGGREGATEINIT;
$packing_dw->resetAttributes();
$packing_dw_list->renderRow();
while ($packing_dw_list->RecCnt < $packing_dw_list->StopRec) {
	$packing_dw_list->RecCnt++;
	if ($packing_dw_list->RecCnt >= $packing_dw_list->StartRec) {
		$packing_dw_list->RowCnt++;

		// Set up key count
		$packing_dw_list->KeyCount = $packing_dw_list->RowIndex;

		// Init row class and style
		$packing_dw->resetAttributes();
		$packing_dw->CssClass = "";
		if ($packing_dw->isGridAdd()) {
		} else {
			$packing_dw_list->loadRowValues($packing_dw_list->Recordset); // Load row values
		}
		$packing_dw->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$packing_dw->RowAttrs = array_merge($packing_dw->RowAttrs, array('data-rowindex'=>$packing_dw_list->RowCnt, 'id'=>'r' . $packing_dw_list->RowCnt . '_packing_dw', 'data-rowtype'=>$packing_dw->RowType));

		// Render row
		$packing_dw_list->renderRow();

		// Render list options
		$packing_dw_list->renderListOptions();
?>
	<tr<?php echo $packing_dw->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_dw_list->ListOptions->render("body", "left", $packing_dw_list->RowCnt);
?>
	<?php if ($packing_dw->id->Visible) { // id ?>
		<td data-name="id"<?php echo $packing_dw->id->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_id" class="packing_dw_id">
<span<?php echo $packing_dw->id->viewAttributes() ?>>
<?php echo $packing_dw->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_dw->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $packing_dw->dated->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_dated" class="packing_dw_dated">
<span<?php echo $packing_dw->dated->viewAttributes() ?>>
<?php if ((!EmptyString($packing_dw->dated->getViewValue())) && $packing_dw->dated->linkAttributes() <> "") { ?>
<a<?php echo $packing_dw->dated->linkAttributes() ?>><?php echo $packing_dw->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_dw->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_dw->product->Visible) { // product ?>
		<td data-name="product"<?php echo $packing_dw->product->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_product" class="packing_dw_product">
<span<?php echo $packing_dw->product->viewAttributes() ?>>
<?php if ((!EmptyString($packing_dw->product->getViewValue())) && $packing_dw->product->linkAttributes() <> "") { ?>
<a<?php echo $packing_dw->product->linkAttributes() ?>><?php echo $packing_dw->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_dw->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_dw->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $packing_dw->rid->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_rid" class="packing_dw_rid">
<span<?php echo $packing_dw->rid->viewAttributes() ?>>
<?php if ((!EmptyString($packing_dw->rid->getViewValue())) && $packing_dw->rid->linkAttributes() <> "") { ?>
<a<?php echo $packing_dw->rid->linkAttributes() ?>><?php echo $packing_dw->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_dw->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_dw->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $packing_dw->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_tmp_lot" class="packing_dw_tmp_lot">
<span<?php echo $packing_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($packing_dw->tmp_lot->getViewValue())) && $packing_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $packing_dw->tmp_lot->linkAttributes() ?>><?php echo $packing_dw->tmp_lot->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_dw->tmp_lot->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_dw->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $packing_dw->packing_type->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_packing_type" class="packing_dw_packing_type">
<span<?php echo $packing_dw->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($packing_dw->packing_type->getViewValue())) && $packing_dw->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $packing_dw->packing_type->linkAttributes() ?>><?php echo $packing_dw->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_dw->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_dw->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $packing_dw->IN->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_IN" class="packing_dw_IN">
<span<?php echo $packing_dw->IN->viewAttributes() ?>>
<?php echo $packing_dw->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_dw->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $packing_dw->packets->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_packets" class="packing_dw_packets">
<span<?php echo $packing_dw->packets->viewAttributes() ?>>
<?php echo $packing_dw->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_dw->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $packing_dw->godown->cellAttributes() ?>>
<span id="el<?php echo $packing_dw_list->RowCnt ?>_packing_dw_godown" class="packing_dw_godown">
<span<?php echo $packing_dw->godown->viewAttributes() ?>>
<?php if ((!EmptyString($packing_dw->godown->getViewValue())) && $packing_dw->godown->linkAttributes() <> "") { ?>
<a<?php echo $packing_dw->godown->linkAttributes() ?>><?php echo $packing_dw->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_dw->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_dw_list->ListOptions->render("body", "right", $packing_dw_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$packing_dw->isGridAdd())
		$packing_dw_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$packing_dw->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($packing_dw_list->Recordset)
	$packing_dw_list->Recordset->Close();
?>
<?php if (!$packing_dw->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$packing_dw->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_dw_list->Pager)) $packing_dw_list->Pager = new PrevNextPager($packing_dw_list->StartRec, $packing_dw_list->DisplayRecs, $packing_dw_list->TotalRecs, $packing_dw_list->AutoHidePager) ?>
<?php if ($packing_dw_list->Pager->RecordCount > 0 && $packing_dw_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_dw_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_dw_list->pageUrl() ?>start=<?php echo $packing_dw_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_dw_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_dw_list->pageUrl() ?>start=<?php echo $packing_dw_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_dw_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_dw_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_dw_list->pageUrl() ?>start=<?php echo $packing_dw_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_dw_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_dw_list->pageUrl() ?>start=<?php echo $packing_dw_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_dw_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_dw_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_dw_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_dw_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_dw_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_dw_list->TotalRecs > 0 && (!$packing_dw_list->AutoHidePageSizeSelector || $packing_dw_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_dw">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_dw_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_dw_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_dw_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_dw_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_dw_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_dw->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_dw_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($packing_dw_list->TotalRecs == 0 && !$packing_dw->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $packing_dw_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$packing_dw_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_dw->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$packing_dw->isExport()) { ?>
<script>
ew.scrollableTable("gmp_packing_dw", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_dw_list->terminate();
?>