<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_list_no_list = new packing_list_no_list();

// Run the page
$packing_list_no_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_list_no_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_list_no->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpacking_list_nolist = currentForm = new ew.Form("fpacking_list_nolist", "list");
fpacking_list_nolist.formKeyCountName = '<?php echo $packing_list_no_list->FormKeyCountName ?>';

// Validate form
fpacking_list_nolist.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($packing_list_no_list->buyer_po->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->buyer_po->caption(), $packing_list_no->buyer_po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->roll_no->Required) { ?>
			elm = this.getElements("x" + infix + "_roll_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->roll_no->caption(), $packing_list_no->roll_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_roll_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_list_no->roll_no->errorMessage()) ?>");
		<?php if ($packing_list_no_list->qty->Required) { ?>
			elm = this.getElements("x" + infix + "_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->qty->caption(), $packing_list_no->qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qty");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_list_no->qty->errorMessage()) ?>");
		<?php if ($packing_list_no_list->pl_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->pl_no->caption(), $packing_list_no->pl_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pl_no");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_list_no->pl_no->errorMessage()) ?>");
		<?php if ($packing_list_no_list->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->_barcode->caption(), $packing_list_no->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->design_id->Required) { ?>
			elm = this.getElements("x" + infix + "_design_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->design_id->caption(), $packing_list_no->design_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->size_buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_size_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->size_buyer->caption(), $packing_list_no->size_buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->buyers_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyers_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->buyers_id->caption(), $packing_list_no->buyers_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->po->caption(), $packing_list_no->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->sqm->caption(), $packing_list_no->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->current_works->Required) { ?>
			elm = this.getElements("x" + infix + "_current_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->current_works->caption(), $packing_list_no->current_works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->id->caption(), $packing_list_no->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_list_no_list->sqm_a->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm_a");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->sqm_a->caption(), $packing_list_no->sqm_a->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm_a");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_list_no->sqm_a->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpacking_list_nolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_list_nolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_list_nolist.lists["x_design_id"] = <?php echo $packing_list_no_list->design_id->Lookup->toClientList() ?>;
fpacking_list_nolist.lists["x_design_id"].options = <?php echo JsonEncode($packing_list_no_list->design_id->lookupOptions()) ?>;
fpacking_list_nolist.lists["x_buyers_id"] = <?php echo $packing_list_no_list->buyers_id->Lookup->toClientList() ?>;
fpacking_list_nolist.lists["x_buyers_id"].options = <?php echo JsonEncode($packing_list_no_list->buyers_id->lookupOptions()) ?>;
fpacking_list_nolist.lists["x_current_works"] = <?php echo $packing_list_no_list->current_works->Lookup->toClientList() ?>;
fpacking_list_nolist.lists["x_current_works"].options = <?php echo JsonEncode($packing_list_no_list->current_works->lookupOptions()) ?>;

// Form object for search
var fpacking_list_nolistsrch = currentSearchForm = new ew.Form("fpacking_list_nolistsrch");

// Validate function for search
fpacking_list_nolistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->pl_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpacking_list_nolistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_list_nolistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_list_nolistsrch.lists["x_design_id"] = <?php echo $packing_list_no_list->design_id->Lookup->toClientList() ?>;
fpacking_list_nolistsrch.lists["x_design_id"].options = <?php echo JsonEncode($packing_list_no_list->design_id->lookupOptions()) ?>;
fpacking_list_nolistsrch.lists["x_buyers_id"] = <?php echo $packing_list_no_list->buyers_id->Lookup->toClientList() ?>;
fpacking_list_nolistsrch.lists["x_buyers_id"].options = <?php echo JsonEncode($packing_list_no_list->buyers_id->lookupOptions()) ?>;

// Filters
fpacking_list_nolistsrch.filterList = <?php echo $packing_list_no_list->getFilterList() ?>;

// Init search panel as collapsed
fpacking_list_nolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_list_no->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($packing_list_no_list->TotalRecs > 0 && $packing_list_no_list->ExportOptions->visible()) { ?>
<?php $packing_list_no_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_no_list->ImportOptions->visible()) { ?>
<?php $packing_list_no_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_no_list->SearchOptions->visible()) { ?>
<?php $packing_list_no_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_no_list->FilterOptions->visible()) { ?>
<?php $packing_list_no_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$packing_list_no_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$packing_list_no->isExport() && !$packing_list_no->CurrentAction) { ?>
<form name="fpacking_list_nolistsrch" id="fpacking_list_nolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($packing_list_no_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpacking_list_nolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="packing_list_no">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$packing_list_no_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$packing_list_no->RowType = ROWTYPE_SEARCH;

// Render row
$packing_list_no->resetAttributes();
$packing_list_no_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($packing_list_no->buyer_po->Visible) { // buyer_po ?>
	<div id="xsc_buyer_po" class="ew-cell form-group">
		<label for="x_buyer_po" class="ew-search-caption ew-label"><?php echo $packing_list_no->buyer_po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="packing_list_no" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_no->buyer_po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->buyer_po->EditValue ?>"<?php echo $packing_list_no->buyer_po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($packing_list_no->pl_no->Visible) { // pl_no ?>
	<div id="xsc_pl_no" class="ew-cell form-group">
		<label for="x_pl_no" class="ew-search-caption ew-label"><?php echo $packing_list_no->pl_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="packing_list_no" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="15" placeholder="<?php echo HtmlEncode($packing_list_no->pl_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->pl_no->EditValue ?>"<?php echo $packing_list_no->pl_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($packing_list_no->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $packing_list_no->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="packing_list_no" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->_barcode->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->_barcode->EditValue ?>"<?php echo $packing_list_no->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="packing_list_no" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->_barcode->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->_barcode->EditValue2 ?>"<?php echo $packing_list_no->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($packing_list_no->design_id->Visible) { // design_id ?>
	<div id="xsc_design_id" class="ew-cell form-group">
		<label for="x_design_id" class="ew-search-caption ew-label"><?php echo $packing_list_no->design_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_design_id" data-value-separator="<?php echo $packing_list_no->design_id->displayValueSeparatorAttribute() ?>" id="x_design_id" name="x_design_id"<?php echo $packing_list_no->design_id->editAttributes() ?>>
		<?php echo $packing_list_no->design_id->selectOptionListHtml("x_design_id") ?>
	</select>
</div>
<?php echo $packing_list_no->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($packing_list_no->buyers_id->Visible) { // buyers_id ?>
	<div id="xsc_buyers_id" class="ew-cell form-group">
		<label for="x_buyers_id" class="ew-search-caption ew-label"><?php echo $packing_list_no->buyers_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_buyers_id" data-value-separator="<?php echo $packing_list_no->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $packing_list_no->buyers_id->editAttributes() ?>>
		<?php echo $packing_list_no->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $packing_list_no->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($packing_list_no->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $packing_list_no->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="packing_list_no" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->po->EditValue ?>"<?php echo $packing_list_no->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="packing_list_no" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->po->EditValue2 ?>"<?php echo $packing_list_no->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($packing_list_no_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($packing_list_no_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $packing_list_no_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($packing_list_no_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($packing_list_no_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($packing_list_no_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($packing_list_no_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $packing_list_no_list->showPageHeader(); ?>
<?php
$packing_list_no_list->showMessage();
?>
<?php if ($packing_list_no_list->TotalRecs > 0 || $packing_list_no->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($packing_list_no_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> packing_list_no">
<?php if (!$packing_list_no->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$packing_list_no->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_list_no_list->Pager)) $packing_list_no_list->Pager = new PrevNextPager($packing_list_no_list->StartRec, $packing_list_no_list->DisplayRecs, $packing_list_no_list->TotalRecs, $packing_list_no_list->AutoHidePager) ?>
<?php if ($packing_list_no_list->Pager->RecordCount > 0 && $packing_list_no_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_list_no_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_list_no_list->pageUrl() ?>start=<?php echo $packing_list_no_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_list_no_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_list_no_list->pageUrl() ?>start=<?php echo $packing_list_no_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_list_no_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_list_no_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_list_no_list->pageUrl() ?>start=<?php echo $packing_list_no_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_list_no_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_list_no_list->pageUrl() ?>start=<?php echo $packing_list_no_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_list_no_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_list_no_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_list_no_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_list_no_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_list_no_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_list_no_list->TotalRecs > 0 && (!$packing_list_no_list->AutoHidePageSizeSelector || $packing_list_no_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_list_no">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($packing_list_no_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_list_no_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_list_no_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_list_no_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpacking_list_nolist" id="fpacking_list_nolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_list_no_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_list_no_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_list_no">
<div id="gmp_packing_list_no" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($packing_list_no_list->TotalRecs > 0 || $packing_list_no->isGridEdit()) { ?>
<table id="tbl_packing_list_nolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$packing_list_no_list->RowType = ROWTYPE_HEADER;

// Render list options
$packing_list_no_list->renderListOptions();

// Render list options (header, left)
$packing_list_no_list->ListOptions->render("header", "left");
?>
<?php if ($packing_list_no->buyer_po->Visible) { // buyer_po ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->buyer_po) == "") { ?>
		<th data-name="buyer_po" class="<?php echo $packing_list_no->buyer_po->headerCellClass() ?>"><div id="elh_packing_list_no_buyer_po" class="packing_list_no_buyer_po"><div class="ew-table-header-caption"><?php echo $packing_list_no->buyer_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_po" class="<?php echo $packing_list_no->buyer_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->buyer_po) ?>',2);"><div id="elh_packing_list_no_buyer_po" class="packing_list_no_buyer_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->buyer_po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->buyer_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->buyer_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->roll_no->Visible) { // roll_no ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->roll_no) == "") { ?>
		<th data-name="roll_no" class="<?php echo $packing_list_no->roll_no->headerCellClass() ?>" style="width: 10px;"><div id="elh_packing_list_no_roll_no" class="packing_list_no_roll_no"><div class="ew-table-header-caption"><?php echo $packing_list_no->roll_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no" class="<?php echo $packing_list_no->roll_no->headerCellClass() ?>" style="width: 10px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->roll_no) ?>',2);"><div id="elh_packing_list_no_roll_no" class="packing_list_no_roll_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->roll_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->roll_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->roll_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->qty->Visible) { // qty ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $packing_list_no->qty->headerCellClass() ?>" style="width: 10px;"><div id="elh_packing_list_no_qty" class="packing_list_no_qty"><div class="ew-table-header-caption"><?php echo $packing_list_no->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $packing_list_no->qty->headerCellClass() ?>" style="width: 10px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->qty) ?>',2);"><div id="elh_packing_list_no_qty" class="packing_list_no_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->pl_no->Visible) { // pl_no ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $packing_list_no->pl_no->headerCellClass() ?>" style="width: 15px;"><div id="elh_packing_list_no_pl_no" class="packing_list_no_pl_no"><div class="ew-table-header-caption"><?php echo $packing_list_no->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $packing_list_no->pl_no->headerCellClass() ?>" style="width: 15px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->pl_no) ?>',2);"><div id="elh_packing_list_no_pl_no" class="packing_list_no_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->pl_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->_barcode->Visible) { // barcode ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $packing_list_no->_barcode->headerCellClass() ?>" style="width: 25px;"><div id="elh_packing_list_no__barcode" class="packing_list_no__barcode"><div class="ew-table-header-caption"><?php echo $packing_list_no->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $packing_list_no->_barcode->headerCellClass() ?>" style="width: 25px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->_barcode) ?>',2);"><div id="elh_packing_list_no__barcode" class="packing_list_no__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->design_id->Visible) { // design_id ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $packing_list_no->design_id->headerCellClass() ?>"><div id="elh_packing_list_no_design_id" class="packing_list_no_design_id"><div class="ew-table-header-caption"><?php echo $packing_list_no->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $packing_list_no->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->design_id) ?>',2);"><div id="elh_packing_list_no_design_id" class="packing_list_no_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->size_buyer->Visible) { // size_buyer ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->size_buyer) == "") { ?>
		<th data-name="size_buyer" class="<?php echo $packing_list_no->size_buyer->headerCellClass() ?>"><div id="elh_packing_list_no_size_buyer" class="packing_list_no_size_buyer"><div class="ew-table-header-caption"><?php echo $packing_list_no->size_buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_buyer" class="<?php echo $packing_list_no->size_buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->size_buyer) ?>',2);"><div id="elh_packing_list_no_size_buyer" class="packing_list_no_size_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->size_buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->size_buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->size_buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->buyers_id->Visible) { // buyers_id ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $packing_list_no->buyers_id->headerCellClass() ?>"><div id="elh_packing_list_no_buyers_id" class="packing_list_no_buyers_id"><div class="ew-table-header-caption"><?php echo $packing_list_no->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $packing_list_no->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->buyers_id) ?>',2);"><div id="elh_packing_list_no_buyers_id" class="packing_list_no_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->po->Visible) { // po ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->po) == "") { ?>
		<th data-name="po" class="<?php echo $packing_list_no->po->headerCellClass() ?>"><div id="elh_packing_list_no_po" class="packing_list_no_po"><div class="ew-table-header-caption"><?php echo $packing_list_no->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $packing_list_no->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->po) ?>',2);"><div id="elh_packing_list_no_po" class="packing_list_no_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->sqm->Visible) { // sqm ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $packing_list_no->sqm->headerCellClass() ?>"><div id="elh_packing_list_no_sqm" class="packing_list_no_sqm"><div class="ew-table-header-caption"><?php echo $packing_list_no->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $packing_list_no->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->sqm) ?>',2);"><div id="elh_packing_list_no_sqm" class="packing_list_no_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->current_works->Visible) { // current_works ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $packing_list_no->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_packing_list_no_current_works" class="packing_list_no_current_works"><div class="ew-table-header-caption"><?php echo $packing_list_no->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $packing_list_no->current_works->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->current_works) ?>',2);"><div id="elh_packing_list_no_current_works" class="packing_list_no_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->id->Visible) { // id ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->id) == "") { ?>
		<th data-name="id" class="<?php echo $packing_list_no->id->headerCellClass() ?>"><div id="elh_packing_list_no_id" class="packing_list_no_id"><div class="ew-table-header-caption"><?php echo $packing_list_no->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $packing_list_no->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->id) ?>',2);"><div id="elh_packing_list_no_id" class="packing_list_no_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_no->sqm_a->Visible) { // sqm_a ?>
	<?php if ($packing_list_no->sortUrl($packing_list_no->sqm_a) == "") { ?>
		<th data-name="sqm_a" class="<?php echo $packing_list_no->sqm_a->headerCellClass() ?>"><div id="elh_packing_list_no_sqm_a" class="packing_list_no_sqm_a"><div class="ew-table-header-caption"><?php echo $packing_list_no->sqm_a->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_a" class="<?php echo $packing_list_no->sqm_a->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_no->SortUrl($packing_list_no->sqm_a) ?>',2);"><div id="elh_packing_list_no_sqm_a" class="packing_list_no_sqm_a">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_no->sqm_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_no->sqm_a->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_no->sqm_a->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$packing_list_no_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($packing_list_no->ExportAll && $packing_list_no->isExport()) {
	$packing_list_no_list->StopRec = $packing_list_no_list->TotalRecs;
} else {

	// Set the last record to display
	if ($packing_list_no_list->TotalRecs > $packing_list_no_list->StartRec + $packing_list_no_list->DisplayRecs - 1)
		$packing_list_no_list->StopRec = $packing_list_no_list->StartRec + $packing_list_no_list->DisplayRecs - 1;
	else
		$packing_list_no_list->StopRec = $packing_list_no_list->TotalRecs;
}

// Restore number of post back records
if ($CurrentForm && $packing_list_no_list->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($packing_list_no_list->FormKeyCountName) && ($packing_list_no->isGridAdd() || $packing_list_no->isGridEdit() || $packing_list_no->isConfirm())) {
		$packing_list_no_list->KeyCount = $CurrentForm->getValue($packing_list_no_list->FormKeyCountName);
		$packing_list_no_list->StopRec = $packing_list_no_list->StartRec + $packing_list_no_list->KeyCount - 1;
	}
}
$packing_list_no_list->RecCnt = $packing_list_no_list->StartRec - 1;
if ($packing_list_no_list->Recordset && !$packing_list_no_list->Recordset->EOF) {
	$packing_list_no_list->Recordset->moveFirst();
	$selectLimit = $packing_list_no_list->UseSelectLimit;
	if (!$selectLimit && $packing_list_no_list->StartRec > 1)
		$packing_list_no_list->Recordset->move($packing_list_no_list->StartRec - 1);
} elseif (!$packing_list_no->AllowAddDeleteRow && $packing_list_no_list->StopRec == 0) {
	$packing_list_no_list->StopRec = $packing_list_no->GridAddRowCount;
}

// Initialize aggregate
$packing_list_no->RowType = ROWTYPE_AGGREGATEINIT;
$packing_list_no->resetAttributes();
$packing_list_no_list->renderRow();
if ($packing_list_no->isGridEdit())
	$packing_list_no_list->RowIndex = 0;
while ($packing_list_no_list->RecCnt < $packing_list_no_list->StopRec) {
	$packing_list_no_list->RecCnt++;
	if ($packing_list_no_list->RecCnt >= $packing_list_no_list->StartRec) {
		$packing_list_no_list->RowCnt++;
		if ($packing_list_no->isGridAdd() || $packing_list_no->isGridEdit() || $packing_list_no->isConfirm()) {
			$packing_list_no_list->RowIndex++;
			$CurrentForm->Index = $packing_list_no_list->RowIndex;
			if ($CurrentForm->hasValue($packing_list_no_list->FormActionName) && $packing_list_no_list->EventCancelled)
				$packing_list_no_list->RowAction = strval($CurrentForm->getValue($packing_list_no_list->FormActionName));
			elseif ($packing_list_no->isGridAdd())
				$packing_list_no_list->RowAction = "insert";
			else
				$packing_list_no_list->RowAction = "";
		}

		// Set up key count
		$packing_list_no_list->KeyCount = $packing_list_no_list->RowIndex;

		// Init row class and style
		$packing_list_no->resetAttributes();
		$packing_list_no->CssClass = "";
		if ($packing_list_no->isGridAdd()) {
			$packing_list_no_list->loadRowValues(); // Load default values
		} else {
			$packing_list_no_list->loadRowValues($packing_list_no_list->Recordset); // Load row values
		}
		$packing_list_no->RowType = ROWTYPE_VIEW; // Render view
		if ($packing_list_no->isGridEdit()) { // Grid edit
			if ($packing_list_no->EventCancelled)
				$packing_list_no_list->restoreCurrentRowFormValues($packing_list_no_list->RowIndex); // Restore form values
			if ($packing_list_no_list->RowAction == "insert")
				$packing_list_no->RowType = ROWTYPE_ADD; // Render add
			else
				$packing_list_no->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($packing_list_no->isGridEdit() && ($packing_list_no->RowType == ROWTYPE_EDIT || $packing_list_no->RowType == ROWTYPE_ADD) && $packing_list_no->EventCancelled) // Update failed
			$packing_list_no_list->restoreCurrentRowFormValues($packing_list_no_list->RowIndex); // Restore form values
		if ($packing_list_no->RowType == ROWTYPE_EDIT) // Edit row
			$packing_list_no_list->EditRowCnt++;

		// Set up row id / data-rowindex
		$packing_list_no->RowAttrs = array_merge($packing_list_no->RowAttrs, array('data-rowindex'=>$packing_list_no_list->RowCnt, 'id'=>'r' . $packing_list_no_list->RowCnt . '_packing_list_no', 'data-rowtype'=>$packing_list_no->RowType));

		// Render row
		$packing_list_no_list->renderRow();

		// Render list options
		$packing_list_no_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($packing_list_no_list->RowAction <> "delete" && $packing_list_no_list->RowAction <> "insertdelete" && !($packing_list_no_list->RowAction == "insert" && $packing_list_no->isConfirm() && $packing_list_no_list->emptyRow())) {
?>
	<tr<?php echo $packing_list_no->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_list_no_list->ListOptions->render("body", "left", $packing_list_no_list->RowCnt);
?>
	<?php if ($packing_list_no->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po"<?php echo $packing_list_no->buyer_po->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_buyer_po" class="form-group packing_list_no_buyer_po">
<input type="text" data-table="packing_list_no" data-field="x_buyer_po" name="x<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" id="x<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_no->buyer_po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->buyer_po->EditValue ?>"<?php echo $packing_list_no->buyer_po->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_buyer_po" name="o<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" id="o<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" value="<?php echo HtmlEncode($packing_list_no->buyer_po->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_buyer_po" class="form-group packing_list_no_buyer_po">
<span<?php echo $packing_list_no->buyer_po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->buyer_po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_buyer_po" name="x<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" id="x<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" value="<?php echo HtmlEncode($packing_list_no->buyer_po->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_buyer_po" class="packing_list_no_buyer_po">
<span<?php echo $packing_list_no->buyer_po->viewAttributes() ?>>
<?php echo $packing_list_no->buyer_po->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no"<?php echo $packing_list_no->roll_no->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_roll_no" class="form-group packing_list_no_roll_no">
<input type="text" data-table="packing_list_no" data-field="x_roll_no" name="x<?php echo $packing_list_no_list->RowIndex ?>_roll_no" id="x<?php echo $packing_list_no_list->RowIndex ?>_roll_no" size="10" placeholder="<?php echo HtmlEncode($packing_list_no->roll_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->roll_no->EditValue ?>"<?php echo $packing_list_no->roll_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_roll_no" name="o<?php echo $packing_list_no_list->RowIndex ?>_roll_no" id="o<?php echo $packing_list_no_list->RowIndex ?>_roll_no" value="<?php echo HtmlEncode($packing_list_no->roll_no->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_roll_no" class="form-group packing_list_no_roll_no">
<input type="text" data-table="packing_list_no" data-field="x_roll_no" name="x<?php echo $packing_list_no_list->RowIndex ?>_roll_no" id="x<?php echo $packing_list_no_list->RowIndex ?>_roll_no" size="10" placeholder="<?php echo HtmlEncode($packing_list_no->roll_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->roll_no->EditValue ?>"<?php echo $packing_list_no->roll_no->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_roll_no" class="packing_list_no_roll_no">
<span<?php echo $packing_list_no->roll_no->viewAttributes() ?>>
<?php echo $packing_list_no->roll_no->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $packing_list_no->qty->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_qty" class="form-group packing_list_no_qty">
<input type="text" data-table="packing_list_no" data-field="x_qty" name="x<?php echo $packing_list_no_list->RowIndex ?>_qty" id="x<?php echo $packing_list_no_list->RowIndex ?>_qty" size="10" placeholder="<?php echo HtmlEncode($packing_list_no->qty->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->qty->EditValue ?>"<?php echo $packing_list_no->qty->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_qty" name="o<?php echo $packing_list_no_list->RowIndex ?>_qty" id="o<?php echo $packing_list_no_list->RowIndex ?>_qty" value="<?php echo HtmlEncode($packing_list_no->qty->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_qty" class="form-group packing_list_no_qty">
<input type="text" data-table="packing_list_no" data-field="x_qty" name="x<?php echo $packing_list_no_list->RowIndex ?>_qty" id="x<?php echo $packing_list_no_list->RowIndex ?>_qty" size="10" placeholder="<?php echo HtmlEncode($packing_list_no->qty->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->qty->EditValue ?>"<?php echo $packing_list_no->qty->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_qty" class="packing_list_no_qty">
<span<?php echo $packing_list_no->qty->viewAttributes() ?>>
<?php echo $packing_list_no->qty->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $packing_list_no->pl_no->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_pl_no" class="form-group packing_list_no_pl_no">
<input type="text" data-table="packing_list_no" data-field="x_pl_no" name="x<?php echo $packing_list_no_list->RowIndex ?>_pl_no" id="x<?php echo $packing_list_no_list->RowIndex ?>_pl_no" size="15" placeholder="<?php echo HtmlEncode($packing_list_no->pl_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->pl_no->EditValue ?>"<?php echo $packing_list_no->pl_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_pl_no" name="o<?php echo $packing_list_no_list->RowIndex ?>_pl_no" id="o<?php echo $packing_list_no_list->RowIndex ?>_pl_no" value="<?php echo HtmlEncode($packing_list_no->pl_no->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_pl_no" class="form-group packing_list_no_pl_no">
<input type="text" data-table="packing_list_no" data-field="x_pl_no" name="x<?php echo $packing_list_no_list->RowIndex ?>_pl_no" id="x<?php echo $packing_list_no_list->RowIndex ?>_pl_no" size="15" placeholder="<?php echo HtmlEncode($packing_list_no->pl_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->pl_no->EditValue ?>"<?php echo $packing_list_no->pl_no->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_pl_no" class="packing_list_no_pl_no">
<span<?php echo $packing_list_no->pl_no->viewAttributes() ?>>
<?php echo $packing_list_no->pl_no->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $packing_list_no->_barcode->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no__barcode" class="form-group packing_list_no__barcode">
<input type="text" data-table="packing_list_no" data-field="x__barcode" name="x<?php echo $packing_list_no_list->RowIndex ?>__barcode" id="x<?php echo $packing_list_no_list->RowIndex ?>__barcode" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->_barcode->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->_barcode->EditValue ?>"<?php echo $packing_list_no->_barcode->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x__barcode" name="o<?php echo $packing_list_no_list->RowIndex ?>__barcode" id="o<?php echo $packing_list_no_list->RowIndex ?>__barcode" value="<?php echo HtmlEncode($packing_list_no->_barcode->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no__barcode" class="form-group packing_list_no__barcode">
<span<?php echo $packing_list_no->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x__barcode" name="x<?php echo $packing_list_no_list->RowIndex ?>__barcode" id="x<?php echo $packing_list_no_list->RowIndex ?>__barcode" value="<?php echo HtmlEncode($packing_list_no->_barcode->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no__barcode" class="packing_list_no__barcode">
<span<?php echo $packing_list_no->_barcode->viewAttributes() ?>>
<?php echo $packing_list_no->_barcode->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $packing_list_no->design_id->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_design_id" class="form-group packing_list_no_design_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_design_id" data-value-separator="<?php echo $packing_list_no->design_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $packing_list_no_list->RowIndex ?>_design_id" name="x<?php echo $packing_list_no_list->RowIndex ?>_design_id"<?php echo $packing_list_no->design_id->editAttributes() ?>>
		<?php echo $packing_list_no->design_id->selectOptionListHtml("x<?php echo $packing_list_no_list->RowIndex ?>_design_id") ?>
	</select>
</div>
<?php echo $packing_list_no->design_id->Lookup->getParamTag("p_x" . $packing_list_no_list->RowIndex . "_design_id") ?>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_design_id" name="o<?php echo $packing_list_no_list->RowIndex ?>_design_id" id="o<?php echo $packing_list_no_list->RowIndex ?>_design_id" value="<?php echo HtmlEncode($packing_list_no->design_id->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_design_id" class="form-group packing_list_no_design_id">
<span<?php echo $packing_list_no->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list_no->design_id->EditValue)) && $packing_list_no->design_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list_no->design_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->design_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->design_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_design_id" name="x<?php echo $packing_list_no_list->RowIndex ?>_design_id" id="x<?php echo $packing_list_no_list->RowIndex ?>_design_id" value="<?php echo HtmlEncode($packing_list_no->design_id->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_design_id" class="packing_list_no_design_id">
<span<?php echo $packing_list_no->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list_no->design_id->getViewValue())) && $packing_list_no->design_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list_no->design_id->linkAttributes() ?>><?php echo $packing_list_no->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list_no->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer"<?php echo $packing_list_no->size_buyer->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_size_buyer" class="form-group packing_list_no_size_buyer">
<input type="text" data-table="packing_list_no" data-field="x_size_buyer" name="x<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" id="x<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_no->size_buyer->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->size_buyer->EditValue ?>"<?php echo $packing_list_no->size_buyer->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_size_buyer" name="o<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" id="o<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" value="<?php echo HtmlEncode($packing_list_no->size_buyer->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_size_buyer" class="form-group packing_list_no_size_buyer">
<span<?php echo $packing_list_no->size_buyer->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->size_buyer->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_size_buyer" name="x<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" id="x<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" value="<?php echo HtmlEncode($packing_list_no->size_buyer->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_size_buyer" class="packing_list_no_size_buyer">
<span<?php echo $packing_list_no->size_buyer->viewAttributes() ?>>
<?php echo $packing_list_no->size_buyer->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $packing_list_no->buyers_id->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_buyers_id" class="form-group packing_list_no_buyers_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_buyers_id" data-value-separator="<?php echo $packing_list_no->buyers_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $packing_list_no_list->RowIndex ?>_buyers_id" name="x<?php echo $packing_list_no_list->RowIndex ?>_buyers_id"<?php echo $packing_list_no->buyers_id->editAttributes() ?>>
		<?php echo $packing_list_no->buyers_id->selectOptionListHtml("x<?php echo $packing_list_no_list->RowIndex ?>_buyers_id") ?>
	</select>
</div>
<?php echo $packing_list_no->buyers_id->Lookup->getParamTag("p_x" . $packing_list_no_list->RowIndex . "_buyers_id") ?>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_buyers_id" name="o<?php echo $packing_list_no_list->RowIndex ?>_buyers_id" id="o<?php echo $packing_list_no_list->RowIndex ?>_buyers_id" value="<?php echo HtmlEncode($packing_list_no->buyers_id->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_buyers_id" class="form-group packing_list_no_buyers_id">
<span<?php echo $packing_list_no->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list_no->buyers_id->EditValue)) && $packing_list_no->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list_no->buyers_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->buyers_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->buyers_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_buyers_id" name="x<?php echo $packing_list_no_list->RowIndex ?>_buyers_id" id="x<?php echo $packing_list_no_list->RowIndex ?>_buyers_id" value="<?php echo HtmlEncode($packing_list_no->buyers_id->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_buyers_id" class="packing_list_no_buyers_id">
<span<?php echo $packing_list_no->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list_no->buyers_id->getViewValue())) && $packing_list_no->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list_no->buyers_id->linkAttributes() ?>><?php echo $packing_list_no->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list_no->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->po->Visible) { // po ?>
		<td data-name="po"<?php echo $packing_list_no->po->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_po" class="form-group packing_list_no_po">
<input type="text" data-table="packing_list_no" data-field="x_po" name="x<?php echo $packing_list_no_list->RowIndex ?>_po" id="x<?php echo $packing_list_no_list->RowIndex ?>_po" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->po->EditValue ?>"<?php echo $packing_list_no->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_po" name="o<?php echo $packing_list_no_list->RowIndex ?>_po" id="o<?php echo $packing_list_no_list->RowIndex ?>_po" value="<?php echo HtmlEncode($packing_list_no->po->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_po" class="form-group packing_list_no_po">
<span<?php echo $packing_list_no->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_po" name="x<?php echo $packing_list_no_list->RowIndex ?>_po" id="x<?php echo $packing_list_no_list->RowIndex ?>_po" value="<?php echo HtmlEncode($packing_list_no->po->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_po" class="packing_list_no_po">
<span<?php echo $packing_list_no->po->viewAttributes() ?>>
<?php echo $packing_list_no->po->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $packing_list_no->sqm->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_sqm" class="form-group packing_list_no_sqm">
<input type="text" data-table="packing_list_no" data-field="x_sqm" name="x<?php echo $packing_list_no_list->RowIndex ?>_sqm" id="x<?php echo $packing_list_no_list->RowIndex ?>_sqm" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->sqm->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->sqm->EditValue ?>"<?php echo $packing_list_no->sqm->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_sqm" name="o<?php echo $packing_list_no_list->RowIndex ?>_sqm" id="o<?php echo $packing_list_no_list->RowIndex ?>_sqm" value="<?php echo HtmlEncode($packing_list_no->sqm->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_sqm" class="form-group packing_list_no_sqm">
<span<?php echo $packing_list_no->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_sqm" name="x<?php echo $packing_list_no_list->RowIndex ?>_sqm" id="x<?php echo $packing_list_no_list->RowIndex ?>_sqm" value="<?php echo HtmlEncode($packing_list_no->sqm->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_sqm" class="packing_list_no_sqm">
<span<?php echo $packing_list_no->sqm->viewAttributes() ?>>
<?php echo $packing_list_no->sqm->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $packing_list_no->current_works->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_current_works" class="form-group packing_list_no_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_current_works" data-value-separator="<?php echo $packing_list_no->current_works->displayValueSeparatorAttribute() ?>" id="x<?php echo $packing_list_no_list->RowIndex ?>_current_works" name="x<?php echo $packing_list_no_list->RowIndex ?>_current_works"<?php echo $packing_list_no->current_works->editAttributes() ?>>
		<?php echo $packing_list_no->current_works->selectOptionListHtml("x<?php echo $packing_list_no_list->RowIndex ?>_current_works") ?>
	</select>
</div>
<?php echo $packing_list_no->current_works->Lookup->getParamTag("p_x" . $packing_list_no_list->RowIndex . "_current_works") ?>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_current_works" name="o<?php echo $packing_list_no_list->RowIndex ?>_current_works" id="o<?php echo $packing_list_no_list->RowIndex ?>_current_works" value="<?php echo HtmlEncode($packing_list_no->current_works->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_current_works" class="form-group packing_list_no_current_works">
<span<?php echo $packing_list_no->current_works->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->current_works->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_current_works" name="x<?php echo $packing_list_no_list->RowIndex ?>_current_works" id="x<?php echo $packing_list_no_list->RowIndex ?>_current_works" value="<?php echo HtmlEncode($packing_list_no->current_works->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_current_works" class="packing_list_no_current_works">
<span<?php echo $packing_list_no->current_works->viewAttributes() ?>>
<?php echo $packing_list_no->current_works->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->id->Visible) { // id ?>
		<td data-name="id"<?php echo $packing_list_no->id->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="packing_list_no" data-field="x_id" name="o<?php echo $packing_list_no_list->RowIndex ?>_id" id="o<?php echo $packing_list_no_list->RowIndex ?>_id" value="<?php echo HtmlEncode($packing_list_no->id->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_id" class="form-group packing_list_no_id">
<span<?php echo $packing_list_no->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_id" name="x<?php echo $packing_list_no_list->RowIndex ?>_id" id="x<?php echo $packing_list_no_list->RowIndex ?>_id" value="<?php echo HtmlEncode($packing_list_no->id->CurrentValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_id" class="packing_list_no_id">
<span<?php echo $packing_list_no->id->viewAttributes() ?>>
<?php echo $packing_list_no->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($packing_list_no->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a"<?php echo $packing_list_no->sqm_a->cellAttributes() ?>>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_sqm_a" class="form-group packing_list_no_sqm_a">
<input type="text" data-table="packing_list_no" data-field="x_sqm_a" name="x<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" id="x<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->sqm_a->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->sqm_a->EditValue ?>"<?php echo $packing_list_no->sqm_a->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_sqm_a" name="o<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" id="o<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" value="<?php echo HtmlEncode($packing_list_no->sqm_a->OldValue) ?>">
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_sqm_a" class="form-group packing_list_no_sqm_a">
<input type="text" data-table="packing_list_no" data-field="x_sqm_a" name="x<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" id="x<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->sqm_a->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->sqm_a->EditValue ?>"<?php echo $packing_list_no->sqm_a->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($packing_list_no->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $packing_list_no_list->RowCnt ?>_packing_list_no_sqm_a" class="packing_list_no_sqm_a">
<span<?php echo $packing_list_no->sqm_a->viewAttributes() ?>>
<?php echo $packing_list_no->sqm_a->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_list_no_list->ListOptions->render("body", "right", $packing_list_no_list->RowCnt);
?>
	</tr>
<?php if ($packing_list_no->RowType == ROWTYPE_ADD || $packing_list_no->RowType == ROWTYPE_EDIT) { ?>
<script>
fpacking_list_nolist.updateLists(<?php echo $packing_list_no_list->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$packing_list_no->isGridAdd())
		if (!$packing_list_no_list->Recordset->EOF)
			$packing_list_no_list->Recordset->moveNext();
}
?>
<?php
	if ($packing_list_no->isGridAdd() || $packing_list_no->isGridEdit()) {
		$packing_list_no_list->RowIndex = '$rowindex$';
		$packing_list_no_list->loadRowValues();

		// Set row properties
		$packing_list_no->resetAttributes();
		$packing_list_no->RowAttrs = array_merge($packing_list_no->RowAttrs, array('data-rowindex'=>$packing_list_no_list->RowIndex, 'id'=>'r0_packing_list_no', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($packing_list_no->RowAttrs["class"], "ew-template");
		$packing_list_no->RowType = ROWTYPE_ADD;

		// Render row
		$packing_list_no_list->renderRow();

		// Render list options
		$packing_list_no_list->renderListOptions();
		$packing_list_no_list->StartRowCnt = 0;
?>
	<tr<?php echo $packing_list_no->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_list_no_list->ListOptions->render("body", "left", $packing_list_no_list->RowIndex);
?>
	<?php if ($packing_list_no->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po">
<span id="el$rowindex$_packing_list_no_buyer_po" class="form-group packing_list_no_buyer_po">
<input type="text" data-table="packing_list_no" data-field="x_buyer_po" name="x<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" id="x<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_no->buyer_po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->buyer_po->EditValue ?>"<?php echo $packing_list_no->buyer_po->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_buyer_po" name="o<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" id="o<?php echo $packing_list_no_list->RowIndex ?>_buyer_po" value="<?php echo HtmlEncode($packing_list_no->buyer_po->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no">
<span id="el$rowindex$_packing_list_no_roll_no" class="form-group packing_list_no_roll_no">
<input type="text" data-table="packing_list_no" data-field="x_roll_no" name="x<?php echo $packing_list_no_list->RowIndex ?>_roll_no" id="x<?php echo $packing_list_no_list->RowIndex ?>_roll_no" size="10" placeholder="<?php echo HtmlEncode($packing_list_no->roll_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->roll_no->EditValue ?>"<?php echo $packing_list_no->roll_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_roll_no" name="o<?php echo $packing_list_no_list->RowIndex ?>_roll_no" id="o<?php echo $packing_list_no_list->RowIndex ?>_roll_no" value="<?php echo HtmlEncode($packing_list_no->roll_no->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->qty->Visible) { // qty ?>
		<td data-name="qty">
<span id="el$rowindex$_packing_list_no_qty" class="form-group packing_list_no_qty">
<input type="text" data-table="packing_list_no" data-field="x_qty" name="x<?php echo $packing_list_no_list->RowIndex ?>_qty" id="x<?php echo $packing_list_no_list->RowIndex ?>_qty" size="10" placeholder="<?php echo HtmlEncode($packing_list_no->qty->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->qty->EditValue ?>"<?php echo $packing_list_no->qty->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_qty" name="o<?php echo $packing_list_no_list->RowIndex ?>_qty" id="o<?php echo $packing_list_no_list->RowIndex ?>_qty" value="<?php echo HtmlEncode($packing_list_no->qty->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no">
<span id="el$rowindex$_packing_list_no_pl_no" class="form-group packing_list_no_pl_no">
<input type="text" data-table="packing_list_no" data-field="x_pl_no" name="x<?php echo $packing_list_no_list->RowIndex ?>_pl_no" id="x<?php echo $packing_list_no_list->RowIndex ?>_pl_no" size="15" placeholder="<?php echo HtmlEncode($packing_list_no->pl_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->pl_no->EditValue ?>"<?php echo $packing_list_no->pl_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_pl_no" name="o<?php echo $packing_list_no_list->RowIndex ?>_pl_no" id="o<?php echo $packing_list_no_list->RowIndex ?>_pl_no" value="<?php echo HtmlEncode($packing_list_no->pl_no->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode">
<span id="el$rowindex$_packing_list_no__barcode" class="form-group packing_list_no__barcode">
<input type="text" data-table="packing_list_no" data-field="x__barcode" name="x<?php echo $packing_list_no_list->RowIndex ?>__barcode" id="x<?php echo $packing_list_no_list->RowIndex ?>__barcode" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->_barcode->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->_barcode->EditValue ?>"<?php echo $packing_list_no->_barcode->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x__barcode" name="o<?php echo $packing_list_no_list->RowIndex ?>__barcode" id="o<?php echo $packing_list_no_list->RowIndex ?>__barcode" value="<?php echo HtmlEncode($packing_list_no->_barcode->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->design_id->Visible) { // design_id ?>
		<td data-name="design_id">
<span id="el$rowindex$_packing_list_no_design_id" class="form-group packing_list_no_design_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_design_id" data-value-separator="<?php echo $packing_list_no->design_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $packing_list_no_list->RowIndex ?>_design_id" name="x<?php echo $packing_list_no_list->RowIndex ?>_design_id"<?php echo $packing_list_no->design_id->editAttributes() ?>>
		<?php echo $packing_list_no->design_id->selectOptionListHtml("x<?php echo $packing_list_no_list->RowIndex ?>_design_id") ?>
	</select>
</div>
<?php echo $packing_list_no->design_id->Lookup->getParamTag("p_x" . $packing_list_no_list->RowIndex . "_design_id") ?>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_design_id" name="o<?php echo $packing_list_no_list->RowIndex ?>_design_id" id="o<?php echo $packing_list_no_list->RowIndex ?>_design_id" value="<?php echo HtmlEncode($packing_list_no->design_id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer">
<span id="el$rowindex$_packing_list_no_size_buyer" class="form-group packing_list_no_size_buyer">
<input type="text" data-table="packing_list_no" data-field="x_size_buyer" name="x<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" id="x<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_no->size_buyer->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->size_buyer->EditValue ?>"<?php echo $packing_list_no->size_buyer->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_size_buyer" name="o<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" id="o<?php echo $packing_list_no_list->RowIndex ?>_size_buyer" value="<?php echo HtmlEncode($packing_list_no->size_buyer->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id">
<span id="el$rowindex$_packing_list_no_buyers_id" class="form-group packing_list_no_buyers_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_buyers_id" data-value-separator="<?php echo $packing_list_no->buyers_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $packing_list_no_list->RowIndex ?>_buyers_id" name="x<?php echo $packing_list_no_list->RowIndex ?>_buyers_id"<?php echo $packing_list_no->buyers_id->editAttributes() ?>>
		<?php echo $packing_list_no->buyers_id->selectOptionListHtml("x<?php echo $packing_list_no_list->RowIndex ?>_buyers_id") ?>
	</select>
</div>
<?php echo $packing_list_no->buyers_id->Lookup->getParamTag("p_x" . $packing_list_no_list->RowIndex . "_buyers_id") ?>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_buyers_id" name="o<?php echo $packing_list_no_list->RowIndex ?>_buyers_id" id="o<?php echo $packing_list_no_list->RowIndex ?>_buyers_id" value="<?php echo HtmlEncode($packing_list_no->buyers_id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->po->Visible) { // po ?>
		<td data-name="po">
<span id="el$rowindex$_packing_list_no_po" class="form-group packing_list_no_po">
<input type="text" data-table="packing_list_no" data-field="x_po" name="x<?php echo $packing_list_no_list->RowIndex ?>_po" id="x<?php echo $packing_list_no_list->RowIndex ?>_po" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->po->EditValue ?>"<?php echo $packing_list_no->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_po" name="o<?php echo $packing_list_no_list->RowIndex ?>_po" id="o<?php echo $packing_list_no_list->RowIndex ?>_po" value="<?php echo HtmlEncode($packing_list_no->po->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->sqm->Visible) { // sqm ?>
		<td data-name="sqm">
<span id="el$rowindex$_packing_list_no_sqm" class="form-group packing_list_no_sqm">
<input type="text" data-table="packing_list_no" data-field="x_sqm" name="x<?php echo $packing_list_no_list->RowIndex ?>_sqm" id="x<?php echo $packing_list_no_list->RowIndex ?>_sqm" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->sqm->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->sqm->EditValue ?>"<?php echo $packing_list_no->sqm->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_sqm" name="o<?php echo $packing_list_no_list->RowIndex ?>_sqm" id="o<?php echo $packing_list_no_list->RowIndex ?>_sqm" value="<?php echo HtmlEncode($packing_list_no->sqm->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->current_works->Visible) { // current_works ?>
		<td data-name="current_works">
<span id="el$rowindex$_packing_list_no_current_works" class="form-group packing_list_no_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_current_works" data-value-separator="<?php echo $packing_list_no->current_works->displayValueSeparatorAttribute() ?>" id="x<?php echo $packing_list_no_list->RowIndex ?>_current_works" name="x<?php echo $packing_list_no_list->RowIndex ?>_current_works"<?php echo $packing_list_no->current_works->editAttributes() ?>>
		<?php echo $packing_list_no->current_works->selectOptionListHtml("x<?php echo $packing_list_no_list->RowIndex ?>_current_works") ?>
	</select>
</div>
<?php echo $packing_list_no->current_works->Lookup->getParamTag("p_x" . $packing_list_no_list->RowIndex . "_current_works") ?>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_current_works" name="o<?php echo $packing_list_no_list->RowIndex ?>_current_works" id="o<?php echo $packing_list_no_list->RowIndex ?>_current_works" value="<?php echo HtmlEncode($packing_list_no->current_works->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->id->Visible) { // id ?>
		<td data-name="id">
<input type="hidden" data-table="packing_list_no" data-field="x_id" name="o<?php echo $packing_list_no_list->RowIndex ?>_id" id="o<?php echo $packing_list_no_list->RowIndex ?>_id" value="<?php echo HtmlEncode($packing_list_no->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($packing_list_no->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a">
<span id="el$rowindex$_packing_list_no_sqm_a" class="form-group packing_list_no_sqm_a">
<input type="text" data-table="packing_list_no" data-field="x_sqm_a" name="x<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" id="x<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->sqm_a->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->sqm_a->EditValue ?>"<?php echo $packing_list_no->sqm_a->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_sqm_a" name="o<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" id="o<?php echo $packing_list_no_list->RowIndex ?>_sqm_a" value="<?php echo HtmlEncode($packing_list_no->sqm_a->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_list_no_list->ListOptions->render("body", "right", $packing_list_no_list->RowIndex);
?>
<script>
fpacking_list_nolist.updateLists(<?php echo $packing_list_no_list->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
<?php

// Render aggregate row
$packing_list_no->RowType = ROWTYPE_AGGREGATE;
$packing_list_no->resetAttributes();
$packing_list_no_list->renderRow();
?>
<?php if ($packing_list_no_list->TotalRecs > 0 && !$packing_list_no->isGridAdd() && !$packing_list_no->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$packing_list_no_list->renderListOptions();

// Render list options (footer, left)
$packing_list_no_list->ListOptions->render("footer", "left");
?>
	<?php if ($packing_list_no->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po" class="<?php echo $packing_list_no->buyer_po->footerCellClass() ?>"><span id="elf_packing_list_no_buyer_po" class="packing_list_no_buyer_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no" class="<?php echo $packing_list_no->roll_no->footerCellClass() ?>"><span id="elf_packing_list_no_roll_no" class="packing_list_no_roll_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->qty->Visible) { // qty ?>
		<td data-name="qty" class="<?php echo $packing_list_no->qty->footerCellClass() ?>"><span id="elf_packing_list_no_qty" class="packing_list_no_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no" class="<?php echo $packing_list_no->pl_no->footerCellClass() ?>"><span id="elf_packing_list_no_pl_no" class="packing_list_no_pl_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $packing_list_no->_barcode->footerCellClass() ?>"><span id="elf_packing_list_no__barcode" class="packing_list_no__barcode">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list_no->_barcode->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->design_id->Visible) { // design_id ?>
		<td data-name="design_id" class="<?php echo $packing_list_no->design_id->footerCellClass() ?>"><span id="elf_packing_list_no_design_id" class="packing_list_no_design_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer" class="<?php echo $packing_list_no->size_buyer->footerCellClass() ?>"><span id="elf_packing_list_no_size_buyer" class="packing_list_no_size_buyer">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $packing_list_no->buyers_id->footerCellClass() ?>"><span id="elf_packing_list_no_buyers_id" class="packing_list_no_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $packing_list_no->po->footerCellClass() ?>"><span id="elf_packing_list_no_po" class="packing_list_no_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $packing_list_no->sqm->footerCellClass() ?>"><span id="elf_packing_list_no_sqm" class="packing_list_no_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list_no->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->current_works->Visible) { // current_works ?>
		<td data-name="current_works" class="<?php echo $packing_list_no->current_works->footerCellClass() ?>"><span id="elf_packing_list_no_current_works" class="packing_list_no_current_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $packing_list_no->id->footerCellClass() ?>"><span id="elf_packing_list_no_id" class="packing_list_no_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_no->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a" class="<?php echo $packing_list_no->sqm_a->footerCellClass() ?>"><span id="elf_packing_list_no_sqm_a" class="packing_list_no_sqm_a">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$packing_list_no_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($packing_list_no->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $packing_list_no_list->FormKeyCountName ?>" id="<?php echo $packing_list_no_list->FormKeyCountName ?>" value="<?php echo $packing_list_no_list->KeyCount ?>">
<?php echo $packing_list_no_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$packing_list_no->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($packing_list_no_list->Recordset)
	$packing_list_no_list->Recordset->Close();
?>
<?php if (!$packing_list_no->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$packing_list_no->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_list_no_list->Pager)) $packing_list_no_list->Pager = new PrevNextPager($packing_list_no_list->StartRec, $packing_list_no_list->DisplayRecs, $packing_list_no_list->TotalRecs, $packing_list_no_list->AutoHidePager) ?>
<?php if ($packing_list_no_list->Pager->RecordCount > 0 && $packing_list_no_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_list_no_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_list_no_list->pageUrl() ?>start=<?php echo $packing_list_no_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_list_no_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_list_no_list->pageUrl() ?>start=<?php echo $packing_list_no_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_list_no_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_list_no_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_list_no_list->pageUrl() ?>start=<?php echo $packing_list_no_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_list_no_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_list_no_list->pageUrl() ?>start=<?php echo $packing_list_no_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_list_no_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_list_no_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_list_no_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_list_no_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_list_no_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_list_no_list->TotalRecs > 0 && (!$packing_list_no_list->AutoHidePageSizeSelector || $packing_list_no_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_list_no">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($packing_list_no_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_list_no_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_list_no_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_list_no_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($packing_list_no_list->TotalRecs == 0 && !$packing_list_no->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $packing_list_no_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$packing_list_no_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_list_no->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$packing_list_no->isExport()) { ?>
<script>
ew.scrollableTable("gmp_packing_list_no", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_list_no_list->terminate();
?>