<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_list_no_search = new packing_list_no_search();

// Run the page
$packing_list_no_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_list_no_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($packing_list_no_search->IsModal) { ?>
var fpacking_list_nosearch = currentAdvancedSearchForm = new ew.Form("fpacking_list_nosearch", "search");
<?php } else { ?>
var fpacking_list_nosearch = currentForm = new ew.Form("fpacking_list_nosearch", "search");
<?php } ?>

// Form_CustomValidate event
fpacking_list_nosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_list_nosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_list_nosearch.lists["x_design_id"] = <?php echo $packing_list_no_search->design_id->Lookup->toClientList() ?>;
fpacking_list_nosearch.lists["x_design_id"].options = <?php echo JsonEncode($packing_list_no_search->design_id->lookupOptions()) ?>;
fpacking_list_nosearch.lists["x_buyers_id"] = <?php echo $packing_list_no_search->buyers_id->Lookup->toClientList() ?>;
fpacking_list_nosearch.lists["x_buyers_id"].options = <?php echo JsonEncode($packing_list_no_search->buyers_id->lookupOptions()) ?>;
fpacking_list_nosearch.lists["x_despatch_week"] = <?php echo $packing_list_no_search->despatch_week->Lookup->toClientList() ?>;
fpacking_list_nosearch.lists["x_despatch_week"].options = <?php echo JsonEncode($packing_list_no_search->despatch_week->lookupOptions()) ?>;
fpacking_list_nosearch.lists["x_current_works"] = <?php echo $packing_list_no_search->current_works->Lookup->toClientList() ?>;
fpacking_list_nosearch.lists["x_current_works"].options = <?php echo JsonEncode($packing_list_no_search->current_works->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpacking_list_nosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_roll_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->roll_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->pl_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm_a");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_no->sqm_a->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_list_no_search->showPageHeader(); ?>
<?php
$packing_list_no_search->showMessage();
?>
<form name="fpacking_list_nosearch" id="fpacking_list_nosearch" class="<?php echo $packing_list_no_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_list_no_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_list_no_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_list_no">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$packing_list_no_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($packing_list_no->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label for="x_buyer_po" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_buyer_po"><?php echo $packing_list_no->buyer_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->buyer_po->cellAttributes() ?>>
			<span id="el_packing_list_no_buyer_po">
<input type="text" data-table="packing_list_no" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_no->buyer_po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->buyer_po->EditValue ?>"<?php echo $packing_list_no->buyer_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->roll_no->Visible) { // roll_no ?>
	<div id="r_roll_no" class="form-group row">
		<label for="x_roll_no" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_roll_no"><?php echo $packing_list_no->roll_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_roll_no" id="z_roll_no" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->roll_no->cellAttributes() ?>>
			<span id="el_packing_list_no_roll_no">
<input type="text" data-table="packing_list_no" data-field="x_roll_no" name="x_roll_no" id="x_roll_no" size="10" placeholder="<?php echo HtmlEncode($packing_list_no->roll_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->roll_no->EditValue ?>"<?php echo $packing_list_no->roll_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_qty"><?php echo $packing_list_no->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->qty->cellAttributes() ?>>
			<span id="el_packing_list_no_qty">
<input type="text" data-table="packing_list_no" data-field="x_qty" name="x_qty" id="x_qty" size="10" placeholder="<?php echo HtmlEncode($packing_list_no->qty->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->qty->EditValue ?>"<?php echo $packing_list_no->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_pl_no"><?php echo $packing_list_no->pl_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->pl_no->cellAttributes() ?>>
			<span id="el_packing_list_no_pl_no">
<input type="text" data-table="packing_list_no" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="15" placeholder="<?php echo HtmlEncode($packing_list_no->pl_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->pl_no->EditValue ?>"<?php echo $packing_list_no->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no__barcode"><?php echo $packing_list_no->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($packing_list_no->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_packing_list_no__barcode">
<input type="text" data-table="packing_list_no" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->_barcode->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->_barcode->EditValue ?>"<?php echo $packing_list_no->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_packing_list_no__barcode" class="btw1__barcode d-none">
<input type="text" data-table="packing_list_no" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->_barcode->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->_barcode->EditValue2 ?>"<?php echo $packing_list_no->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_buyer_ref"><?php echo $packing_list_no->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->buyer_ref->cellAttributes() ?>>
			<span id="el_packing_list_no_buyer_ref">
<input type="text" data-table="packing_list_no" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="35" placeholder="<?php echo HtmlEncode($packing_list_no->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->buyer_ref->EditValue ?>"<?php echo $packing_list_no->buyer_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_design_id"><?php echo $packing_list_no->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->design_id->cellAttributes() ?>>
			<span id="el_packing_list_no_design_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_design_id" data-value-separator="<?php echo $packing_list_no->design_id->displayValueSeparatorAttribute() ?>" id="x_design_id" name="x_design_id"<?php echo $packing_list_no->design_id->editAttributes() ?>>
		<?php echo $packing_list_no->design_id->selectOptionListHtml("x_design_id") ?>
	</select>
</div>
<?php echo $packing_list_no->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label for="x_size_buyer" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_size_buyer"><?php echo $packing_list_no->size_buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->size_buyer->cellAttributes() ?>>
			<span id="el_packing_list_no_size_buyer">
<input type="text" data-table="packing_list_no" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_no->size_buyer->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->size_buyer->EditValue ?>"<?php echo $packing_list_no->size_buyer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_buyers_id"><?php echo $packing_list_no->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->buyers_id->cellAttributes() ?>>
			<span id="el_packing_list_no_buyers_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_buyers_id" data-value-separator="<?php echo $packing_list_no->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $packing_list_no->buyers_id->editAttributes() ?>>
		<?php echo $packing_list_no->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $packing_list_no->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_po"><?php echo $packing_list_no->po->caption() ?></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($packing_list_no->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_packing_list_no_po">
<input type="text" data-table="packing_list_no" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->po->EditValue ?>"<?php echo $packing_list_no->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_packing_list_no_po" class="btw1_po d-none">
<input type="text" data-table="packing_list_no" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->po->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->po->EditValue2 ?>"<?php echo $packing_list_no->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_despatch_week"><?php echo $packing_list_no->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->despatch_week->cellAttributes() ?>>
			<span id="el_packing_list_no_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_despatch_week" data-value-separator="<?php echo $packing_list_no->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $packing_list_no->despatch_week->editAttributes() ?>>
		<?php echo $packing_list_no->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $packing_list_no->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_sqm"><?php echo $packing_list_no->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->sqm->cellAttributes() ?>>
			<span id="el_packing_list_no_sqm">
<input type="text" data-table="packing_list_no" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->sqm->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->sqm->EditValue ?>"<?php echo $packing_list_no->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label for="x_current_works" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_current_works"><?php echo $packing_list_no->current_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->current_works->cellAttributes() ?>>
			<span id="el_packing_list_no_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_no" data-field="x_current_works" data-value-separator="<?php echo $packing_list_no->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $packing_list_no->current_works->editAttributes() ?>>
		<?php echo $packing_list_no->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $packing_list_no->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_id"><?php echo $packing_list_no->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->id->cellAttributes() ?>>
			<span id="el_packing_list_no_id">
<input type="text" data-table="packing_list_no" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($packing_list_no->id->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->id->EditValue ?>"<?php echo $packing_list_no->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_operator"><?php echo $packing_list_no->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->operator->cellAttributes() ?>>
			<span id="el_packing_list_no_operator">
<input type="text" data-table="packing_list_no" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->operator->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->operator->EditValue ?>"<?php echo $packing_list_no->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_datetime"><?php echo $packing_list_no->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->datetime->cellAttributes() ?>>
			<span id="el_packing_list_no_datetime">
<input type="text" data-table="packing_list_no" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($packing_list_no->datetime->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->datetime->EditValue ?>"<?php echo $packing_list_no->datetime->editAttributes() ?>>
<?php if (!$packing_list_no->datetime->ReadOnly && !$packing_list_no->datetime->Disabled && !isset($packing_list_no->datetime->EditAttrs["readonly"]) && !isset($packing_list_no->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpacking_list_nosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->sqm_a->Visible) { // sqm_a ?>
	<div id="r_sqm_a" class="form-group row">
		<label for="x_sqm_a" class="<?php echo $packing_list_no_search->LeftColumnClass ?>"><span id="elh_packing_list_no_sqm_a"><?php echo $packing_list_no->sqm_a->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm_a" id="z_sqm_a" value="="></span>
		</label>
		<div class="<?php echo $packing_list_no_search->RightColumnClass ?>"><div<?php echo $packing_list_no->sqm_a->cellAttributes() ?>>
			<span id="el_packing_list_no_sqm_a">
<input type="text" data-table="packing_list_no" data-field="x_sqm_a" name="x_sqm_a" id="x_sqm_a" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->sqm_a->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->sqm_a->EditValue ?>"<?php echo $packing_list_no->sqm_a->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$packing_list_no_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $packing_list_no_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$packing_list_no_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$packing_list_no_search->terminate();
?>