<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_list_no_update = new packing_list_no_update();

// Run the page
$packing_list_no_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_list_no_update->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "update";
var fpacking_list_noupdate = currentForm = new ew.Form("fpacking_list_noupdate", "update");

// Validate form
fpacking_list_noupdate.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	if (!ew.updateSelected(fobj)) {
		ew.alert(ew.language.phrase("NoFieldSelected"));
		return false;
	}
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($packing_list_no_update->pl_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pl_no");
			uelm = this.getElements("u" + infix + "_pl_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->pl_no->caption(), $packing_list_no->pl_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_pl_no");
			uelm = this.getElements("u" + infix + "_pl_no");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_list_no->pl_no->errorMessage()) ?>");
		<?php if ($packing_list_no_update->sqm_a->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm_a");
			uelm = this.getElements("u" + infix + "_sqm_a");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_list_no->sqm_a->caption(), $packing_list_no->sqm_a->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm_a");
			uelm = this.getElements("u" + infix + "_sqm_a");
			if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_list_no->sqm_a->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpacking_list_noupdate.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_list_noupdate.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_list_no_update->showPageHeader(); ?>
<?php
$packing_list_no_update->showMessage();
?>
<form name="fpacking_list_noupdate" id="fpacking_list_noupdate" class="<?php echo $packing_list_no_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_list_no_update->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_list_no_update->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_list_no">
<?php if ($packing_list_no->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$packing_list_no_update->IsModal ?>">
<?php foreach ($packing_list_no_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_packing_list_noupdate" class="ew-update-div"><!-- page -->
	<div class="form-check">
		<input type="checkbox" class="form-check-input" name="u" id="u" onclick="ew.selectAll(this);"<?php echo $packing_list_no_update->Disabled ?>><label class="form-check-label" for="u"><?php echo $Language->Phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($packing_list_no->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $packing_list_no_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$packing_list_no->isConfirm()) { ?>
<input type="checkbox" name="u_pl_no" id="u_pl_no" class="form-check-input ew-multi-select" value="1"<?php echo ($packing_list_no->pl_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_pl_no" id="u_pl_no" value="<?php echo $packing_list_no->pl_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($packing_list_no->pl_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_pl_no"><?php echo $packing_list_no->pl_no->caption() ?></label></div></label>
		<div class="<?php echo $packing_list_no_update->RightColumnClass ?>"><div<?php echo $packing_list_no->pl_no->cellAttributes() ?>>
<?php if (!$packing_list_no->isConfirm()) { ?>
<span id="el_packing_list_no_pl_no">
<input type="text" data-table="packing_list_no" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="15" placeholder="<?php echo HtmlEncode($packing_list_no->pl_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->pl_no->EditValue ?>"<?php echo $packing_list_no->pl_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_packing_list_no_pl_no">
<span<?php echo $packing_list_no->pl_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->pl_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" value="<?php echo HtmlEncode($packing_list_no->pl_no->FormValue) ?>">
<?php } ?>
<?php echo $packing_list_no->pl_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_list_no->sqm_a->Visible) { // sqm_a ?>
	<div id="r_sqm_a" class="form-group row">
		<label for="x_sqm_a" class="<?php echo $packing_list_no_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$packing_list_no->isConfirm()) { ?>
<input type="checkbox" name="u_sqm_a" id="u_sqm_a" class="form-check-input ew-multi-select" value="1"<?php echo ($packing_list_no->sqm_a->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_sqm_a" id="u_sqm_a" value="<?php echo $packing_list_no->sqm_a->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($packing_list_no->sqm_a->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_sqm_a"><?php echo $packing_list_no->sqm_a->caption() ?></label></div></label>
		<div class="<?php echo $packing_list_no_update->RightColumnClass ?>"><div<?php echo $packing_list_no->sqm_a->cellAttributes() ?>>
<?php if (!$packing_list_no->isConfirm()) { ?>
<span id="el_packing_list_no_sqm_a">
<input type="text" data-table="packing_list_no" data-field="x_sqm_a" name="x_sqm_a" id="x_sqm_a" size="30" placeholder="<?php echo HtmlEncode($packing_list_no->sqm_a->getPlaceHolder()) ?>" value="<?php echo $packing_list_no->sqm_a->EditValue ?>"<?php echo $packing_list_no->sqm_a->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_packing_list_no_sqm_a">
<span<?php echo $packing_list_no->sqm_a->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($packing_list_no->sqm_a->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="packing_list_no" data-field="x_sqm_a" name="x_sqm_a" id="x_sqm_a" value="<?php echo HtmlEncode($packing_list_no->sqm_a->FormValue) ?>">
<?php } ?>
<?php echo $packing_list_no->sqm_a->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$packing_list_no_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $packing_list_no_update->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$packing_list_no->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $packing_list_no_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$packing_list_no_update->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$packing_list_no_update->terminate();
?>