<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_list_no_view = new packing_list_no_view();

// Run the page
$packing_list_no_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_list_no_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_list_no->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpacking_list_noview = currentForm = new ew.Form("fpacking_list_noview", "view");

// Form_CustomValidate event
fpacking_list_noview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_list_noview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_list_noview.lists["x_design_id"] = <?php echo $packing_list_no_view->design_id->Lookup->toClientList() ?>;
fpacking_list_noview.lists["x_design_id"].options = <?php echo JsonEncode($packing_list_no_view->design_id->lookupOptions()) ?>;
fpacking_list_noview.lists["x_buyers_id"] = <?php echo $packing_list_no_view->buyers_id->Lookup->toClientList() ?>;
fpacking_list_noview.lists["x_buyers_id"].options = <?php echo JsonEncode($packing_list_no_view->buyers_id->lookupOptions()) ?>;
fpacking_list_noview.lists["x_despatch_week"] = <?php echo $packing_list_no_view->despatch_week->Lookup->toClientList() ?>;
fpacking_list_noview.lists["x_despatch_week"].options = <?php echo JsonEncode($packing_list_no_view->despatch_week->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_list_no->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $packing_list_no_view->ExportOptions->render("body") ?>
<?php $packing_list_no_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $packing_list_no_view->showPageHeader(); ?>
<?php
$packing_list_no_view->showMessage();
?>
<form name="fpacking_list_noview" id="fpacking_list_noview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_list_no_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_list_no_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_list_no">
<input type="hidden" name="modal" value="<?php echo (int)$packing_list_no_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($packing_list_no->buyer_po->Visible) { // buyer_po ?>
	<tr id="r_buyer_po">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_buyer_po"><?php echo $packing_list_no->buyer_po->caption() ?></span></td>
		<td data-name="buyer_po"<?php echo $packing_list_no->buyer_po->cellAttributes() ?>>
<span id="el_packing_list_no_buyer_po">
<span<?php echo $packing_list_no->buyer_po->viewAttributes() ?>>
<?php echo $packing_list_no->buyer_po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->roll_no->Visible) { // roll_no ?>
	<tr id="r_roll_no">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_roll_no"><?php echo $packing_list_no->roll_no->caption() ?></span></td>
		<td data-name="roll_no"<?php echo $packing_list_no->roll_no->cellAttributes() ?>>
<span id="el_packing_list_no_roll_no">
<span<?php echo $packing_list_no->roll_no->viewAttributes() ?>>
<?php echo $packing_list_no->roll_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->qty->Visible) { // qty ?>
	<tr id="r_qty">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_qty"><?php echo $packing_list_no->qty->caption() ?></span></td>
		<td data-name="qty"<?php echo $packing_list_no->qty->cellAttributes() ?>>
<span id="el_packing_list_no_qty">
<span<?php echo $packing_list_no->qty->viewAttributes() ?>>
<?php echo $packing_list_no->qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->pl_no->Visible) { // pl_no ?>
	<tr id="r_pl_no">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_pl_no"><?php echo $packing_list_no->pl_no->caption() ?></span></td>
		<td data-name="pl_no"<?php echo $packing_list_no->pl_no->cellAttributes() ?>>
<span id="el_packing_list_no_pl_no">
<span<?php echo $packing_list_no->pl_no->viewAttributes() ?>>
<?php echo $packing_list_no->pl_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no__barcode"><?php echo $packing_list_no->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $packing_list_no->_barcode->cellAttributes() ?>>
<span id="el_packing_list_no__barcode">
<span<?php echo $packing_list_no->_barcode->viewAttributes() ?>>
<?php echo $packing_list_no->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->buyer_ref->Visible) { // buyer_ref ?>
	<tr id="r_buyer_ref">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_buyer_ref"><?php echo $packing_list_no->buyer_ref->caption() ?></span></td>
		<td data-name="buyer_ref"<?php echo $packing_list_no->buyer_ref->cellAttributes() ?>>
<span id="el_packing_list_no_buyer_ref">
<span<?php echo $packing_list_no->buyer_ref->viewAttributes() ?>>
<?php echo $packing_list_no->buyer_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->design_id->Visible) { // design_id ?>
	<tr id="r_design_id">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_design_id"><?php echo $packing_list_no->design_id->caption() ?></span></td>
		<td data-name="design_id"<?php echo $packing_list_no->design_id->cellAttributes() ?>>
<span id="el_packing_list_no_design_id">
<span<?php echo $packing_list_no->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list_no->design_id->getViewValue())) && $packing_list_no->design_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list_no->design_id->linkAttributes() ?>><?php echo $packing_list_no->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list_no->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->size_buyer->Visible) { // size_buyer ?>
	<tr id="r_size_buyer">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_size_buyer"><?php echo $packing_list_no->size_buyer->caption() ?></span></td>
		<td data-name="size_buyer"<?php echo $packing_list_no->size_buyer->cellAttributes() ?>>
<span id="el_packing_list_no_size_buyer">
<span<?php echo $packing_list_no->size_buyer->viewAttributes() ?>>
<?php echo $packing_list_no->size_buyer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->buyers_id->Visible) { // buyers_id ?>
	<tr id="r_buyers_id">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_buyers_id"><?php echo $packing_list_no->buyers_id->caption() ?></span></td>
		<td data-name="buyers_id"<?php echo $packing_list_no->buyers_id->cellAttributes() ?>>
<span id="el_packing_list_no_buyers_id">
<span<?php echo $packing_list_no->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list_no->buyers_id->getViewValue())) && $packing_list_no->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list_no->buyers_id->linkAttributes() ?>><?php echo $packing_list_no->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list_no->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_po"><?php echo $packing_list_no->po->caption() ?></span></td>
		<td data-name="po"<?php echo $packing_list_no->po->cellAttributes() ?>>
<span id="el_packing_list_no_po">
<span<?php echo $packing_list_no->po->viewAttributes() ?>>
<?php echo $packing_list_no->po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->despatch_week->Visible) { // despatch_week ?>
	<tr id="r_despatch_week">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_despatch_week"><?php echo $packing_list_no->despatch_week->caption() ?></span></td>
		<td data-name="despatch_week"<?php echo $packing_list_no->despatch_week->cellAttributes() ?>>
<span id="el_packing_list_no_despatch_week">
<span<?php echo $packing_list_no->despatch_week->viewAttributes() ?>>
<?php echo $packing_list_no->despatch_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_sqm"><?php echo $packing_list_no->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $packing_list_no->sqm->cellAttributes() ?>>
<span id="el_packing_list_no_sqm">
<span<?php echo $packing_list_no->sqm->viewAttributes() ?>>
<?php echo $packing_list_no->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_id"><?php echo $packing_list_no->id->caption() ?></span></td>
		<td data-name="id"<?php echo $packing_list_no->id->cellAttributes() ?>>
<span id="el_packing_list_no_id">
<span<?php echo $packing_list_no->id->viewAttributes() ?>>
<?php echo $packing_list_no->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_operator"><?php echo $packing_list_no->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $packing_list_no->operator->cellAttributes() ?>>
<span id="el_packing_list_no_operator">
<span<?php echo $packing_list_no->operator->viewAttributes() ?>>
<?php echo $packing_list_no->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_datetime"><?php echo $packing_list_no->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $packing_list_no->datetime->cellAttributes() ?>>
<span id="el_packing_list_no_datetime">
<span<?php echo $packing_list_no->datetime->viewAttributes() ?>>
<?php echo $packing_list_no->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list_no->sqm_a->Visible) { // sqm_a ?>
	<tr id="r_sqm_a">
		<td class="<?php echo $packing_list_no_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_sqm_a"><?php echo $packing_list_no->sqm_a->caption() ?></span></td>
		<td data-name="sqm_a"<?php echo $packing_list_no->sqm_a->cellAttributes() ?>>
<span id="el_packing_list_no_sqm_a">
<span<?php echo $packing_list_no->sqm_a->viewAttributes() ?>>
<?php echo $packing_list_no->sqm_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$packing_list_no_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_list_no->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_list_no_view->terminate();
?>