<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_list_tmp_list = new packing_list_tmp_list();

// Run the page
$packing_list_tmp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_list_tmp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_list_tmp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpacking_list_tmplist = currentForm = new ew.Form("fpacking_list_tmplist", "list");
fpacking_list_tmplist.formKeyCountName = '<?php echo $packing_list_tmp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpacking_list_tmplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_list_tmplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_list_tmplist.lists["x_buyers_id"] = <?php echo $packing_list_tmp_list->buyers_id->Lookup->toClientList() ?>;
fpacking_list_tmplist.lists["x_buyers_id"].options = <?php echo JsonEncode($packing_list_tmp_list->buyers_id->lookupOptions()) ?>;
fpacking_list_tmplist.lists["x_design"] = <?php echo $packing_list_tmp_list->design->Lookup->toClientList() ?>;
fpacking_list_tmplist.lists["x_design"].options = <?php echo JsonEncode($packing_list_tmp_list->design->lookupOptions()) ?>;
fpacking_list_tmplist.autoSuggests["x_design"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_list_tmplist.lists["x_buyer_ref"] = <?php echo $packing_list_tmp_list->buyer_ref->Lookup->toClientList() ?>;
fpacking_list_tmplist.lists["x_buyer_ref"].options = <?php echo JsonEncode($packing_list_tmp_list->buyer_ref->lookupOptions()) ?>;
fpacking_list_tmplist.lists["x_currency"] = <?php echo $packing_list_tmp_list->currency->Lookup->toClientList() ?>;
fpacking_list_tmplist.lists["x_currency"].options = <?php echo JsonEncode($packing_list_tmp_list->currency->lookupOptions()) ?>;

// Form object for search
var fpacking_list_tmplistsrch = currentSearchForm = new ew.Form("fpacking_list_tmplistsrch");

// Filters
fpacking_list_tmplistsrch.filterList = <?php echo $packing_list_tmp_list->getFilterList() ?>;

// Init search panel as collapsed
fpacking_list_tmplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_list_tmp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($packing_list_tmp_list->TotalRecs > 0 && $packing_list_tmp_list->ExportOptions->visible()) { ?>
<?php $packing_list_tmp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_tmp_list->ImportOptions->visible()) { ?>
<?php $packing_list_tmp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_tmp_list->SearchOptions->visible()) { ?>
<?php $packing_list_tmp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_tmp_list->FilterOptions->visible()) { ?>
<?php $packing_list_tmp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$packing_list_tmp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$packing_list_tmp->isExport() && !$packing_list_tmp->CurrentAction) { ?>
<form name="fpacking_list_tmplistsrch" id="fpacking_list_tmplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($packing_list_tmp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpacking_list_tmplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="packing_list_tmp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($packing_list_tmp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($packing_list_tmp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $packing_list_tmp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($packing_list_tmp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($packing_list_tmp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($packing_list_tmp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($packing_list_tmp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $packing_list_tmp_list->showPageHeader(); ?>
<?php
$packing_list_tmp_list->showMessage();
?>
<?php if ($packing_list_tmp_list->TotalRecs > 0 || $packing_list_tmp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($packing_list_tmp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> packing_list_tmp">
<?php if (!$packing_list_tmp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$packing_list_tmp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_list_tmp_list->Pager)) $packing_list_tmp_list->Pager = new PrevNextPager($packing_list_tmp_list->StartRec, $packing_list_tmp_list->DisplayRecs, $packing_list_tmp_list->TotalRecs, $packing_list_tmp_list->AutoHidePager) ?>
<?php if ($packing_list_tmp_list->Pager->RecordCount > 0 && $packing_list_tmp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_list_tmp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_list_tmp_list->pageUrl() ?>start=<?php echo $packing_list_tmp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_list_tmp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_list_tmp_list->pageUrl() ?>start=<?php echo $packing_list_tmp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_list_tmp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_list_tmp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_list_tmp_list->pageUrl() ?>start=<?php echo $packing_list_tmp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_list_tmp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_list_tmp_list->pageUrl() ?>start=<?php echo $packing_list_tmp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_list_tmp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_list_tmp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_list_tmp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_list_tmp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_list_tmp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_list_tmp_list->TotalRecs > 0 && (!$packing_list_tmp_list->AutoHidePageSizeSelector || $packing_list_tmp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_list_tmp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_list_tmp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_list_tmp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_list_tmp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_list_tmp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_list_tmp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_list_tmp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_list_tmp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpacking_list_tmplist" id="fpacking_list_tmplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_list_tmp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_list_tmp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_list_tmp">
<div id="gmp_packing_list_tmp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($packing_list_tmp_list->TotalRecs > 0 || $packing_list_tmp->isGridEdit()) { ?>
<table id="tbl_packing_list_tmplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$packing_list_tmp_list->RowType = ROWTYPE_HEADER;

// Render list options
$packing_list_tmp_list->renderListOptions();

// Render list options (header, left)
$packing_list_tmp_list->ListOptions->render("header", "left");
?>
<?php if ($packing_list_tmp->id->Visible) { // id ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->id) == "") { ?>
		<th data-name="id" class="<?php echo $packing_list_tmp->id->headerCellClass() ?>"><div id="elh_packing_list_tmp_id" class="packing_list_tmp_id"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $packing_list_tmp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->id) ?>',2);"><div id="elh_packing_list_tmp_id" class="packing_list_tmp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->pl_no->Visible) { // pl_no ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $packing_list_tmp->pl_no->headerCellClass() ?>"><div id="elh_packing_list_tmp_pl_no" class="packing_list_tmp_pl_no"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $packing_list_tmp->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->pl_no) ?>',2);"><div id="elh_packing_list_tmp_pl_no" class="packing_list_tmp_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->pl_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->buyers_id->Visible) { // buyers_id ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $packing_list_tmp->buyers_id->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyers_id" class="packing_list_tmp_buyers_id"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $packing_list_tmp->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->buyers_id) ?>',2);"><div id="elh_packing_list_tmp_buyers_id" class="packing_list_tmp_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->_barcode->Visible) { // barcode ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $packing_list_tmp->_barcode->headerCellClass() ?>"><div id="elh_packing_list_tmp__barcode" class="packing_list_tmp__barcode"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $packing_list_tmp->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->_barcode) ?>',2);"><div id="elh_packing_list_tmp__barcode" class="packing_list_tmp__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->roll_no_start->Visible) { // roll_no_start ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->roll_no_start) == "") { ?>
		<th data-name="roll_no_start" class="<?php echo $packing_list_tmp->roll_no_start->headerCellClass() ?>"><div id="elh_packing_list_tmp_roll_no_start" class="packing_list_tmp_roll_no_start"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->roll_no_start->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no_start" class="<?php echo $packing_list_tmp->roll_no_start->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->roll_no_start) ?>',2);"><div id="elh_packing_list_tmp_roll_no_start" class="packing_list_tmp_roll_no_start">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->roll_no_start->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->roll_no_start->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->roll_no_start->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->design->Visible) { // design ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->design) == "") { ?>
		<th data-name="design" class="<?php echo $packing_list_tmp->design->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_packing_list_tmp_design" class="packing_list_tmp_design"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $packing_list_tmp->design->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->design) ?>',2);"><div id="elh_packing_list_tmp_design" class="packing_list_tmp_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $packing_list_tmp->buyer_ref->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_ref" class="packing_list_tmp_buyer_ref"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $packing_list_tmp->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->buyer_ref) ?>',2);"><div id="elh_packing_list_tmp_buyer_ref" class="packing_list_tmp_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->buyer_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->buyer_code->Visible) { // buyer_code ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->buyer_code) == "") { ?>
		<th data-name="buyer_code" class="<?php echo $packing_list_tmp->buyer_code->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_code" class="packing_list_tmp_buyer_code"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->buyer_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_code" class="<?php echo $packing_list_tmp->buyer_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->buyer_code) ?>',2);"><div id="elh_packing_list_tmp_buyer_code" class="packing_list_tmp_buyer_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->buyer_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->buyer_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->buyer_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->buyer_uid->Visible) { // buyer_uid ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->buyer_uid) == "") { ?>
		<th data-name="buyer_uid" class="<?php echo $packing_list_tmp->buyer_uid->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_uid" class="packing_list_tmp_buyer_uid"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->buyer_uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_uid" class="<?php echo $packing_list_tmp->buyer_uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->buyer_uid) ?>',2);"><div id="elh_packing_list_tmp_buyer_uid" class="packing_list_tmp_buyer_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->buyer_uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->buyer_uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->buyer_uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->partner_ref->Visible) { // partner_ref ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->partner_ref) == "") { ?>
		<th data-name="partner_ref" class="<?php echo $packing_list_tmp->partner_ref->headerCellClass() ?>"><div id="elh_packing_list_tmp_partner_ref" class="packing_list_tmp_partner_ref"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->partner_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_ref" class="<?php echo $packing_list_tmp->partner_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->partner_ref) ?>',2);"><div id="elh_packing_list_tmp_partner_ref" class="packing_list_tmp_partner_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->partner_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->partner_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->partner_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->no_of_bales->Visible) { // no_of_bales ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->no_of_bales) == "") { ?>
		<th data-name="no_of_bales" class="<?php echo $packing_list_tmp->no_of_bales->headerCellClass() ?>"><div id="elh_packing_list_tmp_no_of_bales" class="packing_list_tmp_no_of_bales"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->no_of_bales->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_of_bales" class="<?php echo $packing_list_tmp->no_of_bales->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->no_of_bales) ?>',2);"><div id="elh_packing_list_tmp_no_of_bales" class="packing_list_tmp_no_of_bales">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->no_of_bales->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->no_of_bales->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->no_of_bales->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->buyer_po->Visible) { // buyer_po ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->buyer_po) == "") { ?>
		<th data-name="buyer_po" class="<?php echo $packing_list_tmp->buyer_po->headerCellClass() ?>"><div id="elh_packing_list_tmp_buyer_po" class="packing_list_tmp_buyer_po"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->buyer_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_po" class="<?php echo $packing_list_tmp->buyer_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->buyer_po) ?>',2);"><div id="elh_packing_list_tmp_buyer_po" class="packing_list_tmp_buyer_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->buyer_po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->buyer_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->buyer_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->quantity->Visible) { // quantity ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $packing_list_tmp->quantity->headerCellClass() ?>"><div id="elh_packing_list_tmp_quantity" class="packing_list_tmp_quantity"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $packing_list_tmp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->quantity) ?>',2);"><div id="elh_packing_list_tmp_quantity" class="packing_list_tmp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->size->Visible) { // size ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->size) == "") { ?>
		<th data-name="size" class="<?php echo $packing_list_tmp->size->headerCellClass() ?>"><div id="elh_packing_list_tmp_size" class="packing_list_tmp_size"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $packing_list_tmp->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->size) ?>',2);"><div id="elh_packing_list_tmp_size" class="packing_list_tmp_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->sqm->Visible) { // sqm ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $packing_list_tmp->sqm->headerCellClass() ?>"><div id="elh_packing_list_tmp_sqm" class="packing_list_tmp_sqm"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $packing_list_tmp->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->sqm) ?>',2);"><div id="elh_packing_list_tmp_sqm" class="packing_list_tmp_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->amount->Visible) { // amount ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $packing_list_tmp->amount->headerCellClass() ?>"><div id="elh_packing_list_tmp_amount" class="packing_list_tmp_amount"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $packing_list_tmp->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->amount) ?>',2);"><div id="elh_packing_list_tmp_amount" class="packing_list_tmp_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->currency->Visible) { // currency ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $packing_list_tmp->currency->headerCellClass() ?>"><div id="elh_packing_list_tmp_currency" class="packing_list_tmp_currency"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $packing_list_tmp->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->currency) ?>',2);"><div id="elh_packing_list_tmp_currency" class="packing_list_tmp_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->price->Visible) { // price ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->price) == "") { ?>
		<th data-name="price" class="<?php echo $packing_list_tmp->price->headerCellClass() ?>"><div id="elh_packing_list_tmp_price" class="packing_list_tmp_price"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $packing_list_tmp->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->price) ?>',2);"><div id="elh_packing_list_tmp_price" class="packing_list_tmp_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->discount->Visible) { // discount ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->discount) == "") { ?>
		<th data-name="discount" class="<?php echo $packing_list_tmp->discount->headerCellClass() ?>"><div id="elh_packing_list_tmp_discount" class="packing_list_tmp_discount"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="discount" class="<?php echo $packing_list_tmp->discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->discount) ?>',2);"><div id="elh_packing_list_tmp_discount" class="packing_list_tmp_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->hsn->Visible) { // hsn ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->hsn) == "") { ?>
		<th data-name="hsn" class="<?php echo $packing_list_tmp->hsn->headerCellClass() ?>"><div id="elh_packing_list_tmp_hsn" class="packing_list_tmp_hsn"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->hsn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="hsn" class="<?php echo $packing_list_tmp->hsn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->hsn) ?>',2);"><div id="elh_packing_list_tmp_hsn" class="packing_list_tmp_hsn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->hsn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->hsn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->hsn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->gst->Visible) { // gst ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $packing_list_tmp->gst->headerCellClass() ?>"><div id="elh_packing_list_tmp_gst" class="packing_list_tmp_gst"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $packing_list_tmp->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->gst) ?>',2);"><div id="elh_packing_list_tmp_gst" class="packing_list_tmp_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->gst->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->composition->Visible) { // composition ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->composition) == "") { ?>
		<th data-name="composition" class="<?php echo $packing_list_tmp->composition->headerCellClass() ?>"><div id="elh_packing_list_tmp_composition" class="packing_list_tmp_composition"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->composition->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="composition" class="<?php echo $packing_list_tmp->composition->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->composition) ?>',2);"><div id="elh_packing_list_tmp_composition" class="packing_list_tmp_composition">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->composition->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->composition->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->composition->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->price_exchange->Visible) { // price_exchange ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->price_exchange) == "") { ?>
		<th data-name="price_exchange" class="<?php echo $packing_list_tmp->price_exchange->headerCellClass() ?>"><div id="elh_packing_list_tmp_price_exchange" class="packing_list_tmp_price_exchange"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->price_exchange->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_exchange" class="<?php echo $packing_list_tmp->price_exchange->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->price_exchange) ?>',2);"><div id="elh_packing_list_tmp_price_exchange" class="packing_list_tmp_price_exchange">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->price_exchange->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->price_exchange->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->price_exchange->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->amount_exchange->Visible) { // amount_exchange ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->amount_exchange) == "") { ?>
		<th data-name="amount_exchange" class="<?php echo $packing_list_tmp->amount_exchange->headerCellClass() ?>"><div id="elh_packing_list_tmp_amount_exchange" class="packing_list_tmp_amount_exchange"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->amount_exchange->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount_exchange" class="<?php echo $packing_list_tmp->amount_exchange->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->amount_exchange) ?>',2);"><div id="elh_packing_list_tmp_amount_exchange" class="packing_list_tmp_amount_exchange">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->amount_exchange->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->amount_exchange->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->amount_exchange->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->design_code->Visible) { // design_code ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->design_code) == "") { ?>
		<th data-name="design_code" class="<?php echo $packing_list_tmp->design_code->headerCellClass() ?>"><div id="elh_packing_list_tmp_design_code" class="packing_list_tmp_design_code"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->design_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_code" class="<?php echo $packing_list_tmp->design_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->design_code) ?>',2);"><div id="elh_packing_list_tmp_design_code" class="packing_list_tmp_design_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->design_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->design_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->design_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->cbm->Visible) { // cbm ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $packing_list_tmp->cbm->headerCellClass() ?>"><div id="elh_packing_list_tmp_cbm" class="packing_list_tmp_cbm"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $packing_list_tmp->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->cbm) ?>',2);"><div id="elh_packing_list_tmp_cbm" class="packing_list_tmp_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->cbm->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->weight->Visible) { // weight ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->weight) == "") { ?>
		<th data-name="weight" class="<?php echo $packing_list_tmp->weight->headerCellClass() ?>"><div id="elh_packing_list_tmp_weight" class="packing_list_tmp_weight"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight" class="<?php echo $packing_list_tmp->weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->weight) ?>',2);"><div id="elh_packing_list_tmp_weight" class="packing_list_tmp_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list_tmp->sqm_a->Visible) { // sqm_a ?>
	<?php if ($packing_list_tmp->sortUrl($packing_list_tmp->sqm_a) == "") { ?>
		<th data-name="sqm_a" class="<?php echo $packing_list_tmp->sqm_a->headerCellClass() ?>"><div id="elh_packing_list_tmp_sqm_a" class="packing_list_tmp_sqm_a"><div class="ew-table-header-caption"><?php echo $packing_list_tmp->sqm_a->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_a" class="<?php echo $packing_list_tmp->sqm_a->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list_tmp->SortUrl($packing_list_tmp->sqm_a) ?>',2);"><div id="elh_packing_list_tmp_sqm_a" class="packing_list_tmp_sqm_a">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list_tmp->sqm_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list_tmp->sqm_a->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list_tmp->sqm_a->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$packing_list_tmp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($packing_list_tmp->ExportAll && $packing_list_tmp->isExport()) {
	$packing_list_tmp_list->StopRec = $packing_list_tmp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($packing_list_tmp_list->TotalRecs > $packing_list_tmp_list->StartRec + $packing_list_tmp_list->DisplayRecs - 1)
		$packing_list_tmp_list->StopRec = $packing_list_tmp_list->StartRec + $packing_list_tmp_list->DisplayRecs - 1;
	else
		$packing_list_tmp_list->StopRec = $packing_list_tmp_list->TotalRecs;
}
$packing_list_tmp_list->RecCnt = $packing_list_tmp_list->StartRec - 1;
if ($packing_list_tmp_list->Recordset && !$packing_list_tmp_list->Recordset->EOF) {
	$packing_list_tmp_list->Recordset->moveFirst();
	$selectLimit = $packing_list_tmp_list->UseSelectLimit;
	if (!$selectLimit && $packing_list_tmp_list->StartRec > 1)
		$packing_list_tmp_list->Recordset->move($packing_list_tmp_list->StartRec - 1);
} elseif (!$packing_list_tmp->AllowAddDeleteRow && $packing_list_tmp_list->StopRec == 0) {
	$packing_list_tmp_list->StopRec = $packing_list_tmp->GridAddRowCount;
}

// Initialize aggregate
$packing_list_tmp->RowType = ROWTYPE_AGGREGATEINIT;
$packing_list_tmp->resetAttributes();
$packing_list_tmp_list->renderRow();
while ($packing_list_tmp_list->RecCnt < $packing_list_tmp_list->StopRec) {
	$packing_list_tmp_list->RecCnt++;
	if ($packing_list_tmp_list->RecCnt >= $packing_list_tmp_list->StartRec) {
		$packing_list_tmp_list->RowCnt++;

		// Set up key count
		$packing_list_tmp_list->KeyCount = $packing_list_tmp_list->RowIndex;

		// Init row class and style
		$packing_list_tmp->resetAttributes();
		$packing_list_tmp->CssClass = "";
		if ($packing_list_tmp->isGridAdd()) {
		} else {
			$packing_list_tmp_list->loadRowValues($packing_list_tmp_list->Recordset); // Load row values
		}
		$packing_list_tmp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$packing_list_tmp->RowAttrs = array_merge($packing_list_tmp->RowAttrs, array('data-rowindex'=>$packing_list_tmp_list->RowCnt, 'id'=>'r' . $packing_list_tmp_list->RowCnt . '_packing_list_tmp', 'data-rowtype'=>$packing_list_tmp->RowType));

		// Render row
		$packing_list_tmp_list->renderRow();

		// Render list options
		$packing_list_tmp_list->renderListOptions();
?>
	<tr<?php echo $packing_list_tmp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_list_tmp_list->ListOptions->render("body", "left", $packing_list_tmp_list->RowCnt);
?>
	<?php if ($packing_list_tmp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $packing_list_tmp->id->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_id" class="packing_list_tmp_id">
<span<?php echo $packing_list_tmp->id->viewAttributes() ?>>
<?php echo $packing_list_tmp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $packing_list_tmp->pl_no->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_pl_no" class="packing_list_tmp_pl_no">
<span<?php echo $packing_list_tmp->pl_no->viewAttributes() ?>>
<?php echo $packing_list_tmp->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $packing_list_tmp->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_buyers_id" class="packing_list_tmp_buyers_id">
<span<?php echo $packing_list_tmp->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list_tmp->buyers_id->getViewValue())) && $packing_list_tmp->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list_tmp->buyers_id->linkAttributes() ?>><?php echo $packing_list_tmp->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list_tmp->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $packing_list_tmp->_barcode->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp__barcode" class="packing_list_tmp__barcode">
<span<?php echo $packing_list_tmp->_barcode->viewAttributes() ?>>
<?php echo $packing_list_tmp->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->roll_no_start->Visible) { // roll_no_start ?>
		<td data-name="roll_no_start"<?php echo $packing_list_tmp->roll_no_start->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_roll_no_start" class="packing_list_tmp_roll_no_start">
<span<?php echo $packing_list_tmp->roll_no_start->viewAttributes() ?>>
<?php echo $packing_list_tmp->roll_no_start->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->design->Visible) { // design ?>
		<td data-name="design"<?php echo $packing_list_tmp->design->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_design" class="packing_list_tmp_design">
<span<?php echo $packing_list_tmp->design->viewAttributes() ?>>
<?php echo $packing_list_tmp->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $packing_list_tmp->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_buyer_ref" class="packing_list_tmp_buyer_ref">
<span<?php echo $packing_list_tmp->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list_tmp->buyer_ref->getViewValue())) && $packing_list_tmp->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $packing_list_tmp->buyer_ref->linkAttributes() ?>><?php echo $packing_list_tmp->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list_tmp->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyer_code->Visible) { // buyer_code ?>
		<td data-name="buyer_code"<?php echo $packing_list_tmp->buyer_code->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_buyer_code" class="packing_list_tmp_buyer_code">
<span<?php echo $packing_list_tmp->buyer_code->viewAttributes() ?>>
<?php echo $packing_list_tmp->buyer_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyer_uid->Visible) { // buyer_uid ?>
		<td data-name="buyer_uid"<?php echo $packing_list_tmp->buyer_uid->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_buyer_uid" class="packing_list_tmp_buyer_uid">
<span<?php echo $packing_list_tmp->buyer_uid->viewAttributes() ?>>
<?php echo $packing_list_tmp->buyer_uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->partner_ref->Visible) { // partner_ref ?>
		<td data-name="partner_ref"<?php echo $packing_list_tmp->partner_ref->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_partner_ref" class="packing_list_tmp_partner_ref">
<span<?php echo $packing_list_tmp->partner_ref->viewAttributes() ?>>
<?php echo $packing_list_tmp->partner_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->no_of_bales->Visible) { // no_of_bales ?>
		<td data-name="no_of_bales"<?php echo $packing_list_tmp->no_of_bales->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_no_of_bales" class="packing_list_tmp_no_of_bales">
<span<?php echo $packing_list_tmp->no_of_bales->viewAttributes() ?>>
<?php echo $packing_list_tmp->no_of_bales->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po"<?php echo $packing_list_tmp->buyer_po->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_buyer_po" class="packing_list_tmp_buyer_po">
<span<?php echo $packing_list_tmp->buyer_po->viewAttributes() ?>>
<?php echo $packing_list_tmp->buyer_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $packing_list_tmp->quantity->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_quantity" class="packing_list_tmp_quantity">
<span<?php echo $packing_list_tmp->quantity->viewAttributes() ?>>
<?php echo $packing_list_tmp->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->size->Visible) { // size ?>
		<td data-name="size"<?php echo $packing_list_tmp->size->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_size" class="packing_list_tmp_size">
<span<?php echo $packing_list_tmp->size->viewAttributes() ?>>
<?php echo $packing_list_tmp->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $packing_list_tmp->sqm->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_sqm" class="packing_list_tmp_sqm">
<span<?php echo $packing_list_tmp->sqm->viewAttributes() ?>>
<?php echo $packing_list_tmp->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $packing_list_tmp->amount->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_amount" class="packing_list_tmp_amount">
<span<?php echo $packing_list_tmp->amount->viewAttributes() ?>>
<?php echo $packing_list_tmp->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $packing_list_tmp->currency->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_currency" class="packing_list_tmp_currency">
<span<?php echo $packing_list_tmp->currency->viewAttributes() ?>>
<?php echo $packing_list_tmp->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->price->Visible) { // price ?>
		<td data-name="price"<?php echo $packing_list_tmp->price->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_price" class="packing_list_tmp_price">
<span<?php echo $packing_list_tmp->price->viewAttributes() ?>>
<?php echo $packing_list_tmp->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->discount->Visible) { // discount ?>
		<td data-name="discount"<?php echo $packing_list_tmp->discount->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_discount" class="packing_list_tmp_discount">
<span<?php echo $packing_list_tmp->discount->viewAttributes() ?>>
<?php echo $packing_list_tmp->discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->hsn->Visible) { // hsn ?>
		<td data-name="hsn"<?php echo $packing_list_tmp->hsn->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_hsn" class="packing_list_tmp_hsn">
<span<?php echo $packing_list_tmp->hsn->viewAttributes() ?>>
<?php echo $packing_list_tmp->hsn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $packing_list_tmp->gst->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_gst" class="packing_list_tmp_gst">
<span<?php echo $packing_list_tmp->gst->viewAttributes() ?>>
<?php echo $packing_list_tmp->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->composition->Visible) { // composition ?>
		<td data-name="composition"<?php echo $packing_list_tmp->composition->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_composition" class="packing_list_tmp_composition">
<span<?php echo $packing_list_tmp->composition->viewAttributes() ?>>
<?php echo $packing_list_tmp->composition->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->price_exchange->Visible) { // price_exchange ?>
		<td data-name="price_exchange"<?php echo $packing_list_tmp->price_exchange->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_price_exchange" class="packing_list_tmp_price_exchange">
<span<?php echo $packing_list_tmp->price_exchange->viewAttributes() ?>>
<?php echo $packing_list_tmp->price_exchange->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->amount_exchange->Visible) { // amount_exchange ?>
		<td data-name="amount_exchange"<?php echo $packing_list_tmp->amount_exchange->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_amount_exchange" class="packing_list_tmp_amount_exchange">
<span<?php echo $packing_list_tmp->amount_exchange->viewAttributes() ?>>
<?php echo $packing_list_tmp->amount_exchange->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->design_code->Visible) { // design_code ?>
		<td data-name="design_code"<?php echo $packing_list_tmp->design_code->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_design_code" class="packing_list_tmp_design_code">
<span<?php echo $packing_list_tmp->design_code->viewAttributes() ?>>
<?php echo $packing_list_tmp->design_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $packing_list_tmp->cbm->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_cbm" class="packing_list_tmp_cbm">
<span<?php echo $packing_list_tmp->cbm->viewAttributes() ?>>
<?php echo $packing_list_tmp->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->weight->Visible) { // weight ?>
		<td data-name="weight"<?php echo $packing_list_tmp->weight->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_weight" class="packing_list_tmp_weight">
<span<?php echo $packing_list_tmp->weight->viewAttributes() ?>>
<?php echo $packing_list_tmp->weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list_tmp->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a"<?php echo $packing_list_tmp->sqm_a->cellAttributes() ?>>
<span id="el<?php echo $packing_list_tmp_list->RowCnt ?>_packing_list_tmp_sqm_a" class="packing_list_tmp_sqm_a">
<span<?php echo $packing_list_tmp->sqm_a->viewAttributes() ?>>
<?php echo $packing_list_tmp->sqm_a->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_list_tmp_list->ListOptions->render("body", "right", $packing_list_tmp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$packing_list_tmp->isGridAdd())
		$packing_list_tmp_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$packing_list_tmp->RowType = ROWTYPE_AGGREGATE;
$packing_list_tmp->resetAttributes();
$packing_list_tmp_list->renderRow();
?>
<?php if ($packing_list_tmp_list->TotalRecs > 0 && !$packing_list_tmp->isGridAdd() && !$packing_list_tmp->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$packing_list_tmp_list->renderListOptions();

// Render list options (footer, left)
$packing_list_tmp_list->ListOptions->render("footer", "left");
?>
	<?php if ($packing_list_tmp->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $packing_list_tmp->id->footerCellClass() ?>"><span id="elf_packing_list_tmp_id" class="packing_list_tmp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no" class="<?php echo $packing_list_tmp->pl_no->footerCellClass() ?>"><span id="elf_packing_list_tmp_pl_no" class="packing_list_tmp_pl_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $packing_list_tmp->buyers_id->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyers_id" class="packing_list_tmp_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $packing_list_tmp->_barcode->footerCellClass() ?>"><span id="elf_packing_list_tmp__barcode" class="packing_list_tmp__barcode">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list_tmp->_barcode->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->roll_no_start->Visible) { // roll_no_start ?>
		<td data-name="roll_no_start" class="<?php echo $packing_list_tmp->roll_no_start->footerCellClass() ?>"><span id="elf_packing_list_tmp_roll_no_start" class="packing_list_tmp_roll_no_start">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->design->Visible) { // design ?>
		<td data-name="design" class="<?php echo $packing_list_tmp->design->footerCellClass() ?>"><span id="elf_packing_list_tmp_design" class="packing_list_tmp_design">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref" class="<?php echo $packing_list_tmp->buyer_ref->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_ref" class="packing_list_tmp_buyer_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyer_code->Visible) { // buyer_code ?>
		<td data-name="buyer_code" class="<?php echo $packing_list_tmp->buyer_code->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_code" class="packing_list_tmp_buyer_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyer_uid->Visible) { // buyer_uid ?>
		<td data-name="buyer_uid" class="<?php echo $packing_list_tmp->buyer_uid->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_uid" class="packing_list_tmp_buyer_uid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->partner_ref->Visible) { // partner_ref ?>
		<td data-name="partner_ref" class="<?php echo $packing_list_tmp->partner_ref->footerCellClass() ?>"><span id="elf_packing_list_tmp_partner_ref" class="packing_list_tmp_partner_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->no_of_bales->Visible) { // no_of_bales ?>
		<td data-name="no_of_bales" class="<?php echo $packing_list_tmp->no_of_bales->footerCellClass() ?>"><span id="elf_packing_list_tmp_no_of_bales" class="packing_list_tmp_no_of_bales">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po" class="<?php echo $packing_list_tmp->buyer_po->footerCellClass() ?>"><span id="elf_packing_list_tmp_buyer_po" class="packing_list_tmp_buyer_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $packing_list_tmp->quantity->footerCellClass() ?>"><span id="elf_packing_list_tmp_quantity" class="packing_list_tmp_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list_tmp->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->size->Visible) { // size ?>
		<td data-name="size" class="<?php echo $packing_list_tmp->size->footerCellClass() ?>"><span id="elf_packing_list_tmp_size" class="packing_list_tmp_size">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $packing_list_tmp->sqm->footerCellClass() ?>"><span id="elf_packing_list_tmp_sqm" class="packing_list_tmp_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list_tmp->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $packing_list_tmp->amount->footerCellClass() ?>"><span id="elf_packing_list_tmp_amount" class="packing_list_tmp_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list_tmp->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->currency->Visible) { // currency ?>
		<td data-name="currency" class="<?php echo $packing_list_tmp->currency->footerCellClass() ?>"><span id="elf_packing_list_tmp_currency" class="packing_list_tmp_currency">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->price->Visible) { // price ?>
		<td data-name="price" class="<?php echo $packing_list_tmp->price->footerCellClass() ?>"><span id="elf_packing_list_tmp_price" class="packing_list_tmp_price">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->discount->Visible) { // discount ?>
		<td data-name="discount" class="<?php echo $packing_list_tmp->discount->footerCellClass() ?>"><span id="elf_packing_list_tmp_discount" class="packing_list_tmp_discount">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->hsn->Visible) { // hsn ?>
		<td data-name="hsn" class="<?php echo $packing_list_tmp->hsn->footerCellClass() ?>"><span id="elf_packing_list_tmp_hsn" class="packing_list_tmp_hsn">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->gst->Visible) { // gst ?>
		<td data-name="gst" class="<?php echo $packing_list_tmp->gst->footerCellClass() ?>"><span id="elf_packing_list_tmp_gst" class="packing_list_tmp_gst">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->composition->Visible) { // composition ?>
		<td data-name="composition" class="<?php echo $packing_list_tmp->composition->footerCellClass() ?>"><span id="elf_packing_list_tmp_composition" class="packing_list_tmp_composition">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->price_exchange->Visible) { // price_exchange ?>
		<td data-name="price_exchange" class="<?php echo $packing_list_tmp->price_exchange->footerCellClass() ?>"><span id="elf_packing_list_tmp_price_exchange" class="packing_list_tmp_price_exchange">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->amount_exchange->Visible) { // amount_exchange ?>
		<td data-name="amount_exchange" class="<?php echo $packing_list_tmp->amount_exchange->footerCellClass() ?>"><span id="elf_packing_list_tmp_amount_exchange" class="packing_list_tmp_amount_exchange">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->design_code->Visible) { // design_code ?>
		<td data-name="design_code" class="<?php echo $packing_list_tmp->design_code->footerCellClass() ?>"><span id="elf_packing_list_tmp_design_code" class="packing_list_tmp_design_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->cbm->Visible) { // cbm ?>
		<td data-name="cbm" class="<?php echo $packing_list_tmp->cbm->footerCellClass() ?>"><span id="elf_packing_list_tmp_cbm" class="packing_list_tmp_cbm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->weight->Visible) { // weight ?>
		<td data-name="weight" class="<?php echo $packing_list_tmp->weight->footerCellClass() ?>"><span id="elf_packing_list_tmp_weight" class="packing_list_tmp_weight">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list_tmp->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a" class="<?php echo $packing_list_tmp->sqm_a->footerCellClass() ?>"><span id="elf_packing_list_tmp_sqm_a" class="packing_list_tmp_sqm_a">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$packing_list_tmp_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$packing_list_tmp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($packing_list_tmp_list->Recordset)
	$packing_list_tmp_list->Recordset->Close();
?>
<?php if (!$packing_list_tmp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$packing_list_tmp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_list_tmp_list->Pager)) $packing_list_tmp_list->Pager = new PrevNextPager($packing_list_tmp_list->StartRec, $packing_list_tmp_list->DisplayRecs, $packing_list_tmp_list->TotalRecs, $packing_list_tmp_list->AutoHidePager) ?>
<?php if ($packing_list_tmp_list->Pager->RecordCount > 0 && $packing_list_tmp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_list_tmp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_list_tmp_list->pageUrl() ?>start=<?php echo $packing_list_tmp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_list_tmp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_list_tmp_list->pageUrl() ?>start=<?php echo $packing_list_tmp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_list_tmp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_list_tmp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_list_tmp_list->pageUrl() ?>start=<?php echo $packing_list_tmp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_list_tmp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_list_tmp_list->pageUrl() ?>start=<?php echo $packing_list_tmp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_list_tmp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_list_tmp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_list_tmp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_list_tmp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_list_tmp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_list_tmp_list->TotalRecs > 0 && (!$packing_list_tmp_list->AutoHidePageSizeSelector || $packing_list_tmp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_list_tmp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_list_tmp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_list_tmp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_list_tmp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_list_tmp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_list_tmp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_list_tmp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_list_tmp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($packing_list_tmp_list->TotalRecs == 0 && !$packing_list_tmp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $packing_list_tmp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$packing_list_tmp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_list_tmp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$packing_list_tmp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_packing_list_tmp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_list_tmp_list->terminate();
?>