<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_list_tmp_search = new packing_list_tmp_search();

// Run the page
$packing_list_tmp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_list_tmp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($packing_list_tmp_search->IsModal) { ?>
var fpacking_list_tmpsearch = currentAdvancedSearchForm = new ew.Form("fpacking_list_tmpsearch", "search");
<?php } else { ?>
var fpacking_list_tmpsearch = currentForm = new ew.Form("fpacking_list_tmpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpacking_list_tmpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_list_tmpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_list_tmpsearch.lists["x_buyers_id"] = <?php echo $packing_list_tmp_search->buyers_id->Lookup->toClientList() ?>;
fpacking_list_tmpsearch.lists["x_buyers_id"].options = <?php echo JsonEncode($packing_list_tmp_search->buyers_id->lookupOptions()) ?>;
fpacking_list_tmpsearch.lists["x_buyer_ref"] = <?php echo $packing_list_tmp_search->buyer_ref->Lookup->toClientList() ?>;
fpacking_list_tmpsearch.lists["x_buyer_ref"].options = <?php echo JsonEncode($packing_list_tmp_search->buyer_ref->lookupOptions()) ?>;
fpacking_list_tmpsearch.lists["x_currency"] = <?php echo $packing_list_tmp_search->currency->Lookup->toClientList() ?>;
fpacking_list_tmpsearch.lists["x_currency"].options = <?php echo JsonEncode($packing_list_tmp_search->currency->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpacking_list_tmpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->pl_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_roll_no_start");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->roll_no_start->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_no_of_bales");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->no_of_bales->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_discount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->discount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_gst");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->gst->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price_exchange");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->price_exchange->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount_exchange");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->amount_exchange->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->cbm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm_a");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_list_tmp->sqm_a->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_list_tmp_search->showPageHeader(); ?>
<?php
$packing_list_tmp_search->showMessage();
?>
<form name="fpacking_list_tmpsearch" id="fpacking_list_tmpsearch" class="<?php echo $packing_list_tmp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_list_tmp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_list_tmp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_list_tmp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$packing_list_tmp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($packing_list_tmp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_id"><?php echo $packing_list_tmp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->id->cellAttributes() ?>>
			<span id="el_packing_list_tmp_id">
<input type="text" data-table="packing_list_tmp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($packing_list_tmp->id->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->id->EditValue ?>"<?php echo $packing_list_tmp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_pl_no"><?php echo $packing_list_tmp->pl_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->pl_no->cellAttributes() ?>>
			<span id="el_packing_list_tmp_pl_no">
<input type="text" data-table="packing_list_tmp" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->pl_no->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->pl_no->EditValue ?>"<?php echo $packing_list_tmp->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_buyers_id"><?php echo $packing_list_tmp->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->buyers_id->cellAttributes() ?>>
			<span id="el_packing_list_tmp_buyers_id">
<?php $packing_list_tmp->buyers_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$packing_list_tmp->buyers_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_tmp" data-field="x_buyers_id" data-value-separator="<?php echo $packing_list_tmp->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $packing_list_tmp->buyers_id->editAttributes() ?>>
		<?php echo $packing_list_tmp->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $packing_list_tmp->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp__barcode"><?php echo $packing_list_tmp->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->_barcode->cellAttributes() ?>>
			<span id="el_packing_list_tmp__barcode">
<input type="text" data-table="packing_list_tmp" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->_barcode->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->_barcode->EditValue ?>"<?php echo $packing_list_tmp->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->roll_no_start->Visible) { // roll_no_start ?>
	<div id="r_roll_no_start" class="form-group row">
		<label for="x_roll_no_start" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_roll_no_start"><?php echo $packing_list_tmp->roll_no_start->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_roll_no_start" id="z_roll_no_start" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->roll_no_start->cellAttributes() ?>>
			<span id="el_packing_list_tmp_roll_no_start">
<input type="text" data-table="packing_list_tmp" data-field="x_roll_no_start" name="x_roll_no_start" id="x_roll_no_start" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->roll_no_start->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->roll_no_start->EditValue ?>"<?php echo $packing_list_tmp->roll_no_start->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_buyer_ref"><?php echo $packing_list_tmp->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->buyer_ref->cellAttributes() ?>>
			<span id="el_packing_list_tmp_buyer_ref">
<input type="text" data-table="packing_list_tmp" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->buyer_ref->EditValue ?>"<?php echo $packing_list_tmp->buyer_ref->editAttributes() ?>>
<?php echo $packing_list_tmp->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->buyer_code->Visible) { // buyer_code ?>
	<div id="r_buyer_code" class="form-group row">
		<label for="x_buyer_code" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_buyer_code"><?php echo $packing_list_tmp->buyer_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_code" id="z_buyer_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->buyer_code->cellAttributes() ?>>
			<span id="el_packing_list_tmp_buyer_code">
<input type="text" data-table="packing_list_tmp" data-field="x_buyer_code" name="x_buyer_code" id="x_buyer_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($packing_list_tmp->buyer_code->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->buyer_code->EditValue ?>"<?php echo $packing_list_tmp->buyer_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->buyer_uid->Visible) { // buyer_uid ?>
	<div id="r_buyer_uid" class="form-group row">
		<label for="x_buyer_uid" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_buyer_uid"><?php echo $packing_list_tmp->buyer_uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid" id="z_buyer_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->buyer_uid->cellAttributes() ?>>
			<span id="el_packing_list_tmp_buyer_uid">
<input type="text" data-table="packing_list_tmp" data-field="x_buyer_uid" name="x_buyer_uid" id="x_buyer_uid" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_tmp->buyer_uid->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->buyer_uid->EditValue ?>"<?php echo $packing_list_tmp->buyer_uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->partner_ref->Visible) { // partner_ref ?>
	<div id="r_partner_ref" class="form-group row">
		<label for="x_partner_ref" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_partner_ref"><?php echo $packing_list_tmp->partner_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_ref" id="z_partner_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->partner_ref->cellAttributes() ?>>
			<span id="el_packing_list_tmp_partner_ref">
<input type="text" data-table="packing_list_tmp" data-field="x_partner_ref" name="x_partner_ref" id="x_partner_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($packing_list_tmp->partner_ref->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->partner_ref->EditValue ?>"<?php echo $packing_list_tmp->partner_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->no_of_bales->Visible) { // no_of_bales ?>
	<div id="r_no_of_bales" class="form-group row">
		<label for="x_no_of_bales" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_no_of_bales"><?php echo $packing_list_tmp->no_of_bales->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_no_of_bales" id="z_no_of_bales" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->no_of_bales->cellAttributes() ?>>
			<span id="el_packing_list_tmp_no_of_bales">
<input type="text" data-table="packing_list_tmp" data-field="x_no_of_bales" name="x_no_of_bales" id="x_no_of_bales" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->no_of_bales->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->no_of_bales->EditValue ?>"<?php echo $packing_list_tmp->no_of_bales->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label for="x_buyer_po" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_buyer_po"><?php echo $packing_list_tmp->buyer_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->buyer_po->cellAttributes() ?>>
			<span id="el_packing_list_tmp_buyer_po">
<input type="text" data-table="packing_list_tmp" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_tmp->buyer_po->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->buyer_po->EditValue ?>"<?php echo $packing_list_tmp->buyer_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_quantity"><?php echo $packing_list_tmp->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->quantity->cellAttributes() ?>>
			<span id="el_packing_list_tmp_quantity">
<input type="text" data-table="packing_list_tmp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->quantity->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->quantity->EditValue ?>"<?php echo $packing_list_tmp->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label for="x_size" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_size"><?php echo $packing_list_tmp->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->size->cellAttributes() ?>>
			<span id="el_packing_list_tmp_size">
<input type="text" data-table="packing_list_tmp" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($packing_list_tmp->size->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->size->EditValue ?>"<?php echo $packing_list_tmp->size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_sqm"><?php echo $packing_list_tmp->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->sqm->cellAttributes() ?>>
			<span id="el_packing_list_tmp_sqm">
<input type="text" data-table="packing_list_tmp" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->sqm->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->sqm->EditValue ?>"<?php echo $packing_list_tmp->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_amount"><?php echo $packing_list_tmp->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->amount->cellAttributes() ?>>
			<span id="el_packing_list_tmp_amount">
<input type="text" data-table="packing_list_tmp" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->amount->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->amount->EditValue ?>"<?php echo $packing_list_tmp->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_currency"><?php echo $packing_list_tmp->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->currency->cellAttributes() ?>>
			<span id="el_packing_list_tmp_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_list_tmp" data-field="x_currency" data-value-separator="<?php echo $packing_list_tmp->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $packing_list_tmp->currency->editAttributes() ?>>
		<?php echo $packing_list_tmp->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $packing_list_tmp->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_price"><?php echo $packing_list_tmp->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->price->cellAttributes() ?>>
			<span id="el_packing_list_tmp_price">
<input type="text" data-table="packing_list_tmp" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->price->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->price->EditValue ?>"<?php echo $packing_list_tmp->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->discount->Visible) { // discount ?>
	<div id="r_discount" class="form-group row">
		<label for="x_discount" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_discount"><?php echo $packing_list_tmp->discount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_discount" id="z_discount" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->discount->cellAttributes() ?>>
			<span id="el_packing_list_tmp_discount">
<input type="text" data-table="packing_list_tmp" data-field="x_discount" name="x_discount" id="x_discount" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->discount->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->discount->EditValue ?>"<?php echo $packing_list_tmp->discount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->hsn->Visible) { // hsn ?>
	<div id="r_hsn" class="form-group row">
		<label for="x_hsn" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_hsn"><?php echo $packing_list_tmp->hsn->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_hsn" id="z_hsn" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->hsn->cellAttributes() ?>>
			<span id="el_packing_list_tmp_hsn">
<input type="text" data-table="packing_list_tmp" data-field="x_hsn" name="x_hsn" id="x_hsn" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($packing_list_tmp->hsn->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->hsn->EditValue ?>"<?php echo $packing_list_tmp->hsn->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label for="x_gst" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_gst"><?php echo $packing_list_tmp->gst->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gst" id="z_gst" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->gst->cellAttributes() ?>>
			<span id="el_packing_list_tmp_gst">
<input type="text" data-table="packing_list_tmp" data-field="x_gst" name="x_gst" id="x_gst" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->gst->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->gst->EditValue ?>"<?php echo $packing_list_tmp->gst->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->composition->Visible) { // composition ?>
	<div id="r_composition" class="form-group row">
		<label for="x_composition" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_composition"><?php echo $packing_list_tmp->composition->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_composition" id="z_composition" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->composition->cellAttributes() ?>>
			<span id="el_packing_list_tmp_composition">
<input type="text" data-table="packing_list_tmp" data-field="x_composition" name="x_composition" id="x_composition" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($packing_list_tmp->composition->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->composition->EditValue ?>"<?php echo $packing_list_tmp->composition->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->price_exchange->Visible) { // price_exchange ?>
	<div id="r_price_exchange" class="form-group row">
		<label for="x_price_exchange" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_price_exchange"><?php echo $packing_list_tmp->price_exchange->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price_exchange" id="z_price_exchange" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->price_exchange->cellAttributes() ?>>
			<span id="el_packing_list_tmp_price_exchange">
<input type="text" data-table="packing_list_tmp" data-field="x_price_exchange" name="x_price_exchange" id="x_price_exchange" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->price_exchange->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->price_exchange->EditValue ?>"<?php echo $packing_list_tmp->price_exchange->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->amount_exchange->Visible) { // amount_exchange ?>
	<div id="r_amount_exchange" class="form-group row">
		<label for="x_amount_exchange" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_amount_exchange"><?php echo $packing_list_tmp->amount_exchange->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount_exchange" id="z_amount_exchange" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->amount_exchange->cellAttributes() ?>>
			<span id="el_packing_list_tmp_amount_exchange">
<input type="text" data-table="packing_list_tmp" data-field="x_amount_exchange" name="x_amount_exchange" id="x_amount_exchange" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->amount_exchange->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->amount_exchange->EditValue ?>"<?php echo $packing_list_tmp->amount_exchange->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->design_code->Visible) { // design_code ?>
	<div id="r_design_code" class="form-group row">
		<label for="x_design_code" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_design_code"><?php echo $packing_list_tmp->design_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_code" id="z_design_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->design_code->cellAttributes() ?>>
			<span id="el_packing_list_tmp_design_code">
<input type="text" data-table="packing_list_tmp" data-field="x_design_code" name="x_design_code" id="x_design_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($packing_list_tmp->design_code->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->design_code->EditValue ?>"<?php echo $packing_list_tmp->design_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_cbm"><?php echo $packing_list_tmp->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->cbm->cellAttributes() ?>>
			<span id="el_packing_list_tmp_cbm">
<input type="text" data-table="packing_list_tmp" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->cbm->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->cbm->EditValue ?>"<?php echo $packing_list_tmp->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->weight->Visible) { // weight ?>
	<div id="r_weight" class="form-group row">
		<label for="x_weight" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_weight"><?php echo $packing_list_tmp->weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight" id="z_weight" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->weight->cellAttributes() ?>>
			<span id="el_packing_list_tmp_weight">
<input type="text" data-table="packing_list_tmp" data-field="x_weight" name="x_weight" id="x_weight" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->weight->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->weight->EditValue ?>"<?php echo $packing_list_tmp->weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->sqm_a->Visible) { // sqm_a ?>
	<div id="r_sqm_a" class="form-group row">
		<label for="x_sqm_a" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_sqm_a"><?php echo $packing_list_tmp->sqm_a->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm_a" id="z_sqm_a" value="="></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->sqm_a->cellAttributes() ?>>
			<span id="el_packing_list_tmp_sqm_a">
<input type="text" data-table="packing_list_tmp" data-field="x_sqm_a" name="x_sqm_a" id="x_sqm_a" size="30" placeholder="<?php echo HtmlEncode($packing_list_tmp->sqm_a->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->sqm_a->EditValue ?>"<?php echo $packing_list_tmp->sqm_a->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_list_tmp->partner_other_ref->Visible) { // partner_other_ref ?>
	<div id="r_partner_other_ref" class="form-group row">
		<label for="x_partner_other_ref" class="<?php echo $packing_list_tmp_search->LeftColumnClass ?>"><span id="elh_packing_list_tmp_partner_other_ref"><?php echo $packing_list_tmp->partner_other_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_other_ref" id="z_partner_other_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_list_tmp_search->RightColumnClass ?>"><div<?php echo $packing_list_tmp->partner_other_ref->cellAttributes() ?>>
			<span id="el_packing_list_tmp_partner_other_ref">
<input type="text" data-table="packing_list_tmp" data-field="x_partner_other_ref" name="x_partner_other_ref" id="x_partner_other_ref" size="35" placeholder="<?php echo HtmlEncode($packing_list_tmp->partner_other_ref->getPlaceHolder()) ?>" value="<?php echo $packing_list_tmp->partner_other_ref->EditValue ?>"<?php echo $packing_list_tmp->partner_other_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$packing_list_tmp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $packing_list_tmp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$packing_list_tmp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$packing_list_tmp_search->terminate();
?>