<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_list_list = new packing_list_list();

// Run the page
$packing_list_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_list_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_list->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpacking_listlist = currentForm = new ew.Form("fpacking_listlist", "list");
fpacking_listlist.formKeyCountName = '<?php echo $packing_list_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpacking_listlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_listlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_listlist.lists["x_buyers_id"] = <?php echo $packing_list_list->buyers_id->Lookup->toClientList() ?>;
fpacking_listlist.lists["x_buyers_id"].options = <?php echo JsonEncode($packing_list_list->buyers_id->lookupOptions()) ?>;
fpacking_listlist.lists["x_design"] = <?php echo $packing_list_list->design->Lookup->toClientList() ?>;
fpacking_listlist.lists["x_design"].options = <?php echo JsonEncode($packing_list_list->design->lookupOptions()) ?>;
fpacking_listlist.autoSuggests["x_design"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_listlist.lists["x_buyer_ref"] = <?php echo $packing_list_list->buyer_ref->Lookup->toClientList() ?>;
fpacking_listlist.lists["x_buyer_ref"].options = <?php echo JsonEncode($packing_list_list->buyer_ref->lookupOptions()) ?>;
fpacking_listlist.lists["x_currency"] = <?php echo $packing_list_list->currency->Lookup->toClientList() ?>;
fpacking_listlist.lists["x_currency"].options = <?php echo JsonEncode($packing_list_list->currency->lookupOptions()) ?>;

// Form object for search
var fpacking_listlistsrch = currentSearchForm = new ew.Form("fpacking_listlistsrch");

// Filters
fpacking_listlistsrch.filterList = <?php echo $packing_list_list->getFilterList() ?>;

// Init search panel as collapsed
fpacking_listlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($packing_list_list->TotalRecs > 0 && $packing_list_list->ExportOptions->visible()) { ?>
<?php $packing_list_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_list->ImportOptions->visible()) { ?>
<?php $packing_list_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_list->SearchOptions->visible()) { ?>
<?php $packing_list_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($packing_list_list->FilterOptions->visible()) { ?>
<?php $packing_list_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$packing_list_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$packing_list->isExport() && !$packing_list->CurrentAction) { ?>
<form name="fpacking_listlistsrch" id="fpacking_listlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($packing_list_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpacking_listlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="packing_list">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($packing_list_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($packing_list_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $packing_list_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($packing_list_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($packing_list_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($packing_list_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($packing_list_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $packing_list_list->showPageHeader(); ?>
<?php
$packing_list_list->showMessage();
?>
<?php if ($packing_list_list->TotalRecs > 0 || $packing_list->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($packing_list_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> packing_list">
<?php if (!$packing_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$packing_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_list_list->Pager)) $packing_list_list->Pager = new PrevNextPager($packing_list_list->StartRec, $packing_list_list->DisplayRecs, $packing_list_list->TotalRecs, $packing_list_list->AutoHidePager) ?>
<?php if ($packing_list_list->Pager->RecordCount > 0 && $packing_list_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_list_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_list_list->pageUrl() ?>start=<?php echo $packing_list_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_list_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_list_list->pageUrl() ?>start=<?php echo $packing_list_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_list_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_list_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_list_list->pageUrl() ?>start=<?php echo $packing_list_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_list_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_list_list->pageUrl() ?>start=<?php echo $packing_list_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_list_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_list_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_list_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_list_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_list_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_list_list->TotalRecs > 0 && (!$packing_list_list->AutoHidePageSizeSelector || $packing_list_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_list">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($packing_list_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_list_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_list_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($packing_list->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_list_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpacking_listlist" id="fpacking_listlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_list_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_list_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_list">
<div id="gmp_packing_list" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($packing_list_list->TotalRecs > 0 || $packing_list->isGridEdit()) { ?>
<table id="tbl_packing_listlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$packing_list_list->RowType = ROWTYPE_HEADER;

// Render list options
$packing_list_list->renderListOptions();

// Render list options (header, left)
$packing_list_list->ListOptions->render("header", "left");
?>
<?php if ($packing_list->id->Visible) { // id ?>
	<?php if ($packing_list->sortUrl($packing_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $packing_list->id->headerCellClass() ?>"><div id="elh_packing_list_id" class="packing_list_id"><div class="ew-table-header-caption"><?php echo $packing_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $packing_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->id) ?>',2);"><div id="elh_packing_list_id" class="packing_list_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->pl_no->Visible) { // pl_no ?>
	<?php if ($packing_list->sortUrl($packing_list->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $packing_list->pl_no->headerCellClass() ?>"><div id="elh_packing_list_pl_no" class="packing_list_pl_no"><div class="ew-table-header-caption"><?php echo $packing_list->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $packing_list->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->pl_no) ?>',2);"><div id="elh_packing_list_pl_no" class="packing_list_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->pl_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->buyers_id->Visible) { // buyers_id ?>
	<?php if ($packing_list->sortUrl($packing_list->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $packing_list->buyers_id->headerCellClass() ?>"><div id="elh_packing_list_buyers_id" class="packing_list_buyers_id"><div class="ew-table-header-caption"><?php echo $packing_list->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $packing_list->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->buyers_id) ?>',2);"><div id="elh_packing_list_buyers_id" class="packing_list_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->_barcode->Visible) { // barcode ?>
	<?php if ($packing_list->sortUrl($packing_list->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $packing_list->_barcode->headerCellClass() ?>"><div id="elh_packing_list__barcode" class="packing_list__barcode"><div class="ew-table-header-caption"><?php echo $packing_list->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $packing_list->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->_barcode) ?>',2);"><div id="elh_packing_list__barcode" class="packing_list__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->roll_no->Visible) { // roll_no ?>
	<?php if ($packing_list->sortUrl($packing_list->roll_no) == "") { ?>
		<th data-name="roll_no" class="<?php echo $packing_list->roll_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_packing_list_roll_no" class="packing_list_roll_no"><div class="ew-table-header-caption"><?php echo $packing_list->roll_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="roll_no" class="<?php echo $packing_list->roll_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->roll_no) ?>',2);"><div id="elh_packing_list_roll_no" class="packing_list_roll_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->roll_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->roll_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->roll_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->no_of_bales->Visible) { // no_of_bales ?>
	<?php if ($packing_list->sortUrl($packing_list->no_of_bales) == "") { ?>
		<th data-name="no_of_bales" class="<?php echo $packing_list->no_of_bales->headerCellClass() ?>"><div id="elh_packing_list_no_of_bales" class="packing_list_no_of_bales"><div class="ew-table-header-caption"><?php echo $packing_list->no_of_bales->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_of_bales" class="<?php echo $packing_list->no_of_bales->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->no_of_bales) ?>',2);"><div id="elh_packing_list_no_of_bales" class="packing_list_no_of_bales">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->no_of_bales->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->no_of_bales->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->no_of_bales->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->design->Visible) { // design ?>
	<?php if ($packing_list->sortUrl($packing_list->design) == "") { ?>
		<th data-name="design" class="<?php echo $packing_list->design->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_packing_list_design" class="packing_list_design"><div class="ew-table-header-caption"><?php echo $packing_list->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $packing_list->design->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->design) ?>',2);"><div id="elh_packing_list_design" class="packing_list_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($packing_list->sortUrl($packing_list->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $packing_list->buyer_ref->headerCellClass() ?>"><div id="elh_packing_list_buyer_ref" class="packing_list_buyer_ref"><div class="ew-table-header-caption"><?php echo $packing_list->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $packing_list->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->buyer_ref) ?>',2);"><div id="elh_packing_list_buyer_ref" class="packing_list_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->buyer_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->buyer_code->Visible) { // buyer_code ?>
	<?php if ($packing_list->sortUrl($packing_list->buyer_code) == "") { ?>
		<th data-name="buyer_code" class="<?php echo $packing_list->buyer_code->headerCellClass() ?>"><div id="elh_packing_list_buyer_code" class="packing_list_buyer_code"><div class="ew-table-header-caption"><?php echo $packing_list->buyer_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_code" class="<?php echo $packing_list->buyer_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->buyer_code) ?>',2);"><div id="elh_packing_list_buyer_code" class="packing_list_buyer_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->buyer_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list->buyer_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->buyer_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->buyer_po->Visible) { // buyer_po ?>
	<?php if ($packing_list->sortUrl($packing_list->buyer_po) == "") { ?>
		<th data-name="buyer_po" class="<?php echo $packing_list->buyer_po->headerCellClass() ?>"><div id="elh_packing_list_buyer_po" class="packing_list_buyer_po"><div class="ew-table-header-caption"><?php echo $packing_list->buyer_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_po" class="<?php echo $packing_list->buyer_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->buyer_po) ?>',2);"><div id="elh_packing_list_buyer_po" class="packing_list_buyer_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->buyer_po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list->buyer_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->buyer_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->quantity->Visible) { // quantity ?>
	<?php if ($packing_list->sortUrl($packing_list->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $packing_list->quantity->headerCellClass() ?>"><div id="elh_packing_list_quantity" class="packing_list_quantity"><div class="ew-table-header-caption"><?php echo $packing_list->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $packing_list->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->quantity) ?>',2);"><div id="elh_packing_list_quantity" class="packing_list_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->size->Visible) { // size ?>
	<?php if ($packing_list->sortUrl($packing_list->size) == "") { ?>
		<th data-name="size" class="<?php echo $packing_list->size->headerCellClass() ?>"><div id="elh_packing_list_size" class="packing_list_size"><div class="ew-table-header-caption"><?php echo $packing_list->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $packing_list->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->size) ?>',2);"><div id="elh_packing_list_size" class="packing_list_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->sqm->Visible) { // sqm ?>
	<?php if ($packing_list->sortUrl($packing_list->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $packing_list->sqm->headerCellClass() ?>"><div id="elh_packing_list_sqm" class="packing_list_sqm"><div class="ew-table-header-caption"><?php echo $packing_list->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $packing_list->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->sqm) ?>',2);"><div id="elh_packing_list_sqm" class="packing_list_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->price->Visible) { // price ?>
	<?php if ($packing_list->sortUrl($packing_list->price) == "") { ?>
		<th data-name="price" class="<?php echo $packing_list->price->headerCellClass() ?>"><div id="elh_packing_list_price" class="packing_list_price"><div class="ew-table-header-caption"><?php echo $packing_list->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $packing_list->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->price) ?>',2);"><div id="elh_packing_list_price" class="packing_list_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->discount->Visible) { // discount ?>
	<?php if ($packing_list->sortUrl($packing_list->discount) == "") { ?>
		<th data-name="discount" class="<?php echo $packing_list->discount->headerCellClass() ?>"><div id="elh_packing_list_discount" class="packing_list_discount"><div class="ew-table-header-caption"><?php echo $packing_list->discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="discount" class="<?php echo $packing_list->discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->discount) ?>',2);"><div id="elh_packing_list_discount" class="packing_list_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->amount->Visible) { // amount ?>
	<?php if ($packing_list->sortUrl($packing_list->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $packing_list->amount->headerCellClass() ?>"><div id="elh_packing_list_amount" class="packing_list_amount"><div class="ew-table-header-caption"><?php echo $packing_list->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $packing_list->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->amount) ?>',2);"><div id="elh_packing_list_amount" class="packing_list_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->currency->Visible) { // currency ?>
	<?php if ($packing_list->sortUrl($packing_list->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $packing_list->currency->headerCellClass() ?>"><div id="elh_packing_list_currency" class="packing_list_currency"><div class="ew-table-header-caption"><?php echo $packing_list->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $packing_list->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->currency) ?>',2);"><div id="elh_packing_list_currency" class="packing_list_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->composition->Visible) { // composition ?>
	<?php if ($packing_list->sortUrl($packing_list->composition) == "") { ?>
		<th data-name="composition" class="<?php echo $packing_list->composition->headerCellClass() ?>"><div id="elh_packing_list_composition" class="packing_list_composition"><div class="ew-table-header-caption"><?php echo $packing_list->composition->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="composition" class="<?php echo $packing_list->composition->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->composition) ?>',2);"><div id="elh_packing_list_composition" class="packing_list_composition">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->composition->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list->composition->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->composition->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->hsn->Visible) { // hsn ?>
	<?php if ($packing_list->sortUrl($packing_list->hsn) == "") { ?>
		<th data-name="hsn" class="<?php echo $packing_list->hsn->headerCellClass() ?>"><div id="elh_packing_list_hsn" class="packing_list_hsn"><div class="ew-table-header-caption"><?php echo $packing_list->hsn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="hsn" class="<?php echo $packing_list->hsn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->hsn) ?>',2);"><div id="elh_packing_list_hsn" class="packing_list_hsn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->hsn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_list->hsn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->hsn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->gst->Visible) { // gst ?>
	<?php if ($packing_list->sortUrl($packing_list->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $packing_list->gst->headerCellClass() ?>"><div id="elh_packing_list_gst" class="packing_list_gst"><div class="ew-table-header-caption"><?php echo $packing_list->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $packing_list->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->gst) ?>',2);"><div id="elh_packing_list_gst" class="packing_list_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->gst->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->price_exchange->Visible) { // price_exchange ?>
	<?php if ($packing_list->sortUrl($packing_list->price_exchange) == "") { ?>
		<th data-name="price_exchange" class="<?php echo $packing_list->price_exchange->headerCellClass() ?>"><div id="elh_packing_list_price_exchange" class="packing_list_price_exchange"><div class="ew-table-header-caption"><?php echo $packing_list->price_exchange->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_exchange" class="<?php echo $packing_list->price_exchange->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->price_exchange) ?>',2);"><div id="elh_packing_list_price_exchange" class="packing_list_price_exchange">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->price_exchange->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->price_exchange->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->price_exchange->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->amount_exchange->Visible) { // amount_exchange ?>
	<?php if ($packing_list->sortUrl($packing_list->amount_exchange) == "") { ?>
		<th data-name="amount_exchange" class="<?php echo $packing_list->amount_exchange->headerCellClass() ?>"><div id="elh_packing_list_amount_exchange" class="packing_list_amount_exchange"><div class="ew-table-header-caption"><?php echo $packing_list->amount_exchange->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount_exchange" class="<?php echo $packing_list->amount_exchange->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->amount_exchange) ?>',2);"><div id="elh_packing_list_amount_exchange" class="packing_list_amount_exchange">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->amount_exchange->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->amount_exchange->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->amount_exchange->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->cbm->Visible) { // cbm ?>
	<?php if ($packing_list->sortUrl($packing_list->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $packing_list->cbm->headerCellClass() ?>"><div id="elh_packing_list_cbm" class="packing_list_cbm"><div class="ew-table-header-caption"><?php echo $packing_list->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $packing_list->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->cbm) ?>',2);"><div id="elh_packing_list_cbm" class="packing_list_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->cbm->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->weight->Visible) { // weight ?>
	<?php if ($packing_list->sortUrl($packing_list->weight) == "") { ?>
		<th data-name="weight" class="<?php echo $packing_list->weight->headerCellClass() ?>"><div id="elh_packing_list_weight" class="packing_list_weight"><div class="ew-table-header-caption"><?php echo $packing_list->weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight" class="<?php echo $packing_list->weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->weight) ?>',2);"><div id="elh_packing_list_weight" class="packing_list_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->sqm_a->Visible) { // sqm_a ?>
	<?php if ($packing_list->sortUrl($packing_list->sqm_a) == "") { ?>
		<th data-name="sqm_a" class="<?php echo $packing_list->sqm_a->headerCellClass() ?>"><div id="elh_packing_list_sqm_a" class="packing_list_sqm_a"><div class="ew-table-header-caption"><?php echo $packing_list->sqm_a->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_a" class="<?php echo $packing_list->sqm_a->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->sqm_a) ?>',2);"><div id="elh_packing_list_sqm_a" class="packing_list_sqm_a">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->sqm_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->sqm_a->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->sqm_a->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->price_a->Visible) { // price_a ?>
	<?php if ($packing_list->sortUrl($packing_list->price_a) == "") { ?>
		<th data-name="price_a" class="<?php echo $packing_list->price_a->headerCellClass() ?>"><div id="elh_packing_list_price_a" class="packing_list_price_a"><div class="ew-table-header-caption"><?php echo $packing_list->price_a->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_a" class="<?php echo $packing_list->price_a->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->price_a) ?>',2);"><div id="elh_packing_list_price_a" class="packing_list_price_a">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->price_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->price_a->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->price_a->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_list->price_exchange_a->Visible) { // price_exchange_a ?>
	<?php if ($packing_list->sortUrl($packing_list->price_exchange_a) == "") { ?>
		<th data-name="price_exchange_a" class="<?php echo $packing_list->price_exchange_a->headerCellClass() ?>"><div id="elh_packing_list_price_exchange_a" class="packing_list_price_exchange_a"><div class="ew-table-header-caption"><?php echo $packing_list->price_exchange_a->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_exchange_a" class="<?php echo $packing_list->price_exchange_a->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_list->SortUrl($packing_list->price_exchange_a) ?>',2);"><div id="elh_packing_list_price_exchange_a" class="packing_list_price_exchange_a">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_list->price_exchange_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_list->price_exchange_a->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_list->price_exchange_a->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$packing_list_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($packing_list->ExportAll && $packing_list->isExport()) {
	$packing_list_list->StopRec = $packing_list_list->TotalRecs;
} else {

	// Set the last record to display
	if ($packing_list_list->TotalRecs > $packing_list_list->StartRec + $packing_list_list->DisplayRecs - 1)
		$packing_list_list->StopRec = $packing_list_list->StartRec + $packing_list_list->DisplayRecs - 1;
	else
		$packing_list_list->StopRec = $packing_list_list->TotalRecs;
}
$packing_list_list->RecCnt = $packing_list_list->StartRec - 1;
if ($packing_list_list->Recordset && !$packing_list_list->Recordset->EOF) {
	$packing_list_list->Recordset->moveFirst();
	$selectLimit = $packing_list_list->UseSelectLimit;
	if (!$selectLimit && $packing_list_list->StartRec > 1)
		$packing_list_list->Recordset->move($packing_list_list->StartRec - 1);
} elseif (!$packing_list->AllowAddDeleteRow && $packing_list_list->StopRec == 0) {
	$packing_list_list->StopRec = $packing_list->GridAddRowCount;
}

// Initialize aggregate
$packing_list->RowType = ROWTYPE_AGGREGATEINIT;
$packing_list->resetAttributes();
$packing_list_list->renderRow();
while ($packing_list_list->RecCnt < $packing_list_list->StopRec) {
	$packing_list_list->RecCnt++;
	if ($packing_list_list->RecCnt >= $packing_list_list->StartRec) {
		$packing_list_list->RowCnt++;

		// Set up key count
		$packing_list_list->KeyCount = $packing_list_list->RowIndex;

		// Init row class and style
		$packing_list->resetAttributes();
		$packing_list->CssClass = "";
		if ($packing_list->isGridAdd()) {
		} else {
			$packing_list_list->loadRowValues($packing_list_list->Recordset); // Load row values
		}
		$packing_list->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$packing_list->RowAttrs = array_merge($packing_list->RowAttrs, array('data-rowindex'=>$packing_list_list->RowCnt, 'id'=>'r' . $packing_list_list->RowCnt . '_packing_list', 'data-rowtype'=>$packing_list->RowType));

		// Render row
		$packing_list_list->renderRow();

		// Render list options
		$packing_list_list->renderListOptions();
?>
	<tr<?php echo $packing_list->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_list_list->ListOptions->render("body", "left", $packing_list_list->RowCnt);
?>
	<?php if ($packing_list->id->Visible) { // id ?>
		<td data-name="id"<?php echo $packing_list->id->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_id" class="packing_list_id">
<span<?php echo $packing_list->id->viewAttributes() ?>>
<?php echo $packing_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $packing_list->pl_no->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_pl_no" class="packing_list_pl_no">
<span<?php echo $packing_list->pl_no->viewAttributes() ?>>
<?php echo $packing_list->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $packing_list->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_buyers_id" class="packing_list_buyers_id">
<span<?php echo $packing_list->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list->buyers_id->getViewValue())) && $packing_list->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list->buyers_id->linkAttributes() ?>><?php echo $packing_list->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $packing_list->_barcode->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list__barcode" class="packing_list__barcode">
<span<?php echo $packing_list->_barcode->viewAttributes() ?>>
<?php echo $packing_list->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no"<?php echo $packing_list->roll_no->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_roll_no" class="packing_list_roll_no">
<span<?php echo $packing_list->roll_no->viewAttributes() ?>>
<?php echo $packing_list->roll_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->no_of_bales->Visible) { // no_of_bales ?>
		<td data-name="no_of_bales"<?php echo $packing_list->no_of_bales->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_no_of_bales" class="packing_list_no_of_bales">
<span<?php echo $packing_list->no_of_bales->viewAttributes() ?>>
<?php echo $packing_list->no_of_bales->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->design->Visible) { // design ?>
		<td data-name="design"<?php echo $packing_list->design->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_design" class="packing_list_design">
<span<?php echo $packing_list->design->viewAttributes() ?>>
<?php echo $packing_list->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $packing_list->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_buyer_ref" class="packing_list_buyer_ref">
<span<?php echo $packing_list->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list->buyer_ref->getViewValue())) && $packing_list->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $packing_list->buyer_ref->linkAttributes() ?>><?php echo $packing_list->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->buyer_code->Visible) { // buyer_code ?>
		<td data-name="buyer_code"<?php echo $packing_list->buyer_code->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_buyer_code" class="packing_list_buyer_code">
<span<?php echo $packing_list->buyer_code->viewAttributes() ?>>
<?php echo $packing_list->buyer_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po"<?php echo $packing_list->buyer_po->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_buyer_po" class="packing_list_buyer_po">
<span<?php echo $packing_list->buyer_po->viewAttributes() ?>>
<?php echo $packing_list->buyer_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $packing_list->quantity->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_quantity" class="packing_list_quantity">
<span<?php echo $packing_list->quantity->viewAttributes() ?>>
<?php echo $packing_list->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->size->Visible) { // size ?>
		<td data-name="size"<?php echo $packing_list->size->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_size" class="packing_list_size">
<span<?php echo $packing_list->size->viewAttributes() ?>>
<?php echo $packing_list->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $packing_list->sqm->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_sqm" class="packing_list_sqm">
<span<?php echo $packing_list->sqm->viewAttributes() ?>>
<?php echo $packing_list->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->price->Visible) { // price ?>
		<td data-name="price"<?php echo $packing_list->price->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_price" class="packing_list_price">
<span<?php echo $packing_list->price->viewAttributes() ?>>
<?php echo $packing_list->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->discount->Visible) { // discount ?>
		<td data-name="discount"<?php echo $packing_list->discount->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_discount" class="packing_list_discount">
<span<?php echo $packing_list->discount->viewAttributes() ?>>
<?php echo $packing_list->discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $packing_list->amount->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_amount" class="packing_list_amount">
<span<?php echo $packing_list->amount->viewAttributes() ?>>
<?php echo $packing_list->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $packing_list->currency->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_currency" class="packing_list_currency">
<span<?php echo $packing_list->currency->viewAttributes() ?>>
<?php echo $packing_list->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->composition->Visible) { // composition ?>
		<td data-name="composition"<?php echo $packing_list->composition->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_composition" class="packing_list_composition">
<span<?php echo $packing_list->composition->viewAttributes() ?>>
<?php echo $packing_list->composition->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->hsn->Visible) { // hsn ?>
		<td data-name="hsn"<?php echo $packing_list->hsn->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_hsn" class="packing_list_hsn">
<span<?php echo $packing_list->hsn->viewAttributes() ?>>
<?php echo $packing_list->hsn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $packing_list->gst->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_gst" class="packing_list_gst">
<span<?php echo $packing_list->gst->viewAttributes() ?>>
<?php echo $packing_list->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->price_exchange->Visible) { // price_exchange ?>
		<td data-name="price_exchange"<?php echo $packing_list->price_exchange->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_price_exchange" class="packing_list_price_exchange">
<span<?php echo $packing_list->price_exchange->viewAttributes() ?>>
<?php echo $packing_list->price_exchange->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->amount_exchange->Visible) { // amount_exchange ?>
		<td data-name="amount_exchange"<?php echo $packing_list->amount_exchange->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_amount_exchange" class="packing_list_amount_exchange">
<span<?php echo $packing_list->amount_exchange->viewAttributes() ?>>
<?php echo $packing_list->amount_exchange->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $packing_list->cbm->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_cbm" class="packing_list_cbm">
<span<?php echo $packing_list->cbm->viewAttributes() ?>>
<?php echo $packing_list->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->weight->Visible) { // weight ?>
		<td data-name="weight"<?php echo $packing_list->weight->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_weight" class="packing_list_weight">
<span<?php echo $packing_list->weight->viewAttributes() ?>>
<?php echo $packing_list->weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a"<?php echo $packing_list->sqm_a->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_sqm_a" class="packing_list_sqm_a">
<span<?php echo $packing_list->sqm_a->viewAttributes() ?>>
<?php echo $packing_list->sqm_a->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->price_a->Visible) { // price_a ?>
		<td data-name="price_a"<?php echo $packing_list->price_a->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_price_a" class="packing_list_price_a">
<span<?php echo $packing_list->price_a->viewAttributes() ?>>
<?php echo $packing_list->price_a->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_list->price_exchange_a->Visible) { // price_exchange_a ?>
		<td data-name="price_exchange_a"<?php echo $packing_list->price_exchange_a->cellAttributes() ?>>
<span id="el<?php echo $packing_list_list->RowCnt ?>_packing_list_price_exchange_a" class="packing_list_price_exchange_a">
<span<?php echo $packing_list->price_exchange_a->viewAttributes() ?>>
<?php echo $packing_list->price_exchange_a->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_list_list->ListOptions->render("body", "right", $packing_list_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$packing_list->isGridAdd())
		$packing_list_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$packing_list->RowType = ROWTYPE_AGGREGATE;
$packing_list->resetAttributes();
$packing_list_list->renderRow();
?>
<?php if ($packing_list_list->TotalRecs > 0 && !$packing_list->isGridAdd() && !$packing_list->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$packing_list_list->renderListOptions();

// Render list options (footer, left)
$packing_list_list->ListOptions->render("footer", "left");
?>
	<?php if ($packing_list->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $packing_list->id->footerCellClass() ?>"><span id="elf_packing_list_id" class="packing_list_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no" class="<?php echo $packing_list->pl_no->footerCellClass() ?>"><span id="elf_packing_list_pl_no" class="packing_list_pl_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $packing_list->buyers_id->footerCellClass() ?>"><span id="elf_packing_list_buyers_id" class="packing_list_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $packing_list->_barcode->footerCellClass() ?>"><span id="elf_packing_list__barcode" class="packing_list__barcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->roll_no->Visible) { // roll_no ?>
		<td data-name="roll_no" class="<?php echo $packing_list->roll_no->footerCellClass() ?>"><span id="elf_packing_list_roll_no" class="packing_list_roll_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->no_of_bales->Visible) { // no_of_bales ?>
		<td data-name="no_of_bales" class="<?php echo $packing_list->no_of_bales->footerCellClass() ?>"><span id="elf_packing_list_no_of_bales" class="packing_list_no_of_bales">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list->no_of_bales->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list->design->Visible) { // design ?>
		<td data-name="design" class="<?php echo $packing_list->design->footerCellClass() ?>"><span id="elf_packing_list_design" class="packing_list_design">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref" class="<?php echo $packing_list->buyer_ref->footerCellClass() ?>"><span id="elf_packing_list_buyer_ref" class="packing_list_buyer_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->buyer_code->Visible) { // buyer_code ?>
		<td data-name="buyer_code" class="<?php echo $packing_list->buyer_code->footerCellClass() ?>"><span id="elf_packing_list_buyer_code" class="packing_list_buyer_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po" class="<?php echo $packing_list->buyer_po->footerCellClass() ?>"><span id="elf_packing_list_buyer_po" class="packing_list_buyer_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $packing_list->quantity->footerCellClass() ?>"><span id="elf_packing_list_quantity" class="packing_list_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list->size->Visible) { // size ?>
		<td data-name="size" class="<?php echo $packing_list->size->footerCellClass() ?>"><span id="elf_packing_list_size" class="packing_list_size">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $packing_list->sqm->footerCellClass() ?>"><span id="elf_packing_list_sqm" class="packing_list_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list->price->Visible) { // price ?>
		<td data-name="price" class="<?php echo $packing_list->price->footerCellClass() ?>"><span id="elf_packing_list_price" class="packing_list_price">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->discount->Visible) { // discount ?>
		<td data-name="discount" class="<?php echo $packing_list->discount->footerCellClass() ?>"><span id="elf_packing_list_discount" class="packing_list_discount">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $packing_list->amount->footerCellClass() ?>"><span id="elf_packing_list_amount" class="packing_list_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_list->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_list->currency->Visible) { // currency ?>
		<td data-name="currency" class="<?php echo $packing_list->currency->footerCellClass() ?>"><span id="elf_packing_list_currency" class="packing_list_currency">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->composition->Visible) { // composition ?>
		<td data-name="composition" class="<?php echo $packing_list->composition->footerCellClass() ?>"><span id="elf_packing_list_composition" class="packing_list_composition">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->hsn->Visible) { // hsn ?>
		<td data-name="hsn" class="<?php echo $packing_list->hsn->footerCellClass() ?>"><span id="elf_packing_list_hsn" class="packing_list_hsn">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->gst->Visible) { // gst ?>
		<td data-name="gst" class="<?php echo $packing_list->gst->footerCellClass() ?>"><span id="elf_packing_list_gst" class="packing_list_gst">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->price_exchange->Visible) { // price_exchange ?>
		<td data-name="price_exchange" class="<?php echo $packing_list->price_exchange->footerCellClass() ?>"><span id="elf_packing_list_price_exchange" class="packing_list_price_exchange">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->amount_exchange->Visible) { // amount_exchange ?>
		<td data-name="amount_exchange" class="<?php echo $packing_list->amount_exchange->footerCellClass() ?>"><span id="elf_packing_list_amount_exchange" class="packing_list_amount_exchange">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->cbm->Visible) { // cbm ?>
		<td data-name="cbm" class="<?php echo $packing_list->cbm->footerCellClass() ?>"><span id="elf_packing_list_cbm" class="packing_list_cbm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->weight->Visible) { // weight ?>
		<td data-name="weight" class="<?php echo $packing_list->weight->footerCellClass() ?>"><span id="elf_packing_list_weight" class="packing_list_weight">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a" class="<?php echo $packing_list->sqm_a->footerCellClass() ?>"><span id="elf_packing_list_sqm_a" class="packing_list_sqm_a">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->price_a->Visible) { // price_a ?>
		<td data-name="price_a" class="<?php echo $packing_list->price_a->footerCellClass() ?>"><span id="elf_packing_list_price_a" class="packing_list_price_a">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_list->price_exchange_a->Visible) { // price_exchange_a ?>
		<td data-name="price_exchange_a" class="<?php echo $packing_list->price_exchange_a->footerCellClass() ?>"><span id="elf_packing_list_price_exchange_a" class="packing_list_price_exchange_a">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$packing_list_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$packing_list->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($packing_list_list->Recordset)
	$packing_list_list->Recordset->Close();
?>
<?php if (!$packing_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$packing_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_list_list->Pager)) $packing_list_list->Pager = new PrevNextPager($packing_list_list->StartRec, $packing_list_list->DisplayRecs, $packing_list_list->TotalRecs, $packing_list_list->AutoHidePager) ?>
<?php if ($packing_list_list->Pager->RecordCount > 0 && $packing_list_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_list_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_list_list->pageUrl() ?>start=<?php echo $packing_list_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_list_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_list_list->pageUrl() ?>start=<?php echo $packing_list_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_list_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_list_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_list_list->pageUrl() ?>start=<?php echo $packing_list_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_list_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_list_list->pageUrl() ?>start=<?php echo $packing_list_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_list_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_list_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_list_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_list_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_list_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_list_list->TotalRecs > 0 && (!$packing_list_list->AutoHidePageSizeSelector || $packing_list_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_list">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($packing_list_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_list_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_list_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($packing_list->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_list_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($packing_list_list->TotalRecs == 0 && !$packing_list->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $packing_list_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$packing_list_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_list->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$packing_list->isExport()) { ?>
<script>
ew.scrollableTable("gmp_packing_list", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_list_list->terminate();
?>