<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_list_view = new packing_list_view();

// Run the page
$packing_list_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_list_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_list->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpacking_listview = currentForm = new ew.Form("fpacking_listview", "view");

// Form_CustomValidate event
fpacking_listview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_listview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_listview.lists["x_buyers_id"] = <?php echo $packing_list_view->buyers_id->Lookup->toClientList() ?>;
fpacking_listview.lists["x_buyers_id"].options = <?php echo JsonEncode($packing_list_view->buyers_id->lookupOptions()) ?>;
fpacking_listview.lists["x_buyer_ref"] = <?php echo $packing_list_view->buyer_ref->Lookup->toClientList() ?>;
fpacking_listview.lists["x_buyer_ref"].options = <?php echo JsonEncode($packing_list_view->buyer_ref->lookupOptions()) ?>;
fpacking_listview.lists["x_currency"] = <?php echo $packing_list_view->currency->Lookup->toClientList() ?>;
fpacking_listview.lists["x_currency"].options = <?php echo JsonEncode($packing_list_view->currency->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $packing_list_view->ExportOptions->render("body") ?>
<?php $packing_list_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $packing_list_view->showPageHeader(); ?>
<?php
$packing_list_view->showMessage();
?>
<form name="fpacking_listview" id="fpacking_listview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_list_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_list_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_list">
<input type="hidden" name="modal" value="<?php echo (int)$packing_list_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($packing_list->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_id"><?php echo $packing_list->id->caption() ?></span></td>
		<td data-name="id"<?php echo $packing_list->id->cellAttributes() ?>>
<span id="el_packing_list_id">
<span<?php echo $packing_list->id->viewAttributes() ?>>
<?php echo $packing_list->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->pl_no->Visible) { // pl_no ?>
	<tr id="r_pl_no">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_pl_no"><?php echo $packing_list->pl_no->caption() ?></span></td>
		<td data-name="pl_no"<?php echo $packing_list->pl_no->cellAttributes() ?>>
<span id="el_packing_list_pl_no">
<span<?php echo $packing_list->pl_no->viewAttributes() ?>>
<?php echo $packing_list->pl_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->buyers_id->Visible) { // buyers_id ?>
	<tr id="r_buyers_id">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_buyers_id"><?php echo $packing_list->buyers_id->caption() ?></span></td>
		<td data-name="buyers_id"<?php echo $packing_list->buyers_id->cellAttributes() ?>>
<span id="el_packing_list_buyers_id">
<span<?php echo $packing_list->buyers_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list->buyers_id->getViewValue())) && $packing_list->buyers_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_list->buyers_id->linkAttributes() ?>><?php echo $packing_list->buyers_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list->buyers_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list__barcode"><?php echo $packing_list->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $packing_list->_barcode->cellAttributes() ?>>
<span id="el_packing_list__barcode">
<span<?php echo $packing_list->_barcode->viewAttributes() ?>>
<?php echo $packing_list->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->no_of_bales->Visible) { // no_of_bales ?>
	<tr id="r_no_of_bales">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_no_of_bales"><?php echo $packing_list->no_of_bales->caption() ?></span></td>
		<td data-name="no_of_bales"<?php echo $packing_list->no_of_bales->cellAttributes() ?>>
<span id="el_packing_list_no_of_bales">
<span<?php echo $packing_list->no_of_bales->viewAttributes() ?>>
<?php echo $packing_list->no_of_bales->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->buyer_ref->Visible) { // buyer_ref ?>
	<tr id="r_buyer_ref">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_buyer_ref"><?php echo $packing_list->buyer_ref->caption() ?></span></td>
		<td data-name="buyer_ref"<?php echo $packing_list->buyer_ref->cellAttributes() ?>>
<span id="el_packing_list_buyer_ref">
<span<?php echo $packing_list->buyer_ref->viewAttributes() ?>>
<?php if ((!EmptyString($packing_list->buyer_ref->getViewValue())) && $packing_list->buyer_ref->linkAttributes() <> "") { ?>
<a<?php echo $packing_list->buyer_ref->linkAttributes() ?>><?php echo $packing_list->buyer_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_list->buyer_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->buyer_code->Visible) { // buyer_code ?>
	<tr id="r_buyer_code">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_buyer_code"><?php echo $packing_list->buyer_code->caption() ?></span></td>
		<td data-name="buyer_code"<?php echo $packing_list->buyer_code->cellAttributes() ?>>
<span id="el_packing_list_buyer_code">
<span<?php echo $packing_list->buyer_code->viewAttributes() ?>>
<?php echo $packing_list->buyer_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->buyer_po->Visible) { // buyer_po ?>
	<tr id="r_buyer_po">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_buyer_po"><?php echo $packing_list->buyer_po->caption() ?></span></td>
		<td data-name="buyer_po"<?php echo $packing_list->buyer_po->cellAttributes() ?>>
<span id="el_packing_list_buyer_po">
<span<?php echo $packing_list->buyer_po->viewAttributes() ?>>
<?php echo $packing_list->buyer_po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_quantity"><?php echo $packing_list->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $packing_list->quantity->cellAttributes() ?>>
<span id="el_packing_list_quantity">
<span<?php echo $packing_list->quantity->viewAttributes() ?>>
<?php echo $packing_list->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->size->Visible) { // size ?>
	<tr id="r_size">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_size"><?php echo $packing_list->size->caption() ?></span></td>
		<td data-name="size"<?php echo $packing_list->size->cellAttributes() ?>>
<span id="el_packing_list_size">
<span<?php echo $packing_list->size->viewAttributes() ?>>
<?php echo $packing_list->size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_sqm"><?php echo $packing_list->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $packing_list->sqm->cellAttributes() ?>>
<span id="el_packing_list_sqm">
<span<?php echo $packing_list->sqm->viewAttributes() ?>>
<?php echo $packing_list->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->price->Visible) { // price ?>
	<tr id="r_price">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_price"><?php echo $packing_list->price->caption() ?></span></td>
		<td data-name="price"<?php echo $packing_list->price->cellAttributes() ?>>
<span id="el_packing_list_price">
<span<?php echo $packing_list->price->viewAttributes() ?>>
<?php echo $packing_list->price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->discount->Visible) { // discount ?>
	<tr id="r_discount">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_discount"><?php echo $packing_list->discount->caption() ?></span></td>
		<td data-name="discount"<?php echo $packing_list->discount->cellAttributes() ?>>
<span id="el_packing_list_discount">
<span<?php echo $packing_list->discount->viewAttributes() ?>>
<?php echo $packing_list->discount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_amount"><?php echo $packing_list->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $packing_list->amount->cellAttributes() ?>>
<span id="el_packing_list_amount">
<span<?php echo $packing_list->amount->viewAttributes() ?>>
<?php echo $packing_list->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->currency->Visible) { // currency ?>
	<tr id="r_currency">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_currency"><?php echo $packing_list->currency->caption() ?></span></td>
		<td data-name="currency"<?php echo $packing_list->currency->cellAttributes() ?>>
<span id="el_packing_list_currency">
<span<?php echo $packing_list->currency->viewAttributes() ?>>
<?php echo $packing_list->currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->composition->Visible) { // composition ?>
	<tr id="r_composition">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_composition"><?php echo $packing_list->composition->caption() ?></span></td>
		<td data-name="composition"<?php echo $packing_list->composition->cellAttributes() ?>>
<span id="el_packing_list_composition">
<span<?php echo $packing_list->composition->viewAttributes() ?>>
<?php echo $packing_list->composition->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->hsn->Visible) { // hsn ?>
	<tr id="r_hsn">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_hsn"><?php echo $packing_list->hsn->caption() ?></span></td>
		<td data-name="hsn"<?php echo $packing_list->hsn->cellAttributes() ?>>
<span id="el_packing_list_hsn">
<span<?php echo $packing_list->hsn->viewAttributes() ?>>
<?php echo $packing_list->hsn->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->gst->Visible) { // gst ?>
	<tr id="r_gst">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_gst"><?php echo $packing_list->gst->caption() ?></span></td>
		<td data-name="gst"<?php echo $packing_list->gst->cellAttributes() ?>>
<span id="el_packing_list_gst">
<span<?php echo $packing_list->gst->viewAttributes() ?>>
<?php echo $packing_list->gst->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->price_exchange->Visible) { // price_exchange ?>
	<tr id="r_price_exchange">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_price_exchange"><?php echo $packing_list->price_exchange->caption() ?></span></td>
		<td data-name="price_exchange"<?php echo $packing_list->price_exchange->cellAttributes() ?>>
<span id="el_packing_list_price_exchange">
<span<?php echo $packing_list->price_exchange->viewAttributes() ?>>
<?php echo $packing_list->price_exchange->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->amount_exchange->Visible) { // amount_exchange ?>
	<tr id="r_amount_exchange">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_amount_exchange"><?php echo $packing_list->amount_exchange->caption() ?></span></td>
		<td data-name="amount_exchange"<?php echo $packing_list->amount_exchange->cellAttributes() ?>>
<span id="el_packing_list_amount_exchange">
<span<?php echo $packing_list->amount_exchange->viewAttributes() ?>>
<?php echo $packing_list->amount_exchange->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->cbm->Visible) { // cbm ?>
	<tr id="r_cbm">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_cbm"><?php echo $packing_list->cbm->caption() ?></span></td>
		<td data-name="cbm"<?php echo $packing_list->cbm->cellAttributes() ?>>
<span id="el_packing_list_cbm">
<span<?php echo $packing_list->cbm->viewAttributes() ?>>
<?php echo $packing_list->cbm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->weight->Visible) { // weight ?>
	<tr id="r_weight">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_weight"><?php echo $packing_list->weight->caption() ?></span></td>
		<td data-name="weight"<?php echo $packing_list->weight->cellAttributes() ?>>
<span id="el_packing_list_weight">
<span<?php echo $packing_list->weight->viewAttributes() ?>>
<?php echo $packing_list->weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->sqm_a->Visible) { // sqm_a ?>
	<tr id="r_sqm_a">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_sqm_a"><?php echo $packing_list->sqm_a->caption() ?></span></td>
		<td data-name="sqm_a"<?php echo $packing_list->sqm_a->cellAttributes() ?>>
<span id="el_packing_list_sqm_a">
<span<?php echo $packing_list->sqm_a->viewAttributes() ?>>
<?php echo $packing_list->sqm_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->price_a->Visible) { // price_a ?>
	<tr id="r_price_a">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_price_a"><?php echo $packing_list->price_a->caption() ?></span></td>
		<td data-name="price_a"<?php echo $packing_list->price_a->cellAttributes() ?>>
<span id="el_packing_list_price_a">
<span<?php echo $packing_list->price_a->viewAttributes() ?>>
<?php echo $packing_list->price_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->price_exchange_a->Visible) { // price_exchange_a ?>
	<tr id="r_price_exchange_a">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_price_exchange_a"><?php echo $packing_list->price_exchange_a->caption() ?></span></td>
		<td data-name="price_exchange_a"<?php echo $packing_list->price_exchange_a->cellAttributes() ?>>
<span id="el_packing_list_price_exchange_a">
<span<?php echo $packing_list->price_exchange_a->viewAttributes() ?>>
<?php echo $packing_list->price_exchange_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_list->partner_other_ref->Visible) { // partner_other_ref ?>
	<tr id="r_partner_other_ref">
		<td class="<?php echo $packing_list_view->TableLeftColumnClass ?>"><span id="elh_packing_list_partner_other_ref"><?php echo $packing_list->partner_other_ref->caption() ?></span></td>
		<td data-name="partner_other_ref"<?php echo $packing_list->partner_other_ref->cellAttributes() ?>>
<span id="el_packing_list_partner_other_ref">
<span<?php echo $packing_list->partner_other_ref->viewAttributes() ?>>
<?php echo $packing_list->partner_other_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$packing_list_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_list->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_list_view->terminate();
?>