<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_process_f_list = new packing_process_f_list();

// Run the page
$packing_process_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_process_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_process_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpacking_process_flist = currentForm = new ew.Form("fpacking_process_flist", "list");
fpacking_process_flist.formKeyCountName = '<?php echo $packing_process_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpacking_process_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_process_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_process_flist.lists["x_product"] = <?php echo $packing_process_f_list->product->Lookup->toClientList() ?>;
fpacking_process_flist.lists["x_product"].options = <?php echo JsonEncode($packing_process_f_list->product->lookupOptions()) ?>;
fpacking_process_flist.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_process_flist.lists["x_godown"] = <?php echo $packing_process_f_list->godown->Lookup->toClientList() ?>;
fpacking_process_flist.lists["x_godown"].options = <?php echo JsonEncode($packing_process_f_list->godown->lookupOptions()) ?>;
fpacking_process_flist.lists["x_packing_type"] = <?php echo $packing_process_f_list->packing_type->Lookup->toClientList() ?>;
fpacking_process_flist.lists["x_packing_type"].options = <?php echo JsonEncode($packing_process_f_list->packing_type->lookupOptions()) ?>;
fpacking_process_flist.lists["x_status"] = <?php echo $packing_process_f_list->status->Lookup->toClientList() ?>;
fpacking_process_flist.lists["x_status"].options = <?php echo JsonEncode($packing_process_f_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fpacking_process_flistsrch = currentSearchForm = new ew.Form("fpacking_process_flistsrch");

// Validate function for search
fpacking_process_flistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_f->Balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpacking_process_flistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_process_flistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_process_flistsrch.lists["x_product"] = <?php echo $packing_process_f_list->product->Lookup->toClientList() ?>;
fpacking_process_flistsrch.lists["x_product"].options = <?php echo JsonEncode($packing_process_f_list->product->lookupOptions()) ?>;
fpacking_process_flistsrch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpacking_process_flistsrch.filterList = <?php echo $packing_process_f_list->getFilterList() ?>;

// Init search panel as collapsed
fpacking_process_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_process_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($packing_process_f_list->TotalRecs > 0 && $packing_process_f_list->ExportOptions->visible()) { ?>
<?php $packing_process_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_process_f_list->ImportOptions->visible()) { ?>
<?php $packing_process_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_process_f_list->SearchOptions->visible()) { ?>
<?php $packing_process_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($packing_process_f_list->FilterOptions->visible()) { ?>
<?php $packing_process_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$packing_process_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$packing_process_f->isExport() && !$packing_process_f->CurrentAction) { ?>
<form name="fpacking_process_flistsrch" id="fpacking_process_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($packing_process_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpacking_process_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="packing_process_f">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$packing_process_f_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$packing_process_f->RowType = ROWTYPE_SEARCH;

// Render row
$packing_process_f->resetAttributes();
$packing_process_f_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($packing_process_f->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $packing_process_f->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$packing_process_f->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$packing_process_f->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($packing_process_f->product->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($packing_process_f->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($packing_process_f->product->getPlaceHolder()) ?>"<?php echo $packing_process_f->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_process_f" data-field="x_product" data-value-separator="<?php echo $packing_process_f->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($packing_process_f->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpacking_process_flistsrch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $packing_process_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($packing_process_f->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $packing_process_f->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="packing_process_f" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($packing_process_f->product_code->getPlaceHolder()) ?>" value="<?php echo $packing_process_f->product_code->EditValue ?>"<?php echo $packing_process_f->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($packing_process_f->Balance->Visible) { // Balance ?>
	<div id="xsc_Balance" class="ew-cell form-group">
		<label for="x_Balance" class="ew-search-caption ew-label"><?php echo $packing_process_f->Balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($packing_process_f->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="packing_process_f" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($packing_process_f->Balance->getPlaceHolder()) ?>" value="<?php echo $packing_process_f->Balance->EditValue ?>"<?php echo $packing_process_f->Balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_Balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Balance style="d-none"">
<input type="text" data-table="packing_process_f" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($packing_process_f->Balance->getPlaceHolder()) ?>" value="<?php echo $packing_process_f->Balance->EditValue2 ?>"<?php echo $packing_process_f->Balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($packing_process_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($packing_process_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $packing_process_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($packing_process_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($packing_process_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($packing_process_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($packing_process_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $packing_process_f_list->showPageHeader(); ?>
<?php
$packing_process_f_list->showMessage();
?>
<?php if ($packing_process_f_list->TotalRecs > 0 || $packing_process_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($packing_process_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> packing_process_f">
<?php if (!$packing_process_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$packing_process_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_process_f_list->Pager)) $packing_process_f_list->Pager = new PrevNextPager($packing_process_f_list->StartRec, $packing_process_f_list->DisplayRecs, $packing_process_f_list->TotalRecs, $packing_process_f_list->AutoHidePager) ?>
<?php if ($packing_process_f_list->Pager->RecordCount > 0 && $packing_process_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_process_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_process_f_list->pageUrl() ?>start=<?php echo $packing_process_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_process_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_process_f_list->pageUrl() ?>start=<?php echo $packing_process_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_process_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_process_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_process_f_list->pageUrl() ?>start=<?php echo $packing_process_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_process_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_process_f_list->pageUrl() ?>start=<?php echo $packing_process_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_process_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_process_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_process_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_process_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_process_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_process_f_list->TotalRecs > 0 && (!$packing_process_f_list->AutoHidePageSizeSelector || $packing_process_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_process_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_process_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_process_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_process_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_process_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_process_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_process_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_process_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpacking_process_flist" id="fpacking_process_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_process_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_process_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_process_f">
<div id="gmp_packing_process_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($packing_process_f_list->TotalRecs > 0 || $packing_process_f->isGridEdit()) { ?>
<table id="tbl_packing_process_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$packing_process_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$packing_process_f_list->renderListOptions();

// Render list options (header, left)
$packing_process_f_list->ListOptions->render("header", "left");
?>
<?php if ($packing_process_f->id->Visible) { // id ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $packing_process_f->id->headerCellClass() ?>"><div id="elh_packing_process_f_id" class="packing_process_f_id"><div class="ew-table-header-caption"><?php echo $packing_process_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $packing_process_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->id) ?>',2);"><div id="elh_packing_process_f_id" class="packing_process_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->dated->Visible) { // dated ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $packing_process_f->dated->headerCellClass() ?>"><div id="elh_packing_process_f_dated" class="packing_process_f_dated"><div class="ew-table-header-caption"><?php echo $packing_process_f->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $packing_process_f->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->dated) ?>',2);"><div id="elh_packing_process_f_dated" class="packing_process_f_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->product->Visible) { // product ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $packing_process_f->product->headerCellClass() ?>"><div id="elh_packing_process_f_product" class="packing_process_f_product"><div class="ew-table-header-caption"><?php echo $packing_process_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $packing_process_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->product) ?>',2);"><div id="elh_packing_process_f_product" class="packing_process_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->product_code->Visible) { // product_code ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $packing_process_f->product_code->headerCellClass() ?>"><div id="elh_packing_process_f_product_code" class="packing_process_f_product_code"><div class="ew-table-header-caption"><?php echo $packing_process_f->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $packing_process_f->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->product_code) ?>',2);"><div id="elh_packing_process_f_product_code" class="packing_process_f_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->godown->Visible) { // godown ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $packing_process_f->godown->headerCellClass() ?>"><div id="elh_packing_process_f_godown" class="packing_process_f_godown"><div class="ew-table-header-caption"><?php echo $packing_process_f->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $packing_process_f->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->godown) ?>',2);"><div id="elh_packing_process_f_godown" class="packing_process_f_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->Balance->Visible) { // Balance ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $packing_process_f->Balance->headerCellClass() ?>"><div id="elh_packing_process_f_Balance" class="packing_process_f_Balance"><div class="ew-table-header-caption"><?php echo $packing_process_f->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $packing_process_f->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->Balance) ?>',2);"><div id="elh_packing_process_f_Balance" class="packing_process_f_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->IN->Visible) { // IN ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $packing_process_f->IN->headerCellClass() ?>"><div id="elh_packing_process_f_IN" class="packing_process_f_IN"><div class="ew-table-header-caption"><?php echo $packing_process_f->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $packing_process_f->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->IN) ?>',2);"><div id="elh_packing_process_f_IN" class="packing_process_f_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->OUT->Visible) { // OUT ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $packing_process_f->OUT->headerCellClass() ?>"><div id="elh_packing_process_f_OUT" class="packing_process_f_OUT"><div class="ew-table-header-caption"><?php echo $packing_process_f->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $packing_process_f->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->OUT) ?>',2);"><div id="elh_packing_process_f_OUT" class="packing_process_f_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->OUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->packets->Visible) { // packets ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $packing_process_f->packets->headerCellClass() ?>"><div id="elh_packing_process_f_packets" class="packing_process_f_packets"><div class="ew-table-header-caption"><?php echo $packing_process_f->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $packing_process_f->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->packets) ?>',2);"><div id="elh_packing_process_f_packets" class="packing_process_f_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->packing_type->Visible) { // packing_type ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $packing_process_f->packing_type->headerCellClass() ?>"><div id="elh_packing_process_f_packing_type" class="packing_process_f_packing_type"><div class="ew-table-header-caption"><?php echo $packing_process_f->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $packing_process_f->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->packing_type) ?>',2);"><div id="elh_packing_process_f_packing_type" class="packing_process_f_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->lot_no->Visible) { // lot_no ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $packing_process_f->lot_no->headerCellClass() ?>"><div id="elh_packing_process_f_lot_no" class="packing_process_f_lot_no"><div class="ew-table-header-caption"><?php echo $packing_process_f->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $packing_process_f->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->lot_no) ?>',2);"><div id="elh_packing_process_f_lot_no" class="packing_process_f_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->remarks->Visible) { // remarks ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $packing_process_f->remarks->headerCellClass() ?>"><div id="elh_packing_process_f_remarks" class="packing_process_f_remarks"><div class="ew-table-header-caption"><?php echo $packing_process_f->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $packing_process_f->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->remarks) ?>',2);"><div id="elh_packing_process_f_remarks" class="packing_process_f_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->status->Visible) { // status ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->status) == "") { ?>
		<th data-name="status" class="<?php echo $packing_process_f->status->headerCellClass() ?>"><div id="elh_packing_process_f_status" class="packing_process_f_status"><div class="ew-table-header-caption"><?php echo $packing_process_f->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $packing_process_f->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->status) ?>',2);"><div id="elh_packing_process_f_status" class="packing_process_f_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $packing_process_f->tmp_lot->headerCellClass() ?>"><div id="elh_packing_process_f_tmp_lot" class="packing_process_f_tmp_lot"><div class="ew-table-header-caption"><?php echo $packing_process_f->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $packing_process_f->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->tmp_lot) ?>',2);"><div id="elh_packing_process_f_tmp_lot" class="packing_process_f_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->product_n->Visible) { // product_n ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->product_n) == "") { ?>
		<th data-name="product_n" class="<?php echo $packing_process_f->product_n->headerCellClass() ?>"><div id="elh_packing_process_f_product_n" class="packing_process_f_product_n"><div class="ew-table-header-caption"><?php echo $packing_process_f->product_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_n" class="<?php echo $packing_process_f->product_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->product_n) ?>',2);"><div id="elh_packing_process_f_product_n" class="packing_process_f_product_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->product_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->product_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->product_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->process_type->Visible) { // process_type ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->process_type) == "") { ?>
		<th data-name="process_type" class="<?php echo $packing_process_f->process_type->headerCellClass() ?>"><div id="elh_packing_process_f_process_type" class="packing_process_f_process_type"><div class="ew-table-header-caption"><?php echo $packing_process_f->process_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_type" class="<?php echo $packing_process_f->process_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->process_type) ?>',2);"><div id="elh_packing_process_f_process_type" class="packing_process_f_process_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->process_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->process_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->process_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->gcode->Visible) { // gcode ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->gcode) == "") { ?>
		<th data-name="gcode" class="<?php echo $packing_process_f->gcode->headerCellClass() ?>"><div id="elh_packing_process_f_gcode" class="packing_process_f_gcode"><div class="ew-table-header-caption"><?php echo $packing_process_f->gcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gcode" class="<?php echo $packing_process_f->gcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->gcode) ?>',2);"><div id="elh_packing_process_f_gcode" class="packing_process_f_gcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->gcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->gcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->gcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_f->avg_yield->Visible) { // avg_yield ?>
	<?php if ($packing_process_f->sortUrl($packing_process_f->avg_yield) == "") { ?>
		<th data-name="avg_yield" class="<?php echo $packing_process_f->avg_yield->headerCellClass() ?>"><div id="elh_packing_process_f_avg_yield" class="packing_process_f_avg_yield"><div class="ew-table-header-caption"><?php echo $packing_process_f->avg_yield->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_yield" class="<?php echo $packing_process_f->avg_yield->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_f->SortUrl($packing_process_f->avg_yield) ?>',2);"><div id="elh_packing_process_f_avg_yield" class="packing_process_f_avg_yield">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_f->avg_yield->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_f->avg_yield->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_f->avg_yield->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$packing_process_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($packing_process_f->ExportAll && $packing_process_f->isExport()) {
	$packing_process_f_list->StopRec = $packing_process_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($packing_process_f_list->TotalRecs > $packing_process_f_list->StartRec + $packing_process_f_list->DisplayRecs - 1)
		$packing_process_f_list->StopRec = $packing_process_f_list->StartRec + $packing_process_f_list->DisplayRecs - 1;
	else
		$packing_process_f_list->StopRec = $packing_process_f_list->TotalRecs;
}
$packing_process_f_list->RecCnt = $packing_process_f_list->StartRec - 1;
if ($packing_process_f_list->Recordset && !$packing_process_f_list->Recordset->EOF) {
	$packing_process_f_list->Recordset->moveFirst();
	$selectLimit = $packing_process_f_list->UseSelectLimit;
	if (!$selectLimit && $packing_process_f_list->StartRec > 1)
		$packing_process_f_list->Recordset->move($packing_process_f_list->StartRec - 1);
} elseif (!$packing_process_f->AllowAddDeleteRow && $packing_process_f_list->StopRec == 0) {
	$packing_process_f_list->StopRec = $packing_process_f->GridAddRowCount;
}

// Initialize aggregate
$packing_process_f->RowType = ROWTYPE_AGGREGATEINIT;
$packing_process_f->resetAttributes();
$packing_process_f_list->renderRow();
while ($packing_process_f_list->RecCnt < $packing_process_f_list->StopRec) {
	$packing_process_f_list->RecCnt++;
	if ($packing_process_f_list->RecCnt >= $packing_process_f_list->StartRec) {
		$packing_process_f_list->RowCnt++;

		// Set up key count
		$packing_process_f_list->KeyCount = $packing_process_f_list->RowIndex;

		// Init row class and style
		$packing_process_f->resetAttributes();
		$packing_process_f->CssClass = "";
		if ($packing_process_f->isGridAdd()) {
		} else {
			$packing_process_f_list->loadRowValues($packing_process_f_list->Recordset); // Load row values
		}
		$packing_process_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$packing_process_f->RowAttrs = array_merge($packing_process_f->RowAttrs, array('data-rowindex'=>$packing_process_f_list->RowCnt, 'id'=>'r' . $packing_process_f_list->RowCnt . '_packing_process_f', 'data-rowtype'=>$packing_process_f->RowType));

		// Render row
		$packing_process_f_list->renderRow();

		// Render list options
		$packing_process_f_list->renderListOptions();
?>
	<tr<?php echo $packing_process_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_process_f_list->ListOptions->render("body", "left", $packing_process_f_list->RowCnt);
?>
	<?php if ($packing_process_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $packing_process_f->id->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_id" class="packing_process_f_id">
<span<?php echo $packing_process_f->id->viewAttributes() ?>>
<?php echo $packing_process_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $packing_process_f->dated->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_dated" class="packing_process_f_dated">
<span<?php echo $packing_process_f->dated->viewAttributes() ?>>
<?php echo $packing_process_f->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $packing_process_f->product->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_product" class="packing_process_f_product">
<span<?php echo $packing_process_f->product->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_f->product->getViewValue())) && $packing_process_f->product->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_f->product->linkAttributes() ?>><?php echo $packing_process_f->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_f->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $packing_process_f->product_code->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_product_code" class="packing_process_f_product_code">
<span<?php echo $packing_process_f->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_f->product_code->getViewValue())) && $packing_process_f->product_code->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_f->product_code->linkAttributes() ?>><?php echo $packing_process_f->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_f->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $packing_process_f->godown->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_godown" class="packing_process_f_godown">
<span<?php echo $packing_process_f->godown->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_f->godown->getViewValue())) && $packing_process_f->godown->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_f->godown->linkAttributes() ?>><?php echo $packing_process_f->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_f->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $packing_process_f->Balance->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_Balance" class="packing_process_f_Balance">
<span<?php echo $packing_process_f->Balance->viewAttributes() ?>>
<?php echo $packing_process_f->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $packing_process_f->IN->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_IN" class="packing_process_f_IN">
<span<?php echo $packing_process_f->IN->viewAttributes() ?>>
<?php echo $packing_process_f->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $packing_process_f->OUT->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_OUT" class="packing_process_f_OUT">
<span<?php echo $packing_process_f->OUT->viewAttributes() ?>>
<?php echo $packing_process_f->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $packing_process_f->packets->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_packets" class="packing_process_f_packets">
<span<?php echo $packing_process_f->packets->viewAttributes() ?>>
<?php echo $packing_process_f->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $packing_process_f->packing_type->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_packing_type" class="packing_process_f_packing_type">
<span<?php echo $packing_process_f->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_f->packing_type->getViewValue())) && $packing_process_f->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_f->packing_type->linkAttributes() ?>><?php echo $packing_process_f->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_f->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $packing_process_f->lot_no->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_lot_no" class="packing_process_f_lot_no">
<span<?php echo $packing_process_f->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_f->lot_no->getViewValue())) && $packing_process_f->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_f->lot_no->linkAttributes() ?>><?php echo $packing_process_f->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_f->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $packing_process_f->remarks->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_remarks" class="packing_process_f_remarks">
<span<?php echo $packing_process_f->remarks->viewAttributes() ?>>
<?php echo $packing_process_f->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->status->Visible) { // status ?>
		<td data-name="status"<?php echo $packing_process_f->status->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_status" class="packing_process_f_status">
<span<?php echo $packing_process_f->status->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_f->status->getViewValue())) && $packing_process_f->status->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_f->status->linkAttributes() ?>><?php echo $packing_process_f->status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_f->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $packing_process_f->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_tmp_lot" class="packing_process_f_tmp_lot">
<span<?php echo $packing_process_f->tmp_lot->viewAttributes() ?>>
<?php echo $packing_process_f->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->product_n->Visible) { // product_n ?>
		<td data-name="product_n"<?php echo $packing_process_f->product_n->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_product_n" class="packing_process_f_product_n">
<span<?php echo $packing_process_f->product_n->viewAttributes() ?>>
<?php echo $packing_process_f->product_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->process_type->Visible) { // process_type ?>
		<td data-name="process_type"<?php echo $packing_process_f->process_type->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_process_type" class="packing_process_f_process_type">
<span<?php echo $packing_process_f->process_type->viewAttributes() ?>>
<?php echo $packing_process_f->process_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->gcode->Visible) { // gcode ?>
		<td data-name="gcode"<?php echo $packing_process_f->gcode->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_gcode" class="packing_process_f_gcode">
<span<?php echo $packing_process_f->gcode->viewAttributes() ?>>
<?php echo $packing_process_f->gcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_f->avg_yield->Visible) { // avg_yield ?>
		<td data-name="avg_yield"<?php echo $packing_process_f->avg_yield->cellAttributes() ?>>
<span id="el<?php echo $packing_process_f_list->RowCnt ?>_packing_process_f_avg_yield" class="packing_process_f_avg_yield">
<span<?php echo $packing_process_f->avg_yield->viewAttributes() ?>>
<?php echo $packing_process_f->avg_yield->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_process_f_list->ListOptions->render("body", "right", $packing_process_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$packing_process_f->isGridAdd())
		$packing_process_f_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$packing_process_f->RowType = ROWTYPE_AGGREGATE;
$packing_process_f->resetAttributes();
$packing_process_f_list->renderRow();
?>
<?php if ($packing_process_f_list->TotalRecs > 0 && !$packing_process_f->isGridAdd() && !$packing_process_f->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$packing_process_f_list->renderListOptions();

// Render list options (footer, left)
$packing_process_f_list->ListOptions->render("footer", "left");
?>
	<?php if ($packing_process_f->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $packing_process_f->id->footerCellClass() ?>"><span id="elf_packing_process_f_id" class="packing_process_f_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $packing_process_f->dated->footerCellClass() ?>"><span id="elf_packing_process_f_dated" class="packing_process_f_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $packing_process_f->product->footerCellClass() ?>"><span id="elf_packing_process_f_product" class="packing_process_f_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $packing_process_f->product_code->footerCellClass() ?>"><span id="elf_packing_process_f_product_code" class="packing_process_f_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $packing_process_f->godown->footerCellClass() ?>"><span id="elf_packing_process_f_godown" class="packing_process_f_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $packing_process_f->Balance->footerCellClass() ?>"><span id="elf_packing_process_f_Balance" class="packing_process_f_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_process_f->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $packing_process_f->IN->footerCellClass() ?>"><span id="elf_packing_process_f_IN" class="packing_process_f_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_process_f->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $packing_process_f->OUT->footerCellClass() ?>"><span id="elf_packing_process_f_OUT" class="packing_process_f_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_process_f->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $packing_process_f->packets->footerCellClass() ?>"><span id="elf_packing_process_f_packets" class="packing_process_f_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $packing_process_f->packing_type->footerCellClass() ?>"><span id="elf_packing_process_f_packing_type" class="packing_process_f_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $packing_process_f->lot_no->footerCellClass() ?>"><span id="elf_packing_process_f_lot_no" class="packing_process_f_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $packing_process_f->remarks->footerCellClass() ?>"><span id="elf_packing_process_f_remarks" class="packing_process_f_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $packing_process_f->status->footerCellClass() ?>"><span id="elf_packing_process_f_status" class="packing_process_f_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $packing_process_f->tmp_lot->footerCellClass() ?>"><span id="elf_packing_process_f_tmp_lot" class="packing_process_f_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->product_n->Visible) { // product_n ?>
		<td data-name="product_n" class="<?php echo $packing_process_f->product_n->footerCellClass() ?>"><span id="elf_packing_process_f_product_n" class="packing_process_f_product_n">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->process_type->Visible) { // process_type ?>
		<td data-name="process_type" class="<?php echo $packing_process_f->process_type->footerCellClass() ?>"><span id="elf_packing_process_f_process_type" class="packing_process_f_process_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->gcode->Visible) { // gcode ?>
		<td data-name="gcode" class="<?php echo $packing_process_f->gcode->footerCellClass() ?>"><span id="elf_packing_process_f_gcode" class="packing_process_f_gcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_f->avg_yield->Visible) { // avg_yield ?>
		<td data-name="avg_yield" class="<?php echo $packing_process_f->avg_yield->footerCellClass() ?>"><span id="elf_packing_process_f_avg_yield" class="packing_process_f_avg_yield">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$packing_process_f_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$packing_process_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($packing_process_f_list->Recordset)
	$packing_process_f_list->Recordset->Close();
?>
<?php if (!$packing_process_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$packing_process_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_process_f_list->Pager)) $packing_process_f_list->Pager = new PrevNextPager($packing_process_f_list->StartRec, $packing_process_f_list->DisplayRecs, $packing_process_f_list->TotalRecs, $packing_process_f_list->AutoHidePager) ?>
<?php if ($packing_process_f_list->Pager->RecordCount > 0 && $packing_process_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_process_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_process_f_list->pageUrl() ?>start=<?php echo $packing_process_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_process_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_process_f_list->pageUrl() ?>start=<?php echo $packing_process_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_process_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_process_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_process_f_list->pageUrl() ?>start=<?php echo $packing_process_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_process_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_process_f_list->pageUrl() ?>start=<?php echo $packing_process_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_process_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_process_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_process_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_process_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_process_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_process_f_list->TotalRecs > 0 && (!$packing_process_f_list->AutoHidePageSizeSelector || $packing_process_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_process_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_process_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_process_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_process_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_process_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_process_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_process_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_process_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($packing_process_f_list->TotalRecs == 0 && !$packing_process_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $packing_process_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$packing_process_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_process_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$packing_process_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_packing_process_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_process_f_list->terminate();
?>