<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_process_shortage_list = new packing_process_shortage_list();

// Run the page
$packing_process_shortage_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_process_shortage_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_process_shortage->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpacking_process_shortagelist = currentForm = new ew.Form("fpacking_process_shortagelist", "list");
fpacking_process_shortagelist.formKeyCountName = '<?php echo $packing_process_shortage_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpacking_process_shortagelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_process_shortagelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_process_shortagelist.lists["x_product"] = <?php echo $packing_process_shortage_list->product->Lookup->toClientList() ?>;
fpacking_process_shortagelist.lists["x_product"].options = <?php echo JsonEncode($packing_process_shortage_list->product->lookupOptions()) ?>;
fpacking_process_shortagelist.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_process_shortagelist.lists["x_godown"] = <?php echo $packing_process_shortage_list->godown->Lookup->toClientList() ?>;
fpacking_process_shortagelist.lists["x_godown"].options = <?php echo JsonEncode($packing_process_shortage_list->godown->lookupOptions()) ?>;

// Form object for search
var fpacking_process_shortagelistsrch = currentSearchForm = new ew.Form("fpacking_process_shortagelistsrch");

// Validate function for search
fpacking_process_shortagelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->Balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpacking_process_shortagelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_process_shortagelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_process_shortagelistsrch.lists["x_product"] = <?php echo $packing_process_shortage_list->product->Lookup->toClientList() ?>;
fpacking_process_shortagelistsrch.lists["x_product"].options = <?php echo JsonEncode($packing_process_shortage_list->product->lookupOptions()) ?>;
fpacking_process_shortagelistsrch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpacking_process_shortagelistsrch.filterList = <?php echo $packing_process_shortage_list->getFilterList() ?>;

// Init search panel as collapsed
fpacking_process_shortagelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_process_shortage->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($packing_process_shortage_list->TotalRecs > 0 && $packing_process_shortage_list->ExportOptions->visible()) { ?>
<?php $packing_process_shortage_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_process_shortage_list->ImportOptions->visible()) { ?>
<?php $packing_process_shortage_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_process_shortage_list->SearchOptions->visible()) { ?>
<?php $packing_process_shortage_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($packing_process_shortage_list->FilterOptions->visible()) { ?>
<?php $packing_process_shortage_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$packing_process_shortage_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$packing_process_shortage->isExport() && !$packing_process_shortage->CurrentAction) { ?>
<form name="fpacking_process_shortagelistsrch" id="fpacking_process_shortagelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($packing_process_shortage_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpacking_process_shortagelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="packing_process_shortage">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$packing_process_shortage_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$packing_process_shortage->RowType = ROWTYPE_SEARCH;

// Render row
$packing_process_shortage->resetAttributes();
$packing_process_shortage_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($packing_process_shortage->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $packing_process_shortage->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$packing_process_shortage->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$packing_process_shortage->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($packing_process_shortage->product->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($packing_process_shortage->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($packing_process_shortage->product->getPlaceHolder()) ?>"<?php echo $packing_process_shortage->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_process_shortage" data-field="x_product" data-value-separator="<?php echo $packing_process_shortage->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($packing_process_shortage->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpacking_process_shortagelistsrch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $packing_process_shortage->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $packing_process_shortage->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="packing_process_shortage" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($packing_process_shortage->product_code->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->product_code->EditValue ?>"<?php echo $packing_process_shortage->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->Balance->Visible) { // Balance ?>
	<div id="xsc_Balance" class="ew-cell form-group">
		<label for="x_Balance" class="ew-search-caption ew-label"><?php echo $packing_process_shortage->Balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="packing_process_shortage" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->Balance->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->Balance->EditValue ?>"<?php echo $packing_process_shortage->Balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_Balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Balance style="d-none"">
<input type="text" data-table="packing_process_shortage" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->Balance->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->Balance->EditValue2 ?>"<?php echo $packing_process_shortage->Balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($packing_process_shortage_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($packing_process_shortage_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $packing_process_shortage_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($packing_process_shortage_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($packing_process_shortage_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($packing_process_shortage_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($packing_process_shortage_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $packing_process_shortage_list->showPageHeader(); ?>
<?php
$packing_process_shortage_list->showMessage();
?>
<?php if ($packing_process_shortage_list->TotalRecs > 0 || $packing_process_shortage->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($packing_process_shortage_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> packing_process_shortage">
<?php if (!$packing_process_shortage->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$packing_process_shortage->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_process_shortage_list->Pager)) $packing_process_shortage_list->Pager = new PrevNextPager($packing_process_shortage_list->StartRec, $packing_process_shortage_list->DisplayRecs, $packing_process_shortage_list->TotalRecs, $packing_process_shortage_list->AutoHidePager) ?>
<?php if ($packing_process_shortage_list->Pager->RecordCount > 0 && $packing_process_shortage_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_process_shortage_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_process_shortage_list->pageUrl() ?>start=<?php echo $packing_process_shortage_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_process_shortage_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_process_shortage_list->pageUrl() ?>start=<?php echo $packing_process_shortage_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_process_shortage_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_process_shortage_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_process_shortage_list->pageUrl() ?>start=<?php echo $packing_process_shortage_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_process_shortage_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_process_shortage_list->pageUrl() ?>start=<?php echo $packing_process_shortage_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_process_shortage_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_process_shortage_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_process_shortage_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_process_shortage_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_process_shortage_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_process_shortage_list->TotalRecs > 0 && (!$packing_process_shortage_list->AutoHidePageSizeSelector || $packing_process_shortage_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_process_shortage">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_process_shortage_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_process_shortage_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_process_shortage_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_process_shortage_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_process_shortage_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_process_shortage->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_process_shortage_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpacking_process_shortagelist" id="fpacking_process_shortagelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_process_shortage_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_process_shortage_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_process_shortage">
<div id="gmp_packing_process_shortage" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($packing_process_shortage_list->TotalRecs > 0 || $packing_process_shortage->isGridEdit()) { ?>
<table id="tbl_packing_process_shortagelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$packing_process_shortage_list->RowType = ROWTYPE_HEADER;

// Render list options
$packing_process_shortage_list->renderListOptions();

// Render list options (header, left)
$packing_process_shortage_list->ListOptions->render("header", "left");
?>
<?php if ($packing_process_shortage->id->Visible) { // id ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->id) == "") { ?>
		<th data-name="id" class="<?php echo $packing_process_shortage->id->headerCellClass() ?>"><div id="elh_packing_process_shortage_id" class="packing_process_shortage_id"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $packing_process_shortage->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->id) ?>',2);"><div id="elh_packing_process_shortage_id" class="packing_process_shortage_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->product->Visible) { // product ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->product) == "") { ?>
		<th data-name="product" class="<?php echo $packing_process_shortage->product->headerCellClass() ?>" style="width: 100px;"><div id="elh_packing_process_shortage_product" class="packing_process_shortage_product"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $packing_process_shortage->product->headerCellClass() ?>" style="width: 100px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->product) ?>',2);"><div id="elh_packing_process_shortage_product" class="packing_process_shortage_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->product_code->Visible) { // product_code ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $packing_process_shortage->product_code->headerCellClass() ?>"><div id="elh_packing_process_shortage_product_code" class="packing_process_shortage_product_code"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $packing_process_shortage->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->product_code) ?>',2);"><div id="elh_packing_process_shortage_product_code" class="packing_process_shortage_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->IN->Visible) { // IN ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $packing_process_shortage->IN->headerCellClass() ?>"><div id="elh_packing_process_shortage_IN" class="packing_process_shortage_IN"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $packing_process_shortage->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->IN) ?>',2);"><div id="elh_packing_process_shortage_IN" class="packing_process_shortage_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->OUT->Visible) { // OUT ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $packing_process_shortage->OUT->headerCellClass() ?>"><div id="elh_packing_process_shortage_OUT" class="packing_process_shortage_OUT"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $packing_process_shortage->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->OUT) ?>',2);"><div id="elh_packing_process_shortage_OUT" class="packing_process_shortage_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->OUT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->Balance->Visible) { // Balance ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $packing_process_shortage->Balance->headerCellClass() ?>"><div id="elh_packing_process_shortage_Balance" class="packing_process_shortage_Balance"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $packing_process_shortage->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->Balance) ?>',2);"><div id="elh_packing_process_shortage_Balance" class="packing_process_shortage_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->_action->Visible) { // action ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->_action) == "") { ?>
		<th data-name="_action" class="<?php echo $packing_process_shortage->_action->headerCellClass() ?>"><div id="elh_packing_process_shortage__action" class="packing_process_shortage__action"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->_action->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_action" class="<?php echo $packing_process_shortage->_action->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->_action) ?>',2);"><div id="elh_packing_process_shortage__action" class="packing_process_shortage__action">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->_action->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->_action->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->_action->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->y->Visible) { // y ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->y) == "") { ?>
		<th data-name="y" class="<?php echo $packing_process_shortage->y->headerCellClass() ?>"><div id="elh_packing_process_shortage_y" class="packing_process_shortage_y"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->y->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="y" class="<?php echo $packing_process_shortage->y->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->y) ?>',2);"><div id="elh_packing_process_shortage_y" class="packing_process_shortage_y">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->y->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->y->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->y->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->sy->Visible) { // sy ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->sy) == "") { ?>
		<th data-name="sy" class="<?php echo $packing_process_shortage->sy->headerCellClass() ?>"><div id="elh_packing_process_shortage_sy" class="packing_process_shortage_sy"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->sy->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sy" class="<?php echo $packing_process_shortage->sy->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->sy) ?>',2);"><div id="elh_packing_process_shortage_sy" class="packing_process_shortage_sy">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->sy->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->sy->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->sy->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->lot_no->Visible) { // lot_no ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $packing_process_shortage->lot_no->headerCellClass() ?>"><div id="elh_packing_process_shortage_lot_no" class="packing_process_shortage_lot_no"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $packing_process_shortage->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->lot_no) ?>',2);"><div id="elh_packing_process_shortage_lot_no" class="packing_process_shortage_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $packing_process_shortage->tmp_lot->headerCellClass() ?>"><div id="elh_packing_process_shortage_tmp_lot" class="packing_process_shortage_tmp_lot"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $packing_process_shortage->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->tmp_lot) ?>',2);"><div id="elh_packing_process_shortage_tmp_lot" class="packing_process_shortage_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->godown->Visible) { // godown ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $packing_process_shortage->godown->headerCellClass() ?>"><div id="elh_packing_process_shortage_godown" class="packing_process_shortage_godown"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $packing_process_shortage->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->godown) ?>',2);"><div id="elh_packing_process_shortage_godown" class="packing_process_shortage_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_process_shortage->remarks->Visible) { // remarks ?>
	<?php if ($packing_process_shortage->sortUrl($packing_process_shortage->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $packing_process_shortage->remarks->headerCellClass() ?>"><div id="elh_packing_process_shortage_remarks" class="packing_process_shortage_remarks"><div class="ew-table-header-caption"><?php echo $packing_process_shortage->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $packing_process_shortage->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_process_shortage->SortUrl($packing_process_shortage->remarks) ?>',2);"><div id="elh_packing_process_shortage_remarks" class="packing_process_shortage_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_process_shortage->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_process_shortage->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_process_shortage->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$packing_process_shortage_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($packing_process_shortage->ExportAll && $packing_process_shortage->isExport()) {
	$packing_process_shortage_list->StopRec = $packing_process_shortage_list->TotalRecs;
} else {

	// Set the last record to display
	if ($packing_process_shortage_list->TotalRecs > $packing_process_shortage_list->StartRec + $packing_process_shortage_list->DisplayRecs - 1)
		$packing_process_shortage_list->StopRec = $packing_process_shortage_list->StartRec + $packing_process_shortage_list->DisplayRecs - 1;
	else
		$packing_process_shortage_list->StopRec = $packing_process_shortage_list->TotalRecs;
}
$packing_process_shortage_list->RecCnt = $packing_process_shortage_list->StartRec - 1;
if ($packing_process_shortage_list->Recordset && !$packing_process_shortage_list->Recordset->EOF) {
	$packing_process_shortage_list->Recordset->moveFirst();
	$selectLimit = $packing_process_shortage_list->UseSelectLimit;
	if (!$selectLimit && $packing_process_shortage_list->StartRec > 1)
		$packing_process_shortage_list->Recordset->move($packing_process_shortage_list->StartRec - 1);
} elseif (!$packing_process_shortage->AllowAddDeleteRow && $packing_process_shortage_list->StopRec == 0) {
	$packing_process_shortage_list->StopRec = $packing_process_shortage->GridAddRowCount;
}

// Initialize aggregate
$packing_process_shortage->RowType = ROWTYPE_AGGREGATEINIT;
$packing_process_shortage->resetAttributes();
$packing_process_shortage_list->renderRow();
while ($packing_process_shortage_list->RecCnt < $packing_process_shortage_list->StopRec) {
	$packing_process_shortage_list->RecCnt++;
	if ($packing_process_shortage_list->RecCnt >= $packing_process_shortage_list->StartRec) {
		$packing_process_shortage_list->RowCnt++;

		// Set up key count
		$packing_process_shortage_list->KeyCount = $packing_process_shortage_list->RowIndex;

		// Init row class and style
		$packing_process_shortage->resetAttributes();
		$packing_process_shortage->CssClass = "";
		if ($packing_process_shortage->isGridAdd()) {
		} else {
			$packing_process_shortage_list->loadRowValues($packing_process_shortage_list->Recordset); // Load row values
		}
		$packing_process_shortage->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$packing_process_shortage->RowAttrs = array_merge($packing_process_shortage->RowAttrs, array('data-rowindex'=>$packing_process_shortage_list->RowCnt, 'id'=>'r' . $packing_process_shortage_list->RowCnt . '_packing_process_shortage', 'data-rowtype'=>$packing_process_shortage->RowType));

		// Render row
		$packing_process_shortage_list->renderRow();

		// Render list options
		$packing_process_shortage_list->renderListOptions();
?>
	<tr<?php echo $packing_process_shortage->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_process_shortage_list->ListOptions->render("body", "left", $packing_process_shortage_list->RowCnt);
?>
	<?php if ($packing_process_shortage->id->Visible) { // id ?>
		<td data-name="id"<?php echo $packing_process_shortage->id->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_id" class="packing_process_shortage_id">
<span<?php echo $packing_process_shortage->id->viewAttributes() ?>>
<?php echo $packing_process_shortage->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->product->Visible) { // product ?>
		<td data-name="product"<?php echo $packing_process_shortage->product->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_product" class="packing_process_shortage_product">
<span<?php echo $packing_process_shortage->product->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_shortage->product->getViewValue())) && $packing_process_shortage->product->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_shortage->product->linkAttributes() ?>><?php echo $packing_process_shortage->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_shortage->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $packing_process_shortage->product_code->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_product_code" class="packing_process_shortage_product_code">
<span<?php echo $packing_process_shortage->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_shortage->product_code->getViewValue())) && $packing_process_shortage->product_code->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_shortage->product_code->linkAttributes() ?>><?php echo $packing_process_shortage->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_shortage->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $packing_process_shortage->IN->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_IN" class="packing_process_shortage_IN">
<span<?php echo $packing_process_shortage->IN->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_shortage->IN->getViewValue())) && $packing_process_shortage->IN->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_shortage->IN->linkAttributes() ?>><?php echo $packing_process_shortage->IN->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_shortage->IN->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $packing_process_shortage->OUT->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_OUT" class="packing_process_shortage_OUT">
<span<?php echo $packing_process_shortage->OUT->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_shortage->OUT->getViewValue())) && $packing_process_shortage->OUT->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_shortage->OUT->linkAttributes() ?>><?php echo $packing_process_shortage->OUT->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_shortage->OUT->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $packing_process_shortage->Balance->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_Balance" class="packing_process_shortage_Balance">
<span<?php echo $packing_process_shortage->Balance->viewAttributes() ?>>
<?php echo $packing_process_shortage->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->_action->Visible) { // action ?>
		<td data-name="_action"<?php echo $packing_process_shortage->_action->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage__action" class="packing_process_shortage__action">
<span<?php echo $packing_process_shortage->_action->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_shortage->_action->getViewValue())) && $packing_process_shortage->_action->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_shortage->_action->linkAttributes() ?>><?php echo $packing_process_shortage->_action->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_shortage->_action->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->y->Visible) { // y ?>
		<td data-name="y"<?php echo $packing_process_shortage->y->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_y" class="packing_process_shortage_y">
<span<?php echo $packing_process_shortage->y->viewAttributes() ?>>
<?php echo $packing_process_shortage->y->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->sy->Visible) { // sy ?>
		<td data-name="sy"<?php echo $packing_process_shortage->sy->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_sy" class="packing_process_shortage_sy">
<span<?php echo $packing_process_shortage->sy->viewAttributes() ?>>
<?php echo $packing_process_shortage->sy->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $packing_process_shortage->lot_no->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_lot_no" class="packing_process_shortage_lot_no">
<span<?php echo $packing_process_shortage->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_shortage->lot_no->getViewValue())) && $packing_process_shortage->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_shortage->lot_no->linkAttributes() ?>><?php echo $packing_process_shortage->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_shortage->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $packing_process_shortage->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_tmp_lot" class="packing_process_shortage_tmp_lot">
<span<?php echo $packing_process_shortage->tmp_lot->viewAttributes() ?>>
<?php echo $packing_process_shortage->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $packing_process_shortage->godown->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_godown" class="packing_process_shortage_godown">
<span<?php echo $packing_process_shortage->godown->viewAttributes() ?>>
<?php if ((!EmptyString($packing_process_shortage->godown->getViewValue())) && $packing_process_shortage->godown->linkAttributes() <> "") { ?>
<a<?php echo $packing_process_shortage->godown->linkAttributes() ?>><?php echo $packing_process_shortage->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_process_shortage->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_process_shortage->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $packing_process_shortage->remarks->cellAttributes() ?>>
<span id="el<?php echo $packing_process_shortage_list->RowCnt ?>_packing_process_shortage_remarks" class="packing_process_shortage_remarks">
<span<?php echo $packing_process_shortage->remarks->viewAttributes() ?>>
<?php echo $packing_process_shortage->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_process_shortage_list->ListOptions->render("body", "right", $packing_process_shortage_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$packing_process_shortage->isGridAdd())
		$packing_process_shortage_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$packing_process_shortage->RowType = ROWTYPE_AGGREGATE;
$packing_process_shortage->resetAttributes();
$packing_process_shortage_list->renderRow();
?>
<?php if ($packing_process_shortage_list->TotalRecs > 0 && !$packing_process_shortage->isGridAdd() && !$packing_process_shortage->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$packing_process_shortage_list->renderListOptions();

// Render list options (footer, left)
$packing_process_shortage_list->ListOptions->render("footer", "left");
?>
	<?php if ($packing_process_shortage->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $packing_process_shortage->id->footerCellClass() ?>"><span id="elf_packing_process_shortage_id" class="packing_process_shortage_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $packing_process_shortage->product->footerCellClass() ?>"><span id="elf_packing_process_shortage_product" class="packing_process_shortage_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $packing_process_shortage->product_code->footerCellClass() ?>"><span id="elf_packing_process_shortage_product_code" class="packing_process_shortage_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->IN->Visible) { // IN ?>
		<td data-name="IN" class="<?php echo $packing_process_shortage->IN->footerCellClass() ?>"><span id="elf_packing_process_shortage_IN" class="packing_process_shortage_IN">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_process_shortage->IN->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->OUT->Visible) { // OUT ?>
		<td data-name="OUT" class="<?php echo $packing_process_shortage->OUT->footerCellClass() ?>"><span id="elf_packing_process_shortage_OUT" class="packing_process_shortage_OUT">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_process_shortage->OUT->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $packing_process_shortage->Balance->footerCellClass() ?>"><span id="elf_packing_process_shortage_Balance" class="packing_process_shortage_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_process_shortage->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->_action->Visible) { // action ?>
		<td data-name="_action" class="<?php echo $packing_process_shortage->_action->footerCellClass() ?>"><span id="elf_packing_process_shortage__action" class="packing_process_shortage__action">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->y->Visible) { // y ?>
		<td data-name="y" class="<?php echo $packing_process_shortage->y->footerCellClass() ?>"><span id="elf_packing_process_shortage_y" class="packing_process_shortage_y">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_process_shortage->y->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->sy->Visible) { // sy ?>
		<td data-name="sy" class="<?php echo $packing_process_shortage->sy->footerCellClass() ?>"><span id="elf_packing_process_shortage_sy" class="packing_process_shortage_sy">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_process_shortage->sy->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $packing_process_shortage->lot_no->footerCellClass() ?>"><span id="elf_packing_process_shortage_lot_no" class="packing_process_shortage_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $packing_process_shortage->tmp_lot->footerCellClass() ?>"><span id="elf_packing_process_shortage_tmp_lot" class="packing_process_shortage_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $packing_process_shortage->godown->footerCellClass() ?>"><span id="elf_packing_process_shortage_godown" class="packing_process_shortage_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_process_shortage->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $packing_process_shortage->remarks->footerCellClass() ?>"><span id="elf_packing_process_shortage_remarks" class="packing_process_shortage_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$packing_process_shortage_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$packing_process_shortage->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($packing_process_shortage_list->Recordset)
	$packing_process_shortage_list->Recordset->Close();
?>
<?php if (!$packing_process_shortage->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$packing_process_shortage->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_process_shortage_list->Pager)) $packing_process_shortage_list->Pager = new PrevNextPager($packing_process_shortage_list->StartRec, $packing_process_shortage_list->DisplayRecs, $packing_process_shortage_list->TotalRecs, $packing_process_shortage_list->AutoHidePager) ?>
<?php if ($packing_process_shortage_list->Pager->RecordCount > 0 && $packing_process_shortage_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_process_shortage_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_process_shortage_list->pageUrl() ?>start=<?php echo $packing_process_shortage_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_process_shortage_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_process_shortage_list->pageUrl() ?>start=<?php echo $packing_process_shortage_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_process_shortage_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_process_shortage_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_process_shortage_list->pageUrl() ?>start=<?php echo $packing_process_shortage_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_process_shortage_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_process_shortage_list->pageUrl() ?>start=<?php echo $packing_process_shortage_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_process_shortage_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_process_shortage_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_process_shortage_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_process_shortage_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_process_shortage_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_process_shortage_list->TotalRecs > 0 && (!$packing_process_shortage_list->AutoHidePageSizeSelector || $packing_process_shortage_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_process_shortage">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_process_shortage_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_process_shortage_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_process_shortage_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_process_shortage_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_process_shortage_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_process_shortage->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_process_shortage_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($packing_process_shortage_list->TotalRecs == 0 && !$packing_process_shortage->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $packing_process_shortage_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$packing_process_shortage_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_process_shortage->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$packing_process_shortage->isExport()) { ?>
<script>
ew.scrollableTable("gmp_packing_process_shortage", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_process_shortage_list->terminate();
?>