<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_process_shortage_search = new packing_process_shortage_search();

// Run the page
$packing_process_shortage_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_process_shortage_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($packing_process_shortage_search->IsModal) { ?>
var fpacking_process_shortagesearch = currentAdvancedSearchForm = new ew.Form("fpacking_process_shortagesearch", "search");
<?php } else { ?>
var fpacking_process_shortagesearch = currentForm = new ew.Form("fpacking_process_shortagesearch", "search");
<?php } ?>

// Form_CustomValidate event
fpacking_process_shortagesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_process_shortagesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_process_shortagesearch.lists["x_product"] = <?php echo $packing_process_shortage_search->product->Lookup->toClientList() ?>;
fpacking_process_shortagesearch.lists["x_product"].options = <?php echo JsonEncode($packing_process_shortage_search->product->lookupOptions()) ?>;
fpacking_process_shortagesearch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_process_shortagesearch.lists["x_godown"] = <?php echo $packing_process_shortage_search->godown->Lookup->toClientList() ?>;
fpacking_process_shortagesearch.lists["x_godown"].options = <?php echo JsonEncode($packing_process_shortage_search->godown->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpacking_process_shortagesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_y");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->y->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sy");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->sy->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lot_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->lot_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_process_shortage->tmp_lot->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_process_shortage_search->showPageHeader(); ?>
<?php
$packing_process_shortage_search->showMessage();
?>
<form name="fpacking_process_shortagesearch" id="fpacking_process_shortagesearch" class="<?php echo $packing_process_shortage_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_process_shortage_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_process_shortage_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_process_shortage">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$packing_process_shortage_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($packing_process_shortage->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_id"><?php echo $packing_process_shortage->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->id->cellAttributes() ?>>
			<span id="el_packing_process_shortage_id">
<input type="text" data-table="packing_process_shortage" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($packing_process_shortage->id->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->id->EditValue ?>"<?php echo $packing_process_shortage->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_product"><?php echo $packing_process_shortage->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->product->cellAttributes() ?>>
			<span id="el_packing_process_shortage_product">
<?php
$wrkonchange = "" . trim(@$packing_process_shortage->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$packing_process_shortage->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($packing_process_shortage->product->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($packing_process_shortage->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($packing_process_shortage->product->getPlaceHolder()) ?>"<?php echo $packing_process_shortage->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_process_shortage" data-field="x_product" data-value-separator="<?php echo $packing_process_shortage->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($packing_process_shortage->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpacking_process_shortagesearch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $packing_process_shortage->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_product_code"><?php echo $packing_process_shortage->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->product_code->cellAttributes() ?>>
			<span id="el_packing_process_shortage_product_code">
<input type="text" data-table="packing_process_shortage" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($packing_process_shortage->product_code->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->product_code->EditValue ?>"<?php echo $packing_process_shortage->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_IN"><?php echo $packing_process_shortage->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->IN->cellAttributes() ?>>
			<span id="el_packing_process_shortage_IN">
<input type="text" data-table="packing_process_shortage" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->IN->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->IN->EditValue ?>"<?php echo $packing_process_shortage->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_OUT"><?php echo $packing_process_shortage->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->OUT->cellAttributes() ?>>
			<span id="el_packing_process_shortage_OUT">
<input type="text" data-table="packing_process_shortage" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->OUT->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->OUT->EditValue ?>"<?php echo $packing_process_shortage->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_Balance"><?php echo $packing_process_shortage->Balance->caption() ?></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->Balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Balance" id="z_Balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($packing_process_shortage->Balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_packing_process_shortage_Balance">
<input type="text" data-table="packing_process_shortage" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->Balance->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->Balance->EditValue ?>"<?php echo $packing_process_shortage->Balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_Balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_packing_process_shortage_Balance" class="btw1_Balance d-none">
<input type="text" data-table="packing_process_shortage" data-field="x_Balance" name="y_Balance" id="y_Balance" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->Balance->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->Balance->EditValue2 ?>"<?php echo $packing_process_shortage->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->_action->Visible) { // action ?>
	<div id="r__action" class="form-group row">
		<label for="x__action" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage__action"><?php echo $packing_process_shortage->_action->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__action" id="z__action" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->_action->cellAttributes() ?>>
			<span id="el_packing_process_shortage__action">
<input type="text" data-table="packing_process_shortage" data-field="x__action" name="x__action" id="x__action" size="30" maxlength="28" placeholder="<?php echo HtmlEncode($packing_process_shortage->_action->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->_action->EditValue ?>"<?php echo $packing_process_shortage->_action->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->y->Visible) { // y ?>
	<div id="r_y" class="form-group row">
		<label for="x_y" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_y"><?php echo $packing_process_shortage->y->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_y" id="z_y" value="="></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->y->cellAttributes() ?>>
			<span id="el_packing_process_shortage_y">
<input type="text" data-table="packing_process_shortage" data-field="x_y" name="x_y" id="x_y" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->y->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->y->EditValue ?>"<?php echo $packing_process_shortage->y->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->sy->Visible) { // sy ?>
	<div id="r_sy" class="form-group row">
		<label for="x_sy" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_sy"><?php echo $packing_process_shortage->sy->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sy" id="z_sy" value="="></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->sy->cellAttributes() ?>>
			<span id="el_packing_process_shortage_sy">
<input type="text" data-table="packing_process_shortage" data-field="x_sy" name="x_sy" id="x_sy" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->sy->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->sy->EditValue ?>"<?php echo $packing_process_shortage->sy->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_lot_no"><?php echo $packing_process_shortage->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->lot_no->cellAttributes() ?>>
			<span id="el_packing_process_shortage_lot_no">
<input type="text" data-table="packing_process_shortage" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->lot_no->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->lot_no->EditValue ?>"<?php echo $packing_process_shortage->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_tmp_lot"><?php echo $packing_process_shortage->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="="></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->tmp_lot->cellAttributes() ?>>
			<span id="el_packing_process_shortage_tmp_lot">
<input type="text" data-table="packing_process_shortage" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($packing_process_shortage->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->tmp_lot->EditValue ?>"<?php echo $packing_process_shortage->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_godown"><?php echo $packing_process_shortage->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->godown->cellAttributes() ?>>
			<span id="el_packing_process_shortage_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_process_shortage" data-field="x_godown" data-value-separator="<?php echo $packing_process_shortage->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $packing_process_shortage->godown->editAttributes() ?>>
		<?php echo $packing_process_shortage->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $packing_process_shortage->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_process_shortage->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $packing_process_shortage_search->LeftColumnClass ?>"><span id="elh_packing_process_shortage_remarks"><?php echo $packing_process_shortage->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_process_shortage_search->RightColumnClass ?>"><div<?php echo $packing_process_shortage->remarks->cellAttributes() ?>>
			<span id="el_packing_process_shortage_remarks">
<input type="text" data-table="packing_process_shortage" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($packing_process_shortage->remarks->getPlaceHolder()) ?>" value="<?php echo $packing_process_shortage->remarks->EditValue ?>"<?php echo $packing_process_shortage->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$packing_process_shortage_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $packing_process_shortage_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$packing_process_shortage_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$packing_process_shortage_search->terminate();
?>