<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_table_fp_add = new packing_table_fp_add();

// Run the page
$packing_table_fp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_table_fp_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpacking_table_fpadd = currentForm = new ew.Form("fpacking_table_fpadd", "add");

// Validate form
fpacking_table_fpadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($packing_table_fp_add->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->ref->caption(), $packing_table_fp->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->out_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_out_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->out_ref->caption(), $packing_table_fp->out_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_out_ref");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table_fp->out_ref->errorMessage()) ?>");
		<?php if ($packing_table_fp_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->product->caption(), $packing_table_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->rid->caption(), $packing_table_fp->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table_fp->rid->errorMessage()) ?>");
		<?php if ($packing_table_fp_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->packets->caption(), $packing_table_fp->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table_fp->packets->errorMessage()) ?>");
		<?php if ($packing_table_fp_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->quantity->caption(), $packing_table_fp->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table_fp->quantity->errorMessage()) ?>");
		<?php if ($packing_table_fp_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->lot_no->caption(), $packing_table_fp->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->par_com->Required) { ?>
			elm = this.getElements("x" + infix + "_par_com");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->par_com->caption(), $packing_table_fp->par_com->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->packing_type->caption(), $packing_table_fp->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->godown->caption(), $packing_table_fp->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->dated->caption(), $packing_table_fp->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table_fp->dated->errorMessage()) ?>");
		<?php if ($packing_table_fp_add->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->employee_id->caption(), $packing_table_fp->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->operator->caption(), $packing_table_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->datetime->caption(), $packing_table_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_fp_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table_fp->remarks->caption(), $packing_table_fp->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpacking_table_fpadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_table_fpadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_table_fpadd.lists["x_ref"] = <?php echo $packing_table_fp_add->ref->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_ref"].options = <?php echo JsonEncode($packing_table_fp_add->ref->lookupOptions()) ?>;
fpacking_table_fpadd.lists["x_out_ref"] = <?php echo $packing_table_fp_add->out_ref->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_out_ref"].options = <?php echo JsonEncode($packing_table_fp_add->out_ref->lookupOptions()) ?>;
fpacking_table_fpadd.autoSuggests["x_out_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_table_fpadd.lists["x_product"] = <?php echo $packing_table_fp_add->product->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_product"].options = <?php echo JsonEncode($packing_table_fp_add->product->lookupOptions()) ?>;
fpacking_table_fpadd.lists["x_rid"] = <?php echo $packing_table_fp_add->rid->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_rid"].options = <?php echo JsonEncode($packing_table_fp_add->rid->lookupOptions()) ?>;
fpacking_table_fpadd.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_table_fpadd.lists["x_par_com"] = <?php echo $packing_table_fp_add->par_com->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_par_com"].options = <?php echo JsonEncode($packing_table_fp_add->par_com->options(FALSE, TRUE)) ?>;
fpacking_table_fpadd.lists["x_packing_type"] = <?php echo $packing_table_fp_add->packing_type->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_packing_type"].options = <?php echo JsonEncode($packing_table_fp_add->packing_type->lookupOptions()) ?>;
fpacking_table_fpadd.lists["x_godown"] = <?php echo $packing_table_fp_add->godown->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_godown"].options = <?php echo JsonEncode($packing_table_fp_add->godown->lookupOptions()) ?>;
fpacking_table_fpadd.lists["x_employee_id"] = <?php echo $packing_table_fp_add->employee_id->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_employee_id"].options = <?php echo JsonEncode($packing_table_fp_add->employee_id->lookupOptions()) ?>;
fpacking_table_fpadd.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_table_fpadd.lists["x_operator"] = <?php echo $packing_table_fp_add->operator->Lookup->toClientList() ?>;
fpacking_table_fpadd.lists["x_operator"].options = <?php echo JsonEncode($packing_table_fp_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_table_fp_add->showPageHeader(); ?>
<?php
$packing_table_fp_add->showMessage();
?>
<form name="fpacking_table_fpadd" id="fpacking_table_fpadd" class="<?php echo $packing_table_fp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_table_fp_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_table_fp_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_table_fp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$packing_table_fp_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($packing_table_fp->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_packing_table_fp_ref" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->ref->caption() ?><?php echo ($packing_table_fp->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->ref->cellAttributes() ?>>
<span id="el_packing_table_fp_ref">
<?php $packing_table_fp->ref->EditAttrs["onclick"] = "ew.autoFill(this); " . @$packing_table_fp->ref->EditAttrs["onclick"]; ?>
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="packing_table_fp" data-field="x_ref" data-value-separator="<?php echo $packing_table_fp->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $packing_table_fp->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $packing_table_fp->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $packing_table_fp->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
<?php echo $packing_table_fp->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->out_ref->Visible) { // out_ref ?>
	<div id="r_out_ref" class="form-group row">
		<label id="elh_packing_table_fp_out_ref" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->out_ref->caption() ?><?php echo ($packing_table_fp->out_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->out_ref->cellAttributes() ?>>
<span id="el_packing_table_fp_out_ref">
<?php
$wrkonchange = "" . trim(@$packing_table_fp->out_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$packing_table_fp->out_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_out_ref" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_out_ref" id="sv_x_out_ref" value="<?php echo RemoveHtml($packing_table_fp->out_ref->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($packing_table_fp->out_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($packing_table_fp->out_ref->getPlaceHolder()) ?>"<?php echo $packing_table_fp->out_ref->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_table_fp" data-field="x_out_ref" data-value-separator="<?php echo $packing_table_fp->out_ref->displayValueSeparatorAttribute() ?>" name="x_out_ref" id="x_out_ref" value="<?php echo HtmlEncode($packing_table_fp->out_ref->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpacking_table_fpadd.createAutoSuggest({"id":"x_out_ref","forceSelect":false});
</script>
<?php echo $packing_table_fp->out_ref->Lookup->getParamTag("p_x_out_ref") ?>
</span>
<?php echo $packing_table_fp->out_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_packing_table_fp_product" for="x_product" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->product->caption() ?><?php echo ($packing_table_fp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->product->cellAttributes() ?>>
<span id="el_packing_table_fp_product">
<?php $packing_table_fp->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$packing_table_fp->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table_fp" data-field="x_product" data-value-separator="<?php echo $packing_table_fp->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $packing_table_fp->product->editAttributes() ?>>
		<?php echo $packing_table_fp->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $packing_table_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $packing_table_fp->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_packing_table_fp_rid" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->rid->caption() ?><?php echo ($packing_table_fp->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->rid->cellAttributes() ?>>
<span id="el_packing_table_fp_rid">
<?php
$wrkonchange = "" . trim(@$packing_table_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$packing_table_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8950">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($packing_table_fp->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($packing_table_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($packing_table_fp->rid->getPlaceHolder()) ?>"<?php echo $packing_table_fp->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_table_fp" data-field="x_rid" data-value-separator="<?php echo $packing_table_fp->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($packing_table_fp->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpacking_table_fpadd.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $packing_table_fp->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $packing_table_fp->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_packing_table_fp_packets" for="x_packets" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->packets->caption() ?><?php echo ($packing_table_fp->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->packets->cellAttributes() ?>>
<span id="el_packing_table_fp_packets">
<input type="text" data-table="packing_table_fp" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($packing_table_fp->packets->getPlaceHolder()) ?>" value="<?php echo $packing_table_fp->packets->EditValue ?>"<?php echo $packing_table_fp->packets->editAttributes() ?>>
</span>
<?php echo $packing_table_fp->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_packing_table_fp_quantity" for="x_quantity" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->quantity->caption() ?><?php echo ($packing_table_fp->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->quantity->cellAttributes() ?>>
<span id="el_packing_table_fp_quantity">
<input type="text" data-table="packing_table_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($packing_table_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $packing_table_fp->quantity->EditValue ?>"<?php echo $packing_table_fp->quantity->editAttributes() ?>>
</span>
<?php echo $packing_table_fp->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_packing_table_fp_lot_no" for="x_lot_no" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->lot_no->caption() ?><?php echo ($packing_table_fp->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->lot_no->cellAttributes() ?>>
<span id="el_packing_table_fp_lot_no">
<input type="text" data-table="packing_table_fp" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($packing_table_fp->lot_no->getPlaceHolder()) ?>" value="<?php echo $packing_table_fp->lot_no->EditValue ?>"<?php echo $packing_table_fp->lot_no->editAttributes() ?>>
</span>
<?php echo $packing_table_fp->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->par_com->Visible) { // par_com ?>
	<div id="r_par_com" class="form-group row">
		<label id="elh_packing_table_fp_par_com" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->par_com->caption() ?><?php echo ($packing_table_fp->par_com->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->par_com->cellAttributes() ?>>
<span id="el_packing_table_fp_par_com">
<div id="tp_x_par_com" class="ew-template"><input type="radio" class="form-check-input" data-table="packing_table_fp" data-field="x_par_com" data-value-separator="<?php echo $packing_table_fp->par_com->displayValueSeparatorAttribute() ?>" name="x_par_com" id="x_par_com" value="{value}"<?php echo $packing_table_fp->par_com->editAttributes() ?>></div>
<div id="dsl_x_par_com" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $packing_table_fp->par_com->radioButtonListHtml(FALSE, "x_par_com") ?>
</div></div>
</span>
<?php echo $packing_table_fp->par_com->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_packing_table_fp_packing_type" for="x_packing_type" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->packing_type->caption() ?><?php echo ($packing_table_fp->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->packing_type->cellAttributes() ?>>
<span id="el_packing_table_fp_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table_fp" data-field="x_packing_type" data-value-separator="<?php echo $packing_table_fp->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $packing_table_fp->packing_type->editAttributes() ?>>
		<?php echo $packing_table_fp->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$packing_table_fp->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $packing_table_fp->packing_type->caption() ?>" data-title="<?php echo $packing_table_fp->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $packing_table_fp->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $packing_table_fp->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_packing_table_fp_godown" for="x_godown" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->godown->caption() ?><?php echo ($packing_table_fp->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->godown->cellAttributes() ?>>
<span id="el_packing_table_fp_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table_fp" data-field="x_godown" data-value-separator="<?php echo $packing_table_fp->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $packing_table_fp->godown->editAttributes() ?>>
		<?php echo $packing_table_fp->godown->selectOptionListHtml("x_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$packing_table_fp->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $packing_table_fp->godown->caption() ?>" data-title="<?php echo $packing_table_fp->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_godown',url:'godown_tableaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $packing_table_fp->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $packing_table_fp->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_packing_table_fp_dated" for="x_dated" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->dated->caption() ?><?php echo ($packing_table_fp->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->dated->cellAttributes() ?>>
<span id="el_packing_table_fp_dated">
<input type="text" data-table="packing_table_fp" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($packing_table_fp->dated->getPlaceHolder()) ?>" value="<?php echo $packing_table_fp->dated->EditValue ?>"<?php echo $packing_table_fp->dated->editAttributes() ?>>
<?php if (!$packing_table_fp->dated->ReadOnly && !$packing_table_fp->dated->Disabled && !isset($packing_table_fp->dated->EditAttrs["readonly"]) && !isset($packing_table_fp->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpacking_table_fpadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $packing_table_fp->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_packing_table_fp_employee_id" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->employee_id->caption() ?><?php echo ($packing_table_fp->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->employee_id->cellAttributes() ?>>
<span id="el_packing_table_fp_employee_id">
<?php
$wrkonchange = "" . trim(@$packing_table_fp->employee_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$packing_table_fp->employee_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_employee_id" class="text-nowrap" style="z-index: 8860">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_employee_id" id="sv_x_employee_id" value="<?php echo RemoveHtml($packing_table_fp->employee_id->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($packing_table_fp->employee_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($packing_table_fp->employee_id->getPlaceHolder()) ?>"<?php echo $packing_table_fp->employee_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($packing_table_fp->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id',m:0,n:20,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($packing_table_fp->employee_id->ReadOnly || $packing_table_fp->employee_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "production_employee_fp") && !$packing_table_fp->employee_id->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_employee_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $packing_table_fp->employee_id->caption() ?>" data-title="<?php echo $packing_table_fp->employee_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_employee_id',url:'production_employee_fpaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="packing_table_fp" data-field="x_employee_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $packing_table_fp->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id" id="x_employee_id" value="<?php echo HtmlEncode($packing_table_fp->employee_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpacking_table_fpadd.createAutoSuggest({"id":"x_employee_id","forceSelect":false});
</script>
<?php echo $packing_table_fp->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
<?php echo $packing_table_fp->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_packing_table_fp_remarks" for="x_remarks" class="<?php echo $packing_table_fp_add->LeftColumnClass ?>"><?php echo $packing_table_fp->remarks->caption() ?><?php echo ($packing_table_fp->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_fp_add->RightColumnClass ?>"><div<?php echo $packing_table_fp->remarks->cellAttributes() ?>>
<span id="el_packing_table_fp_remarks">
<textarea data-table="packing_table_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($packing_table_fp->remarks->getPlaceHolder()) ?>"<?php echo $packing_table_fp->remarks->editAttributes() ?>><?php echo $packing_table_fp->remarks->EditValue ?></textarea>
</span>
<?php echo $packing_table_fp->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$packing_table_fp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $packing_table_fp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $packing_table_fp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$packing_table_fp_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$packing_table_fp_add->terminate();
?>