<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_table_fp_list = new packing_table_fp_list();

// Run the page
$packing_table_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_table_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_table_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpacking_table_fplist = currentForm = new ew.Form("fpacking_table_fplist", "list");
fpacking_table_fplist.formKeyCountName = '<?php echo $packing_table_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpacking_table_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_table_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_table_fplist.lists["x_out_ref"] = <?php echo $packing_table_fp_list->out_ref->Lookup->toClientList() ?>;
fpacking_table_fplist.lists["x_out_ref"].options = <?php echo JsonEncode($packing_table_fp_list->out_ref->lookupOptions()) ?>;
fpacking_table_fplist.autoSuggests["x_out_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_table_fplist.lists["x_product"] = <?php echo $packing_table_fp_list->product->Lookup->toClientList() ?>;
fpacking_table_fplist.lists["x_product"].options = <?php echo JsonEncode($packing_table_fp_list->product->lookupOptions()) ?>;
fpacking_table_fplist.lists["x_rid"] = <?php echo $packing_table_fp_list->rid->Lookup->toClientList() ?>;
fpacking_table_fplist.lists["x_rid"].options = <?php echo JsonEncode($packing_table_fp_list->rid->lookupOptions()) ?>;
fpacking_table_fplist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_table_fplist.lists["x_par_com"] = <?php echo $packing_table_fp_list->par_com->Lookup->toClientList() ?>;
fpacking_table_fplist.lists["x_par_com"].options = <?php echo JsonEncode($packing_table_fp_list->par_com->options(FALSE, TRUE)) ?>;
fpacking_table_fplist.lists["x_packing_type"] = <?php echo $packing_table_fp_list->packing_type->Lookup->toClientList() ?>;
fpacking_table_fplist.lists["x_packing_type"].options = <?php echo JsonEncode($packing_table_fp_list->packing_type->lookupOptions()) ?>;
fpacking_table_fplist.lists["x_godown"] = <?php echo $packing_table_fp_list->godown->Lookup->toClientList() ?>;
fpacking_table_fplist.lists["x_godown"].options = <?php echo JsonEncode($packing_table_fp_list->godown->lookupOptions()) ?>;
fpacking_table_fplist.lists["x_employee_id"] = <?php echo $packing_table_fp_list->employee_id->Lookup->toClientList() ?>;
fpacking_table_fplist.lists["x_employee_id"].options = <?php echo JsonEncode($packing_table_fp_list->employee_id->lookupOptions()) ?>;
fpacking_table_fplist.autoSuggests["x_employee_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_table_fplist.lists["x_operator"] = <?php echo $packing_table_fp_list->operator->Lookup->toClientList() ?>;
fpacking_table_fplist.lists["x_operator"].options = <?php echo JsonEncode($packing_table_fp_list->operator->lookupOptions()) ?>;

// Form object for search
var fpacking_table_fplistsrch = currentSearchForm = new ew.Form("fpacking_table_fplistsrch");

// Filters
fpacking_table_fplistsrch.filterList = <?php echo $packing_table_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fpacking_table_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_table_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($packing_table_fp_list->TotalRecs > 0 && $packing_table_fp_list->ExportOptions->visible()) { ?>
<?php $packing_table_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_table_fp_list->ImportOptions->visible()) { ?>
<?php $packing_table_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_table_fp_list->SearchOptions->visible()) { ?>
<?php $packing_table_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($packing_table_fp_list->FilterOptions->visible()) { ?>
<?php $packing_table_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$packing_table_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$packing_table_fp->isExport() && !$packing_table_fp->CurrentAction) { ?>
<form name="fpacking_table_fplistsrch" id="fpacking_table_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($packing_table_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpacking_table_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="packing_table_fp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($packing_table_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($packing_table_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $packing_table_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($packing_table_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($packing_table_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($packing_table_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($packing_table_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $packing_table_fp_list->showPageHeader(); ?>
<?php
$packing_table_fp_list->showMessage();
?>
<?php if ($packing_table_fp_list->TotalRecs > 0 || $packing_table_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($packing_table_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> packing_table_fp">
<?php if (!$packing_table_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$packing_table_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_table_fp_list->Pager)) $packing_table_fp_list->Pager = new PrevNextPager($packing_table_fp_list->StartRec, $packing_table_fp_list->DisplayRecs, $packing_table_fp_list->TotalRecs, $packing_table_fp_list->AutoHidePager) ?>
<?php if ($packing_table_fp_list->Pager->RecordCount > 0 && $packing_table_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_table_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_table_fp_list->pageUrl() ?>start=<?php echo $packing_table_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_table_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_table_fp_list->pageUrl() ?>start=<?php echo $packing_table_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_table_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_table_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_table_fp_list->pageUrl() ?>start=<?php echo $packing_table_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_table_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_table_fp_list->pageUrl() ?>start=<?php echo $packing_table_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_table_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_table_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_table_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_table_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_table_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_table_fp_list->TotalRecs > 0 && (!$packing_table_fp_list->AutoHidePageSizeSelector || $packing_table_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_table_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_table_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_table_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_table_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_table_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_table_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_table_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_table_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpacking_table_fplist" id="fpacking_table_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_table_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_table_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_table_fp">
<div id="gmp_packing_table_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($packing_table_fp_list->TotalRecs > 0 || $packing_table_fp->isGridEdit()) { ?>
<table id="tbl_packing_table_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$packing_table_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$packing_table_fp_list->renderListOptions();

// Render list options (header, left)
$packing_table_fp_list->ListOptions->render("header", "left");
?>
<?php if ($packing_table_fp->id->Visible) { // id ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $packing_table_fp->id->headerCellClass() ?>"><div id="elh_packing_table_fp_id" class="packing_table_fp_id"><div class="ew-table-header-caption"><?php echo $packing_table_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $packing_table_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->id) ?>',2);"><div id="elh_packing_table_fp_id" class="packing_table_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->out_ref->Visible) { // out_ref ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->out_ref) == "") { ?>
		<th data-name="out_ref" class="<?php echo $packing_table_fp->out_ref->headerCellClass() ?>"><div id="elh_packing_table_fp_out_ref" class="packing_table_fp_out_ref"><div class="ew-table-header-caption"><?php echo $packing_table_fp->out_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="out_ref" class="<?php echo $packing_table_fp->out_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->out_ref) ?>',2);"><div id="elh_packing_table_fp_out_ref" class="packing_table_fp_out_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->out_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->out_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->out_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->product->Visible) { // product ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $packing_table_fp->product->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_packing_table_fp_product" class="packing_table_fp_product"><div class="ew-table-header-caption"><?php echo $packing_table_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $packing_table_fp->product->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->product) ?>',2);"><div id="elh_packing_table_fp_product" class="packing_table_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->rid->Visible) { // rid ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $packing_table_fp->rid->headerCellClass() ?>"><div id="elh_packing_table_fp_rid" class="packing_table_fp_rid"><div class="ew-table-header-caption"><?php echo $packing_table_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $packing_table_fp->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->rid) ?>',2);"><div id="elh_packing_table_fp_rid" class="packing_table_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->packets->Visible) { // packets ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $packing_table_fp->packets->headerCellClass() ?>"><div id="elh_packing_table_fp_packets" class="packing_table_fp_packets"><div class="ew-table-header-caption"><?php echo $packing_table_fp->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $packing_table_fp->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->packets) ?>',2);"><div id="elh_packing_table_fp_packets" class="packing_table_fp_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->quantity->Visible) { // quantity ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $packing_table_fp->quantity->headerCellClass() ?>"><div id="elh_packing_table_fp_quantity" class="packing_table_fp_quantity"><div class="ew-table-header-caption"><?php echo $packing_table_fp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $packing_table_fp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->quantity) ?>',2);"><div id="elh_packing_table_fp_quantity" class="packing_table_fp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->lot_no->Visible) { // lot_no ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $packing_table_fp->lot_no->headerCellClass() ?>"><div id="elh_packing_table_fp_lot_no" class="packing_table_fp_lot_no"><div class="ew-table-header-caption"><?php echo $packing_table_fp->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $packing_table_fp->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->lot_no) ?>',2);"><div id="elh_packing_table_fp_lot_no" class="packing_table_fp_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->par_com->Visible) { // par_com ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->par_com) == "") { ?>
		<th data-name="par_com" class="<?php echo $packing_table_fp->par_com->headerCellClass() ?>"><div id="elh_packing_table_fp_par_com" class="packing_table_fp_par_com"><div class="ew-table-header-caption"><?php echo $packing_table_fp->par_com->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="par_com" class="<?php echo $packing_table_fp->par_com->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->par_com) ?>',2);"><div id="elh_packing_table_fp_par_com" class="packing_table_fp_par_com">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->par_com->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->par_com->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->par_com->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->packing_type->Visible) { // packing_type ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $packing_table_fp->packing_type->headerCellClass() ?>"><div id="elh_packing_table_fp_packing_type" class="packing_table_fp_packing_type"><div class="ew-table-header-caption"><?php echo $packing_table_fp->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $packing_table_fp->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->packing_type) ?>',2);"><div id="elh_packing_table_fp_packing_type" class="packing_table_fp_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->godown->Visible) { // godown ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $packing_table_fp->godown->headerCellClass() ?>"><div id="elh_packing_table_fp_godown" class="packing_table_fp_godown"><div class="ew-table-header-caption"><?php echo $packing_table_fp->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $packing_table_fp->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->godown) ?>',2);"><div id="elh_packing_table_fp_godown" class="packing_table_fp_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->dated->Visible) { // dated ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $packing_table_fp->dated->headerCellClass() ?>"><div id="elh_packing_table_fp_dated" class="packing_table_fp_dated"><div class="ew-table-header-caption"><?php echo $packing_table_fp->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $packing_table_fp->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->dated) ?>',2);"><div id="elh_packing_table_fp_dated" class="packing_table_fp_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->employee_id->Visible) { // employee_id ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $packing_table_fp->employee_id->headerCellClass() ?>"><div id="elh_packing_table_fp_employee_id" class="packing_table_fp_employee_id"><div class="ew-table-header-caption"><?php echo $packing_table_fp->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $packing_table_fp->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->employee_id) ?>',2);"><div id="elh_packing_table_fp_employee_id" class="packing_table_fp_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->employee_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->operator->Visible) { // operator ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $packing_table_fp->operator->headerCellClass() ?>"><div id="elh_packing_table_fp_operator" class="packing_table_fp_operator"><div class="ew-table-header-caption"><?php echo $packing_table_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $packing_table_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->operator) ?>',2);"><div id="elh_packing_table_fp_operator" class="packing_table_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->datetime->Visible) { // datetime ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $packing_table_fp->datetime->headerCellClass() ?>"><div id="elh_packing_table_fp_datetime" class="packing_table_fp_datetime"><div class="ew-table-header-caption"><?php echo $packing_table_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $packing_table_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->datetime) ?>',2);"><div id="elh_packing_table_fp_datetime" class="packing_table_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table_fp->remarks->Visible) { // remarks ?>
	<?php if ($packing_table_fp->sortUrl($packing_table_fp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $packing_table_fp->remarks->headerCellClass() ?>"><div id="elh_packing_table_fp_remarks" class="packing_table_fp_remarks"><div class="ew-table-header-caption"><?php echo $packing_table_fp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $packing_table_fp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table_fp->SortUrl($packing_table_fp->remarks) ?>',2);"><div id="elh_packing_table_fp_remarks" class="packing_table_fp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table_fp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_table_fp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table_fp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$packing_table_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($packing_table_fp->ExportAll && $packing_table_fp->isExport()) {
	$packing_table_fp_list->StopRec = $packing_table_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($packing_table_fp_list->TotalRecs > $packing_table_fp_list->StartRec + $packing_table_fp_list->DisplayRecs - 1)
		$packing_table_fp_list->StopRec = $packing_table_fp_list->StartRec + $packing_table_fp_list->DisplayRecs - 1;
	else
		$packing_table_fp_list->StopRec = $packing_table_fp_list->TotalRecs;
}
$packing_table_fp_list->RecCnt = $packing_table_fp_list->StartRec - 1;
if ($packing_table_fp_list->Recordset && !$packing_table_fp_list->Recordset->EOF) {
	$packing_table_fp_list->Recordset->moveFirst();
	$selectLimit = $packing_table_fp_list->UseSelectLimit;
	if (!$selectLimit && $packing_table_fp_list->StartRec > 1)
		$packing_table_fp_list->Recordset->move($packing_table_fp_list->StartRec - 1);
} elseif (!$packing_table_fp->AllowAddDeleteRow && $packing_table_fp_list->StopRec == 0) {
	$packing_table_fp_list->StopRec = $packing_table_fp->GridAddRowCount;
}

// Initialize aggregate
$packing_table_fp->RowType = ROWTYPE_AGGREGATEINIT;
$packing_table_fp->resetAttributes();
$packing_table_fp_list->renderRow();
while ($packing_table_fp_list->RecCnt < $packing_table_fp_list->StopRec) {
	$packing_table_fp_list->RecCnt++;
	if ($packing_table_fp_list->RecCnt >= $packing_table_fp_list->StartRec) {
		$packing_table_fp_list->RowCnt++;

		// Set up key count
		$packing_table_fp_list->KeyCount = $packing_table_fp_list->RowIndex;

		// Init row class and style
		$packing_table_fp->resetAttributes();
		$packing_table_fp->CssClass = "";
		if ($packing_table_fp->isGridAdd()) {
		} else {
			$packing_table_fp_list->loadRowValues($packing_table_fp_list->Recordset); // Load row values
		}
		$packing_table_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$packing_table_fp->RowAttrs = array_merge($packing_table_fp->RowAttrs, array('data-rowindex'=>$packing_table_fp_list->RowCnt, 'id'=>'r' . $packing_table_fp_list->RowCnt . '_packing_table_fp', 'data-rowtype'=>$packing_table_fp->RowType));

		// Render row
		$packing_table_fp_list->renderRow();

		// Render list options
		$packing_table_fp_list->renderListOptions();
?>
	<tr<?php echo $packing_table_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_table_fp_list->ListOptions->render("body", "left", $packing_table_fp_list->RowCnt);
?>
	<?php if ($packing_table_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $packing_table_fp->id->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_id" class="packing_table_fp_id">
<span<?php echo $packing_table_fp->id->viewAttributes() ?>>
<?php echo $packing_table_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->out_ref->Visible) { // out_ref ?>
		<td data-name="out_ref"<?php echo $packing_table_fp->out_ref->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_out_ref" class="packing_table_fp_out_ref">
<span<?php echo $packing_table_fp->out_ref->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table_fp->out_ref->getViewValue())) && $packing_table_fp->out_ref->linkAttributes() <> "") { ?>
<a<?php echo $packing_table_fp->out_ref->linkAttributes() ?>><?php echo $packing_table_fp->out_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table_fp->out_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $packing_table_fp->product->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_product" class="packing_table_fp_product">
<span<?php echo $packing_table_fp->product->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table_fp->product->getViewValue())) && $packing_table_fp->product->linkAttributes() <> "") { ?>
<a<?php echo $packing_table_fp->product->linkAttributes() ?>><?php echo $packing_table_fp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table_fp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $packing_table_fp->rid->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_rid" class="packing_table_fp_rid">
<span<?php echo $packing_table_fp->rid->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table_fp->rid->getViewValue())) && $packing_table_fp->rid->linkAttributes() <> "") { ?>
<a<?php echo $packing_table_fp->rid->linkAttributes() ?>><?php echo $packing_table_fp->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table_fp->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $packing_table_fp->packets->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_packets" class="packing_table_fp_packets">
<span<?php echo $packing_table_fp->packets->viewAttributes() ?>>
<?php echo $packing_table_fp->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $packing_table_fp->quantity->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_quantity" class="packing_table_fp_quantity">
<span<?php echo $packing_table_fp->quantity->viewAttributes() ?>>
<?php echo $packing_table_fp->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $packing_table_fp->lot_no->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_lot_no" class="packing_table_fp_lot_no">
<span<?php echo $packing_table_fp->lot_no->viewAttributes() ?>>
<?php echo $packing_table_fp->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->par_com->Visible) { // par_com ?>
		<td data-name="par_com"<?php echo $packing_table_fp->par_com->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_par_com" class="packing_table_fp_par_com">
<span<?php echo $packing_table_fp->par_com->viewAttributes() ?>>
<?php echo $packing_table_fp->par_com->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $packing_table_fp->packing_type->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_packing_type" class="packing_table_fp_packing_type">
<span<?php echo $packing_table_fp->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table_fp->packing_type->getViewValue())) && $packing_table_fp->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $packing_table_fp->packing_type->linkAttributes() ?>><?php echo $packing_table_fp->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table_fp->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $packing_table_fp->godown->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_godown" class="packing_table_fp_godown">
<span<?php echo $packing_table_fp->godown->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table_fp->godown->getViewValue())) && $packing_table_fp->godown->linkAttributes() <> "") { ?>
<a<?php echo $packing_table_fp->godown->linkAttributes() ?>><?php echo $packing_table_fp->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table_fp->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $packing_table_fp->dated->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_dated" class="packing_table_fp_dated">
<span<?php echo $packing_table_fp->dated->viewAttributes() ?>>
<?php echo $packing_table_fp->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $packing_table_fp->employee_id->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_employee_id" class="packing_table_fp_employee_id">
<span<?php echo $packing_table_fp->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table_fp->employee_id->getViewValue())) && $packing_table_fp->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_table_fp->employee_id->linkAttributes() ?>><?php echo $packing_table_fp->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table_fp->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $packing_table_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_operator" class="packing_table_fp_operator">
<span<?php echo $packing_table_fp->operator->viewAttributes() ?>>
<?php echo $packing_table_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $packing_table_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_datetime" class="packing_table_fp_datetime">
<span<?php echo $packing_table_fp->datetime->viewAttributes() ?>>
<?php echo $packing_table_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $packing_table_fp->remarks->cellAttributes() ?>>
<span id="el<?php echo $packing_table_fp_list->RowCnt ?>_packing_table_fp_remarks" class="packing_table_fp_remarks">
<span<?php echo $packing_table_fp->remarks->viewAttributes() ?>>
<?php echo $packing_table_fp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_table_fp_list->ListOptions->render("body", "right", $packing_table_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$packing_table_fp->isGridAdd())
		$packing_table_fp_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$packing_table_fp->RowType = ROWTYPE_AGGREGATE;
$packing_table_fp->resetAttributes();
$packing_table_fp_list->renderRow();
?>
<?php if ($packing_table_fp_list->TotalRecs > 0 && !$packing_table_fp->isGridAdd() && !$packing_table_fp->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$packing_table_fp_list->renderListOptions();

// Render list options (footer, left)
$packing_table_fp_list->ListOptions->render("footer", "left");
?>
	<?php if ($packing_table_fp->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $packing_table_fp->id->footerCellClass() ?>"><span id="elf_packing_table_fp_id" class="packing_table_fp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->out_ref->Visible) { // out_ref ?>
		<td data-name="out_ref" class="<?php echo $packing_table_fp->out_ref->footerCellClass() ?>"><span id="elf_packing_table_fp_out_ref" class="packing_table_fp_out_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $packing_table_fp->product->footerCellClass() ?>"><span id="elf_packing_table_fp_product" class="packing_table_fp_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $packing_table_fp->rid->footerCellClass() ?>"><span id="elf_packing_table_fp_rid" class="packing_table_fp_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $packing_table_fp->packets->footerCellClass() ?>"><span id="elf_packing_table_fp_packets" class="packing_table_fp_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $packing_table_fp->quantity->footerCellClass() ?>"><span id="elf_packing_table_fp_quantity" class="packing_table_fp_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_table_fp->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $packing_table_fp->lot_no->footerCellClass() ?>"><span id="elf_packing_table_fp_lot_no" class="packing_table_fp_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->par_com->Visible) { // par_com ?>
		<td data-name="par_com" class="<?php echo $packing_table_fp->par_com->footerCellClass() ?>"><span id="elf_packing_table_fp_par_com" class="packing_table_fp_par_com">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $packing_table_fp->packing_type->footerCellClass() ?>"><span id="elf_packing_table_fp_packing_type" class="packing_table_fp_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $packing_table_fp->godown->footerCellClass() ?>"><span id="elf_packing_table_fp_godown" class="packing_table_fp_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $packing_table_fp->dated->footerCellClass() ?>"><span id="elf_packing_table_fp_dated" class="packing_table_fp_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id" class="<?php echo $packing_table_fp->employee_id->footerCellClass() ?>"><span id="elf_packing_table_fp_employee_id" class="packing_table_fp_employee_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $packing_table_fp->operator->footerCellClass() ?>"><span id="elf_packing_table_fp_operator" class="packing_table_fp_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $packing_table_fp->datetime->footerCellClass() ?>"><span id="elf_packing_table_fp_datetime" class="packing_table_fp_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $packing_table_fp->remarks->footerCellClass() ?>"><span id="elf_packing_table_fp_remarks" class="packing_table_fp_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$packing_table_fp_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$packing_table_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($packing_table_fp_list->Recordset)
	$packing_table_fp_list->Recordset->Close();
?>
<?php if (!$packing_table_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$packing_table_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_table_fp_list->Pager)) $packing_table_fp_list->Pager = new PrevNextPager($packing_table_fp_list->StartRec, $packing_table_fp_list->DisplayRecs, $packing_table_fp_list->TotalRecs, $packing_table_fp_list->AutoHidePager) ?>
<?php if ($packing_table_fp_list->Pager->RecordCount > 0 && $packing_table_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_table_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_table_fp_list->pageUrl() ?>start=<?php echo $packing_table_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_table_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_table_fp_list->pageUrl() ?>start=<?php echo $packing_table_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_table_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_table_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_table_fp_list->pageUrl() ?>start=<?php echo $packing_table_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_table_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_table_fp_list->pageUrl() ?>start=<?php echo $packing_table_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_table_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_table_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_table_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_table_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_table_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_table_fp_list->TotalRecs > 0 && (!$packing_table_fp_list->AutoHidePageSizeSelector || $packing_table_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_table_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_table_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_table_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_table_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_table_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_table_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_table_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_table_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($packing_table_fp_list->TotalRecs == 0 && !$packing_table_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $packing_table_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$packing_table_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_table_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$packing_table_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_packing_table_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_table_fp_list->terminate();
?>