<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_table_add = new packing_table_add();

// Run the page
$packing_table_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_table_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpacking_tableadd = currentForm = new ew.Form("fpacking_tableadd", "add");

// Validate form
fpacking_tableadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($packing_table_add->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->ref->caption(), $packing_table->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->out_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_out_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->out_ref->caption(), $packing_table->out_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_out_ref");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table->out_ref->errorMessage()) ?>");
		<?php if ($packing_table_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->product->caption(), $packing_table->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->rid->caption(), $packing_table->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->tmp_lot->Required) { ?>
			elm = this.getElements("x" + infix + "_tmp_lot");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->tmp_lot->caption(), $packing_table->tmp_lot->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->packets->caption(), $packing_table->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table->packets->errorMessage()) ?>");
		<?php if ($packing_table_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->quantity->caption(), $packing_table->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table->quantity->errorMessage()) ?>");
		<?php if ($packing_table_add->par_com->Required) { ?>
			elm = this.getElements("x" + infix + "_par_com");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->par_com->caption(), $packing_table->par_com->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->packing_type->caption(), $packing_table->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->godown->caption(), $packing_table->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->employee_id->caption(), $packing_table->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->dated->caption(), $packing_table->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($packing_table->dated->errorMessage()) ?>");
		<?php if ($packing_table_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->operator->caption(), $packing_table->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->datetime->caption(), $packing_table->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_table_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_table->remarks->caption(), $packing_table->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpacking_tableadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_tableadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_tableadd.lists["x_ref[]"] = <?php echo $packing_table_add->ref->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_ref[]"].options = <?php echo JsonEncode($packing_table_add->ref->lookupOptions()) ?>;
fpacking_tableadd.lists["x_out_ref"] = <?php echo $packing_table_add->out_ref->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_out_ref"].options = <?php echo JsonEncode($packing_table_add->out_ref->lookupOptions()) ?>;
fpacking_tableadd.autoSuggests["x_out_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_tableadd.lists["x_product"] = <?php echo $packing_table_add->product->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_product"].options = <?php echo JsonEncode($packing_table_add->product->lookupOptions()) ?>;
fpacking_tableadd.lists["x_rid"] = <?php echo $packing_table_add->rid->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_rid"].options = <?php echo JsonEncode($packing_table_add->rid->lookupOptions()) ?>;
fpacking_tableadd.lists["x_par_com"] = <?php echo $packing_table_add->par_com->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_par_com"].options = <?php echo JsonEncode($packing_table_add->par_com->options(FALSE, TRUE)) ?>;
fpacking_tableadd.lists["x_packing_type"] = <?php echo $packing_table_add->packing_type->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_packing_type"].options = <?php echo JsonEncode($packing_table_add->packing_type->lookupOptions()) ?>;
fpacking_tableadd.lists["x_godown"] = <?php echo $packing_table_add->godown->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_godown"].options = <?php echo JsonEncode($packing_table_add->godown->lookupOptions()) ?>;
fpacking_tableadd.lists["x_employee_id[]"] = <?php echo $packing_table_add->employee_id->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_employee_id[]"].options = <?php echo JsonEncode($packing_table_add->employee_id->lookupOptions()) ?>;
fpacking_tableadd.lists["x_operator"] = <?php echo $packing_table_add->operator->Lookup->toClientList() ?>;
fpacking_tableadd.lists["x_operator"].options = <?php echo JsonEncode($packing_table_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_table_add->showPageHeader(); ?>
<?php
$packing_table_add->showMessage();
?>
<form name="fpacking_tableadd" id="fpacking_tableadd" class="<?php echo $packing_table_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_table_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_table_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_table">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$packing_table_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($packing_table->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_packing_table_ref" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->ref->caption() ?><?php echo ($packing_table->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->ref->cellAttributes() ?>>
<span id="el_packing_table_ref">
<div id="tp_x_ref" class="ew-template"><input type="checkbox" class="form-check-input" data-table="packing_table" data-field="x_ref" data-value-separator="<?php echo $packing_table->ref->displayValueSeparatorAttribute() ?>" name="x_ref[]" id="x_ref[]" value="{value}"<?php echo $packing_table->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $packing_table->ref->checkBoxListHtml(FALSE, "x_ref[]") ?>
</div></div>
<?php echo $packing_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
<?php echo $packing_table->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->out_ref->Visible) { // out_ref ?>
	<div id="r_out_ref" class="form-group row">
		<label id="elh_packing_table_out_ref" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->out_ref->caption() ?><?php echo ($packing_table->out_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->out_ref->cellAttributes() ?>>
<span id="el_packing_table_out_ref">
<?php
$wrkonchange = "" . trim(@$packing_table->out_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$packing_table->out_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_out_ref" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_out_ref" id="sv_x_out_ref" value="<?php echo RemoveHtml($packing_table->out_ref->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($packing_table->out_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($packing_table->out_ref->getPlaceHolder()) ?>"<?php echo $packing_table->out_ref->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_table" data-field="x_out_ref" data-value-separator="<?php echo $packing_table->out_ref->displayValueSeparatorAttribute() ?>" name="x_out_ref" id="x_out_ref" value="<?php echo HtmlEncode($packing_table->out_ref->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpacking_tableadd.createAutoSuggest({"id":"x_out_ref","forceSelect":false});
</script>
<?php echo $packing_table->out_ref->Lookup->getParamTag("p_x_out_ref") ?>
</span>
<?php echo $packing_table->out_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_packing_table_product" for="x_product" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->product->caption() ?><?php echo ($packing_table->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->product->cellAttributes() ?>>
<span id="el_packing_table_product">
<?php $packing_table->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$packing_table->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table" data-field="x_product" data-value-separator="<?php echo $packing_table->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $packing_table->product->editAttributes() ?>>
		<?php echo $packing_table->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $packing_table->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $packing_table->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_packing_table_rid" for="x_rid" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->rid->caption() ?><?php echo ($packing_table->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->rid->cellAttributes() ?>>
<span id="el_packing_table_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table" data-field="x_rid" data-value-separator="<?php echo $packing_table->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $packing_table->rid->editAttributes() ?>>
		<?php echo $packing_table->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $packing_table->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $packing_table->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label id="elh_packing_table_tmp_lot" for="x_tmp_lot" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->tmp_lot->caption() ?><?php echo ($packing_table->tmp_lot->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->tmp_lot->cellAttributes() ?>>
<span id="el_packing_table_tmp_lot">
<input type="text" data-table="packing_table" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($packing_table->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $packing_table->tmp_lot->EditValue ?>"<?php echo $packing_table->tmp_lot->editAttributes() ?>>
</span>
<?php echo $packing_table->tmp_lot->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_packing_table_packets" for="x_packets" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->packets->caption() ?><?php echo ($packing_table->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->packets->cellAttributes() ?>>
<span id="el_packing_table_packets">
<input type="text" data-table="packing_table" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($packing_table->packets->getPlaceHolder()) ?>" value="<?php echo $packing_table->packets->EditValue ?>"<?php echo $packing_table->packets->editAttributes() ?>>
</span>
<?php echo $packing_table->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_packing_table_quantity" for="x_quantity" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->quantity->caption() ?><?php echo ($packing_table->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->quantity->cellAttributes() ?>>
<span id="el_packing_table_quantity">
<input type="text" data-table="packing_table" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($packing_table->quantity->getPlaceHolder()) ?>" value="<?php echo $packing_table->quantity->EditValue ?>"<?php echo $packing_table->quantity->editAttributes() ?>>
</span>
<?php echo $packing_table->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->par_com->Visible) { // par_com ?>
	<div id="r_par_com" class="form-group row">
		<label id="elh_packing_table_par_com" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->par_com->caption() ?><?php echo ($packing_table->par_com->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->par_com->cellAttributes() ?>>
<span id="el_packing_table_par_com">
<div id="tp_x_par_com" class="ew-template"><input type="radio" class="form-check-input" data-table="packing_table" data-field="x_par_com" data-value-separator="<?php echo $packing_table->par_com->displayValueSeparatorAttribute() ?>" name="x_par_com" id="x_par_com" value="{value}"<?php echo $packing_table->par_com->editAttributes() ?>></div>
<div id="dsl_x_par_com" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $packing_table->par_com->radioButtonListHtml(FALSE, "x_par_com") ?>
</div></div>
</span>
<?php echo $packing_table->par_com->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_packing_table_packing_type" for="x_packing_type" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->packing_type->caption() ?><?php echo ($packing_table->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->packing_type->cellAttributes() ?>>
<span id="el_packing_table_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table" data-field="x_packing_type" data-value-separator="<?php echo $packing_table->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $packing_table->packing_type->editAttributes() ?>>
		<?php echo $packing_table->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$packing_table->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $packing_table->packing_type->caption() ?>" data-title="<?php echo $packing_table->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $packing_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $packing_table->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_packing_table_godown" for="x_godown" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->godown->caption() ?><?php echo ($packing_table->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->godown->cellAttributes() ?>>
<span id="el_packing_table_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table" data-field="x_godown" data-value-separator="<?php echo $packing_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $packing_table->godown->editAttributes() ?>>
		<?php echo $packing_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$packing_table->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $packing_table->godown->caption() ?>" data-title="<?php echo $packing_table->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_godown',url:'godown_tableaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $packing_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $packing_table->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_packing_table_employee_id" for="x_employee_id" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->employee_id->caption() ?><?php echo ($packing_table->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->employee_id->cellAttributes() ?>>
<span id="el_packing_table_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($packing_table->employee_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($packing_table->employee_id->ViewValue) : $packing_table->employee_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($packing_table->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($packing_table->employee_id->ReadOnly || $packing_table->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "production_employee_f") && !$packing_table->employee_id->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_employee_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $packing_table->employee_id->caption() ?>" data-title="<?php echo $packing_table->employee_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_employee_id[]',url:'production_employee_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
	</div>
</div>
<?php echo $packing_table->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="packing_table" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $packing_table->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $packing_table->employee_id->CurrentValue ?>"<?php echo $packing_table->employee_id->editAttributes() ?>>
</span>
<?php echo $packing_table->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_packing_table_dated" for="x_dated" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->dated->caption() ?><?php echo ($packing_table->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->dated->cellAttributes() ?>>
<span id="el_packing_table_dated">
<input type="text" data-table="packing_table" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($packing_table->dated->getPlaceHolder()) ?>" value="<?php echo $packing_table->dated->EditValue ?>"<?php echo $packing_table->dated->editAttributes() ?>>
<?php if (!$packing_table->dated->ReadOnly && !$packing_table->dated->Disabled && !isset($packing_table->dated->EditAttrs["readonly"]) && !isset($packing_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpacking_tableadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $packing_table->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($packing_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_packing_table_remarks" for="x_remarks" class="<?php echo $packing_table_add->LeftColumnClass ?>"><?php echo $packing_table->remarks->caption() ?><?php echo ($packing_table->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $packing_table_add->RightColumnClass ?>"><div<?php echo $packing_table->remarks->cellAttributes() ?>>
<span id="el_packing_table_remarks">
<textarea data-table="packing_table" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($packing_table->remarks->getPlaceHolder()) ?>"<?php echo $packing_table->remarks->editAttributes() ?>><?php echo $packing_table->remarks->EditValue ?></textarea>
</span>
<?php echo $packing_table->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$packing_table_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $packing_table_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $packing_table_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$packing_table_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$packing_table_add->terminate();
?>