<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_table_list = new packing_table_list();

// Run the page
$packing_table_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_table_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpacking_tablelist = currentForm = new ew.Form("fpacking_tablelist", "list");
fpacking_tablelist.formKeyCountName = '<?php echo $packing_table_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpacking_tablelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_tablelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_tablelist.lists["x_out_ref"] = <?php echo $packing_table_list->out_ref->Lookup->toClientList() ?>;
fpacking_tablelist.lists["x_out_ref"].options = <?php echo JsonEncode($packing_table_list->out_ref->lookupOptions()) ?>;
fpacking_tablelist.autoSuggests["x_out_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_tablelist.lists["x_product"] = <?php echo $packing_table_list->product->Lookup->toClientList() ?>;
fpacking_tablelist.lists["x_product"].options = <?php echo JsonEncode($packing_table_list->product->lookupOptions()) ?>;
fpacking_tablelist.lists["x_rid"] = <?php echo $packing_table_list->rid->Lookup->toClientList() ?>;
fpacking_tablelist.lists["x_rid"].options = <?php echo JsonEncode($packing_table_list->rid->lookupOptions()) ?>;
fpacking_tablelist.lists["x_par_com"] = <?php echo $packing_table_list->par_com->Lookup->toClientList() ?>;
fpacking_tablelist.lists["x_par_com"].options = <?php echo JsonEncode($packing_table_list->par_com->options(FALSE, TRUE)) ?>;
fpacking_tablelist.lists["x_packing_type"] = <?php echo $packing_table_list->packing_type->Lookup->toClientList() ?>;
fpacking_tablelist.lists["x_packing_type"].options = <?php echo JsonEncode($packing_table_list->packing_type->lookupOptions()) ?>;
fpacking_tablelist.lists["x_godown"] = <?php echo $packing_table_list->godown->Lookup->toClientList() ?>;
fpacking_tablelist.lists["x_godown"].options = <?php echo JsonEncode($packing_table_list->godown->lookupOptions()) ?>;
fpacking_tablelist.lists["x_employee_id[]"] = <?php echo $packing_table_list->employee_id->Lookup->toClientList() ?>;
fpacking_tablelist.lists["x_employee_id[]"].options = <?php echo JsonEncode($packing_table_list->employee_id->lookupOptions()) ?>;
fpacking_tablelist.lists["x_operator"] = <?php echo $packing_table_list->operator->Lookup->toClientList() ?>;
fpacking_tablelist.lists["x_operator"].options = <?php echo JsonEncode($packing_table_list->operator->lookupOptions()) ?>;

// Form object for search
var fpacking_tablelistsrch = currentSearchForm = new ew.Form("fpacking_tablelistsrch");

// Filters
fpacking_tablelistsrch.filterList = <?php echo $packing_table_list->getFilterList() ?>;

// Init search panel as collapsed
fpacking_tablelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($packing_table_list->TotalRecs > 0 && $packing_table_list->ExportOptions->visible()) { ?>
<?php $packing_table_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_table_list->ImportOptions->visible()) { ?>
<?php $packing_table_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($packing_table_list->SearchOptions->visible()) { ?>
<?php $packing_table_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($packing_table_list->FilterOptions->visible()) { ?>
<?php $packing_table_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$packing_table_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$packing_table->isExport() && !$packing_table->CurrentAction) { ?>
<form name="fpacking_tablelistsrch" id="fpacking_tablelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($packing_table_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpacking_tablelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="packing_table">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($packing_table_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($packing_table_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $packing_table_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($packing_table_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($packing_table_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($packing_table_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($packing_table_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $packing_table_list->showPageHeader(); ?>
<?php
$packing_table_list->showMessage();
?>
<?php if ($packing_table_list->TotalRecs > 0 || $packing_table->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($packing_table_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> packing_table">
<?php if (!$packing_table->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$packing_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_table_list->Pager)) $packing_table_list->Pager = new PrevNextPager($packing_table_list->StartRec, $packing_table_list->DisplayRecs, $packing_table_list->TotalRecs, $packing_table_list->AutoHidePager) ?>
<?php if ($packing_table_list->Pager->RecordCount > 0 && $packing_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_table_list->pageUrl() ?>start=<?php echo $packing_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_table_list->pageUrl() ?>start=<?php echo $packing_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_table_list->pageUrl() ?>start=<?php echo $packing_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_table_list->pageUrl() ?>start=<?php echo $packing_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_table_list->TotalRecs > 0 && (!$packing_table_list->AutoHidePageSizeSelector || $packing_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpacking_tablelist" id="fpacking_tablelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_table_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_table_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_table">
<div id="gmp_packing_table" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($packing_table_list->TotalRecs > 0 || $packing_table->isGridEdit()) { ?>
<table id="tbl_packing_tablelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$packing_table_list->RowType = ROWTYPE_HEADER;

// Render list options
$packing_table_list->renderListOptions();

// Render list options (header, left)
$packing_table_list->ListOptions->render("header", "left");
?>
<?php if ($packing_table->id->Visible) { // id ?>
	<?php if ($packing_table->sortUrl($packing_table->id) == "") { ?>
		<th data-name="id" class="<?php echo $packing_table->id->headerCellClass() ?>"><div id="elh_packing_table_id" class="packing_table_id"><div class="ew-table-header-caption"><?php echo $packing_table->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $packing_table->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->id) ?>',2);"><div id="elh_packing_table_id" class="packing_table_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->out_ref->Visible) { // out_ref ?>
	<?php if ($packing_table->sortUrl($packing_table->out_ref) == "") { ?>
		<th data-name="out_ref" class="<?php echo $packing_table->out_ref->headerCellClass() ?>"><div id="elh_packing_table_out_ref" class="packing_table_out_ref"><div class="ew-table-header-caption"><?php echo $packing_table->out_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="out_ref" class="<?php echo $packing_table->out_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->out_ref) ?>',2);"><div id="elh_packing_table_out_ref" class="packing_table_out_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->out_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->out_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->out_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->product->Visible) { // product ?>
	<?php if ($packing_table->sortUrl($packing_table->product) == "") { ?>
		<th data-name="product" class="<?php echo $packing_table->product->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_packing_table_product" class="packing_table_product"><div class="ew-table-header-caption"><?php echo $packing_table->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $packing_table->product->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->product) ?>',2);"><div id="elh_packing_table_product" class="packing_table_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->rid->Visible) { // rid ?>
	<?php if ($packing_table->sortUrl($packing_table->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $packing_table->rid->headerCellClass() ?>"><div id="elh_packing_table_rid" class="packing_table_rid"><div class="ew-table-header-caption"><?php echo $packing_table->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $packing_table->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->rid) ?>',2);"><div id="elh_packing_table_rid" class="packing_table_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($packing_table->sortUrl($packing_table->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $packing_table->tmp_lot->headerCellClass() ?>"><div id="elh_packing_table_tmp_lot" class="packing_table_tmp_lot"><div class="ew-table-header-caption"><?php echo $packing_table->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $packing_table->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->tmp_lot) ?>',2);"><div id="elh_packing_table_tmp_lot" class="packing_table_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->tmp_lot->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_table->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->packets->Visible) { // packets ?>
	<?php if ($packing_table->sortUrl($packing_table->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $packing_table->packets->headerCellClass() ?>"><div id="elh_packing_table_packets" class="packing_table_packets"><div class="ew-table-header-caption"><?php echo $packing_table->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $packing_table->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->packets) ?>',2);"><div id="elh_packing_table_packets" class="packing_table_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->quantity->Visible) { // quantity ?>
	<?php if ($packing_table->sortUrl($packing_table->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $packing_table->quantity->headerCellClass() ?>"><div id="elh_packing_table_quantity" class="packing_table_quantity"><div class="ew-table-header-caption"><?php echo $packing_table->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $packing_table->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->quantity) ?>',2);"><div id="elh_packing_table_quantity" class="packing_table_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->par_com->Visible) { // par_com ?>
	<?php if ($packing_table->sortUrl($packing_table->par_com) == "") { ?>
		<th data-name="par_com" class="<?php echo $packing_table->par_com->headerCellClass() ?>"><div id="elh_packing_table_par_com" class="packing_table_par_com"><div class="ew-table-header-caption"><?php echo $packing_table->par_com->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="par_com" class="<?php echo $packing_table->par_com->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->par_com) ?>',2);"><div id="elh_packing_table_par_com" class="packing_table_par_com">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->par_com->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->par_com->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->par_com->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->packing_type->Visible) { // packing_type ?>
	<?php if ($packing_table->sortUrl($packing_table->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $packing_table->packing_type->headerCellClass() ?>"><div id="elh_packing_table_packing_type" class="packing_table_packing_type"><div class="ew-table-header-caption"><?php echo $packing_table->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $packing_table->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->packing_type) ?>',2);"><div id="elh_packing_table_packing_type" class="packing_table_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->godown->Visible) { // godown ?>
	<?php if ($packing_table->sortUrl($packing_table->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $packing_table->godown->headerCellClass() ?>"><div id="elh_packing_table_godown" class="packing_table_godown"><div class="ew-table-header-caption"><?php echo $packing_table->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $packing_table->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->godown) ?>',2);"><div id="elh_packing_table_godown" class="packing_table_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->employee_id->Visible) { // employee_id ?>
	<?php if ($packing_table->sortUrl($packing_table->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $packing_table->employee_id->headerCellClass() ?>"><div id="elh_packing_table_employee_id" class="packing_table_employee_id"><div class="ew-table-header-caption"><?php echo $packing_table->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $packing_table->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->employee_id) ?>',2);"><div id="elh_packing_table_employee_id" class="packing_table_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->dated->Visible) { // dated ?>
	<?php if ($packing_table->sortUrl($packing_table->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $packing_table->dated->headerCellClass() ?>"><div id="elh_packing_table_dated" class="packing_table_dated"><div class="ew-table-header-caption"><?php echo $packing_table->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $packing_table->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->dated) ?>',2);"><div id="elh_packing_table_dated" class="packing_table_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->operator->Visible) { // operator ?>
	<?php if ($packing_table->sortUrl($packing_table->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $packing_table->operator->headerCellClass() ?>"><div id="elh_packing_table_operator" class="packing_table_operator"><div class="ew-table-header-caption"><?php echo $packing_table->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $packing_table->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->operator) ?>',2);"><div id="elh_packing_table_operator" class="packing_table_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->datetime->Visible) { // datetime ?>
	<?php if ($packing_table->sortUrl($packing_table->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $packing_table->datetime->headerCellClass() ?>"><div id="elh_packing_table_datetime" class="packing_table_datetime"><div class="ew-table-header-caption"><?php echo $packing_table->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $packing_table->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->datetime) ?>',2);"><div id="elh_packing_table_datetime" class="packing_table_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($packing_table->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($packing_table->remarks->Visible) { // remarks ?>
	<?php if ($packing_table->sortUrl($packing_table->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $packing_table->remarks->headerCellClass() ?>"><div id="elh_packing_table_remarks" class="packing_table_remarks"><div class="ew-table-header-caption"><?php echo $packing_table->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $packing_table->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $packing_table->SortUrl($packing_table->remarks) ?>',2);"><div id="elh_packing_table_remarks" class="packing_table_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $packing_table->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($packing_table->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($packing_table->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$packing_table_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($packing_table->ExportAll && $packing_table->isExport()) {
	$packing_table_list->StopRec = $packing_table_list->TotalRecs;
} else {

	// Set the last record to display
	if ($packing_table_list->TotalRecs > $packing_table_list->StartRec + $packing_table_list->DisplayRecs - 1)
		$packing_table_list->StopRec = $packing_table_list->StartRec + $packing_table_list->DisplayRecs - 1;
	else
		$packing_table_list->StopRec = $packing_table_list->TotalRecs;
}
$packing_table_list->RecCnt = $packing_table_list->StartRec - 1;
if ($packing_table_list->Recordset && !$packing_table_list->Recordset->EOF) {
	$packing_table_list->Recordset->moveFirst();
	$selectLimit = $packing_table_list->UseSelectLimit;
	if (!$selectLimit && $packing_table_list->StartRec > 1)
		$packing_table_list->Recordset->move($packing_table_list->StartRec - 1);
} elseif (!$packing_table->AllowAddDeleteRow && $packing_table_list->StopRec == 0) {
	$packing_table_list->StopRec = $packing_table->GridAddRowCount;
}

// Initialize aggregate
$packing_table->RowType = ROWTYPE_AGGREGATEINIT;
$packing_table->resetAttributes();
$packing_table_list->renderRow();
while ($packing_table_list->RecCnt < $packing_table_list->StopRec) {
	$packing_table_list->RecCnt++;
	if ($packing_table_list->RecCnt >= $packing_table_list->StartRec) {
		$packing_table_list->RowCnt++;

		// Set up key count
		$packing_table_list->KeyCount = $packing_table_list->RowIndex;

		// Init row class and style
		$packing_table->resetAttributes();
		$packing_table->CssClass = "";
		if ($packing_table->isGridAdd()) {
		} else {
			$packing_table_list->loadRowValues($packing_table_list->Recordset); // Load row values
		}
		$packing_table->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$packing_table->RowAttrs = array_merge($packing_table->RowAttrs, array('data-rowindex'=>$packing_table_list->RowCnt, 'id'=>'r' . $packing_table_list->RowCnt . '_packing_table', 'data-rowtype'=>$packing_table->RowType));

		// Render row
		$packing_table_list->renderRow();

		// Render list options
		$packing_table_list->renderListOptions();
?>
	<tr<?php echo $packing_table->rowAttributes() ?>>
<?php

// Render list options (body, left)
$packing_table_list->ListOptions->render("body", "left", $packing_table_list->RowCnt);
?>
	<?php if ($packing_table->id->Visible) { // id ?>
		<td data-name="id"<?php echo $packing_table->id->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_id" class="packing_table_id">
<span<?php echo $packing_table->id->viewAttributes() ?>>
<?php echo $packing_table->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->out_ref->Visible) { // out_ref ?>
		<td data-name="out_ref"<?php echo $packing_table->out_ref->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_out_ref" class="packing_table_out_ref">
<span<?php echo $packing_table->out_ref->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->out_ref->getViewValue())) && $packing_table->out_ref->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->out_ref->linkAttributes() ?>><?php echo $packing_table->out_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->out_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->product->Visible) { // product ?>
		<td data-name="product"<?php echo $packing_table->product->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_product" class="packing_table_product">
<span<?php echo $packing_table->product->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->product->getViewValue())) && $packing_table->product->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->product->linkAttributes() ?>><?php echo $packing_table->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $packing_table->rid->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_rid" class="packing_table_rid">
<span<?php echo $packing_table->rid->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->rid->getViewValue())) && $packing_table->rid->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->rid->linkAttributes() ?>><?php echo $packing_table->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $packing_table->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_tmp_lot" class="packing_table_tmp_lot">
<span<?php echo $packing_table->tmp_lot->viewAttributes() ?>>
<?php echo $packing_table->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $packing_table->packets->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_packets" class="packing_table_packets">
<span<?php echo $packing_table->packets->viewAttributes() ?>>
<?php echo $packing_table->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $packing_table->quantity->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_quantity" class="packing_table_quantity">
<span<?php echo $packing_table->quantity->viewAttributes() ?>>
<?php echo $packing_table->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->par_com->Visible) { // par_com ?>
		<td data-name="par_com"<?php echo $packing_table->par_com->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_par_com" class="packing_table_par_com">
<span<?php echo $packing_table->par_com->viewAttributes() ?>>
<?php echo $packing_table->par_com->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $packing_table->packing_type->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_packing_type" class="packing_table_packing_type">
<span<?php echo $packing_table->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->packing_type->getViewValue())) && $packing_table->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->packing_type->linkAttributes() ?>><?php echo $packing_table->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $packing_table->godown->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_godown" class="packing_table_godown">
<span<?php echo $packing_table->godown->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->godown->getViewValue())) && $packing_table->godown->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->godown->linkAttributes() ?>><?php echo $packing_table->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $packing_table->employee_id->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_employee_id" class="packing_table_employee_id">
<span<?php echo $packing_table->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->employee_id->getViewValue())) && $packing_table->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->employee_id->linkAttributes() ?>><?php echo $packing_table->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $packing_table->dated->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_dated" class="packing_table_dated">
<span<?php echo $packing_table->dated->viewAttributes() ?>>
<?php echo $packing_table->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $packing_table->operator->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_operator" class="packing_table_operator">
<span<?php echo $packing_table->operator->viewAttributes() ?>>
<?php echo $packing_table->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $packing_table->datetime->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_datetime" class="packing_table_datetime">
<span<?php echo $packing_table->datetime->viewAttributes() ?>>
<?php echo $packing_table->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($packing_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $packing_table->remarks->cellAttributes() ?>>
<span id="el<?php echo $packing_table_list->RowCnt ?>_packing_table_remarks" class="packing_table_remarks">
<span<?php echo $packing_table->remarks->viewAttributes() ?>>
<?php echo $packing_table->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$packing_table_list->ListOptions->render("body", "right", $packing_table_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$packing_table->isGridAdd())
		$packing_table_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$packing_table->RowType = ROWTYPE_AGGREGATE;
$packing_table->resetAttributes();
$packing_table_list->renderRow();
?>
<?php if ($packing_table_list->TotalRecs > 0 && !$packing_table->isGridAdd() && !$packing_table->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$packing_table_list->renderListOptions();

// Render list options (footer, left)
$packing_table_list->ListOptions->render("footer", "left");
?>
	<?php if ($packing_table->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $packing_table->id->footerCellClass() ?>"><span id="elf_packing_table_id" class="packing_table_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->out_ref->Visible) { // out_ref ?>
		<td data-name="out_ref" class="<?php echo $packing_table->out_ref->footerCellClass() ?>"><span id="elf_packing_table_out_ref" class="packing_table_out_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $packing_table->product->footerCellClass() ?>"><span id="elf_packing_table_product" class="packing_table_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $packing_table->rid->footerCellClass() ?>"><span id="elf_packing_table_rid" class="packing_table_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $packing_table->tmp_lot->footerCellClass() ?>"><span id="elf_packing_table_tmp_lot" class="packing_table_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $packing_table->packets->footerCellClass() ?>"><span id="elf_packing_table_packets" class="packing_table_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $packing_table->quantity->footerCellClass() ?>"><span id="elf_packing_table_quantity" class="packing_table_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $packing_table->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($packing_table->par_com->Visible) { // par_com ?>
		<td data-name="par_com" class="<?php echo $packing_table->par_com->footerCellClass() ?>"><span id="elf_packing_table_par_com" class="packing_table_par_com">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $packing_table->packing_type->footerCellClass() ?>"><span id="elf_packing_table_packing_type" class="packing_table_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $packing_table->godown->footerCellClass() ?>"><span id="elf_packing_table_godown" class="packing_table_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id" class="<?php echo $packing_table->employee_id->footerCellClass() ?>"><span id="elf_packing_table_employee_id" class="packing_table_employee_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $packing_table->dated->footerCellClass() ?>"><span id="elf_packing_table_dated" class="packing_table_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $packing_table->operator->footerCellClass() ?>"><span id="elf_packing_table_operator" class="packing_table_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $packing_table->datetime->footerCellClass() ?>"><span id="elf_packing_table_datetime" class="packing_table_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($packing_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $packing_table->remarks->footerCellClass() ?>"><span id="elf_packing_table_remarks" class="packing_table_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$packing_table_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$packing_table->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($packing_table_list->Recordset)
	$packing_table_list->Recordset->Close();
?>
<?php if (!$packing_table->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$packing_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($packing_table_list->Pager)) $packing_table_list->Pager = new PrevNextPager($packing_table_list->StartRec, $packing_table_list->DisplayRecs, $packing_table_list->TotalRecs, $packing_table_list->AutoHidePager) ?>
<?php if ($packing_table_list->Pager->RecordCount > 0 && $packing_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($packing_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $packing_table_list->pageUrl() ?>start=<?php echo $packing_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($packing_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $packing_table_list->pageUrl() ?>start=<?php echo $packing_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $packing_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($packing_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $packing_table_list->pageUrl() ?>start=<?php echo $packing_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($packing_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $packing_table_list->pageUrl() ?>start=<?php echo $packing_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $packing_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($packing_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $packing_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $packing_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $packing_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($packing_table_list->TotalRecs > 0 && (!$packing_table_list->AutoHidePageSizeSelector || $packing_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="packing_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($packing_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($packing_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($packing_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($packing_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($packing_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($packing_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $packing_table_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($packing_table_list->TotalRecs == 0 && !$packing_table->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $packing_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$packing_table_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$packing_table->isExport()) { ?>
<script>
ew.scrollableTable("gmp_packing_table", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_table_list->terminate();
?>