<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_table_search = new packing_table_search();

// Run the page
$packing_table_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_table_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($packing_table_search->IsModal) { ?>
var fpacking_tablesearch = currentAdvancedSearchForm = new ew.Form("fpacking_tablesearch", "search");
<?php } else { ?>
var fpacking_tablesearch = currentForm = new ew.Form("fpacking_tablesearch", "search");
<?php } ?>

// Form_CustomValidate event
fpacking_tablesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_tablesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_tablesearch.lists["x_ref[]"] = <?php echo $packing_table_search->ref->Lookup->toClientList() ?>;
fpacking_tablesearch.lists["x_ref[]"].options = <?php echo JsonEncode($packing_table_search->ref->lookupOptions()) ?>;
fpacking_tablesearch.lists["x_out_ref"] = <?php echo $packing_table_search->out_ref->Lookup->toClientList() ?>;
fpacking_tablesearch.lists["x_out_ref"].options = <?php echo JsonEncode($packing_table_search->out_ref->lookupOptions()) ?>;
fpacking_tablesearch.autoSuggests["x_out_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_tablesearch.lists["x_rid"] = <?php echo $packing_table_search->rid->Lookup->toClientList() ?>;
fpacking_tablesearch.lists["x_rid"].options = <?php echo JsonEncode($packing_table_search->rid->lookupOptions()) ?>;
fpacking_tablesearch.lists["x_par_com"] = <?php echo $packing_table_search->par_com->Lookup->toClientList() ?>;
fpacking_tablesearch.lists["x_par_com"].options = <?php echo JsonEncode($packing_table_search->par_com->options(FALSE, TRUE)) ?>;
fpacking_tablesearch.lists["x_packing_type"] = <?php echo $packing_table_search->packing_type->Lookup->toClientList() ?>;
fpacking_tablesearch.lists["x_packing_type"].options = <?php echo JsonEncode($packing_table_search->packing_type->lookupOptions()) ?>;
fpacking_tablesearch.lists["x_godown"] = <?php echo $packing_table_search->godown->Lookup->toClientList() ?>;
fpacking_tablesearch.lists["x_godown"].options = <?php echo JsonEncode($packing_table_search->godown->lookupOptions()) ?>;
fpacking_tablesearch.lists["x_employee_id[]"] = <?php echo $packing_table_search->employee_id->Lookup->toClientList() ?>;
fpacking_tablesearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($packing_table_search->employee_id->lookupOptions()) ?>;
fpacking_tablesearch.lists["x_operator"] = <?php echo $packing_table_search->operator->Lookup->toClientList() ?>;
fpacking_tablesearch.lists["x_operator"].options = <?php echo JsonEncode($packing_table_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpacking_tablesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_table->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_out_ref");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_table->out_ref->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_table->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_table->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_table->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_table_search->showPageHeader(); ?>
<?php
$packing_table_search->showMessage();
?>
<form name="fpacking_tablesearch" id="fpacking_tablesearch" class="<?php echo $packing_table_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_table_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_table_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_table">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$packing_table_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($packing_table->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_id"><?php echo $packing_table->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->id->cellAttributes() ?>>
			<span id="el_packing_table_id">
<input type="text" data-table="packing_table" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($packing_table->id->getPlaceHolder()) ?>" value="<?php echo $packing_table->id->EditValue ?>"<?php echo $packing_table->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_ref"><?php echo $packing_table->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->ref->cellAttributes() ?>>
			<span id="el_packing_table_ref">
<div id="tp_x_ref" class="ew-template"><input type="checkbox" class="form-check-input" data-table="packing_table" data-field="x_ref" data-value-separator="<?php echo $packing_table->ref->displayValueSeparatorAttribute() ?>" name="x_ref[]" id="x_ref[]" value="{value}"<?php echo $packing_table->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $packing_table->ref->checkBoxListHtml(FALSE, "x_ref[]") ?>
</div></div>
<?php echo $packing_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->out_ref->Visible) { // out_ref ?>
	<div id="r_out_ref" class="form-group row">
		<label class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_out_ref"><?php echo $packing_table->out_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_out_ref" id="z_out_ref" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->out_ref->cellAttributes() ?>>
			<span id="el_packing_table_out_ref">
<?php
$wrkonchange = "" . trim(@$packing_table->out_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$packing_table->out_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_out_ref" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_out_ref" id="sv_x_out_ref" value="<?php echo RemoveHtml($packing_table->out_ref->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($packing_table->out_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($packing_table->out_ref->getPlaceHolder()) ?>"<?php echo $packing_table->out_ref->editAttributes() ?>>
</span>
<input type="hidden" data-table="packing_table" data-field="x_out_ref" data-value-separator="<?php echo $packing_table->out_ref->displayValueSeparatorAttribute() ?>" name="x_out_ref" id="x_out_ref" value="<?php echo HtmlEncode($packing_table->out_ref->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpacking_tablesearch.createAutoSuggest({"id":"x_out_ref","forceSelect":false});
</script>
<?php echo $packing_table->out_ref->Lookup->getParamTag("p_x_out_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_rid"><?php echo $packing_table->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->rid->cellAttributes() ?>>
			<span id="el_packing_table_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table" data-field="x_rid" data-value-separator="<?php echo $packing_table->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $packing_table->rid->editAttributes() ?>>
		<?php echo $packing_table->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $packing_table->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_tmp_lot"><?php echo $packing_table->tmp_lot->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->tmp_lot->cellAttributes() ?>>
			<span id="el_packing_table_tmp_lot">
<input type="text" data-table="packing_table" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($packing_table->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $packing_table->tmp_lot->EditValue ?>"<?php echo $packing_table->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_packets"><?php echo $packing_table->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->packets->cellAttributes() ?>>
			<span id="el_packing_table_packets">
<input type="text" data-table="packing_table" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($packing_table->packets->getPlaceHolder()) ?>" value="<?php echo $packing_table->packets->EditValue ?>"<?php echo $packing_table->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_quantity"><?php echo $packing_table->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->quantity->cellAttributes() ?>>
			<span id="el_packing_table_quantity">
<input type="text" data-table="packing_table" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($packing_table->quantity->getPlaceHolder()) ?>" value="<?php echo $packing_table->quantity->EditValue ?>"<?php echo $packing_table->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->par_com->Visible) { // par_com ?>
	<div id="r_par_com" class="form-group row">
		<label class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_par_com"><?php echo $packing_table->par_com->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_par_com" id="z_par_com" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->par_com->cellAttributes() ?>>
			<span id="el_packing_table_par_com">
<div id="tp_x_par_com" class="ew-template"><input type="radio" class="form-check-input" data-table="packing_table" data-field="x_par_com" data-value-separator="<?php echo $packing_table->par_com->displayValueSeparatorAttribute() ?>" name="x_par_com" id="x_par_com" value="{value}"<?php echo $packing_table->par_com->editAttributes() ?>></div>
<div id="dsl_x_par_com" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $packing_table->par_com->radioButtonListHtml(FALSE, "x_par_com") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_packing_type"><?php echo $packing_table->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->packing_type->cellAttributes() ?>>
			<span id="el_packing_table_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table" data-field="x_packing_type" data-value-separator="<?php echo $packing_table->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $packing_table->packing_type->editAttributes() ?>>
		<?php echo $packing_table->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $packing_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_godown"><?php echo $packing_table->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->godown->cellAttributes() ?>>
			<span id="el_packing_table_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table" data-field="x_godown" data-value-separator="<?php echo $packing_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $packing_table->godown->editAttributes() ?>>
		<?php echo $packing_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $packing_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label for="x_employee_id" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_employee_id"><?php echo $packing_table->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->employee_id->cellAttributes() ?>>
			<span id="el_packing_table_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($packing_table->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($packing_table->employee_id->AdvancedSearch->ViewValue) : $packing_table->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($packing_table->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($packing_table->employee_id->ReadOnly || $packing_table->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $packing_table->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="packing_table" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $packing_table->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $packing_table->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $packing_table->employee_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_dated"><?php echo $packing_table->dated->caption() ?></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($packing_table->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_packing_table_dated">
<input type="text" data-table="packing_table" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($packing_table->dated->getPlaceHolder()) ?>" value="<?php echo $packing_table->dated->EditValue ?>"<?php echo $packing_table->dated->editAttributes() ?>>
<?php if (!$packing_table->dated->ReadOnly && !$packing_table->dated->Disabled && !isset($packing_table->dated->EditAttrs["readonly"]) && !isset($packing_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpacking_tablesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_packing_table_dated" class="btw1_dated d-none">
<input type="text" data-table="packing_table" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($packing_table->dated->getPlaceHolder()) ?>" value="<?php echo $packing_table->dated->EditValue2 ?>"<?php echo $packing_table->dated->editAttributes() ?>>
<?php if (!$packing_table->dated->ReadOnly && !$packing_table->dated->Disabled && !isset($packing_table->dated->EditAttrs["readonly"]) && !isset($packing_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpacking_tablesearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_operator"><?php echo $packing_table->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->operator->cellAttributes() ?>>
			<span id="el_packing_table_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_table" data-field="x_operator" data-value-separator="<?php echo $packing_table->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $packing_table->operator->editAttributes() ?>>
		<?php echo $packing_table->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $packing_table->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_datetime"><?php echo $packing_table->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($packing_table->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_packing_table_datetime">
<input type="text" data-table="packing_table" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($packing_table->datetime->getPlaceHolder()) ?>" value="<?php echo $packing_table->datetime->EditValue ?>"<?php echo $packing_table->datetime->editAttributes() ?>>
<?php if (!$packing_table->datetime->ReadOnly && !$packing_table->datetime->Disabled && !isset($packing_table->datetime->EditAttrs["readonly"]) && !isset($packing_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpacking_tablesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_packing_table_datetime" class="btw1_datetime d-none">
<input type="text" data-table="packing_table" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($packing_table->datetime->getPlaceHolder()) ?>" value="<?php echo $packing_table->datetime->EditValue2 ?>"<?php echo $packing_table->datetime->editAttributes() ?>>
<?php if (!$packing_table->datetime->ReadOnly && !$packing_table->datetime->Disabled && !isset($packing_table->datetime->EditAttrs["readonly"]) && !isset($packing_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpacking_tablesearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $packing_table_search->LeftColumnClass ?>"><span id="elh_packing_table_remarks"><?php echo $packing_table->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_table_search->RightColumnClass ?>"><div<?php echo $packing_table->remarks->cellAttributes() ?>>
			<span id="el_packing_table_remarks">
<input type="text" data-table="packing_table" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="40" placeholder="<?php echo HtmlEncode($packing_table->remarks->getPlaceHolder()) ?>" value="<?php echo $packing_table->remarks->EditValue ?>"<?php echo $packing_table->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$packing_table_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $packing_table_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$packing_table_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$packing_table_search->terminate();
?>