<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_table_view = new packing_table_view();

// Run the page
$packing_table_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_table_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$packing_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpacking_tableview = currentForm = new ew.Form("fpacking_tableview", "view");

// Form_CustomValidate event
fpacking_tableview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_tableview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_tableview.lists["x_ref[]"] = <?php echo $packing_table_view->ref->Lookup->toClientList() ?>;
fpacking_tableview.lists["x_ref[]"].options = <?php echo JsonEncode($packing_table_view->ref->lookupOptions()) ?>;
fpacking_tableview.lists["x_out_ref"] = <?php echo $packing_table_view->out_ref->Lookup->toClientList() ?>;
fpacking_tableview.lists["x_out_ref"].options = <?php echo JsonEncode($packing_table_view->out_ref->lookupOptions()) ?>;
fpacking_tableview.autoSuggests["x_out_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpacking_tableview.lists["x_rid"] = <?php echo $packing_table_view->rid->Lookup->toClientList() ?>;
fpacking_tableview.lists["x_rid"].options = <?php echo JsonEncode($packing_table_view->rid->lookupOptions()) ?>;
fpacking_tableview.lists["x_par_com"] = <?php echo $packing_table_view->par_com->Lookup->toClientList() ?>;
fpacking_tableview.lists["x_par_com"].options = <?php echo JsonEncode($packing_table_view->par_com->options(FALSE, TRUE)) ?>;
fpacking_tableview.lists["x_packing_type"] = <?php echo $packing_table_view->packing_type->Lookup->toClientList() ?>;
fpacking_tableview.lists["x_packing_type"].options = <?php echo JsonEncode($packing_table_view->packing_type->lookupOptions()) ?>;
fpacking_tableview.lists["x_godown"] = <?php echo $packing_table_view->godown->Lookup->toClientList() ?>;
fpacking_tableview.lists["x_godown"].options = <?php echo JsonEncode($packing_table_view->godown->lookupOptions()) ?>;
fpacking_tableview.lists["x_employee_id[]"] = <?php echo $packing_table_view->employee_id->Lookup->toClientList() ?>;
fpacking_tableview.lists["x_employee_id[]"].options = <?php echo JsonEncode($packing_table_view->employee_id->lookupOptions()) ?>;
fpacking_tableview.lists["x_operator"] = <?php echo $packing_table_view->operator->Lookup->toClientList() ?>;
fpacking_tableview.lists["x_operator"].options = <?php echo JsonEncode($packing_table_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$packing_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $packing_table_view->ExportOptions->render("body") ?>
<?php $packing_table_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $packing_table_view->showPageHeader(); ?>
<?php
$packing_table_view->showMessage();
?>
<form name="fpacking_tableview" id="fpacking_tableview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_table_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_table_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_table">
<input type="hidden" name="modal" value="<?php echo (int)$packing_table_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($packing_table->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_id"><?php echo $packing_table->id->caption() ?></span></td>
		<td data-name="id"<?php echo $packing_table->id->cellAttributes() ?>>
<span id="el_packing_table_id">
<span<?php echo $packing_table->id->viewAttributes() ?>>
<?php echo $packing_table->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->ref->Visible) { // ref ?>
	<tr id="r_ref">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_ref"><?php echo $packing_table->ref->caption() ?></span></td>
		<td data-name="ref"<?php echo $packing_table->ref->cellAttributes() ?>>
<span id="el_packing_table_ref">
<span<?php echo $packing_table->ref->viewAttributes() ?>>
<?php echo $packing_table->ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->out_ref->Visible) { // out_ref ?>
	<tr id="r_out_ref">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_out_ref"><?php echo $packing_table->out_ref->caption() ?></span></td>
		<td data-name="out_ref"<?php echo $packing_table->out_ref->cellAttributes() ?>>
<span id="el_packing_table_out_ref">
<span<?php echo $packing_table->out_ref->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->out_ref->getViewValue())) && $packing_table->out_ref->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->out_ref->linkAttributes() ?>><?php echo $packing_table->out_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->out_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_rid"><?php echo $packing_table->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $packing_table->rid->cellAttributes() ?>>
<span id="el_packing_table_rid">
<span<?php echo $packing_table->rid->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->rid->getViewValue())) && $packing_table->rid->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->rid->linkAttributes() ?>><?php echo $packing_table->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->tmp_lot->Visible) { // tmp_lot ?>
	<tr id="r_tmp_lot">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_tmp_lot"><?php echo $packing_table->tmp_lot->caption() ?></span></td>
		<td data-name="tmp_lot"<?php echo $packing_table->tmp_lot->cellAttributes() ?>>
<span id="el_packing_table_tmp_lot">
<span<?php echo $packing_table->tmp_lot->viewAttributes() ?>>
<?php echo $packing_table->tmp_lot->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->packets->Visible) { // packets ?>
	<tr id="r_packets">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_packets"><?php echo $packing_table->packets->caption() ?></span></td>
		<td data-name="packets"<?php echo $packing_table->packets->cellAttributes() ?>>
<span id="el_packing_table_packets">
<span<?php echo $packing_table->packets->viewAttributes() ?>>
<?php echo $packing_table->packets->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_quantity"><?php echo $packing_table->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $packing_table->quantity->cellAttributes() ?>>
<span id="el_packing_table_quantity">
<span<?php echo $packing_table->quantity->viewAttributes() ?>>
<?php echo $packing_table->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->par_com->Visible) { // par_com ?>
	<tr id="r_par_com">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_par_com"><?php echo $packing_table->par_com->caption() ?></span></td>
		<td data-name="par_com"<?php echo $packing_table->par_com->cellAttributes() ?>>
<span id="el_packing_table_par_com">
<span<?php echo $packing_table->par_com->viewAttributes() ?>>
<?php echo $packing_table->par_com->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_packing_type"><?php echo $packing_table->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $packing_table->packing_type->cellAttributes() ?>>
<span id="el_packing_table_packing_type">
<span<?php echo $packing_table->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->packing_type->getViewValue())) && $packing_table->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->packing_type->linkAttributes() ?>><?php echo $packing_table->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_godown"><?php echo $packing_table->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $packing_table->godown->cellAttributes() ?>>
<span id="el_packing_table_godown">
<span<?php echo $packing_table->godown->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->godown->getViewValue())) && $packing_table->godown->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->godown->linkAttributes() ?>><?php echo $packing_table->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->employee_id->Visible) { // employee_id ?>
	<tr id="r_employee_id">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_employee_id"><?php echo $packing_table->employee_id->caption() ?></span></td>
		<td data-name="employee_id"<?php echo $packing_table->employee_id->cellAttributes() ?>>
<span id="el_packing_table_employee_id">
<span<?php echo $packing_table->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($packing_table->employee_id->getViewValue())) && $packing_table->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $packing_table->employee_id->linkAttributes() ?>><?php echo $packing_table->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $packing_table->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_dated"><?php echo $packing_table->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $packing_table->dated->cellAttributes() ?>>
<span id="el_packing_table_dated">
<span<?php echo $packing_table->dated->viewAttributes() ?>>
<?php echo $packing_table->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_operator"><?php echo $packing_table->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $packing_table->operator->cellAttributes() ?>>
<span id="el_packing_table_operator">
<span<?php echo $packing_table->operator->viewAttributes() ?>>
<?php echo $packing_table->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_datetime"><?php echo $packing_table->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $packing_table->datetime->cellAttributes() ?>>
<span id="el_packing_table_datetime">
<span<?php echo $packing_table->datetime->viewAttributes() ?>>
<?php echo $packing_table->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($packing_table->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $packing_table_view->TableLeftColumnClass ?>"><span id="elh_packing_table_remarks"><?php echo $packing_table->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $packing_table->remarks->cellAttributes() ?>>
<span id="el_packing_table_remarks">
<span<?php echo $packing_table->remarks->viewAttributes() ?>>
<?php echo $packing_table->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$packing_table_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$packing_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$packing_table_view->terminate();
?>