<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_type_addopt = new packing_type_addopt();

// Run the page
$packing_type_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_type_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fpacking_typeaddopt = currentForm = new ew.Form("fpacking_typeaddopt", "addopt");

// Validate form
fpacking_typeaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($packing_type_addopt->packing->Required) { ?>
			elm = this.getElements("x" + infix + "_packing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_type->packing->caption(), $packing_type->packing->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_type_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_type->code->caption(), $packing_type->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($packing_type->code->errorMessage()) ?>");
		<?php if ($packing_type_addopt->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_type->process->caption(), $packing_type->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_type_addopt->internal_external->Required) { ?>
			elm = this.getElements("x" + infix + "_internal_external");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_type->internal_external->caption(), $packing_type->internal_external->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($packing_type_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $packing_type->status->caption(), $packing_type->status->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpacking_typeaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_typeaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_typeaddopt.lists["x_process[]"] = <?php echo $packing_type_addopt->process->Lookup->toClientList() ?>;
fpacking_typeaddopt.lists["x_process[]"].options = <?php echo JsonEncode($packing_type_addopt->process->lookupOptions()) ?>;
fpacking_typeaddopt.lists["x_internal_external"] = <?php echo $packing_type_addopt->internal_external->Lookup->toClientList() ?>;
fpacking_typeaddopt.lists["x_internal_external"].options = <?php echo JsonEncode($packing_type_addopt->internal_external->options(FALSE, TRUE)) ?>;
fpacking_typeaddopt.lists["x_status"] = <?php echo $packing_type_addopt->status->Lookup->toClientList() ?>;
fpacking_typeaddopt.lists["x_status"].options = <?php echo JsonEncode($packing_type_addopt->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_type_addopt->showPageHeader(); ?>
<?php
$packing_type_addopt->showMessage();
?>
<form name="fpacking_typeaddopt" id="fpacking_typeaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($packing_type_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_type_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $packing_type_addopt->TableVar ?>">
<?php if ($packing_type->packing->Visible) { // packing ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_packing"><?php echo $packing_type->packing->caption() ?><?php echo ($packing_type->packing->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="packing_type" data-field="x_packing" name="x_packing" id="x_packing" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($packing_type->packing->getPlaceHolder()) ?>" value="<?php echo $packing_type->packing->EditValue ?>"<?php echo $packing_type->packing->editAttributes() ?>>
<?php echo $packing_type->packing->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($packing_type->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $packing_type->code->caption() ?><?php echo ($packing_type->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="packing_type" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($packing_type->code->getPlaceHolder()) ?>" value="<?php echo $packing_type->code->EditValue ?>"<?php echo $packing_type->code->editAttributes() ?>>
<?php echo $packing_type->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($packing_type->process->Visible) { // process ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $packing_type->process->caption() ?><?php echo ($packing_type->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="packing_type" data-field="x_process" data-value-separator="<?php echo $packing_type->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $packing_type->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $packing_type->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $packing_type->process->Lookup->getParamTag("p_x_process") ?>
<?php echo $packing_type->process->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($packing_type->internal_external->Visible) { // internal_external ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_internal_external"><?php echo $packing_type->internal_external->caption() ?><?php echo ($packing_type->internal_external->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_type" data-field="x_internal_external" data-value-separator="<?php echo $packing_type->internal_external->displayValueSeparatorAttribute() ?>" id="x_internal_external" name="x_internal_external"<?php echo $packing_type->internal_external->editAttributes() ?>>
		<?php echo $packing_type->internal_external->selectOptionListHtml("x_internal_external") ?>
	</select>
</div>
<?php echo $packing_type->internal_external->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($packing_type->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $packing_type->status->caption() ?><?php echo ($packing_type->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_type" data-field="x_status" data-value-separator="<?php echo $packing_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $packing_type->status->editAttributes() ?>>
		<?php echo $packing_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $packing_type->status->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$packing_type_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$packing_type_addopt->terminate();
?>