<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$packing_type_search = new packing_type_search();

// Run the page
$packing_type_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$packing_type_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($packing_type_search->IsModal) { ?>
var fpacking_typesearch = currentAdvancedSearchForm = new ew.Form("fpacking_typesearch", "search");
<?php } else { ?>
var fpacking_typesearch = currentForm = new ew.Form("fpacking_typesearch", "search");
<?php } ?>

// Form_CustomValidate event
fpacking_typesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpacking_typesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpacking_typesearch.lists["x_process[]"] = <?php echo $packing_type_search->process->Lookup->toClientList() ?>;
fpacking_typesearch.lists["x_process[]"].options = <?php echo JsonEncode($packing_type_search->process->lookupOptions()) ?>;
fpacking_typesearch.lists["x_internal_external"] = <?php echo $packing_type_search->internal_external->Lookup->toClientList() ?>;
fpacking_typesearch.lists["x_internal_external"].options = <?php echo JsonEncode($packing_type_search->internal_external->options(FALSE, TRUE)) ?>;
fpacking_typesearch.lists["x_status"] = <?php echo $packing_type_search->status->Lookup->toClientList() ?>;
fpacking_typesearch.lists["x_status"].options = <?php echo JsonEncode($packing_type_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fpacking_typesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_type->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($packing_type->grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_code");
	if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
		return this.onError(elm, "<?php echo JsEncode($packing_type->code->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $packing_type_search->showPageHeader(); ?>
<?php
$packing_type_search->showMessage();
?>
<form name="fpacking_typesearch" id="fpacking_typesearch" class="<?php echo $packing_type_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($packing_type_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $packing_type_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="packing_type">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$packing_type_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($packing_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $packing_type_search->LeftColumnClass ?>"><span id="elh_packing_type_id"><?php echo $packing_type->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $packing_type_search->RightColumnClass ?>"><div<?php echo $packing_type->id->cellAttributes() ?>>
			<span id="el_packing_type_id">
<input type="text" data-table="packing_type" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($packing_type->id->getPlaceHolder()) ?>" value="<?php echo $packing_type->id->EditValue ?>"<?php echo $packing_type->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_type->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $packing_type_search->LeftColumnClass ?>"><span id="elh_packing_type_grp"><?php echo $packing_type->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $packing_type_search->RightColumnClass ?>"><div<?php echo $packing_type->grp->cellAttributes() ?>>
			<span id="el_packing_type_grp">
<input type="text" data-table="packing_type" data-field="x_grp" name="x_grp" id="x_grp" size="30" placeholder="<?php echo HtmlEncode($packing_type->grp->getPlaceHolder()) ?>" value="<?php echo $packing_type->grp->EditValue ?>"<?php echo $packing_type->grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_type->packing->Visible) { // packing ?>
	<div id="r_packing" class="form-group row">
		<label for="x_packing" class="<?php echo $packing_type_search->LeftColumnClass ?>"><span id="elh_packing_type_packing"><?php echo $packing_type->packing->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_packing" id="z_packing" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_type_search->RightColumnClass ?>"><div<?php echo $packing_type->packing->cellAttributes() ?>>
			<span id="el_packing_type_packing">
<input type="text" data-table="packing_type" data-field="x_packing" name="x_packing" id="x_packing" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($packing_type->packing->getPlaceHolder()) ?>" value="<?php echo $packing_type->packing->EditValue ?>"<?php echo $packing_type->packing->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_type->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $packing_type_search->LeftColumnClass ?>"><span id="elh_packing_type_code"><?php echo $packing_type->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_type_search->RightColumnClass ?>"><div<?php echo $packing_type->code->cellAttributes() ?>>
			<span id="el_packing_type_code">
<input type="text" data-table="packing_type" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($packing_type->code->getPlaceHolder()) ?>" value="<?php echo $packing_type->code->EditValue ?>"<?php echo $packing_type->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_type->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label class="<?php echo $packing_type_search->LeftColumnClass ?>"><span id="elh_packing_type_process"><?php echo $packing_type->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		</label>
		<div class="<?php echo $packing_type_search->RightColumnClass ?>"><div<?php echo $packing_type->process->cellAttributes() ?>>
			<span id="el_packing_type_process">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="packing_type" data-field="x_process" data-value-separator="<?php echo $packing_type->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $packing_type->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $packing_type->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $packing_type->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_type->internal_external->Visible) { // internal_external ?>
	<div id="r_internal_external" class="form-group row">
		<label for="x_internal_external" class="<?php echo $packing_type_search->LeftColumnClass ?>"><span id="elh_packing_type_internal_external"><?php echo $packing_type->internal_external->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_internal_external" id="z_internal_external" value="="></span>
		</label>
		<div class="<?php echo $packing_type_search->RightColumnClass ?>"><div<?php echo $packing_type->internal_external->cellAttributes() ?>>
			<span id="el_packing_type_internal_external">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_type" data-field="x_internal_external" data-value-separator="<?php echo $packing_type->internal_external->displayValueSeparatorAttribute() ?>" id="x_internal_external" name="x_internal_external"<?php echo $packing_type->internal_external->editAttributes() ?>>
		<?php echo $packing_type->internal_external->selectOptionListHtml("x_internal_external") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($packing_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $packing_type_search->LeftColumnClass ?>"><span id="elh_packing_type_status"><?php echo $packing_type->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $packing_type_search->RightColumnClass ?>"><div<?php echo $packing_type->status->cellAttributes() ?>>
			<span id="el_packing_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="packing_type" data-field="x_status" data-value-separator="<?php echo $packing_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $packing_type->status->editAttributes() ?>>
		<?php echo $packing_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$packing_type_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $packing_type_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$packing_type_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$packing_type_search->terminate();
?>