<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_balance_compiled_list = new partner_balance_compiled_list();

// Run the page
$partner_balance_compiled_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_balance_compiled_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$partner_balance_compiled->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpartner_balance_compiledlist = currentForm = new ew.Form("fpartner_balance_compiledlist", "list");
fpartner_balance_compiledlist.formKeyCountName = '<?php echo $partner_balance_compiled_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpartner_balance_compiledlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_balance_compiledlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_balance_compiledlist.lists["x_location"] = <?php echo $partner_balance_compiled_list->location->Lookup->toClientList() ?>;
fpartner_balance_compiledlist.lists["x_location"].options = <?php echo JsonEncode($partner_balance_compiled_list->location->lookupOptions()) ?>;
fpartner_balance_compiledlist.lists["x_partner_id"] = <?php echo $partner_balance_compiled_list->partner_id->Lookup->toClientList() ?>;
fpartner_balance_compiledlist.lists["x_partner_id"].options = <?php echo JsonEncode($partner_balance_compiled_list->partner_id->lookupOptions()) ?>;
fpartner_balance_compiledlist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpartner_balance_compiledlist.lists["x_ref"] = <?php echo $partner_balance_compiled_list->ref->Lookup->toClientList() ?>;
fpartner_balance_compiledlist.lists["x_ref"].options = <?php echo JsonEncode($partner_balance_compiled_list->ref->lookupOptions()) ?>;

// Form object for search
var fpartner_balance_compiledlistsrch = currentSearchForm = new ew.Form("fpartner_balance_compiledlistsrch");

// Validate function for search
fpartner_balance_compiledlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpartner_balance_compiledlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_balance_compiledlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_balance_compiledlistsrch.lists["x_location"] = <?php echo $partner_balance_compiled_list->location->Lookup->toClientList() ?>;
fpartner_balance_compiledlistsrch.lists["x_location"].options = <?php echo JsonEncode($partner_balance_compiled_list->location->lookupOptions()) ?>;
fpartner_balance_compiledlistsrch.lists["x_partner_id"] = <?php echo $partner_balance_compiled_list->partner_id->Lookup->toClientList() ?>;
fpartner_balance_compiledlistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($partner_balance_compiled_list->partner_id->lookupOptions()) ?>;
fpartner_balance_compiledlistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpartner_balance_compiledlistsrch.filterList = <?php echo $partner_balance_compiled_list->getFilterList() ?>;

// Init search panel as collapsed
fpartner_balance_compiledlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$partner_balance_compiled->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($partner_balance_compiled_list->TotalRecs > 0 && $partner_balance_compiled_list->ExportOptions->visible()) { ?>
<?php $partner_balance_compiled_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_balance_compiled_list->ImportOptions->visible()) { ?>
<?php $partner_balance_compiled_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_balance_compiled_list->SearchOptions->visible()) { ?>
<?php $partner_balance_compiled_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($partner_balance_compiled_list->FilterOptions->visible()) { ?>
<?php $partner_balance_compiled_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$partner_balance_compiled_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$partner_balance_compiled->isExport() && !$partner_balance_compiled->CurrentAction) { ?>
<form name="fpartner_balance_compiledlistsrch" id="fpartner_balance_compiledlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($partner_balance_compiled_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpartner_balance_compiledlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="partner_balance_compiled">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$partner_balance_compiled_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$partner_balance_compiled->RowType = ROWTYPE_SEARCH;

// Render row
$partner_balance_compiled->resetAttributes();
$partner_balance_compiled_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($partner_balance_compiled->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $partner_balance_compiled->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_balance_compiled" data-field="x_location" data-value-separator="<?php echo $partner_balance_compiled->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $partner_balance_compiled->location->editAttributes() ?>>
		<?php echo $partner_balance_compiled->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $partner_balance_compiled->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($partner_balance_compiled->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $partner_balance_compiled->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$partner_balance_compiled->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance_compiled->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($partner_balance_compiled->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance_compiled->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance_compiled->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance_compiled->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance_compiled" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance_compiled->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($partner_balance_compiled->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balance_compiledlistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $partner_balance_compiled->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($partner_balance_compiled_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($partner_balance_compiled_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $partner_balance_compiled_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($partner_balance_compiled_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($partner_balance_compiled_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($partner_balance_compiled_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($partner_balance_compiled_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $partner_balance_compiled_list->showPageHeader(); ?>
<?php
$partner_balance_compiled_list->showMessage();
?>
<?php if ($partner_balance_compiled_list->TotalRecs > 0 || $partner_balance_compiled->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($partner_balance_compiled_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> partner_balance_compiled">
<?php if (!$partner_balance_compiled->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$partner_balance_compiled->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_balance_compiled_list->Pager)) $partner_balance_compiled_list->Pager = new PrevNextPager($partner_balance_compiled_list->StartRec, $partner_balance_compiled_list->DisplayRecs, $partner_balance_compiled_list->TotalRecs, $partner_balance_compiled_list->AutoHidePager) ?>
<?php if ($partner_balance_compiled_list->Pager->RecordCount > 0 && $partner_balance_compiled_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_balance_compiled_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_balance_compiled_list->pageUrl() ?>start=<?php echo $partner_balance_compiled_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_balance_compiled_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_balance_compiled_list->pageUrl() ?>start=<?php echo $partner_balance_compiled_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_balance_compiled_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_balance_compiled_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_balance_compiled_list->pageUrl() ?>start=<?php echo $partner_balance_compiled_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_balance_compiled_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_balance_compiled_list->pageUrl() ?>start=<?php echo $partner_balance_compiled_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_balance_compiled_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_balance_compiled_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_balance_compiled_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_balance_compiled_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_balance_compiled_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_balance_compiled_list->TotalRecs > 0 && (!$partner_balance_compiled_list->AutoHidePageSizeSelector || $partner_balance_compiled_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_balance_compiled">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_balance_compiled_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_balance_compiled_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_balance_compiled_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_balance_compiled_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_balance_compiled_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_balance_compiled->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_balance_compiled_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpartner_balance_compiledlist" id="fpartner_balance_compiledlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_balance_compiled_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_balance_compiled_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_balance_compiled">
<div id="gmp_partner_balance_compiled" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($partner_balance_compiled_list->TotalRecs > 0 || $partner_balance_compiled->isGridEdit()) { ?>
<table id="tbl_partner_balance_compiledlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$partner_balance_compiled_list->RowType = ROWTYPE_HEADER;

// Render list options
$partner_balance_compiled_list->renderListOptions();

// Render list options (header, left)
$partner_balance_compiled_list->ListOptions->render("header", "left");
?>
<?php if ($partner_balance_compiled->location->Visible) { // location ?>
	<?php if ($partner_balance_compiled->sortUrl($partner_balance_compiled->location) == "") { ?>
		<th data-name="location" class="<?php echo $partner_balance_compiled->location->headerCellClass() ?>"><div id="elh_partner_balance_compiled_location" class="partner_balance_compiled_location"><div class="ew-table-header-caption"><?php echo $partner_balance_compiled->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $partner_balance_compiled->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance_compiled->SortUrl($partner_balance_compiled->location) ?>',2);"><div id="elh_partner_balance_compiled_location" class="partner_balance_compiled_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance_compiled->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_compiled->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_compiled->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance_compiled->partner_id->Visible) { // partner_id ?>
	<?php if ($partner_balance_compiled->sortUrl($partner_balance_compiled->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $partner_balance_compiled->partner_id->headerCellClass() ?>"><div id="elh_partner_balance_compiled_partner_id" class="partner_balance_compiled_partner_id"><div class="ew-table-header-caption"><?php echo $partner_balance_compiled->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $partner_balance_compiled->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance_compiled->SortUrl($partner_balance_compiled->partner_id) ?>',2);"><div id="elh_partner_balance_compiled_partner_id" class="partner_balance_compiled_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance_compiled->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_compiled->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_compiled->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance_compiled->balance->Visible) { // balance ?>
	<?php if ($partner_balance_compiled->sortUrl($partner_balance_compiled->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $partner_balance_compiled->balance->headerCellClass() ?>"><div id="elh_partner_balance_compiled_balance" class="partner_balance_compiled_balance"><div class="ew-table-header-caption"><?php echo $partner_balance_compiled->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $partner_balance_compiled->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance_compiled->SortUrl($partner_balance_compiled->balance) ?>',2);"><div id="elh_partner_balance_compiled_balance" class="partner_balance_compiled_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance_compiled->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_compiled->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_compiled->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance_compiled->receipt->Visible) { // receipt ?>
	<?php if ($partner_balance_compiled->sortUrl($partner_balance_compiled->receipt) == "") { ?>
		<th data-name="receipt" class="<?php echo $partner_balance_compiled->receipt->headerCellClass() ?>"><div id="elh_partner_balance_compiled_receipt" class="partner_balance_compiled_receipt"><div class="ew-table-header-caption"><?php echo $partner_balance_compiled->receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receipt" class="<?php echo $partner_balance_compiled->receipt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance_compiled->SortUrl($partner_balance_compiled->receipt) ?>',2);"><div id="elh_partner_balance_compiled_receipt" class="partner_balance_compiled_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance_compiled->receipt->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_compiled->receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_compiled->receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance_compiled->panel_amount->Visible) { // panel_amount ?>
	<?php if ($partner_balance_compiled->sortUrl($partner_balance_compiled->panel_amount) == "") { ?>
		<th data-name="panel_amount" class="<?php echo $partner_balance_compiled->panel_amount->headerCellClass() ?>"><div id="elh_partner_balance_compiled_panel_amount" class="partner_balance_compiled_panel_amount"><div class="ew-table-header-caption"><?php echo $partner_balance_compiled->panel_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="panel_amount" class="<?php echo $partner_balance_compiled->panel_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance_compiled->SortUrl($partner_balance_compiled->panel_amount) ?>',2);"><div id="elh_partner_balance_compiled_panel_amount" class="partner_balance_compiled_panel_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance_compiled->panel_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_compiled->panel_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_compiled->panel_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance_compiled->total_amount->Visible) { // total_amount ?>
	<?php if ($partner_balance_compiled->sortUrl($partner_balance_compiled->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $partner_balance_compiled->total_amount->headerCellClass() ?>"><div id="elh_partner_balance_compiled_total_amount" class="partner_balance_compiled_total_amount"><div class="ew-table-header-caption"><?php echo $partner_balance_compiled->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $partner_balance_compiled->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance_compiled->SortUrl($partner_balance_compiled->total_amount) ?>',2);"><div id="elh_partner_balance_compiled_total_amount" class="partner_balance_compiled_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance_compiled->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_compiled->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_compiled->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance_compiled->ref->Visible) { // ref ?>
	<?php if ($partner_balance_compiled->sortUrl($partner_balance_compiled->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $partner_balance_compiled->ref->headerCellClass() ?>"><div id="elh_partner_balance_compiled_ref" class="partner_balance_compiled_ref"><div class="ew-table-header-caption"><?php echo $partner_balance_compiled->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $partner_balance_compiled->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance_compiled->SortUrl($partner_balance_compiled->ref) ?>',2);"><div id="elh_partner_balance_compiled_ref" class="partner_balance_compiled_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance_compiled->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_compiled->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_compiled->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$partner_balance_compiled_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($partner_balance_compiled->ExportAll && $partner_balance_compiled->isExport()) {
	$partner_balance_compiled_list->StopRec = $partner_balance_compiled_list->TotalRecs;
} else {

	// Set the last record to display
	if ($partner_balance_compiled_list->TotalRecs > $partner_balance_compiled_list->StartRec + $partner_balance_compiled_list->DisplayRecs - 1)
		$partner_balance_compiled_list->StopRec = $partner_balance_compiled_list->StartRec + $partner_balance_compiled_list->DisplayRecs - 1;
	else
		$partner_balance_compiled_list->StopRec = $partner_balance_compiled_list->TotalRecs;
}
$partner_balance_compiled_list->RecCnt = $partner_balance_compiled_list->StartRec - 1;
if ($partner_balance_compiled_list->Recordset && !$partner_balance_compiled_list->Recordset->EOF) {
	$partner_balance_compiled_list->Recordset->moveFirst();
	$selectLimit = $partner_balance_compiled_list->UseSelectLimit;
	if (!$selectLimit && $partner_balance_compiled_list->StartRec > 1)
		$partner_balance_compiled_list->Recordset->move($partner_balance_compiled_list->StartRec - 1);
} elseif (!$partner_balance_compiled->AllowAddDeleteRow && $partner_balance_compiled_list->StopRec == 0) {
	$partner_balance_compiled_list->StopRec = $partner_balance_compiled->GridAddRowCount;
}

// Initialize aggregate
$partner_balance_compiled->RowType = ROWTYPE_AGGREGATEINIT;
$partner_balance_compiled->resetAttributes();
$partner_balance_compiled_list->renderRow();
while ($partner_balance_compiled_list->RecCnt < $partner_balance_compiled_list->StopRec) {
	$partner_balance_compiled_list->RecCnt++;
	if ($partner_balance_compiled_list->RecCnt >= $partner_balance_compiled_list->StartRec) {
		$partner_balance_compiled_list->RowCnt++;

		// Set up key count
		$partner_balance_compiled_list->KeyCount = $partner_balance_compiled_list->RowIndex;

		// Init row class and style
		$partner_balance_compiled->resetAttributes();
		$partner_balance_compiled->CssClass = "";
		if ($partner_balance_compiled->isGridAdd()) {
		} else {
			$partner_balance_compiled_list->loadRowValues($partner_balance_compiled_list->Recordset); // Load row values
		}
		$partner_balance_compiled->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$partner_balance_compiled->RowAttrs = array_merge($partner_balance_compiled->RowAttrs, array('data-rowindex'=>$partner_balance_compiled_list->RowCnt, 'id'=>'r' . $partner_balance_compiled_list->RowCnt . '_partner_balance_compiled', 'data-rowtype'=>$partner_balance_compiled->RowType));

		// Render row
		$partner_balance_compiled_list->renderRow();

		// Render list options
		$partner_balance_compiled_list->renderListOptions();
?>
	<tr<?php echo $partner_balance_compiled->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_balance_compiled_list->ListOptions->render("body", "left", $partner_balance_compiled_list->RowCnt);
?>
	<?php if ($partner_balance_compiled->location->Visible) { // location ?>
		<td data-name="location"<?php echo $partner_balance_compiled->location->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_compiled_list->RowCnt ?>_partner_balance_compiled_location" class="partner_balance_compiled_location">
<span<?php echo $partner_balance_compiled->location->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance_compiled->location->getViewValue())) && $partner_balance_compiled->location->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance_compiled->location->linkAttributes() ?>><?php echo $partner_balance_compiled->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance_compiled->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance_compiled->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $partner_balance_compiled->partner_id->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_compiled_list->RowCnt ?>_partner_balance_compiled_partner_id" class="partner_balance_compiled_partner_id">
<span<?php echo $partner_balance_compiled->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance_compiled->partner_id->getViewValue())) && $partner_balance_compiled->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance_compiled->partner_id->linkAttributes() ?>><?php echo $partner_balance_compiled->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance_compiled->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance_compiled->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $partner_balance_compiled->balance->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_compiled_list->RowCnt ?>_partner_balance_compiled_balance" class="partner_balance_compiled_balance">
<span<?php echo $partner_balance_compiled->balance->viewAttributes() ?>>
<?php echo $partner_balance_compiled->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance_compiled->receipt->Visible) { // receipt ?>
		<td data-name="receipt"<?php echo $partner_balance_compiled->receipt->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_compiled_list->RowCnt ?>_partner_balance_compiled_receipt" class="partner_balance_compiled_receipt">
<span<?php echo $partner_balance_compiled->receipt->viewAttributes() ?>>
<?php echo $partner_balance_compiled->receipt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance_compiled->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount"<?php echo $partner_balance_compiled->panel_amount->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_compiled_list->RowCnt ?>_partner_balance_compiled_panel_amount" class="partner_balance_compiled_panel_amount">
<span<?php echo $partner_balance_compiled->panel_amount->viewAttributes() ?>>
<?php echo $partner_balance_compiled->panel_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance_compiled->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $partner_balance_compiled->total_amount->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_compiled_list->RowCnt ?>_partner_balance_compiled_total_amount" class="partner_balance_compiled_total_amount">
<span<?php echo $partner_balance_compiled->total_amount->viewAttributes() ?>>
<?php echo $partner_balance_compiled->total_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance_compiled->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $partner_balance_compiled->ref->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_compiled_list->RowCnt ?>_partner_balance_compiled_ref" class="partner_balance_compiled_ref">
<span<?php echo $partner_balance_compiled->ref->viewAttributes() ?>>
<?php echo $partner_balance_compiled->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$partner_balance_compiled_list->ListOptions->render("body", "right", $partner_balance_compiled_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$partner_balance_compiled->isGridAdd())
		$partner_balance_compiled_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$partner_balance_compiled->RowType = ROWTYPE_AGGREGATE;
$partner_balance_compiled->resetAttributes();
$partner_balance_compiled_list->renderRow();
?>
<?php if ($partner_balance_compiled_list->TotalRecs > 0 && !$partner_balance_compiled->isGridAdd() && !$partner_balance_compiled->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$partner_balance_compiled_list->renderListOptions();

// Render list options (footer, left)
$partner_balance_compiled_list->ListOptions->render("footer", "left");
?>
	<?php if ($partner_balance_compiled->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $partner_balance_compiled->location->footerCellClass() ?>"><span id="elf_partner_balance_compiled_location" class="partner_balance_compiled_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($partner_balance_compiled->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id" class="<?php echo $partner_balance_compiled->partner_id->footerCellClass() ?>"><span id="elf_partner_balance_compiled_partner_id" class="partner_balance_compiled_partner_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($partner_balance_compiled->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $partner_balance_compiled->balance->footerCellClass() ?>"><span id="elf_partner_balance_compiled_balance" class="partner_balance_compiled_balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance_compiled->balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance_compiled->receipt->Visible) { // receipt ?>
		<td data-name="receipt" class="<?php echo $partner_balance_compiled->receipt->footerCellClass() ?>"><span id="elf_partner_balance_compiled_receipt" class="partner_balance_compiled_receipt">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance_compiled->receipt->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance_compiled->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount" class="<?php echo $partner_balance_compiled->panel_amount->footerCellClass() ?>"><span id="elf_partner_balance_compiled_panel_amount" class="partner_balance_compiled_panel_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance_compiled->panel_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance_compiled->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount" class="<?php echo $partner_balance_compiled->total_amount->footerCellClass() ?>"><span id="elf_partner_balance_compiled_total_amount" class="partner_balance_compiled_total_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance_compiled->total_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance_compiled->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $partner_balance_compiled->ref->footerCellClass() ?>"><span id="elf_partner_balance_compiled_ref" class="partner_balance_compiled_ref">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$partner_balance_compiled_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$partner_balance_compiled->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($partner_balance_compiled_list->Recordset)
	$partner_balance_compiled_list->Recordset->Close();
?>
<?php if (!$partner_balance_compiled->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$partner_balance_compiled->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_balance_compiled_list->Pager)) $partner_balance_compiled_list->Pager = new PrevNextPager($partner_balance_compiled_list->StartRec, $partner_balance_compiled_list->DisplayRecs, $partner_balance_compiled_list->TotalRecs, $partner_balance_compiled_list->AutoHidePager) ?>
<?php if ($partner_balance_compiled_list->Pager->RecordCount > 0 && $partner_balance_compiled_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_balance_compiled_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_balance_compiled_list->pageUrl() ?>start=<?php echo $partner_balance_compiled_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_balance_compiled_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_balance_compiled_list->pageUrl() ?>start=<?php echo $partner_balance_compiled_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_balance_compiled_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_balance_compiled_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_balance_compiled_list->pageUrl() ?>start=<?php echo $partner_balance_compiled_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_balance_compiled_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_balance_compiled_list->pageUrl() ?>start=<?php echo $partner_balance_compiled_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_balance_compiled_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_balance_compiled_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_balance_compiled_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_balance_compiled_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_balance_compiled_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_balance_compiled_list->TotalRecs > 0 && (!$partner_balance_compiled_list->AutoHidePageSizeSelector || $partner_balance_compiled_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_balance_compiled">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_balance_compiled_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_balance_compiled_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_balance_compiled_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_balance_compiled_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_balance_compiled_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_balance_compiled->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_balance_compiled_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($partner_balance_compiled_list->TotalRecs == 0 && !$partner_balance_compiled->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $partner_balance_compiled_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$partner_balance_compiled_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$partner_balance_compiled->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$partner_balance_compiled->isExport()) { ?>
<script>
ew.scrollableTable("gmp_partner_balance_compiled", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$partner_balance_compiled_list->terminate();
?>