<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_balance_compiled_search = new partner_balance_compiled_search();

// Run the page
$partner_balance_compiled_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_balance_compiled_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($partner_balance_compiled_search->IsModal) { ?>
var fpartner_balance_compiledsearch = currentAdvancedSearchForm = new ew.Form("fpartner_balance_compiledsearch", "search");
<?php } else { ?>
var fpartner_balance_compiledsearch = currentForm = new ew.Form("fpartner_balance_compiledsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpartner_balance_compiledsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_balance_compiledsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_balance_compiledsearch.lists["x_location"] = <?php echo $partner_balance_compiled_search->location->Lookup->toClientList() ?>;
fpartner_balance_compiledsearch.lists["x_location"].options = <?php echo JsonEncode($partner_balance_compiled_search->location->lookupOptions()) ?>;
fpartner_balance_compiledsearch.lists["x_partner_id"] = <?php echo $partner_balance_compiled_search->partner_id->Lookup->toClientList() ?>;
fpartner_balance_compiledsearch.lists["x_partner_id"].options = <?php echo JsonEncode($partner_balance_compiled_search->partner_id->lookupOptions()) ?>;
fpartner_balance_compiledsearch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpartner_balance_compiledsearch.lists["x_ref"] = <?php echo $partner_balance_compiled_search->ref->Lookup->toClientList() ?>;
fpartner_balance_compiledsearch.lists["x_ref"].options = <?php echo JsonEncode($partner_balance_compiled_search->ref->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpartner_balance_compiledsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance_compiled->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_receipt");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance_compiled->receipt->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_panel_amount");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance_compiled->panel_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance_compiled->total_amount->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $partner_balance_compiled_search->showPageHeader(); ?>
<?php
$partner_balance_compiled_search->showMessage();
?>
<form name="fpartner_balance_compiledsearch" id="fpartner_balance_compiledsearch" class="<?php echo $partner_balance_compiled_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_balance_compiled_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_balance_compiled_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_balance_compiled">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$partner_balance_compiled_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($partner_balance_compiled->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $partner_balance_compiled_search->LeftColumnClass ?>"><span id="elh_partner_balance_compiled_location"><?php echo $partner_balance_compiled->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_compiled_search->RightColumnClass ?>"><div<?php echo $partner_balance_compiled->location->cellAttributes() ?>>
			<span id="el_partner_balance_compiled_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_balance_compiled" data-field="x_location" data-value-separator="<?php echo $partner_balance_compiled->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $partner_balance_compiled->location->editAttributes() ?>>
		<?php echo $partner_balance_compiled->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $partner_balance_compiled->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance_compiled->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $partner_balance_compiled_search->LeftColumnClass ?>"><span id="elh_partner_balance_compiled_partner_id"><?php echo $partner_balance_compiled->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_compiled_search->RightColumnClass ?>"><div<?php echo $partner_balance_compiled->partner_id->cellAttributes() ?>>
			<span id="el_partner_balance_compiled_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$partner_balance_compiled->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance_compiled->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($partner_balance_compiled->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance_compiled->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance_compiled->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance_compiled->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance_compiled" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance_compiled->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($partner_balance_compiled->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balance_compiledsearch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $partner_balance_compiled->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance_compiled->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $partner_balance_compiled_search->LeftColumnClass ?>"><span id="elh_partner_balance_compiled_balance"><?php echo $partner_balance_compiled->balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance" id="z_balance" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_compiled_search->RightColumnClass ?>"><div<?php echo $partner_balance_compiled->balance->cellAttributes() ?>>
			<span id="el_partner_balance_compiled_balance">
<input type="text" data-table="partner_balance_compiled" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($partner_balance_compiled->balance->getPlaceHolder()) ?>" value="<?php echo $partner_balance_compiled->balance->EditValue ?>"<?php echo $partner_balance_compiled->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance_compiled->receipt->Visible) { // receipt ?>
	<div id="r_receipt" class="form-group row">
		<label for="x_receipt" class="<?php echo $partner_balance_compiled_search->LeftColumnClass ?>"><span id="elh_partner_balance_compiled_receipt"><?php echo $partner_balance_compiled->receipt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receipt" id="z_receipt" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_compiled_search->RightColumnClass ?>"><div<?php echo $partner_balance_compiled->receipt->cellAttributes() ?>>
			<span id="el_partner_balance_compiled_receipt">
<input type="text" data-table="partner_balance_compiled" data-field="x_receipt" name="x_receipt" id="x_receipt" size="30" placeholder="<?php echo HtmlEncode($partner_balance_compiled->receipt->getPlaceHolder()) ?>" value="<?php echo $partner_balance_compiled->receipt->EditValue ?>"<?php echo $partner_balance_compiled->receipt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance_compiled->panel_amount->Visible) { // panel_amount ?>
	<div id="r_panel_amount" class="form-group row">
		<label for="x_panel_amount" class="<?php echo $partner_balance_compiled_search->LeftColumnClass ?>"><span id="elh_partner_balance_compiled_panel_amount"><?php echo $partner_balance_compiled->panel_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_panel_amount" id="z_panel_amount" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_compiled_search->RightColumnClass ?>"><div<?php echo $partner_balance_compiled->panel_amount->cellAttributes() ?>>
			<span id="el_partner_balance_compiled_panel_amount">
<input type="text" data-table="partner_balance_compiled" data-field="x_panel_amount" name="x_panel_amount" id="x_panel_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance_compiled->panel_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance_compiled->panel_amount->EditValue ?>"<?php echo $partner_balance_compiled->panel_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance_compiled->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $partner_balance_compiled_search->LeftColumnClass ?>"><span id="elh_partner_balance_compiled_total_amount"><?php echo $partner_balance_compiled->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_compiled_search->RightColumnClass ?>"><div<?php echo $partner_balance_compiled->total_amount->cellAttributes() ?>>
			<span id="el_partner_balance_compiled_total_amount">
<input type="text" data-table="partner_balance_compiled" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance_compiled->total_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance_compiled->total_amount->EditValue ?>"<?php echo $partner_balance_compiled->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance_compiled->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $partner_balance_compiled_search->LeftColumnClass ?>"><span id="elh_partner_balance_compiled_ref"><?php echo $partner_balance_compiled->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_balance_compiled_search->RightColumnClass ?>"><div<?php echo $partner_balance_compiled->ref->cellAttributes() ?>>
			<span id="el_partner_balance_compiled_ref">
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="partner_balance_compiled" data-field="x_ref" data-value-separator="<?php echo $partner_balance_compiled->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $partner_balance_compiled->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $partner_balance_compiled->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $partner_balance_compiled->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$partner_balance_compiled_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $partner_balance_compiled_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$partner_balance_compiled_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$partner_balance_compiled_search->terminate();
?>