<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($partner_balance_grid))
	$partner_balance_grid = new partner_balance_grid();

// Run the page
$partner_balance_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_balance_grid->Page_Render();
?>
<?php if (!$partner_balance->isExport()) { ?>
<script>

// Form object
var fpartner_balancegrid = new ew.Form("fpartner_balancegrid", "grid");
fpartner_balancegrid.formKeyCountName = '<?php echo $partner_balance_grid->FormKeyCountName ?>';

// Validate form
fpartner_balancegrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($partner_balance_grid->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_balance->location->caption(), $partner_balance->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_balance_grid->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_balance->partner_id->caption(), $partner_balance->partner_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_balance->partner_id->errorMessage()) ?>");
		<?php if ($partner_balance_grid->balance->Required) { ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_balance->balance->caption(), $partner_balance->balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_balance->balance->errorMessage()) ?>");
		<?php if ($partner_balance_grid->receipt->Required) { ?>
			elm = this.getElements("x" + infix + "_receipt");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_balance->receipt->caption(), $partner_balance->receipt->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_receipt");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_balance->receipt->errorMessage()) ?>");
		<?php if ($partner_balance_grid->panel_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_panel_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_balance->panel_amount->caption(), $partner_balance->panel_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_panel_amount");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_balance->panel_amount->errorMessage()) ?>");
		<?php if ($partner_balance_grid->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_balance->total_amount->caption(), $partner_balance->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_balance->total_amount->errorMessage()) ?>");
		<?php if ($partner_balance_grid->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_balance->ref->caption(), $partner_balance->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_balance_grid->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_balance->dated->caption(), $partner_balance->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_balance->dated->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fpartner_balancegrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "location", false)) return false;
	if (ew.valueChanged(fobj, infix, "partner_id", false)) return false;
	if (ew.valueChanged(fobj, infix, "balance", false)) return false;
	if (ew.valueChanged(fobj, infix, "receipt", false)) return false;
	if (ew.valueChanged(fobj, infix, "panel_amount", false)) return false;
	if (ew.valueChanged(fobj, infix, "total_amount", false)) return false;
	if (ew.valueChanged(fobj, infix, "ref", false)) return false;
	if (ew.valueChanged(fobj, infix, "dated", false)) return false;
	return true;
}

// Form_CustomValidate event
fpartner_balancegrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_balancegrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_balancegrid.lists["x_location"] = <?php echo $partner_balance_grid->location->Lookup->toClientList() ?>;
fpartner_balancegrid.lists["x_location"].options = <?php echo JsonEncode($partner_balance_grid->location->lookupOptions()) ?>;
fpartner_balancegrid.lists["x_partner_id"] = <?php echo $partner_balance_grid->partner_id->Lookup->toClientList() ?>;
fpartner_balancegrid.lists["x_partner_id"].options = <?php echo JsonEncode($partner_balance_grid->partner_id->lookupOptions()) ?>;
fpartner_balancegrid.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpartner_balancegrid.lists["x_ref"] = <?php echo $partner_balance_grid->ref->Lookup->toClientList() ?>;
fpartner_balancegrid.lists["x_ref"].options = <?php echo JsonEncode($partner_balance_grid->ref->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$partner_balance_grid->renderOtherOptions();
?>
<?php $partner_balance_grid->showPageHeader(); ?>
<?php
$partner_balance_grid->showMessage();
?>
<?php if ($partner_balance_grid->TotalRecs > 0 || $partner_balance->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($partner_balance_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> partner_balance">
<?php if ($partner_balance_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $partner_balance_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fpartner_balancegrid" class="ew-form ew-list-form form-inline">
<div id="gmp_partner_balance" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_partner_balancegrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$partner_balance_grid->RowType = ROWTYPE_HEADER;

// Render list options
$partner_balance_grid->renderListOptions();

// Render list options (header, left)
$partner_balance_grid->ListOptions->render("header", "left");
?>
<?php if ($partner_balance->location->Visible) { // location ?>
	<?php if ($partner_balance->sortUrl($partner_balance->location) == "") { ?>
		<th data-name="location" class="<?php echo $partner_balance->location->headerCellClass() ?>"><div id="elh_partner_balance_location" class="partner_balance_location"><div class="ew-table-header-caption"><?php echo $partner_balance->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $partner_balance->location->headerCellClass() ?>"><div><div id="elh_partner_balance_location" class="partner_balance_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
	<?php if ($partner_balance->sortUrl($partner_balance->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $partner_balance->partner_id->headerCellClass() ?>"><div id="elh_partner_balance_partner_id" class="partner_balance_partner_id"><div class="ew-table-header-caption"><?php echo $partner_balance->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $partner_balance->partner_id->headerCellClass() ?>"><div><div id="elh_partner_balance_partner_id" class="partner_balance_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->balance->Visible) { // balance ?>
	<?php if ($partner_balance->sortUrl($partner_balance->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $partner_balance->balance->headerCellClass() ?>"><div id="elh_partner_balance_balance" class="partner_balance_balance"><div class="ew-table-header-caption"><?php echo $partner_balance->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $partner_balance->balance->headerCellClass() ?>"><div><div id="elh_partner_balance_balance" class="partner_balance_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->receipt->Visible) { // receipt ?>
	<?php if ($partner_balance->sortUrl($partner_balance->receipt) == "") { ?>
		<th data-name="receipt" class="<?php echo $partner_balance->receipt->headerCellClass() ?>"><div id="elh_partner_balance_receipt" class="partner_balance_receipt"><div class="ew-table-header-caption"><?php echo $partner_balance->receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receipt" class="<?php echo $partner_balance->receipt->headerCellClass() ?>"><div><div id="elh_partner_balance_receipt" class="partner_balance_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->receipt->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
	<?php if ($partner_balance->sortUrl($partner_balance->panel_amount) == "") { ?>
		<th data-name="panel_amount" class="<?php echo $partner_balance->panel_amount->headerCellClass() ?>"><div id="elh_partner_balance_panel_amount" class="partner_balance_panel_amount"><div class="ew-table-header-caption"><?php echo $partner_balance->panel_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="panel_amount" class="<?php echo $partner_balance->panel_amount->headerCellClass() ?>"><div><div id="elh_partner_balance_panel_amount" class="partner_balance_panel_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->panel_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->panel_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->panel_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
	<?php if ($partner_balance->sortUrl($partner_balance->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $partner_balance->total_amount->headerCellClass() ?>"><div id="elh_partner_balance_total_amount" class="partner_balance_total_amount"><div class="ew-table-header-caption"><?php echo $partner_balance->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $partner_balance->total_amount->headerCellClass() ?>"><div><div id="elh_partner_balance_total_amount" class="partner_balance_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->ref->Visible) { // ref ?>
	<?php if ($partner_balance->sortUrl($partner_balance->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $partner_balance->ref->headerCellClass() ?>"><div id="elh_partner_balance_ref" class="partner_balance_ref"><div class="ew-table-header-caption"><?php echo $partner_balance->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $partner_balance->ref->headerCellClass() ?>"><div><div id="elh_partner_balance_ref" class="partner_balance_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->dated->Visible) { // dated ?>
	<?php if ($partner_balance->sortUrl($partner_balance->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $partner_balance->dated->headerCellClass() ?>"><div id="elh_partner_balance_dated" class="partner_balance_dated"><div class="ew-table-header-caption"><?php echo $partner_balance->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $partner_balance->dated->headerCellClass() ?>"><div><div id="elh_partner_balance_dated" class="partner_balance_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$partner_balance_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$partner_balance_grid->StartRec = 1;
$partner_balance_grid->StopRec = $partner_balance_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $partner_balance_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($partner_balance_grid->FormKeyCountName) && ($partner_balance->isGridAdd() || $partner_balance->isGridEdit() || $partner_balance->isConfirm())) {
		$partner_balance_grid->KeyCount = $CurrentForm->getValue($partner_balance_grid->FormKeyCountName);
		$partner_balance_grid->StopRec = $partner_balance_grid->StartRec + $partner_balance_grid->KeyCount - 1;
	}
}
$partner_balance_grid->RecCnt = $partner_balance_grid->StartRec - 1;
if ($partner_balance_grid->Recordset && !$partner_balance_grid->Recordset->EOF) {
	$partner_balance_grid->Recordset->moveFirst();
	$selectLimit = $partner_balance_grid->UseSelectLimit;
	if (!$selectLimit && $partner_balance_grid->StartRec > 1)
		$partner_balance_grid->Recordset->move($partner_balance_grid->StartRec - 1);
} elseif (!$partner_balance->AllowAddDeleteRow && $partner_balance_grid->StopRec == 0) {
	$partner_balance_grid->StopRec = $partner_balance->GridAddRowCount;
}

// Initialize aggregate
$partner_balance->RowType = ROWTYPE_AGGREGATEINIT;
$partner_balance->resetAttributes();
$partner_balance_grid->renderRow();
if ($partner_balance->isGridAdd())
	$partner_balance_grid->RowIndex = 0;
if ($partner_balance->isGridEdit())
	$partner_balance_grid->RowIndex = 0;
while ($partner_balance_grid->RecCnt < $partner_balance_grid->StopRec) {
	$partner_balance_grid->RecCnt++;
	if ($partner_balance_grid->RecCnt >= $partner_balance_grid->StartRec) {
		$partner_balance_grid->RowCnt++;
		if ($partner_balance->isGridAdd() || $partner_balance->isGridEdit() || $partner_balance->isConfirm()) {
			$partner_balance_grid->RowIndex++;
			$CurrentForm->Index = $partner_balance_grid->RowIndex;
			if ($CurrentForm->hasValue($partner_balance_grid->FormActionName) && $partner_balance_grid->EventCancelled)
				$partner_balance_grid->RowAction = strval($CurrentForm->getValue($partner_balance_grid->FormActionName));
			elseif ($partner_balance->isGridAdd())
				$partner_balance_grid->RowAction = "insert";
			else
				$partner_balance_grid->RowAction = "";
		}

		// Set up key count
		$partner_balance_grid->KeyCount = $partner_balance_grid->RowIndex;

		// Init row class and style
		$partner_balance->resetAttributes();
		$partner_balance->CssClass = "";
		if ($partner_balance->isGridAdd()) {
			if ($partner_balance->CurrentMode == "copy") {
				$partner_balance_grid->loadRowValues($partner_balance_grid->Recordset); // Load row values
				$partner_balance_grid->setRecordKey($partner_balance_grid->RowOldKey, $partner_balance_grid->Recordset); // Set old record key
			} else {
				$partner_balance_grid->loadRowValues(); // Load default values
				$partner_balance_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$partner_balance_grid->loadRowValues($partner_balance_grid->Recordset); // Load row values
		}
		$partner_balance->RowType = ROWTYPE_VIEW; // Render view
		if ($partner_balance->isGridAdd()) // Grid add
			$partner_balance->RowType = ROWTYPE_ADD; // Render add
		if ($partner_balance->isGridAdd() && $partner_balance->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$partner_balance_grid->restoreCurrentRowFormValues($partner_balance_grid->RowIndex); // Restore form values
		if ($partner_balance->isGridEdit()) { // Grid edit
			if ($partner_balance->EventCancelled)
				$partner_balance_grid->restoreCurrentRowFormValues($partner_balance_grid->RowIndex); // Restore form values
			if ($partner_balance_grid->RowAction == "insert")
				$partner_balance->RowType = ROWTYPE_ADD; // Render add
			else
				$partner_balance->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($partner_balance->isGridEdit() && ($partner_balance->RowType == ROWTYPE_EDIT || $partner_balance->RowType == ROWTYPE_ADD) && $partner_balance->EventCancelled) // Update failed
			$partner_balance_grid->restoreCurrentRowFormValues($partner_balance_grid->RowIndex); // Restore form values
		if ($partner_balance->RowType == ROWTYPE_EDIT) // Edit row
			$partner_balance_grid->EditRowCnt++;
		if ($partner_balance->isConfirm()) // Confirm row
			$partner_balance_grid->restoreCurrentRowFormValues($partner_balance_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$partner_balance->RowAttrs = array_merge($partner_balance->RowAttrs, array('data-rowindex'=>$partner_balance_grid->RowCnt, 'id'=>'r' . $partner_balance_grid->RowCnt . '_partner_balance', 'data-rowtype'=>$partner_balance->RowType));

		// Render row
		$partner_balance_grid->renderRow();

		// Render list options
		$partner_balance_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($partner_balance_grid->RowAction <> "delete" && $partner_balance_grid->RowAction <> "insertdelete" && !($partner_balance_grid->RowAction == "insert" && $partner_balance->isConfirm() && $partner_balance_grid->emptyRow())) {
?>
	<tr<?php echo $partner_balance->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_balance_grid->ListOptions->render("body", "left", $partner_balance_grid->RowCnt);
?>
	<?php if ($partner_balance->location->Visible) { // location ?>
		<td data-name="location"<?php echo $partner_balance->location->cellAttributes() ?>>
<?php if ($partner_balance->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($partner_balance->location->getSessionValue() <> "") { ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_location" class="form-group partner_balance_location">
<span<?php echo $partner_balance->location->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->location->ViewValue)) && $partner_balance->location->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->location->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->location->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->location->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $partner_balance_grid->RowIndex ?>_location" name="x<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_location" class="form-group partner_balance_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_balance" data-field="x_location" data-value-separator="<?php echo $partner_balance->location->displayValueSeparatorAttribute() ?>" id="x<?php echo $partner_balance_grid->RowIndex ?>_location" name="x<?php echo $partner_balance_grid->RowIndex ?>_location"<?php echo $partner_balance->location->editAttributes() ?>>
		<?php echo $partner_balance->location->selectOptionListHtml("x<?php echo $partner_balance_grid->RowIndex ?>_location") ?>
	</select>
</div>
<?php echo $partner_balance->location->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_location") ?>
</span>
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_location" name="o<?php echo $partner_balance_grid->RowIndex ?>_location" id="o<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->OldValue) ?>">
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($partner_balance->location->getSessionValue() <> "") { ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_location" class="form-group partner_balance_location">
<span<?php echo $partner_balance->location->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->location->ViewValue)) && $partner_balance->location->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->location->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->location->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->location->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $partner_balance_grid->RowIndex ?>_location" name="x<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_location" class="form-group partner_balance_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_balance" data-field="x_location" data-value-separator="<?php echo $partner_balance->location->displayValueSeparatorAttribute() ?>" id="x<?php echo $partner_balance_grid->RowIndex ?>_location" name="x<?php echo $partner_balance_grid->RowIndex ?>_location"<?php echo $partner_balance->location->editAttributes() ?>>
		<?php echo $partner_balance->location->selectOptionListHtml("x<?php echo $partner_balance_grid->RowIndex ?>_location") ?>
	</select>
</div>
<?php echo $partner_balance->location->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_location") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_location" class="partner_balance_location">
<span<?php echo $partner_balance->location->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->location->getViewValue())) && $partner_balance->location->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->location->linkAttributes() ?>><?php echo $partner_balance->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->location->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$partner_balance->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_location" name="x<?php echo $partner_balance_grid->RowIndex ?>_location" id="x<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_location" name="o<?php echo $partner_balance_grid->RowIndex ?>_location" id="o<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="partner_balance" data-field="x_location" name="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_location" id="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_location" name="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_location" id="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $partner_balance->partner_id->cellAttributes() ?>>
<?php if ($partner_balance->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($partner_balance->partner_id->getSessionValue() <> "") { ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_partner_id" class="form-group partner_balance_partner_id">
<span<?php echo $partner_balance->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->partner_id->ViewValue)) && $partner_balance->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->partner_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->partner_id->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->partner_id->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" name="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_partner_id" class="form-group partner_balance_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$partner_balance->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" class="text-nowrap" style="z-index: <?php echo (9000 - $partner_balance_grid->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="sv_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo RemoveHtml($partner_balance->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance->partner_id->displayValueSeparatorAttribute() ?>" name="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balancegrid.createAutoSuggest({"id":"x<?php echo $partner_balance_grid->RowIndex ?>_partner_id","forceSelect":true});
</script>
<?php echo $partner_balance->partner_id->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_partner_id") ?>
</span>
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" name="o<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="o<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->OldValue) ?>">
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($partner_balance->partner_id->getSessionValue() <> "") { ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_partner_id" class="form-group partner_balance_partner_id">
<span<?php echo $partner_balance->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->partner_id->ViewValue)) && $partner_balance->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->partner_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->partner_id->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->partner_id->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" name="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_partner_id" class="form-group partner_balance_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$partner_balance->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" class="text-nowrap" style="z-index: <?php echo (9000 - $partner_balance_grid->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="sv_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo RemoveHtml($partner_balance->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance->partner_id->displayValueSeparatorAttribute() ?>" name="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balancegrid.createAutoSuggest({"id":"x<?php echo $partner_balance_grid->RowIndex ?>_partner_id","forceSelect":true});
</script>
<?php echo $partner_balance->partner_id->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_partner_id") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_partner_id" class="partner_balance_partner_id">
<span<?php echo $partner_balance->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->partner_id->getViewValue())) && $partner_balance->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->partner_id->linkAttributes() ?>><?php echo $partner_balance->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$partner_balance->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" name="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" name="o<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="o<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" name="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" name="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($partner_balance->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $partner_balance->balance->cellAttributes() ?>>
<?php if ($partner_balance->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_balance" class="form-group partner_balance_balance">
<input type="text" data-table="partner_balance" data-field="x_balance" name="x<?php echo $partner_balance_grid->RowIndex ?>_balance" id="x<?php echo $partner_balance_grid->RowIndex ?>_balance" size="30" placeholder="<?php echo HtmlEncode($partner_balance->balance->getPlaceHolder()) ?>" value="<?php echo $partner_balance->balance->EditValue ?>"<?php echo $partner_balance->balance->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_balance" name="o<?php echo $partner_balance_grid->RowIndex ?>_balance" id="o<?php echo $partner_balance_grid->RowIndex ?>_balance" value="<?php echo HtmlEncode($partner_balance->balance->OldValue) ?>">
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_balance" class="form-group partner_balance_balance">
<input type="text" data-table="partner_balance" data-field="x_balance" name="x<?php echo $partner_balance_grid->RowIndex ?>_balance" id="x<?php echo $partner_balance_grid->RowIndex ?>_balance" size="30" placeholder="<?php echo HtmlEncode($partner_balance->balance->getPlaceHolder()) ?>" value="<?php echo $partner_balance->balance->EditValue ?>"<?php echo $partner_balance->balance->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_balance" class="partner_balance_balance">
<span<?php echo $partner_balance->balance->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->balance->getViewValue())) && $partner_balance->balance->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->balance->linkAttributes() ?>><?php echo $partner_balance->balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->balance->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$partner_balance->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_balance" name="x<?php echo $partner_balance_grid->RowIndex ?>_balance" id="x<?php echo $partner_balance_grid->RowIndex ?>_balance" value="<?php echo HtmlEncode($partner_balance->balance->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_balance" name="o<?php echo $partner_balance_grid->RowIndex ?>_balance" id="o<?php echo $partner_balance_grid->RowIndex ?>_balance" value="<?php echo HtmlEncode($partner_balance->balance->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="partner_balance" data-field="x_balance" name="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_balance" id="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_balance" value="<?php echo HtmlEncode($partner_balance->balance->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_balance" name="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_balance" id="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_balance" value="<?php echo HtmlEncode($partner_balance->balance->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($partner_balance->receipt->Visible) { // receipt ?>
		<td data-name="receipt"<?php echo $partner_balance->receipt->cellAttributes() ?>>
<?php if ($partner_balance->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_receipt" class="form-group partner_balance_receipt">
<input type="text" data-table="partner_balance" data-field="x_receipt" name="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" size="30" placeholder="<?php echo HtmlEncode($partner_balance->receipt->getPlaceHolder()) ?>" value="<?php echo $partner_balance->receipt->EditValue ?>"<?php echo $partner_balance->receipt->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_receipt" name="o<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="o<?php echo $partner_balance_grid->RowIndex ?>_receipt" value="<?php echo HtmlEncode($partner_balance->receipt->OldValue) ?>">
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_receipt" class="form-group partner_balance_receipt">
<input type="text" data-table="partner_balance" data-field="x_receipt" name="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" size="30" placeholder="<?php echo HtmlEncode($partner_balance->receipt->getPlaceHolder()) ?>" value="<?php echo $partner_balance->receipt->EditValue ?>"<?php echo $partner_balance->receipt->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_receipt" class="partner_balance_receipt">
<span<?php echo $partner_balance->receipt->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->receipt->getViewValue())) && $partner_balance->receipt->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->receipt->linkAttributes() ?>><?php echo $partner_balance->receipt->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->receipt->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$partner_balance->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_receipt" name="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" value="<?php echo HtmlEncode($partner_balance->receipt->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_receipt" name="o<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="o<?php echo $partner_balance_grid->RowIndex ?>_receipt" value="<?php echo HtmlEncode($partner_balance->receipt->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="partner_balance" data-field="x_receipt" name="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_receipt" value="<?php echo HtmlEncode($partner_balance->receipt->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_receipt" name="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_receipt" value="<?php echo HtmlEncode($partner_balance->receipt->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount"<?php echo $partner_balance->panel_amount->cellAttributes() ?>>
<?php if ($partner_balance->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_panel_amount" class="form-group partner_balance_panel_amount">
<input type="text" data-table="partner_balance" data-field="x_panel_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance->panel_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance->panel_amount->EditValue ?>"<?php echo $partner_balance->panel_amount->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" name="o<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="o<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" value="<?php echo HtmlEncode($partner_balance->panel_amount->OldValue) ?>">
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_panel_amount" class="form-group partner_balance_panel_amount">
<input type="text" data-table="partner_balance" data-field="x_panel_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance->panel_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance->panel_amount->EditValue ?>"<?php echo $partner_balance->panel_amount->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_panel_amount" class="partner_balance_panel_amount">
<span<?php echo $partner_balance->panel_amount->viewAttributes() ?>>
<?php echo $partner_balance->panel_amount->getViewValue() ?></span>
</span>
<?php if (!$partner_balance->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" value="<?php echo HtmlEncode($partner_balance->panel_amount->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" name="o<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="o<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" value="<?php echo HtmlEncode($partner_balance->panel_amount->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" name="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" value="<?php echo HtmlEncode($partner_balance->panel_amount->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" name="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" value="<?php echo HtmlEncode($partner_balance->panel_amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $partner_balance->total_amount->cellAttributes() ?>>
<?php if ($partner_balance->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_total_amount" class="form-group partner_balance_total_amount">
<input type="text" data-table="partner_balance" data-field="x_total_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance->total_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance->total_amount->EditValue ?>"<?php echo $partner_balance->total_amount->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" name="o<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="o<?php echo $partner_balance_grid->RowIndex ?>_total_amount" value="<?php echo HtmlEncode($partner_balance->total_amount->OldValue) ?>">
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_total_amount" class="form-group partner_balance_total_amount">
<input type="text" data-table="partner_balance" data-field="x_total_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance->total_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance->total_amount->EditValue ?>"<?php echo $partner_balance->total_amount->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_total_amount" class="partner_balance_total_amount">
<span<?php echo $partner_balance->total_amount->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->total_amount->getViewValue())) && $partner_balance->total_amount->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->total_amount->linkAttributes() ?>><?php echo $partner_balance->total_amount->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->total_amount->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$partner_balance->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" value="<?php echo HtmlEncode($partner_balance->total_amount->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" name="o<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="o<?php echo $partner_balance_grid->RowIndex ?>_total_amount" value="<?php echo HtmlEncode($partner_balance->total_amount->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" name="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" value="<?php echo HtmlEncode($partner_balance->total_amount->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" name="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_total_amount" value="<?php echo HtmlEncode($partner_balance->total_amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($partner_balance->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $partner_balance->ref->cellAttributes() ?>>
<?php if ($partner_balance->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_ref" class="form-group partner_balance_ref">
<div id="tp_x<?php echo $partner_balance_grid->RowIndex ?>_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="partner_balance" data-field="x_ref" data-value-separator="<?php echo $partner_balance->ref->displayValueSeparatorAttribute() ?>" name="x<?php echo $partner_balance_grid->RowIndex ?>_ref" id="x<?php echo $partner_balance_grid->RowIndex ?>_ref" value="{value}"<?php echo $partner_balance->ref->editAttributes() ?>></div>
<div id="dsl_x<?php echo $partner_balance_grid->RowIndex ?>_ref" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $partner_balance->ref->radioButtonListHtml(FALSE, "x{$partner_balance_grid->RowIndex}_ref") ?>
</div></div>
<?php echo $partner_balance->ref->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_ref") ?>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_ref" name="o<?php echo $partner_balance_grid->RowIndex ?>_ref" id="o<?php echo $partner_balance_grid->RowIndex ?>_ref" value="<?php echo HtmlEncode($partner_balance->ref->OldValue) ?>">
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_ref" class="form-group partner_balance_ref">
<div id="tp_x<?php echo $partner_balance_grid->RowIndex ?>_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="partner_balance" data-field="x_ref" data-value-separator="<?php echo $partner_balance->ref->displayValueSeparatorAttribute() ?>" name="x<?php echo $partner_balance_grid->RowIndex ?>_ref" id="x<?php echo $partner_balance_grid->RowIndex ?>_ref" value="{value}"<?php echo $partner_balance->ref->editAttributes() ?>></div>
<div id="dsl_x<?php echo $partner_balance_grid->RowIndex ?>_ref" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $partner_balance->ref->radioButtonListHtml(FALSE, "x{$partner_balance_grid->RowIndex}_ref") ?>
</div></div>
<?php echo $partner_balance->ref->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_ref") ?>
</span>
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_ref" class="partner_balance_ref">
<span<?php echo $partner_balance->ref->viewAttributes() ?>>
<?php echo $partner_balance->ref->getViewValue() ?></span>
</span>
<?php if (!$partner_balance->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_ref" name="x<?php echo $partner_balance_grid->RowIndex ?>_ref" id="x<?php echo $partner_balance_grid->RowIndex ?>_ref" value="<?php echo HtmlEncode($partner_balance->ref->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_ref" name="o<?php echo $partner_balance_grid->RowIndex ?>_ref" id="o<?php echo $partner_balance_grid->RowIndex ?>_ref" value="<?php echo HtmlEncode($partner_balance->ref->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="partner_balance" data-field="x_ref" name="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_ref" id="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_ref" value="<?php echo HtmlEncode($partner_balance->ref->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_ref" name="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_ref" id="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_ref" value="<?php echo HtmlEncode($partner_balance->ref->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($partner_balance->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $partner_balance->dated->cellAttributes() ?>>
<?php if ($partner_balance->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_dated" class="form-group partner_balance_dated">
<input type="text" data-table="partner_balance" data-field="x_dated" name="x<?php echo $partner_balance_grid->RowIndex ?>_dated" id="x<?php echo $partner_balance_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($partner_balance->dated->getPlaceHolder()) ?>" value="<?php echo $partner_balance->dated->EditValue ?>"<?php echo $partner_balance->dated->editAttributes() ?>>
<?php if (!$partner_balance->dated->ReadOnly && !$partner_balance->dated->Disabled && !isset($partner_balance->dated->EditAttrs["readonly"]) && !isset($partner_balance->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_balancegrid", "x<?php echo $partner_balance_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_dated" name="o<?php echo $partner_balance_grid->RowIndex ?>_dated" id="o<?php echo $partner_balance_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($partner_balance->dated->OldValue) ?>">
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_dated" class="form-group partner_balance_dated">
<input type="text" data-table="partner_balance" data-field="x_dated" name="x<?php echo $partner_balance_grid->RowIndex ?>_dated" id="x<?php echo $partner_balance_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($partner_balance->dated->getPlaceHolder()) ?>" value="<?php echo $partner_balance->dated->EditValue ?>"<?php echo $partner_balance->dated->editAttributes() ?>>
<?php if (!$partner_balance->dated->ReadOnly && !$partner_balance->dated->Disabled && !isset($partner_balance->dated->EditAttrs["readonly"]) && !isset($partner_balance->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_balancegrid", "x<?php echo $partner_balance_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($partner_balance->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $partner_balance_grid->RowCnt ?>_partner_balance_dated" class="partner_balance_dated">
<span<?php echo $partner_balance->dated->viewAttributes() ?>>
<?php echo $partner_balance->dated->getViewValue() ?></span>
</span>
<?php if (!$partner_balance->isConfirm()) { ?>
<input type="hidden" data-table="partner_balance" data-field="x_dated" name="x<?php echo $partner_balance_grid->RowIndex ?>_dated" id="x<?php echo $partner_balance_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($partner_balance->dated->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_dated" name="o<?php echo $partner_balance_grid->RowIndex ?>_dated" id="o<?php echo $partner_balance_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($partner_balance->dated->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="partner_balance" data-field="x_dated" name="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_dated" id="fpartner_balancegrid$x<?php echo $partner_balance_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($partner_balance->dated->FormValue) ?>">
<input type="hidden" data-table="partner_balance" data-field="x_dated" name="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_dated" id="fpartner_balancegrid$o<?php echo $partner_balance_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($partner_balance->dated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$partner_balance_grid->ListOptions->render("body", "right", $partner_balance_grid->RowCnt);
?>
	</tr>
<?php if ($partner_balance->RowType == ROWTYPE_ADD || $partner_balance->RowType == ROWTYPE_EDIT) { ?>
<script>
fpartner_balancegrid.updateLists(<?php echo $partner_balance_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$partner_balance->isGridAdd() || $partner_balance->CurrentMode == "copy")
		if (!$partner_balance_grid->Recordset->EOF)
			$partner_balance_grid->Recordset->moveNext();
}
?>
<?php
	if ($partner_balance->CurrentMode == "add" || $partner_balance->CurrentMode == "copy" || $partner_balance->CurrentMode == "edit") {
		$partner_balance_grid->RowIndex = '$rowindex$';
		$partner_balance_grid->loadRowValues();

		// Set row properties
		$partner_balance->resetAttributes();
		$partner_balance->RowAttrs = array_merge($partner_balance->RowAttrs, array('data-rowindex'=>$partner_balance_grid->RowIndex, 'id'=>'r0_partner_balance', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($partner_balance->RowAttrs["class"], "ew-template");
		$partner_balance->RowType = ROWTYPE_ADD;

		// Render row
		$partner_balance_grid->renderRow();

		// Render list options
		$partner_balance_grid->renderListOptions();
		$partner_balance_grid->StartRowCnt = 0;
?>
	<tr<?php echo $partner_balance->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_balance_grid->ListOptions->render("body", "left", $partner_balance_grid->RowIndex);
?>
	<?php if ($partner_balance->location->Visible) { // location ?>
		<td data-name="location">
<?php if (!$partner_balance->isConfirm()) { ?>
<?php if ($partner_balance->location->getSessionValue() <> "") { ?>
<span id="el$rowindex$_partner_balance_location" class="form-group partner_balance_location">
<span<?php echo $partner_balance->location->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->location->ViewValue)) && $partner_balance->location->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->location->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->location->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->location->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $partner_balance_grid->RowIndex ?>_location" name="x<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_partner_balance_location" class="form-group partner_balance_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_balance" data-field="x_location" data-value-separator="<?php echo $partner_balance->location->displayValueSeparatorAttribute() ?>" id="x<?php echo $partner_balance_grid->RowIndex ?>_location" name="x<?php echo $partner_balance_grid->RowIndex ?>_location"<?php echo $partner_balance->location->editAttributes() ?>>
		<?php echo $partner_balance->location->selectOptionListHtml("x<?php echo $partner_balance_grid->RowIndex ?>_location") ?>
	</select>
</div>
<?php echo $partner_balance->location->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_location") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_partner_balance_location" class="form-group partner_balance_location">
<span<?php echo $partner_balance->location->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->location->ViewValue)) && $partner_balance->location->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->location->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->location->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->location->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_location" name="x<?php echo $partner_balance_grid->RowIndex ?>_location" id="x<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_location" name="o<?php echo $partner_balance_grid->RowIndex ?>_location" id="o<?php echo $partner_balance_grid->RowIndex ?>_location" value="<?php echo HtmlEncode($partner_balance->location->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id">
<?php if (!$partner_balance->isConfirm()) { ?>
<?php if ($partner_balance->partner_id->getSessionValue() <> "") { ?>
<span id="el$rowindex$_partner_balance_partner_id" class="form-group partner_balance_partner_id">
<span<?php echo $partner_balance->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->partner_id->ViewValue)) && $partner_balance->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->partner_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->partner_id->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->partner_id->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" name="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_partner_balance_partner_id" class="form-group partner_balance_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$partner_balance->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" class="text-nowrap" style="z-index: <?php echo (9000 - $partner_balance_grid->RowCnt * 10) ?>">
	<input type="text" class="form-control" name="sv_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="sv_x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo RemoveHtml($partner_balance->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance->partner_id->displayValueSeparatorAttribute() ?>" name="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balancegrid.createAutoSuggest({"id":"x<?php echo $partner_balance_grid->RowIndex ?>_partner_id","forceSelect":true});
</script>
<?php echo $partner_balance->partner_id->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_partner_id") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_partner_balance_partner_id" class="form-group partner_balance_partner_id">
<span<?php echo $partner_balance->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->partner_id->ViewValue)) && $partner_balance->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->partner_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->partner_id->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->partner_id->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" name="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="x<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" name="o<?php echo $partner_balance_grid->RowIndex ?>_partner_id" id="o<?php echo $partner_balance_grid->RowIndex ?>_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($partner_balance->balance->Visible) { // balance ?>
		<td data-name="balance">
<?php if (!$partner_balance->isConfirm()) { ?>
<span id="el$rowindex$_partner_balance_balance" class="form-group partner_balance_balance">
<input type="text" data-table="partner_balance" data-field="x_balance" name="x<?php echo $partner_balance_grid->RowIndex ?>_balance" id="x<?php echo $partner_balance_grid->RowIndex ?>_balance" size="30" placeholder="<?php echo HtmlEncode($partner_balance->balance->getPlaceHolder()) ?>" value="<?php echo $partner_balance->balance->EditValue ?>"<?php echo $partner_balance->balance->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_partner_balance_balance" class="form-group partner_balance_balance">
<span<?php echo $partner_balance->balance->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->balance->ViewValue)) && $partner_balance->balance->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->balance->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->balance->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->balance->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_balance" name="x<?php echo $partner_balance_grid->RowIndex ?>_balance" id="x<?php echo $partner_balance_grid->RowIndex ?>_balance" value="<?php echo HtmlEncode($partner_balance->balance->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_balance" name="o<?php echo $partner_balance_grid->RowIndex ?>_balance" id="o<?php echo $partner_balance_grid->RowIndex ?>_balance" value="<?php echo HtmlEncode($partner_balance->balance->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($partner_balance->receipt->Visible) { // receipt ?>
		<td data-name="receipt">
<?php if (!$partner_balance->isConfirm()) { ?>
<span id="el$rowindex$_partner_balance_receipt" class="form-group partner_balance_receipt">
<input type="text" data-table="partner_balance" data-field="x_receipt" name="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" size="30" placeholder="<?php echo HtmlEncode($partner_balance->receipt->getPlaceHolder()) ?>" value="<?php echo $partner_balance->receipt->EditValue ?>"<?php echo $partner_balance->receipt->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_partner_balance_receipt" class="form-group partner_balance_receipt">
<span<?php echo $partner_balance->receipt->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->receipt->ViewValue)) && $partner_balance->receipt->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->receipt->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->receipt->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->receipt->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_receipt" name="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="x<?php echo $partner_balance_grid->RowIndex ?>_receipt" value="<?php echo HtmlEncode($partner_balance->receipt->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_receipt" name="o<?php echo $partner_balance_grid->RowIndex ?>_receipt" id="o<?php echo $partner_balance_grid->RowIndex ?>_receipt" value="<?php echo HtmlEncode($partner_balance->receipt->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount">
<?php if (!$partner_balance->isConfirm()) { ?>
<span id="el$rowindex$_partner_balance_panel_amount" class="form-group partner_balance_panel_amount">
<input type="text" data-table="partner_balance" data-field="x_panel_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance->panel_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance->panel_amount->EditValue ?>"<?php echo $partner_balance->panel_amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_partner_balance_panel_amount" class="form-group partner_balance_panel_amount">
<span<?php echo $partner_balance->panel_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->panel_amount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" value="<?php echo HtmlEncode($partner_balance->panel_amount->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_panel_amount" name="o<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" id="o<?php echo $partner_balance_grid->RowIndex ?>_panel_amount" value="<?php echo HtmlEncode($partner_balance->panel_amount->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount">
<?php if (!$partner_balance->isConfirm()) { ?>
<span id="el$rowindex$_partner_balance_total_amount" class="form-group partner_balance_total_amount">
<input type="text" data-table="partner_balance" data-field="x_total_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance->total_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance->total_amount->EditValue ?>"<?php echo $partner_balance->total_amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_partner_balance_total_amount" class="form-group partner_balance_total_amount">
<span<?php echo $partner_balance->total_amount->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->total_amount->ViewValue)) && $partner_balance->total_amount->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->total_amount->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->total_amount->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->total_amount->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" name="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="x<?php echo $partner_balance_grid->RowIndex ?>_total_amount" value="<?php echo HtmlEncode($partner_balance->total_amount->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_total_amount" name="o<?php echo $partner_balance_grid->RowIndex ?>_total_amount" id="o<?php echo $partner_balance_grid->RowIndex ?>_total_amount" value="<?php echo HtmlEncode($partner_balance->total_amount->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($partner_balance->ref->Visible) { // ref ?>
		<td data-name="ref">
<?php if (!$partner_balance->isConfirm()) { ?>
<span id="el$rowindex$_partner_balance_ref" class="form-group partner_balance_ref">
<div id="tp_x<?php echo $partner_balance_grid->RowIndex ?>_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="partner_balance" data-field="x_ref" data-value-separator="<?php echo $partner_balance->ref->displayValueSeparatorAttribute() ?>" name="x<?php echo $partner_balance_grid->RowIndex ?>_ref" id="x<?php echo $partner_balance_grid->RowIndex ?>_ref" value="{value}"<?php echo $partner_balance->ref->editAttributes() ?>></div>
<div id="dsl_x<?php echo $partner_balance_grid->RowIndex ?>_ref" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $partner_balance->ref->radioButtonListHtml(FALSE, "x{$partner_balance_grid->RowIndex}_ref") ?>
</div></div>
<?php echo $partner_balance->ref->Lookup->getParamTag("p_x" . $partner_balance_grid->RowIndex . "_ref") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_partner_balance_ref" class="form-group partner_balance_ref">
<span<?php echo $partner_balance->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->ref->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_ref" name="x<?php echo $partner_balance_grid->RowIndex ?>_ref" id="x<?php echo $partner_balance_grid->RowIndex ?>_ref" value="<?php echo HtmlEncode($partner_balance->ref->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_ref" name="o<?php echo $partner_balance_grid->RowIndex ?>_ref" id="o<?php echo $partner_balance_grid->RowIndex ?>_ref" value="<?php echo HtmlEncode($partner_balance->ref->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($partner_balance->dated->Visible) { // dated ?>
		<td data-name="dated">
<?php if (!$partner_balance->isConfirm()) { ?>
<span id="el$rowindex$_partner_balance_dated" class="form-group partner_balance_dated">
<input type="text" data-table="partner_balance" data-field="x_dated" name="x<?php echo $partner_balance_grid->RowIndex ?>_dated" id="x<?php echo $partner_balance_grid->RowIndex ?>_dated" placeholder="<?php echo HtmlEncode($partner_balance->dated->getPlaceHolder()) ?>" value="<?php echo $partner_balance->dated->EditValue ?>"<?php echo $partner_balance->dated->editAttributes() ?>>
<?php if (!$partner_balance->dated->ReadOnly && !$partner_balance->dated->Disabled && !isset($partner_balance->dated->EditAttrs["readonly"]) && !isset($partner_balance->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_balancegrid", "x<?php echo $partner_balance_grid->RowIndex ?>_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_partner_balance_dated" class="form-group partner_balance_dated">
<span<?php echo $partner_balance->dated->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_balance->dated->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_dated" name="x<?php echo $partner_balance_grid->RowIndex ?>_dated" id="x<?php echo $partner_balance_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($partner_balance->dated->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="partner_balance" data-field="x_dated" name="o<?php echo $partner_balance_grid->RowIndex ?>_dated" id="o<?php echo $partner_balance_grid->RowIndex ?>_dated" value="<?php echo HtmlEncode($partner_balance->dated->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$partner_balance_grid->ListOptions->render("body", "right", $partner_balance_grid->RowIndex);
?>
<script>
fpartner_balancegrid.updateLists(<?php echo $partner_balance_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
<?php

// Render aggregate row
$partner_balance->RowType = ROWTYPE_AGGREGATE;
$partner_balance->resetAttributes();
$partner_balance_grid->renderRow();
?>
<?php if ($partner_balance_grid->TotalRecs > 0 && $partner_balance->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$partner_balance_grid->renderListOptions();

// Render list options (footer, left)
$partner_balance_grid->ListOptions->render("footer", "left");
?>
	<?php if ($partner_balance->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $partner_balance->location->footerCellClass() ?>"><span id="elf_partner_balance_location" class="partner_balance_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id" class="<?php echo $partner_balance->partner_id->footerCellClass() ?>"><span id="elf_partner_balance_partner_id" class="partner_balance_partner_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $partner_balance->balance->footerCellClass() ?>"><span id="elf_partner_balance_balance" class="partner_balance_balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->receipt->Visible) { // receipt ?>
		<td data-name="receipt" class="<?php echo $partner_balance->receipt->footerCellClass() ?>"><span id="elf_partner_balance_receipt" class="partner_balance_receipt">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->receipt->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount" class="<?php echo $partner_balance->panel_amount->footerCellClass() ?>"><span id="elf_partner_balance_panel_amount" class="partner_balance_panel_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->panel_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount" class="<?php echo $partner_balance->total_amount->footerCellClass() ?>"><span id="elf_partner_balance_total_amount" class="partner_balance_total_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->total_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $partner_balance->ref->footerCellClass() ?>"><span id="elf_partner_balance_ref" class="partner_balance_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $partner_balance->dated->footerCellClass() ?>"><span id="elf_partner_balance_dated" class="partner_balance_dated">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$partner_balance_grid->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($partner_balance->CurrentMode == "add" || $partner_balance->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $partner_balance_grid->FormKeyCountName ?>" id="<?php echo $partner_balance_grid->FormKeyCountName ?>" value="<?php echo $partner_balance_grid->KeyCount ?>">
<?php echo $partner_balance_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($partner_balance->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $partner_balance_grid->FormKeyCountName ?>" id="<?php echo $partner_balance_grid->FormKeyCountName ?>" value="<?php echo $partner_balance_grid->KeyCount ?>">
<?php echo $partner_balance_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($partner_balance->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpartner_balancegrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($partner_balance_grid->Recordset)
	$partner_balance_grid->Recordset->Close();
?>
</div>
<?php if ($partner_balance_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $partner_balance_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($partner_balance_grid->TotalRecs == 0 && !$partner_balance->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $partner_balance_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$partner_balance_grid->terminate();
?>
<?php if (!$partner_balance->isExport()) { ?>
<script>
ew.scrollableTable("gmp_partner_balance", "100%", "500px");
</script>
<?php } ?>