<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_balance_list = new partner_balance_list();

// Run the page
$partner_balance_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_balance_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$partner_balance->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpartner_balancelist = currentForm = new ew.Form("fpartner_balancelist", "list");
fpartner_balancelist.formKeyCountName = '<?php echo $partner_balance_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpartner_balancelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_balancelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_balancelist.lists["x_location"] = <?php echo $partner_balance_list->location->Lookup->toClientList() ?>;
fpartner_balancelist.lists["x_location"].options = <?php echo JsonEncode($partner_balance_list->location->lookupOptions()) ?>;
fpartner_balancelist.lists["x_partner_id"] = <?php echo $partner_balance_list->partner_id->Lookup->toClientList() ?>;
fpartner_balancelist.lists["x_partner_id"].options = <?php echo JsonEncode($partner_balance_list->partner_id->lookupOptions()) ?>;
fpartner_balancelist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpartner_balancelist.lists["x_ref"] = <?php echo $partner_balance_list->ref->Lookup->toClientList() ?>;
fpartner_balancelist.lists["x_ref"].options = <?php echo JsonEncode($partner_balance_list->ref->lookupOptions()) ?>;

// Form object for search
var fpartner_balancelistsrch = currentSearchForm = new ew.Form("fpartner_balancelistsrch");

// Validate function for search
fpartner_balancelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_partner_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance->partner_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpartner_balancelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_balancelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_balancelistsrch.lists["x_location"] = <?php echo $partner_balance_list->location->Lookup->toClientList() ?>;
fpartner_balancelistsrch.lists["x_location"].options = <?php echo JsonEncode($partner_balance_list->location->lookupOptions()) ?>;
fpartner_balancelistsrch.lists["x_partner_id"] = <?php echo $partner_balance_list->partner_id->Lookup->toClientList() ?>;
fpartner_balancelistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($partner_balance_list->partner_id->lookupOptions()) ?>;
fpartner_balancelistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpartner_balancelistsrch.filterList = <?php echo $partner_balance_list->getFilterList() ?>;

// Init search panel as collapsed
fpartner_balancelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$partner_balance->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($partner_balance_list->TotalRecs > 0 && $partner_balance_list->ExportOptions->visible()) { ?>
<?php $partner_balance_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_balance_list->ImportOptions->visible()) { ?>
<?php $partner_balance_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_balance_list->SearchOptions->visible()) { ?>
<?php $partner_balance_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($partner_balance_list->FilterOptions->visible()) { ?>
<?php $partner_balance_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$partner_balance->isExport() || EXPORT_MASTER_RECORD && $partner_balance->isExport("print")) { ?>
<?php
if ($partner_balance_list->DbMasterFilter <> "" && $partner_balance->getCurrentMasterTable() == "partner_balance_compiled") {
	if ($partner_balance_list->MasterRecordExists) {
		include_once "partner_balance_compiledmaster.php";
	}
}
?>
<?php } ?>
<?php
$partner_balance_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$partner_balance->isExport() && !$partner_balance->CurrentAction) { ?>
<form name="fpartner_balancelistsrch" id="fpartner_balancelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($partner_balance_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpartner_balancelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="partner_balance">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$partner_balance_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$partner_balance->RowType = ROWTYPE_SEARCH;

// Render row
$partner_balance->resetAttributes();
$partner_balance_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($partner_balance->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $partner_balance->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_balance" data-field="x_location" data-value-separator="<?php echo $partner_balance->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $partner_balance->location->editAttributes() ?>>
		<?php echo $partner_balance->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $partner_balance->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $partner_balance->partner_id->caption() ?></label>
		<span class="ew-search-operator"><select name="z_partner_id" id="z_partner_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$partner_balance->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($partner_balance->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balancelistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":true});
</script>
<?php echo $partner_balance->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		<span class="ew-search-cond btw1_partner_id style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_partner_id style="d-none"">
<?php
$wrkonchange = "" . trim(@$partner_balance->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_y_partner_id" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_y_partner_id" id="sv_y_partner_id" value="<?php echo RemoveHtml($partner_balance->partner_id->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance->partner_id->displayValueSeparatorAttribute() ?>" name="y_partner_id" id="y_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balancelistsrch.createAutoSuggest({"id":"y_partner_id","forceSelect":true});
</script>
<?php echo $partner_balance->partner_id->Lookup->getParamTag("p_y_partner_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($partner_balance_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($partner_balance_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $partner_balance_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($partner_balance_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($partner_balance_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($partner_balance_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($partner_balance_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $partner_balance_list->showPageHeader(); ?>
<?php
$partner_balance_list->showMessage();
?>
<?php if ($partner_balance_list->TotalRecs > 0 || $partner_balance->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($partner_balance_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> partner_balance">
<?php if (!$partner_balance->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$partner_balance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_balance_list->Pager)) $partner_balance_list->Pager = new PrevNextPager($partner_balance_list->StartRec, $partner_balance_list->DisplayRecs, $partner_balance_list->TotalRecs, $partner_balance_list->AutoHidePager) ?>
<?php if ($partner_balance_list->Pager->RecordCount > 0 && $partner_balance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_balance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_balance_list->pageUrl() ?>start=<?php echo $partner_balance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_balance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_balance_list->pageUrl() ?>start=<?php echo $partner_balance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_balance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_balance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_balance_list->pageUrl() ?>start=<?php echo $partner_balance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_balance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_balance_list->pageUrl() ?>start=<?php echo $partner_balance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_balance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_balance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_balance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_balance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_balance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_balance_list->TotalRecs > 0 && (!$partner_balance_list->AutoHidePageSizeSelector || $partner_balance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_balance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_balance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_balance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_balance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_balance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_balance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_balance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_balance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpartner_balancelist" id="fpartner_balancelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_balance_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_balance_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_balance">
<?php if ($partner_balance->getCurrentMasterTable() == "partner_balance_compiled" && $partner_balance->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="partner_balance_compiled">
<input type="hidden" name="fk_partner_id" value="<?php echo $partner_balance->partner_id->getSessionValue() ?>">
<input type="hidden" name="fk_location" value="<?php echo $partner_balance->location->getSessionValue() ?>">
<?php } ?>
<div id="gmp_partner_balance" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($partner_balance_list->TotalRecs > 0 || $partner_balance->isGridEdit()) { ?>
<table id="tbl_partner_balancelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$partner_balance_list->RowType = ROWTYPE_HEADER;

// Render list options
$partner_balance_list->renderListOptions();

// Render list options (header, left)
$partner_balance_list->ListOptions->render("header", "left");
?>
<?php if ($partner_balance->location->Visible) { // location ?>
	<?php if ($partner_balance->sortUrl($partner_balance->location) == "") { ?>
		<th data-name="location" class="<?php echo $partner_balance->location->headerCellClass() ?>"><div id="elh_partner_balance_location" class="partner_balance_location"><div class="ew-table-header-caption"><?php echo $partner_balance->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $partner_balance->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance->SortUrl($partner_balance->location) ?>',2);"><div id="elh_partner_balance_location" class="partner_balance_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
	<?php if ($partner_balance->sortUrl($partner_balance->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $partner_balance->partner_id->headerCellClass() ?>"><div id="elh_partner_balance_partner_id" class="partner_balance_partner_id"><div class="ew-table-header-caption"><?php echo $partner_balance->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $partner_balance->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance->SortUrl($partner_balance->partner_id) ?>',2);"><div id="elh_partner_balance_partner_id" class="partner_balance_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->balance->Visible) { // balance ?>
	<?php if ($partner_balance->sortUrl($partner_balance->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $partner_balance->balance->headerCellClass() ?>"><div id="elh_partner_balance_balance" class="partner_balance_balance"><div class="ew-table-header-caption"><?php echo $partner_balance->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $partner_balance->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance->SortUrl($partner_balance->balance) ?>',2);"><div id="elh_partner_balance_balance" class="partner_balance_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->receipt->Visible) { // receipt ?>
	<?php if ($partner_balance->sortUrl($partner_balance->receipt) == "") { ?>
		<th data-name="receipt" class="<?php echo $partner_balance->receipt->headerCellClass() ?>"><div id="elh_partner_balance_receipt" class="partner_balance_receipt"><div class="ew-table-header-caption"><?php echo $partner_balance->receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receipt" class="<?php echo $partner_balance->receipt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance->SortUrl($partner_balance->receipt) ?>',2);"><div id="elh_partner_balance_receipt" class="partner_balance_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->receipt->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
	<?php if ($partner_balance->sortUrl($partner_balance->panel_amount) == "") { ?>
		<th data-name="panel_amount" class="<?php echo $partner_balance->panel_amount->headerCellClass() ?>"><div id="elh_partner_balance_panel_amount" class="partner_balance_panel_amount"><div class="ew-table-header-caption"><?php echo $partner_balance->panel_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="panel_amount" class="<?php echo $partner_balance->panel_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance->SortUrl($partner_balance->panel_amount) ?>',2);"><div id="elh_partner_balance_panel_amount" class="partner_balance_panel_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->panel_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->panel_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->panel_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
	<?php if ($partner_balance->sortUrl($partner_balance->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $partner_balance->total_amount->headerCellClass() ?>"><div id="elh_partner_balance_total_amount" class="partner_balance_total_amount"><div class="ew-table-header-caption"><?php echo $partner_balance->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $partner_balance->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance->SortUrl($partner_balance->total_amount) ?>',2);"><div id="elh_partner_balance_total_amount" class="partner_balance_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->ref->Visible) { // ref ?>
	<?php if ($partner_balance->sortUrl($partner_balance->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $partner_balance->ref->headerCellClass() ?>"><div id="elh_partner_balance_ref" class="partner_balance_ref"><div class="ew-table-header-caption"><?php echo $partner_balance->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $partner_balance->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance->SortUrl($partner_balance->ref) ?>',2);"><div id="elh_partner_balance_ref" class="partner_balance_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->dated->Visible) { // dated ?>
	<?php if ($partner_balance->sortUrl($partner_balance->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $partner_balance->dated->headerCellClass() ?>"><div id="elh_partner_balance_dated" class="partner_balance_dated"><div class="ew-table-header-caption"><?php echo $partner_balance->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $partner_balance->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_balance->SortUrl($partner_balance->dated) ?>',2);"><div id="elh_partner_balance_dated" class="partner_balance_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$partner_balance_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($partner_balance->ExportAll && $partner_balance->isExport()) {
	$partner_balance_list->StopRec = $partner_balance_list->TotalRecs;
} else {

	// Set the last record to display
	if ($partner_balance_list->TotalRecs > $partner_balance_list->StartRec + $partner_balance_list->DisplayRecs - 1)
		$partner_balance_list->StopRec = $partner_balance_list->StartRec + $partner_balance_list->DisplayRecs - 1;
	else
		$partner_balance_list->StopRec = $partner_balance_list->TotalRecs;
}
$partner_balance_list->RecCnt = $partner_balance_list->StartRec - 1;
if ($partner_balance_list->Recordset && !$partner_balance_list->Recordset->EOF) {
	$partner_balance_list->Recordset->moveFirst();
	$selectLimit = $partner_balance_list->UseSelectLimit;
	if (!$selectLimit && $partner_balance_list->StartRec > 1)
		$partner_balance_list->Recordset->move($partner_balance_list->StartRec - 1);
} elseif (!$partner_balance->AllowAddDeleteRow && $partner_balance_list->StopRec == 0) {
	$partner_balance_list->StopRec = $partner_balance->GridAddRowCount;
}

// Initialize aggregate
$partner_balance->RowType = ROWTYPE_AGGREGATEINIT;
$partner_balance->resetAttributes();
$partner_balance_list->renderRow();
while ($partner_balance_list->RecCnt < $partner_balance_list->StopRec) {
	$partner_balance_list->RecCnt++;
	if ($partner_balance_list->RecCnt >= $partner_balance_list->StartRec) {
		$partner_balance_list->RowCnt++;

		// Set up key count
		$partner_balance_list->KeyCount = $partner_balance_list->RowIndex;

		// Init row class and style
		$partner_balance->resetAttributes();
		$partner_balance->CssClass = "";
		if ($partner_balance->isGridAdd()) {
		} else {
			$partner_balance_list->loadRowValues($partner_balance_list->Recordset); // Load row values
		}
		$partner_balance->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$partner_balance->RowAttrs = array_merge($partner_balance->RowAttrs, array('data-rowindex'=>$partner_balance_list->RowCnt, 'id'=>'r' . $partner_balance_list->RowCnt . '_partner_balance', 'data-rowtype'=>$partner_balance->RowType));

		// Render row
		$partner_balance_list->renderRow();

		// Render list options
		$partner_balance_list->renderListOptions();
?>
	<tr<?php echo $partner_balance->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_balance_list->ListOptions->render("body", "left", $partner_balance_list->RowCnt);
?>
	<?php if ($partner_balance->location->Visible) { // location ?>
		<td data-name="location"<?php echo $partner_balance->location->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_list->RowCnt ?>_partner_balance_location" class="partner_balance_location">
<span<?php echo $partner_balance->location->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->location->getViewValue())) && $partner_balance->location->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->location->linkAttributes() ?>><?php echo $partner_balance->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $partner_balance->partner_id->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_list->RowCnt ?>_partner_balance_partner_id" class="partner_balance_partner_id">
<span<?php echo $partner_balance->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->partner_id->getViewValue())) && $partner_balance->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->partner_id->linkAttributes() ?>><?php echo $partner_balance->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $partner_balance->balance->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_list->RowCnt ?>_partner_balance_balance" class="partner_balance_balance">
<span<?php echo $partner_balance->balance->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->balance->getViewValue())) && $partner_balance->balance->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->balance->linkAttributes() ?>><?php echo $partner_balance->balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->balance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance->receipt->Visible) { // receipt ?>
		<td data-name="receipt"<?php echo $partner_balance->receipt->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_list->RowCnt ?>_partner_balance_receipt" class="partner_balance_receipt">
<span<?php echo $partner_balance->receipt->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->receipt->getViewValue())) && $partner_balance->receipt->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->receipt->linkAttributes() ?>><?php echo $partner_balance->receipt->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->receipt->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount"<?php echo $partner_balance->panel_amount->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_list->RowCnt ?>_partner_balance_panel_amount" class="partner_balance_panel_amount">
<span<?php echo $partner_balance->panel_amount->viewAttributes() ?>>
<?php echo $partner_balance->panel_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $partner_balance->total_amount->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_list->RowCnt ?>_partner_balance_total_amount" class="partner_balance_total_amount">
<span<?php echo $partner_balance->total_amount->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->total_amount->getViewValue())) && $partner_balance->total_amount->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->total_amount->linkAttributes() ?>><?php echo $partner_balance->total_amount->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->total_amount->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $partner_balance->ref->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_list->RowCnt ?>_partner_balance_ref" class="partner_balance_ref">
<span<?php echo $partner_balance->ref->viewAttributes() ?>>
<?php echo $partner_balance->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_balance->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $partner_balance->dated->cellAttributes() ?>>
<span id="el<?php echo $partner_balance_list->RowCnt ?>_partner_balance_dated" class="partner_balance_dated">
<span<?php echo $partner_balance->dated->viewAttributes() ?>>
<?php echo $partner_balance->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$partner_balance_list->ListOptions->render("body", "right", $partner_balance_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$partner_balance->isGridAdd())
		$partner_balance_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$partner_balance->RowType = ROWTYPE_AGGREGATE;
$partner_balance->resetAttributes();
$partner_balance_list->renderRow();
?>
<?php if ($partner_balance_list->TotalRecs > 0 && !$partner_balance->isGridAdd() && !$partner_balance->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$partner_balance_list->renderListOptions();

// Render list options (footer, left)
$partner_balance_list->ListOptions->render("footer", "left");
?>
	<?php if ($partner_balance->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $partner_balance->location->footerCellClass() ?>"><span id="elf_partner_balance_location" class="partner_balance_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id" class="<?php echo $partner_balance->partner_id->footerCellClass() ?>"><span id="elf_partner_balance_partner_id" class="partner_balance_partner_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $partner_balance->balance->footerCellClass() ?>"><span id="elf_partner_balance_balance" class="partner_balance_balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->receipt->Visible) { // receipt ?>
		<td data-name="receipt" class="<?php echo $partner_balance->receipt->footerCellClass() ?>"><span id="elf_partner_balance_receipt" class="partner_balance_receipt">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->receipt->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount" class="<?php echo $partner_balance->panel_amount->footerCellClass() ?>"><span id="elf_partner_balance_panel_amount" class="partner_balance_panel_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->panel_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount" class="<?php echo $partner_balance->total_amount->footerCellClass() ?>"><span id="elf_partner_balance_total_amount" class="partner_balance_total_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->total_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $partner_balance->ref->footerCellClass() ?>"><span id="elf_partner_balance_ref" class="partner_balance_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($partner_balance->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $partner_balance->dated->footerCellClass() ?>"><span id="elf_partner_balance_dated" class="partner_balance_dated">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$partner_balance_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$partner_balance->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($partner_balance_list->Recordset)
	$partner_balance_list->Recordset->Close();
?>
<?php if (!$partner_balance->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$partner_balance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_balance_list->Pager)) $partner_balance_list->Pager = new PrevNextPager($partner_balance_list->StartRec, $partner_balance_list->DisplayRecs, $partner_balance_list->TotalRecs, $partner_balance_list->AutoHidePager) ?>
<?php if ($partner_balance_list->Pager->RecordCount > 0 && $partner_balance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_balance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_balance_list->pageUrl() ?>start=<?php echo $partner_balance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_balance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_balance_list->pageUrl() ?>start=<?php echo $partner_balance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_balance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_balance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_balance_list->pageUrl() ?>start=<?php echo $partner_balance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_balance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_balance_list->pageUrl() ?>start=<?php echo $partner_balance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_balance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_balance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_balance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_balance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_balance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_balance_list->TotalRecs > 0 && (!$partner_balance_list->AutoHidePageSizeSelector || $partner_balance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_balance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_balance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_balance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_balance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_balance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_balance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_balance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_balance_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($partner_balance_list->TotalRecs == 0 && !$partner_balance->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $partner_balance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$partner_balance_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$partner_balance->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$partner_balance->isExport()) { ?>
<script>
ew.scrollableTable("gmp_partner_balance", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$partner_balance_list->terminate();
?>