<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$partner_balance_preview = new partner_balance_preview();

// Run the page
$partner_balance_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_balance_preview->Page_Render();
?>
<?php $partner_balance_preview->showPageHeader(); ?>
<div class="card ew-grid partner_balance"><!-- .card -->
<?php if ($partner_balance_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$partner_balance_preview->renderListOptions();

// Render list options (header, left)
$partner_balance_preview->ListOptions->render("header", "left");
?>
<?php if ($partner_balance->location->Visible) { // location ?>
	<?php if ($partner_balance->SortUrl($partner_balance->location) == "") { ?>
		<th class="<?php echo $partner_balance->location->headerCellClass() ?>"><?php echo $partner_balance->location->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_balance->location->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_balance->location->Name) ?>" data-sort-order="<?php echo $partner_balance_preview->SortField == $partner_balance->location->Name && $partner_balance_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_preview->SortField == $partner_balance->location->Name) { ?><?php if ($partner_balance_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
	<?php if ($partner_balance->SortUrl($partner_balance->partner_id) == "") { ?>
		<th class="<?php echo $partner_balance->partner_id->headerCellClass() ?>"><?php echo $partner_balance->partner_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_balance->partner_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_balance->partner_id->Name) ?>" data-sort-order="<?php echo $partner_balance_preview->SortField == $partner_balance->partner_id->Name && $partner_balance_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_preview->SortField == $partner_balance->partner_id->Name) { ?><?php if ($partner_balance_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->balance->Visible) { // balance ?>
	<?php if ($partner_balance->SortUrl($partner_balance->balance) == "") { ?>
		<th class="<?php echo $partner_balance->balance->headerCellClass() ?>"><?php echo $partner_balance->balance->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_balance->balance->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_balance->balance->Name) ?>" data-sort-order="<?php echo $partner_balance_preview->SortField == $partner_balance->balance->Name && $partner_balance_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_preview->SortField == $partner_balance->balance->Name) { ?><?php if ($partner_balance_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->receipt->Visible) { // receipt ?>
	<?php if ($partner_balance->SortUrl($partner_balance->receipt) == "") { ?>
		<th class="<?php echo $partner_balance->receipt->headerCellClass() ?>"><?php echo $partner_balance->receipt->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_balance->receipt->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_balance->receipt->Name) ?>" data-sort-order="<?php echo $partner_balance_preview->SortField == $partner_balance->receipt->Name && $partner_balance_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->receipt->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_preview->SortField == $partner_balance->receipt->Name) { ?><?php if ($partner_balance_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
	<?php if ($partner_balance->SortUrl($partner_balance->panel_amount) == "") { ?>
		<th class="<?php echo $partner_balance->panel_amount->headerCellClass() ?>"><?php echo $partner_balance->panel_amount->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_balance->panel_amount->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_balance->panel_amount->Name) ?>" data-sort-order="<?php echo $partner_balance_preview->SortField == $partner_balance->panel_amount->Name && $partner_balance_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->panel_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_preview->SortField == $partner_balance->panel_amount->Name) { ?><?php if ($partner_balance_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
	<?php if ($partner_balance->SortUrl($partner_balance->total_amount) == "") { ?>
		<th class="<?php echo $partner_balance->total_amount->headerCellClass() ?>"><?php echo $partner_balance->total_amount->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_balance->total_amount->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_balance->total_amount->Name) ?>" data-sort-order="<?php echo $partner_balance_preview->SortField == $partner_balance->total_amount->Name && $partner_balance_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_preview->SortField == $partner_balance->total_amount->Name) { ?><?php if ($partner_balance_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->ref->Visible) { // ref ?>
	<?php if ($partner_balance->SortUrl($partner_balance->ref) == "") { ?>
		<th class="<?php echo $partner_balance->ref->headerCellClass() ?>"><?php echo $partner_balance->ref->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_balance->ref->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_balance->ref->Name) ?>" data-sort-order="<?php echo $partner_balance_preview->SortField == $partner_balance->ref->Name && $partner_balance_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_preview->SortField == $partner_balance->ref->Name) { ?><?php if ($partner_balance_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_balance->dated->Visible) { // dated ?>
	<?php if ($partner_balance->SortUrl($partner_balance->dated) == "") { ?>
		<th class="<?php echo $partner_balance->dated->headerCellClass() ?>"><?php echo $partner_balance->dated->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_balance->dated->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_balance->dated->Name) ?>" data-sort-order="<?php echo $partner_balance_preview->SortField == $partner_balance->dated->Name && $partner_balance_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_balance->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_balance_preview->SortField == $partner_balance->dated->Name) { ?><?php if ($partner_balance_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_balance_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$partner_balance_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$partner_balance_preview->RecCount = 0;
$partner_balance_preview->RowCnt = 0;
while ($partner_balance_preview->Recordset && !$partner_balance_preview->Recordset->EOF) {

	// Init row class and style
	$partner_balance_preview->RecCount++;
	$partner_balance_preview->RowCnt++;
	$partner_balance_preview->CssStyle = "";
	$partner_balance_preview->loadListRowValues($partner_balance_preview->Recordset);
	$partner_balance_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$partner_balance_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$partner_balance_preview->resetAttributes();
	$partner_balance_preview->renderListRow();

	// Render list options
	$partner_balance_preview->renderListOptions();
?>
	<tr<?php echo $partner_balance_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_balance_preview->ListOptions->render("body", "left", $partner_balance_preview->RowCnt);
?>
<?php if ($partner_balance->location->Visible) { // location ?>
		<!-- location -->
		<td<?php echo $partner_balance->location->cellAttributes() ?>>
<span<?php echo $partner_balance->location->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->location->getViewValue())) && $partner_balance->location->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->location->linkAttributes() ?>><?php echo $partner_balance->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->location->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
		<!-- partner_id -->
		<td<?php echo $partner_balance->partner_id->cellAttributes() ?>>
<span<?php echo $partner_balance->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->partner_id->getViewValue())) && $partner_balance->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->partner_id->linkAttributes() ?>><?php echo $partner_balance->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->partner_id->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_balance->balance->Visible) { // balance ?>
		<!-- balance -->
		<td<?php echo $partner_balance->balance->cellAttributes() ?>>
<span<?php echo $partner_balance->balance->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->balance->getViewValue())) && $partner_balance->balance->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->balance->linkAttributes() ?>><?php echo $partner_balance->balance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->balance->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_balance->receipt->Visible) { // receipt ?>
		<!-- receipt -->
		<td<?php echo $partner_balance->receipt->cellAttributes() ?>>
<span<?php echo $partner_balance->receipt->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->receipt->getViewValue())) && $partner_balance->receipt->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->receipt->linkAttributes() ?>><?php echo $partner_balance->receipt->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->receipt->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
		<!-- panel_amount -->
		<td<?php echo $partner_balance->panel_amount->cellAttributes() ?>>
<span<?php echo $partner_balance->panel_amount->viewAttributes() ?>>
<?php echo $partner_balance->panel_amount->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
		<!-- total_amount -->
		<td<?php echo $partner_balance->total_amount->cellAttributes() ?>>
<span<?php echo $partner_balance->total_amount->viewAttributes() ?>>
<?php if ((!EmptyString($partner_balance->total_amount->getViewValue())) && $partner_balance->total_amount->linkAttributes() <> "") { ?>
<a<?php echo $partner_balance->total_amount->linkAttributes() ?>><?php echo $partner_balance->total_amount->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_balance->total_amount->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_balance->ref->Visible) { // ref ?>
		<!-- ref -->
		<td<?php echo $partner_balance->ref->cellAttributes() ?>>
<span<?php echo $partner_balance->ref->viewAttributes() ?>>
<?php echo $partner_balance->ref->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_balance->dated->Visible) { // dated ?>
		<!-- dated -->
		<td<?php echo $partner_balance->dated->cellAttributes() ?>>
<span<?php echo $partner_balance->dated->viewAttributes() ?>>
<?php echo $partner_balance->dated->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$partner_balance_preview->ListOptions->render("body", "right", $partner_balance_preview->RowCnt);
?>
	</tr>
<?php
	$partner_balance_preview->Recordset->MoveNext();
}
?>
	</tbody>
<?php

	// Render aggregate row
	$partner_balance_preview->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$partner_balance_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$partner_balance_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$partner_balance_preview->ListOptions->render("footer", "left");
?>
<?php if ($partner_balance->location->Visible) { // location ?>
		<!-- location -->
		<td class="<?php echo $partner_balance->location->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
		<!-- partner_id -->
		<td class="<?php echo $partner_balance->partner_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($partner_balance->balance->Visible) { // balance ?>
		<!-- balance -->
		<td class="<?php echo $partner_balance->balance->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->balance->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($partner_balance->receipt->Visible) { // receipt ?>
		<!-- receipt -->
		<td class="<?php echo $partner_balance->receipt->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->receipt->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
		<!-- panel_amount -->
		<td class="<?php echo $partner_balance->panel_amount->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->panel_amount->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
		<!-- total_amount -->
		<td class="<?php echo $partner_balance->total_amount->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $partner_balance->total_amount->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($partner_balance->ref->Visible) { // ref ?>
		<!-- ref -->
		<td class="<?php echo $partner_balance->ref->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($partner_balance->dated->Visible) { // dated ?>
		<!-- dated -->
		<td class="<?php echo $partner_balance->dated->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$partner_balance_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($partner_balance_preview->TotalRecs > 0) { ?>
<?php if (!isset($partner_balance_preview->Pager)) $partner_balance_preview->Pager = new PrevNextPager($partner_balance_preview->StartRec, $partner_balance_preview->DisplayRecs, $partner_balance_preview->TotalRecs) ?>
<?php if ($partner_balance_preview->Pager->RecordCount > 0 && $partner_balance_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($partner_balance_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $partner_balance_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($partner_balance_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $partner_balance_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($partner_balance_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $partner_balance_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($partner_balance_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $partner_balance_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $partner_balance_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $partner_balance_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $partner_balance_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($partner_balance_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$partner_balance_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($partner_balance_preview->Recordset)
	$partner_balance_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$partner_balance_preview->terminate();
?>