<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_balance_search = new partner_balance_search();

// Run the page
$partner_balance_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_balance_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($partner_balance_search->IsModal) { ?>
var fpartner_balancesearch = currentAdvancedSearchForm = new ew.Form("fpartner_balancesearch", "search");
<?php } else { ?>
var fpartner_balancesearch = currentForm = new ew.Form("fpartner_balancesearch", "search");
<?php } ?>

// Form_CustomValidate event
fpartner_balancesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_balancesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_balancesearch.lists["x_location"] = <?php echo $partner_balance_search->location->Lookup->toClientList() ?>;
fpartner_balancesearch.lists["x_location"].options = <?php echo JsonEncode($partner_balance_search->location->lookupOptions()) ?>;
fpartner_balancesearch.lists["x_partner_id"] = <?php echo $partner_balance_search->partner_id->Lookup->toClientList() ?>;
fpartner_balancesearch.lists["x_partner_id"].options = <?php echo JsonEncode($partner_balance_search->partner_id->lookupOptions()) ?>;
fpartner_balancesearch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpartner_balancesearch.lists["x_ref"] = <?php echo $partner_balance_search->ref->Lookup->toClientList() ?>;
fpartner_balancesearch.lists["x_ref"].options = <?php echo JsonEncode($partner_balance_search->ref->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpartner_balancesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_partner_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance->partner_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_receipt");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance->receipt->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_panel_amount");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance->panel_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance->total_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_balance->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $partner_balance_search->showPageHeader(); ?>
<?php
$partner_balance_search->showMessage();
?>
<form name="fpartner_balancesearch" id="fpartner_balancesearch" class="<?php echo $partner_balance_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_balance_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_balance_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_balance">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$partner_balance_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($partner_balance->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $partner_balance_search->LeftColumnClass ?>"><span id="elh_partner_balance_location"><?php echo $partner_balance->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_search->RightColumnClass ?>"><div<?php echo $partner_balance->location->cellAttributes() ?>>
			<span id="el_partner_balance_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_balance" data-field="x_location" data-value-separator="<?php echo $partner_balance->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $partner_balance->location->editAttributes() ?>>
		<?php echo $partner_balance->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $partner_balance->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $partner_balance_search->LeftColumnClass ?>"><span id="elh_partner_balance_partner_id"><?php echo $partner_balance->partner_id->caption() ?></span>
		</label>
		<div class="<?php echo $partner_balance_search->RightColumnClass ?>"><div<?php echo $partner_balance->partner_id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_partner_id" id="z_partner_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($partner_balance->partner_id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_partner_balance_partner_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$partner_balance->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($partner_balance->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balancesearch.createAutoSuggest({"id":"x_partner_id","forceSelect":true});
</script>
<?php echo $partner_balance->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
			<span class="ew-search-cond btw1_partner_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_partner_balance_partner_id" class="btw1_partner_id d-none">
<?php
$wrkonchange = "" . trim(@$partner_balance->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$partner_balance->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_y_partner_id" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_y_partner_id" id="sv_y_partner_id" value="<?php echo RemoveHtml($partner_balance->partner_id->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($partner_balance->partner_id->getPlaceHolder()) ?>"<?php echo $partner_balance->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="partner_balance" data-field="x_partner_id" data-value-separator="<?php echo $partner_balance->partner_id->displayValueSeparatorAttribute() ?>" name="y_partner_id" id="y_partner_id" value="<?php echo HtmlEncode($partner_balance->partner_id->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fpartner_balancesearch.createAutoSuggest({"id":"y_partner_id","forceSelect":true});
</script>
<?php echo $partner_balance->partner_id->Lookup->getParamTag("p_y_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $partner_balance_search->LeftColumnClass ?>"><span id="elh_partner_balance_balance"><?php echo $partner_balance->balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance" id="z_balance" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_search->RightColumnClass ?>"><div<?php echo $partner_balance->balance->cellAttributes() ?>>
			<span id="el_partner_balance_balance">
<input type="text" data-table="partner_balance" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($partner_balance->balance->getPlaceHolder()) ?>" value="<?php echo $partner_balance->balance->EditValue ?>"<?php echo $partner_balance->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance->receipt->Visible) { // receipt ?>
	<div id="r_receipt" class="form-group row">
		<label for="x_receipt" class="<?php echo $partner_balance_search->LeftColumnClass ?>"><span id="elh_partner_balance_receipt"><?php echo $partner_balance->receipt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receipt" id="z_receipt" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_search->RightColumnClass ?>"><div<?php echo $partner_balance->receipt->cellAttributes() ?>>
			<span id="el_partner_balance_receipt">
<input type="text" data-table="partner_balance" data-field="x_receipt" name="x_receipt" id="x_receipt" size="30" placeholder="<?php echo HtmlEncode($partner_balance->receipt->getPlaceHolder()) ?>" value="<?php echo $partner_balance->receipt->EditValue ?>"<?php echo $partner_balance->receipt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance->panel_amount->Visible) { // panel_amount ?>
	<div id="r_panel_amount" class="form-group row">
		<label for="x_panel_amount" class="<?php echo $partner_balance_search->LeftColumnClass ?>"><span id="elh_partner_balance_panel_amount"><?php echo $partner_balance->panel_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_panel_amount" id="z_panel_amount" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_search->RightColumnClass ?>"><div<?php echo $partner_balance->panel_amount->cellAttributes() ?>>
			<span id="el_partner_balance_panel_amount">
<input type="text" data-table="partner_balance" data-field="x_panel_amount" name="x_panel_amount" id="x_panel_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance->panel_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance->panel_amount->EditValue ?>"<?php echo $partner_balance->panel_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $partner_balance_search->LeftColumnClass ?>"><span id="elh_partner_balance_total_amount"><?php echo $partner_balance->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_search->RightColumnClass ?>"><div<?php echo $partner_balance->total_amount->cellAttributes() ?>>
			<span id="el_partner_balance_total_amount">
<input type="text" data-table="partner_balance" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($partner_balance->total_amount->getPlaceHolder()) ?>" value="<?php echo $partner_balance->total_amount->EditValue ?>"<?php echo $partner_balance->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $partner_balance_search->LeftColumnClass ?>"><span id="elh_partner_balance_ref"><?php echo $partner_balance->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_balance_search->RightColumnClass ?>"><div<?php echo $partner_balance->ref->cellAttributes() ?>>
			<span id="el_partner_balance_ref">
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="partner_balance" data-field="x_ref" data-value-separator="<?php echo $partner_balance->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $partner_balance->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $partner_balance->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $partner_balance->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_balance->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $partner_balance_search->LeftColumnClass ?>"><span id="elh_partner_balance_dated"><?php echo $partner_balance->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $partner_balance_search->RightColumnClass ?>"><div<?php echo $partner_balance->dated->cellAttributes() ?>>
			<span id="el_partner_balance_dated">
<input type="text" data-table="partner_balance" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($partner_balance->dated->getPlaceHolder()) ?>" value="<?php echo $partner_balance->dated->EditValue ?>"<?php echo $partner_balance->dated->editAttributes() ?>>
<?php if (!$partner_balance->dated->ReadOnly && !$partner_balance->dated->Disabled && !isset($partner_balance->dated->EditAttrs["readonly"]) && !isset($partner_balance->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_balancesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$partner_balance_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $partner_balance_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$partner_balance_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$partner_balance_search->terminate();
?>