<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_product_ref_addopt = new partner_product_ref_addopt();

// Run the page
$partner_product_ref_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_product_ref_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fpartner_product_refaddopt = currentForm = new ew.Form("fpartner_product_refaddopt", "addopt");

// Validate form
fpartner_product_refaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($partner_product_ref_addopt->partner_type->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner_type->caption(), $partner_product_ref->partner_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->partner->Required) { ?>
			elm = this.getElements("x" + infix + "_partner");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner->caption(), $partner_product_ref->partner->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->partner_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner_ref->caption(), $partner_product_ref->partner_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->_barcode->caption(), $partner_product_ref->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->partner_code->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner_code->caption(), $partner_product_ref->partner_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->product_type->caption(), $partner_product_ref->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->shape->caption(), $partner_product_ref->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->grp->caption(), $partner_product_ref->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->s_grp->caption(), $partner_product_ref->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->product->caption(), $partner_product_ref->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->rid->caption(), $partner_product_ref->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->spl_ins->Required) { ?>
			elm = this.getElements("x" + infix + "_spl_ins");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->spl_ins->caption(), $partner_product_ref->spl_ins->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->packing_type->caption(), $partner_product_ref->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->batch_no->caption(), $partner_product_ref->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->unit->caption(), $partner_product_ref->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->w->Required) { ?>
			elm = this.getElements("x" + infix + "_w");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->w->caption(), $partner_product_ref->w->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->w_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->w_cm->caption(), $partner_product_ref->w_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->w_cm->errorMessage()) ?>");
		<?php if ($partner_product_ref_addopt->l->Required) { ?>
			elm = this.getElements("x" + infix + "_l");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->l->caption(), $partner_product_ref->l->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->l_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->l_cm->caption(), $partner_product_ref->l_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->l_cm->errorMessage()) ?>");
		<?php if ($partner_product_ref_addopt->h->Required) { ?>
			elm = this.getElements("x" + infix + "_h");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->h->caption(), $partner_product_ref->h->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->h_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_h_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->h_cm->caption(), $partner_product_ref->h_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_h_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->h_cm->errorMessage()) ?>");
		<?php if ($partner_product_ref_addopt->partner_size->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner_size->caption(), $partner_product_ref->partner_size->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->sqm->caption(), $partner_product_ref->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->cbm->caption(), $partner_product_ref->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->cbm->errorMessage()) ?>");
		<?php if ($partner_product_ref_addopt->weight_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_weight_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->weight_sqm->caption(), $partner_product_ref->weight_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_weight_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->weight_sqm->errorMessage()) ?>");
		<?php if ($partner_product_ref_addopt->price_cs->Required) { ?>
			elm = this.getElements("x" + infix + "_price_cs");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->price_cs->caption(), $partner_product_ref->price_cs->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price_cs");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->price_cs->errorMessage()) ?>");
		<?php if ($partner_product_ref_addopt->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->currency->caption(), $partner_product_ref->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->hsn->Required) { ?>
			elm = this.getElements("x" + infix + "_hsn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->hsn->caption(), $partner_product_ref->hsn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->composition->Required) { ?>
			elm = this.getElements("x" + infix + "_composition");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->composition->caption(), $partner_product_ref->composition->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->status->caption(), $partner_product_ref->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->operator->caption(), $partner_product_ref->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->datetime->caption(), $partner_product_ref->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_addopt->gcode->Required) { ?>
			elm = this.getElements("x" + infix + "_gcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->gcode->caption(), $partner_product_ref->gcode->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpartner_product_refaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_product_refaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_product_refaddopt.lists["x_partner_type"] = <?php echo $partner_product_ref_addopt->partner_type->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_partner_type"].options = <?php echo JsonEncode($partner_product_ref_addopt->partner_type->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_partner"] = <?php echo $partner_product_ref_addopt->partner->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_partner"].options = <?php echo JsonEncode($partner_product_ref_addopt->partner->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_product_type"] = <?php echo $partner_product_ref_addopt->product_type->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_product_type"].options = <?php echo JsonEncode($partner_product_ref_addopt->product_type->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_shape"] = <?php echo $partner_product_ref_addopt->shape->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_shape"].options = <?php echo JsonEncode($partner_product_ref_addopt->shape->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_grp"] = <?php echo $partner_product_ref_addopt->grp->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_grp"].options = <?php echo JsonEncode($partner_product_ref_addopt->grp->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_s_grp"] = <?php echo $partner_product_ref_addopt->s_grp->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_s_grp"].options = <?php echo JsonEncode($partner_product_ref_addopt->s_grp->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_product"] = <?php echo $partner_product_ref_addopt->product->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_product"].options = <?php echo JsonEncode($partner_product_ref_addopt->product->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_rid"] = <?php echo $partner_product_ref_addopt->rid->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_rid"].options = <?php echo JsonEncode($partner_product_ref_addopt->rid->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_packing_type"] = <?php echo $partner_product_ref_addopt->packing_type->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_packing_type"].options = <?php echo JsonEncode($partner_product_ref_addopt->packing_type->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_batch_no"] = <?php echo $partner_product_ref_addopt->batch_no->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_batch_no"].options = <?php echo JsonEncode($partner_product_ref_addopt->batch_no->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_unit"] = <?php echo $partner_product_ref_addopt->unit->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_unit"].options = <?php echo JsonEncode($partner_product_ref_addopt->unit->options(FALSE, TRUE)) ?>;
fpartner_product_refaddopt.lists["x_currency"] = <?php echo $partner_product_ref_addopt->currency->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_currency"].options = <?php echo JsonEncode($partner_product_ref_addopt->currency->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_hsn"] = <?php echo $partner_product_ref_addopt->hsn->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_hsn"].options = <?php echo JsonEncode($partner_product_ref_addopt->hsn->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_composition"] = <?php echo $partner_product_ref_addopt->composition->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_composition"].options = <?php echo JsonEncode($partner_product_ref_addopt->composition->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_status"] = <?php echo $partner_product_ref_addopt->status->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_status"].options = <?php echo JsonEncode($partner_product_ref_addopt->status->options(FALSE, TRUE)) ?>;
fpartner_product_refaddopt.lists["x_operator"] = <?php echo $partner_product_ref_addopt->operator->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_operator"].options = <?php echo JsonEncode($partner_product_ref_addopt->operator->lookupOptions()) ?>;
fpartner_product_refaddopt.lists["x_gcode"] = <?php echo $partner_product_ref_addopt->gcode->Lookup->toClientList() ?>;
fpartner_product_refaddopt.lists["x_gcode"].options = <?php echo JsonEncode($partner_product_ref_addopt->gcode->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $partner_product_ref_addopt->showPageHeader(); ?>
<?php
$partner_product_ref_addopt->showMessage();
?>
<form name="fpartner_product_refaddopt" id="fpartner_product_refaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($partner_product_ref_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_product_ref_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $partner_product_ref_addopt->TableVar ?>">
<?php if ($partner_product_ref->partner_type->Visible) { // partner_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_partner_type"><?php echo $partner_product_ref->partner_type->caption() ?><?php echo ($partner_product_ref->partner_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $partner_product_ref->partner_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->partner_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_partner_type" data-value-separator="<?php echo $partner_product_ref->partner_type->displayValueSeparatorAttribute() ?>" id="x_partner_type" name="x_partner_type"<?php echo $partner_product_ref->partner_type->editAttributes() ?>>
		<?php echo $partner_product_ref->partner_type->selectOptionListHtml("x_partner_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->partner_type->Lookup->getParamTag("p_x_partner_type") ?>
<?php echo $partner_product_ref->partner_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner->Visible) { // partner ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_partner"><?php echo $partner_product_ref->partner->caption() ?><?php echo ($partner_product_ref->partner->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $partner_product_ref->partner->EditAttrs["onchange"] = "ew.autoFill(this);" . @$partner_product_ref->partner->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_partner" data-value-separator="<?php echo $partner_product_ref->partner->displayValueSeparatorAttribute() ?>" id="x_partner" name="x_partner"<?php echo $partner_product_ref->partner->editAttributes() ?>>
		<?php echo $partner_product_ref->partner->selectOptionListHtml("x_partner") ?>
	</select>
</div>
<?php echo $partner_product_ref->partner->Lookup->getParamTag("p_x_partner") ?>
<?php echo $partner_product_ref->partner->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_ref->Visible) { // partner_ref ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_partner_ref"><?php echo $partner_product_ref->partner_ref->caption() ?><?php echo ($partner_product_ref->partner_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_partner_ref" name="x_partner_ref" id="x_partner_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_ref->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_ref->EditValue ?>"<?php echo $partner_product_ref->partner_ref->editAttributes() ?>>
<?php echo $partner_product_ref->partner_ref->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->_barcode->Visible) { // barcode ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__barcode"><?php echo $partner_product_ref->_barcode->caption() ?><?php echo ($partner_product_ref->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_product_ref->_barcode->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->_barcode->EditValue ?>"<?php echo $partner_product_ref->_barcode->editAttributes() ?>>
<?php echo $partner_product_ref->_barcode->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_code->Visible) { // partner_code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_partner_code"><?php echo $partner_product_ref->partner_code->caption() ?><?php echo ($partner_product_ref->partner_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_code->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_code->EditValue ?>"<?php echo $partner_product_ref->partner_code->editAttributes() ?>>
<?php echo $partner_product_ref->partner_code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->product_type->Visible) { // product_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product_type"><?php echo $partner_product_ref->product_type->caption() ?><?php echo ($partner_product_ref->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_product_type" data-value-separator="<?php echo $partner_product_ref->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $partner_product_ref->product_type->editAttributes() ?>>
		<?php echo $partner_product_ref->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->product_type->Lookup->getParamTag("p_x_product_type") ?>
<?php echo $partner_product_ref->product_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->shape->Visible) { // shape ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_shape"><?php echo $partner_product_ref->shape->caption() ?><?php echo ($partner_product_ref->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_shape" data-value-separator="<?php echo $partner_product_ref->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $partner_product_ref->shape->editAttributes() ?>>
		<?php echo $partner_product_ref->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $partner_product_ref->shape->Lookup->getParamTag("p_x_shape") ?>
<?php echo $partner_product_ref->shape->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $partner_product_ref->grp->caption() ?><?php echo ($partner_product_ref->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $partner_product_ref->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_grp" data-value-separator="<?php echo $partner_product_ref->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $partner_product_ref->grp->editAttributes() ?>>
		<?php echo $partner_product_ref->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $partner_product_ref->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $partner_product_ref->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->s_grp->Visible) { // s_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_s_grp"><?php echo $partner_product_ref->s_grp->caption() ?><?php echo ($partner_product_ref->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $partner_product_ref->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_s_grp" data-value-separator="<?php echo $partner_product_ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $partner_product_ref->s_grp->editAttributes() ?>>
		<?php echo $partner_product_ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $partner_product_ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<?php echo $partner_product_ref->s_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $partner_product_ref->product->caption() ?><?php echo ($partner_product_ref->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $partner_product_ref->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_product" data-value-separator="<?php echo $partner_product_ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $partner_product_ref->product->editAttributes() ?>>
		<?php echo $partner_product_ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $partner_product_ref->product->Lookup->getParamTag("p_x_product") ?>
<?php echo $partner_product_ref->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->rid->Visible) { // rid ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_rid"><?php echo $partner_product_ref->rid->caption() ?><?php echo ($partner_product_ref->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $partner_product_ref->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->rid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_rid" data-value-separator="<?php echo $partner_product_ref->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $partner_product_ref->rid->editAttributes() ?>>
		<?php echo $partner_product_ref->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $partner_product_ref->rid->Lookup->getParamTag("p_x_rid") ?>
<?php echo $partner_product_ref->rid->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->spl_ins->Visible) { // spl_ins ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_spl_ins"><?php echo $partner_product_ref->spl_ins->caption() ?><?php echo ($partner_product_ref->spl_ins->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_spl_ins" name="x_spl_ins" id="x_spl_ins" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->spl_ins->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->spl_ins->EditValue ?>"<?php echo $partner_product_ref->spl_ins->editAttributes() ?>>
<?php echo $partner_product_ref->spl_ins->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->packing_type->Visible) { // packing_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_packing_type"><?php echo $partner_product_ref->packing_type->caption() ?><?php echo ($partner_product_ref->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_packing_type" data-value-separator="<?php echo $partner_product_ref->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $partner_product_ref->packing_type->editAttributes() ?>>
		<?php echo $partner_product_ref->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
<?php echo $partner_product_ref->packing_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->batch_no->Visible) { // batch_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_batch_no"><?php echo $partner_product_ref->batch_no->caption() ?><?php echo ($partner_product_ref->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_batch_no" data-value-separator="<?php echo $partner_product_ref->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $partner_product_ref->batch_no->editAttributes() ?>>
		<?php echo $partner_product_ref->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $partner_product_ref->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
<?php echo $partner_product_ref->batch_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->unit->Visible) { // unit ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_unit"><?php echo $partner_product_ref->unit->caption() ?><?php echo ($partner_product_ref->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_unit" data-value-separator="<?php echo $partner_product_ref->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $partner_product_ref->unit->editAttributes() ?>>
		<?php echo $partner_product_ref->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $partner_product_ref->unit->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->w->Visible) { // w ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_w"><?php echo $partner_product_ref->w->caption() ?><?php echo ($partner_product_ref->w->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_w" name="x_w" id="x_w" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->w->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->w->EditValue ?>"<?php echo $partner_product_ref->w->editAttributes() ?>>
<?php echo $partner_product_ref->w->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->w_cm->Visible) { // w_cm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_w_cm"><?php echo $partner_product_ref->w_cm->caption() ?><?php echo ($partner_product_ref->w_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->w_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->w_cm->EditValue ?>"<?php echo $partner_product_ref->w_cm->editAttributes() ?>>
<?php echo $partner_product_ref->w_cm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->l->Visible) { // l ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_l"><?php echo $partner_product_ref->l->caption() ?><?php echo ($partner_product_ref->l->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_l" name="x_l" id="x_l" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->l->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->l->EditValue ?>"<?php echo $partner_product_ref->l->editAttributes() ?>>
<?php echo $partner_product_ref->l->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->l_cm->Visible) { // l_cm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_l_cm"><?php echo $partner_product_ref->l_cm->caption() ?><?php echo ($partner_product_ref->l_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->l_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->l_cm->EditValue ?>"<?php echo $partner_product_ref->l_cm->editAttributes() ?>>
<?php echo $partner_product_ref->l_cm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->h->Visible) { // h ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_h"><?php echo $partner_product_ref->h->caption() ?><?php echo ($partner_product_ref->h->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_h" name="x_h" id="x_h" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->h->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->h->EditValue ?>"<?php echo $partner_product_ref->h->editAttributes() ?>>
<?php echo $partner_product_ref->h->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->h_cm->Visible) { // h_cm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_h_cm"><?php echo $partner_product_ref->h_cm->caption() ?><?php echo ($partner_product_ref->h_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_h_cm" name="x_h_cm" id="x_h_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->h_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->h_cm->EditValue ?>"<?php echo $partner_product_ref->h_cm->editAttributes() ?>>
<?php echo $partner_product_ref->h_cm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_size->Visible) { // partner_size ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_partner_size"><?php echo $partner_product_ref->partner_size->caption() ?><?php echo ($partner_product_ref->partner_size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_partner_size" name="x_partner_size" id="x_partner_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_size->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_size->EditValue ?>"<?php echo $partner_product_ref->partner_size->editAttributes() ?>>
<?php echo $partner_product_ref->partner_size->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->sqm->Visible) { // sqm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_sqm"><?php echo $partner_product_ref->sqm->caption() ?><?php echo ($partner_product_ref->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->sqm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->sqm->EditValue ?>"<?php echo $partner_product_ref->sqm->editAttributes() ?>>
<?php echo $partner_product_ref->sqm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->cbm->Visible) { // cbm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_cbm"><?php echo $partner_product_ref->cbm->caption() ?><?php echo ($partner_product_ref->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->cbm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->cbm->EditValue ?>"<?php echo $partner_product_ref->cbm->editAttributes() ?>>
<?php echo $partner_product_ref->cbm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->weight_sqm->Visible) { // weight_sqm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_weight_sqm"><?php echo $partner_product_ref->weight_sqm->caption() ?><?php echo ($partner_product_ref->weight_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_weight_sqm" name="x_weight_sqm" id="x_weight_sqm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->weight_sqm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->weight_sqm->EditValue ?>"<?php echo $partner_product_ref->weight_sqm->editAttributes() ?>>
<?php echo $partner_product_ref->weight_sqm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->price_cs->Visible) { // price_cs ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_price_cs"><?php echo $partner_product_ref->price_cs->caption() ?><?php echo ($partner_product_ref->price_cs->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="partner_product_ref" data-field="x_price_cs" name="x_price_cs" id="x_price_cs" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->price_cs->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->price_cs->EditValue ?>"<?php echo $partner_product_ref->price_cs->editAttributes() ?>>
<?php echo $partner_product_ref->price_cs->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->currency->Visible) { // currency ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_currency"><?php echo $partner_product_ref->currency->caption() ?><?php echo ($partner_product_ref->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_currency" data-value-separator="<?php echo $partner_product_ref->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $partner_product_ref->currency->editAttributes() ?>>
		<?php echo $partner_product_ref->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $partner_product_ref->currency->Lookup->getParamTag("p_x_currency") ?>
<?php echo $partner_product_ref->currency->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->hsn->Visible) { // hsn ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_hsn"><?php echo $partner_product_ref->hsn->caption() ?><?php echo ($partner_product_ref->hsn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_hsn" data-value-separator="<?php echo $partner_product_ref->hsn->displayValueSeparatorAttribute() ?>" id="x_hsn" name="x_hsn"<?php echo $partner_product_ref->hsn->editAttributes() ?>>
		<?php echo $partner_product_ref->hsn->selectOptionListHtml("x_hsn") ?>
	</select>
</div>
<?php echo $partner_product_ref->hsn->Lookup->getParamTag("p_x_hsn") ?>
<?php echo $partner_product_ref->hsn->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->composition->Visible) { // composition ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_composition"><?php echo $partner_product_ref->composition->caption() ?><?php echo ($partner_product_ref->composition->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_composition" data-value-separator="<?php echo $partner_product_ref->composition->displayValueSeparatorAttribute() ?>" id="x_composition" name="x_composition"<?php echo $partner_product_ref->composition->editAttributes() ?>>
		<?php echo $partner_product_ref->composition->selectOptionListHtml("x_composition") ?>
	</select>
</div>
<?php echo $partner_product_ref->composition->Lookup->getParamTag("p_x_composition") ?>
<?php echo $partner_product_ref->composition->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $partner_product_ref->status->caption() ?><?php echo ($partner_product_ref->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_status" data-value-separator="<?php echo $partner_product_ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $partner_product_ref->status->editAttributes() ?>>
		<?php echo $partner_product_ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $partner_product_ref->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->operator->Visible) { // operator ?>
	<input type="hidden" data-table="partner_product_ref" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($partner_product_ref->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($partner_product_ref->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="partner_product_ref" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($partner_product_ref->datetime->CurrentValue) ?>">
	<?php if (!$partner_product_ref->datetime->ReadOnly && !$partner_product_ref->datetime->Disabled && !isset($partner_product_ref->datetime->EditAttrs["readonly"]) && !isset($partner_product_ref->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fpartner_product_refaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->gcode->Visible) { // gcode ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_gcode"><?php echo $partner_product_ref->gcode->caption() ?><?php echo ($partner_product_ref->gcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_gcode" data-value-separator="<?php echo $partner_product_ref->gcode->displayValueSeparatorAttribute() ?>" id="x_gcode" name="x_gcode"<?php echo $partner_product_ref->gcode->editAttributes() ?>>
		<?php echo $partner_product_ref->gcode->selectOptionListHtml("x_gcode") ?>
	</select>
</div>
<?php echo $partner_product_ref->gcode->Lookup->getParamTag("p_x_gcode") ?>
<?php echo $partner_product_ref->gcode->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$partner_product_ref_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$partner_product_ref_addopt->terminate();
?>