<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_product_ref_edit = new partner_product_ref_edit();

// Run the page
$partner_product_ref_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_product_ref_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpartner_product_refedit = currentForm = new ew.Form("fpartner_product_refedit", "edit");

// Validate form
fpartner_product_refedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($partner_product_ref_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->id->caption(), $partner_product_ref->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->partner_type->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner_type->caption(), $partner_product_ref->partner_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->partner->Required) { ?>
			elm = this.getElements("x" + infix + "_partner");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner->caption(), $partner_product_ref->partner->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->partner_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner_ref->caption(), $partner_product_ref->partner_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->_barcode->caption(), $partner_product_ref->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->partner_code->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner_code->caption(), $partner_product_ref->partner_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->product_type->caption(), $partner_product_ref->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->shape->caption(), $partner_product_ref->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->grp->caption(), $partner_product_ref->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->s_grp->caption(), $partner_product_ref->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->product->caption(), $partner_product_ref->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->rid->caption(), $partner_product_ref->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->spl_ins->Required) { ?>
			elm = this.getElements("x" + infix + "_spl_ins");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->spl_ins->caption(), $partner_product_ref->spl_ins->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->packing_type->caption(), $partner_product_ref->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->batch_no->caption(), $partner_product_ref->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->unit->caption(), $partner_product_ref->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->w->Required) { ?>
			elm = this.getElements("x" + infix + "_w");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->w->caption(), $partner_product_ref->w->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->w_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->w_cm->caption(), $partner_product_ref->w_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_w_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->w_cm->errorMessage()) ?>");
		<?php if ($partner_product_ref_edit->l->Required) { ?>
			elm = this.getElements("x" + infix + "_l");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->l->caption(), $partner_product_ref->l->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->l_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->l_cm->caption(), $partner_product_ref->l_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_l_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->l_cm->errorMessage()) ?>");
		<?php if ($partner_product_ref_edit->h->Required) { ?>
			elm = this.getElements("x" + infix + "_h");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->h->caption(), $partner_product_ref->h->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->h_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_h_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->h_cm->caption(), $partner_product_ref->h_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_h_cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->h_cm->errorMessage()) ?>");
		<?php if ($partner_product_ref_edit->partner_size->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->partner_size->caption(), $partner_product_ref->partner_size->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->sqm->caption(), $partner_product_ref->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->cbm->caption(), $partner_product_ref->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->cbm->errorMessage()) ?>");
		<?php if ($partner_product_ref_edit->weight_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_weight_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->weight_sqm->caption(), $partner_product_ref->weight_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_weight_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->weight_sqm->errorMessage()) ?>");
		<?php if ($partner_product_ref_edit->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->price->caption(), $partner_product_ref->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->price->errorMessage()) ?>");
		<?php if ($partner_product_ref_edit->price_cs->Required) { ?>
			elm = this.getElements("x" + infix + "_price_cs");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->price_cs->caption(), $partner_product_ref->price_cs->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price_cs");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_product_ref->price_cs->errorMessage()) ?>");
		<?php if ($partner_product_ref_edit->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->currency->caption(), $partner_product_ref->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->hsn->Required) { ?>
			elm = this.getElements("x" + infix + "_hsn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->hsn->caption(), $partner_product_ref->hsn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->composition->Required) { ?>
			elm = this.getElements("x" + infix + "_composition");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->composition->caption(), $partner_product_ref->composition->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->status->caption(), $partner_product_ref->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->operator->caption(), $partner_product_ref->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_product_ref_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_product_ref->datetime->caption(), $partner_product_ref->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpartner_product_refedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_product_refedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_product_refedit.lists["x_partner_type"] = <?php echo $partner_product_ref_edit->partner_type->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_partner_type"].options = <?php echo JsonEncode($partner_product_ref_edit->partner_type->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_partner"] = <?php echo $partner_product_ref_edit->partner->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_partner"].options = <?php echo JsonEncode($partner_product_ref_edit->partner->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_product_type"] = <?php echo $partner_product_ref_edit->product_type->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_product_type"].options = <?php echo JsonEncode($partner_product_ref_edit->product_type->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_shape"] = <?php echo $partner_product_ref_edit->shape->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_shape"].options = <?php echo JsonEncode($partner_product_ref_edit->shape->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_grp"] = <?php echo $partner_product_ref_edit->grp->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_grp"].options = <?php echo JsonEncode($partner_product_ref_edit->grp->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_s_grp"] = <?php echo $partner_product_ref_edit->s_grp->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_s_grp"].options = <?php echo JsonEncode($partner_product_ref_edit->s_grp->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_product"] = <?php echo $partner_product_ref_edit->product->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_product"].options = <?php echo JsonEncode($partner_product_ref_edit->product->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_rid"] = <?php echo $partner_product_ref_edit->rid->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_rid"].options = <?php echo JsonEncode($partner_product_ref_edit->rid->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_packing_type"] = <?php echo $partner_product_ref_edit->packing_type->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_packing_type"].options = <?php echo JsonEncode($partner_product_ref_edit->packing_type->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_batch_no"] = <?php echo $partner_product_ref_edit->batch_no->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_batch_no"].options = <?php echo JsonEncode($partner_product_ref_edit->batch_no->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_unit"] = <?php echo $partner_product_ref_edit->unit->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_unit"].options = <?php echo JsonEncode($partner_product_ref_edit->unit->options(FALSE, TRUE)) ?>;
fpartner_product_refedit.lists["x_currency"] = <?php echo $partner_product_ref_edit->currency->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_currency"].options = <?php echo JsonEncode($partner_product_ref_edit->currency->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_hsn"] = <?php echo $partner_product_ref_edit->hsn->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_hsn"].options = <?php echo JsonEncode($partner_product_ref_edit->hsn->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_composition"] = <?php echo $partner_product_ref_edit->composition->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_composition"].options = <?php echo JsonEncode($partner_product_ref_edit->composition->lookupOptions()) ?>;
fpartner_product_refedit.lists["x_status"] = <?php echo $partner_product_ref_edit->status->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_status"].options = <?php echo JsonEncode($partner_product_ref_edit->status->options(FALSE, TRUE)) ?>;
fpartner_product_refedit.lists["x_operator"] = <?php echo $partner_product_ref_edit->operator->Lookup->toClientList() ?>;
fpartner_product_refedit.lists["x_operator"].options = <?php echo JsonEncode($partner_product_ref_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $partner_product_ref_edit->showPageHeader(); ?>
<?php
$partner_product_ref_edit->showMessage();
?>
<form name="fpartner_product_refedit" id="fpartner_product_refedit" class="<?php echo $partner_product_ref_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_product_ref_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_product_ref_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_product_ref">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$partner_product_ref_edit->IsModal ?>">
<?php if ($partner_product_ref->getCurrentMasterTable() == "ref") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="ref">
<input type="hidden" name="fk_id" value="<?php echo $partner_product_ref->rid->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($partner_product_ref->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_partner_product_ref_id" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->id->caption() ?><?php echo ($partner_product_ref->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->id->cellAttributes() ?>>
<span id="el_partner_product_ref_id">
<span<?php echo $partner_product_ref->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_product_ref->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="partner_product_ref" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($partner_product_ref->id->CurrentValue) ?>">
<?php echo $partner_product_ref->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_type->Visible) { // partner_type ?>
	<div id="r_partner_type" class="form-group row">
		<label id="elh_partner_product_ref_partner_type" for="x_partner_type" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->partner_type->caption() ?><?php echo ($partner_product_ref->partner_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner_type->cellAttributes() ?>>
<span id="el_partner_product_ref_partner_type">
<?php $partner_product_ref->partner_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->partner_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_partner_type" data-value-separator="<?php echo $partner_product_ref->partner_type->displayValueSeparatorAttribute() ?>" id="x_partner_type" name="x_partner_type"<?php echo $partner_product_ref->partner_type->editAttributes() ?>>
		<?php echo $partner_product_ref->partner_type->selectOptionListHtml("x_partner_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->partner_type->Lookup->getParamTag("p_x_partner_type") ?>
</span>
<?php echo $partner_product_ref->partner_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner->Visible) { // partner ?>
	<div id="r_partner" class="form-group row">
		<label id="elh_partner_product_ref_partner" for="x_partner" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->partner->caption() ?><?php echo ($partner_product_ref->partner->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner->cellAttributes() ?>>
<span id="el_partner_product_ref_partner">
<?php $partner_product_ref->partner->EditAttrs["onchange"] = "ew.autoFill(this);" . @$partner_product_ref->partner->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_partner" data-value-separator="<?php echo $partner_product_ref->partner->displayValueSeparatorAttribute() ?>" id="x_partner" name="x_partner"<?php echo $partner_product_ref->partner->editAttributes() ?>>
		<?php echo $partner_product_ref->partner->selectOptionListHtml("x_partner") ?>
	</select>
</div>
<?php echo $partner_product_ref->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
<?php echo $partner_product_ref->partner->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_ref->Visible) { // partner_ref ?>
	<div id="r_partner_ref" class="form-group row">
		<label id="elh_partner_product_ref_partner_ref" for="x_partner_ref" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->partner_ref->caption() ?><?php echo ($partner_product_ref->partner_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner_ref->cellAttributes() ?>>
<span id="el_partner_product_ref_partner_ref">
<input type="text" data-table="partner_product_ref" data-field="x_partner_ref" name="x_partner_ref" id="x_partner_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_ref->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_ref->EditValue ?>"<?php echo $partner_product_ref->partner_ref->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->partner_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_partner_product_ref__barcode" for="x__barcode" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->_barcode->caption() ?><?php echo ($partner_product_ref->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->_barcode->cellAttributes() ?>>
<span id="el_partner_product_ref__barcode">
<input type="text" data-table="partner_product_ref" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_product_ref->_barcode->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->_barcode->EditValue ?>"<?php echo $partner_product_ref->_barcode->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_code->Visible) { // partner_code ?>
	<div id="r_partner_code" class="form-group row">
		<label id="elh_partner_product_ref_partner_code" for="x_partner_code" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->partner_code->caption() ?><?php echo ($partner_product_ref->partner_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner_code->cellAttributes() ?>>
<span id="el_partner_product_ref_partner_code">
<input type="text" data-table="partner_product_ref" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_code->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_code->EditValue ?>"<?php echo $partner_product_ref->partner_code->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->partner_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_partner_product_ref_product_type" for="x_product_type" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->product_type->caption() ?><?php echo ($partner_product_ref->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->product_type->cellAttributes() ?>>
<span id="el_partner_product_ref_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_product_type" data-value-separator="<?php echo $partner_product_ref->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $partner_product_ref->product_type->editAttributes() ?>>
		<?php echo $partner_product_ref->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
<?php echo $partner_product_ref->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_partner_product_ref_shape" for="x_shape" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->shape->caption() ?><?php echo ($partner_product_ref->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->shape->cellAttributes() ?>>
<span id="el_partner_product_ref_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_shape" data-value-separator="<?php echo $partner_product_ref->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $partner_product_ref->shape->editAttributes() ?>>
		<?php echo $partner_product_ref->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $partner_product_ref->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
<?php echo $partner_product_ref->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_partner_product_ref_grp" for="x_grp" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->grp->caption() ?><?php echo ($partner_product_ref->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->grp->cellAttributes() ?>>
<span id="el_partner_product_ref_grp">
<?php $partner_product_ref->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_grp" data-value-separator="<?php echo $partner_product_ref->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $partner_product_ref->grp->editAttributes() ?>>
		<?php echo $partner_product_ref->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $partner_product_ref->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $partner_product_ref->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_partner_product_ref_s_grp" for="x_s_grp" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->s_grp->caption() ?><?php echo ($partner_product_ref->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->s_grp->cellAttributes() ?>>
<span id="el_partner_product_ref_s_grp">
<?php $partner_product_ref->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_s_grp" data-value-separator="<?php echo $partner_product_ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $partner_product_ref->s_grp->editAttributes() ?>>
		<?php echo $partner_product_ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $partner_product_ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $partner_product_ref->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_partner_product_ref_product" for="x_product" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->product->caption() ?><?php echo ($partner_product_ref->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->product->cellAttributes() ?>>
<span id="el_partner_product_ref_product">
<?php $partner_product_ref->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_product" data-value-separator="<?php echo $partner_product_ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $partner_product_ref->product->editAttributes() ?>>
		<?php echo $partner_product_ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $partner_product_ref->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $partner_product_ref->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_partner_product_ref_rid" for="x_rid" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->rid->caption() ?><?php echo ($partner_product_ref->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->rid->cellAttributes() ?>>
<?php if ($partner_product_ref->rid->getSessionValue() <> "") { ?>
<span id="el_partner_product_ref_rid">
<span<?php echo $partner_product_ref->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($partner_product_ref->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_rid" name="x_rid" value="<?php echo HtmlEncode($partner_product_ref->rid->CurrentValue) ?>">
<?php } else { ?>
<span id="el_partner_product_ref_rid">
<?php $partner_product_ref->rid->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->rid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_rid" data-value-separator="<?php echo $partner_product_ref->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $partner_product_ref->rid->editAttributes() ?>>
		<?php echo $partner_product_ref->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $partner_product_ref->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php } ?>
<?php echo $partner_product_ref->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->spl_ins->Visible) { // spl_ins ?>
	<div id="r_spl_ins" class="form-group row">
		<label id="elh_partner_product_ref_spl_ins" for="x_spl_ins" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->spl_ins->caption() ?><?php echo ($partner_product_ref->spl_ins->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->spl_ins->cellAttributes() ?>>
<span id="el_partner_product_ref_spl_ins">
<input type="text" data-table="partner_product_ref" data-field="x_spl_ins" name="x_spl_ins" id="x_spl_ins" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->spl_ins->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->spl_ins->EditValue ?>"<?php echo $partner_product_ref->spl_ins->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->spl_ins->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_partner_product_ref_packing_type" for="x_packing_type" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->packing_type->caption() ?><?php echo ($partner_product_ref->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->packing_type->cellAttributes() ?>>
<span id="el_partner_product_ref_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_packing_type" data-value-separator="<?php echo $partner_product_ref->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $partner_product_ref->packing_type->editAttributes() ?>>
		<?php echo $partner_product_ref->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $partner_product_ref->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_partner_product_ref_batch_no" for="x_batch_no" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->batch_no->caption() ?><?php echo ($partner_product_ref->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->batch_no->cellAttributes() ?>>
<span id="el_partner_product_ref_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_batch_no" data-value-separator="<?php echo $partner_product_ref->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $partner_product_ref->batch_no->editAttributes() ?>>
		<?php echo $partner_product_ref->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $partner_product_ref->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
<?php echo $partner_product_ref->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label id="elh_partner_product_ref_unit" for="x_unit" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->unit->caption() ?><?php echo ($partner_product_ref->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->unit->cellAttributes() ?>>
<span id="el_partner_product_ref_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_unit" data-value-separator="<?php echo $partner_product_ref->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $partner_product_ref->unit->editAttributes() ?>>
		<?php echo $partner_product_ref->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
</span>
<?php echo $partner_product_ref->unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->w->Visible) { // w ?>
	<div id="r_w" class="form-group row">
		<label id="elh_partner_product_ref_w" for="x_w" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->w->caption() ?><?php echo ($partner_product_ref->w->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->w->cellAttributes() ?>>
<span id="el_partner_product_ref_w">
<input type="text" data-table="partner_product_ref" data-field="x_w" name="x_w" id="x_w" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->w->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->w->EditValue ?>"<?php echo $partner_product_ref->w->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->w->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label id="elh_partner_product_ref_w_cm" for="x_w_cm" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->w_cm->caption() ?><?php echo ($partner_product_ref->w_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->w_cm->cellAttributes() ?>>
<span id="el_partner_product_ref_w_cm">
<input type="text" data-table="partner_product_ref" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->w_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->w_cm->EditValue ?>"<?php echo $partner_product_ref->w_cm->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->w_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->l->Visible) { // l ?>
	<div id="r_l" class="form-group row">
		<label id="elh_partner_product_ref_l" for="x_l" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->l->caption() ?><?php echo ($partner_product_ref->l->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->l->cellAttributes() ?>>
<span id="el_partner_product_ref_l">
<input type="text" data-table="partner_product_ref" data-field="x_l" name="x_l" id="x_l" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->l->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->l->EditValue ?>"<?php echo $partner_product_ref->l->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->l->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label id="elh_partner_product_ref_l_cm" for="x_l_cm" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->l_cm->caption() ?><?php echo ($partner_product_ref->l_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->l_cm->cellAttributes() ?>>
<span id="el_partner_product_ref_l_cm">
<input type="text" data-table="partner_product_ref" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->l_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->l_cm->EditValue ?>"<?php echo $partner_product_ref->l_cm->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->l_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->h->Visible) { // h ?>
	<div id="r_h" class="form-group row">
		<label id="elh_partner_product_ref_h" for="x_h" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->h->caption() ?><?php echo ($partner_product_ref->h->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->h->cellAttributes() ?>>
<span id="el_partner_product_ref_h">
<input type="text" data-table="partner_product_ref" data-field="x_h" name="x_h" id="x_h" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->h->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->h->EditValue ?>"<?php echo $partner_product_ref->h->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->h->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->h_cm->Visible) { // h_cm ?>
	<div id="r_h_cm" class="form-group row">
		<label id="elh_partner_product_ref_h_cm" for="x_h_cm" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->h_cm->caption() ?><?php echo ($partner_product_ref->h_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->h_cm->cellAttributes() ?>>
<span id="el_partner_product_ref_h_cm">
<input type="text" data-table="partner_product_ref" data-field="x_h_cm" name="x_h_cm" id="x_h_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->h_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->h_cm->EditValue ?>"<?php echo $partner_product_ref->h_cm->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->h_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_size->Visible) { // partner_size ?>
	<div id="r_partner_size" class="form-group row">
		<label id="elh_partner_product_ref_partner_size" for="x_partner_size" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->partner_size->caption() ?><?php echo ($partner_product_ref->partner_size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner_size->cellAttributes() ?>>
<span id="el_partner_product_ref_partner_size">
<input type="text" data-table="partner_product_ref" data-field="x_partner_size" name="x_partner_size" id="x_partner_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_size->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_size->EditValue ?>"<?php echo $partner_product_ref->partner_size->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->partner_size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_partner_product_ref_sqm" for="x_sqm" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->sqm->caption() ?><?php echo ($partner_product_ref->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->sqm->cellAttributes() ?>>
<span id="el_partner_product_ref_sqm">
<input type="text" data-table="partner_product_ref" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->sqm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->sqm->EditValue ?>"<?php echo $partner_product_ref->sqm->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label id="elh_partner_product_ref_cbm" for="x_cbm" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->cbm->caption() ?><?php echo ($partner_product_ref->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->cbm->cellAttributes() ?>>
<span id="el_partner_product_ref_cbm">
<input type="text" data-table="partner_product_ref" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->cbm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->cbm->EditValue ?>"<?php echo $partner_product_ref->cbm->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->weight_sqm->Visible) { // weight_sqm ?>
	<div id="r_weight_sqm" class="form-group row">
		<label id="elh_partner_product_ref_weight_sqm" for="x_weight_sqm" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->weight_sqm->caption() ?><?php echo ($partner_product_ref->weight_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->weight_sqm->cellAttributes() ?>>
<span id="el_partner_product_ref_weight_sqm">
<input type="text" data-table="partner_product_ref" data-field="x_weight_sqm" name="x_weight_sqm" id="x_weight_sqm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->weight_sqm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->weight_sqm->EditValue ?>"<?php echo $partner_product_ref->weight_sqm->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->weight_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_partner_product_ref_price" for="x_price" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->price->caption() ?><?php echo ($partner_product_ref->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->price->cellAttributes() ?>>
<span id="el_partner_product_ref_price">
<input type="text" data-table="partner_product_ref" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->price->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->price->EditValue ?>"<?php echo $partner_product_ref->price->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->price_cs->Visible) { // price_cs ?>
	<div id="r_price_cs" class="form-group row">
		<label id="elh_partner_product_ref_price_cs" for="x_price_cs" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->price_cs->caption() ?><?php echo ($partner_product_ref->price_cs->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->price_cs->cellAttributes() ?>>
<span id="el_partner_product_ref_price_cs">
<input type="text" data-table="partner_product_ref" data-field="x_price_cs" name="x_price_cs" id="x_price_cs" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->price_cs->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->price_cs->EditValue ?>"<?php echo $partner_product_ref->price_cs->editAttributes() ?>>
</span>
<?php echo $partner_product_ref->price_cs->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_partner_product_ref_currency" for="x_currency" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->currency->caption() ?><?php echo ($partner_product_ref->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->currency->cellAttributes() ?>>
<span id="el_partner_product_ref_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_currency" data-value-separator="<?php echo $partner_product_ref->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $partner_product_ref->currency->editAttributes() ?>>
		<?php echo $partner_product_ref->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $partner_product_ref->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
<?php echo $partner_product_ref->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->hsn->Visible) { // hsn ?>
	<div id="r_hsn" class="form-group row">
		<label id="elh_partner_product_ref_hsn" for="x_hsn" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->hsn->caption() ?><?php echo ($partner_product_ref->hsn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->hsn->cellAttributes() ?>>
<span id="el_partner_product_ref_hsn">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_hsn" data-value-separator="<?php echo $partner_product_ref->hsn->displayValueSeparatorAttribute() ?>" id="x_hsn" name="x_hsn"<?php echo $partner_product_ref->hsn->editAttributes() ?>>
		<?php echo $partner_product_ref->hsn->selectOptionListHtml("x_hsn") ?>
	</select>
</div>
<?php echo $partner_product_ref->hsn->Lookup->getParamTag("p_x_hsn") ?>
</span>
<?php echo $partner_product_ref->hsn->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->composition->Visible) { // composition ?>
	<div id="r_composition" class="form-group row">
		<label id="elh_partner_product_ref_composition" for="x_composition" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->composition->caption() ?><?php echo ($partner_product_ref->composition->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->composition->cellAttributes() ?>>
<span id="el_partner_product_ref_composition">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_composition" data-value-separator="<?php echo $partner_product_ref->composition->displayValueSeparatorAttribute() ?>" id="x_composition" name="x_composition"<?php echo $partner_product_ref->composition->editAttributes() ?>>
		<?php echo $partner_product_ref->composition->selectOptionListHtml("x_composition") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "composition") && !$partner_product_ref->composition->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_composition" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $partner_product_ref->composition->caption() ?>" data-title="<?php echo $partner_product_ref->composition->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_composition',url:'compositionaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $partner_product_ref->composition->Lookup->getParamTag("p_x_composition") ?>
</span>
<?php echo $partner_product_ref->composition->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_partner_product_ref_status" for="x_status" class="<?php echo $partner_product_ref_edit->LeftColumnClass ?>"><?php echo $partner_product_ref->status->caption() ?><?php echo ($partner_product_ref->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_product_ref_edit->RightColumnClass ?>"><div<?php echo $partner_product_ref->status->cellAttributes() ?>>
<span id="el_partner_product_ref_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_status" data-value-separator="<?php echo $partner_product_ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $partner_product_ref->status->editAttributes() ?>>
		<?php echo $partner_product_ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $partner_product_ref->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$partner_product_ref_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $partner_product_ref_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $partner_product_ref_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$partner_product_ref_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");
// Write your table-specific startup script here
// document.write("page loaded");

		$.getJSON("apcajax.php?pdbyepass=9",function(data) {
		if (data == '2') {$("#r_batch_no").hide();}});
		var SGrp = $("#x_s_grp").val();
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
					if (data.calculation_method == '1') {
					$("#elh_partner_product_ref_price").html('Price / SQM');}
					else if (data.calculation_method == '11') {
					$("#elh_partner_product_ref_price").html('Price / SKU');}
					else if (data.calculation_method == '21') {
					$("#elh_partner_product_ref_price").html('Price / KG');}
			 		if (data.pc_shape == '--NA--') {
					$("#x_shape").val('');
					$("#r_shape").hide(); } else {
					$("#r_shape").show();}
			 		if (data.pc_unit == '--NA--') {
					$("#x_unit").val(1);
					$("#r_unit").hide(); } else {
					$("#r_unit").show();}			 		
					if (data.pc_w == '--NA--') {
					$("#x_w").val(0);
					$("#x_w_cm").val(0);
					$("#r_w").hide();					
					$("#r_w_cm").hide();
					} else {
					$("#r_w").show();
					$("#r_w_cm").show();}
					if (data.pc_l == '--NA--') {
					$("#x_l").val(0);
					$("#x_l_cm").val(0);
					$("#r_l").hide();					
					$("#r_l_cm").hide();
					} else {
					$("#r_l").show();
					$("#r_l_cm").show();}					
					if (data.pc_h == '--NA--') {
					$("#x_h").val(0);
					$("#x_h_cm").val(0);
					$("#r_h").hide();					
					$("#r_h_cm").hide();
					} else {
					$("#r_h").show();
					$("#r_h_cm").show();}
			 		if (data.pc_partner_size == '--NA--') {
					$("#x_partner_size").val('');
					$("#r_partner_size").hide(); } else {
					$("#r_partner_size").show();}
			 		if (data.pc_sqm == '--NA--') {
					$("#x_sqm").val(0);
					$("#r_sqm").hide(); } else {
					$("#r_sqm").show();}
			});
		}
</script>
<?php include_once "footer.php" ?>
<?php
$partner_product_ref_edit->terminate();
?>