<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_product_ref_list = new partner_product_ref_list();

// Run the page
$partner_product_ref_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_product_ref_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$partner_product_ref->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpartner_product_reflist = currentForm = new ew.Form("fpartner_product_reflist", "list");
fpartner_product_reflist.formKeyCountName = '<?php echo $partner_product_ref_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpartner_product_reflist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_product_reflist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_product_reflist.lists["x_partner_type"] = <?php echo $partner_product_ref_list->partner_type->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_partner_type"].options = <?php echo JsonEncode($partner_product_ref_list->partner_type->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_partner"] = <?php echo $partner_product_ref_list->partner->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_partner"].options = <?php echo JsonEncode($partner_product_ref_list->partner->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_product_type"] = <?php echo $partner_product_ref_list->product_type->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_product_type"].options = <?php echo JsonEncode($partner_product_ref_list->product_type->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_shape"] = <?php echo $partner_product_ref_list->shape->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_shape"].options = <?php echo JsonEncode($partner_product_ref_list->shape->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_grp"] = <?php echo $partner_product_ref_list->grp->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_grp"].options = <?php echo JsonEncode($partner_product_ref_list->grp->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_s_grp"] = <?php echo $partner_product_ref_list->s_grp->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_s_grp"].options = <?php echo JsonEncode($partner_product_ref_list->s_grp->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_product"] = <?php echo $partner_product_ref_list->product->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_product"].options = <?php echo JsonEncode($partner_product_ref_list->product->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_rid"] = <?php echo $partner_product_ref_list->rid->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_rid"].options = <?php echo JsonEncode($partner_product_ref_list->rid->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_packing_type"] = <?php echo $partner_product_ref_list->packing_type->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_packing_type"].options = <?php echo JsonEncode($partner_product_ref_list->packing_type->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_batch_no"] = <?php echo $partner_product_ref_list->batch_no->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_batch_no"].options = <?php echo JsonEncode($partner_product_ref_list->batch_no->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_unit"] = <?php echo $partner_product_ref_list->unit->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_unit"].options = <?php echo JsonEncode($partner_product_ref_list->unit->options(FALSE, TRUE)) ?>;
fpartner_product_reflist.lists["x_currency"] = <?php echo $partner_product_ref_list->currency->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_currency"].options = <?php echo JsonEncode($partner_product_ref_list->currency->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_hsn"] = <?php echo $partner_product_ref_list->hsn->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_hsn"].options = <?php echo JsonEncode($partner_product_ref_list->hsn->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_composition"] = <?php echo $partner_product_ref_list->composition->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_composition"].options = <?php echo JsonEncode($partner_product_ref_list->composition->lookupOptions()) ?>;
fpartner_product_reflist.lists["x_status"] = <?php echo $partner_product_ref_list->status->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_status"].options = <?php echo JsonEncode($partner_product_ref_list->status->options(FALSE, TRUE)) ?>;
fpartner_product_reflist.lists["x_operator"] = <?php echo $partner_product_ref_list->operator->Lookup->toClientList() ?>;
fpartner_product_reflist.lists["x_operator"].options = <?php echo JsonEncode($partner_product_ref_list->operator->lookupOptions()) ?>;

// Form object for search
var fpartner_product_reflistsrch = currentSearchForm = new ew.Form("fpartner_product_reflistsrch");

// Validate function for search
fpartner_product_reflistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->price->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpartner_product_reflistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_product_reflistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_product_reflistsrch.lists["x_partner_type"] = <?php echo $partner_product_ref_list->partner_type->Lookup->toClientList() ?>;
fpartner_product_reflistsrch.lists["x_partner_type"].options = <?php echo JsonEncode($partner_product_ref_list->partner_type->lookupOptions()) ?>;
fpartner_product_reflistsrch.lists["x_partner"] = <?php echo $partner_product_ref_list->partner->Lookup->toClientList() ?>;
fpartner_product_reflistsrch.lists["x_partner"].options = <?php echo JsonEncode($partner_product_ref_list->partner->lookupOptions()) ?>;
fpartner_product_reflistsrch.lists["x_status"] = <?php echo $partner_product_ref_list->status->Lookup->toClientList() ?>;
fpartner_product_reflistsrch.lists["x_status"].options = <?php echo JsonEncode($partner_product_ref_list->status->options(FALSE, TRUE)) ?>;

// Filters
fpartner_product_reflistsrch.filterList = <?php echo $partner_product_ref_list->getFilterList() ?>;

// Init search panel as collapsed
fpartner_product_reflistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$partner_product_ref->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($partner_product_ref_list->TotalRecs > 0 && $partner_product_ref_list->ExportOptions->visible()) { ?>
<?php $partner_product_ref_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_product_ref_list->ImportOptions->visible()) { ?>
<?php $partner_product_ref_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_product_ref_list->SearchOptions->visible()) { ?>
<?php $partner_product_ref_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($partner_product_ref_list->FilterOptions->visible()) { ?>
<?php $partner_product_ref_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$partner_product_ref->isExport() || EXPORT_MASTER_RECORD && $partner_product_ref->isExport("print")) { ?>
<?php
if ($partner_product_ref_list->DbMasterFilter <> "" && $partner_product_ref->getCurrentMasterTable() == "ref") {
	if ($partner_product_ref_list->MasterRecordExists) {
		include_once "refmaster.php";
	}
}
?>
<?php } ?>
<?php
$partner_product_ref_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$partner_product_ref->isExport() && !$partner_product_ref->CurrentAction) { ?>
<form name="fpartner_product_reflistsrch" id="fpartner_product_reflistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($partner_product_ref_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpartner_product_reflistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="partner_product_ref">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$partner_product_ref_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$partner_product_ref->RowType = ROWTYPE_SEARCH;

// Render row
$partner_product_ref->resetAttributes();
$partner_product_ref_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($partner_product_ref->partner_type->Visible) { // partner_type ?>
	<div id="xsc_partner_type" class="ew-cell form-group">
		<label for="x_partner_type" class="ew-search-caption ew-label"><?php echo $partner_product_ref->partner_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_type" id="z_partner_type" value="="></span>
		<span class="ew-search-field">
<?php $partner_product_ref->partner_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->partner_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_partner_type" data-value-separator="<?php echo $partner_product_ref->partner_type->displayValueSeparatorAttribute() ?>" id="x_partner_type" name="x_partner_type"<?php echo $partner_product_ref->partner_type->editAttributes() ?>>
		<?php echo $partner_product_ref->partner_type->selectOptionListHtml("x_partner_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->partner_type->Lookup->getParamTag("p_x_partner_type") ?>
</span>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner->Visible) { // partner ?>
	<div id="xsc_partner" class="ew-cell form-group">
		<label for="x_partner" class="ew-search-caption ew-label"><?php echo $partner_product_ref->partner->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner" id="z_partner" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_partner" data-value-separator="<?php echo $partner_product_ref->partner->displayValueSeparatorAttribute() ?>" id="x_partner" name="x_partner"<?php echo $partner_product_ref->partner->editAttributes() ?>>
		<?php echo $partner_product_ref->partner->selectOptionListHtml("x_partner") ?>
	</select>
</div>
<?php echo $partner_product_ref->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
	</div>
<?php } ?>
<?php if ($partner_product_ref->price->Visible) { // price ?>
	<div id="xsc_price" class="ew-cell form-group">
		<label for="x_price" class="ew-search-caption ew-label"><?php echo $partner_product_ref->price->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="partner_product_ref" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->price->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->price->EditValue ?>"<?php echo $partner_product_ref->price->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($partner_product_ref->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $partner_product_ref->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_status" data-value-separator="<?php echo $partner_product_ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $partner_product_ref->status->editAttributes() ?>>
		<?php echo $partner_product_ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($partner_product_ref_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($partner_product_ref_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $partner_product_ref_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($partner_product_ref_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($partner_product_ref_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($partner_product_ref_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($partner_product_ref_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $partner_product_ref_list->showPageHeader(); ?>
<?php
$partner_product_ref_list->showMessage();
?>
<?php if ($partner_product_ref_list->TotalRecs > 0 || $partner_product_ref->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($partner_product_ref_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> partner_product_ref">
<?php if (!$partner_product_ref->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$partner_product_ref->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_product_ref_list->Pager)) $partner_product_ref_list->Pager = new PrevNextPager($partner_product_ref_list->StartRec, $partner_product_ref_list->DisplayRecs, $partner_product_ref_list->TotalRecs, $partner_product_ref_list->AutoHidePager) ?>
<?php if ($partner_product_ref_list->Pager->RecordCount > 0 && $partner_product_ref_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_product_ref_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_product_ref_list->pageUrl() ?>start=<?php echo $partner_product_ref_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_product_ref_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_product_ref_list->pageUrl() ?>start=<?php echo $partner_product_ref_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_product_ref_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_product_ref_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_product_ref_list->pageUrl() ?>start=<?php echo $partner_product_ref_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_product_ref_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_product_ref_list->pageUrl() ?>start=<?php echo $partner_product_ref_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_product_ref_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_product_ref_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_product_ref_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_product_ref_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_product_ref_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_product_ref_list->TotalRecs > 0 && (!$partner_product_ref_list->AutoHidePageSizeSelector || $partner_product_ref_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_product_ref">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_product_ref_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_product_ref_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_product_ref_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_product_ref_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_product_ref_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_product_ref->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_product_ref_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpartner_product_reflist" id="fpartner_product_reflist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_product_ref_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_product_ref_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_product_ref">
<?php if ($partner_product_ref->getCurrentMasterTable() == "ref" && $partner_product_ref->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="ref">
<input type="hidden" name="fk_id" value="<?php echo $partner_product_ref->rid->getSessionValue() ?>">
<?php } ?>
<div id="gmp_partner_product_ref" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($partner_product_ref_list->TotalRecs > 0 || $partner_product_ref->isGridEdit()) { ?>
<table id="tbl_partner_product_reflist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$partner_product_ref_list->RowType = ROWTYPE_HEADER;

// Render list options
$partner_product_ref_list->renderListOptions();

// Render list options (header, left)
$partner_product_ref_list->ListOptions->render("header", "left");
?>
<?php if ($partner_product_ref->id->Visible) { // id ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->id) == "") { ?>
		<th data-name="id" class="<?php echo $partner_product_ref->id->headerCellClass() ?>"><div id="elh_partner_product_ref_id" class="partner_product_ref_id"><div class="ew-table-header-caption"><?php echo $partner_product_ref->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $partner_product_ref->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->id) ?>',2);"><div id="elh_partner_product_ref_id" class="partner_product_ref_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner_type->Visible) { // partner_type ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->partner_type) == "") { ?>
		<th data-name="partner_type" class="<?php echo $partner_product_ref->partner_type->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_type" class="partner_product_ref_partner_type"><div class="ew-table-header-caption"><?php echo $partner_product_ref->partner_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_type" class="<?php echo $partner_product_ref->partner_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->partner_type) ?>',2);"><div id="elh_partner_product_ref_partner_type" class="partner_product_ref_partner_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->partner_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->partner_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner->Visible) { // partner ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->partner) == "") { ?>
		<th data-name="partner" class="<?php echo $partner_product_ref->partner->headerCellClass() ?>"><div id="elh_partner_product_ref_partner" class="partner_product_ref_partner"><div class="ew-table-header-caption"><?php echo $partner_product_ref->partner->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner" class="<?php echo $partner_product_ref->partner->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->partner) ?>',2);"><div id="elh_partner_product_ref_partner" class="partner_product_ref_partner">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->partner->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->partner->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner_ref->Visible) { // partner_ref ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->partner_ref) == "") { ?>
		<th data-name="partner_ref" class="<?php echo $partner_product_ref->partner_ref->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_ref" class="partner_product_ref_partner_ref"><div class="ew-table-header-caption"><?php echo $partner_product_ref->partner_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_ref" class="<?php echo $partner_product_ref->partner_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->partner_ref) ?>',2);"><div id="elh_partner_product_ref_partner_ref" class="partner_product_ref_partner_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->partner_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->partner_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->_barcode->Visible) { // barcode ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $partner_product_ref->_barcode->headerCellClass() ?>"><div id="elh_partner_product_ref__barcode" class="partner_product_ref__barcode"><div class="ew-table-header-caption"><?php echo $partner_product_ref->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $partner_product_ref->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->_barcode) ?>',2);"><div id="elh_partner_product_ref__barcode" class="partner_product_ref__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner_code->Visible) { // partner_code ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->partner_code) == "") { ?>
		<th data-name="partner_code" class="<?php echo $partner_product_ref->partner_code->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_code" class="partner_product_ref_partner_code"><div class="ew-table-header-caption"><?php echo $partner_product_ref->partner_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_code" class="<?php echo $partner_product_ref->partner_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->partner_code) ?>',2);"><div id="elh_partner_product_ref_partner_code" class="partner_product_ref_partner_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->partner_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->partner_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->product_type->Visible) { // product_type ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $partner_product_ref->product_type->headerCellClass() ?>"><div id="elh_partner_product_ref_product_type" class="partner_product_ref_product_type"><div class="ew-table-header-caption"><?php echo $partner_product_ref->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $partner_product_ref->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->product_type) ?>',2);"><div id="elh_partner_product_ref_product_type" class="partner_product_ref_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->shape->Visible) { // shape ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $partner_product_ref->shape->headerCellClass() ?>"><div id="elh_partner_product_ref_shape" class="partner_product_ref_shape"><div class="ew-table-header-caption"><?php echo $partner_product_ref->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $partner_product_ref->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->shape) ?>',2);"><div id="elh_partner_product_ref_shape" class="partner_product_ref_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->grp->Visible) { // grp ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $partner_product_ref->grp->headerCellClass() ?>"><div id="elh_partner_product_ref_grp" class="partner_product_ref_grp"><div class="ew-table-header-caption"><?php echo $partner_product_ref->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $partner_product_ref->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->grp) ?>',2);"><div id="elh_partner_product_ref_grp" class="partner_product_ref_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->s_grp->Visible) { // s_grp ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $partner_product_ref->s_grp->headerCellClass() ?>"><div id="elh_partner_product_ref_s_grp" class="partner_product_ref_s_grp"><div class="ew-table-header-caption"><?php echo $partner_product_ref->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $partner_product_ref->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->s_grp) ?>',2);"><div id="elh_partner_product_ref_s_grp" class="partner_product_ref_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->product->Visible) { // product ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->product) == "") { ?>
		<th data-name="product" class="<?php echo $partner_product_ref->product->headerCellClass() ?>"><div id="elh_partner_product_ref_product" class="partner_product_ref_product"><div class="ew-table-header-caption"><?php echo $partner_product_ref->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $partner_product_ref->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->product) ?>',2);"><div id="elh_partner_product_ref_product" class="partner_product_ref_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->rid->Visible) { // rid ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $partner_product_ref->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_partner_product_ref_rid" class="partner_product_ref_rid"><div class="ew-table-header-caption"><?php echo $partner_product_ref->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $partner_product_ref->rid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->rid) ?>',2);"><div id="elh_partner_product_ref_rid" class="partner_product_ref_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->spl_ins->Visible) { // spl_ins ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->spl_ins) == "") { ?>
		<th data-name="spl_ins" class="<?php echo $partner_product_ref->spl_ins->headerCellClass() ?>"><div id="elh_partner_product_ref_spl_ins" class="partner_product_ref_spl_ins"><div class="ew-table-header-caption"><?php echo $partner_product_ref->spl_ins->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="spl_ins" class="<?php echo $partner_product_ref->spl_ins->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->spl_ins) ?>',2);"><div id="elh_partner_product_ref_spl_ins" class="partner_product_ref_spl_ins">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->spl_ins->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->spl_ins->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->spl_ins->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->packing_type->Visible) { // packing_type ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $partner_product_ref->packing_type->headerCellClass() ?>"><div id="elh_partner_product_ref_packing_type" class="partner_product_ref_packing_type"><div class="ew-table-header-caption"><?php echo $partner_product_ref->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $partner_product_ref->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->packing_type) ?>',2);"><div id="elh_partner_product_ref_packing_type" class="partner_product_ref_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->batch_no->Visible) { // batch_no ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $partner_product_ref->batch_no->headerCellClass() ?>"><div id="elh_partner_product_ref_batch_no" class="partner_product_ref_batch_no"><div class="ew-table-header-caption"><?php echo $partner_product_ref->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $partner_product_ref->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->batch_no) ?>',2);"><div id="elh_partner_product_ref_batch_no" class="partner_product_ref_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->unit->Visible) { // unit ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $partner_product_ref->unit->headerCellClass() ?>"><div id="elh_partner_product_ref_unit" class="partner_product_ref_unit"><div class="ew-table-header-caption"><?php echo $partner_product_ref->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $partner_product_ref->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->unit) ?>',2);"><div id="elh_partner_product_ref_unit" class="partner_product_ref_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->w->Visible) { // w ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->w) == "") { ?>
		<th data-name="w" class="<?php echo $partner_product_ref->w->headerCellClass() ?>"><div id="elh_partner_product_ref_w" class="partner_product_ref_w"><div class="ew-table-header-caption"><?php echo $partner_product_ref->w->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w" class="<?php echo $partner_product_ref->w->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->w) ?>',2);"><div id="elh_partner_product_ref_w" class="partner_product_ref_w">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->w->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->w->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->w->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->w_cm->Visible) { // w_cm ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->w_cm) == "") { ?>
		<th data-name="w_cm" class="<?php echo $partner_product_ref->w_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_w_cm" class="partner_product_ref_w_cm"><div class="ew-table-header-caption"><?php echo $partner_product_ref->w_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="w_cm" class="<?php echo $partner_product_ref->w_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->w_cm) ?>',2);"><div id="elh_partner_product_ref_w_cm" class="partner_product_ref_w_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->w_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->w_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->w_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->l->Visible) { // l ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->l) == "") { ?>
		<th data-name="l" class="<?php echo $partner_product_ref->l->headerCellClass() ?>"><div id="elh_partner_product_ref_l" class="partner_product_ref_l"><div class="ew-table-header-caption"><?php echo $partner_product_ref->l->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l" class="<?php echo $partner_product_ref->l->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->l) ?>',2);"><div id="elh_partner_product_ref_l" class="partner_product_ref_l">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->l->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->l->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->l->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->l_cm->Visible) { // l_cm ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->l_cm) == "") { ?>
		<th data-name="l_cm" class="<?php echo $partner_product_ref->l_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_l_cm" class="partner_product_ref_l_cm"><div class="ew-table-header-caption"><?php echo $partner_product_ref->l_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="l_cm" class="<?php echo $partner_product_ref->l_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->l_cm) ?>',2);"><div id="elh_partner_product_ref_l_cm" class="partner_product_ref_l_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->l_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->l_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->l_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->h->Visible) { // h ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->h) == "") { ?>
		<th data-name="h" class="<?php echo $partner_product_ref->h->headerCellClass() ?>"><div id="elh_partner_product_ref_h" class="partner_product_ref_h"><div class="ew-table-header-caption"><?php echo $partner_product_ref->h->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="h" class="<?php echo $partner_product_ref->h->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->h) ?>',2);"><div id="elh_partner_product_ref_h" class="partner_product_ref_h">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->h->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->h->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->h->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->h_cm->Visible) { // h_cm ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->h_cm) == "") { ?>
		<th data-name="h_cm" class="<?php echo $partner_product_ref->h_cm->headerCellClass() ?>"><div id="elh_partner_product_ref_h_cm" class="partner_product_ref_h_cm"><div class="ew-table-header-caption"><?php echo $partner_product_ref->h_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="h_cm" class="<?php echo $partner_product_ref->h_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->h_cm) ?>',2);"><div id="elh_partner_product_ref_h_cm" class="partner_product_ref_h_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->h_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->h_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->h_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner_size->Visible) { // partner_size ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->partner_size) == "") { ?>
		<th data-name="partner_size" class="<?php echo $partner_product_ref->partner_size->headerCellClass() ?>"><div id="elh_partner_product_ref_partner_size" class="partner_product_ref_partner_size"><div class="ew-table-header-caption"><?php echo $partner_product_ref->partner_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_size" class="<?php echo $partner_product_ref->partner_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->partner_size) ?>',2);"><div id="elh_partner_product_ref_partner_size" class="partner_product_ref_partner_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->partner_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->partner_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->sqm->Visible) { // sqm ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $partner_product_ref->sqm->headerCellClass() ?>"><div id="elh_partner_product_ref_sqm" class="partner_product_ref_sqm"><div class="ew-table-header-caption"><?php echo $partner_product_ref->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $partner_product_ref->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->sqm) ?>',2);"><div id="elh_partner_product_ref_sqm" class="partner_product_ref_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->cbm->Visible) { // cbm ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $partner_product_ref->cbm->headerCellClass() ?>"><div id="elh_partner_product_ref_cbm" class="partner_product_ref_cbm"><div class="ew-table-header-caption"><?php echo $partner_product_ref->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $partner_product_ref->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->cbm) ?>',2);"><div id="elh_partner_product_ref_cbm" class="partner_product_ref_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->cbm->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->weight_sqm->Visible) { // weight_sqm ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->weight_sqm) == "") { ?>
		<th data-name="weight_sqm" class="<?php echo $partner_product_ref->weight_sqm->headerCellClass() ?>"><div id="elh_partner_product_ref_weight_sqm" class="partner_product_ref_weight_sqm"><div class="ew-table-header-caption"><?php echo $partner_product_ref->weight_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight_sqm" class="<?php echo $partner_product_ref->weight_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->weight_sqm) ?>',2);"><div id="elh_partner_product_ref_weight_sqm" class="partner_product_ref_weight_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->weight_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->weight_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->weight_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->price->Visible) { // price ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->price) == "") { ?>
		<th data-name="price" class="<?php echo $partner_product_ref->price->headerCellClass() ?>"><div id="elh_partner_product_ref_price" class="partner_product_ref_price"><div class="ew-table-header-caption"><?php echo $partner_product_ref->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $partner_product_ref->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->price) ?>',2);"><div id="elh_partner_product_ref_price" class="partner_product_ref_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->price_cs->Visible) { // price_cs ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->price_cs) == "") { ?>
		<th data-name="price_cs" class="<?php echo $partner_product_ref->price_cs->headerCellClass() ?>"><div id="elh_partner_product_ref_price_cs" class="partner_product_ref_price_cs"><div class="ew-table-header-caption"><?php echo $partner_product_ref->price_cs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_cs" class="<?php echo $partner_product_ref->price_cs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->price_cs) ?>',2);"><div id="elh_partner_product_ref_price_cs" class="partner_product_ref_price_cs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->price_cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->price_cs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->price_cs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->currency->Visible) { // currency ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $partner_product_ref->currency->headerCellClass() ?>"><div id="elh_partner_product_ref_currency" class="partner_product_ref_currency"><div class="ew-table-header-caption"><?php echo $partner_product_ref->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $partner_product_ref->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->currency) ?>',2);"><div id="elh_partner_product_ref_currency" class="partner_product_ref_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->hsn->Visible) { // hsn ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->hsn) == "") { ?>
		<th data-name="hsn" class="<?php echo $partner_product_ref->hsn->headerCellClass() ?>"><div id="elh_partner_product_ref_hsn" class="partner_product_ref_hsn"><div class="ew-table-header-caption"><?php echo $partner_product_ref->hsn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="hsn" class="<?php echo $partner_product_ref->hsn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->hsn) ?>',2);"><div id="elh_partner_product_ref_hsn" class="partner_product_ref_hsn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->hsn->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->hsn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->hsn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->composition->Visible) { // composition ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->composition) == "") { ?>
		<th data-name="composition" class="<?php echo $partner_product_ref->composition->headerCellClass() ?>"><div id="elh_partner_product_ref_composition" class="partner_product_ref_composition"><div class="ew-table-header-caption"><?php echo $partner_product_ref->composition->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="composition" class="<?php echo $partner_product_ref->composition->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->composition) ?>',2);"><div id="elh_partner_product_ref_composition" class="partner_product_ref_composition">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->composition->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->composition->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->composition->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->status->Visible) { // status ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->status) == "") { ?>
		<th data-name="status" class="<?php echo $partner_product_ref->status->headerCellClass() ?>"><div id="elh_partner_product_ref_status" class="partner_product_ref_status"><div class="ew-table-header-caption"><?php echo $partner_product_ref->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $partner_product_ref->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->status) ?>',2);"><div id="elh_partner_product_ref_status" class="partner_product_ref_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->operator->Visible) { // operator ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $partner_product_ref->operator->headerCellClass() ?>"><div id="elh_partner_product_ref_operator" class="partner_product_ref_operator"><div class="ew-table-header-caption"><?php echo $partner_product_ref->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $partner_product_ref->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->operator) ?>',2);"><div id="elh_partner_product_ref_operator" class="partner_product_ref_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->datetime->Visible) { // datetime ?>
	<?php if ($partner_product_ref->sortUrl($partner_product_ref->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $partner_product_ref->datetime->headerCellClass() ?>"><div id="elh_partner_product_ref_datetime" class="partner_product_ref_datetime"><div class="ew-table-header-caption"><?php echo $partner_product_ref->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $partner_product_ref->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_product_ref->SortUrl($partner_product_ref->datetime) ?>',2);"><div id="elh_partner_product_ref_datetime" class="partner_product_ref_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$partner_product_ref_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($partner_product_ref->ExportAll && $partner_product_ref->isExport()) {
	$partner_product_ref_list->StopRec = $partner_product_ref_list->TotalRecs;
} else {

	// Set the last record to display
	if ($partner_product_ref_list->TotalRecs > $partner_product_ref_list->StartRec + $partner_product_ref_list->DisplayRecs - 1)
		$partner_product_ref_list->StopRec = $partner_product_ref_list->StartRec + $partner_product_ref_list->DisplayRecs - 1;
	else
		$partner_product_ref_list->StopRec = $partner_product_ref_list->TotalRecs;
}
$partner_product_ref_list->RecCnt = $partner_product_ref_list->StartRec - 1;
if ($partner_product_ref_list->Recordset && !$partner_product_ref_list->Recordset->EOF) {
	$partner_product_ref_list->Recordset->moveFirst();
	$selectLimit = $partner_product_ref_list->UseSelectLimit;
	if (!$selectLimit && $partner_product_ref_list->StartRec > 1)
		$partner_product_ref_list->Recordset->move($partner_product_ref_list->StartRec - 1);
} elseif (!$partner_product_ref->AllowAddDeleteRow && $partner_product_ref_list->StopRec == 0) {
	$partner_product_ref_list->StopRec = $partner_product_ref->GridAddRowCount;
}

// Initialize aggregate
$partner_product_ref->RowType = ROWTYPE_AGGREGATEINIT;
$partner_product_ref->resetAttributes();
$partner_product_ref_list->renderRow();
while ($partner_product_ref_list->RecCnt < $partner_product_ref_list->StopRec) {
	$partner_product_ref_list->RecCnt++;
	if ($partner_product_ref_list->RecCnt >= $partner_product_ref_list->StartRec) {
		$partner_product_ref_list->RowCnt++;

		// Set up key count
		$partner_product_ref_list->KeyCount = $partner_product_ref_list->RowIndex;

		// Init row class and style
		$partner_product_ref->resetAttributes();
		$partner_product_ref->CssClass = "";
		if ($partner_product_ref->isGridAdd()) {
		} else {
			$partner_product_ref_list->loadRowValues($partner_product_ref_list->Recordset); // Load row values
		}
		$partner_product_ref->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$partner_product_ref->RowAttrs = array_merge($partner_product_ref->RowAttrs, array('data-rowindex'=>$partner_product_ref_list->RowCnt, 'id'=>'r' . $partner_product_ref_list->RowCnt . '_partner_product_ref', 'data-rowtype'=>$partner_product_ref->RowType));

		// Render row
		$partner_product_ref_list->renderRow();

		// Render list options
		$partner_product_ref_list->renderListOptions();
?>
	<tr<?php echo $partner_product_ref->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_product_ref_list->ListOptions->render("body", "left", $partner_product_ref_list->RowCnt);
?>
	<?php if ($partner_product_ref->id->Visible) { // id ?>
		<td data-name="id"<?php echo $partner_product_ref->id->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_id" class="partner_product_ref_id">
<span<?php echo $partner_product_ref->id->viewAttributes() ?>>
<?php echo $partner_product_ref->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->partner_type->Visible) { // partner_type ?>
		<td data-name="partner_type"<?php echo $partner_product_ref->partner_type->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_partner_type" class="partner_product_ref_partner_type">
<span<?php echo $partner_product_ref->partner_type->viewAttributes() ?>>
<?php echo $partner_product_ref->partner_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->partner->Visible) { // partner ?>
		<td data-name="partner"<?php echo $partner_product_ref->partner->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_partner" class="partner_product_ref_partner">
<span<?php echo $partner_product_ref->partner->viewAttributes() ?>>
<?php echo $partner_product_ref->partner->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->partner_ref->Visible) { // partner_ref ?>
		<td data-name="partner_ref"<?php echo $partner_product_ref->partner_ref->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_partner_ref" class="partner_product_ref_partner_ref">
<span<?php echo $partner_product_ref->partner_ref->viewAttributes() ?>>
<?php echo $partner_product_ref->partner_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $partner_product_ref->_barcode->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref__barcode" class="partner_product_ref__barcode">
<span<?php echo $partner_product_ref->_barcode->viewAttributes() ?>>
<?php echo $partner_product_ref->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->partner_code->Visible) { // partner_code ?>
		<td data-name="partner_code"<?php echo $partner_product_ref->partner_code->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_partner_code" class="partner_product_ref_partner_code">
<span<?php echo $partner_product_ref->partner_code->viewAttributes() ?>>
<?php echo $partner_product_ref->partner_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $partner_product_ref->product_type->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_product_type" class="partner_product_ref_product_type">
<span<?php echo $partner_product_ref->product_type->viewAttributes() ?>>
<?php echo $partner_product_ref->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $partner_product_ref->shape->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_shape" class="partner_product_ref_shape">
<span<?php echo $partner_product_ref->shape->viewAttributes() ?>>
<?php echo $partner_product_ref->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $partner_product_ref->grp->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_grp" class="partner_product_ref_grp">
<span<?php echo $partner_product_ref->grp->viewAttributes() ?>>
<?php if ((!EmptyString($partner_product_ref->grp->getViewValue())) && $partner_product_ref->grp->linkAttributes() <> "") { ?>
<a<?php echo $partner_product_ref->grp->linkAttributes() ?>><?php echo $partner_product_ref->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_product_ref->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $partner_product_ref->s_grp->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_s_grp" class="partner_product_ref_s_grp">
<span<?php echo $partner_product_ref->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($partner_product_ref->s_grp->getViewValue())) && $partner_product_ref->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $partner_product_ref->s_grp->linkAttributes() ?>><?php echo $partner_product_ref->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_product_ref->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->product->Visible) { // product ?>
		<td data-name="product"<?php echo $partner_product_ref->product->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_product" class="partner_product_ref_product">
<span<?php echo $partner_product_ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($partner_product_ref->product->getViewValue())) && $partner_product_ref->product->linkAttributes() <> "") { ?>
<a<?php echo $partner_product_ref->product->linkAttributes() ?>><?php echo $partner_product_ref->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_product_ref->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $partner_product_ref->rid->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_rid" class="partner_product_ref_rid">
<span<?php echo $partner_product_ref->rid->viewAttributes() ?>>
<?php echo $partner_product_ref->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->spl_ins->Visible) { // spl_ins ?>
		<td data-name="spl_ins"<?php echo $partner_product_ref->spl_ins->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_spl_ins" class="partner_product_ref_spl_ins">
<span<?php echo $partner_product_ref->spl_ins->viewAttributes() ?>>
<?php echo $partner_product_ref->spl_ins->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $partner_product_ref->packing_type->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_packing_type" class="partner_product_ref_packing_type">
<span<?php echo $partner_product_ref->packing_type->viewAttributes() ?>>
<?php echo $partner_product_ref->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $partner_product_ref->batch_no->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_batch_no" class="partner_product_ref_batch_no">
<span<?php echo $partner_product_ref->batch_no->viewAttributes() ?>>
<?php echo $partner_product_ref->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $partner_product_ref->unit->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_unit" class="partner_product_ref_unit">
<span<?php echo $partner_product_ref->unit->viewAttributes() ?>>
<?php if ((!EmptyString($partner_product_ref->unit->getViewValue())) && $partner_product_ref->unit->linkAttributes() <> "") { ?>
<a<?php echo $partner_product_ref->unit->linkAttributes() ?>><?php echo $partner_product_ref->unit->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_product_ref->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->w->Visible) { // w ?>
		<td data-name="w"<?php echo $partner_product_ref->w->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_w" class="partner_product_ref_w">
<span<?php echo $partner_product_ref->w->viewAttributes() ?>>
<?php echo $partner_product_ref->w->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->w_cm->Visible) { // w_cm ?>
		<td data-name="w_cm"<?php echo $partner_product_ref->w_cm->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_w_cm" class="partner_product_ref_w_cm">
<span<?php echo $partner_product_ref->w_cm->viewAttributes() ?>>
<?php echo $partner_product_ref->w_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->l->Visible) { // l ?>
		<td data-name="l"<?php echo $partner_product_ref->l->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_l" class="partner_product_ref_l">
<span<?php echo $partner_product_ref->l->viewAttributes() ?>>
<?php echo $partner_product_ref->l->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->l_cm->Visible) { // l_cm ?>
		<td data-name="l_cm"<?php echo $partner_product_ref->l_cm->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_l_cm" class="partner_product_ref_l_cm">
<span<?php echo $partner_product_ref->l_cm->viewAttributes() ?>>
<?php echo $partner_product_ref->l_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->h->Visible) { // h ?>
		<td data-name="h"<?php echo $partner_product_ref->h->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_h" class="partner_product_ref_h">
<span<?php echo $partner_product_ref->h->viewAttributes() ?>>
<?php echo $partner_product_ref->h->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->h_cm->Visible) { // h_cm ?>
		<td data-name="h_cm"<?php echo $partner_product_ref->h_cm->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_h_cm" class="partner_product_ref_h_cm">
<span<?php echo $partner_product_ref->h_cm->viewAttributes() ?>>
<?php echo $partner_product_ref->h_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->partner_size->Visible) { // partner_size ?>
		<td data-name="partner_size"<?php echo $partner_product_ref->partner_size->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_partner_size" class="partner_product_ref_partner_size">
<span<?php echo $partner_product_ref->partner_size->viewAttributes() ?>>
<?php echo $partner_product_ref->partner_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $partner_product_ref->sqm->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_sqm" class="partner_product_ref_sqm">
<span<?php echo $partner_product_ref->sqm->viewAttributes() ?>>
<?php echo $partner_product_ref->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $partner_product_ref->cbm->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_cbm" class="partner_product_ref_cbm">
<span<?php echo $partner_product_ref->cbm->viewAttributes() ?>>
<?php echo $partner_product_ref->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->weight_sqm->Visible) { // weight_sqm ?>
		<td data-name="weight_sqm"<?php echo $partner_product_ref->weight_sqm->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_weight_sqm" class="partner_product_ref_weight_sqm">
<span<?php echo $partner_product_ref->weight_sqm->viewAttributes() ?>>
<?php echo $partner_product_ref->weight_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->price->Visible) { // price ?>
		<td data-name="price"<?php echo $partner_product_ref->price->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_price" class="partner_product_ref_price">
<span<?php echo $partner_product_ref->price->viewAttributes() ?>>
<?php echo $partner_product_ref->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->price_cs->Visible) { // price_cs ?>
		<td data-name="price_cs"<?php echo $partner_product_ref->price_cs->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_price_cs" class="partner_product_ref_price_cs">
<span<?php echo $partner_product_ref->price_cs->viewAttributes() ?>>
<?php echo $partner_product_ref->price_cs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $partner_product_ref->currency->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_currency" class="partner_product_ref_currency">
<span<?php echo $partner_product_ref->currency->viewAttributes() ?>>
<?php echo $partner_product_ref->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->hsn->Visible) { // hsn ?>
		<td data-name="hsn"<?php echo $partner_product_ref->hsn->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_hsn" class="partner_product_ref_hsn">
<span<?php echo $partner_product_ref->hsn->viewAttributes() ?>>
<?php echo $partner_product_ref->hsn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->composition->Visible) { // composition ?>
		<td data-name="composition"<?php echo $partner_product_ref->composition->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_composition" class="partner_product_ref_composition">
<span<?php echo $partner_product_ref->composition->viewAttributes() ?>>
<?php echo $partner_product_ref->composition->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->status->Visible) { // status ?>
		<td data-name="status"<?php echo $partner_product_ref->status->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_status" class="partner_product_ref_status">
<span<?php echo $partner_product_ref->status->viewAttributes() ?>>
<?php echo $partner_product_ref->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $partner_product_ref->operator->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_operator" class="partner_product_ref_operator">
<span<?php echo $partner_product_ref->operator->viewAttributes() ?>>
<?php echo $partner_product_ref->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_product_ref->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $partner_product_ref->datetime->cellAttributes() ?>>
<span id="el<?php echo $partner_product_ref_list->RowCnt ?>_partner_product_ref_datetime" class="partner_product_ref_datetime">
<span<?php echo $partner_product_ref->datetime->viewAttributes() ?>>
<?php echo $partner_product_ref->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$partner_product_ref_list->ListOptions->render("body", "right", $partner_product_ref_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$partner_product_ref->isGridAdd())
		$partner_product_ref_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$partner_product_ref->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($partner_product_ref_list->Recordset)
	$partner_product_ref_list->Recordset->Close();
?>
<?php if (!$partner_product_ref->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$partner_product_ref->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_product_ref_list->Pager)) $partner_product_ref_list->Pager = new PrevNextPager($partner_product_ref_list->StartRec, $partner_product_ref_list->DisplayRecs, $partner_product_ref_list->TotalRecs, $partner_product_ref_list->AutoHidePager) ?>
<?php if ($partner_product_ref_list->Pager->RecordCount > 0 && $partner_product_ref_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_product_ref_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_product_ref_list->pageUrl() ?>start=<?php echo $partner_product_ref_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_product_ref_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_product_ref_list->pageUrl() ?>start=<?php echo $partner_product_ref_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_product_ref_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_product_ref_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_product_ref_list->pageUrl() ?>start=<?php echo $partner_product_ref_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_product_ref_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_product_ref_list->pageUrl() ?>start=<?php echo $partner_product_ref_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_product_ref_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_product_ref_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_product_ref_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_product_ref_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_product_ref_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_product_ref_list->TotalRecs > 0 && (!$partner_product_ref_list->AutoHidePageSizeSelector || $partner_product_ref_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_product_ref">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_product_ref_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_product_ref_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_product_ref_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_product_ref_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_product_ref_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_product_ref->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_product_ref_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($partner_product_ref_list->TotalRecs == 0 && !$partner_product_ref->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $partner_product_ref_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$partner_product_ref_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$partner_product_ref->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$partner_product_ref->isExport()) { ?>
<script>
ew.scrollableTable("gmp_partner_product_ref", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$partner_product_ref_list->terminate();
?>