<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$partner_product_ref_preview = new partner_product_ref_preview();

// Run the page
$partner_product_ref_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_product_ref_preview->Page_Render();
?>
<?php $partner_product_ref_preview->showPageHeader(); ?>
<div class="card ew-grid partner_product_ref"><!-- .card -->
<?php if ($partner_product_ref_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$partner_product_ref_preview->renderListOptions();

// Render list options (header, left)
$partner_product_ref_preview->ListOptions->render("header", "left");
?>
<?php if ($partner_product_ref->id->Visible) { // id ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->id) == "") { ?>
		<th class="<?php echo $partner_product_ref->id->headerCellClass() ?>"><?php echo $partner_product_ref->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->id->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->id->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->id->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner_type->Visible) { // partner_type ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->partner_type) == "") { ?>
		<th class="<?php echo $partner_product_ref->partner_type->headerCellClass() ?>"><?php echo $partner_product_ref->partner_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->partner_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->partner_type->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->partner_type->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->partner_type->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner->Visible) { // partner ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->partner) == "") { ?>
		<th class="<?php echo $partner_product_ref->partner->headerCellClass() ?>"><?php echo $partner_product_ref->partner->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->partner->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->partner->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->partner->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->partner->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner_ref->Visible) { // partner_ref ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->partner_ref) == "") { ?>
		<th class="<?php echo $partner_product_ref->partner_ref->headerCellClass() ?>"><?php echo $partner_product_ref->partner_ref->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->partner_ref->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->partner_ref->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->partner_ref->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->partner_ref->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->_barcode->Visible) { // barcode ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->_barcode) == "") { ?>
		<th class="<?php echo $partner_product_ref->_barcode->headerCellClass() ?>"><?php echo $partner_product_ref->_barcode->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->_barcode->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->_barcode->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->_barcode->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->_barcode->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner_code->Visible) { // partner_code ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->partner_code) == "") { ?>
		<th class="<?php echo $partner_product_ref->partner_code->headerCellClass() ?>"><?php echo $partner_product_ref->partner_code->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->partner_code->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->partner_code->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->partner_code->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->partner_code->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->product_type->Visible) { // product_type ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->product_type) == "") { ?>
		<th class="<?php echo $partner_product_ref->product_type->headerCellClass() ?>"><?php echo $partner_product_ref->product_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->product_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->product_type->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->product_type->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->product_type->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->shape->Visible) { // shape ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->shape) == "") { ?>
		<th class="<?php echo $partner_product_ref->shape->headerCellClass() ?>"><?php echo $partner_product_ref->shape->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->shape->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->shape->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->shape->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->shape->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->grp->Visible) { // grp ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->grp) == "") { ?>
		<th class="<?php echo $partner_product_ref->grp->headerCellClass() ?>"><?php echo $partner_product_ref->grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->grp->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->grp->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->grp->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->s_grp->Visible) { // s_grp ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->s_grp) == "") { ?>
		<th class="<?php echo $partner_product_ref->s_grp->headerCellClass() ?>"><?php echo $partner_product_ref->s_grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->s_grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->s_grp->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->s_grp->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->s_grp->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->product->Visible) { // product ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->product) == "") { ?>
		<th class="<?php echo $partner_product_ref->product->headerCellClass() ?>"><?php echo $partner_product_ref->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->product->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->product->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->product->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->rid->Visible) { // rid ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->rid) == "") { ?>
		<th class="<?php echo $partner_product_ref->rid->headerCellClass() ?>"><?php echo $partner_product_ref->rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->rid->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->rid->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->rid->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->spl_ins->Visible) { // spl_ins ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->spl_ins) == "") { ?>
		<th class="<?php echo $partner_product_ref->spl_ins->headerCellClass() ?>"><?php echo $partner_product_ref->spl_ins->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->spl_ins->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->spl_ins->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->spl_ins->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->spl_ins->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->spl_ins->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->packing_type->Visible) { // packing_type ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->packing_type) == "") { ?>
		<th class="<?php echo $partner_product_ref->packing_type->headerCellClass() ?>"><?php echo $partner_product_ref->packing_type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->packing_type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->packing_type->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->packing_type->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->packing_type->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->batch_no->Visible) { // batch_no ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->batch_no) == "") { ?>
		<th class="<?php echo $partner_product_ref->batch_no->headerCellClass() ?>"><?php echo $partner_product_ref->batch_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->batch_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->batch_no->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->batch_no->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->batch_no->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->unit->Visible) { // unit ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->unit) == "") { ?>
		<th class="<?php echo $partner_product_ref->unit->headerCellClass() ?>"><?php echo $partner_product_ref->unit->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->unit->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->unit->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->unit->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->unit->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->w->Visible) { // w ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->w) == "") { ?>
		<th class="<?php echo $partner_product_ref->w->headerCellClass() ?>"><?php echo $partner_product_ref->w->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->w->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->w->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->w->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->w->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->w->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->w_cm->Visible) { // w_cm ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->w_cm) == "") { ?>
		<th class="<?php echo $partner_product_ref->w_cm->headerCellClass() ?>"><?php echo $partner_product_ref->w_cm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->w_cm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->w_cm->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->w_cm->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->w_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->w_cm->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->l->Visible) { // l ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->l) == "") { ?>
		<th class="<?php echo $partner_product_ref->l->headerCellClass() ?>"><?php echo $partner_product_ref->l->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->l->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->l->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->l->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->l->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->l->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->l_cm->Visible) { // l_cm ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->l_cm) == "") { ?>
		<th class="<?php echo $partner_product_ref->l_cm->headerCellClass() ?>"><?php echo $partner_product_ref->l_cm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->l_cm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->l_cm->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->l_cm->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->l_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->l_cm->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->h->Visible) { // h ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->h) == "") { ?>
		<th class="<?php echo $partner_product_ref->h->headerCellClass() ?>"><?php echo $partner_product_ref->h->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->h->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->h->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->h->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->h->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->h->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->h_cm->Visible) { // h_cm ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->h_cm) == "") { ?>
		<th class="<?php echo $partner_product_ref->h_cm->headerCellClass() ?>"><?php echo $partner_product_ref->h_cm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->h_cm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->h_cm->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->h_cm->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->h_cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->h_cm->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->partner_size->Visible) { // partner_size ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->partner_size) == "") { ?>
		<th class="<?php echo $partner_product_ref->partner_size->headerCellClass() ?>"><?php echo $partner_product_ref->partner_size->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->partner_size->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->partner_size->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->partner_size->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->partner_size->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->partner_size->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->sqm->Visible) { // sqm ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->sqm) == "") { ?>
		<th class="<?php echo $partner_product_ref->sqm->headerCellClass() ?>"><?php echo $partner_product_ref->sqm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->sqm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->sqm->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->sqm->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->sqm->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->cbm->Visible) { // cbm ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->cbm) == "") { ?>
		<th class="<?php echo $partner_product_ref->cbm->headerCellClass() ?>"><?php echo $partner_product_ref->cbm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->cbm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->cbm->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->cbm->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->cbm->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->cbm->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->weight_sqm->Visible) { // weight_sqm ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->weight_sqm) == "") { ?>
		<th class="<?php echo $partner_product_ref->weight_sqm->headerCellClass() ?>"><?php echo $partner_product_ref->weight_sqm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->weight_sqm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->weight_sqm->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->weight_sqm->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->weight_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->weight_sqm->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->price->Visible) { // price ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->price) == "") { ?>
		<th class="<?php echo $partner_product_ref->price->headerCellClass() ?>"><?php echo $partner_product_ref->price->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->price->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->price->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->price->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->price->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->price_cs->Visible) { // price_cs ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->price_cs) == "") { ?>
		<th class="<?php echo $partner_product_ref->price_cs->headerCellClass() ?>"><?php echo $partner_product_ref->price_cs->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->price_cs->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->price_cs->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->price_cs->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->price_cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->price_cs->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->currency->Visible) { // currency ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->currency) == "") { ?>
		<th class="<?php echo $partner_product_ref->currency->headerCellClass() ?>"><?php echo $partner_product_ref->currency->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->currency->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->currency->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->currency->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->currency->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->hsn->Visible) { // hsn ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->hsn) == "") { ?>
		<th class="<?php echo $partner_product_ref->hsn->headerCellClass() ?>"><?php echo $partner_product_ref->hsn->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->hsn->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->hsn->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->hsn->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->hsn->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->hsn->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->composition->Visible) { // composition ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->composition) == "") { ?>
		<th class="<?php echo $partner_product_ref->composition->headerCellClass() ?>"><?php echo $partner_product_ref->composition->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->composition->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->composition->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->composition->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->composition->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->composition->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->status->Visible) { // status ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->status) == "") { ?>
		<th class="<?php echo $partner_product_ref->status->headerCellClass() ?>"><?php echo $partner_product_ref->status->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->status->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->status->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->status->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->status->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->operator->Visible) { // operator ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->operator) == "") { ?>
		<th class="<?php echo $partner_product_ref->operator->headerCellClass() ?>"><?php echo $partner_product_ref->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->operator->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->operator->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->operator->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_product_ref->datetime->Visible) { // datetime ?>
	<?php if ($partner_product_ref->SortUrl($partner_product_ref->datetime) == "") { ?>
		<th class="<?php echo $partner_product_ref->datetime->headerCellClass() ?>"><?php echo $partner_product_ref->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $partner_product_ref->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($partner_product_ref->datetime->Name) ?>" data-sort-order="<?php echo $partner_product_ref_preview->SortField == $partner_product_ref->datetime->Name && $partner_product_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_product_ref->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_product_ref_preview->SortField == $partner_product_ref->datetime->Name) { ?><?php if ($partner_product_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_product_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$partner_product_ref_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$partner_product_ref_preview->RecCount = 0;
$partner_product_ref_preview->RowCnt = 0;
while ($partner_product_ref_preview->Recordset && !$partner_product_ref_preview->Recordset->EOF) {

	// Init row class and style
	$partner_product_ref_preview->RecCount++;
	$partner_product_ref_preview->RowCnt++;
	$partner_product_ref_preview->CssStyle = "";
	$partner_product_ref_preview->loadListRowValues($partner_product_ref_preview->Recordset);

	// Render row
	$partner_product_ref_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$partner_product_ref_preview->resetAttributes();
	$partner_product_ref_preview->renderListRow();

	// Render list options
	$partner_product_ref_preview->renderListOptions();
?>
	<tr<?php echo $partner_product_ref_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_product_ref_preview->ListOptions->render("body", "left", $partner_product_ref_preview->RowCnt);
?>
<?php if ($partner_product_ref->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $partner_product_ref->id->cellAttributes() ?>>
<span<?php echo $partner_product_ref->id->viewAttributes() ?>>
<?php echo $partner_product_ref->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->partner_type->Visible) { // partner_type ?>
		<!-- partner_type -->
		<td<?php echo $partner_product_ref->partner_type->cellAttributes() ?>>
<span<?php echo $partner_product_ref->partner_type->viewAttributes() ?>>
<?php echo $partner_product_ref->partner_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->partner->Visible) { // partner ?>
		<!-- partner -->
		<td<?php echo $partner_product_ref->partner->cellAttributes() ?>>
<span<?php echo $partner_product_ref->partner->viewAttributes() ?>>
<?php echo $partner_product_ref->partner->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->partner_ref->Visible) { // partner_ref ?>
		<!-- partner_ref -->
		<td<?php echo $partner_product_ref->partner_ref->cellAttributes() ?>>
<span<?php echo $partner_product_ref->partner_ref->viewAttributes() ?>>
<?php echo $partner_product_ref->partner_ref->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->_barcode->Visible) { // barcode ?>
		<!-- barcode -->
		<td<?php echo $partner_product_ref->_barcode->cellAttributes() ?>>
<span<?php echo $partner_product_ref->_barcode->viewAttributes() ?>>
<?php echo $partner_product_ref->_barcode->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->partner_code->Visible) { // partner_code ?>
		<!-- partner_code -->
		<td<?php echo $partner_product_ref->partner_code->cellAttributes() ?>>
<span<?php echo $partner_product_ref->partner_code->viewAttributes() ?>>
<?php echo $partner_product_ref->partner_code->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->product_type->Visible) { // product_type ?>
		<!-- product_type -->
		<td<?php echo $partner_product_ref->product_type->cellAttributes() ?>>
<span<?php echo $partner_product_ref->product_type->viewAttributes() ?>>
<?php echo $partner_product_ref->product_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->shape->Visible) { // shape ?>
		<!-- shape -->
		<td<?php echo $partner_product_ref->shape->cellAttributes() ?>>
<span<?php echo $partner_product_ref->shape->viewAttributes() ?>>
<?php echo $partner_product_ref->shape->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->grp->Visible) { // grp ?>
		<!-- grp -->
		<td<?php echo $partner_product_ref->grp->cellAttributes() ?>>
<span<?php echo $partner_product_ref->grp->viewAttributes() ?>>
<?php if ((!EmptyString($partner_product_ref->grp->getViewValue())) && $partner_product_ref->grp->linkAttributes() <> "") { ?>
<a<?php echo $partner_product_ref->grp->linkAttributes() ?>><?php echo $partner_product_ref->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_product_ref->grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_product_ref->s_grp->Visible) { // s_grp ?>
		<!-- s_grp -->
		<td<?php echo $partner_product_ref->s_grp->cellAttributes() ?>>
<span<?php echo $partner_product_ref->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($partner_product_ref->s_grp->getViewValue())) && $partner_product_ref->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $partner_product_ref->s_grp->linkAttributes() ?>><?php echo $partner_product_ref->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_product_ref->s_grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_product_ref->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $partner_product_ref->product->cellAttributes() ?>>
<span<?php echo $partner_product_ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($partner_product_ref->product->getViewValue())) && $partner_product_ref->product->linkAttributes() <> "") { ?>
<a<?php echo $partner_product_ref->product->linkAttributes() ?>><?php echo $partner_product_ref->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_product_ref->product->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_product_ref->rid->Visible) { // rid ?>
		<!-- rid -->
		<td<?php echo $partner_product_ref->rid->cellAttributes() ?>>
<span<?php echo $partner_product_ref->rid->viewAttributes() ?>>
<?php echo $partner_product_ref->rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->spl_ins->Visible) { // spl_ins ?>
		<!-- spl_ins -->
		<td<?php echo $partner_product_ref->spl_ins->cellAttributes() ?>>
<span<?php echo $partner_product_ref->spl_ins->viewAttributes() ?>>
<?php echo $partner_product_ref->spl_ins->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->packing_type->Visible) { // packing_type ?>
		<!-- packing_type -->
		<td<?php echo $partner_product_ref->packing_type->cellAttributes() ?>>
<span<?php echo $partner_product_ref->packing_type->viewAttributes() ?>>
<?php echo $partner_product_ref->packing_type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td<?php echo $partner_product_ref->batch_no->cellAttributes() ?>>
<span<?php echo $partner_product_ref->batch_no->viewAttributes() ?>>
<?php echo $partner_product_ref->batch_no->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->unit->Visible) { // unit ?>
		<!-- unit -->
		<td<?php echo $partner_product_ref->unit->cellAttributes() ?>>
<span<?php echo $partner_product_ref->unit->viewAttributes() ?>>
<?php if ((!EmptyString($partner_product_ref->unit->getViewValue())) && $partner_product_ref->unit->linkAttributes() <> "") { ?>
<a<?php echo $partner_product_ref->unit->linkAttributes() ?>><?php echo $partner_product_ref->unit->getViewValue() ?></a>
<?php } else { ?>
<?php echo $partner_product_ref->unit->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($partner_product_ref->w->Visible) { // w ?>
		<!-- w -->
		<td<?php echo $partner_product_ref->w->cellAttributes() ?>>
<span<?php echo $partner_product_ref->w->viewAttributes() ?>>
<?php echo $partner_product_ref->w->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->w_cm->Visible) { // w_cm ?>
		<!-- w_cm -->
		<td<?php echo $partner_product_ref->w_cm->cellAttributes() ?>>
<span<?php echo $partner_product_ref->w_cm->viewAttributes() ?>>
<?php echo $partner_product_ref->w_cm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->l->Visible) { // l ?>
		<!-- l -->
		<td<?php echo $partner_product_ref->l->cellAttributes() ?>>
<span<?php echo $partner_product_ref->l->viewAttributes() ?>>
<?php echo $partner_product_ref->l->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->l_cm->Visible) { // l_cm ?>
		<!-- l_cm -->
		<td<?php echo $partner_product_ref->l_cm->cellAttributes() ?>>
<span<?php echo $partner_product_ref->l_cm->viewAttributes() ?>>
<?php echo $partner_product_ref->l_cm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->h->Visible) { // h ?>
		<!-- h -->
		<td<?php echo $partner_product_ref->h->cellAttributes() ?>>
<span<?php echo $partner_product_ref->h->viewAttributes() ?>>
<?php echo $partner_product_ref->h->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->h_cm->Visible) { // h_cm ?>
		<!-- h_cm -->
		<td<?php echo $partner_product_ref->h_cm->cellAttributes() ?>>
<span<?php echo $partner_product_ref->h_cm->viewAttributes() ?>>
<?php echo $partner_product_ref->h_cm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->partner_size->Visible) { // partner_size ?>
		<!-- partner_size -->
		<td<?php echo $partner_product_ref->partner_size->cellAttributes() ?>>
<span<?php echo $partner_product_ref->partner_size->viewAttributes() ?>>
<?php echo $partner_product_ref->partner_size->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->sqm->Visible) { // sqm ?>
		<!-- sqm -->
		<td<?php echo $partner_product_ref->sqm->cellAttributes() ?>>
<span<?php echo $partner_product_ref->sqm->viewAttributes() ?>>
<?php echo $partner_product_ref->sqm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->cbm->Visible) { // cbm ?>
		<!-- cbm -->
		<td<?php echo $partner_product_ref->cbm->cellAttributes() ?>>
<span<?php echo $partner_product_ref->cbm->viewAttributes() ?>>
<?php echo $partner_product_ref->cbm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->weight_sqm->Visible) { // weight_sqm ?>
		<!-- weight_sqm -->
		<td<?php echo $partner_product_ref->weight_sqm->cellAttributes() ?>>
<span<?php echo $partner_product_ref->weight_sqm->viewAttributes() ?>>
<?php echo $partner_product_ref->weight_sqm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->price->Visible) { // price ?>
		<!-- price -->
		<td<?php echo $partner_product_ref->price->cellAttributes() ?>>
<span<?php echo $partner_product_ref->price->viewAttributes() ?>>
<?php echo $partner_product_ref->price->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->price_cs->Visible) { // price_cs ?>
		<!-- price_cs -->
		<td<?php echo $partner_product_ref->price_cs->cellAttributes() ?>>
<span<?php echo $partner_product_ref->price_cs->viewAttributes() ?>>
<?php echo $partner_product_ref->price_cs->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->currency->Visible) { // currency ?>
		<!-- currency -->
		<td<?php echo $partner_product_ref->currency->cellAttributes() ?>>
<span<?php echo $partner_product_ref->currency->viewAttributes() ?>>
<?php echo $partner_product_ref->currency->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->hsn->Visible) { // hsn ?>
		<!-- hsn -->
		<td<?php echo $partner_product_ref->hsn->cellAttributes() ?>>
<span<?php echo $partner_product_ref->hsn->viewAttributes() ?>>
<?php echo $partner_product_ref->hsn->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->composition->Visible) { // composition ?>
		<!-- composition -->
		<td<?php echo $partner_product_ref->composition->cellAttributes() ?>>
<span<?php echo $partner_product_ref->composition->viewAttributes() ?>>
<?php echo $partner_product_ref->composition->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->status->Visible) { // status ?>
		<!-- status -->
		<td<?php echo $partner_product_ref->status->cellAttributes() ?>>
<span<?php echo $partner_product_ref->status->viewAttributes() ?>>
<?php echo $partner_product_ref->status->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $partner_product_ref->operator->cellAttributes() ?>>
<span<?php echo $partner_product_ref->operator->viewAttributes() ?>>
<?php echo $partner_product_ref->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($partner_product_ref->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $partner_product_ref->datetime->cellAttributes() ?>>
<span<?php echo $partner_product_ref->datetime->viewAttributes() ?>>
<?php echo $partner_product_ref->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$partner_product_ref_preview->ListOptions->render("body", "right", $partner_product_ref_preview->RowCnt);
?>
	</tr>
<?php
	$partner_product_ref_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($partner_product_ref_preview->TotalRecs > 0) { ?>
<?php if (!isset($partner_product_ref_preview->Pager)) $partner_product_ref_preview->Pager = new PrevNextPager($partner_product_ref_preview->StartRec, $partner_product_ref_preview->DisplayRecs, $partner_product_ref_preview->TotalRecs) ?>
<?php if ($partner_product_ref_preview->Pager->RecordCount > 0 && $partner_product_ref_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($partner_product_ref_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $partner_product_ref_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($partner_product_ref_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $partner_product_ref_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($partner_product_ref_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $partner_product_ref_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($partner_product_ref_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $partner_product_ref_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $partner_product_ref_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $partner_product_ref_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $partner_product_ref_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($partner_product_ref_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$partner_product_ref_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($partner_product_ref_preview->Recordset)
	$partner_product_ref_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$partner_product_ref_preview->terminate();
?>