<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_product_ref_search = new partner_product_ref_search();

// Run the page
$partner_product_ref_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_product_ref_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($partner_product_ref_search->IsModal) { ?>
var fpartner_product_refsearch = currentAdvancedSearchForm = new ew.Form("fpartner_product_refsearch", "search");
<?php } else { ?>
var fpartner_product_refsearch = currentForm = new ew.Form("fpartner_product_refsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpartner_product_refsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_product_refsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_product_refsearch.lists["x_partner_type"] = <?php echo $partner_product_ref_search->partner_type->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_partner_type"].options = <?php echo JsonEncode($partner_product_ref_search->partner_type->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_partner"] = <?php echo $partner_product_ref_search->partner->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_partner"].options = <?php echo JsonEncode($partner_product_ref_search->partner->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_product_type"] = <?php echo $partner_product_ref_search->product_type->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_product_type"].options = <?php echo JsonEncode($partner_product_ref_search->product_type->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_shape"] = <?php echo $partner_product_ref_search->shape->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_shape"].options = <?php echo JsonEncode($partner_product_ref_search->shape->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_grp"] = <?php echo $partner_product_ref_search->grp->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_grp"].options = <?php echo JsonEncode($partner_product_ref_search->grp->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_s_grp"] = <?php echo $partner_product_ref_search->s_grp->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_s_grp"].options = <?php echo JsonEncode($partner_product_ref_search->s_grp->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_product"] = <?php echo $partner_product_ref_search->product->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_product"].options = <?php echo JsonEncode($partner_product_ref_search->product->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_packing_type"] = <?php echo $partner_product_ref_search->packing_type->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_packing_type"].options = <?php echo JsonEncode($partner_product_ref_search->packing_type->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_batch_no"] = <?php echo $partner_product_ref_search->batch_no->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_batch_no"].options = <?php echo JsonEncode($partner_product_ref_search->batch_no->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_unit"] = <?php echo $partner_product_ref_search->unit->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_unit"].options = <?php echo JsonEncode($partner_product_ref_search->unit->options(FALSE, TRUE)) ?>;
fpartner_product_refsearch.lists["x_currency"] = <?php echo $partner_product_ref_search->currency->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_currency"].options = <?php echo JsonEncode($partner_product_ref_search->currency->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_hsn"] = <?php echo $partner_product_ref_search->hsn->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_hsn"].options = <?php echo JsonEncode($partner_product_ref_search->hsn->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_composition"] = <?php echo $partner_product_ref_search->composition->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_composition"].options = <?php echo JsonEncode($partner_product_ref_search->composition->lookupOptions()) ?>;
fpartner_product_refsearch.lists["x_status"] = <?php echo $partner_product_ref_search->status->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_status"].options = <?php echo JsonEncode($partner_product_ref_search->status->options(FALSE, TRUE)) ?>;
fpartner_product_refsearch.lists["x_operator"] = <?php echo $partner_product_ref_search->operator->Lookup->toClientList() ?>;
fpartner_product_refsearch.lists["x_operator"].options = <?php echo JsonEncode($partner_product_ref_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpartner_product_refsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_w_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->w_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_l_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->l_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_h_cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->h_cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->cbm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->weight_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price_cs");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_product_ref->price_cs->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $partner_product_ref_search->showPageHeader(); ?>
<?php
$partner_product_ref_search->showMessage();
?>
<form name="fpartner_product_refsearch" id="fpartner_product_refsearch" class="<?php echo $partner_product_ref_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_product_ref_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_product_ref_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_product_ref">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$partner_product_ref_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($partner_product_ref->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_id"><?php echo $partner_product_ref->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->id->cellAttributes() ?>>
			<span id="el_partner_product_ref_id">
<input type="text" data-table="partner_product_ref" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($partner_product_ref->id->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->id->EditValue ?>"<?php echo $partner_product_ref->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_type->Visible) { // partner_type ?>
	<div id="r_partner_type" class="form-group row">
		<label for="x_partner_type" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner_type"><?php echo $partner_product_ref->partner_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_type" id="z_partner_type" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner_type->cellAttributes() ?>>
			<span id="el_partner_product_ref_partner_type">
<?php $partner_product_ref->partner_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->partner_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_partner_type" data-value-separator="<?php echo $partner_product_ref->partner_type->displayValueSeparatorAttribute() ?>" id="x_partner_type" name="x_partner_type"<?php echo $partner_product_ref->partner_type->editAttributes() ?>>
		<?php echo $partner_product_ref->partner_type->selectOptionListHtml("x_partner_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->partner_type->Lookup->getParamTag("p_x_partner_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner->Visible) { // partner ?>
	<div id="r_partner" class="form-group row">
		<label for="x_partner" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner"><?php echo $partner_product_ref->partner->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner" id="z_partner" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner->cellAttributes() ?>>
			<span id="el_partner_product_ref_partner">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_partner" data-value-separator="<?php echo $partner_product_ref->partner->displayValueSeparatorAttribute() ?>" id="x_partner" name="x_partner"<?php echo $partner_product_ref->partner->editAttributes() ?>>
		<?php echo $partner_product_ref->partner->selectOptionListHtml("x_partner") ?>
	</select>
</div>
<?php echo $partner_product_ref->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_ref->Visible) { // partner_ref ?>
	<div id="r_partner_ref" class="form-group row">
		<label for="x_partner_ref" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner_ref"><?php echo $partner_product_ref->partner_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_ref" id="z_partner_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner_ref->cellAttributes() ?>>
			<span id="el_partner_product_ref_partner_ref">
<input type="text" data-table="partner_product_ref" data-field="x_partner_ref" name="x_partner_ref" id="x_partner_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_ref->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_ref->EditValue ?>"<?php echo $partner_product_ref->partner_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref__barcode"><?php echo $partner_product_ref->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__barcode" id="z__barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->_barcode->cellAttributes() ?>>
			<span id="el_partner_product_ref__barcode">
<input type="text" data-table="partner_product_ref" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_product_ref->_barcode->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->_barcode->EditValue ?>"<?php echo $partner_product_ref->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_code->Visible) { // partner_code ?>
	<div id="r_partner_code" class="form-group row">
		<label for="x_partner_code" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner_code"><?php echo $partner_product_ref->partner_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_code" id="z_partner_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner_code->cellAttributes() ?>>
			<span id="el_partner_product_ref_partner_code">
<input type="text" data-table="partner_product_ref" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_code->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_code->EditValue ?>"<?php echo $partner_product_ref->partner_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_product_type"><?php echo $partner_product_ref->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->product_type->cellAttributes() ?>>
			<span id="el_partner_product_ref_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_product_type" data-value-separator="<?php echo $partner_product_ref->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $partner_product_ref->product_type->editAttributes() ?>>
		<?php echo $partner_product_ref->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_shape"><?php echo $partner_product_ref->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->shape->cellAttributes() ?>>
			<span id="el_partner_product_ref_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_shape" data-value-separator="<?php echo $partner_product_ref->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $partner_product_ref->shape->editAttributes() ?>>
		<?php echo $partner_product_ref->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $partner_product_ref->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_grp"><?php echo $partner_product_ref->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->grp->cellAttributes() ?>>
			<span id="el_partner_product_ref_grp">
<?php $partner_product_ref->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_grp" data-value-separator="<?php echo $partner_product_ref->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $partner_product_ref->grp->editAttributes() ?>>
		<?php echo $partner_product_ref->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $partner_product_ref->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_s_grp"><?php echo $partner_product_ref->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->s_grp->cellAttributes() ?>>
			<span id="el_partner_product_ref_s_grp">
<?php $partner_product_ref->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_product_ref->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_s_grp" data-value-separator="<?php echo $partner_product_ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $partner_product_ref->s_grp->editAttributes() ?>>
		<?php echo $partner_product_ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $partner_product_ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_product"><?php echo $partner_product_ref->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->product->cellAttributes() ?>>
			<span id="el_partner_product_ref_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_product" data-value-separator="<?php echo $partner_product_ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $partner_product_ref->product->editAttributes() ?>>
		<?php echo $partner_product_ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $partner_product_ref->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->spl_ins->Visible) { // spl_ins ?>
	<div id="r_spl_ins" class="form-group row">
		<label for="x_spl_ins" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_spl_ins"><?php echo $partner_product_ref->spl_ins->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_spl_ins" id="z_spl_ins" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->spl_ins->cellAttributes() ?>>
			<span id="el_partner_product_ref_spl_ins">
<input type="text" data-table="partner_product_ref" data-field="x_spl_ins" name="x_spl_ins" id="x_spl_ins" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->spl_ins->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->spl_ins->EditValue ?>"<?php echo $partner_product_ref->spl_ins->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_packing_type"><?php echo $partner_product_ref->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->packing_type->cellAttributes() ?>>
			<span id="el_partner_product_ref_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_packing_type" data-value-separator="<?php echo $partner_product_ref->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $partner_product_ref->packing_type->editAttributes() ?>>
		<?php echo $partner_product_ref->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $partner_product_ref->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_batch_no"><?php echo $partner_product_ref->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->batch_no->cellAttributes() ?>>
			<span id="el_partner_product_ref_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_batch_no" data-value-separator="<?php echo $partner_product_ref->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $partner_product_ref->batch_no->editAttributes() ?>>
		<?php echo $partner_product_ref->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $partner_product_ref->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_unit"><?php echo $partner_product_ref->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->unit->cellAttributes() ?>>
			<span id="el_partner_product_ref_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_unit" data-value-separator="<?php echo $partner_product_ref->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $partner_product_ref->unit->editAttributes() ?>>
		<?php echo $partner_product_ref->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->w->Visible) { // w ?>
	<div id="r_w" class="form-group row">
		<label for="x_w" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_w"><?php echo $partner_product_ref->w->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_w" id="z_w" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->w->cellAttributes() ?>>
			<span id="el_partner_product_ref_w">
<input type="text" data-table="partner_product_ref" data-field="x_w" name="x_w" id="x_w" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->w->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->w->EditValue ?>"<?php echo $partner_product_ref->w->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->w_cm->Visible) { // w_cm ?>
	<div id="r_w_cm" class="form-group row">
		<label for="x_w_cm" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_w_cm"><?php echo $partner_product_ref->w_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_w_cm" id="z_w_cm" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->w_cm->cellAttributes() ?>>
			<span id="el_partner_product_ref_w_cm">
<input type="text" data-table="partner_product_ref" data-field="x_w_cm" name="x_w_cm" id="x_w_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->w_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->w_cm->EditValue ?>"<?php echo $partner_product_ref->w_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->l->Visible) { // l ?>
	<div id="r_l" class="form-group row">
		<label for="x_l" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_l"><?php echo $partner_product_ref->l->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_l" id="z_l" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->l->cellAttributes() ?>>
			<span id="el_partner_product_ref_l">
<input type="text" data-table="partner_product_ref" data-field="x_l" name="x_l" id="x_l" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->l->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->l->EditValue ?>"<?php echo $partner_product_ref->l->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->l_cm->Visible) { // l_cm ?>
	<div id="r_l_cm" class="form-group row">
		<label for="x_l_cm" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_l_cm"><?php echo $partner_product_ref->l_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_l_cm" id="z_l_cm" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->l_cm->cellAttributes() ?>>
			<span id="el_partner_product_ref_l_cm">
<input type="text" data-table="partner_product_ref" data-field="x_l_cm" name="x_l_cm" id="x_l_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->l_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->l_cm->EditValue ?>"<?php echo $partner_product_ref->l_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->h->Visible) { // h ?>
	<div id="r_h" class="form-group row">
		<label for="x_h" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_h"><?php echo $partner_product_ref->h->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_h" id="z_h" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->h->cellAttributes() ?>>
			<span id="el_partner_product_ref_h">
<input type="text" data-table="partner_product_ref" data-field="x_h" name="x_h" id="x_h" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($partner_product_ref->h->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->h->EditValue ?>"<?php echo $partner_product_ref->h->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->h_cm->Visible) { // h_cm ?>
	<div id="r_h_cm" class="form-group row">
		<label for="x_h_cm" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_h_cm"><?php echo $partner_product_ref->h_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_h_cm" id="z_h_cm" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->h_cm->cellAttributes() ?>>
			<span id="el_partner_product_ref_h_cm">
<input type="text" data-table="partner_product_ref" data-field="x_h_cm" name="x_h_cm" id="x_h_cm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->h_cm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->h_cm->EditValue ?>"<?php echo $partner_product_ref->h_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->partner_size->Visible) { // partner_size ?>
	<div id="r_partner_size" class="form-group row">
		<label for="x_partner_size" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_partner_size"><?php echo $partner_product_ref->partner_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_size" id="z_partner_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->partner_size->cellAttributes() ?>>
			<span id="el_partner_product_ref_partner_size">
<input type="text" data-table="partner_product_ref" data-field="x_partner_size" name="x_partner_size" id="x_partner_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_product_ref->partner_size->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->partner_size->EditValue ?>"<?php echo $partner_product_ref->partner_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_sqm"><?php echo $partner_product_ref->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->sqm->cellAttributes() ?>>
			<span id="el_partner_product_ref_sqm">
<input type="text" data-table="partner_product_ref" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->sqm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->sqm->EditValue ?>"<?php echo $partner_product_ref->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_cbm"><?php echo $partner_product_ref->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->cbm->cellAttributes() ?>>
			<span id="el_partner_product_ref_cbm">
<input type="text" data-table="partner_product_ref" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->cbm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->cbm->EditValue ?>"<?php echo $partner_product_ref->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->weight_sqm->Visible) { // weight_sqm ?>
	<div id="r_weight_sqm" class="form-group row">
		<label for="x_weight_sqm" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_weight_sqm"><?php echo $partner_product_ref->weight_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight_sqm" id="z_weight_sqm" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->weight_sqm->cellAttributes() ?>>
			<span id="el_partner_product_ref_weight_sqm">
<input type="text" data-table="partner_product_ref" data-field="x_weight_sqm" name="x_weight_sqm" id="x_weight_sqm" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->weight_sqm->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->weight_sqm->EditValue ?>"<?php echo $partner_product_ref->weight_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_price"><?php echo $partner_product_ref->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->price->cellAttributes() ?>>
			<span id="el_partner_product_ref_price">
<input type="text" data-table="partner_product_ref" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->price->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->price->EditValue ?>"<?php echo $partner_product_ref->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->price_cs->Visible) { // price_cs ?>
	<div id="r_price_cs" class="form-group row">
		<label for="x_price_cs" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_price_cs"><?php echo $partner_product_ref->price_cs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price_cs" id="z_price_cs" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->price_cs->cellAttributes() ?>>
			<span id="el_partner_product_ref_price_cs">
<input type="text" data-table="partner_product_ref" data-field="x_price_cs" name="x_price_cs" id="x_price_cs" size="30" placeholder="<?php echo HtmlEncode($partner_product_ref->price_cs->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->price_cs->EditValue ?>"<?php echo $partner_product_ref->price_cs->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_currency"><?php echo $partner_product_ref->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->currency->cellAttributes() ?>>
			<span id="el_partner_product_ref_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_currency" data-value-separator="<?php echo $partner_product_ref->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $partner_product_ref->currency->editAttributes() ?>>
		<?php echo $partner_product_ref->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $partner_product_ref->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->hsn->Visible) { // hsn ?>
	<div id="r_hsn" class="form-group row">
		<label for="x_hsn" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_hsn"><?php echo $partner_product_ref->hsn->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_hsn" id="z_hsn" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->hsn->cellAttributes() ?>>
			<span id="el_partner_product_ref_hsn">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_hsn" data-value-separator="<?php echo $partner_product_ref->hsn->displayValueSeparatorAttribute() ?>" id="x_hsn" name="x_hsn"<?php echo $partner_product_ref->hsn->editAttributes() ?>>
		<?php echo $partner_product_ref->hsn->selectOptionListHtml("x_hsn") ?>
	</select>
</div>
<?php echo $partner_product_ref->hsn->Lookup->getParamTag("p_x_hsn") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->composition->Visible) { // composition ?>
	<div id="r_composition" class="form-group row">
		<label for="x_composition" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_composition"><?php echo $partner_product_ref->composition->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_composition" id="z_composition" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->composition->cellAttributes() ?>>
			<span id="el_partner_product_ref_composition">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_composition" data-value-separator="<?php echo $partner_product_ref->composition->displayValueSeparatorAttribute() ?>" id="x_composition" name="x_composition"<?php echo $partner_product_ref->composition->editAttributes() ?>>
		<?php echo $partner_product_ref->composition->selectOptionListHtml("x_composition") ?>
	</select>
</div>
<?php echo $partner_product_ref->composition->Lookup->getParamTag("p_x_composition") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_status"><?php echo $partner_product_ref->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->status->cellAttributes() ?>>
			<span id="el_partner_product_ref_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_status" data-value-separator="<?php echo $partner_product_ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $partner_product_ref->status->editAttributes() ?>>
		<?php echo $partner_product_ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_operator"><?php echo $partner_product_ref->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->operator->cellAttributes() ?>>
			<span id="el_partner_product_ref_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_product_ref" data-field="x_operator" data-value-separator="<?php echo $partner_product_ref->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $partner_product_ref->operator->editAttributes() ?>>
		<?php echo $partner_product_ref->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $partner_product_ref->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_product_ref->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $partner_product_ref_search->LeftColumnClass ?>"><span id="elh_partner_product_ref_datetime"><?php echo $partner_product_ref->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $partner_product_ref_search->RightColumnClass ?>"><div<?php echo $partner_product_ref->datetime->cellAttributes() ?>>
			<span id="el_partner_product_ref_datetime">
<input type="text" data-table="partner_product_ref" data-field="x_datetime" data-format="7" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($partner_product_ref->datetime->getPlaceHolder()) ?>" value="<?php echo $partner_product_ref->datetime->EditValue ?>"<?php echo $partner_product_ref->datetime->editAttributes() ?>>
<?php if (!$partner_product_ref->datetime->ReadOnly && !$partner_product_ref->datetime->Disabled && !isset($partner_product_ref->datetime->EditAttrs["readonly"]) && !isset($partner_product_ref->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_product_refsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$partner_product_ref_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $partner_product_ref_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$partner_product_ref_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$partner_product_ref_search->terminate();
?>