<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_quotation_buyer_add = new partner_quotation_buyer_add();

// Run the page
$partner_quotation_buyer_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_quotation_buyer_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpartner_quotation_buyeradd = currentForm = new ew.Form("fpartner_quotation_buyeradd", "add");

// Validate form
fpartner_quotation_buyeradd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($partner_quotation_buyer_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->company_id->caption(), $partner_quotation_buyer->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->partner_id->caption(), $partner_quotation_buyer->partner_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->partner_details->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->partner_details->caption(), $partner_quotation_buyer->partner_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->product_type->caption(), $partner_quotation_buyer->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->product->caption(), $partner_quotation_buyer->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->product_code->caption(), $partner_quotation_buyer->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->partner_code->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->partner_code->caption(), $partner_quotation_buyer->partner_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->packing_type->caption(), $partner_quotation_buyer->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->unit->caption(), $partner_quotation_buyer->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->quantity_approx->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_approx");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->quantity_approx->caption(), $partner_quotation_buyer->quantity_approx->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->quantity->caption(), $partner_quotation_buyer->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->quantity->errorMessage()) ?>");
		<?php if ($partner_quotation_buyer_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->price->caption(), $partner_quotation_buyer->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->price->errorMessage()) ?>");
		<?php if ($partner_quotation_buyer_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->amount->caption(), $partner_quotation_buyer->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->amount->errorMessage()) ?>");
		<?php if ($partner_quotation_buyer_add->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->currency->caption(), $partner_quotation_buyer->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->total_amount->caption(), $partner_quotation_buyer->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->total_amount->errorMessage()) ?>");
		<?php if ($partner_quotation_buyer_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->remarks->caption(), $partner_quotation_buyer->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->payment_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->payment_terms->caption(), $partner_quotation_buyer->payment_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->tax_categories->Required) { ?>
			elm = this.getElements("x" + infix + "_tax_categories");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->tax_categories->caption(), $partner_quotation_buyer->tax_categories->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->delivery_period->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_period");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->delivery_period->caption(), $partner_quotation_buyer->delivery_period->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_delivery_period");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->delivery_period->errorMessage()) ?>");
		<?php if ($partner_quotation_buyer_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->operator->caption(), $partner_quotation_buyer->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_buyer_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_buyer->datetime->caption(), $partner_quotation_buyer->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpartner_quotation_buyeradd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_quotation_buyeradd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_quotation_buyeradd.lists["x_company_id"] = <?php echo $partner_quotation_buyer_add->company_id->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_company_id"].options = <?php echo JsonEncode($partner_quotation_buyer_add->company_id->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_partner_id"] = <?php echo $partner_quotation_buyer_add->partner_id->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_partner_id"].options = <?php echo JsonEncode($partner_quotation_buyer_add->partner_id->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_product_type"] = <?php echo $partner_quotation_buyer_add->product_type->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_product_type"].options = <?php echo JsonEncode($partner_quotation_buyer_add->product_type->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_product"] = <?php echo $partner_quotation_buyer_add->product->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_product"].options = <?php echo JsonEncode($partner_quotation_buyer_add->product->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_product_code"] = <?php echo $partner_quotation_buyer_add->product_code->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_product_code"].options = <?php echo JsonEncode($partner_quotation_buyer_add->product_code->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_packing_type"] = <?php echo $partner_quotation_buyer_add->packing_type->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_packing_type"].options = <?php echo JsonEncode($partner_quotation_buyer_add->packing_type->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_unit"] = <?php echo $partner_quotation_buyer_add->unit->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_unit"].options = <?php echo JsonEncode($partner_quotation_buyer_add->unit->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_currency"] = <?php echo $partner_quotation_buyer_add->currency->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_currency"].options = <?php echo JsonEncode($partner_quotation_buyer_add->currency->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_payment_terms"] = <?php echo $partner_quotation_buyer_add->payment_terms->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_payment_terms"].options = <?php echo JsonEncode($partner_quotation_buyer_add->payment_terms->lookupOptions()) ?>;
fpartner_quotation_buyeradd.lists["x_tax_categories"] = <?php echo $partner_quotation_buyer_add->tax_categories->Lookup->toClientList() ?>;
fpartner_quotation_buyeradd.lists["x_tax_categories"].options = <?php echo JsonEncode($partner_quotation_buyer_add->tax_categories->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $partner_quotation_buyer_add->showPageHeader(); ?>
<?php
$partner_quotation_buyer_add->showMessage();
?>
<form name="fpartner_quotation_buyeradd" id="fpartner_quotation_buyeradd" class="<?php echo $partner_quotation_buyer_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_quotation_buyer_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_quotation_buyer_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_quotation_buyer">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$partner_quotation_buyer_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($partner_quotation_buyer->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_partner_quotation_buyer_company_id" for="x_company_id" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->company_id->caption() ?><?php echo ($partner_quotation_buyer->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->company_id->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_company_id" data-value-separator="<?php echo $partner_quotation_buyer->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $partner_quotation_buyer->company_id->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $partner_quotation_buyer->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label id="elh_partner_quotation_buyer_partner_id" for="x_partner_id" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->partner_id->caption() ?><?php echo ($partner_quotation_buyer->partner_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->partner_id->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_partner_id" data-value-separator="<?php echo $partner_quotation_buyer->partner_id->displayValueSeparatorAttribute() ?>" id="x_partner_id" name="x_partner_id"<?php echo $partner_quotation_buyer->partner_id->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->partner_id->selectOptionListHtml("x_partner_id") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
<?php echo $partner_quotation_buyer->partner_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_details->Visible) { // partner_details ?>
	<div id="r_partner_details" class="form-group row">
		<label id="elh_partner_quotation_buyer_partner_details" for="x_partner_details" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->partner_details->caption() ?><?php echo ($partner_quotation_buyer->partner_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->partner_details->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_details">
<textarea data-table="partner_quotation_buyer" data-field="x_partner_details" name="x_partner_details" id="x_partner_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->partner_details->getPlaceHolder()) ?>"<?php echo $partner_quotation_buyer->partner_details->editAttributes() ?>><?php echo $partner_quotation_buyer->partner_details->EditValue ?></textarea>
</span>
<?php echo $partner_quotation_buyer->partner_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_partner_quotation_buyer_product_type" for="x_product_type" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->product_type->caption() ?><?php echo ($partner_quotation_buyer->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->product_type->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product_type">
<?php $partner_quotation_buyer->product_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_quotation_buyer->product_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_product_type" data-value-separator="<?php echo $partner_quotation_buyer->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $partner_quotation_buyer->product_type->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
<?php echo $partner_quotation_buyer->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_partner_quotation_buyer_product" for="x_product" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->product->caption() ?><?php echo ($partner_quotation_buyer->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->product->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product">
<?php $partner_quotation_buyer->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_quotation_buyer->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_product" data-value-separator="<?php echo $partner_quotation_buyer->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $partner_quotation_buyer->product->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $partner_quotation_buyer->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label id="elh_partner_quotation_buyer_product_code" for="x_product_code" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->product_code->caption() ?><?php echo ($partner_quotation_buyer->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->product_code->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product_code">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_product_code" data-value-separator="<?php echo $partner_quotation_buyer->product_code->displayValueSeparatorAttribute() ?>" id="x_product_code" name="x_product_code"<?php echo $partner_quotation_buyer->product_code->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->product_code->selectOptionListHtml("x_product_code") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->product_code->Lookup->getParamTag("p_x_product_code") ?>
</span>
<?php echo $partner_quotation_buyer->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_code->Visible) { // partner_code ?>
	<div id="r_partner_code" class="form-group row">
		<label id="elh_partner_quotation_buyer_partner_code" for="x_partner_code" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->partner_code->caption() ?><?php echo ($partner_quotation_buyer->partner_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->partner_code->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_code">
<textarea data-table="partner_quotation_buyer" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" cols="35" rows="3" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->partner_code->getPlaceHolder()) ?>"<?php echo $partner_quotation_buyer->partner_code->editAttributes() ?>><?php echo $partner_quotation_buyer->partner_code->EditValue ?></textarea>
</span>
<?php echo $partner_quotation_buyer->partner_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_partner_quotation_buyer_packing_type" for="x_packing_type" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->packing_type->caption() ?><?php echo ($partner_quotation_buyer->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->packing_type->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_packing_type" data-value-separator="<?php echo $partner_quotation_buyer->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $partner_quotation_buyer->packing_type->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $partner_quotation_buyer->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label id="elh_partner_quotation_buyer_unit" for="x_unit" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->unit->caption() ?><?php echo ($partner_quotation_buyer->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->unit->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_unit" data-value-separator="<?php echo $partner_quotation_buyer->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $partner_quotation_buyer->unit->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
<?php echo $partner_quotation_buyer->unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->quantity_approx->Visible) { // quantity_approx ?>
	<div id="r_quantity_approx" class="form-group row">
		<label id="elh_partner_quotation_buyer_quantity_approx" for="x_quantity_approx" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->quantity_approx->caption() ?><?php echo ($partner_quotation_buyer->quantity_approx->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->quantity_approx->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_quantity_approx">
<input type="text" data-table="partner_quotation_buyer" data-field="x_quantity_approx" name="x_quantity_approx" id="x_quantity_approx" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->quantity_approx->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->quantity_approx->EditValue ?>"<?php echo $partner_quotation_buyer->quantity_approx->editAttributes() ?>>
</span>
<?php echo $partner_quotation_buyer->quantity_approx->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_partner_quotation_buyer_quantity" for="x_quantity" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->quantity->caption() ?><?php echo ($partner_quotation_buyer->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->quantity->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_quantity">
<input type="text" data-table="partner_quotation_buyer" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->quantity->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->quantity->EditValue ?>"<?php echo $partner_quotation_buyer->quantity->editAttributes() ?>>
</span>
<?php echo $partner_quotation_buyer->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_partner_quotation_buyer_price" for="x_price" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->price->caption() ?><?php echo ($partner_quotation_buyer->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->price->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_price">
<input type="text" data-table="partner_quotation_buyer" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->price->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->price->EditValue ?>"<?php echo $partner_quotation_buyer->price->editAttributes() ?>>
</span>
<?php echo $partner_quotation_buyer->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_partner_quotation_buyer_amount" for="x_amount" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->amount->caption() ?><?php echo ($partner_quotation_buyer->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->amount->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_amount">
<input type="text" data-table="partner_quotation_buyer" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->amount->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->amount->EditValue ?>"<?php echo $partner_quotation_buyer->amount->editAttributes() ?>>
</span>
<?php echo $partner_quotation_buyer->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_partner_quotation_buyer_currency" for="x_currency" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->currency->caption() ?><?php echo ($partner_quotation_buyer->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->currency->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_currency" data-value-separator="<?php echo $partner_quotation_buyer->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $partner_quotation_buyer->currency->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
<?php echo $partner_quotation_buyer->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label id="elh_partner_quotation_buyer_total_amount" for="x_total_amount" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->total_amount->caption() ?><?php echo ($partner_quotation_buyer->total_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->total_amount->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_total_amount">
<input type="text" data-table="partner_quotation_buyer" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->total_amount->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->total_amount->EditValue ?>"<?php echo $partner_quotation_buyer->total_amount->editAttributes() ?>>
</span>
<?php echo $partner_quotation_buyer->total_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_partner_quotation_buyer_remarks" for="x_remarks" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->remarks->caption() ?><?php echo ($partner_quotation_buyer->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->remarks->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_remarks">
<input type="text" data-table="partner_quotation_buyer" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->remarks->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->remarks->EditValue ?>"<?php echo $partner_quotation_buyer->remarks->editAttributes() ?>>
</span>
<?php echo $partner_quotation_buyer->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label id="elh_partner_quotation_buyer_payment_terms" for="x_payment_terms" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->payment_terms->caption() ?><?php echo ($partner_quotation_buyer->payment_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->payment_terms->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_payment_terms">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_payment_terms" data-value-separator="<?php echo $partner_quotation_buyer->payment_terms->displayValueSeparatorAttribute() ?>" id="x_payment_terms" name="x_payment_terms"<?php echo $partner_quotation_buyer->payment_terms->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->payment_terms->selectOptionListHtml("x_payment_terms") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->payment_terms->Lookup->getParamTag("p_x_payment_terms") ?>
</span>
<?php echo $partner_quotation_buyer->payment_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->tax_categories->Visible) { // tax_categories ?>
	<div id="r_tax_categories" class="form-group row">
		<label id="elh_partner_quotation_buyer_tax_categories" for="x_tax_categories" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->tax_categories->caption() ?><?php echo ($partner_quotation_buyer->tax_categories->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->tax_categories->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_tax_categories">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_tax_categories" data-value-separator="<?php echo $partner_quotation_buyer->tax_categories->displayValueSeparatorAttribute() ?>" id="x_tax_categories" name="x_tax_categories"<?php echo $partner_quotation_buyer->tax_categories->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->tax_categories->selectOptionListHtml("x_tax_categories") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->tax_categories->Lookup->getParamTag("p_x_tax_categories") ?>
</span>
<?php echo $partner_quotation_buyer->tax_categories->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->delivery_period->Visible) { // delivery_period ?>
	<div id="r_delivery_period" class="form-group row">
		<label id="elh_partner_quotation_buyer_delivery_period" for="x_delivery_period" class="<?php echo $partner_quotation_buyer_add->LeftColumnClass ?>"><?php echo $partner_quotation_buyer->delivery_period->caption() ?><?php echo ($partner_quotation_buyer->delivery_period->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_buyer_add->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->delivery_period->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_delivery_period">
<input type="text" data-table="partner_quotation_buyer" data-field="x_delivery_period" name="x_delivery_period" id="x_delivery_period" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->delivery_period->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->delivery_period->EditValue ?>"<?php echo $partner_quotation_buyer->delivery_period->editAttributes() ?>>
</span>
<?php echo $partner_quotation_buyer->delivery_period->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$partner_quotation_buyer_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $partner_quotation_buyer_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $partner_quotation_buyer_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$partner_quotation_buyer_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$partner_quotation_buyer_add->terminate();
?>