<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_quotation_buyer_list = new partner_quotation_buyer_list();

// Run the page
$partner_quotation_buyer_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_quotation_buyer_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpartner_quotation_buyerlist = currentForm = new ew.Form("fpartner_quotation_buyerlist", "list");
fpartner_quotation_buyerlist.formKeyCountName = '<?php echo $partner_quotation_buyer_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpartner_quotation_buyerlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_quotation_buyerlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_quotation_buyerlist.lists["x_company_id"] = <?php echo $partner_quotation_buyer_list->company_id->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_company_id"].options = <?php echo JsonEncode($partner_quotation_buyer_list->company_id->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_partner_id"] = <?php echo $partner_quotation_buyer_list->partner_id->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_partner_id"].options = <?php echo JsonEncode($partner_quotation_buyer_list->partner_id->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_product_type"] = <?php echo $partner_quotation_buyer_list->product_type->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_product_type"].options = <?php echo JsonEncode($partner_quotation_buyer_list->product_type->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_product"] = <?php echo $partner_quotation_buyer_list->product->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_product"].options = <?php echo JsonEncode($partner_quotation_buyer_list->product->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_product_code"] = <?php echo $partner_quotation_buyer_list->product_code->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_product_code"].options = <?php echo JsonEncode($partner_quotation_buyer_list->product_code->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_packing_type"] = <?php echo $partner_quotation_buyer_list->packing_type->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_packing_type"].options = <?php echo JsonEncode($partner_quotation_buyer_list->packing_type->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_unit"] = <?php echo $partner_quotation_buyer_list->unit->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_unit"].options = <?php echo JsonEncode($partner_quotation_buyer_list->unit->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_currency"] = <?php echo $partner_quotation_buyer_list->currency->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_currency"].options = <?php echo JsonEncode($partner_quotation_buyer_list->currency->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_payment_terms"] = <?php echo $partner_quotation_buyer_list->payment_terms->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_payment_terms"].options = <?php echo JsonEncode($partner_quotation_buyer_list->payment_terms->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_tax_categories"] = <?php echo $partner_quotation_buyer_list->tax_categories->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_tax_categories"].options = <?php echo JsonEncode($partner_quotation_buyer_list->tax_categories->lookupOptions()) ?>;
fpartner_quotation_buyerlist.lists["x_status"] = <?php echo $partner_quotation_buyer_list->status->Lookup->toClientList() ?>;
fpartner_quotation_buyerlist.lists["x_status"].options = <?php echo JsonEncode($partner_quotation_buyer_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fpartner_quotation_buyerlistsrch = currentSearchForm = new ew.Form("fpartner_quotation_buyerlistsrch");

// Filters
fpartner_quotation_buyerlistsrch.filterList = <?php echo $partner_quotation_buyer_list->getFilterList() ?>;

// Init search panel as collapsed
fpartner_quotation_buyerlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($partner_quotation_buyer_list->TotalRecs > 0 && $partner_quotation_buyer_list->ExportOptions->visible()) { ?>
<?php $partner_quotation_buyer_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_quotation_buyer_list->ImportOptions->visible()) { ?>
<?php $partner_quotation_buyer_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_quotation_buyer_list->SearchOptions->visible()) { ?>
<?php $partner_quotation_buyer_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($partner_quotation_buyer_list->FilterOptions->visible()) { ?>
<?php $partner_quotation_buyer_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$partner_quotation_buyer_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$partner_quotation_buyer->isExport() && !$partner_quotation_buyer->CurrentAction) { ?>
<form name="fpartner_quotation_buyerlistsrch" id="fpartner_quotation_buyerlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($partner_quotation_buyer_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpartner_quotation_buyerlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="partner_quotation_buyer">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($partner_quotation_buyer_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($partner_quotation_buyer_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $partner_quotation_buyer_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($partner_quotation_buyer_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($partner_quotation_buyer_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($partner_quotation_buyer_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($partner_quotation_buyer_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $partner_quotation_buyer_list->showPageHeader(); ?>
<?php
$partner_quotation_buyer_list->showMessage();
?>
<?php if ($partner_quotation_buyer_list->TotalRecs > 0 || $partner_quotation_buyer->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($partner_quotation_buyer_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> partner_quotation_buyer">
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$partner_quotation_buyer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_quotation_buyer_list->Pager)) $partner_quotation_buyer_list->Pager = new PrevNextPager($partner_quotation_buyer_list->StartRec, $partner_quotation_buyer_list->DisplayRecs, $partner_quotation_buyer_list->TotalRecs, $partner_quotation_buyer_list->AutoHidePager) ?>
<?php if ($partner_quotation_buyer_list->Pager->RecordCount > 0 && $partner_quotation_buyer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_quotation_buyer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_quotation_buyer_list->pageUrl() ?>start=<?php echo $partner_quotation_buyer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_quotation_buyer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_quotation_buyer_list->pageUrl() ?>start=<?php echo $partner_quotation_buyer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_quotation_buyer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_quotation_buyer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_quotation_buyer_list->pageUrl() ?>start=<?php echo $partner_quotation_buyer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_quotation_buyer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_quotation_buyer_list->pageUrl() ?>start=<?php echo $partner_quotation_buyer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_quotation_buyer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_quotation_buyer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_quotation_buyer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_quotation_buyer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_quotation_buyer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_quotation_buyer_list->TotalRecs > 0 && (!$partner_quotation_buyer_list->AutoHidePageSizeSelector || $partner_quotation_buyer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_quotation_buyer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_quotation_buyer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_quotation_buyer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_quotation_buyer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_quotation_buyer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_quotation_buyer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_quotation_buyer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_quotation_buyer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpartner_quotation_buyerlist" id="fpartner_quotation_buyerlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_quotation_buyer_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_quotation_buyer_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_quotation_buyer">
<div id="gmp_partner_quotation_buyer" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($partner_quotation_buyer_list->TotalRecs > 0 || $partner_quotation_buyer->isGridEdit()) { ?>
<table id="tbl_partner_quotation_buyerlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$partner_quotation_buyer_list->RowType = ROWTYPE_HEADER;

// Render list options
$partner_quotation_buyer_list->renderListOptions();

// Render list options (header, left)
$partner_quotation_buyer_list->ListOptions->render("header", "left");
?>
<?php if ($partner_quotation_buyer->id->Visible) { // id ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->id) == "") { ?>
		<th data-name="id" class="<?php echo $partner_quotation_buyer->id->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_id" class="partner_quotation_buyer_id"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $partner_quotation_buyer->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->id) ?>',2);"><div id="elh_partner_quotation_buyer_id" class="partner_quotation_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->company_id->Visible) { // company_id ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $partner_quotation_buyer->company_id->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_company_id" class="partner_quotation_buyer_company_id"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $partner_quotation_buyer->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->company_id) ?>',2);"><div id="elh_partner_quotation_buyer_company_id" class="partner_quotation_buyer_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_id->Visible) { // partner_id ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $partner_quotation_buyer->partner_id->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_partner_id" class="partner_quotation_buyer_partner_id"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $partner_quotation_buyer->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->partner_id) ?>',2);"><div id="elh_partner_quotation_buyer_partner_id" class="partner_quotation_buyer_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->product_type->Visible) { // product_type ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $partner_quotation_buyer->product_type->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_product_type" class="partner_quotation_buyer_product_type"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $partner_quotation_buyer->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->product_type) ?>',2);"><div id="elh_partner_quotation_buyer_product_type" class="partner_quotation_buyer_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->product->Visible) { // product ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->product) == "") { ?>
		<th data-name="product" class="<?php echo $partner_quotation_buyer->product->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_product" class="partner_quotation_buyer_product"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $partner_quotation_buyer->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->product) ?>',2);"><div id="elh_partner_quotation_buyer_product" class="partner_quotation_buyer_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->product_code->Visible) { // product_code ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $partner_quotation_buyer->product_code->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_product_code" class="partner_quotation_buyer_product_code"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $partner_quotation_buyer->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->product_code) ?>',2);"><div id="elh_partner_quotation_buyer_product_code" class="partner_quotation_buyer_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->product_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_code->Visible) { // partner_code ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->partner_code) == "") { ?>
		<th data-name="partner_code" class="<?php echo $partner_quotation_buyer->partner_code->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_partner_code" class="partner_quotation_buyer_partner_code"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->partner_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_code" class="<?php echo $partner_quotation_buyer->partner_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->partner_code) ?>',2);"><div id="elh_partner_quotation_buyer_partner_code" class="partner_quotation_buyer_partner_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->partner_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->partner_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->partner_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->packing_type->Visible) { // packing_type ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $partner_quotation_buyer->packing_type->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_packing_type" class="partner_quotation_buyer_packing_type"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $partner_quotation_buyer->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->packing_type) ?>',2);"><div id="elh_partner_quotation_buyer_packing_type" class="partner_quotation_buyer_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->unit->Visible) { // unit ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $partner_quotation_buyer->unit->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_unit" class="partner_quotation_buyer_unit"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $partner_quotation_buyer->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->unit) ?>',2);"><div id="elh_partner_quotation_buyer_unit" class="partner_quotation_buyer_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->quantity_approx->Visible) { // quantity_approx ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->quantity_approx) == "") { ?>
		<th data-name="quantity_approx" class="<?php echo $partner_quotation_buyer->quantity_approx->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_quantity_approx" class="partner_quotation_buyer_quantity_approx"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->quantity_approx->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_approx" class="<?php echo $partner_quotation_buyer->quantity_approx->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->quantity_approx) ?>',2);"><div id="elh_partner_quotation_buyer_quantity_approx" class="partner_quotation_buyer_quantity_approx">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->quantity_approx->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->quantity_approx->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->quantity_approx->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->quantity->Visible) { // quantity ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $partner_quotation_buyer->quantity->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_quantity" class="partner_quotation_buyer_quantity"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $partner_quotation_buyer->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->quantity) ?>',2);"><div id="elh_partner_quotation_buyer_quantity" class="partner_quotation_buyer_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->price->Visible) { // price ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->price) == "") { ?>
		<th data-name="price" class="<?php echo $partner_quotation_buyer->price->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_price" class="partner_quotation_buyer_price"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $partner_quotation_buyer->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->price) ?>',2);"><div id="elh_partner_quotation_buyer_price" class="partner_quotation_buyer_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->amount->Visible) { // amount ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $partner_quotation_buyer->amount->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_amount" class="partner_quotation_buyer_amount"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $partner_quotation_buyer->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->amount) ?>',2);"><div id="elh_partner_quotation_buyer_amount" class="partner_quotation_buyer_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->currency->Visible) { // currency ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $partner_quotation_buyer->currency->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_currency" class="partner_quotation_buyer_currency"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $partner_quotation_buyer->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->currency) ?>',2);"><div id="elh_partner_quotation_buyer_currency" class="partner_quotation_buyer_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->total_amount->Visible) { // total_amount ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $partner_quotation_buyer->total_amount->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_total_amount" class="partner_quotation_buyer_total_amount"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $partner_quotation_buyer->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->total_amount) ?>',2);"><div id="elh_partner_quotation_buyer_total_amount" class="partner_quotation_buyer_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->remarks->Visible) { // remarks ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $partner_quotation_buyer->remarks->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_remarks" class="partner_quotation_buyer_remarks"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $partner_quotation_buyer->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->remarks) ?>',2);"><div id="elh_partner_quotation_buyer_remarks" class="partner_quotation_buyer_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->payment_terms->Visible) { // payment_terms ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->payment_terms) == "") { ?>
		<th data-name="payment_terms" class="<?php echo $partner_quotation_buyer->payment_terms->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_payment_terms" class="partner_quotation_buyer_payment_terms"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->payment_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_terms" class="<?php echo $partner_quotation_buyer->payment_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->payment_terms) ?>',2);"><div id="elh_partner_quotation_buyer_payment_terms" class="partner_quotation_buyer_payment_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->payment_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->payment_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->payment_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->tax_categories->Visible) { // tax_categories ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->tax_categories) == "") { ?>
		<th data-name="tax_categories" class="<?php echo $partner_quotation_buyer->tax_categories->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_tax_categories" class="partner_quotation_buyer_tax_categories"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->tax_categories->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tax_categories" class="<?php echo $partner_quotation_buyer->tax_categories->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->tax_categories) ?>',2);"><div id="elh_partner_quotation_buyer_tax_categories" class="partner_quotation_buyer_tax_categories">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->tax_categories->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->tax_categories->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->tax_categories->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->delivery_period->Visible) { // delivery_period ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->delivery_period) == "") { ?>
		<th data-name="delivery_period" class="<?php echo $partner_quotation_buyer->delivery_period->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_delivery_period" class="partner_quotation_buyer_delivery_period"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->delivery_period->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_period" class="<?php echo $partner_quotation_buyer->delivery_period->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->delivery_period) ?>',2);"><div id="elh_partner_quotation_buyer_delivery_period" class="partner_quotation_buyer_delivery_period">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->delivery_period->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->delivery_period->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->delivery_period->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->status->Visible) { // status ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->status) == "") { ?>
		<th data-name="status" class="<?php echo $partner_quotation_buyer->status->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_status" class="partner_quotation_buyer_status"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $partner_quotation_buyer->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->status) ?>',2);"><div id="elh_partner_quotation_buyer_status" class="partner_quotation_buyer_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->operator->Visible) { // operator ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $partner_quotation_buyer->operator->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_operator" class="partner_quotation_buyer_operator"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $partner_quotation_buyer->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->operator) ?>',2);"><div id="elh_partner_quotation_buyer_operator" class="partner_quotation_buyer_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->datetime->Visible) { // datetime ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $partner_quotation_buyer->datetime->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_datetime" class="partner_quotation_buyer_datetime"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $partner_quotation_buyer->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->datetime) ?>',2);"><div id="elh_partner_quotation_buyer_datetime" class="partner_quotation_buyer_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->pp_operator->Visible) { // pp_operator ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->pp_operator) == "") { ?>
		<th data-name="pp_operator" class="<?php echo $partner_quotation_buyer->pp_operator->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_pp_operator" class="partner_quotation_buyer_pp_operator"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->pp_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_operator" class="<?php echo $partner_quotation_buyer->pp_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->pp_operator) ?>',2);"><div id="elh_partner_quotation_buyer_pp_operator" class="partner_quotation_buyer_pp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->pp_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->pp_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->pp_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_buyer->pp_datetime->Visible) { // pp_datetime ?>
	<?php if ($partner_quotation_buyer->sortUrl($partner_quotation_buyer->pp_datetime) == "") { ?>
		<th data-name="pp_datetime" class="<?php echo $partner_quotation_buyer->pp_datetime->headerCellClass() ?>"><div id="elh_partner_quotation_buyer_pp_datetime" class="partner_quotation_buyer_pp_datetime"><div class="ew-table-header-caption"><?php echo $partner_quotation_buyer->pp_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_datetime" class="<?php echo $partner_quotation_buyer->pp_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_buyer->SortUrl($partner_quotation_buyer->pp_datetime) ?>',2);"><div id="elh_partner_quotation_buyer_pp_datetime" class="partner_quotation_buyer_pp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_buyer->pp_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_buyer->pp_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_buyer->pp_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$partner_quotation_buyer_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($partner_quotation_buyer->ExportAll && $partner_quotation_buyer->isExport()) {
	$partner_quotation_buyer_list->StopRec = $partner_quotation_buyer_list->TotalRecs;
} else {

	// Set the last record to display
	if ($partner_quotation_buyer_list->TotalRecs > $partner_quotation_buyer_list->StartRec + $partner_quotation_buyer_list->DisplayRecs - 1)
		$partner_quotation_buyer_list->StopRec = $partner_quotation_buyer_list->StartRec + $partner_quotation_buyer_list->DisplayRecs - 1;
	else
		$partner_quotation_buyer_list->StopRec = $partner_quotation_buyer_list->TotalRecs;
}
$partner_quotation_buyer_list->RecCnt = $partner_quotation_buyer_list->StartRec - 1;
if ($partner_quotation_buyer_list->Recordset && !$partner_quotation_buyer_list->Recordset->EOF) {
	$partner_quotation_buyer_list->Recordset->moveFirst();
	$selectLimit = $partner_quotation_buyer_list->UseSelectLimit;
	if (!$selectLimit && $partner_quotation_buyer_list->StartRec > 1)
		$partner_quotation_buyer_list->Recordset->move($partner_quotation_buyer_list->StartRec - 1);
} elseif (!$partner_quotation_buyer->AllowAddDeleteRow && $partner_quotation_buyer_list->StopRec == 0) {
	$partner_quotation_buyer_list->StopRec = $partner_quotation_buyer->GridAddRowCount;
}

// Initialize aggregate
$partner_quotation_buyer->RowType = ROWTYPE_AGGREGATEINIT;
$partner_quotation_buyer->resetAttributes();
$partner_quotation_buyer_list->renderRow();
while ($partner_quotation_buyer_list->RecCnt < $partner_quotation_buyer_list->StopRec) {
	$partner_quotation_buyer_list->RecCnt++;
	if ($partner_quotation_buyer_list->RecCnt >= $partner_quotation_buyer_list->StartRec) {
		$partner_quotation_buyer_list->RowCnt++;

		// Set up key count
		$partner_quotation_buyer_list->KeyCount = $partner_quotation_buyer_list->RowIndex;

		// Init row class and style
		$partner_quotation_buyer->resetAttributes();
		$partner_quotation_buyer->CssClass = "";
		if ($partner_quotation_buyer->isGridAdd()) {
		} else {
			$partner_quotation_buyer_list->loadRowValues($partner_quotation_buyer_list->Recordset); // Load row values
		}
		$partner_quotation_buyer->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$partner_quotation_buyer->RowAttrs = array_merge($partner_quotation_buyer->RowAttrs, array('data-rowindex'=>$partner_quotation_buyer_list->RowCnt, 'id'=>'r' . $partner_quotation_buyer_list->RowCnt . '_partner_quotation_buyer', 'data-rowtype'=>$partner_quotation_buyer->RowType));

		// Render row
		$partner_quotation_buyer_list->renderRow();

		// Render list options
		$partner_quotation_buyer_list->renderListOptions();
?>
	<tr<?php echo $partner_quotation_buyer->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_quotation_buyer_list->ListOptions->render("body", "left", $partner_quotation_buyer_list->RowCnt);
?>
	<?php if ($partner_quotation_buyer->id->Visible) { // id ?>
		<td data-name="id"<?php echo $partner_quotation_buyer->id->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_id" class="partner_quotation_buyer_id">
<span<?php echo $partner_quotation_buyer->id->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $partner_quotation_buyer->company_id->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_company_id" class="partner_quotation_buyer_company_id">
<span<?php echo $partner_quotation_buyer->company_id->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $partner_quotation_buyer->partner_id->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_partner_id" class="partner_quotation_buyer_partner_id">
<span<?php echo $partner_quotation_buyer->partner_id->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $partner_quotation_buyer->product_type->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_product_type" class="partner_quotation_buyer_product_type">
<span<?php echo $partner_quotation_buyer->product_type->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->product->Visible) { // product ?>
		<td data-name="product"<?php echo $partner_quotation_buyer->product->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_product" class="partner_quotation_buyer_product">
<span<?php echo $partner_quotation_buyer->product->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $partner_quotation_buyer->product_code->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_product_code" class="partner_quotation_buyer_product_code">
<span<?php echo $partner_quotation_buyer->product_code->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->partner_code->Visible) { // partner_code ?>
		<td data-name="partner_code"<?php echo $partner_quotation_buyer->partner_code->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_partner_code" class="partner_quotation_buyer_partner_code">
<span<?php echo $partner_quotation_buyer->partner_code->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->partner_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $partner_quotation_buyer->packing_type->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_packing_type" class="partner_quotation_buyer_packing_type">
<span<?php echo $partner_quotation_buyer->packing_type->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $partner_quotation_buyer->unit->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_unit" class="partner_quotation_buyer_unit">
<span<?php echo $partner_quotation_buyer->unit->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->quantity_approx->Visible) { // quantity_approx ?>
		<td data-name="quantity_approx"<?php echo $partner_quotation_buyer->quantity_approx->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_quantity_approx" class="partner_quotation_buyer_quantity_approx">
<span<?php echo $partner_quotation_buyer->quantity_approx->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->quantity_approx->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $partner_quotation_buyer->quantity->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_quantity" class="partner_quotation_buyer_quantity">
<span<?php echo $partner_quotation_buyer->quantity->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->price->Visible) { // price ?>
		<td data-name="price"<?php echo $partner_quotation_buyer->price->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_price" class="partner_quotation_buyer_price">
<span<?php echo $partner_quotation_buyer->price->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $partner_quotation_buyer->amount->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_amount" class="partner_quotation_buyer_amount">
<span<?php echo $partner_quotation_buyer->amount->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $partner_quotation_buyer->currency->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_currency" class="partner_quotation_buyer_currency">
<span<?php echo $partner_quotation_buyer->currency->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $partner_quotation_buyer->total_amount->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_total_amount" class="partner_quotation_buyer_total_amount">
<span<?php echo $partner_quotation_buyer->total_amount->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->total_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $partner_quotation_buyer->remarks->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_remarks" class="partner_quotation_buyer_remarks">
<span<?php echo $partner_quotation_buyer->remarks->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->payment_terms->Visible) { // payment_terms ?>
		<td data-name="payment_terms"<?php echo $partner_quotation_buyer->payment_terms->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_payment_terms" class="partner_quotation_buyer_payment_terms">
<span<?php echo $partner_quotation_buyer->payment_terms->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->payment_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->tax_categories->Visible) { // tax_categories ?>
		<td data-name="tax_categories"<?php echo $partner_quotation_buyer->tax_categories->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_tax_categories" class="partner_quotation_buyer_tax_categories">
<span<?php echo $partner_quotation_buyer->tax_categories->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->tax_categories->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->delivery_period->Visible) { // delivery_period ?>
		<td data-name="delivery_period"<?php echo $partner_quotation_buyer->delivery_period->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_delivery_period" class="partner_quotation_buyer_delivery_period">
<span<?php echo $partner_quotation_buyer->delivery_period->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->delivery_period->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->status->Visible) { // status ?>
		<td data-name="status"<?php echo $partner_quotation_buyer->status->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_status" class="partner_quotation_buyer_status">
<span<?php echo $partner_quotation_buyer->status->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $partner_quotation_buyer->operator->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_operator" class="partner_quotation_buyer_operator">
<span<?php echo $partner_quotation_buyer->operator->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $partner_quotation_buyer->datetime->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_datetime" class="partner_quotation_buyer_datetime">
<span<?php echo $partner_quotation_buyer->datetime->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->pp_operator->Visible) { // pp_operator ?>
		<td data-name="pp_operator"<?php echo $partner_quotation_buyer->pp_operator->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_pp_operator" class="partner_quotation_buyer_pp_operator">
<span<?php echo $partner_quotation_buyer->pp_operator->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->pp_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_buyer->pp_datetime->Visible) { // pp_datetime ?>
		<td data-name="pp_datetime"<?php echo $partner_quotation_buyer->pp_datetime->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_buyer_list->RowCnt ?>_partner_quotation_buyer_pp_datetime" class="partner_quotation_buyer_pp_datetime">
<span<?php echo $partner_quotation_buyer->pp_datetime->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->pp_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$partner_quotation_buyer_list->ListOptions->render("body", "right", $partner_quotation_buyer_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$partner_quotation_buyer->isGridAdd())
		$partner_quotation_buyer_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$partner_quotation_buyer->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($partner_quotation_buyer_list->Recordset)
	$partner_quotation_buyer_list->Recordset->Close();
?>
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$partner_quotation_buyer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_quotation_buyer_list->Pager)) $partner_quotation_buyer_list->Pager = new PrevNextPager($partner_quotation_buyer_list->StartRec, $partner_quotation_buyer_list->DisplayRecs, $partner_quotation_buyer_list->TotalRecs, $partner_quotation_buyer_list->AutoHidePager) ?>
<?php if ($partner_quotation_buyer_list->Pager->RecordCount > 0 && $partner_quotation_buyer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_quotation_buyer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_quotation_buyer_list->pageUrl() ?>start=<?php echo $partner_quotation_buyer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_quotation_buyer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_quotation_buyer_list->pageUrl() ?>start=<?php echo $partner_quotation_buyer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_quotation_buyer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_quotation_buyer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_quotation_buyer_list->pageUrl() ?>start=<?php echo $partner_quotation_buyer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_quotation_buyer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_quotation_buyer_list->pageUrl() ?>start=<?php echo $partner_quotation_buyer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_quotation_buyer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_quotation_buyer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_quotation_buyer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_quotation_buyer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_quotation_buyer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_quotation_buyer_list->TotalRecs > 0 && (!$partner_quotation_buyer_list->AutoHidePageSizeSelector || $partner_quotation_buyer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_quotation_buyer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_quotation_buyer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_quotation_buyer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_quotation_buyer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_quotation_buyer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_quotation_buyer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_quotation_buyer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_quotation_buyer_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($partner_quotation_buyer_list->TotalRecs == 0 && !$partner_quotation_buyer->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $partner_quotation_buyer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$partner_quotation_buyer_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<script>
ew.scrollableTable("gmp_partner_quotation_buyer", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$partner_quotation_buyer_list->terminate();
?>