<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_quotation_buyer_search = new partner_quotation_buyer_search();

// Run the page
$partner_quotation_buyer_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_quotation_buyer_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($partner_quotation_buyer_search->IsModal) { ?>
var fpartner_quotation_buyersearch = currentAdvancedSearchForm = new ew.Form("fpartner_quotation_buyersearch", "search");
<?php } else { ?>
var fpartner_quotation_buyersearch = currentForm = new ew.Form("fpartner_quotation_buyersearch", "search");
<?php } ?>

// Form_CustomValidate event
fpartner_quotation_buyersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_quotation_buyersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_quotation_buyersearch.lists["x_company_id"] = <?php echo $partner_quotation_buyer_search->company_id->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_company_id"].options = <?php echo JsonEncode($partner_quotation_buyer_search->company_id->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_partner_id"] = <?php echo $partner_quotation_buyer_search->partner_id->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_partner_id"].options = <?php echo JsonEncode($partner_quotation_buyer_search->partner_id->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_product_type"] = <?php echo $partner_quotation_buyer_search->product_type->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_product_type"].options = <?php echo JsonEncode($partner_quotation_buyer_search->product_type->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_product"] = <?php echo $partner_quotation_buyer_search->product->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_product"].options = <?php echo JsonEncode($partner_quotation_buyer_search->product->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_product_code"] = <?php echo $partner_quotation_buyer_search->product_code->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_product_code"].options = <?php echo JsonEncode($partner_quotation_buyer_search->product_code->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_packing_type"] = <?php echo $partner_quotation_buyer_search->packing_type->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_packing_type"].options = <?php echo JsonEncode($partner_quotation_buyer_search->packing_type->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_unit"] = <?php echo $partner_quotation_buyer_search->unit->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_unit"].options = <?php echo JsonEncode($partner_quotation_buyer_search->unit->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_currency"] = <?php echo $partner_quotation_buyer_search->currency->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_currency"].options = <?php echo JsonEncode($partner_quotation_buyer_search->currency->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_payment_terms"] = <?php echo $partner_quotation_buyer_search->payment_terms->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_payment_terms"].options = <?php echo JsonEncode($partner_quotation_buyer_search->payment_terms->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_tax_categories"] = <?php echo $partner_quotation_buyer_search->tax_categories->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_tax_categories"].options = <?php echo JsonEncode($partner_quotation_buyer_search->tax_categories->lookupOptions()) ?>;
fpartner_quotation_buyersearch.lists["x_status"] = <?php echo $partner_quotation_buyer_search->status->Lookup->toClientList() ?>;
fpartner_quotation_buyersearch.lists["x_status"].options = <?php echo JsonEncode($partner_quotation_buyer_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fpartner_quotation_buyersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->total_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_delivery_period");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->delivery_period->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pp_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->pp_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pp_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($partner_quotation_buyer->pp_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $partner_quotation_buyer_search->showPageHeader(); ?>
<?php
$partner_quotation_buyer_search->showMessage();
?>
<form name="fpartner_quotation_buyersearch" id="fpartner_quotation_buyersearch" class="<?php echo $partner_quotation_buyer_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_quotation_buyer_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_quotation_buyer_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_quotation_buyer">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$partner_quotation_buyer_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($partner_quotation_buyer->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_id"><?php echo $partner_quotation_buyer->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->id->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_id">
<input type="text" data-table="partner_quotation_buyer" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->id->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->id->EditValue ?>"<?php echo $partner_quotation_buyer->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_company_id"><?php echo $partner_quotation_buyer->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->company_id->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_company_id" data-value-separator="<?php echo $partner_quotation_buyer->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $partner_quotation_buyer->company_id->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label for="x_partner_id" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_id"><?php echo $partner_quotation_buyer->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->partner_id->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_partner_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_partner_id" data-value-separator="<?php echo $partner_quotation_buyer->partner_id->displayValueSeparatorAttribute() ?>" id="x_partner_id" name="x_partner_id"<?php echo $partner_quotation_buyer->partner_id->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->partner_id->selectOptionListHtml("x_partner_id") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_details->Visible) { // partner_details ?>
	<div id="r_partner_details" class="form-group row">
		<label for="x_partner_details" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_details"><?php echo $partner_quotation_buyer->partner_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_details" id="z_partner_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->partner_details->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_partner_details">
<input type="text" data-table="partner_quotation_buyer" data-field="x_partner_details" name="x_partner_details" id="x_partner_details" size="35" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->partner_details->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->partner_details->EditValue ?>"<?php echo $partner_quotation_buyer->partner_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product_type"><?php echo $partner_quotation_buyer->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->product_type->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_product_type">
<?php $partner_quotation_buyer->product_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_quotation_buyer->product_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_product_type" data-value-separator="<?php echo $partner_quotation_buyer->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $partner_quotation_buyer->product_type->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product"><?php echo $partner_quotation_buyer->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->product->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_product">
<?php $partner_quotation_buyer->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$partner_quotation_buyer->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_product" data-value-separator="<?php echo $partner_quotation_buyer->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $partner_quotation_buyer->product->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product_code"><?php echo $partner_quotation_buyer->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_code" id="z_product_code" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->product_code->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_product_code">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_product_code" data-value-separator="<?php echo $partner_quotation_buyer->product_code->displayValueSeparatorAttribute() ?>" id="x_product_code" name="x_product_code"<?php echo $partner_quotation_buyer->product_code->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->product_code->selectOptionListHtml("x_product_code") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->product_code->Lookup->getParamTag("p_x_product_code") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_code->Visible) { // partner_code ?>
	<div id="r_partner_code" class="form-group row">
		<label for="x_partner_code" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_code"><?php echo $partner_quotation_buyer->partner_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_code" id="z_partner_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->partner_code->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_partner_code">
<input type="text" data-table="partner_quotation_buyer" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" maxlength="48" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->partner_code->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->partner_code->EditValue ?>"<?php echo $partner_quotation_buyer->partner_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_packing_type"><?php echo $partner_quotation_buyer->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->packing_type->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_packing_type" data-value-separator="<?php echo $partner_quotation_buyer->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $partner_quotation_buyer->packing_type->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_unit"><?php echo $partner_quotation_buyer->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->unit->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_unit" data-value-separator="<?php echo $partner_quotation_buyer->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $partner_quotation_buyer->unit->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->quantity_approx->Visible) { // quantity_approx ?>
	<div id="r_quantity_approx" class="form-group row">
		<label for="x_quantity_approx" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_quantity_approx"><?php echo $partner_quotation_buyer->quantity_approx->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_quantity_approx" id="z_quantity_approx" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->quantity_approx->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_quantity_approx">
<input type="text" data-table="partner_quotation_buyer" data-field="x_quantity_approx" name="x_quantity_approx" id="x_quantity_approx" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->quantity_approx->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->quantity_approx->EditValue ?>"<?php echo $partner_quotation_buyer->quantity_approx->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_quantity"><?php echo $partner_quotation_buyer->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->quantity->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_quantity">
<input type="text" data-table="partner_quotation_buyer" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->quantity->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->quantity->EditValue ?>"<?php echo $partner_quotation_buyer->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_price"><?php echo $partner_quotation_buyer->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->price->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_price">
<input type="text" data-table="partner_quotation_buyer" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->price->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->price->EditValue ?>"<?php echo $partner_quotation_buyer->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_amount"><?php echo $partner_quotation_buyer->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->amount->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_amount">
<input type="text" data-table="partner_quotation_buyer" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->amount->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->amount->EditValue ?>"<?php echo $partner_quotation_buyer->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_currency"><?php echo $partner_quotation_buyer->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->currency->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_currency" data-value-separator="<?php echo $partner_quotation_buyer->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $partner_quotation_buyer->currency->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_total_amount"><?php echo $partner_quotation_buyer->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->total_amount->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_total_amount">
<input type="text" data-table="partner_quotation_buyer" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->total_amount->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->total_amount->EditValue ?>"<?php echo $partner_quotation_buyer->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_remarks"><?php echo $partner_quotation_buyer->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->remarks->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_remarks">
<input type="text" data-table="partner_quotation_buyer" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->remarks->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->remarks->EditValue ?>"<?php echo $partner_quotation_buyer->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label for="x_payment_terms" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_payment_terms"><?php echo $partner_quotation_buyer->payment_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment_terms" id="z_payment_terms" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->payment_terms->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_payment_terms">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_payment_terms" data-value-separator="<?php echo $partner_quotation_buyer->payment_terms->displayValueSeparatorAttribute() ?>" id="x_payment_terms" name="x_payment_terms"<?php echo $partner_quotation_buyer->payment_terms->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->payment_terms->selectOptionListHtml("x_payment_terms") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->payment_terms->Lookup->getParamTag("p_x_payment_terms") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->tax_categories->Visible) { // tax_categories ?>
	<div id="r_tax_categories" class="form-group row">
		<label for="x_tax_categories" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_tax_categories"><?php echo $partner_quotation_buyer->tax_categories->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tax_categories" id="z_tax_categories" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->tax_categories->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_tax_categories">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_tax_categories" data-value-separator="<?php echo $partner_quotation_buyer->tax_categories->displayValueSeparatorAttribute() ?>" id="x_tax_categories" name="x_tax_categories"<?php echo $partner_quotation_buyer->tax_categories->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->tax_categories->selectOptionListHtml("x_tax_categories") ?>
	</select>
</div>
<?php echo $partner_quotation_buyer->tax_categories->Lookup->getParamTag("p_x_tax_categories") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->delivery_period->Visible) { // delivery_period ?>
	<div id="r_delivery_period" class="form-group row">
		<label for="x_delivery_period" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_delivery_period"><?php echo $partner_quotation_buyer->delivery_period->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delivery_period" id="z_delivery_period" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->delivery_period->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_delivery_period">
<input type="text" data-table="partner_quotation_buyer" data-field="x_delivery_period" name="x_delivery_period" id="x_delivery_period" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->delivery_period->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->delivery_period->EditValue ?>"<?php echo $partner_quotation_buyer->delivery_period->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_status"><?php echo $partner_quotation_buyer->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->status->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="partner_quotation_buyer" data-field="x_status" data-value-separator="<?php echo $partner_quotation_buyer->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $partner_quotation_buyer->status->editAttributes() ?>>
		<?php echo $partner_quotation_buyer->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_operator"><?php echo $partner_quotation_buyer->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->operator->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_operator">
<input type="text" data-table="partner_quotation_buyer" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->operator->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->operator->EditValue ?>"<?php echo $partner_quotation_buyer->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_datetime"><?php echo $partner_quotation_buyer->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->datetime->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_datetime">
<input type="text" data-table="partner_quotation_buyer" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->datetime->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->datetime->EditValue ?>"<?php echo $partner_quotation_buyer->datetime->editAttributes() ?>>
<?php if (!$partner_quotation_buyer->datetime->ReadOnly && !$partner_quotation_buyer->datetime->Disabled && !isset($partner_quotation_buyer->datetime->EditAttrs["readonly"]) && !isset($partner_quotation_buyer->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_quotation_buyersearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->pp_operator->Visible) { // pp_operator ?>
	<div id="r_pp_operator" class="form-group row">
		<label for="x_pp_operator" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_pp_operator"><?php echo $partner_quotation_buyer->pp_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pp_operator" id="z_pp_operator" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->pp_operator->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_pp_operator">
<input type="text" data-table="partner_quotation_buyer" data-field="x_pp_operator" name="x_pp_operator" id="x_pp_operator" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->pp_operator->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->pp_operator->EditValue ?>"<?php echo $partner_quotation_buyer->pp_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_buyer->pp_datetime->Visible) { // pp_datetime ?>
	<div id="r_pp_datetime" class="form-group row">
		<label for="x_pp_datetime" class="<?php echo $partner_quotation_buyer_search->LeftColumnClass ?>"><span id="elh_partner_quotation_buyer_pp_datetime"><?php echo $partner_quotation_buyer->pp_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pp_datetime" id="z_pp_datetime" value="="></span>
		</label>
		<div class="<?php echo $partner_quotation_buyer_search->RightColumnClass ?>"><div<?php echo $partner_quotation_buyer->pp_datetime->cellAttributes() ?>>
			<span id="el_partner_quotation_buyer_pp_datetime">
<input type="text" data-table="partner_quotation_buyer" data-field="x_pp_datetime" name="x_pp_datetime" id="x_pp_datetime" placeholder="<?php echo HtmlEncode($partner_quotation_buyer->pp_datetime->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_buyer->pp_datetime->EditValue ?>"<?php echo $partner_quotation_buyer->pp_datetime->editAttributes() ?>>
<?php if (!$partner_quotation_buyer->pp_datetime->ReadOnly && !$partner_quotation_buyer->pp_datetime->Disabled && !isset($partner_quotation_buyer->pp_datetime->EditAttrs["readonly"]) && !isset($partner_quotation_buyer->pp_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_quotation_buyersearch", "x_pp_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$partner_quotation_buyer_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $partner_quotation_buyer_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$partner_quotation_buyer_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$partner_quotation_buyer_search->terminate();
?>