<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_quotation_buyer_view = new partner_quotation_buyer_view();

// Run the page
$partner_quotation_buyer_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_quotation_buyer_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpartner_quotation_buyerview = currentForm = new ew.Form("fpartner_quotation_buyerview", "view");

// Form_CustomValidate event
fpartner_quotation_buyerview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_quotation_buyerview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpartner_quotation_buyerview.lists["x_company_id"] = <?php echo $partner_quotation_buyer_view->company_id->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_company_id"].options = <?php echo JsonEncode($partner_quotation_buyer_view->company_id->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_partner_id"] = <?php echo $partner_quotation_buyer_view->partner_id->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_partner_id"].options = <?php echo JsonEncode($partner_quotation_buyer_view->partner_id->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_product_type"] = <?php echo $partner_quotation_buyer_view->product_type->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_product_type"].options = <?php echo JsonEncode($partner_quotation_buyer_view->product_type->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_product"] = <?php echo $partner_quotation_buyer_view->product->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_product"].options = <?php echo JsonEncode($partner_quotation_buyer_view->product->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_product_code"] = <?php echo $partner_quotation_buyer_view->product_code->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_product_code"].options = <?php echo JsonEncode($partner_quotation_buyer_view->product_code->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_packing_type"] = <?php echo $partner_quotation_buyer_view->packing_type->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_packing_type"].options = <?php echo JsonEncode($partner_quotation_buyer_view->packing_type->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_unit"] = <?php echo $partner_quotation_buyer_view->unit->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_unit"].options = <?php echo JsonEncode($partner_quotation_buyer_view->unit->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_currency"] = <?php echo $partner_quotation_buyer_view->currency->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_currency"].options = <?php echo JsonEncode($partner_quotation_buyer_view->currency->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_payment_terms"] = <?php echo $partner_quotation_buyer_view->payment_terms->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_payment_terms"].options = <?php echo JsonEncode($partner_quotation_buyer_view->payment_terms->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_tax_categories"] = <?php echo $partner_quotation_buyer_view->tax_categories->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_tax_categories"].options = <?php echo JsonEncode($partner_quotation_buyer_view->tax_categories->lookupOptions()) ?>;
fpartner_quotation_buyerview.lists["x_status"] = <?php echo $partner_quotation_buyer_view->status->Lookup->toClientList() ?>;
fpartner_quotation_buyerview.lists["x_status"].options = <?php echo JsonEncode($partner_quotation_buyer_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $partner_quotation_buyer_view->ExportOptions->render("body") ?>
<?php $partner_quotation_buyer_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $partner_quotation_buyer_view->showPageHeader(); ?>
<?php
$partner_quotation_buyer_view->showMessage();
?>
<form name="fpartner_quotation_buyerview" id="fpartner_quotation_buyerview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_quotation_buyer_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_quotation_buyer_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_quotation_buyer">
<input type="hidden" name="modal" value="<?php echo (int)$partner_quotation_buyer_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($partner_quotation_buyer->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_id"><?php echo $partner_quotation_buyer->id->caption() ?></span></td>
		<td data-name="id"<?php echo $partner_quotation_buyer->id->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_id">
<span<?php echo $partner_quotation_buyer->id->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_company_id"><?php echo $partner_quotation_buyer->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $partner_quotation_buyer->company_id->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_company_id">
<span<?php echo $partner_quotation_buyer->company_id->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_id->Visible) { // partner_id ?>
	<tr id="r_partner_id">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_id"><?php echo $partner_quotation_buyer->partner_id->caption() ?></span></td>
		<td data-name="partner_id"<?php echo $partner_quotation_buyer->partner_id->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_id">
<span<?php echo $partner_quotation_buyer->partner_id->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->partner_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_details->Visible) { // partner_details ?>
	<tr id="r_partner_details">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_details"><?php echo $partner_quotation_buyer->partner_details->caption() ?></span></td>
		<td data-name="partner_details"<?php echo $partner_quotation_buyer->partner_details->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_details">
<span<?php echo $partner_quotation_buyer->partner_details->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->partner_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->product_type->Visible) { // product_type ?>
	<tr id="r_product_type">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product_type"><?php echo $partner_quotation_buyer->product_type->caption() ?></span></td>
		<td data-name="product_type"<?php echo $partner_quotation_buyer->product_type->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product_type">
<span<?php echo $partner_quotation_buyer->product_type->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->product_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product"><?php echo $partner_quotation_buyer->product->caption() ?></span></td>
		<td data-name="product"<?php echo $partner_quotation_buyer->product->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product">
<span<?php echo $partner_quotation_buyer->product->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->product->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_product_code"><?php echo $partner_quotation_buyer->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $partner_quotation_buyer->product_code->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_product_code">
<span<?php echo $partner_quotation_buyer->product_code->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->product_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->partner_code->Visible) { // partner_code ?>
	<tr id="r_partner_code">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_partner_code"><?php echo $partner_quotation_buyer->partner_code->caption() ?></span></td>
		<td data-name="partner_code"<?php echo $partner_quotation_buyer->partner_code->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_partner_code">
<span<?php echo $partner_quotation_buyer->partner_code->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->partner_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_packing_type"><?php echo $partner_quotation_buyer->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $partner_quotation_buyer->packing_type->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_packing_type">
<span<?php echo $partner_quotation_buyer->packing_type->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->unit->Visible) { // unit ?>
	<tr id="r_unit">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_unit"><?php echo $partner_quotation_buyer->unit->caption() ?></span></td>
		<td data-name="unit"<?php echo $partner_quotation_buyer->unit->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_unit">
<span<?php echo $partner_quotation_buyer->unit->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->unit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->quantity_approx->Visible) { // quantity_approx ?>
	<tr id="r_quantity_approx">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_quantity_approx"><?php echo $partner_quotation_buyer->quantity_approx->caption() ?></span></td>
		<td data-name="quantity_approx"<?php echo $partner_quotation_buyer->quantity_approx->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_quantity_approx">
<span<?php echo $partner_quotation_buyer->quantity_approx->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->quantity_approx->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_quantity"><?php echo $partner_quotation_buyer->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $partner_quotation_buyer->quantity->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_quantity">
<span<?php echo $partner_quotation_buyer->quantity->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->price->Visible) { // price ?>
	<tr id="r_price">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_price"><?php echo $partner_quotation_buyer->price->caption() ?></span></td>
		<td data-name="price"<?php echo $partner_quotation_buyer->price->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_price">
<span<?php echo $partner_quotation_buyer->price->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_amount"><?php echo $partner_quotation_buyer->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $partner_quotation_buyer->amount->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_amount">
<span<?php echo $partner_quotation_buyer->amount->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->currency->Visible) { // currency ?>
	<tr id="r_currency">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_currency"><?php echo $partner_quotation_buyer->currency->caption() ?></span></td>
		<td data-name="currency"<?php echo $partner_quotation_buyer->currency->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_currency">
<span<?php echo $partner_quotation_buyer->currency->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->total_amount->Visible) { // total_amount ?>
	<tr id="r_total_amount">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_total_amount"><?php echo $partner_quotation_buyer->total_amount->caption() ?></span></td>
		<td data-name="total_amount"<?php echo $partner_quotation_buyer->total_amount->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_total_amount">
<span<?php echo $partner_quotation_buyer->total_amount->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->total_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_remarks"><?php echo $partner_quotation_buyer->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $partner_quotation_buyer->remarks->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_remarks">
<span<?php echo $partner_quotation_buyer->remarks->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->payment_terms->Visible) { // payment_terms ?>
	<tr id="r_payment_terms">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_payment_terms"><?php echo $partner_quotation_buyer->payment_terms->caption() ?></span></td>
		<td data-name="payment_terms"<?php echo $partner_quotation_buyer->payment_terms->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_payment_terms">
<span<?php echo $partner_quotation_buyer->payment_terms->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->payment_terms->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->tax_categories->Visible) { // tax_categories ?>
	<tr id="r_tax_categories">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_tax_categories"><?php echo $partner_quotation_buyer->tax_categories->caption() ?></span></td>
		<td data-name="tax_categories"<?php echo $partner_quotation_buyer->tax_categories->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_tax_categories">
<span<?php echo $partner_quotation_buyer->tax_categories->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->tax_categories->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->delivery_period->Visible) { // delivery_period ?>
	<tr id="r_delivery_period">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_delivery_period"><?php echo $partner_quotation_buyer->delivery_period->caption() ?></span></td>
		<td data-name="delivery_period"<?php echo $partner_quotation_buyer->delivery_period->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_delivery_period">
<span<?php echo $partner_quotation_buyer->delivery_period->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->delivery_period->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_status"><?php echo $partner_quotation_buyer->status->caption() ?></span></td>
		<td data-name="status"<?php echo $partner_quotation_buyer->status->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_status">
<span<?php echo $partner_quotation_buyer->status->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_operator"><?php echo $partner_quotation_buyer->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $partner_quotation_buyer->operator->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_operator">
<span<?php echo $partner_quotation_buyer->operator->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_datetime"><?php echo $partner_quotation_buyer->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $partner_quotation_buyer->datetime->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_datetime">
<span<?php echo $partner_quotation_buyer->datetime->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->pp_operator->Visible) { // pp_operator ?>
	<tr id="r_pp_operator">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_pp_operator"><?php echo $partner_quotation_buyer->pp_operator->caption() ?></span></td>
		<td data-name="pp_operator"<?php echo $partner_quotation_buyer->pp_operator->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_pp_operator">
<span<?php echo $partner_quotation_buyer->pp_operator->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->pp_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($partner_quotation_buyer->pp_datetime->Visible) { // pp_datetime ?>
	<tr id="r_pp_datetime">
		<td class="<?php echo $partner_quotation_buyer_view->TableLeftColumnClass ?>"><span id="elh_partner_quotation_buyer_pp_datetime"><?php echo $partner_quotation_buyer->pp_datetime->caption() ?></span></td>
		<td data-name="pp_datetime"<?php echo $partner_quotation_buyer->pp_datetime->cellAttributes() ?>>
<span id="el_partner_quotation_buyer_pp_datetime">
<span<?php echo $partner_quotation_buyer->pp_datetime->viewAttributes() ?>>
<?php echo $partner_quotation_buyer->pp_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$partner_quotation_buyer_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$partner_quotation_buyer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$partner_quotation_buyer_view->terminate();
?>