<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_quotation_pp_add = new partner_quotation_pp_add();

// Run the page
$partner_quotation_pp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_quotation_pp_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpartner_quotation_ppadd = currentForm = new ew.Form("fpartner_quotation_ppadd", "add");

// Validate form
fpartner_quotation_ppadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($partner_quotation_pp_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->company_id->caption(), $partner_quotation_pp->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->company_id->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->partner_id->caption(), $partner_quotation_pp->partner_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->partner_id->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->product_type->caption(), $partner_quotation_pp->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->product_type->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->product->caption(), $partner_quotation_pp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->product->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->product_code->caption(), $partner_quotation_pp->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->product_code->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->partner_code->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->partner_code->caption(), $partner_quotation_pp->partner_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_pp_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->packing_type->caption(), $partner_quotation_pp->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->packing_type->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->unit->caption(), $partner_quotation_pp->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->unit->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->quantity->caption(), $partner_quotation_pp->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->quantity->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->price->caption(), $partner_quotation_pp->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->price->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->amount->caption(), $partner_quotation_pp->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->amount->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->currency->caption(), $partner_quotation_pp->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->currency->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->total_amount->caption(), $partner_quotation_pp->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->total_amount->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->remarks->caption(), $partner_quotation_pp->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($partner_quotation_pp_add->payment_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->payment_terms->caption(), $partner_quotation_pp->payment_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->payment_terms->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->tax_categories->Required) { ?>
			elm = this.getElements("x" + infix + "_tax_categories");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->tax_categories->caption(), $partner_quotation_pp->tax_categories->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_tax_categories");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->tax_categories->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->delivery_period->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_period");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->delivery_period->caption(), $partner_quotation_pp->delivery_period->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_delivery_period");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->delivery_period->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->operator->caption(), $partner_quotation_pp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->operator->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->datetime->caption(), $partner_quotation_pp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->datetime->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->status->caption(), $partner_quotation_pp->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->status->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->pp_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->pp_operator->caption(), $partner_quotation_pp->pp_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pp_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->pp_operator->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->pp_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->pp_datetime->caption(), $partner_quotation_pp->pp_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pp_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($partner_quotation_pp->pp_datetime->errorMessage()) ?>");
		<?php if ($partner_quotation_pp_add->quantity_approx->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_approx");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $partner_quotation_pp->quantity_approx->caption(), $partner_quotation_pp->quantity_approx->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpartner_quotation_ppadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_quotation_ppadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $partner_quotation_pp_add->showPageHeader(); ?>
<?php
$partner_quotation_pp_add->showMessage();
?>
<form name="fpartner_quotation_ppadd" id="fpartner_quotation_ppadd" class="<?php echo $partner_quotation_pp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_quotation_pp_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_quotation_pp_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_quotation_pp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$partner_quotation_pp_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($partner_quotation_pp->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_partner_quotation_pp_company_id" for="x_company_id" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->company_id->caption() ?><?php echo ($partner_quotation_pp->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->company_id->cellAttributes() ?>>
<span id="el_partner_quotation_pp_company_id">
<input type="text" data-table="partner_quotation_pp" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->company_id->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->company_id->EditValue ?>"<?php echo $partner_quotation_pp->company_id->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label id="elh_partner_quotation_pp_partner_id" for="x_partner_id" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->partner_id->caption() ?><?php echo ($partner_quotation_pp->partner_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->partner_id->cellAttributes() ?>>
<span id="el_partner_quotation_pp_partner_id">
<input type="text" data-table="partner_quotation_pp" data-field="x_partner_id" name="x_partner_id" id="x_partner_id" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->partner_id->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->partner_id->EditValue ?>"<?php echo $partner_quotation_pp->partner_id->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->partner_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_partner_quotation_pp_product_type" for="x_product_type" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->product_type->caption() ?><?php echo ($partner_quotation_pp->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->product_type->cellAttributes() ?>>
<span id="el_partner_quotation_pp_product_type">
<input type="text" data-table="partner_quotation_pp" data-field="x_product_type" name="x_product_type" id="x_product_type" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->product_type->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->product_type->EditValue ?>"<?php echo $partner_quotation_pp->product_type->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_partner_quotation_pp_product" for="x_product" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->product->caption() ?><?php echo ($partner_quotation_pp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->product->cellAttributes() ?>>
<span id="el_partner_quotation_pp_product">
<input type="text" data-table="partner_quotation_pp" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->product->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->product->EditValue ?>"<?php echo $partner_quotation_pp->product->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label id="elh_partner_quotation_pp_product_code" for="x_product_code" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->product_code->caption() ?><?php echo ($partner_quotation_pp->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->product_code->cellAttributes() ?>>
<span id="el_partner_quotation_pp_product_code">
<input type="text" data-table="partner_quotation_pp" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->product_code->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->product_code->EditValue ?>"<?php echo $partner_quotation_pp->product_code->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->partner_code->Visible) { // partner_code ?>
	<div id="r_partner_code" class="form-group row">
		<label id="elh_partner_quotation_pp_partner_code" for="x_partner_code" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->partner_code->caption() ?><?php echo ($partner_quotation_pp->partner_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->partner_code->cellAttributes() ?>>
<span id="el_partner_quotation_pp_partner_code">
<input type="text" data-table="partner_quotation_pp" data-field="x_partner_code" name="x_partner_code" id="x_partner_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_quotation_pp->partner_code->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->partner_code->EditValue ?>"<?php echo $partner_quotation_pp->partner_code->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->partner_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_partner_quotation_pp_packing_type" for="x_packing_type" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->packing_type->caption() ?><?php echo ($partner_quotation_pp->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->packing_type->cellAttributes() ?>>
<span id="el_partner_quotation_pp_packing_type">
<input type="text" data-table="partner_quotation_pp" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->packing_type->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->packing_type->EditValue ?>"<?php echo $partner_quotation_pp->packing_type->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label id="elh_partner_quotation_pp_unit" for="x_unit" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->unit->caption() ?><?php echo ($partner_quotation_pp->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->unit->cellAttributes() ?>>
<span id="el_partner_quotation_pp_unit">
<input type="text" data-table="partner_quotation_pp" data-field="x_unit" name="x_unit" id="x_unit" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->unit->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->unit->EditValue ?>"<?php echo $partner_quotation_pp->unit->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_partner_quotation_pp_quantity" for="x_quantity" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->quantity->caption() ?><?php echo ($partner_quotation_pp->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->quantity->cellAttributes() ?>>
<span id="el_partner_quotation_pp_quantity">
<input type="text" data-table="partner_quotation_pp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->quantity->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->quantity->EditValue ?>"<?php echo $partner_quotation_pp->quantity->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_partner_quotation_pp_price" for="x_price" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->price->caption() ?><?php echo ($partner_quotation_pp->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->price->cellAttributes() ?>>
<span id="el_partner_quotation_pp_price">
<input type="text" data-table="partner_quotation_pp" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->price->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->price->EditValue ?>"<?php echo $partner_quotation_pp->price->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_partner_quotation_pp_amount" for="x_amount" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->amount->caption() ?><?php echo ($partner_quotation_pp->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->amount->cellAttributes() ?>>
<span id="el_partner_quotation_pp_amount">
<input type="text" data-table="partner_quotation_pp" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->amount->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->amount->EditValue ?>"<?php echo $partner_quotation_pp->amount->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_partner_quotation_pp_currency" for="x_currency" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->currency->caption() ?><?php echo ($partner_quotation_pp->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->currency->cellAttributes() ?>>
<span id="el_partner_quotation_pp_currency">
<input type="text" data-table="partner_quotation_pp" data-field="x_currency" name="x_currency" id="x_currency" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->currency->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->currency->EditValue ?>"<?php echo $partner_quotation_pp->currency->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label id="elh_partner_quotation_pp_total_amount" for="x_total_amount" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->total_amount->caption() ?><?php echo ($partner_quotation_pp->total_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->total_amount->cellAttributes() ?>>
<span id="el_partner_quotation_pp_total_amount">
<input type="text" data-table="partner_quotation_pp" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->total_amount->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->total_amount->EditValue ?>"<?php echo $partner_quotation_pp->total_amount->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->total_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_partner_quotation_pp_remarks" for="x_remarks" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->remarks->caption() ?><?php echo ($partner_quotation_pp->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->remarks->cellAttributes() ?>>
<span id="el_partner_quotation_pp_remarks">
<input type="text" data-table="partner_quotation_pp" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($partner_quotation_pp->remarks->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->remarks->EditValue ?>"<?php echo $partner_quotation_pp->remarks->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label id="elh_partner_quotation_pp_payment_terms" for="x_payment_terms" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->payment_terms->caption() ?><?php echo ($partner_quotation_pp->payment_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->payment_terms->cellAttributes() ?>>
<span id="el_partner_quotation_pp_payment_terms">
<input type="text" data-table="partner_quotation_pp" data-field="x_payment_terms" name="x_payment_terms" id="x_payment_terms" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->payment_terms->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->payment_terms->EditValue ?>"<?php echo $partner_quotation_pp->payment_terms->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->payment_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->tax_categories->Visible) { // tax_categories ?>
	<div id="r_tax_categories" class="form-group row">
		<label id="elh_partner_quotation_pp_tax_categories" for="x_tax_categories" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->tax_categories->caption() ?><?php echo ($partner_quotation_pp->tax_categories->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->tax_categories->cellAttributes() ?>>
<span id="el_partner_quotation_pp_tax_categories">
<input type="text" data-table="partner_quotation_pp" data-field="x_tax_categories" name="x_tax_categories" id="x_tax_categories" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->tax_categories->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->tax_categories->EditValue ?>"<?php echo $partner_quotation_pp->tax_categories->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->tax_categories->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->delivery_period->Visible) { // delivery_period ?>
	<div id="r_delivery_period" class="form-group row">
		<label id="elh_partner_quotation_pp_delivery_period" for="x_delivery_period" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->delivery_period->caption() ?><?php echo ($partner_quotation_pp->delivery_period->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->delivery_period->cellAttributes() ?>>
<span id="el_partner_quotation_pp_delivery_period">
<input type="text" data-table="partner_quotation_pp" data-field="x_delivery_period" name="x_delivery_period" id="x_delivery_period" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->delivery_period->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->delivery_period->EditValue ?>"<?php echo $partner_quotation_pp->delivery_period->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->delivery_period->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_partner_quotation_pp_operator" for="x_operator" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->operator->caption() ?><?php echo ($partner_quotation_pp->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->operator->cellAttributes() ?>>
<span id="el_partner_quotation_pp_operator">
<input type="text" data-table="partner_quotation_pp" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->operator->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->operator->EditValue ?>"<?php echo $partner_quotation_pp->operator->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_partner_quotation_pp_datetime" for="x_datetime" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->datetime->caption() ?><?php echo ($partner_quotation_pp->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->datetime->cellAttributes() ?>>
<span id="el_partner_quotation_pp_datetime">
<input type="text" data-table="partner_quotation_pp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($partner_quotation_pp->datetime->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->datetime->EditValue ?>"<?php echo $partner_quotation_pp->datetime->editAttributes() ?>>
<?php if (!$partner_quotation_pp->datetime->ReadOnly && !$partner_quotation_pp->datetime->Disabled && !isset($partner_quotation_pp->datetime->EditAttrs["readonly"]) && !isset($partner_quotation_pp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_quotation_ppadd", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $partner_quotation_pp->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_partner_quotation_pp_status" for="x_status" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->status->caption() ?><?php echo ($partner_quotation_pp->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->status->cellAttributes() ?>>
<span id="el_partner_quotation_pp_status">
<input type="text" data-table="partner_quotation_pp" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->status->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->status->EditValue ?>"<?php echo $partner_quotation_pp->status->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->pp_operator->Visible) { // pp_operator ?>
	<div id="r_pp_operator" class="form-group row">
		<label id="elh_partner_quotation_pp_pp_operator" for="x_pp_operator" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->pp_operator->caption() ?><?php echo ($partner_quotation_pp->pp_operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->pp_operator->cellAttributes() ?>>
<span id="el_partner_quotation_pp_pp_operator">
<input type="text" data-table="partner_quotation_pp" data-field="x_pp_operator" name="x_pp_operator" id="x_pp_operator" size="30" placeholder="<?php echo HtmlEncode($partner_quotation_pp->pp_operator->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->pp_operator->EditValue ?>"<?php echo $partner_quotation_pp->pp_operator->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->pp_operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->pp_datetime->Visible) { // pp_datetime ?>
	<div id="r_pp_datetime" class="form-group row">
		<label id="elh_partner_quotation_pp_pp_datetime" for="x_pp_datetime" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->pp_datetime->caption() ?><?php echo ($partner_quotation_pp->pp_datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->pp_datetime->cellAttributes() ?>>
<span id="el_partner_quotation_pp_pp_datetime">
<input type="text" data-table="partner_quotation_pp" data-field="x_pp_datetime" name="x_pp_datetime" id="x_pp_datetime" placeholder="<?php echo HtmlEncode($partner_quotation_pp->pp_datetime->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->pp_datetime->EditValue ?>"<?php echo $partner_quotation_pp->pp_datetime->editAttributes() ?>>
<?php if (!$partner_quotation_pp->pp_datetime->ReadOnly && !$partner_quotation_pp->pp_datetime->Disabled && !isset($partner_quotation_pp->pp_datetime->EditAttrs["readonly"]) && !isset($partner_quotation_pp->pp_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpartner_quotation_ppadd", "x_pp_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $partner_quotation_pp->pp_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($partner_quotation_pp->quantity_approx->Visible) { // quantity_approx ?>
	<div id="r_quantity_approx" class="form-group row">
		<label id="elh_partner_quotation_pp_quantity_approx" for="x_quantity_approx" class="<?php echo $partner_quotation_pp_add->LeftColumnClass ?>"><?php echo $partner_quotation_pp->quantity_approx->caption() ?><?php echo ($partner_quotation_pp->quantity_approx->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $partner_quotation_pp_add->RightColumnClass ?>"><div<?php echo $partner_quotation_pp->quantity_approx->cellAttributes() ?>>
<span id="el_partner_quotation_pp_quantity_approx">
<input type="text" data-table="partner_quotation_pp" data-field="x_quantity_approx" name="x_quantity_approx" id="x_quantity_approx" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($partner_quotation_pp->quantity_approx->getPlaceHolder()) ?>" value="<?php echo $partner_quotation_pp->quantity_approx->EditValue ?>"<?php echo $partner_quotation_pp->quantity_approx->editAttributes() ?>>
</span>
<?php echo $partner_quotation_pp->quantity_approx->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$partner_quotation_pp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $partner_quotation_pp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $partner_quotation_pp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$partner_quotation_pp_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$partner_quotation_pp_add->terminate();
?>