<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$partner_quotation_pp_list = new partner_quotation_pp_list();

// Run the page
$partner_quotation_pp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$partner_quotation_pp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$partner_quotation_pp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpartner_quotation_pplist = currentForm = new ew.Form("fpartner_quotation_pplist", "list");
fpartner_quotation_pplist.formKeyCountName = '<?php echo $partner_quotation_pp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpartner_quotation_pplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpartner_quotation_pplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fpartner_quotation_pplistsrch = currentSearchForm = new ew.Form("fpartner_quotation_pplistsrch");

// Filters
fpartner_quotation_pplistsrch.filterList = <?php echo $partner_quotation_pp_list->getFilterList() ?>;

// Init search panel as collapsed
fpartner_quotation_pplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$partner_quotation_pp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($partner_quotation_pp_list->TotalRecs > 0 && $partner_quotation_pp_list->ExportOptions->visible()) { ?>
<?php $partner_quotation_pp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_quotation_pp_list->ImportOptions->visible()) { ?>
<?php $partner_quotation_pp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($partner_quotation_pp_list->SearchOptions->visible()) { ?>
<?php $partner_quotation_pp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($partner_quotation_pp_list->FilterOptions->visible()) { ?>
<?php $partner_quotation_pp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$partner_quotation_pp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$partner_quotation_pp->isExport() && !$partner_quotation_pp->CurrentAction) { ?>
<form name="fpartner_quotation_pplistsrch" id="fpartner_quotation_pplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($partner_quotation_pp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpartner_quotation_pplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="partner_quotation_pp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($partner_quotation_pp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($partner_quotation_pp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $partner_quotation_pp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($partner_quotation_pp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($partner_quotation_pp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($partner_quotation_pp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($partner_quotation_pp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $partner_quotation_pp_list->showPageHeader(); ?>
<?php
$partner_quotation_pp_list->showMessage();
?>
<?php if ($partner_quotation_pp_list->TotalRecs > 0 || $partner_quotation_pp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($partner_quotation_pp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> partner_quotation_pp">
<?php if (!$partner_quotation_pp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$partner_quotation_pp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_quotation_pp_list->Pager)) $partner_quotation_pp_list->Pager = new PrevNextPager($partner_quotation_pp_list->StartRec, $partner_quotation_pp_list->DisplayRecs, $partner_quotation_pp_list->TotalRecs, $partner_quotation_pp_list->AutoHidePager) ?>
<?php if ($partner_quotation_pp_list->Pager->RecordCount > 0 && $partner_quotation_pp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_quotation_pp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_quotation_pp_list->pageUrl() ?>start=<?php echo $partner_quotation_pp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_quotation_pp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_quotation_pp_list->pageUrl() ?>start=<?php echo $partner_quotation_pp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_quotation_pp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_quotation_pp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_quotation_pp_list->pageUrl() ?>start=<?php echo $partner_quotation_pp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_quotation_pp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_quotation_pp_list->pageUrl() ?>start=<?php echo $partner_quotation_pp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_quotation_pp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_quotation_pp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_quotation_pp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_quotation_pp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_quotation_pp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_quotation_pp_list->TotalRecs > 0 && (!$partner_quotation_pp_list->AutoHidePageSizeSelector || $partner_quotation_pp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_quotation_pp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_quotation_pp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_quotation_pp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_quotation_pp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_quotation_pp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_quotation_pp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_quotation_pp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_quotation_pp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpartner_quotation_pplist" id="fpartner_quotation_pplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($partner_quotation_pp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $partner_quotation_pp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="partner_quotation_pp">
<div id="gmp_partner_quotation_pp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($partner_quotation_pp_list->TotalRecs > 0 || $partner_quotation_pp->isGridEdit()) { ?>
<table id="tbl_partner_quotation_pplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$partner_quotation_pp_list->RowType = ROWTYPE_HEADER;

// Render list options
$partner_quotation_pp_list->renderListOptions();

// Render list options (header, left)
$partner_quotation_pp_list->ListOptions->render("header", "left");
?>
<?php if ($partner_quotation_pp->id->Visible) { // id ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->id) == "") { ?>
		<th data-name="id" class="<?php echo $partner_quotation_pp->id->headerCellClass() ?>"><div id="elh_partner_quotation_pp_id" class="partner_quotation_pp_id"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $partner_quotation_pp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->id) ?>',2);"><div id="elh_partner_quotation_pp_id" class="partner_quotation_pp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->company_id->Visible) { // company_id ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $partner_quotation_pp->company_id->headerCellClass() ?>"><div id="elh_partner_quotation_pp_company_id" class="partner_quotation_pp_company_id"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $partner_quotation_pp->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->company_id) ?>',2);"><div id="elh_partner_quotation_pp_company_id" class="partner_quotation_pp_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->partner_id->Visible) { // partner_id ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $partner_quotation_pp->partner_id->headerCellClass() ?>"><div id="elh_partner_quotation_pp_partner_id" class="partner_quotation_pp_partner_id"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $partner_quotation_pp->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->partner_id) ?>',2);"><div id="elh_partner_quotation_pp_partner_id" class="partner_quotation_pp_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->product_type->Visible) { // product_type ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $partner_quotation_pp->product_type->headerCellClass() ?>"><div id="elh_partner_quotation_pp_product_type" class="partner_quotation_pp_product_type"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $partner_quotation_pp->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->product_type) ?>',2);"><div id="elh_partner_quotation_pp_product_type" class="partner_quotation_pp_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->product->Visible) { // product ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->product) == "") { ?>
		<th data-name="product" class="<?php echo $partner_quotation_pp->product->headerCellClass() ?>"><div id="elh_partner_quotation_pp_product" class="partner_quotation_pp_product"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $partner_quotation_pp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->product) ?>',2);"><div id="elh_partner_quotation_pp_product" class="partner_quotation_pp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->product_code->Visible) { // product_code ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $partner_quotation_pp->product_code->headerCellClass() ?>"><div id="elh_partner_quotation_pp_product_code" class="partner_quotation_pp_product_code"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $partner_quotation_pp->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->product_code) ?>',2);"><div id="elh_partner_quotation_pp_product_code" class="partner_quotation_pp_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->product_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->partner_code->Visible) { // partner_code ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->partner_code) == "") { ?>
		<th data-name="partner_code" class="<?php echo $partner_quotation_pp->partner_code->headerCellClass() ?>"><div id="elh_partner_quotation_pp_partner_code" class="partner_quotation_pp_partner_code"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->partner_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_code" class="<?php echo $partner_quotation_pp->partner_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->partner_code) ?>',2);"><div id="elh_partner_quotation_pp_partner_code" class="partner_quotation_pp_partner_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->partner_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->partner_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->partner_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->packing_type->Visible) { // packing_type ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $partner_quotation_pp->packing_type->headerCellClass() ?>"><div id="elh_partner_quotation_pp_packing_type" class="partner_quotation_pp_packing_type"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $partner_quotation_pp->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->packing_type) ?>',2);"><div id="elh_partner_quotation_pp_packing_type" class="partner_quotation_pp_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->unit->Visible) { // unit ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $partner_quotation_pp->unit->headerCellClass() ?>"><div id="elh_partner_quotation_pp_unit" class="partner_quotation_pp_unit"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $partner_quotation_pp->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->unit) ?>',2);"><div id="elh_partner_quotation_pp_unit" class="partner_quotation_pp_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->quantity->Visible) { // quantity ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $partner_quotation_pp->quantity->headerCellClass() ?>"><div id="elh_partner_quotation_pp_quantity" class="partner_quotation_pp_quantity"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $partner_quotation_pp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->quantity) ?>',2);"><div id="elh_partner_quotation_pp_quantity" class="partner_quotation_pp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->price->Visible) { // price ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->price) == "") { ?>
		<th data-name="price" class="<?php echo $partner_quotation_pp->price->headerCellClass() ?>"><div id="elh_partner_quotation_pp_price" class="partner_quotation_pp_price"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $partner_quotation_pp->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->price) ?>',2);"><div id="elh_partner_quotation_pp_price" class="partner_quotation_pp_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->amount->Visible) { // amount ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $partner_quotation_pp->amount->headerCellClass() ?>"><div id="elh_partner_quotation_pp_amount" class="partner_quotation_pp_amount"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $partner_quotation_pp->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->amount) ?>',2);"><div id="elh_partner_quotation_pp_amount" class="partner_quotation_pp_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->currency->Visible) { // currency ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $partner_quotation_pp->currency->headerCellClass() ?>"><div id="elh_partner_quotation_pp_currency" class="partner_quotation_pp_currency"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $partner_quotation_pp->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->currency) ?>',2);"><div id="elh_partner_quotation_pp_currency" class="partner_quotation_pp_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->total_amount->Visible) { // total_amount ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $partner_quotation_pp->total_amount->headerCellClass() ?>"><div id="elh_partner_quotation_pp_total_amount" class="partner_quotation_pp_total_amount"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $partner_quotation_pp->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->total_amount) ?>',2);"><div id="elh_partner_quotation_pp_total_amount" class="partner_quotation_pp_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->remarks->Visible) { // remarks ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $partner_quotation_pp->remarks->headerCellClass() ?>"><div id="elh_partner_quotation_pp_remarks" class="partner_quotation_pp_remarks"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $partner_quotation_pp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->remarks) ?>',2);"><div id="elh_partner_quotation_pp_remarks" class="partner_quotation_pp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->payment_terms->Visible) { // payment_terms ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->payment_terms) == "") { ?>
		<th data-name="payment_terms" class="<?php echo $partner_quotation_pp->payment_terms->headerCellClass() ?>"><div id="elh_partner_quotation_pp_payment_terms" class="partner_quotation_pp_payment_terms"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->payment_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_terms" class="<?php echo $partner_quotation_pp->payment_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->payment_terms) ?>',2);"><div id="elh_partner_quotation_pp_payment_terms" class="partner_quotation_pp_payment_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->payment_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->payment_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->payment_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->tax_categories->Visible) { // tax_categories ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->tax_categories) == "") { ?>
		<th data-name="tax_categories" class="<?php echo $partner_quotation_pp->tax_categories->headerCellClass() ?>"><div id="elh_partner_quotation_pp_tax_categories" class="partner_quotation_pp_tax_categories"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->tax_categories->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tax_categories" class="<?php echo $partner_quotation_pp->tax_categories->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->tax_categories) ?>',2);"><div id="elh_partner_quotation_pp_tax_categories" class="partner_quotation_pp_tax_categories">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->tax_categories->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->tax_categories->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->tax_categories->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->delivery_period->Visible) { // delivery_period ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->delivery_period) == "") { ?>
		<th data-name="delivery_period" class="<?php echo $partner_quotation_pp->delivery_period->headerCellClass() ?>"><div id="elh_partner_quotation_pp_delivery_period" class="partner_quotation_pp_delivery_period"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->delivery_period->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_period" class="<?php echo $partner_quotation_pp->delivery_period->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->delivery_period) ?>',2);"><div id="elh_partner_quotation_pp_delivery_period" class="partner_quotation_pp_delivery_period">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->delivery_period->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->delivery_period->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->delivery_period->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->operator->Visible) { // operator ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $partner_quotation_pp->operator->headerCellClass() ?>"><div id="elh_partner_quotation_pp_operator" class="partner_quotation_pp_operator"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $partner_quotation_pp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->operator) ?>',2);"><div id="elh_partner_quotation_pp_operator" class="partner_quotation_pp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->datetime->Visible) { // datetime ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $partner_quotation_pp->datetime->headerCellClass() ?>"><div id="elh_partner_quotation_pp_datetime" class="partner_quotation_pp_datetime"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $partner_quotation_pp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->datetime) ?>',2);"><div id="elh_partner_quotation_pp_datetime" class="partner_quotation_pp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->status->Visible) { // status ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->status) == "") { ?>
		<th data-name="status" class="<?php echo $partner_quotation_pp->status->headerCellClass() ?>"><div id="elh_partner_quotation_pp_status" class="partner_quotation_pp_status"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $partner_quotation_pp->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->status) ?>',2);"><div id="elh_partner_quotation_pp_status" class="partner_quotation_pp_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->pp_operator->Visible) { // pp_operator ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->pp_operator) == "") { ?>
		<th data-name="pp_operator" class="<?php echo $partner_quotation_pp->pp_operator->headerCellClass() ?>"><div id="elh_partner_quotation_pp_pp_operator" class="partner_quotation_pp_pp_operator"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->pp_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_operator" class="<?php echo $partner_quotation_pp->pp_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->pp_operator) ?>',2);"><div id="elh_partner_quotation_pp_pp_operator" class="partner_quotation_pp_pp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->pp_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->pp_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->pp_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->pp_datetime->Visible) { // pp_datetime ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->pp_datetime) == "") { ?>
		<th data-name="pp_datetime" class="<?php echo $partner_quotation_pp->pp_datetime->headerCellClass() ?>"><div id="elh_partner_quotation_pp_pp_datetime" class="partner_quotation_pp_pp_datetime"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->pp_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_datetime" class="<?php echo $partner_quotation_pp->pp_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->pp_datetime) ?>',2);"><div id="elh_partner_quotation_pp_pp_datetime" class="partner_quotation_pp_pp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->pp_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->pp_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->pp_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($partner_quotation_pp->quantity_approx->Visible) { // quantity_approx ?>
	<?php if ($partner_quotation_pp->sortUrl($partner_quotation_pp->quantity_approx) == "") { ?>
		<th data-name="quantity_approx" class="<?php echo $partner_quotation_pp->quantity_approx->headerCellClass() ?>"><div id="elh_partner_quotation_pp_quantity_approx" class="partner_quotation_pp_quantity_approx"><div class="ew-table-header-caption"><?php echo $partner_quotation_pp->quantity_approx->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_approx" class="<?php echo $partner_quotation_pp->quantity_approx->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $partner_quotation_pp->SortUrl($partner_quotation_pp->quantity_approx) ?>',2);"><div id="elh_partner_quotation_pp_quantity_approx" class="partner_quotation_pp_quantity_approx">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $partner_quotation_pp->quantity_approx->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($partner_quotation_pp->quantity_approx->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($partner_quotation_pp->quantity_approx->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$partner_quotation_pp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($partner_quotation_pp->ExportAll && $partner_quotation_pp->isExport()) {
	$partner_quotation_pp_list->StopRec = $partner_quotation_pp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($partner_quotation_pp_list->TotalRecs > $partner_quotation_pp_list->StartRec + $partner_quotation_pp_list->DisplayRecs - 1)
		$partner_quotation_pp_list->StopRec = $partner_quotation_pp_list->StartRec + $partner_quotation_pp_list->DisplayRecs - 1;
	else
		$partner_quotation_pp_list->StopRec = $partner_quotation_pp_list->TotalRecs;
}
$partner_quotation_pp_list->RecCnt = $partner_quotation_pp_list->StartRec - 1;
if ($partner_quotation_pp_list->Recordset && !$partner_quotation_pp_list->Recordset->EOF) {
	$partner_quotation_pp_list->Recordset->moveFirst();
	$selectLimit = $partner_quotation_pp_list->UseSelectLimit;
	if (!$selectLimit && $partner_quotation_pp_list->StartRec > 1)
		$partner_quotation_pp_list->Recordset->move($partner_quotation_pp_list->StartRec - 1);
} elseif (!$partner_quotation_pp->AllowAddDeleteRow && $partner_quotation_pp_list->StopRec == 0) {
	$partner_quotation_pp_list->StopRec = $partner_quotation_pp->GridAddRowCount;
}

// Initialize aggregate
$partner_quotation_pp->RowType = ROWTYPE_AGGREGATEINIT;
$partner_quotation_pp->resetAttributes();
$partner_quotation_pp_list->renderRow();
while ($partner_quotation_pp_list->RecCnt < $partner_quotation_pp_list->StopRec) {
	$partner_quotation_pp_list->RecCnt++;
	if ($partner_quotation_pp_list->RecCnt >= $partner_quotation_pp_list->StartRec) {
		$partner_quotation_pp_list->RowCnt++;

		// Set up key count
		$partner_quotation_pp_list->KeyCount = $partner_quotation_pp_list->RowIndex;

		// Init row class and style
		$partner_quotation_pp->resetAttributes();
		$partner_quotation_pp->CssClass = "";
		if ($partner_quotation_pp->isGridAdd()) {
		} else {
			$partner_quotation_pp_list->loadRowValues($partner_quotation_pp_list->Recordset); // Load row values
		}
		$partner_quotation_pp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$partner_quotation_pp->RowAttrs = array_merge($partner_quotation_pp->RowAttrs, array('data-rowindex'=>$partner_quotation_pp_list->RowCnt, 'id'=>'r' . $partner_quotation_pp_list->RowCnt . '_partner_quotation_pp', 'data-rowtype'=>$partner_quotation_pp->RowType));

		// Render row
		$partner_quotation_pp_list->renderRow();

		// Render list options
		$partner_quotation_pp_list->renderListOptions();
?>
	<tr<?php echo $partner_quotation_pp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$partner_quotation_pp_list->ListOptions->render("body", "left", $partner_quotation_pp_list->RowCnt);
?>
	<?php if ($partner_quotation_pp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $partner_quotation_pp->id->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_id" class="partner_quotation_pp_id">
<span<?php echo $partner_quotation_pp->id->viewAttributes() ?>>
<?php echo $partner_quotation_pp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $partner_quotation_pp->company_id->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_company_id" class="partner_quotation_pp_company_id">
<span<?php echo $partner_quotation_pp->company_id->viewAttributes() ?>>
<?php echo $partner_quotation_pp->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $partner_quotation_pp->partner_id->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_partner_id" class="partner_quotation_pp_partner_id">
<span<?php echo $partner_quotation_pp->partner_id->viewAttributes() ?>>
<?php echo $partner_quotation_pp->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $partner_quotation_pp->product_type->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_product_type" class="partner_quotation_pp_product_type">
<span<?php echo $partner_quotation_pp->product_type->viewAttributes() ?>>
<?php echo $partner_quotation_pp->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $partner_quotation_pp->product->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_product" class="partner_quotation_pp_product">
<span<?php echo $partner_quotation_pp->product->viewAttributes() ?>>
<?php echo $partner_quotation_pp->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $partner_quotation_pp->product_code->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_product_code" class="partner_quotation_pp_product_code">
<span<?php echo $partner_quotation_pp->product_code->viewAttributes() ?>>
<?php echo $partner_quotation_pp->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->partner_code->Visible) { // partner_code ?>
		<td data-name="partner_code"<?php echo $partner_quotation_pp->partner_code->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_partner_code" class="partner_quotation_pp_partner_code">
<span<?php echo $partner_quotation_pp->partner_code->viewAttributes() ?>>
<?php echo $partner_quotation_pp->partner_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $partner_quotation_pp->packing_type->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_packing_type" class="partner_quotation_pp_packing_type">
<span<?php echo $partner_quotation_pp->packing_type->viewAttributes() ?>>
<?php echo $partner_quotation_pp->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $partner_quotation_pp->unit->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_unit" class="partner_quotation_pp_unit">
<span<?php echo $partner_quotation_pp->unit->viewAttributes() ?>>
<?php echo $partner_quotation_pp->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $partner_quotation_pp->quantity->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_quantity" class="partner_quotation_pp_quantity">
<span<?php echo $partner_quotation_pp->quantity->viewAttributes() ?>>
<?php echo $partner_quotation_pp->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->price->Visible) { // price ?>
		<td data-name="price"<?php echo $partner_quotation_pp->price->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_price" class="partner_quotation_pp_price">
<span<?php echo $partner_quotation_pp->price->viewAttributes() ?>>
<?php echo $partner_quotation_pp->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $partner_quotation_pp->amount->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_amount" class="partner_quotation_pp_amount">
<span<?php echo $partner_quotation_pp->amount->viewAttributes() ?>>
<?php echo $partner_quotation_pp->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $partner_quotation_pp->currency->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_currency" class="partner_quotation_pp_currency">
<span<?php echo $partner_quotation_pp->currency->viewAttributes() ?>>
<?php echo $partner_quotation_pp->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $partner_quotation_pp->total_amount->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_total_amount" class="partner_quotation_pp_total_amount">
<span<?php echo $partner_quotation_pp->total_amount->viewAttributes() ?>>
<?php echo $partner_quotation_pp->total_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $partner_quotation_pp->remarks->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_remarks" class="partner_quotation_pp_remarks">
<span<?php echo $partner_quotation_pp->remarks->viewAttributes() ?>>
<?php echo $partner_quotation_pp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->payment_terms->Visible) { // payment_terms ?>
		<td data-name="payment_terms"<?php echo $partner_quotation_pp->payment_terms->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_payment_terms" class="partner_quotation_pp_payment_terms">
<span<?php echo $partner_quotation_pp->payment_terms->viewAttributes() ?>>
<?php echo $partner_quotation_pp->payment_terms->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->tax_categories->Visible) { // tax_categories ?>
		<td data-name="tax_categories"<?php echo $partner_quotation_pp->tax_categories->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_tax_categories" class="partner_quotation_pp_tax_categories">
<span<?php echo $partner_quotation_pp->tax_categories->viewAttributes() ?>>
<?php echo $partner_quotation_pp->tax_categories->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->delivery_period->Visible) { // delivery_period ?>
		<td data-name="delivery_period"<?php echo $partner_quotation_pp->delivery_period->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_delivery_period" class="partner_quotation_pp_delivery_period">
<span<?php echo $partner_quotation_pp->delivery_period->viewAttributes() ?>>
<?php echo $partner_quotation_pp->delivery_period->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $partner_quotation_pp->operator->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_operator" class="partner_quotation_pp_operator">
<span<?php echo $partner_quotation_pp->operator->viewAttributes() ?>>
<?php echo $partner_quotation_pp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $partner_quotation_pp->datetime->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_datetime" class="partner_quotation_pp_datetime">
<span<?php echo $partner_quotation_pp->datetime->viewAttributes() ?>>
<?php echo $partner_quotation_pp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->status->Visible) { // status ?>
		<td data-name="status"<?php echo $partner_quotation_pp->status->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_status" class="partner_quotation_pp_status">
<span<?php echo $partner_quotation_pp->status->viewAttributes() ?>>
<?php echo $partner_quotation_pp->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->pp_operator->Visible) { // pp_operator ?>
		<td data-name="pp_operator"<?php echo $partner_quotation_pp->pp_operator->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_pp_operator" class="partner_quotation_pp_pp_operator">
<span<?php echo $partner_quotation_pp->pp_operator->viewAttributes() ?>>
<?php echo $partner_quotation_pp->pp_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->pp_datetime->Visible) { // pp_datetime ?>
		<td data-name="pp_datetime"<?php echo $partner_quotation_pp->pp_datetime->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_pp_datetime" class="partner_quotation_pp_pp_datetime">
<span<?php echo $partner_quotation_pp->pp_datetime->viewAttributes() ?>>
<?php echo $partner_quotation_pp->pp_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($partner_quotation_pp->quantity_approx->Visible) { // quantity_approx ?>
		<td data-name="quantity_approx"<?php echo $partner_quotation_pp->quantity_approx->cellAttributes() ?>>
<span id="el<?php echo $partner_quotation_pp_list->RowCnt ?>_partner_quotation_pp_quantity_approx" class="partner_quotation_pp_quantity_approx">
<span<?php echo $partner_quotation_pp->quantity_approx->viewAttributes() ?>>
<?php echo $partner_quotation_pp->quantity_approx->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$partner_quotation_pp_list->ListOptions->render("body", "right", $partner_quotation_pp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$partner_quotation_pp->isGridAdd())
		$partner_quotation_pp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$partner_quotation_pp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($partner_quotation_pp_list->Recordset)
	$partner_quotation_pp_list->Recordset->Close();
?>
<?php if (!$partner_quotation_pp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$partner_quotation_pp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($partner_quotation_pp_list->Pager)) $partner_quotation_pp_list->Pager = new PrevNextPager($partner_quotation_pp_list->StartRec, $partner_quotation_pp_list->DisplayRecs, $partner_quotation_pp_list->TotalRecs, $partner_quotation_pp_list->AutoHidePager) ?>
<?php if ($partner_quotation_pp_list->Pager->RecordCount > 0 && $partner_quotation_pp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($partner_quotation_pp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $partner_quotation_pp_list->pageUrl() ?>start=<?php echo $partner_quotation_pp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($partner_quotation_pp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $partner_quotation_pp_list->pageUrl() ?>start=<?php echo $partner_quotation_pp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $partner_quotation_pp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($partner_quotation_pp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $partner_quotation_pp_list->pageUrl() ?>start=<?php echo $partner_quotation_pp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($partner_quotation_pp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $partner_quotation_pp_list->pageUrl() ?>start=<?php echo $partner_quotation_pp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $partner_quotation_pp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($partner_quotation_pp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $partner_quotation_pp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $partner_quotation_pp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $partner_quotation_pp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($partner_quotation_pp_list->TotalRecs > 0 && (!$partner_quotation_pp_list->AutoHidePageSizeSelector || $partner_quotation_pp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="partner_quotation_pp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($partner_quotation_pp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($partner_quotation_pp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($partner_quotation_pp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($partner_quotation_pp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($partner_quotation_pp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($partner_quotation_pp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $partner_quotation_pp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($partner_quotation_pp_list->TotalRecs == 0 && !$partner_quotation_pp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $partner_quotation_pp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$partner_quotation_pp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$partner_quotation_pp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$partner_quotation_pp_list->terminate();
?>