<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_emp_grp_check_list = new payment_emp_grp_check_list();

// Run the page
$payment_emp_grp_check_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_emp_grp_check_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_emp_grp_check->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_emp_grp_checklist = currentForm = new ew.Form("fpayment_emp_grp_checklist", "list");
fpayment_emp_grp_checklist.formKeyCountName = '<?php echo $payment_emp_grp_check_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_emp_grp_checklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_emp_grp_checklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_emp_grp_checklist.lists["x_process"] = <?php echo $payment_emp_grp_check_list->process->Lookup->toClientList() ?>;
fpayment_emp_grp_checklist.lists["x_process"].options = <?php echo JsonEncode($payment_emp_grp_check_list->process->lookupOptions()) ?>;
fpayment_emp_grp_checklist.lists["x_payment_type"] = <?php echo $payment_emp_grp_check_list->payment_type->Lookup->toClientList() ?>;
fpayment_emp_grp_checklist.lists["x_payment_type"].options = <?php echo JsonEncode($payment_emp_grp_check_list->payment_type->options(FALSE, TRUE)) ?>;
fpayment_emp_grp_checklist.lists["x_payment"] = <?php echo $payment_emp_grp_check_list->payment->Lookup->toClientList() ?>;
fpayment_emp_grp_checklist.lists["x_payment"].options = <?php echo JsonEncode($payment_emp_grp_check_list->payment->lookupOptions()) ?>;

// Form object for search
var fpayment_emp_grp_checklistsrch = currentSearchForm = new ew.Form("fpayment_emp_grp_checklistsrch");

// Validate function for search
fpayment_emp_grp_checklistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_emp_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_emp_grp_check->emp_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_count");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_emp_grp_check->count->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpayment_emp_grp_checklistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_emp_grp_checklistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fpayment_emp_grp_checklistsrch.filterList = <?php echo $payment_emp_grp_check_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_emp_grp_checklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_emp_grp_check->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_emp_grp_check_list->TotalRecs > 0 && $payment_emp_grp_check_list->ExportOptions->visible()) { ?>
<?php $payment_emp_grp_check_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_emp_grp_check_list->ImportOptions->visible()) { ?>
<?php $payment_emp_grp_check_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_emp_grp_check_list->SearchOptions->visible()) { ?>
<?php $payment_emp_grp_check_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_emp_grp_check_list->FilterOptions->visible()) { ?>
<?php $payment_emp_grp_check_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_emp_grp_check_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_emp_grp_check->isExport() && !$payment_emp_grp_check->CurrentAction) { ?>
<form name="fpayment_emp_grp_checklistsrch" id="fpayment_emp_grp_checklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_emp_grp_check_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_emp_grp_checklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_emp_grp_check">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$payment_emp_grp_check_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$payment_emp_grp_check->RowType = ROWTYPE_SEARCH;

// Render row
$payment_emp_grp_check->resetAttributes();
$payment_emp_grp_check_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($payment_emp_grp_check->emp_grp->Visible) { // emp_grp ?>
	<div id="xsc_emp_grp" class="ew-cell form-group">
		<label for="x_emp_grp" class="ew-search-caption ew-label"><?php echo $payment_emp_grp_check->emp_grp->caption() ?></label>
		<span class="ew-search-operator"><select name="z_emp_grp" id="z_emp_grp" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($payment_emp_grp_check->emp_grp->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($payment_emp_grp_check->emp_grp->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($payment_emp_grp_check->emp_grp->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($payment_emp_grp_check->emp_grp->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($payment_emp_grp_check->emp_grp->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($payment_emp_grp_check->emp_grp->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($payment_emp_grp_check->emp_grp->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="payment_emp_grp_check" data-field="x_emp_grp" name="x_emp_grp" id="x_emp_grp" size="30" placeholder="<?php echo HtmlEncode($payment_emp_grp_check->emp_grp->getPlaceHolder()) ?>" value="<?php echo $payment_emp_grp_check->emp_grp->EditValue ?>"<?php echo $payment_emp_grp_check->emp_grp->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_emp_grp style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_emp_grp style="d-none"">
<input type="text" data-table="payment_emp_grp_check" data-field="x_emp_grp" name="y_emp_grp" id="y_emp_grp" size="30" placeholder="<?php echo HtmlEncode($payment_emp_grp_check->emp_grp->getPlaceHolder()) ?>" value="<?php echo $payment_emp_grp_check->emp_grp->EditValue2 ?>"<?php echo $payment_emp_grp_check->emp_grp->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($payment_emp_grp_check->count->Visible) { // count ?>
	<div id="xsc_count" class="ew-cell form-group">
		<label for="x_count" class="ew-search-caption ew-label"><?php echo $payment_emp_grp_check->count->caption() ?></label>
		<span class="ew-search-operator"><select name="z_count" id="z_count" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($payment_emp_grp_check->count->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($payment_emp_grp_check->count->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($payment_emp_grp_check->count->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($payment_emp_grp_check->count->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($payment_emp_grp_check->count->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($payment_emp_grp_check->count->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($payment_emp_grp_check->count->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="payment_emp_grp_check" data-field="x_count" name="x_count" id="x_count" size="30" placeholder="<?php echo HtmlEncode($payment_emp_grp_check->count->getPlaceHolder()) ?>" value="<?php echo $payment_emp_grp_check->count->EditValue ?>"<?php echo $payment_emp_grp_check->count->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_count style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_count style="d-none"">
<input type="text" data-table="payment_emp_grp_check" data-field="x_count" name="y_count" id="y_count" size="30" placeholder="<?php echo HtmlEncode($payment_emp_grp_check->count->getPlaceHolder()) ?>" value="<?php echo $payment_emp_grp_check->count->EditValue2 ?>"<?php echo $payment_emp_grp_check->count->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_emp_grp_check_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_emp_grp_check_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_emp_grp_check_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_emp_grp_check_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_emp_grp_check_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_emp_grp_check_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_emp_grp_check_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_emp_grp_check_list->showPageHeader(); ?>
<?php
$payment_emp_grp_check_list->showMessage();
?>
<?php if ($payment_emp_grp_check_list->TotalRecs > 0 || $payment_emp_grp_check->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_emp_grp_check_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_emp_grp_check">
<?php if (!$payment_emp_grp_check->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_emp_grp_check->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_emp_grp_check_list->Pager)) $payment_emp_grp_check_list->Pager = new PrevNextPager($payment_emp_grp_check_list->StartRec, $payment_emp_grp_check_list->DisplayRecs, $payment_emp_grp_check_list->TotalRecs, $payment_emp_grp_check_list->AutoHidePager) ?>
<?php if ($payment_emp_grp_check_list->Pager->RecordCount > 0 && $payment_emp_grp_check_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_emp_grp_check_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_emp_grp_check_list->pageUrl() ?>start=<?php echo $payment_emp_grp_check_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_emp_grp_check_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_emp_grp_check_list->pageUrl() ?>start=<?php echo $payment_emp_grp_check_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_emp_grp_check_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_emp_grp_check_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_emp_grp_check_list->pageUrl() ?>start=<?php echo $payment_emp_grp_check_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_emp_grp_check_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_emp_grp_check_list->pageUrl() ?>start=<?php echo $payment_emp_grp_check_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_emp_grp_check_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_emp_grp_check_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_emp_grp_check_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_emp_grp_check_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_emp_grp_check_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_emp_grp_check_list->TotalRecs > 0 && (!$payment_emp_grp_check_list->AutoHidePageSizeSelector || $payment_emp_grp_check_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_emp_grp_check">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_emp_grp_check_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_emp_grp_check_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_emp_grp_check_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_emp_grp_check_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_emp_grp_check_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_emp_grp_check->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_emp_grp_check_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_emp_grp_checklist" id="fpayment_emp_grp_checklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_emp_grp_check_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_emp_grp_check_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_emp_grp_check">
<div id="gmp_payment_emp_grp_check" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_emp_grp_check_list->TotalRecs > 0 || $payment_emp_grp_check->isGridEdit()) { ?>
<table id="tbl_payment_emp_grp_checklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_emp_grp_check_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_emp_grp_check_list->renderListOptions();

// Render list options (header, left)
$payment_emp_grp_check_list->ListOptions->render("header", "left");
?>
<?php if ($payment_emp_grp_check->code->Visible) { // code ?>
	<?php if ($payment_emp_grp_check->sortUrl($payment_emp_grp_check->code) == "") { ?>
		<th data-name="code" class="<?php echo $payment_emp_grp_check->code->headerCellClass() ?>"><div id="elh_payment_emp_grp_check_code" class="payment_emp_grp_check_code"><div class="ew-table-header-caption"><?php echo $payment_emp_grp_check->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $payment_emp_grp_check->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_emp_grp_check->SortUrl($payment_emp_grp_check->code) ?>',2);"><div id="elh_payment_emp_grp_check_code" class="payment_emp_grp_check_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_emp_grp_check->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_emp_grp_check->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_emp_grp_check->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_emp_grp_check->process->Visible) { // process ?>
	<?php if ($payment_emp_grp_check->sortUrl($payment_emp_grp_check->process) == "") { ?>
		<th data-name="process" class="<?php echo $payment_emp_grp_check->process->headerCellClass() ?>"><div id="elh_payment_emp_grp_check_process" class="payment_emp_grp_check_process"><div class="ew-table-header-caption"><?php echo $payment_emp_grp_check->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $payment_emp_grp_check->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_emp_grp_check->SortUrl($payment_emp_grp_check->process) ?>',2);"><div id="elh_payment_emp_grp_check_process" class="payment_emp_grp_check_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_emp_grp_check->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_emp_grp_check->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_emp_grp_check->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_emp_grp_check->payment_type->Visible) { // payment_type ?>
	<?php if ($payment_emp_grp_check->sortUrl($payment_emp_grp_check->payment_type) == "") { ?>
		<th data-name="payment_type" class="<?php echo $payment_emp_grp_check->payment_type->headerCellClass() ?>"><div id="elh_payment_emp_grp_check_payment_type" class="payment_emp_grp_check_payment_type"><div class="ew-table-header-caption"><?php echo $payment_emp_grp_check->payment_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_type" class="<?php echo $payment_emp_grp_check->payment_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_emp_grp_check->SortUrl($payment_emp_grp_check->payment_type) ?>',2);"><div id="elh_payment_emp_grp_check_payment_type" class="payment_emp_grp_check_payment_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_emp_grp_check->payment_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_emp_grp_check->payment_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_emp_grp_check->payment_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_emp_grp_check->payment->Visible) { // payment ?>
	<?php if ($payment_emp_grp_check->sortUrl($payment_emp_grp_check->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $payment_emp_grp_check->payment->headerCellClass() ?>"><div id="elh_payment_emp_grp_check_payment" class="payment_emp_grp_check_payment"><div class="ew-table-header-caption"><?php echo $payment_emp_grp_check->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $payment_emp_grp_check->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_emp_grp_check->SortUrl($payment_emp_grp_check->payment) ?>',2);"><div id="elh_payment_emp_grp_check_payment" class="payment_emp_grp_check_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_emp_grp_check->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_emp_grp_check->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_emp_grp_check->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_emp_grp_check->emp_grp->Visible) { // emp_grp ?>
	<?php if ($payment_emp_grp_check->sortUrl($payment_emp_grp_check->emp_grp) == "") { ?>
		<th data-name="emp_grp" class="<?php echo $payment_emp_grp_check->emp_grp->headerCellClass() ?>"><div id="elh_payment_emp_grp_check_emp_grp" class="payment_emp_grp_check_emp_grp"><div class="ew-table-header-caption"><?php echo $payment_emp_grp_check->emp_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_grp" class="<?php echo $payment_emp_grp_check->emp_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_emp_grp_check->SortUrl($payment_emp_grp_check->emp_grp) ?>',2);"><div id="elh_payment_emp_grp_check_emp_grp" class="payment_emp_grp_check_emp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_emp_grp_check->emp_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_emp_grp_check->emp_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_emp_grp_check->emp_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_emp_grp_check->count->Visible) { // count ?>
	<?php if ($payment_emp_grp_check->sortUrl($payment_emp_grp_check->count) == "") { ?>
		<th data-name="count" class="<?php echo $payment_emp_grp_check->count->headerCellClass() ?>"><div id="elh_payment_emp_grp_check_count" class="payment_emp_grp_check_count"><div class="ew-table-header-caption"><?php echo $payment_emp_grp_check->count->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count" class="<?php echo $payment_emp_grp_check->count->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_emp_grp_check->SortUrl($payment_emp_grp_check->count) ?>',2);"><div id="elh_payment_emp_grp_check_count" class="payment_emp_grp_check_count">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_emp_grp_check->count->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_emp_grp_check->count->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_emp_grp_check->count->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_emp_grp_check_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_emp_grp_check->ExportAll && $payment_emp_grp_check->isExport()) {
	$payment_emp_grp_check_list->StopRec = $payment_emp_grp_check_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_emp_grp_check_list->TotalRecs > $payment_emp_grp_check_list->StartRec + $payment_emp_grp_check_list->DisplayRecs - 1)
		$payment_emp_grp_check_list->StopRec = $payment_emp_grp_check_list->StartRec + $payment_emp_grp_check_list->DisplayRecs - 1;
	else
		$payment_emp_grp_check_list->StopRec = $payment_emp_grp_check_list->TotalRecs;
}
$payment_emp_grp_check_list->RecCnt = $payment_emp_grp_check_list->StartRec - 1;
if ($payment_emp_grp_check_list->Recordset && !$payment_emp_grp_check_list->Recordset->EOF) {
	$payment_emp_grp_check_list->Recordset->moveFirst();
	$selectLimit = $payment_emp_grp_check_list->UseSelectLimit;
	if (!$selectLimit && $payment_emp_grp_check_list->StartRec > 1)
		$payment_emp_grp_check_list->Recordset->move($payment_emp_grp_check_list->StartRec - 1);
} elseif (!$payment_emp_grp_check->AllowAddDeleteRow && $payment_emp_grp_check_list->StopRec == 0) {
	$payment_emp_grp_check_list->StopRec = $payment_emp_grp_check->GridAddRowCount;
}

// Initialize aggregate
$payment_emp_grp_check->RowType = ROWTYPE_AGGREGATEINIT;
$payment_emp_grp_check->resetAttributes();
$payment_emp_grp_check_list->renderRow();
while ($payment_emp_grp_check_list->RecCnt < $payment_emp_grp_check_list->StopRec) {
	$payment_emp_grp_check_list->RecCnt++;
	if ($payment_emp_grp_check_list->RecCnt >= $payment_emp_grp_check_list->StartRec) {
		$payment_emp_grp_check_list->RowCnt++;

		// Set up key count
		$payment_emp_grp_check_list->KeyCount = $payment_emp_grp_check_list->RowIndex;

		// Init row class and style
		$payment_emp_grp_check->resetAttributes();
		$payment_emp_grp_check->CssClass = "";
		if ($payment_emp_grp_check->isGridAdd()) {
		} else {
			$payment_emp_grp_check_list->loadRowValues($payment_emp_grp_check_list->Recordset); // Load row values
		}
		$payment_emp_grp_check->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_emp_grp_check->RowAttrs = array_merge($payment_emp_grp_check->RowAttrs, array('data-rowindex'=>$payment_emp_grp_check_list->RowCnt, 'id'=>'r' . $payment_emp_grp_check_list->RowCnt . '_payment_emp_grp_check', 'data-rowtype'=>$payment_emp_grp_check->RowType));

		// Render row
		$payment_emp_grp_check_list->renderRow();

		// Render list options
		$payment_emp_grp_check_list->renderListOptions();
?>
	<tr<?php echo $payment_emp_grp_check->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_emp_grp_check_list->ListOptions->render("body", "left", $payment_emp_grp_check_list->RowCnt);
?>
	<?php if ($payment_emp_grp_check->code->Visible) { // code ?>
		<td data-name="code"<?php echo $payment_emp_grp_check->code->cellAttributes() ?>>
<span id="el<?php echo $payment_emp_grp_check_list->RowCnt ?>_payment_emp_grp_check_code" class="payment_emp_grp_check_code">
<span<?php echo $payment_emp_grp_check->code->viewAttributes() ?>>
<?php echo $payment_emp_grp_check->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_emp_grp_check->process->Visible) { // process ?>
		<td data-name="process"<?php echo $payment_emp_grp_check->process->cellAttributes() ?>>
<span id="el<?php echo $payment_emp_grp_check_list->RowCnt ?>_payment_emp_grp_check_process" class="payment_emp_grp_check_process">
<span<?php echo $payment_emp_grp_check->process->viewAttributes() ?>>
<?php echo $payment_emp_grp_check->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_emp_grp_check->payment_type->Visible) { // payment_type ?>
		<td data-name="payment_type"<?php echo $payment_emp_grp_check->payment_type->cellAttributes() ?>>
<span id="el<?php echo $payment_emp_grp_check_list->RowCnt ?>_payment_emp_grp_check_payment_type" class="payment_emp_grp_check_payment_type">
<span<?php echo $payment_emp_grp_check->payment_type->viewAttributes() ?>>
<?php echo $payment_emp_grp_check->payment_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_emp_grp_check->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $payment_emp_grp_check->payment->cellAttributes() ?>>
<span id="el<?php echo $payment_emp_grp_check_list->RowCnt ?>_payment_emp_grp_check_payment" class="payment_emp_grp_check_payment">
<span<?php echo $payment_emp_grp_check->payment->viewAttributes() ?>>
<?php echo $payment_emp_grp_check->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_emp_grp_check->emp_grp->Visible) { // emp_grp ?>
		<td data-name="emp_grp"<?php echo $payment_emp_grp_check->emp_grp->cellAttributes() ?>>
<span id="el<?php echo $payment_emp_grp_check_list->RowCnt ?>_payment_emp_grp_check_emp_grp" class="payment_emp_grp_check_emp_grp">
<span<?php echo $payment_emp_grp_check->emp_grp->viewAttributes() ?>>
<?php echo $payment_emp_grp_check->emp_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_emp_grp_check->count->Visible) { // count ?>
		<td data-name="count"<?php echo $payment_emp_grp_check->count->cellAttributes() ?>>
<span id="el<?php echo $payment_emp_grp_check_list->RowCnt ?>_payment_emp_grp_check_count" class="payment_emp_grp_check_count">
<span<?php echo $payment_emp_grp_check->count->viewAttributes() ?>>
<?php echo $payment_emp_grp_check->count->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_emp_grp_check_list->ListOptions->render("body", "right", $payment_emp_grp_check_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_emp_grp_check->isGridAdd())
		$payment_emp_grp_check_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_emp_grp_check->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_emp_grp_check_list->Recordset)
	$payment_emp_grp_check_list->Recordset->Close();
?>
<?php if (!$payment_emp_grp_check->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_emp_grp_check->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_emp_grp_check_list->Pager)) $payment_emp_grp_check_list->Pager = new PrevNextPager($payment_emp_grp_check_list->StartRec, $payment_emp_grp_check_list->DisplayRecs, $payment_emp_grp_check_list->TotalRecs, $payment_emp_grp_check_list->AutoHidePager) ?>
<?php if ($payment_emp_grp_check_list->Pager->RecordCount > 0 && $payment_emp_grp_check_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_emp_grp_check_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_emp_grp_check_list->pageUrl() ?>start=<?php echo $payment_emp_grp_check_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_emp_grp_check_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_emp_grp_check_list->pageUrl() ?>start=<?php echo $payment_emp_grp_check_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_emp_grp_check_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_emp_grp_check_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_emp_grp_check_list->pageUrl() ?>start=<?php echo $payment_emp_grp_check_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_emp_grp_check_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_emp_grp_check_list->pageUrl() ?>start=<?php echo $payment_emp_grp_check_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_emp_grp_check_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_emp_grp_check_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_emp_grp_check_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_emp_grp_check_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_emp_grp_check_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_emp_grp_check_list->TotalRecs > 0 && (!$payment_emp_grp_check_list->AutoHidePageSizeSelector || $payment_emp_grp_check_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_emp_grp_check">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_emp_grp_check_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_emp_grp_check_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_emp_grp_check_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_emp_grp_check_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_emp_grp_check_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_emp_grp_check->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_emp_grp_check_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_emp_grp_check_list->TotalRecs == 0 && !$payment_emp_grp_check->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_emp_grp_check_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_emp_grp_check_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_emp_grp_check->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_emp_grp_check->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_emp_grp_check", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_emp_grp_check_list->terminate();
?>