<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_hs_edit = new payment_hs_edit();

// Run the page
$payment_hs_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_hs_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpayment_hsedit = currentForm = new ew.Form("fpayment_hsedit", "edit");

// Validate form
fpayment_hsedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($payment_hs_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->id->caption(), $payment_hs->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_hs_edit->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->godown->caption(), $payment_hs->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_hs_edit->emp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_emp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->emp_id->caption(), $payment_hs->emp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_hs_edit->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->ref->caption(), $payment_hs->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_hs_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->amount->caption(), $payment_hs->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_hs->amount->errorMessage()) ?>");
		<?php if ($payment_hs_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->remarks->caption(), $payment_hs->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_hs_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->operator->caption(), $payment_hs->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_hs_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->datetime->caption(), $payment_hs->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_hs_edit->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->total_amount->caption(), $payment_hs->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_hs->total_amount->errorMessage()) ?>");
		<?php if ($payment_hs_edit->balance->Required) { ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_hs->balance->caption(), $payment_hs->balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_hs->balance->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpayment_hsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_hsedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_hsedit.lists["x_godown"] = <?php echo $payment_hs_edit->godown->Lookup->toClientList() ?>;
fpayment_hsedit.lists["x_godown"].options = <?php echo JsonEncode($payment_hs_edit->godown->lookupOptions()) ?>;
fpayment_hsedit.lists["x_emp_id"] = <?php echo $payment_hs_edit->emp_id->Lookup->toClientList() ?>;
fpayment_hsedit.lists["x_emp_id"].options = <?php echo JsonEncode($payment_hs_edit->emp_id->lookupOptions()) ?>;
fpayment_hsedit.lists["x_ref"] = <?php echo $payment_hs_edit->ref->Lookup->toClientList() ?>;
fpayment_hsedit.lists["x_ref"].options = <?php echo JsonEncode($payment_hs_edit->ref->lookupOptions()) ?>;
fpayment_hsedit.lists["x_operator"] = <?php echo $payment_hs_edit->operator->Lookup->toClientList() ?>;
fpayment_hsedit.lists["x_operator"].options = <?php echo JsonEncode($payment_hs_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_hs_edit->showPageHeader(); ?>
<?php
$payment_hs_edit->showMessage();
?>
<form name="fpayment_hsedit" id="fpayment_hsedit" class="<?php echo $payment_hs_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_hs_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_hs_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_hs">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$payment_hs_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($payment_hs->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_payment_hs_id" class="<?php echo $payment_hs_edit->LeftColumnClass ?>"><?php echo $payment_hs->id->caption() ?><?php echo ($payment_hs->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_hs_edit->RightColumnClass ?>"><div<?php echo $payment_hs->id->cellAttributes() ?>>
<span id="el_payment_hs_id">
<span<?php echo $payment_hs->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($payment_hs->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="payment_hs" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($payment_hs->id->CurrentValue) ?>">
<?php echo $payment_hs->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_hs->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_payment_hs_godown" for="x_godown" class="<?php echo $payment_hs_edit->LeftColumnClass ?>"><?php echo $payment_hs->godown->caption() ?><?php echo ($payment_hs->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_hs_edit->RightColumnClass ?>"><div<?php echo $payment_hs->godown->cellAttributes() ?>>
<span id="el_payment_hs_godown">
<?php $payment_hs->godown->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$payment_hs->godown->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_hs" data-field="x_godown" data-value-separator="<?php echo $payment_hs->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $payment_hs->godown->editAttributes() ?>>
		<?php echo $payment_hs->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $payment_hs->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $payment_hs->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_hs->emp_id->Visible) { // emp_id ?>
	<div id="r_emp_id" class="form-group row">
		<label id="elh_payment_hs_emp_id" for="x_emp_id" class="<?php echo $payment_hs_edit->LeftColumnClass ?>"><?php echo $payment_hs->emp_id->caption() ?><?php echo ($payment_hs->emp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_hs_edit->RightColumnClass ?>"><div<?php echo $payment_hs->emp_id->cellAttributes() ?>>
<span id="el_payment_hs_emp_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_hs" data-field="x_emp_id" data-value-separator="<?php echo $payment_hs->emp_id->displayValueSeparatorAttribute() ?>" id="x_emp_id" name="x_emp_id"<?php echo $payment_hs->emp_id->editAttributes() ?>>
		<?php echo $payment_hs->emp_id->selectOptionListHtml("x_emp_id") ?>
	</select>
</div>
<?php echo $payment_hs->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
</span>
<?php echo $payment_hs->emp_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_hs->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_payment_hs_ref" for="x_ref" class="<?php echo $payment_hs_edit->LeftColumnClass ?>"><?php echo $payment_hs->ref->caption() ?><?php echo ($payment_hs->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_hs_edit->RightColumnClass ?>"><div<?php echo $payment_hs->ref->cellAttributes() ?>>
<span id="el_payment_hs_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_hs" data-field="x_ref" data-value-separator="<?php echo $payment_hs->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $payment_hs->ref->editAttributes() ?>>
		<?php echo $payment_hs->ref->selectOptionListHtml("x_ref") ?>
	</select>
</div>
<?php echo $payment_hs->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
<?php echo $payment_hs->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_hs->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_payment_hs_amount" for="x_amount" class="<?php echo $payment_hs_edit->LeftColumnClass ?>"><?php echo $payment_hs->amount->caption() ?><?php echo ($payment_hs->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_hs_edit->RightColumnClass ?>"><div<?php echo $payment_hs->amount->cellAttributes() ?>>
<span id="el_payment_hs_amount">
<input type="text" data-table="payment_hs" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($payment_hs->amount->getPlaceHolder()) ?>" value="<?php echo $payment_hs->amount->EditValue ?>"<?php echo $payment_hs->amount->editAttributes() ?>>
</span>
<?php echo $payment_hs->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_hs->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_payment_hs_remarks" for="x_remarks" class="<?php echo $payment_hs_edit->LeftColumnClass ?>"><?php echo $payment_hs->remarks->caption() ?><?php echo ($payment_hs->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_hs_edit->RightColumnClass ?>"><div<?php echo $payment_hs->remarks->cellAttributes() ?>>
<span id="el_payment_hs_remarks">
<input type="text" data-table="payment_hs" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($payment_hs->remarks->getPlaceHolder()) ?>" value="<?php echo $payment_hs->remarks->EditValue ?>"<?php echo $payment_hs->remarks->editAttributes() ?>>
</span>
<?php echo $payment_hs->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_hs->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label id="elh_payment_hs_total_amount" for="x_total_amount" class="<?php echo $payment_hs_edit->LeftColumnClass ?>"><?php echo $payment_hs->total_amount->caption() ?><?php echo ($payment_hs->total_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_hs_edit->RightColumnClass ?>"><div<?php echo $payment_hs->total_amount->cellAttributes() ?>>
<span id="el_payment_hs_total_amount">
<input type="text" data-table="payment_hs" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($payment_hs->total_amount->getPlaceHolder()) ?>" value="<?php echo $payment_hs->total_amount->EditValue ?>"<?php echo $payment_hs->total_amount->editAttributes() ?>>
</span>
<?php echo $payment_hs->total_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_hs->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label id="elh_payment_hs_balance" for="x_balance" class="<?php echo $payment_hs_edit->LeftColumnClass ?>"><?php echo $payment_hs->balance->caption() ?><?php echo ($payment_hs->balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_hs_edit->RightColumnClass ?>"><div<?php echo $payment_hs->balance->cellAttributes() ?>>
<span id="el_payment_hs_balance">
<input type="text" data-table="payment_hs" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($payment_hs->balance->getPlaceHolder()) ?>" value="<?php echo $payment_hs->balance->EditValue ?>"<?php echo $payment_hs->balance->editAttributes() ?>>
</span>
<?php echo $payment_hs->balance->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_hs_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_hs_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payment_hs_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_hs_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_hs_edit->terminate();
?>