<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_hs_list = new payment_hs_list();

// Run the page
$payment_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_hslist = currentForm = new ew.Form("fpayment_hslist", "list");
fpayment_hslist.formKeyCountName = '<?php echo $payment_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_hslist.lists["x_godown"] = <?php echo $payment_hs_list->godown->Lookup->toClientList() ?>;
fpayment_hslist.lists["x_godown"].options = <?php echo JsonEncode($payment_hs_list->godown->lookupOptions()) ?>;
fpayment_hslist.lists["x_emp_id"] = <?php echo $payment_hs_list->emp_id->Lookup->toClientList() ?>;
fpayment_hslist.lists["x_emp_id"].options = <?php echo JsonEncode($payment_hs_list->emp_id->lookupOptions()) ?>;
fpayment_hslist.lists["x_ref"] = <?php echo $payment_hs_list->ref->Lookup->toClientList() ?>;
fpayment_hslist.lists["x_ref"].options = <?php echo JsonEncode($payment_hs_list->ref->lookupOptions()) ?>;
fpayment_hslist.lists["x_operator"] = <?php echo $payment_hs_list->operator->Lookup->toClientList() ?>;
fpayment_hslist.lists["x_operator"].options = <?php echo JsonEncode($payment_hs_list->operator->lookupOptions()) ?>;

// Form object for search
var fpayment_hslistsrch = currentSearchForm = new ew.Form("fpayment_hslistsrch");

// Filters
fpayment_hslistsrch.filterList = <?php echo $payment_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_hs_list->TotalRecs > 0 && $payment_hs_list->ExportOptions->visible()) { ?>
<?php $payment_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_hs_list->ImportOptions->visible()) { ?>
<?php $payment_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_hs_list->SearchOptions->visible()) { ?>
<?php $payment_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_hs_list->FilterOptions->visible()) { ?>
<?php $payment_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_hs->isExport() && !$payment_hs->CurrentAction) { ?>
<form name="fpayment_hslistsrch" id="fpayment_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_hs">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_hs_list->showPageHeader(); ?>
<?php
$payment_hs_list->showMessage();
?>
<?php if ($payment_hs_list->TotalRecs > 0 || $payment_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_hs">
<?php if (!$payment_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_hs_list->Pager)) $payment_hs_list->Pager = new PrevNextPager($payment_hs_list->StartRec, $payment_hs_list->DisplayRecs, $payment_hs_list->TotalRecs, $payment_hs_list->AutoHidePager) ?>
<?php if ($payment_hs_list->Pager->RecordCount > 0 && $payment_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_hs_list->pageUrl() ?>start=<?php echo $payment_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_hs_list->pageUrl() ?>start=<?php echo $payment_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_hs_list->pageUrl() ?>start=<?php echo $payment_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_hs_list->pageUrl() ?>start=<?php echo $payment_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_hs_list->TotalRecs > 0 && (!$payment_hs_list->AutoHidePageSizeSelector || $payment_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_hslist" id="fpayment_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_hs">
<div id="gmp_payment_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_hs_list->TotalRecs > 0 || $payment_hs->isGridEdit()) { ?>
<table id="tbl_payment_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_hs_list->renderListOptions();

// Render list options (header, left)
$payment_hs_list->ListOptions->render("header", "left");
?>
<?php if ($payment_hs->id->Visible) { // id ?>
	<?php if ($payment_hs->sortUrl($payment_hs->id) == "") { ?>
		<th data-name="id" class="<?php echo $payment_hs->id->headerCellClass() ?>"><div id="elh_payment_hs_id" class="payment_hs_id"><div class="ew-table-header-caption"><?php echo $payment_hs->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payment_hs->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->id) ?>',2);"><div id="elh_payment_hs_id" class="payment_hs_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->godown->Visible) { // godown ?>
	<?php if ($payment_hs->sortUrl($payment_hs->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $payment_hs->godown->headerCellClass() ?>"><div id="elh_payment_hs_godown" class="payment_hs_godown"><div class="ew-table-header-caption"><?php echo $payment_hs->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $payment_hs->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->godown) ?>',2);"><div id="elh_payment_hs_godown" class="payment_hs_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->emp_id->Visible) { // emp_id ?>
	<?php if ($payment_hs->sortUrl($payment_hs->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $payment_hs->emp_id->headerCellClass() ?>"><div id="elh_payment_hs_emp_id" class="payment_hs_emp_id"><div class="ew-table-header-caption"><?php echo $payment_hs->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $payment_hs->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->emp_id) ?>',2);"><div id="elh_payment_hs_emp_id" class="payment_hs_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->ref->Visible) { // ref ?>
	<?php if ($payment_hs->sortUrl($payment_hs->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $payment_hs->ref->headerCellClass() ?>"><div id="elh_payment_hs_ref" class="payment_hs_ref"><div class="ew-table-header-caption"><?php echo $payment_hs->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $payment_hs->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->ref) ?>',2);"><div id="elh_payment_hs_ref" class="payment_hs_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->amount->Visible) { // amount ?>
	<?php if ($payment_hs->sortUrl($payment_hs->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $payment_hs->amount->headerCellClass() ?>"><div id="elh_payment_hs_amount" class="payment_hs_amount"><div class="ew-table-header-caption"><?php echo $payment_hs->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $payment_hs->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->amount) ?>',2);"><div id="elh_payment_hs_amount" class="payment_hs_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->remarks->Visible) { // remarks ?>
	<?php if ($payment_hs->sortUrl($payment_hs->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $payment_hs->remarks->headerCellClass() ?>"><div id="elh_payment_hs_remarks" class="payment_hs_remarks"><div class="ew-table-header-caption"><?php echo $payment_hs->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $payment_hs->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->remarks) ?>',2);"><div id="elh_payment_hs_remarks" class="payment_hs_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->operator->Visible) { // operator ?>
	<?php if ($payment_hs->sortUrl($payment_hs->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $payment_hs->operator->headerCellClass() ?>"><div id="elh_payment_hs_operator" class="payment_hs_operator"><div class="ew-table-header-caption"><?php echo $payment_hs->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $payment_hs->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->operator) ?>',2);"><div id="elh_payment_hs_operator" class="payment_hs_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->datetime->Visible) { // datetime ?>
	<?php if ($payment_hs->sortUrl($payment_hs->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payment_hs->datetime->headerCellClass() ?>"><div id="elh_payment_hs_datetime" class="payment_hs_datetime"><div class="ew-table-header-caption"><?php echo $payment_hs->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payment_hs->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->datetime) ?>',2);"><div id="elh_payment_hs_datetime" class="payment_hs_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->total_amount->Visible) { // total_amount ?>
	<?php if ($payment_hs->sortUrl($payment_hs->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $payment_hs->total_amount->headerCellClass() ?>"><div id="elh_payment_hs_total_amount" class="payment_hs_total_amount"><div class="ew-table-header-caption"><?php echo $payment_hs->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $payment_hs->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->total_amount) ?>',2);"><div id="elh_payment_hs_total_amount" class="payment_hs_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->total_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_hs->balance->Visible) { // balance ?>
	<?php if ($payment_hs->sortUrl($payment_hs->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $payment_hs->balance->headerCellClass() ?>"><div id="elh_payment_hs_balance" class="payment_hs_balance"><div class="ew-table-header-caption"><?php echo $payment_hs->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $payment_hs->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_hs->SortUrl($payment_hs->balance) ?>',2);"><div id="elh_payment_hs_balance" class="payment_hs_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_hs->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_hs->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_hs->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_hs->ExportAll && $payment_hs->isExport()) {
	$payment_hs_list->StopRec = $payment_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_hs_list->TotalRecs > $payment_hs_list->StartRec + $payment_hs_list->DisplayRecs - 1)
		$payment_hs_list->StopRec = $payment_hs_list->StartRec + $payment_hs_list->DisplayRecs - 1;
	else
		$payment_hs_list->StopRec = $payment_hs_list->TotalRecs;
}
$payment_hs_list->RecCnt = $payment_hs_list->StartRec - 1;
if ($payment_hs_list->Recordset && !$payment_hs_list->Recordset->EOF) {
	$payment_hs_list->Recordset->moveFirst();
	$selectLimit = $payment_hs_list->UseSelectLimit;
	if (!$selectLimit && $payment_hs_list->StartRec > 1)
		$payment_hs_list->Recordset->move($payment_hs_list->StartRec - 1);
} elseif (!$payment_hs->AllowAddDeleteRow && $payment_hs_list->StopRec == 0) {
	$payment_hs_list->StopRec = $payment_hs->GridAddRowCount;
}

// Initialize aggregate
$payment_hs->RowType = ROWTYPE_AGGREGATEINIT;
$payment_hs->resetAttributes();
$payment_hs_list->renderRow();
while ($payment_hs_list->RecCnt < $payment_hs_list->StopRec) {
	$payment_hs_list->RecCnt++;
	if ($payment_hs_list->RecCnt >= $payment_hs_list->StartRec) {
		$payment_hs_list->RowCnt++;

		// Set up key count
		$payment_hs_list->KeyCount = $payment_hs_list->RowIndex;

		// Init row class and style
		$payment_hs->resetAttributes();
		$payment_hs->CssClass = "";
		if ($payment_hs->isGridAdd()) {
		} else {
			$payment_hs_list->loadRowValues($payment_hs_list->Recordset); // Load row values
		}
		$payment_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_hs->RowAttrs = array_merge($payment_hs->RowAttrs, array('data-rowindex'=>$payment_hs_list->RowCnt, 'id'=>'r' . $payment_hs_list->RowCnt . '_payment_hs', 'data-rowtype'=>$payment_hs->RowType));

		// Render row
		$payment_hs_list->renderRow();

		// Render list options
		$payment_hs_list->renderListOptions();
?>
	<tr<?php echo $payment_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_hs_list->ListOptions->render("body", "left", $payment_hs_list->RowCnt);
?>
	<?php if ($payment_hs->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payment_hs->id->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_id" class="payment_hs_id">
<span<?php echo $payment_hs->id->viewAttributes() ?>>
<?php echo $payment_hs->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $payment_hs->godown->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_godown" class="payment_hs_godown">
<span<?php echo $payment_hs->godown->viewAttributes() ?>>
<?php echo $payment_hs->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $payment_hs->emp_id->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_emp_id" class="payment_hs_emp_id">
<span<?php echo $payment_hs->emp_id->viewAttributes() ?>>
<?php echo $payment_hs->emp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $payment_hs->ref->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_ref" class="payment_hs_ref">
<span<?php echo $payment_hs->ref->viewAttributes() ?>>
<?php echo $payment_hs->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $payment_hs->amount->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_amount" class="payment_hs_amount">
<span<?php echo $payment_hs->amount->viewAttributes() ?>>
<?php echo $payment_hs->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $payment_hs->remarks->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_remarks" class="payment_hs_remarks">
<span<?php echo $payment_hs->remarks->viewAttributes() ?>>
<?php echo $payment_hs->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $payment_hs->operator->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_operator" class="payment_hs_operator">
<span<?php echo $payment_hs->operator->viewAttributes() ?>>
<?php echo $payment_hs->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payment_hs->datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_datetime" class="payment_hs_datetime">
<span<?php echo $payment_hs->datetime->viewAttributes() ?>>
<?php echo $payment_hs->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $payment_hs->total_amount->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_total_amount" class="payment_hs_total_amount">
<span<?php echo $payment_hs->total_amount->viewAttributes() ?>>
<?php echo $payment_hs->total_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_hs->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $payment_hs->balance->cellAttributes() ?>>
<span id="el<?php echo $payment_hs_list->RowCnt ?>_payment_hs_balance" class="payment_hs_balance">
<span<?php echo $payment_hs->balance->viewAttributes() ?>>
<?php echo $payment_hs->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_hs_list->ListOptions->render("body", "right", $payment_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_hs->isGridAdd())
		$payment_hs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_hs_list->Recordset)
	$payment_hs_list->Recordset->Close();
?>
<?php if (!$payment_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_hs_list->Pager)) $payment_hs_list->Pager = new PrevNextPager($payment_hs_list->StartRec, $payment_hs_list->DisplayRecs, $payment_hs_list->TotalRecs, $payment_hs_list->AutoHidePager) ?>
<?php if ($payment_hs_list->Pager->RecordCount > 0 && $payment_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_hs_list->pageUrl() ?>start=<?php echo $payment_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_hs_list->pageUrl() ?>start=<?php echo $payment_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_hs_list->pageUrl() ?>start=<?php echo $payment_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_hs_list->pageUrl() ?>start=<?php echo $payment_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_hs_list->TotalRecs > 0 && (!$payment_hs_list->AutoHidePageSizeSelector || $payment_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_hs_list->TotalRecs == 0 && !$payment_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_hs_list->terminate();
?>