<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_hs_view = new payment_hs_view();

// Run the page
$payment_hs_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_hs_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpayment_hsview = currentForm = new ew.Form("fpayment_hsview", "view");

// Form_CustomValidate event
fpayment_hsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_hsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_hsview.lists["x_godown"] = <?php echo $payment_hs_view->godown->Lookup->toClientList() ?>;
fpayment_hsview.lists["x_godown"].options = <?php echo JsonEncode($payment_hs_view->godown->lookupOptions()) ?>;
fpayment_hsview.lists["x_emp_id"] = <?php echo $payment_hs_view->emp_id->Lookup->toClientList() ?>;
fpayment_hsview.lists["x_emp_id"].options = <?php echo JsonEncode($payment_hs_view->emp_id->lookupOptions()) ?>;
fpayment_hsview.lists["x_ref"] = <?php echo $payment_hs_view->ref->Lookup->toClientList() ?>;
fpayment_hsview.lists["x_ref"].options = <?php echo JsonEncode($payment_hs_view->ref->lookupOptions()) ?>;
fpayment_hsview.lists["x_operator"] = <?php echo $payment_hs_view->operator->Lookup->toClientList() ?>;
fpayment_hsview.lists["x_operator"].options = <?php echo JsonEncode($payment_hs_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $payment_hs_view->ExportOptions->render("body") ?>
<?php $payment_hs_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $payment_hs_view->showPageHeader(); ?>
<?php
$payment_hs_view->showMessage();
?>
<form name="fpayment_hsview" id="fpayment_hsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_hs_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_hs_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_hs">
<input type="hidden" name="modal" value="<?php echo (int)$payment_hs_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($payment_hs->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_id"><?php echo $payment_hs->id->caption() ?></span></td>
		<td data-name="id"<?php echo $payment_hs->id->cellAttributes() ?>>
<span id="el_payment_hs_id">
<span<?php echo $payment_hs->id->viewAttributes() ?>>
<?php echo $payment_hs->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_godown"><?php echo $payment_hs->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $payment_hs->godown->cellAttributes() ?>>
<span id="el_payment_hs_godown">
<span<?php echo $payment_hs->godown->viewAttributes() ?>>
<?php echo $payment_hs->godown->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->emp_id->Visible) { // emp_id ?>
	<tr id="r_emp_id">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_emp_id"><?php echo $payment_hs->emp_id->caption() ?></span></td>
		<td data-name="emp_id"<?php echo $payment_hs->emp_id->cellAttributes() ?>>
<span id="el_payment_hs_emp_id">
<span<?php echo $payment_hs->emp_id->viewAttributes() ?>>
<?php echo $payment_hs->emp_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->ref->Visible) { // ref ?>
	<tr id="r_ref">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_ref"><?php echo $payment_hs->ref->caption() ?></span></td>
		<td data-name="ref"<?php echo $payment_hs->ref->cellAttributes() ?>>
<span id="el_payment_hs_ref">
<span<?php echo $payment_hs->ref->viewAttributes() ?>>
<?php echo $payment_hs->ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_amount"><?php echo $payment_hs->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $payment_hs->amount->cellAttributes() ?>>
<span id="el_payment_hs_amount">
<span<?php echo $payment_hs->amount->viewAttributes() ?>>
<?php echo $payment_hs->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_remarks"><?php echo $payment_hs->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $payment_hs->remarks->cellAttributes() ?>>
<span id="el_payment_hs_remarks">
<span<?php echo $payment_hs->remarks->viewAttributes() ?>>
<?php echo $payment_hs->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_operator"><?php echo $payment_hs->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $payment_hs->operator->cellAttributes() ?>>
<span id="el_payment_hs_operator">
<span<?php echo $payment_hs->operator->viewAttributes() ?>>
<?php echo $payment_hs->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_datetime"><?php echo $payment_hs->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $payment_hs->datetime->cellAttributes() ?>>
<span id="el_payment_hs_datetime">
<span<?php echo $payment_hs->datetime->viewAttributes() ?>>
<?php echo $payment_hs->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->total_amount->Visible) { // total_amount ?>
	<tr id="r_total_amount">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_total_amount"><?php echo $payment_hs->total_amount->caption() ?></span></td>
		<td data-name="total_amount"<?php echo $payment_hs->total_amount->cellAttributes() ?>>
<span id="el_payment_hs_total_amount">
<span<?php echo $payment_hs->total_amount->viewAttributes() ?>>
<?php echo $payment_hs->total_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_hs->balance->Visible) { // balance ?>
	<tr id="r_balance">
		<td class="<?php echo $payment_hs_view->TableLeftColumnClass ?>"><span id="elh_payment_hs_balance"><?php echo $payment_hs->balance->caption() ?></span></td>
		<td data-name="balance"<?php echo $payment_hs->balance->cellAttributes() ?>>
<span id="el_payment_hs_balance">
<span<?php echo $payment_hs->balance->viewAttributes() ?>>
<?php echo $payment_hs->balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$payment_hs_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_hs_view->terminate();
?>