<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_period_fp_view = new payment_period_fp_view();

// Run the page
$payment_period_fp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_period_fp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_period_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpayment_period_fpview = currentForm = new ew.Form("fpayment_period_fpview", "view");

// Form_CustomValidate event
fpayment_period_fpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_period_fpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_period_fpview.lists["x_grp"] = <?php echo $payment_period_fp_view->grp->Lookup->toClientList() ?>;
fpayment_period_fpview.lists["x_grp"].options = <?php echo JsonEncode($payment_period_fp_view->grp->options(FALSE, TRUE)) ?>;
fpayment_period_fpview.lists["x_process[]"] = <?php echo $payment_period_fp_view->process->Lookup->toClientList() ?>;
fpayment_period_fpview.lists["x_process[]"].options = <?php echo JsonEncode($payment_period_fp_view->process->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_period_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $payment_period_fp_view->ExportOptions->render("body") ?>
<?php $payment_period_fp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $payment_period_fp_view->showPageHeader(); ?>
<?php
$payment_period_fp_view->showMessage();
?>
<form name="fpayment_period_fpview" id="fpayment_period_fpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_period_fp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_period_fp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_period_fp">
<input type="hidden" name="modal" value="<?php echo (int)$payment_period_fp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($payment_period_fp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $payment_period_fp_view->TableLeftColumnClass ?>"><span id="elh_payment_period_fp_id"><?php echo $payment_period_fp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $payment_period_fp->id->cellAttributes() ?>>
<span id="el_payment_period_fp_id">
<span<?php echo $payment_period_fp->id->viewAttributes() ?>>
<?php echo $payment_period_fp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period_fp->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $payment_period_fp_view->TableLeftColumnClass ?>"><span id="elh_payment_period_fp_grp"><?php echo $payment_period_fp->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $payment_period_fp->grp->cellAttributes() ?>>
<span id="el_payment_period_fp_grp">
<span<?php echo $payment_period_fp->grp->viewAttributes() ?>>
<?php echo $payment_period_fp->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period_fp->from_date->Visible) { // from_date ?>
	<tr id="r_from_date">
		<td class="<?php echo $payment_period_fp_view->TableLeftColumnClass ?>"><span id="elh_payment_period_fp_from_date"><?php echo $payment_period_fp->from_date->caption() ?></span></td>
		<td data-name="from_date"<?php echo $payment_period_fp->from_date->cellAttributes() ?>>
<span id="el_payment_period_fp_from_date">
<span<?php echo $payment_period_fp->from_date->viewAttributes() ?>>
<?php echo $payment_period_fp->from_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period_fp->to_date->Visible) { // to_date ?>
	<tr id="r_to_date">
		<td class="<?php echo $payment_period_fp_view->TableLeftColumnClass ?>"><span id="elh_payment_period_fp_to_date"><?php echo $payment_period_fp->to_date->caption() ?></span></td>
		<td data-name="to_date"<?php echo $payment_period_fp->to_date->cellAttributes() ?>>
<span id="el_payment_period_fp_to_date">
<span<?php echo $payment_period_fp->to_date->viewAttributes() ?>>
<?php echo $payment_period_fp->to_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period_fp->payment_description->Visible) { // payment_description ?>
	<tr id="r_payment_description">
		<td class="<?php echo $payment_period_fp_view->TableLeftColumnClass ?>"><span id="elh_payment_period_fp_payment_description"><?php echo $payment_period_fp->payment_description->caption() ?></span></td>
		<td data-name="payment_description"<?php echo $payment_period_fp->payment_description->cellAttributes() ?>>
<span id="el_payment_period_fp_payment_description">
<span<?php echo $payment_period_fp->payment_description->viewAttributes() ?>>
<?php echo $payment_period_fp->payment_description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period_fp->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $payment_period_fp_view->TableLeftColumnClass ?>"><span id="elh_payment_period_fp_process"><?php echo $payment_period_fp->process->caption() ?></span></td>
		<td data-name="process"<?php echo $payment_period_fp->process->cellAttributes() ?>>
<span id="el_payment_period_fp_process">
<span<?php echo $payment_period_fp->process->viewAttributes() ?>>
<?php if ((!EmptyString($payment_period_fp->process->getViewValue())) && $payment_period_fp->process->linkAttributes() <> "") { ?>
<a<?php echo $payment_period_fp->process->linkAttributes() ?>><?php echo $payment_period_fp->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_period_fp->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$payment_period_fp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_period_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_period_fp_view->terminate();
?>