<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_period_add = new payment_period_add();

// Run the page
$payment_period_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_period_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpayment_periodadd = currentForm = new ew.Form("fpayment_periodadd", "add");

// Validate form
fpayment_periodadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($payment_period_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->location->caption(), $payment_period->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_period_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->grp->caption(), $payment_period->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_period_add->from_date->Required) { ?>
			elm = this.getElements("x" + infix + "_from_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->from_date->caption(), $payment_period->from_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_from_date");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_period->from_date->errorMessage()) ?>");
		<?php if ($payment_period_add->to_date->Required) { ?>
			elm = this.getElements("x" + infix + "_to_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->to_date->caption(), $payment_period->to_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_to_date");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_period->to_date->errorMessage()) ?>");
		<?php if ($payment_period_add->payment_description->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->payment_description->caption(), $payment_period->payment_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_period_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->process->caption(), $payment_period->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_period_add->transfer_account->Required) { ?>
			elm = this.getElements("x" + infix + "_transfer_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->transfer_account->caption(), $payment_period->transfer_account->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_period_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->operator->caption(), $payment_period->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_period_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_period->datetime->caption(), $payment_period->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpayment_periodadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_periodadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_periodadd.lists["x_location[]"] = <?php echo $payment_period_add->location->Lookup->toClientList() ?>;
fpayment_periodadd.lists["x_location[]"].options = <?php echo JsonEncode($payment_period_add->location->lookupOptions()) ?>;
fpayment_periodadd.lists["x_grp"] = <?php echo $payment_period_add->grp->Lookup->toClientList() ?>;
fpayment_periodadd.lists["x_grp"].options = <?php echo JsonEncode($payment_period_add->grp->lookupOptions()) ?>;
fpayment_periodadd.lists["x_process[]"] = <?php echo $payment_period_add->process->Lookup->toClientList() ?>;
fpayment_periodadd.lists["x_process[]"].options = <?php echo JsonEncode($payment_period_add->process->lookupOptions()) ?>;
fpayment_periodadd.lists["x_transfer_account"] = <?php echo $payment_period_add->transfer_account->Lookup->toClientList() ?>;
fpayment_periodadd.lists["x_transfer_account"].options = <?php echo JsonEncode($payment_period_add->transfer_account->lookupOptions()) ?>;
fpayment_periodadd.lists["x_operator"] = <?php echo $payment_period_add->operator->Lookup->toClientList() ?>;
fpayment_periodadd.lists["x_operator"].options = <?php echo JsonEncode($payment_period_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_period_add->showPageHeader(); ?>
<?php
$payment_period_add->showMessage();
?>
<form name="fpayment_periodadd" id="fpayment_periodadd" class="<?php echo $payment_period_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_period_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_period_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_period">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$payment_period_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($payment_period->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_payment_period_location" class="<?php echo $payment_period_add->LeftColumnClass ?>"><?php echo $payment_period->location->caption() ?><?php echo ($payment_period->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_period_add->RightColumnClass ?>"><div<?php echo $payment_period->location->cellAttributes() ?>>
<span id="el_payment_period_location">
<div id="tp_x_location" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_period" data-field="x_location" data-value-separator="<?php echo $payment_period->location->displayValueSeparatorAttribute() ?>" name="x_location[]" id="x_location[]" value="{value}"<?php echo $payment_period->location->editAttributes() ?>></div>
<div id="dsl_x_location" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payment_period->location->checkBoxListHtml(FALSE, "x_location[]") ?>
</div></div>
<?php echo $payment_period->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $payment_period->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_period->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_payment_period_grp" for="x_grp" class="<?php echo $payment_period_add->LeftColumnClass ?>"><?php echo $payment_period->grp->caption() ?><?php echo ($payment_period->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_period_add->RightColumnClass ?>"><div<?php echo $payment_period->grp->cellAttributes() ?>>
<span id="el_payment_period_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_period" data-field="x_grp" data-value-separator="<?php echo $payment_period->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $payment_period->grp->editAttributes() ?>>
		<?php echo $payment_period->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $payment_period->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $payment_period->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_period->from_date->Visible) { // from_date ?>
	<div id="r_from_date" class="form-group row">
		<label id="elh_payment_period_from_date" for="x_from_date" class="<?php echo $payment_period_add->LeftColumnClass ?>"><?php echo $payment_period->from_date->caption() ?><?php echo ($payment_period->from_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_period_add->RightColumnClass ?>"><div<?php echo $payment_period->from_date->cellAttributes() ?>>
<span id="el_payment_period_from_date">
<input type="text" data-table="payment_period" data-field="x_from_date" data-format="11" name="x_from_date" id="x_from_date" placeholder="<?php echo HtmlEncode($payment_period->from_date->getPlaceHolder()) ?>" value="<?php echo $payment_period->from_date->EditValue ?>"<?php echo $payment_period->from_date->editAttributes() ?>>
<?php if (!$payment_period->from_date->ReadOnly && !$payment_period->from_date->Disabled && !isset($payment_period->from_date->EditAttrs["readonly"]) && !isset($payment_period->from_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_periodadd", "x_from_date", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
<?php echo $payment_period->from_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_period->to_date->Visible) { // to_date ?>
	<div id="r_to_date" class="form-group row">
		<label id="elh_payment_period_to_date" for="x_to_date" class="<?php echo $payment_period_add->LeftColumnClass ?>"><?php echo $payment_period->to_date->caption() ?><?php echo ($payment_period->to_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_period_add->RightColumnClass ?>"><div<?php echo $payment_period->to_date->cellAttributes() ?>>
<span id="el_payment_period_to_date">
<input type="text" data-table="payment_period" data-field="x_to_date" data-format="11" name="x_to_date" id="x_to_date" placeholder="<?php echo HtmlEncode($payment_period->to_date->getPlaceHolder()) ?>" value="<?php echo $payment_period->to_date->EditValue ?>"<?php echo $payment_period->to_date->editAttributes() ?>>
<?php if (!$payment_period->to_date->ReadOnly && !$payment_period->to_date->Disabled && !isset($payment_period->to_date->EditAttrs["readonly"]) && !isset($payment_period->to_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_periodadd", "x_to_date", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
<?php echo $payment_period->to_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_period->payment_description->Visible) { // payment_description ?>
	<div id="r_payment_description" class="form-group row">
		<label id="elh_payment_period_payment_description" for="x_payment_description" class="<?php echo $payment_period_add->LeftColumnClass ?>"><?php echo $payment_period->payment_description->caption() ?><?php echo ($payment_period->payment_description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_period_add->RightColumnClass ?>"><div<?php echo $payment_period->payment_description->cellAttributes() ?>>
<span id="el_payment_period_payment_description">
<input type="text" data-table="payment_period" data-field="x_payment_description" name="x_payment_description" id="x_payment_description" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($payment_period->payment_description->getPlaceHolder()) ?>" value="<?php echo $payment_period->payment_description->EditValue ?>"<?php echo $payment_period->payment_description->editAttributes() ?>>
</span>
<?php echo $payment_period->payment_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_period->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_payment_period_process" class="<?php echo $payment_period_add->LeftColumnClass ?>"><?php echo $payment_period->process->caption() ?><?php echo ($payment_period->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_period_add->RightColumnClass ?>"><div<?php echo $payment_period->process->cellAttributes() ?>>
<span id="el_payment_period_process">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_period" data-field="x_process" data-value-separator="<?php echo $payment_period->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $payment_period->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payment_period->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $payment_period->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $payment_period->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_period->transfer_account->Visible) { // transfer_account ?>
	<div id="r_transfer_account" class="form-group row">
		<label id="elh_payment_period_transfer_account" for="x_transfer_account" class="<?php echo $payment_period_add->LeftColumnClass ?>"><?php echo $payment_period->transfer_account->caption() ?><?php echo ($payment_period->transfer_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_period_add->RightColumnClass ?>"><div<?php echo $payment_period->transfer_account->cellAttributes() ?>>
<span id="el_payment_period_transfer_account">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_period" data-field="x_transfer_account" data-value-separator="<?php echo $payment_period->transfer_account->displayValueSeparatorAttribute() ?>" id="x_transfer_account" name="x_transfer_account"<?php echo $payment_period->transfer_account->editAttributes() ?>>
		<?php echo $payment_period->transfer_account->selectOptionListHtml("x_transfer_account") ?>
	</select>
</div>
<?php echo $payment_period->transfer_account->Lookup->getParamTag("p_x_transfer_account") ?>
</span>
<?php echo $payment_period->transfer_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_period_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_period_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payment_period_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_period_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_period_add->terminate();
?>