<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_period_list = new payment_period_list();

// Run the page
$payment_period_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_period_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_period->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_periodlist = currentForm = new ew.Form("fpayment_periodlist", "list");
fpayment_periodlist.formKeyCountName = '<?php echo $payment_period_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_periodlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_periodlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_periodlist.lists["x_location[]"] = <?php echo $payment_period_list->location->Lookup->toClientList() ?>;
fpayment_periodlist.lists["x_location[]"].options = <?php echo JsonEncode($payment_period_list->location->lookupOptions()) ?>;
fpayment_periodlist.lists["x_grp"] = <?php echo $payment_period_list->grp->Lookup->toClientList() ?>;
fpayment_periodlist.lists["x_grp"].options = <?php echo JsonEncode($payment_period_list->grp->lookupOptions()) ?>;
fpayment_periodlist.lists["x_process[]"] = <?php echo $payment_period_list->process->Lookup->toClientList() ?>;
fpayment_periodlist.lists["x_process[]"].options = <?php echo JsonEncode($payment_period_list->process->lookupOptions()) ?>;
fpayment_periodlist.lists["x_transfer_account"] = <?php echo $payment_period_list->transfer_account->Lookup->toClientList() ?>;
fpayment_periodlist.lists["x_transfer_account"].options = <?php echo JsonEncode($payment_period_list->transfer_account->lookupOptions()) ?>;
fpayment_periodlist.lists["x_transfer_by"] = <?php echo $payment_period_list->transfer_by->Lookup->toClientList() ?>;
fpayment_periodlist.lists["x_transfer_by"].options = <?php echo JsonEncode($payment_period_list->transfer_by->lookupOptions()) ?>;
fpayment_periodlist.lists["x_operator"] = <?php echo $payment_period_list->operator->Lookup->toClientList() ?>;
fpayment_periodlist.lists["x_operator"].options = <?php echo JsonEncode($payment_period_list->operator->lookupOptions()) ?>;

// Form object for search
var fpayment_periodlistsrch = currentSearchForm = new ew.Form("fpayment_periodlistsrch");

// Filters
fpayment_periodlistsrch.filterList = <?php echo $payment_period_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_periodlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_period->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_period_list->TotalRecs > 0 && $payment_period_list->ExportOptions->visible()) { ?>
<?php $payment_period_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_period_list->ImportOptions->visible()) { ?>
<?php $payment_period_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_period_list->SearchOptions->visible()) { ?>
<?php $payment_period_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_period_list->FilterOptions->visible()) { ?>
<?php $payment_period_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_period_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_period->isExport() && !$payment_period->CurrentAction) { ?>
<form name="fpayment_periodlistsrch" id="fpayment_periodlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_period_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_periodlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_period">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_period_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_period_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_period_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_period_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_period_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_period_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_period_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_period_list->showPageHeader(); ?>
<?php
$payment_period_list->showMessage();
?>
<?php if ($payment_period_list->TotalRecs > 0 || $payment_period->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_period_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_period">
<?php if (!$payment_period->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_period->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_period_list->Pager)) $payment_period_list->Pager = new PrevNextPager($payment_period_list->StartRec, $payment_period_list->DisplayRecs, $payment_period_list->TotalRecs, $payment_period_list->AutoHidePager) ?>
<?php if ($payment_period_list->Pager->RecordCount > 0 && $payment_period_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_period_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_period_list->pageUrl() ?>start=<?php echo $payment_period_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_period_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_period_list->pageUrl() ?>start=<?php echo $payment_period_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_period_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_period_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_period_list->pageUrl() ?>start=<?php echo $payment_period_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_period_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_period_list->pageUrl() ?>start=<?php echo $payment_period_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_period_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_period_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_period_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_period_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_period_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_period_list->TotalRecs > 0 && (!$payment_period_list->AutoHidePageSizeSelector || $payment_period_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_period">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_period_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_period_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_period_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_period_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_period_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_period->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_period_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_periodlist" id="fpayment_periodlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_period_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_period_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_period">
<div id="gmp_payment_period" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_period_list->TotalRecs > 0 || $payment_period->isGridEdit()) { ?>
<table id="tbl_payment_periodlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_period_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_period_list->renderListOptions();

// Render list options (header, left)
$payment_period_list->ListOptions->render("header", "left");
?>
<?php if ($payment_period->id->Visible) { // id ?>
	<?php if ($payment_period->sortUrl($payment_period->id) == "") { ?>
		<th data-name="id" class="<?php echo $payment_period->id->headerCellClass() ?>"><div id="elh_payment_period_id" class="payment_period_id"><div class="ew-table-header-caption"><?php echo $payment_period->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payment_period->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->id) ?>',2);"><div id="elh_payment_period_id" class="payment_period_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->location->Visible) { // location ?>
	<?php if ($payment_period->sortUrl($payment_period->location) == "") { ?>
		<th data-name="location" class="<?php echo $payment_period->location->headerCellClass() ?>"><div id="elh_payment_period_location" class="payment_period_location"><div class="ew-table-header-caption"><?php echo $payment_period->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $payment_period->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->location) ?>',2);"><div id="elh_payment_period_location" class="payment_period_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->grp->Visible) { // grp ?>
	<?php if ($payment_period->sortUrl($payment_period->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $payment_period->grp->headerCellClass() ?>"><div id="elh_payment_period_grp" class="payment_period_grp"><div class="ew-table-header-caption"><?php echo $payment_period->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $payment_period->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->grp) ?>',2);"><div id="elh_payment_period_grp" class="payment_period_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->from_date->Visible) { // from_date ?>
	<?php if ($payment_period->sortUrl($payment_period->from_date) == "") { ?>
		<th data-name="from_date" class="<?php echo $payment_period->from_date->headerCellClass() ?>"><div id="elh_payment_period_from_date" class="payment_period_from_date"><div class="ew-table-header-caption"><?php echo $payment_period->from_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from_date" class="<?php echo $payment_period->from_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->from_date) ?>',2);"><div id="elh_payment_period_from_date" class="payment_period_from_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->from_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->from_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->from_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->to_date->Visible) { // to_date ?>
	<?php if ($payment_period->sortUrl($payment_period->to_date) == "") { ?>
		<th data-name="to_date" class="<?php echo $payment_period->to_date->headerCellClass() ?>"><div id="elh_payment_period_to_date" class="payment_period_to_date"><div class="ew-table-header-caption"><?php echo $payment_period->to_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_date" class="<?php echo $payment_period->to_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->to_date) ?>',2);"><div id="elh_payment_period_to_date" class="payment_period_to_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->to_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->to_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->to_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->payment_description->Visible) { // payment_description ?>
	<?php if ($payment_period->sortUrl($payment_period->payment_description) == "") { ?>
		<th data-name="payment_description" class="<?php echo $payment_period->payment_description->headerCellClass() ?>"><div id="elh_payment_period_payment_description" class="payment_period_payment_description"><div class="ew-table-header-caption"><?php echo $payment_period->payment_description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_description" class="<?php echo $payment_period->payment_description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->payment_description) ?>',2);"><div id="elh_payment_period_payment_description" class="payment_period_payment_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->payment_description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_period->payment_description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->payment_description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->process->Visible) { // process ?>
	<?php if ($payment_period->sortUrl($payment_period->process) == "") { ?>
		<th data-name="process" class="<?php echo $payment_period->process->headerCellClass() ?>"><div id="elh_payment_period_process" class="payment_period_process"><div class="ew-table-header-caption"><?php echo $payment_period->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $payment_period->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->process) ?>',2);"><div id="elh_payment_period_process" class="payment_period_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->transfer_account->Visible) { // transfer_account ?>
	<?php if ($payment_period->sortUrl($payment_period->transfer_account) == "") { ?>
		<th data-name="transfer_account" class="<?php echo $payment_period->transfer_account->headerCellClass() ?>"><div id="elh_payment_period_transfer_account" class="payment_period_transfer_account"><div class="ew-table-header-caption"><?php echo $payment_period->transfer_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_account" class="<?php echo $payment_period->transfer_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->transfer_account) ?>',2);"><div id="elh_payment_period_transfer_account" class="payment_period_transfer_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->transfer_account->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->transfer_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->transfer_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->transfer_by->Visible) { // transfer_by ?>
	<?php if ($payment_period->sortUrl($payment_period->transfer_by) == "") { ?>
		<th data-name="transfer_by" class="<?php echo $payment_period->transfer_by->headerCellClass() ?>"><div id="elh_payment_period_transfer_by" class="payment_period_transfer_by"><div class="ew-table-header-caption"><?php echo $payment_period->transfer_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_by" class="<?php echo $payment_period->transfer_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->transfer_by) ?>',2);"><div id="elh_payment_period_transfer_by" class="payment_period_transfer_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->transfer_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->transfer_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->transfer_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->transfer_datetime->Visible) { // transfer_datetime ?>
	<?php if ($payment_period->sortUrl($payment_period->transfer_datetime) == "") { ?>
		<th data-name="transfer_datetime" class="<?php echo $payment_period->transfer_datetime->headerCellClass() ?>"><div id="elh_payment_period_transfer_datetime" class="payment_period_transfer_datetime"><div class="ew-table-header-caption"><?php echo $payment_period->transfer_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_datetime" class="<?php echo $payment_period->transfer_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->transfer_datetime) ?>',2);"><div id="elh_payment_period_transfer_datetime" class="payment_period_transfer_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->transfer_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->transfer_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->transfer_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->operator->Visible) { // operator ?>
	<?php if ($payment_period->sortUrl($payment_period->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $payment_period->operator->headerCellClass() ?>"><div id="elh_payment_period_operator" class="payment_period_operator"><div class="ew-table-header-caption"><?php echo $payment_period->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $payment_period->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->operator) ?>',2);"><div id="elh_payment_period_operator" class="payment_period_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_period->datetime->Visible) { // datetime ?>
	<?php if ($payment_period->sortUrl($payment_period->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payment_period->datetime->headerCellClass() ?>"><div id="elh_payment_period_datetime" class="payment_period_datetime"><div class="ew-table-header-caption"><?php echo $payment_period->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payment_period->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_period->SortUrl($payment_period->datetime) ?>',2);"><div id="elh_payment_period_datetime" class="payment_period_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_period->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_period->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_period->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_period_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_period->ExportAll && $payment_period->isExport()) {
	$payment_period_list->StopRec = $payment_period_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_period_list->TotalRecs > $payment_period_list->StartRec + $payment_period_list->DisplayRecs - 1)
		$payment_period_list->StopRec = $payment_period_list->StartRec + $payment_period_list->DisplayRecs - 1;
	else
		$payment_period_list->StopRec = $payment_period_list->TotalRecs;
}
$payment_period_list->RecCnt = $payment_period_list->StartRec - 1;
if ($payment_period_list->Recordset && !$payment_period_list->Recordset->EOF) {
	$payment_period_list->Recordset->moveFirst();
	$selectLimit = $payment_period_list->UseSelectLimit;
	if (!$selectLimit && $payment_period_list->StartRec > 1)
		$payment_period_list->Recordset->move($payment_period_list->StartRec - 1);
} elseif (!$payment_period->AllowAddDeleteRow && $payment_period_list->StopRec == 0) {
	$payment_period_list->StopRec = $payment_period->GridAddRowCount;
}

// Initialize aggregate
$payment_period->RowType = ROWTYPE_AGGREGATEINIT;
$payment_period->resetAttributes();
$payment_period_list->renderRow();
while ($payment_period_list->RecCnt < $payment_period_list->StopRec) {
	$payment_period_list->RecCnt++;
	if ($payment_period_list->RecCnt >= $payment_period_list->StartRec) {
		$payment_period_list->RowCnt++;

		// Set up key count
		$payment_period_list->KeyCount = $payment_period_list->RowIndex;

		// Init row class and style
		$payment_period->resetAttributes();
		$payment_period->CssClass = "";
		if ($payment_period->isGridAdd()) {
		} else {
			$payment_period_list->loadRowValues($payment_period_list->Recordset); // Load row values
		}
		$payment_period->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_period->RowAttrs = array_merge($payment_period->RowAttrs, array('data-rowindex'=>$payment_period_list->RowCnt, 'id'=>'r' . $payment_period_list->RowCnt . '_payment_period', 'data-rowtype'=>$payment_period->RowType));

		// Render row
		$payment_period_list->renderRow();

		// Render list options
		$payment_period_list->renderListOptions();
?>
	<tr<?php echo $payment_period->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_period_list->ListOptions->render("body", "left", $payment_period_list->RowCnt);
?>
	<?php if ($payment_period->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payment_period->id->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_id" class="payment_period_id">
<span<?php echo $payment_period->id->viewAttributes() ?>>
<?php echo $payment_period->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->location->Visible) { // location ?>
		<td data-name="location"<?php echo $payment_period->location->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_location" class="payment_period_location">
<span<?php echo $payment_period->location->viewAttributes() ?>>
<?php echo $payment_period->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $payment_period->grp->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_grp" class="payment_period_grp">
<span<?php echo $payment_period->grp->viewAttributes() ?>>
<?php echo $payment_period->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->from_date->Visible) { // from_date ?>
		<td data-name="from_date"<?php echo $payment_period->from_date->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_from_date" class="payment_period_from_date">
<span<?php echo $payment_period->from_date->viewAttributes() ?>>
<?php echo $payment_period->from_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->to_date->Visible) { // to_date ?>
		<td data-name="to_date"<?php echo $payment_period->to_date->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_to_date" class="payment_period_to_date">
<span<?php echo $payment_period->to_date->viewAttributes() ?>>
<?php echo $payment_period->to_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->payment_description->Visible) { // payment_description ?>
		<td data-name="payment_description"<?php echo $payment_period->payment_description->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_payment_description" class="payment_period_payment_description">
<span<?php echo $payment_period->payment_description->viewAttributes() ?>>
<?php echo $payment_period->payment_description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->process->Visible) { // process ?>
		<td data-name="process"<?php echo $payment_period->process->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_process" class="payment_period_process">
<span<?php echo $payment_period->process->viewAttributes() ?>>
<?php echo $payment_period->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->transfer_account->Visible) { // transfer_account ?>
		<td data-name="transfer_account"<?php echo $payment_period->transfer_account->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_transfer_account" class="payment_period_transfer_account">
<span<?php echo $payment_period->transfer_account->viewAttributes() ?>>
<?php echo $payment_period->transfer_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->transfer_by->Visible) { // transfer_by ?>
		<td data-name="transfer_by"<?php echo $payment_period->transfer_by->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_transfer_by" class="payment_period_transfer_by">
<span<?php echo $payment_period->transfer_by->viewAttributes() ?>>
<?php echo $payment_period->transfer_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->transfer_datetime->Visible) { // transfer_datetime ?>
		<td data-name="transfer_datetime"<?php echo $payment_period->transfer_datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_transfer_datetime" class="payment_period_transfer_datetime">
<span<?php echo $payment_period->transfer_datetime->viewAttributes() ?>>
<?php echo $payment_period->transfer_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $payment_period->operator->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_operator" class="payment_period_operator">
<span<?php echo $payment_period->operator->viewAttributes() ?>>
<?php echo $payment_period->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_period->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payment_period->datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_period_list->RowCnt ?>_payment_period_datetime" class="payment_period_datetime">
<span<?php echo $payment_period->datetime->viewAttributes() ?>>
<?php echo $payment_period->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_period_list->ListOptions->render("body", "right", $payment_period_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_period->isGridAdd())
		$payment_period_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_period->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_period_list->Recordset)
	$payment_period_list->Recordset->Close();
?>
<?php if (!$payment_period->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_period->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_period_list->Pager)) $payment_period_list->Pager = new PrevNextPager($payment_period_list->StartRec, $payment_period_list->DisplayRecs, $payment_period_list->TotalRecs, $payment_period_list->AutoHidePager) ?>
<?php if ($payment_period_list->Pager->RecordCount > 0 && $payment_period_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_period_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_period_list->pageUrl() ?>start=<?php echo $payment_period_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_period_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_period_list->pageUrl() ?>start=<?php echo $payment_period_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_period_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_period_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_period_list->pageUrl() ?>start=<?php echo $payment_period_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_period_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_period_list->pageUrl() ?>start=<?php echo $payment_period_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_period_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_period_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_period_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_period_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_period_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_period_list->TotalRecs > 0 && (!$payment_period_list->AutoHidePageSizeSelector || $payment_period_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_period">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_period_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_period_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_period_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_period_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_period_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_period->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_period_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_period_list->TotalRecs == 0 && !$payment_period->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_period_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_period_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_period->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_period->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_period", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_period_list->terminate();
?>