<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_period_view = new payment_period_view();

// Run the page
$payment_period_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_period_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_period->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpayment_periodview = currentForm = new ew.Form("fpayment_periodview", "view");

// Form_CustomValidate event
fpayment_periodview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_periodview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_periodview.lists["x_location[]"] = <?php echo $payment_period_view->location->Lookup->toClientList() ?>;
fpayment_periodview.lists["x_location[]"].options = <?php echo JsonEncode($payment_period_view->location->lookupOptions()) ?>;
fpayment_periodview.lists["x_grp"] = <?php echo $payment_period_view->grp->Lookup->toClientList() ?>;
fpayment_periodview.lists["x_grp"].options = <?php echo JsonEncode($payment_period_view->grp->lookupOptions()) ?>;
fpayment_periodview.lists["x_process[]"] = <?php echo $payment_period_view->process->Lookup->toClientList() ?>;
fpayment_periodview.lists["x_process[]"].options = <?php echo JsonEncode($payment_period_view->process->lookupOptions()) ?>;
fpayment_periodview.lists["x_transfer_account"] = <?php echo $payment_period_view->transfer_account->Lookup->toClientList() ?>;
fpayment_periodview.lists["x_transfer_account"].options = <?php echo JsonEncode($payment_period_view->transfer_account->lookupOptions()) ?>;
fpayment_periodview.lists["x_transfer_by"] = <?php echo $payment_period_view->transfer_by->Lookup->toClientList() ?>;
fpayment_periodview.lists["x_transfer_by"].options = <?php echo JsonEncode($payment_period_view->transfer_by->lookupOptions()) ?>;
fpayment_periodview.lists["x_operator"] = <?php echo $payment_period_view->operator->Lookup->toClientList() ?>;
fpayment_periodview.lists["x_operator"].options = <?php echo JsonEncode($payment_period_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_period->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $payment_period_view->ExportOptions->render("body") ?>
<?php $payment_period_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $payment_period_view->showPageHeader(); ?>
<?php
$payment_period_view->showMessage();
?>
<form name="fpayment_periodview" id="fpayment_periodview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_period_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_period_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_period">
<input type="hidden" name="modal" value="<?php echo (int)$payment_period_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($payment_period->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_id"><?php echo $payment_period->id->caption() ?></span></td>
		<td data-name="id"<?php echo $payment_period->id->cellAttributes() ?>>
<span id="el_payment_period_id">
<span<?php echo $payment_period->id->viewAttributes() ?>>
<?php echo $payment_period->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_location"><?php echo $payment_period->location->caption() ?></span></td>
		<td data-name="location"<?php echo $payment_period->location->cellAttributes() ?>>
<span id="el_payment_period_location">
<span<?php echo $payment_period->location->viewAttributes() ?>>
<?php echo $payment_period->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_grp"><?php echo $payment_period->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $payment_period->grp->cellAttributes() ?>>
<span id="el_payment_period_grp">
<span<?php echo $payment_period->grp->viewAttributes() ?>>
<?php echo $payment_period->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->from_date->Visible) { // from_date ?>
	<tr id="r_from_date">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_from_date"><?php echo $payment_period->from_date->caption() ?></span></td>
		<td data-name="from_date"<?php echo $payment_period->from_date->cellAttributes() ?>>
<span id="el_payment_period_from_date">
<span<?php echo $payment_period->from_date->viewAttributes() ?>>
<?php echo $payment_period->from_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->to_date->Visible) { // to_date ?>
	<tr id="r_to_date">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_to_date"><?php echo $payment_period->to_date->caption() ?></span></td>
		<td data-name="to_date"<?php echo $payment_period->to_date->cellAttributes() ?>>
<span id="el_payment_period_to_date">
<span<?php echo $payment_period->to_date->viewAttributes() ?>>
<?php echo $payment_period->to_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->payment_description->Visible) { // payment_description ?>
	<tr id="r_payment_description">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_payment_description"><?php echo $payment_period->payment_description->caption() ?></span></td>
		<td data-name="payment_description"<?php echo $payment_period->payment_description->cellAttributes() ?>>
<span id="el_payment_period_payment_description">
<span<?php echo $payment_period->payment_description->viewAttributes() ?>>
<?php echo $payment_period->payment_description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_process"><?php echo $payment_period->process->caption() ?></span></td>
		<td data-name="process"<?php echo $payment_period->process->cellAttributes() ?>>
<span id="el_payment_period_process">
<span<?php echo $payment_period->process->viewAttributes() ?>>
<?php echo $payment_period->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->transfer_account->Visible) { // transfer_account ?>
	<tr id="r_transfer_account">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_transfer_account"><?php echo $payment_period->transfer_account->caption() ?></span></td>
		<td data-name="transfer_account"<?php echo $payment_period->transfer_account->cellAttributes() ?>>
<span id="el_payment_period_transfer_account">
<span<?php echo $payment_period->transfer_account->viewAttributes() ?>>
<?php echo $payment_period->transfer_account->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->transfer_by->Visible) { // transfer_by ?>
	<tr id="r_transfer_by">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_transfer_by"><?php echo $payment_period->transfer_by->caption() ?></span></td>
		<td data-name="transfer_by"<?php echo $payment_period->transfer_by->cellAttributes() ?>>
<span id="el_payment_period_transfer_by">
<span<?php echo $payment_period->transfer_by->viewAttributes() ?>>
<?php echo $payment_period->transfer_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->transfer_datetime->Visible) { // transfer_datetime ?>
	<tr id="r_transfer_datetime">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_transfer_datetime"><?php echo $payment_period->transfer_datetime->caption() ?></span></td>
		<td data-name="transfer_datetime"<?php echo $payment_period->transfer_datetime->cellAttributes() ?>>
<span id="el_payment_period_transfer_datetime">
<span<?php echo $payment_period->transfer_datetime->viewAttributes() ?>>
<?php echo $payment_period->transfer_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_operator"><?php echo $payment_period->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $payment_period->operator->cellAttributes() ?>>
<span id="el_payment_period_operator">
<span<?php echo $payment_period->operator->viewAttributes() ?>>
<?php echo $payment_period->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_period->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $payment_period_view->TableLeftColumnClass ?>"><span id="elh_payment_period_datetime"><?php echo $payment_period->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $payment_period->datetime->cellAttributes() ?>>
<span id="el_payment_period_datetime">
<span<?php echo $payment_period->datetime->viewAttributes() ?>>
<?php echo $payment_period->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$payment_period_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_period->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_period_view->terminate();
?>