<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_check_list = new payment_plan_check_list();

// Run the page
$payment_plan_check_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_check_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_plan_check->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_plan_checklist = currentForm = new ew.Form("fpayment_plan_checklist", "list");
fpayment_plan_checklist.formKeyCountName = '<?php echo $payment_plan_check_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_plan_checklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_checklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_checklist.lists["x_pa_location"] = <?php echo $payment_plan_check_list->pa_location->Lookup->toClientList() ?>;
fpayment_plan_checklist.lists["x_pa_location"].options = <?php echo JsonEncode($payment_plan_check_list->pa_location->lookupOptions()) ?>;
fpayment_plan_checklist.lists["x_pa_process"] = <?php echo $payment_plan_check_list->pa_process->Lookup->toClientList() ?>;
fpayment_plan_checklist.lists["x_pa_process"].options = <?php echo JsonEncode($payment_plan_check_list->pa_process->lookupOptions()) ?>;
fpayment_plan_checklist.lists["x_pa_payment"] = <?php echo $payment_plan_check_list->pa_payment->Lookup->toClientList() ?>;
fpayment_plan_checklist.lists["x_pa_payment"].options = <?php echo JsonEncode($payment_plan_check_list->pa_payment->lookupOptions()) ?>;

// Form object for search
var fpayment_plan_checklistsrch = currentSearchForm = new ew.Form("fpayment_plan_checklistsrch");

// Validate function for search
fpayment_plan_checklistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpayment_plan_checklistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_checklistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_checklistsrch.lists["x_pa_location"] = <?php echo $payment_plan_check_list->pa_location->Lookup->toClientList() ?>;
fpayment_plan_checklistsrch.lists["x_pa_location"].options = <?php echo JsonEncode($payment_plan_check_list->pa_location->lookupOptions()) ?>;
fpayment_plan_checklistsrch.lists["x_pa_process"] = <?php echo $payment_plan_check_list->pa_process->Lookup->toClientList() ?>;
fpayment_plan_checklistsrch.lists["x_pa_process"].options = <?php echo JsonEncode($payment_plan_check_list->pa_process->lookupOptions()) ?>;
fpayment_plan_checklistsrch.lists["x_pa_payment"] = <?php echo $payment_plan_check_list->pa_payment->Lookup->toClientList() ?>;
fpayment_plan_checklistsrch.lists["x_pa_payment"].options = <?php echo JsonEncode($payment_plan_check_list->pa_payment->lookupOptions()) ?>;

// Filters
fpayment_plan_checklistsrch.filterList = <?php echo $payment_plan_check_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_plan_checklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_plan_check->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_plan_check_list->TotalRecs > 0 && $payment_plan_check_list->ExportOptions->visible()) { ?>
<?php $payment_plan_check_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_check_list->ImportOptions->visible()) { ?>
<?php $payment_plan_check_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_check_list->SearchOptions->visible()) { ?>
<?php $payment_plan_check_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_check_list->FilterOptions->visible()) { ?>
<?php $payment_plan_check_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_plan_check_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_plan_check->isExport() && !$payment_plan_check->CurrentAction) { ?>
<form name="fpayment_plan_checklistsrch" id="fpayment_plan_checklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_plan_check_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_plan_checklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_plan_check">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$payment_plan_check_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$payment_plan_check->RowType = ROWTYPE_SEARCH;

// Render row
$payment_plan_check->resetAttributes();
$payment_plan_check_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($payment_plan_check->pa_location->Visible) { // pa_location ?>
	<div id="xsc_pa_location" class="ew-cell form-group">
		<label for="x_pa_location" class="ew-search-caption ew-label"><?php echo $payment_plan_check->pa_location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pa_location" id="z_pa_location" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_check" data-field="x_pa_location" data-value-separator="<?php echo $payment_plan_check->pa_location->displayValueSeparatorAttribute() ?>" id="x_pa_location" name="x_pa_location"<?php echo $payment_plan_check->pa_location->editAttributes() ?>>
		<?php echo $payment_plan_check->pa_location->selectOptionListHtml("x_pa_location") ?>
	</select>
</div>
<?php echo $payment_plan_check->pa_location->Lookup->getParamTag("p_x_pa_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_check->pa_process->Visible) { // pa_process ?>
	<div id="xsc_pa_process" class="ew-cell form-group">
		<label for="x_pa_process" class="ew-search-caption ew-label"><?php echo $payment_plan_check->pa_process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pa_process" id="z_pa_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_check" data-field="x_pa_process" data-value-separator="<?php echo $payment_plan_check->pa_process->displayValueSeparatorAttribute() ?>" id="x_pa_process" name="x_pa_process"<?php echo $payment_plan_check->pa_process->editAttributes() ?>>
		<?php echo $payment_plan_check->pa_process->selectOptionListHtml("x_pa_process") ?>
	</select>
</div>
<?php echo $payment_plan_check->pa_process->Lookup->getParamTag("p_x_pa_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_check->pa_payment->Visible) { // pa_payment ?>
	<div id="xsc_pa_payment" class="ew-cell form-group">
		<label for="x_pa_payment" class="ew-search-caption ew-label"><?php echo $payment_plan_check->pa_payment->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pa_payment" id="z_pa_payment" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_check" data-field="x_pa_payment" data-value-separator="<?php echo $payment_plan_check->pa_payment->displayValueSeparatorAttribute() ?>" id="x_pa_payment" name="x_pa_payment"<?php echo $payment_plan_check->pa_payment->editAttributes() ?>>
		<?php echo $payment_plan_check->pa_payment->selectOptionListHtml("x_pa_payment") ?>
	</select>
</div>
<?php echo $payment_plan_check->pa_payment->Lookup->getParamTag("p_x_pa_payment") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_plan_check_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_plan_check_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_plan_check_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_plan_check_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_check_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_check_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_check_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_plan_check_list->showPageHeader(); ?>
<?php
$payment_plan_check_list->showMessage();
?>
<?php if ($payment_plan_check_list->TotalRecs > 0 || $payment_plan_check->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_plan_check_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_plan_check">
<?php if (!$payment_plan_check->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_plan_check->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_check_list->Pager)) $payment_plan_check_list->Pager = new PrevNextPager($payment_plan_check_list->StartRec, $payment_plan_check_list->DisplayRecs, $payment_plan_check_list->TotalRecs, $payment_plan_check_list->AutoHidePager) ?>
<?php if ($payment_plan_check_list->Pager->RecordCount > 0 && $payment_plan_check_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_check_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_check_list->pageUrl() ?>start=<?php echo $payment_plan_check_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_check_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_check_list->pageUrl() ?>start=<?php echo $payment_plan_check_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_check_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_check_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_check_list->pageUrl() ?>start=<?php echo $payment_plan_check_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_check_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_check_list->pageUrl() ?>start=<?php echo $payment_plan_check_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_check_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_check_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_check_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_check_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_check_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_check_list->TotalRecs > 0 && (!$payment_plan_check_list->AutoHidePageSizeSelector || $payment_plan_check_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan_check">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_check_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_check_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_check_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_check_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_check_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan_check->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_check_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_plan_checklist" id="fpayment_plan_checklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_check_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_check_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan_check">
<div id="gmp_payment_plan_check" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_plan_check_list->TotalRecs > 0 || $payment_plan_check->isGridEdit()) { ?>
<table id="tbl_payment_plan_checklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_plan_check_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_plan_check_list->renderListOptions();

// Render list options (header, left)
$payment_plan_check_list->ListOptions->render("header", "left");
?>
<?php if ($payment_plan_check->pa_location->Visible) { // pa_location ?>
	<?php if ($payment_plan_check->sortUrl($payment_plan_check->pa_location) == "") { ?>
		<th data-name="pa_location" class="<?php echo $payment_plan_check->pa_location->headerCellClass() ?>"><div id="elh_payment_plan_check_pa_location" class="payment_plan_check_pa_location"><div class="ew-table-header-caption"><?php echo $payment_plan_check->pa_location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pa_location" class="<?php echo $payment_plan_check->pa_location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_check->SortUrl($payment_plan_check->pa_location) ?>',2);"><div id="elh_payment_plan_check_pa_location" class="payment_plan_check_pa_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_check->pa_location->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_check->pa_location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_check->pa_location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_check->pa_process->Visible) { // pa_process ?>
	<?php if ($payment_plan_check->sortUrl($payment_plan_check->pa_process) == "") { ?>
		<th data-name="pa_process" class="<?php echo $payment_plan_check->pa_process->headerCellClass() ?>"><div id="elh_payment_plan_check_pa_process" class="payment_plan_check_pa_process"><div class="ew-table-header-caption"><?php echo $payment_plan_check->pa_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pa_process" class="<?php echo $payment_plan_check->pa_process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_check->SortUrl($payment_plan_check->pa_process) ?>',2);"><div id="elh_payment_plan_check_pa_process" class="payment_plan_check_pa_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_check->pa_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_check->pa_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_check->pa_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_check->pa_ref->Visible) { // pa_ref ?>
	<?php if ($payment_plan_check->sortUrl($payment_plan_check->pa_ref) == "") { ?>
		<th data-name="pa_ref" class="<?php echo $payment_plan_check->pa_ref->headerCellClass() ?>"><div id="elh_payment_plan_check_pa_ref" class="payment_plan_check_pa_ref"><div class="ew-table-header-caption"><?php echo $payment_plan_check->pa_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pa_ref" class="<?php echo $payment_plan_check->pa_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_check->SortUrl($payment_plan_check->pa_ref) ?>',2);"><div id="elh_payment_plan_check_pa_ref" class="payment_plan_check_pa_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_check->pa_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_check->pa_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_check->pa_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_check->pa_size->Visible) { // pa_size ?>
	<?php if ($payment_plan_check->sortUrl($payment_plan_check->pa_size) == "") { ?>
		<th data-name="pa_size" class="<?php echo $payment_plan_check->pa_size->headerCellClass() ?>"><div id="elh_payment_plan_check_pa_size" class="payment_plan_check_pa_size"><div class="ew-table-header-caption"><?php echo $payment_plan_check->pa_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pa_size" class="<?php echo $payment_plan_check->pa_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_check->SortUrl($payment_plan_check->pa_size) ?>',2);"><div id="elh_payment_plan_check_pa_size" class="payment_plan_check_pa_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_check->pa_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_check->pa_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_check->pa_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_check->price->Visible) { // price ?>
	<?php if ($payment_plan_check->sortUrl($payment_plan_check->price) == "") { ?>
		<th data-name="price" class="<?php echo $payment_plan_check->price->headerCellClass() ?>"><div id="elh_payment_plan_check_price" class="payment_plan_check_price"><div class="ew-table-header-caption"><?php echo $payment_plan_check->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $payment_plan_check->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_check->SortUrl($payment_plan_check->price) ?>',2);"><div id="elh_payment_plan_check_price" class="payment_plan_check_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_check->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_check->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_check->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_check->pa_payment->Visible) { // pa_payment ?>
	<?php if ($payment_plan_check->sortUrl($payment_plan_check->pa_payment) == "") { ?>
		<th data-name="pa_payment" class="<?php echo $payment_plan_check->pa_payment->headerCellClass() ?>"><div id="elh_payment_plan_check_pa_payment" class="payment_plan_check_pa_payment"><div class="ew-table-header-caption"><?php echo $payment_plan_check->pa_payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pa_payment" class="<?php echo $payment_plan_check->pa_payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_check->SortUrl($payment_plan_check->pa_payment) ?>',2);"><div id="elh_payment_plan_check_pa_payment" class="payment_plan_check_pa_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_check->pa_payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_check->pa_payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_check->pa_payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_check->pps->Visible) { // pps ?>
	<?php if ($payment_plan_check->sortUrl($payment_plan_check->pps) == "") { ?>
		<th data-name="pps" class="<?php echo $payment_plan_check->pps->headerCellClass() ?>"><div id="elh_payment_plan_check_pps" class="payment_plan_check_pps"><div class="ew-table-header-caption"><?php echo $payment_plan_check->pps->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pps" class="<?php echo $payment_plan_check->pps->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_check->SortUrl($payment_plan_check->pps) ?>',2);"><div id="elh_payment_plan_check_pps" class="payment_plan_check_pps">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_check->pps->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_check->pps->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_check->pps->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_plan_check_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_plan_check->ExportAll && $payment_plan_check->isExport()) {
	$payment_plan_check_list->StopRec = $payment_plan_check_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_plan_check_list->TotalRecs > $payment_plan_check_list->StartRec + $payment_plan_check_list->DisplayRecs - 1)
		$payment_plan_check_list->StopRec = $payment_plan_check_list->StartRec + $payment_plan_check_list->DisplayRecs - 1;
	else
		$payment_plan_check_list->StopRec = $payment_plan_check_list->TotalRecs;
}
$payment_plan_check_list->RecCnt = $payment_plan_check_list->StartRec - 1;
if ($payment_plan_check_list->Recordset && !$payment_plan_check_list->Recordset->EOF) {
	$payment_plan_check_list->Recordset->moveFirst();
	$selectLimit = $payment_plan_check_list->UseSelectLimit;
	if (!$selectLimit && $payment_plan_check_list->StartRec > 1)
		$payment_plan_check_list->Recordset->move($payment_plan_check_list->StartRec - 1);
} elseif (!$payment_plan_check->AllowAddDeleteRow && $payment_plan_check_list->StopRec == 0) {
	$payment_plan_check_list->StopRec = $payment_plan_check->GridAddRowCount;
}

// Initialize aggregate
$payment_plan_check->RowType = ROWTYPE_AGGREGATEINIT;
$payment_plan_check->resetAttributes();
$payment_plan_check_list->renderRow();
while ($payment_plan_check_list->RecCnt < $payment_plan_check_list->StopRec) {
	$payment_plan_check_list->RecCnt++;
	if ($payment_plan_check_list->RecCnt >= $payment_plan_check_list->StartRec) {
		$payment_plan_check_list->RowCnt++;

		// Set up key count
		$payment_plan_check_list->KeyCount = $payment_plan_check_list->RowIndex;

		// Init row class and style
		$payment_plan_check->resetAttributes();
		$payment_plan_check->CssClass = "";
		if ($payment_plan_check->isGridAdd()) {
		} else {
			$payment_plan_check_list->loadRowValues($payment_plan_check_list->Recordset); // Load row values
		}
		$payment_plan_check->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_plan_check->RowAttrs = array_merge($payment_plan_check->RowAttrs, array('data-rowindex'=>$payment_plan_check_list->RowCnt, 'id'=>'r' . $payment_plan_check_list->RowCnt . '_payment_plan_check', 'data-rowtype'=>$payment_plan_check->RowType));

		// Render row
		$payment_plan_check_list->renderRow();

		// Render list options
		$payment_plan_check_list->renderListOptions();
?>
	<tr<?php echo $payment_plan_check->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_plan_check_list->ListOptions->render("body", "left", $payment_plan_check_list->RowCnt);
?>
	<?php if ($payment_plan_check->pa_location->Visible) { // pa_location ?>
		<td data-name="pa_location"<?php echo $payment_plan_check->pa_location->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_check_list->RowCnt ?>_payment_plan_check_pa_location" class="payment_plan_check_pa_location">
<span<?php echo $payment_plan_check->pa_location->viewAttributes() ?>>
<?php echo $payment_plan_check->pa_location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_check->pa_process->Visible) { // pa_process ?>
		<td data-name="pa_process"<?php echo $payment_plan_check->pa_process->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_check_list->RowCnt ?>_payment_plan_check_pa_process" class="payment_plan_check_pa_process">
<span<?php echo $payment_plan_check->pa_process->viewAttributes() ?>>
<?php echo $payment_plan_check->pa_process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_check->pa_ref->Visible) { // pa_ref ?>
		<td data-name="pa_ref"<?php echo $payment_plan_check->pa_ref->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_check_list->RowCnt ?>_payment_plan_check_pa_ref" class="payment_plan_check_pa_ref">
<span<?php echo $payment_plan_check->pa_ref->viewAttributes() ?>>
<?php echo $payment_plan_check->pa_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_check->pa_size->Visible) { // pa_size ?>
		<td data-name="pa_size"<?php echo $payment_plan_check->pa_size->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_check_list->RowCnt ?>_payment_plan_check_pa_size" class="payment_plan_check_pa_size">
<span<?php echo $payment_plan_check->pa_size->viewAttributes() ?>>
<?php echo $payment_plan_check->pa_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_check->price->Visible) { // price ?>
		<td data-name="price"<?php echo $payment_plan_check->price->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_check_list->RowCnt ?>_payment_plan_check_price" class="payment_plan_check_price">
<span<?php echo $payment_plan_check->price->viewAttributes() ?>>
<?php echo $payment_plan_check->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_check->pa_payment->Visible) { // pa_payment ?>
		<td data-name="pa_payment"<?php echo $payment_plan_check->pa_payment->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_check_list->RowCnt ?>_payment_plan_check_pa_payment" class="payment_plan_check_pa_payment">
<span<?php echo $payment_plan_check->pa_payment->viewAttributes() ?>>
<?php echo $payment_plan_check->pa_payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_check->pps->Visible) { // pps ?>
		<td data-name="pps"<?php echo $payment_plan_check->pps->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_check_list->RowCnt ?>_payment_plan_check_pps" class="payment_plan_check_pps">
<span<?php echo $payment_plan_check->pps->viewAttributes() ?>>
<?php echo $payment_plan_check->pps->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_plan_check_list->ListOptions->render("body", "right", $payment_plan_check_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_plan_check->isGridAdd())
		$payment_plan_check_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_plan_check->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_plan_check_list->Recordset)
	$payment_plan_check_list->Recordset->Close();
?>
<?php if (!$payment_plan_check->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_plan_check->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_check_list->Pager)) $payment_plan_check_list->Pager = new PrevNextPager($payment_plan_check_list->StartRec, $payment_plan_check_list->DisplayRecs, $payment_plan_check_list->TotalRecs, $payment_plan_check_list->AutoHidePager) ?>
<?php if ($payment_plan_check_list->Pager->RecordCount > 0 && $payment_plan_check_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_check_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_check_list->pageUrl() ?>start=<?php echo $payment_plan_check_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_check_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_check_list->pageUrl() ?>start=<?php echo $payment_plan_check_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_check_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_check_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_check_list->pageUrl() ?>start=<?php echo $payment_plan_check_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_check_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_check_list->pageUrl() ?>start=<?php echo $payment_plan_check_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_check_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_check_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_check_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_check_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_check_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_check_list->TotalRecs > 0 && (!$payment_plan_check_list->AutoHidePageSizeSelector || $payment_plan_check_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan_check">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_check_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_check_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_check_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_check_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_check_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan_check->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_check_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_plan_check_list->TotalRecs == 0 && !$payment_plan_check->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_plan_check_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_plan_check_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_plan_check->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_plan_check->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_plan_check", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_plan_check_list->terminate();
?>