<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_check_search = new payment_plan_check_search();

// Run the page
$payment_plan_check_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_check_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($payment_plan_check_search->IsModal) { ?>
var fpayment_plan_checksearch = currentAdvancedSearchForm = new ew.Form("fpayment_plan_checksearch", "search");
<?php } else { ?>
var fpayment_plan_checksearch = currentForm = new ew.Form("fpayment_plan_checksearch", "search");
<?php } ?>

// Form_CustomValidate event
fpayment_plan_checksearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_checksearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_checksearch.lists["x_pa_location"] = <?php echo $payment_plan_check_search->pa_location->Lookup->toClientList() ?>;
fpayment_plan_checksearch.lists["x_pa_location"].options = <?php echo JsonEncode($payment_plan_check_search->pa_location->lookupOptions()) ?>;
fpayment_plan_checksearch.lists["x_pa_process"] = <?php echo $payment_plan_check_search->pa_process->Lookup->toClientList() ?>;
fpayment_plan_checksearch.lists["x_pa_process"].options = <?php echo JsonEncode($payment_plan_check_search->pa_process->lookupOptions()) ?>;
fpayment_plan_checksearch.lists["x_pa_payment"] = <?php echo $payment_plan_check_search->pa_payment->Lookup->toClientList() ?>;
fpayment_plan_checksearch.lists["x_pa_payment"].options = <?php echo JsonEncode($payment_plan_check_search->pa_payment->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpayment_plan_checksearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_pa_size");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan_check->pa_size->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pps");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan_check->pps->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_plan_check_search->showPageHeader(); ?>
<?php
$payment_plan_check_search->showMessage();
?>
<form name="fpayment_plan_checksearch" id="fpayment_plan_checksearch" class="<?php echo $payment_plan_check_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_check_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_check_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan_check">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$payment_plan_check_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($payment_plan_check->pa_location->Visible) { // pa_location ?>
	<div id="r_pa_location" class="form-group row">
		<label for="x_pa_location" class="<?php echo $payment_plan_check_search->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_location"><?php echo $payment_plan_check->pa_location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pa_location" id="z_pa_location" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_check_search->RightColumnClass ?>"><div<?php echo $payment_plan_check->pa_location->cellAttributes() ?>>
			<span id="el_payment_plan_check_pa_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_check" data-field="x_pa_location" data-value-separator="<?php echo $payment_plan_check->pa_location->displayValueSeparatorAttribute() ?>" id="x_pa_location" name="x_pa_location"<?php echo $payment_plan_check->pa_location->editAttributes() ?>>
		<?php echo $payment_plan_check->pa_location->selectOptionListHtml("x_pa_location") ?>
	</select>
</div>
<?php echo $payment_plan_check->pa_location->Lookup->getParamTag("p_x_pa_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_check->pa_process->Visible) { // pa_process ?>
	<div id="r_pa_process" class="form-group row">
		<label for="x_pa_process" class="<?php echo $payment_plan_check_search->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_process"><?php echo $payment_plan_check->pa_process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pa_process" id="z_pa_process" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_check_search->RightColumnClass ?>"><div<?php echo $payment_plan_check->pa_process->cellAttributes() ?>>
			<span id="el_payment_plan_check_pa_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_check" data-field="x_pa_process" data-value-separator="<?php echo $payment_plan_check->pa_process->displayValueSeparatorAttribute() ?>" id="x_pa_process" name="x_pa_process"<?php echo $payment_plan_check->pa_process->editAttributes() ?>>
		<?php echo $payment_plan_check->pa_process->selectOptionListHtml("x_pa_process") ?>
	</select>
</div>
<?php echo $payment_plan_check->pa_process->Lookup->getParamTag("p_x_pa_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_check->pa_ref->Visible) { // pa_ref ?>
	<div id="r_pa_ref" class="form-group row">
		<label for="x_pa_ref" class="<?php echo $payment_plan_check_search->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_ref"><?php echo $payment_plan_check->pa_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pa_ref" id="z_pa_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_check_search->RightColumnClass ?>"><div<?php echo $payment_plan_check->pa_ref->cellAttributes() ?>>
			<span id="el_payment_plan_check_pa_ref">
<input type="text" data-table="payment_plan_check" data-field="x_pa_ref" name="x_pa_ref" id="x_pa_ref" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($payment_plan_check->pa_ref->getPlaceHolder()) ?>" value="<?php echo $payment_plan_check->pa_ref->EditValue ?>"<?php echo $payment_plan_check->pa_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_check->pa_size->Visible) { // pa_size ?>
	<div id="r_pa_size" class="form-group row">
		<label for="x_pa_size" class="<?php echo $payment_plan_check_search->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_size"><?php echo $payment_plan_check->pa_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pa_size" id="z_pa_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_check_search->RightColumnClass ?>"><div<?php echo $payment_plan_check->pa_size->cellAttributes() ?>>
			<span id="el_payment_plan_check_pa_size">
<input type="text" data-table="payment_plan_check" data-field="x_pa_size" name="x_pa_size" id="x_pa_size" size="30" placeholder="<?php echo HtmlEncode($payment_plan_check->pa_size->getPlaceHolder()) ?>" value="<?php echo $payment_plan_check->pa_size->EditValue ?>"<?php echo $payment_plan_check->pa_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_check->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $payment_plan_check_search->LeftColumnClass ?>"><span id="elh_payment_plan_check_price"><?php echo $payment_plan_check->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_price" id="z_price" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_check_search->RightColumnClass ?>"><div<?php echo $payment_plan_check->price->cellAttributes() ?>>
			<span id="el_payment_plan_check_price">
<input type="text" data-table="payment_plan_check" data-field="x_price" name="x_price" id="x_price" size="30" maxlength="19" placeholder="<?php echo HtmlEncode($payment_plan_check->price->getPlaceHolder()) ?>" value="<?php echo $payment_plan_check->price->EditValue ?>"<?php echo $payment_plan_check->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_check->pa_payment->Visible) { // pa_payment ?>
	<div id="r_pa_payment" class="form-group row">
		<label for="x_pa_payment" class="<?php echo $payment_plan_check_search->LeftColumnClass ?>"><span id="elh_payment_plan_check_pa_payment"><?php echo $payment_plan_check->pa_payment->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pa_payment" id="z_pa_payment" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_check_search->RightColumnClass ?>"><div<?php echo $payment_plan_check->pa_payment->cellAttributes() ?>>
			<span id="el_payment_plan_check_pa_payment">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_check" data-field="x_pa_payment" data-value-separator="<?php echo $payment_plan_check->pa_payment->displayValueSeparatorAttribute() ?>" id="x_pa_payment" name="x_pa_payment"<?php echo $payment_plan_check->pa_payment->editAttributes() ?>>
		<?php echo $payment_plan_check->pa_payment->selectOptionListHtml("x_pa_payment") ?>
	</select>
</div>
<?php echo $payment_plan_check->pa_payment->Lookup->getParamTag("p_x_pa_payment") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_check->pps->Visible) { // pps ?>
	<div id="r_pps" class="form-group row">
		<label for="x_pps" class="<?php echo $payment_plan_check_search->LeftColumnClass ?>"><span id="elh_payment_plan_check_pps"><?php echo $payment_plan_check->pps->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pps" id="z_pps" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_check_search->RightColumnClass ?>"><div<?php echo $payment_plan_check->pps->cellAttributes() ?>>
			<span id="el_payment_plan_check_pps">
<input type="text" data-table="payment_plan_check" data-field="x_pps" name="x_pps" id="x_pps" size="30" placeholder="<?php echo HtmlEncode($payment_plan_check->pps->getPlaceHolder()) ?>" value="<?php echo $payment_plan_check->pps->EditValue ?>"<?php echo $payment_plan_check->pps->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_plan_check_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_plan_check_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_plan_check_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_plan_check_search->terminate();
?>