<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_hs_list = new payment_plan_hs_list();

// Run the page
$payment_plan_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_plan_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_plan_hslist = currentForm = new ew.Form("fpayment_plan_hslist", "list");
fpayment_plan_hslist.formKeyCountName = '<?php echo $payment_plan_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_plan_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_hslist.lists["x_grp"] = <?php echo $payment_plan_hs_list->grp->Lookup->toClientList() ?>;
fpayment_plan_hslist.lists["x_grp"].options = <?php echo JsonEncode($payment_plan_hs_list->grp->options(FALSE, TRUE)) ?>;
fpayment_plan_hslist.lists["x_s_grp"] = <?php echo $payment_plan_hs_list->s_grp->Lookup->toClientList() ?>;
fpayment_plan_hslist.lists["x_s_grp"].options = <?php echo JsonEncode($payment_plan_hs_list->s_grp->options(FALSE, TRUE)) ?>;
fpayment_plan_hslist.lists["x_godown"] = <?php echo $payment_plan_hs_list->godown->Lookup->toClientList() ?>;
fpayment_plan_hslist.lists["x_godown"].options = <?php echo JsonEncode($payment_plan_hs_list->godown->lookupOptions()) ?>;
fpayment_plan_hslist.lists["x_rid"] = <?php echo $payment_plan_hs_list->rid->Lookup->toClientList() ?>;
fpayment_plan_hslist.lists["x_rid"].options = <?php echo JsonEncode($payment_plan_hs_list->rid->lookupOptions()) ?>;
fpayment_plan_hslist.lists["x_twist"] = <?php echo $payment_plan_hs_list->twist->Lookup->toClientList() ?>;
fpayment_plan_hslist.lists["x_twist"].options = <?php echo JsonEncode($payment_plan_hs_list->twist->options(FALSE, TRUE)) ?>;
fpayment_plan_hslist.lists["x_yes_no"] = <?php echo $payment_plan_hs_list->yes_no->Lookup->toClientList() ?>;
fpayment_plan_hslist.lists["x_yes_no"].options = <?php echo JsonEncode($payment_plan_hs_list->yes_no->options(FALSE, TRUE)) ?>;
fpayment_plan_hslist.lists["x_status"] = <?php echo $payment_plan_hs_list->status->Lookup->toClientList() ?>;
fpayment_plan_hslist.lists["x_status"].options = <?php echo JsonEncode($payment_plan_hs_list->status->options(FALSE, TRUE)) ?>;
fpayment_plan_hslist.lists["x_operator"] = <?php echo $payment_plan_hs_list->operator->Lookup->toClientList() ?>;
fpayment_plan_hslist.lists["x_operator"].options = <?php echo JsonEncode($payment_plan_hs_list->operator->lookupOptions()) ?>;

// Form object for search
var fpayment_plan_hslistsrch = currentSearchForm = new ew.Form("fpayment_plan_hslistsrch");

// Filters
fpayment_plan_hslistsrch.filterList = <?php echo $payment_plan_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_plan_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_plan_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_plan_hs_list->TotalRecs > 0 && $payment_plan_hs_list->ExportOptions->visible()) { ?>
<?php $payment_plan_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_hs_list->ImportOptions->visible()) { ?>
<?php $payment_plan_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_hs_list->SearchOptions->visible()) { ?>
<?php $payment_plan_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_hs_list->FilterOptions->visible()) { ?>
<?php $payment_plan_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_plan_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_plan_hs->isExport() && !$payment_plan_hs->CurrentAction) { ?>
<form name="fpayment_plan_hslistsrch" id="fpayment_plan_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_plan_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_plan_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_plan_hs">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_plan_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_plan_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_plan_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_plan_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_plan_hs_list->showPageHeader(); ?>
<?php
$payment_plan_hs_list->showMessage();
?>
<?php if ($payment_plan_hs_list->TotalRecs > 0 || $payment_plan_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_plan_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_plan_hs">
<?php if (!$payment_plan_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_plan_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_hs_list->Pager)) $payment_plan_hs_list->Pager = new PrevNextPager($payment_plan_hs_list->StartRec, $payment_plan_hs_list->DisplayRecs, $payment_plan_hs_list->TotalRecs, $payment_plan_hs_list->AutoHidePager) ?>
<?php if ($payment_plan_hs_list->Pager->RecordCount > 0 && $payment_plan_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_hs_list->pageUrl() ?>start=<?php echo $payment_plan_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_hs_list->pageUrl() ?>start=<?php echo $payment_plan_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_hs_list->pageUrl() ?>start=<?php echo $payment_plan_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_hs_list->pageUrl() ?>start=<?php echo $payment_plan_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_hs_list->TotalRecs > 0 && (!$payment_plan_hs_list->AutoHidePageSizeSelector || $payment_plan_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_plan_hslist" id="fpayment_plan_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan_hs">
<div id="gmp_payment_plan_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_plan_hs_list->TotalRecs > 0 || $payment_plan_hs->isGridEdit()) { ?>
<table id="tbl_payment_plan_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_plan_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_plan_hs_list->renderListOptions();

// Render list options (header, left)
$payment_plan_hs_list->ListOptions->render("header", "left");
?>
<?php if ($payment_plan_hs->id->Visible) { // id ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->id) == "") { ?>
		<th data-name="id" class="<?php echo $payment_plan_hs->id->headerCellClass() ?>"><div id="elh_payment_plan_hs_id" class="payment_plan_hs_id"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payment_plan_hs->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->id) ?>',2);"><div id="elh_payment_plan_hs_id" class="payment_plan_hs_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->grp->Visible) { // grp ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $payment_plan_hs->grp->headerCellClass() ?>"><div id="elh_payment_plan_hs_grp" class="payment_plan_hs_grp"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $payment_plan_hs->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->grp) ?>',2);"><div id="elh_payment_plan_hs_grp" class="payment_plan_hs_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->s_grp->Visible) { // s_grp ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $payment_plan_hs->s_grp->headerCellClass() ?>"><div id="elh_payment_plan_hs_s_grp" class="payment_plan_hs_s_grp"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $payment_plan_hs->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->s_grp) ?>',2);"><div id="elh_payment_plan_hs_s_grp" class="payment_plan_hs_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->godown->Visible) { // godown ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $payment_plan_hs->godown->headerCellClass() ?>"><div id="elh_payment_plan_hs_godown" class="payment_plan_hs_godown"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $payment_plan_hs->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->godown) ?>',2);"><div id="elh_payment_plan_hs_godown" class="payment_plan_hs_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->rid->Visible) { // rid ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $payment_plan_hs->rid->headerCellClass() ?>"><div id="elh_payment_plan_hs_rid" class="payment_plan_hs_rid"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $payment_plan_hs->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->rid) ?>',2);"><div id="elh_payment_plan_hs_rid" class="payment_plan_hs_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->batch_no->Visible) { // batch_no ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $payment_plan_hs->batch_no->headerCellClass() ?>"><div id="elh_payment_plan_hs_batch_no" class="payment_plan_hs_batch_no"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $payment_plan_hs->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->batch_no) ?>',2);"><div id="elh_payment_plan_hs_batch_no" class="payment_plan_hs_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->count->Visible) { // count ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->count) == "") { ?>
		<th data-name="count" class="<?php echo $payment_plan_hs->count->headerCellClass() ?>"><div id="elh_payment_plan_hs_count" class="payment_plan_hs_count"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->count->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count" class="<?php echo $payment_plan_hs->count->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->count) ?>',2);"><div id="elh_payment_plan_hs_count" class="payment_plan_hs_count">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->count->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->count->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->count->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->twist->Visible) { // twist ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->twist) == "") { ?>
		<th data-name="twist" class="<?php echo $payment_plan_hs->twist->headerCellClass() ?>"><div id="elh_payment_plan_hs_twist" class="payment_plan_hs_twist"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->twist->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="twist" class="<?php echo $payment_plan_hs->twist->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->twist) ?>',2);"><div id="elh_payment_plan_hs_twist" class="payment_plan_hs_twist">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->twist->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->twist->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->twist->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->min_tolerance->Visible) { // min_tolerance ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->min_tolerance) == "") { ?>
		<th data-name="min_tolerance" class="<?php echo $payment_plan_hs->min_tolerance->headerCellClass() ?>"><div id="elh_payment_plan_hs_min_tolerance" class="payment_plan_hs_min_tolerance"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->min_tolerance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="min_tolerance" class="<?php echo $payment_plan_hs->min_tolerance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->min_tolerance) ?>',2);"><div id="elh_payment_plan_hs_min_tolerance" class="payment_plan_hs_min_tolerance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->min_tolerance->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->min_tolerance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->min_tolerance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->max_tolerance->Visible) { // max_tolerance ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->max_tolerance) == "") { ?>
		<th data-name="max_tolerance" class="<?php echo $payment_plan_hs->max_tolerance->headerCellClass() ?>"><div id="elh_payment_plan_hs_max_tolerance" class="payment_plan_hs_max_tolerance"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->max_tolerance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_tolerance" class="<?php echo $payment_plan_hs->max_tolerance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->max_tolerance) ?>',2);"><div id="elh_payment_plan_hs_max_tolerance" class="payment_plan_hs_max_tolerance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->max_tolerance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->max_tolerance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->max_tolerance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->description->Visible) { // description ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->description) == "") { ?>
		<th data-name="description" class="<?php echo $payment_plan_hs->description->headerCellClass() ?>"><div id="elh_payment_plan_hs_description" class="payment_plan_hs_description"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $payment_plan_hs->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->description) ?>',2);"><div id="elh_payment_plan_hs_description" class="payment_plan_hs_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->yes_no->Visible) { // yes_no ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->yes_no) == "") { ?>
		<th data-name="yes_no" class="<?php echo $payment_plan_hs->yes_no->headerCellClass() ?>"><div id="elh_payment_plan_hs_yes_no" class="payment_plan_hs_yes_no"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->yes_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="yes_no" class="<?php echo $payment_plan_hs->yes_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->yes_no) ?>',2);"><div id="elh_payment_plan_hs_yes_no" class="payment_plan_hs_yes_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->yes_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->yes_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->yes_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->_40->Visible) { // @ ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $payment_plan_hs->_40->headerCellClass() ?>"><div id="elh_payment_plan_hs__40" class="payment_plan_hs__40"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $payment_plan_hs->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->_40) ?>',2);"><div id="elh_payment_plan_hs__40" class="payment_plan_hs__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->shortage_deduction->Visible) { // shortage_deduction ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->shortage_deduction) == "") { ?>
		<th data-name="shortage_deduction" class="<?php echo $payment_plan_hs->shortage_deduction->headerCellClass() ?>"><div id="elh_payment_plan_hs_shortage_deduction" class="payment_plan_hs_shortage_deduction"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->shortage_deduction->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shortage_deduction" class="<?php echo $payment_plan_hs->shortage_deduction->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->shortage_deduction) ?>',2);"><div id="elh_payment_plan_hs_shortage_deduction" class="payment_plan_hs_shortage_deduction">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->shortage_deduction->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->shortage_deduction->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->shortage_deduction->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->status->Visible) { // status ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->status) == "") { ?>
		<th data-name="status" class="<?php echo $payment_plan_hs->status->headerCellClass() ?>"><div id="elh_payment_plan_hs_status" class="payment_plan_hs_status"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $payment_plan_hs->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->status) ?>',2);"><div id="elh_payment_plan_hs_status" class="payment_plan_hs_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->operator->Visible) { // operator ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $payment_plan_hs->operator->headerCellClass() ?>"><div id="elh_payment_plan_hs_operator" class="payment_plan_hs_operator"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $payment_plan_hs->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->operator) ?>',2);"><div id="elh_payment_plan_hs_operator" class="payment_plan_hs_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_hs->datetime->Visible) { // datetime ?>
	<?php if ($payment_plan_hs->sortUrl($payment_plan_hs->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payment_plan_hs->datetime->headerCellClass() ?>"><div id="elh_payment_plan_hs_datetime" class="payment_plan_hs_datetime"><div class="ew-table-header-caption"><?php echo $payment_plan_hs->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payment_plan_hs->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_hs->SortUrl($payment_plan_hs->datetime) ?>',2);"><div id="elh_payment_plan_hs_datetime" class="payment_plan_hs_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_hs->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_hs->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_hs->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_plan_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_plan_hs->ExportAll && $payment_plan_hs->isExport()) {
	$payment_plan_hs_list->StopRec = $payment_plan_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_plan_hs_list->TotalRecs > $payment_plan_hs_list->StartRec + $payment_plan_hs_list->DisplayRecs - 1)
		$payment_plan_hs_list->StopRec = $payment_plan_hs_list->StartRec + $payment_plan_hs_list->DisplayRecs - 1;
	else
		$payment_plan_hs_list->StopRec = $payment_plan_hs_list->TotalRecs;
}
$payment_plan_hs_list->RecCnt = $payment_plan_hs_list->StartRec - 1;
if ($payment_plan_hs_list->Recordset && !$payment_plan_hs_list->Recordset->EOF) {
	$payment_plan_hs_list->Recordset->moveFirst();
	$selectLimit = $payment_plan_hs_list->UseSelectLimit;
	if (!$selectLimit && $payment_plan_hs_list->StartRec > 1)
		$payment_plan_hs_list->Recordset->move($payment_plan_hs_list->StartRec - 1);
} elseif (!$payment_plan_hs->AllowAddDeleteRow && $payment_plan_hs_list->StopRec == 0) {
	$payment_plan_hs_list->StopRec = $payment_plan_hs->GridAddRowCount;
}

// Initialize aggregate
$payment_plan_hs->RowType = ROWTYPE_AGGREGATEINIT;
$payment_plan_hs->resetAttributes();
$payment_plan_hs_list->renderRow();
while ($payment_plan_hs_list->RecCnt < $payment_plan_hs_list->StopRec) {
	$payment_plan_hs_list->RecCnt++;
	if ($payment_plan_hs_list->RecCnt >= $payment_plan_hs_list->StartRec) {
		$payment_plan_hs_list->RowCnt++;

		// Set up key count
		$payment_plan_hs_list->KeyCount = $payment_plan_hs_list->RowIndex;

		// Init row class and style
		$payment_plan_hs->resetAttributes();
		$payment_plan_hs->CssClass = "";
		if ($payment_plan_hs->isGridAdd()) {
		} else {
			$payment_plan_hs_list->loadRowValues($payment_plan_hs_list->Recordset); // Load row values
		}
		$payment_plan_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_plan_hs->RowAttrs = array_merge($payment_plan_hs->RowAttrs, array('data-rowindex'=>$payment_plan_hs_list->RowCnt, 'id'=>'r' . $payment_plan_hs_list->RowCnt . '_payment_plan_hs', 'data-rowtype'=>$payment_plan_hs->RowType));

		// Render row
		$payment_plan_hs_list->renderRow();

		// Render list options
		$payment_plan_hs_list->renderListOptions();
?>
	<tr<?php echo $payment_plan_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_plan_hs_list->ListOptions->render("body", "left", $payment_plan_hs_list->RowCnt);
?>
	<?php if ($payment_plan_hs->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payment_plan_hs->id->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_id" class="payment_plan_hs_id">
<span<?php echo $payment_plan_hs->id->viewAttributes() ?>>
<?php echo $payment_plan_hs->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $payment_plan_hs->grp->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_grp" class="payment_plan_hs_grp">
<span<?php echo $payment_plan_hs->grp->viewAttributes() ?>>
<?php echo $payment_plan_hs->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $payment_plan_hs->s_grp->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_s_grp" class="payment_plan_hs_s_grp">
<span<?php echo $payment_plan_hs->s_grp->viewAttributes() ?>>
<?php echo $payment_plan_hs->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $payment_plan_hs->godown->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_godown" class="payment_plan_hs_godown">
<span<?php echo $payment_plan_hs->godown->viewAttributes() ?>>
<?php echo $payment_plan_hs->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $payment_plan_hs->rid->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_rid" class="payment_plan_hs_rid">
<span<?php echo $payment_plan_hs->rid->viewAttributes() ?>>
<?php echo $payment_plan_hs->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $payment_plan_hs->batch_no->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_batch_no" class="payment_plan_hs_batch_no">
<span<?php echo $payment_plan_hs->batch_no->viewAttributes() ?>>
<?php echo $payment_plan_hs->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->count->Visible) { // count ?>
		<td data-name="count"<?php echo $payment_plan_hs->count->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_count" class="payment_plan_hs_count">
<span<?php echo $payment_plan_hs->count->viewAttributes() ?>>
<?php echo $payment_plan_hs->count->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->twist->Visible) { // twist ?>
		<td data-name="twist"<?php echo $payment_plan_hs->twist->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_twist" class="payment_plan_hs_twist">
<span<?php echo $payment_plan_hs->twist->viewAttributes() ?>>
<?php echo $payment_plan_hs->twist->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->min_tolerance->Visible) { // min_tolerance ?>
		<td data-name="min_tolerance"<?php echo $payment_plan_hs->min_tolerance->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_min_tolerance" class="payment_plan_hs_min_tolerance">
<span<?php echo $payment_plan_hs->min_tolerance->viewAttributes() ?>>
<?php echo $payment_plan_hs->min_tolerance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->max_tolerance->Visible) { // max_tolerance ?>
		<td data-name="max_tolerance"<?php echo $payment_plan_hs->max_tolerance->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_max_tolerance" class="payment_plan_hs_max_tolerance">
<span<?php echo $payment_plan_hs->max_tolerance->viewAttributes() ?>>
<?php echo $payment_plan_hs->max_tolerance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->description->Visible) { // description ?>
		<td data-name="description"<?php echo $payment_plan_hs->description->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_description" class="payment_plan_hs_description">
<span<?php echo $payment_plan_hs->description->viewAttributes() ?>>
<?php echo $payment_plan_hs->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->yes_no->Visible) { // yes_no ?>
		<td data-name="yes_no"<?php echo $payment_plan_hs->yes_no->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_yes_no" class="payment_plan_hs_yes_no">
<span<?php echo $payment_plan_hs->yes_no->viewAttributes() ?>>
<?php echo $payment_plan_hs->yes_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $payment_plan_hs->_40->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs__40" class="payment_plan_hs__40">
<span<?php echo $payment_plan_hs->_40->viewAttributes() ?>>
<?php echo $payment_plan_hs->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->shortage_deduction->Visible) { // shortage_deduction ?>
		<td data-name="shortage_deduction"<?php echo $payment_plan_hs->shortage_deduction->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_shortage_deduction" class="payment_plan_hs_shortage_deduction">
<span<?php echo $payment_plan_hs->shortage_deduction->viewAttributes() ?>>
<?php echo $payment_plan_hs->shortage_deduction->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->status->Visible) { // status ?>
		<td data-name="status"<?php echo $payment_plan_hs->status->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_status" class="payment_plan_hs_status">
<span<?php echo $payment_plan_hs->status->viewAttributes() ?>>
<?php echo $payment_plan_hs->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $payment_plan_hs->operator->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_operator" class="payment_plan_hs_operator">
<span<?php echo $payment_plan_hs->operator->viewAttributes() ?>>
<?php echo $payment_plan_hs->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payment_plan_hs->datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_hs_list->RowCnt ?>_payment_plan_hs_datetime" class="payment_plan_hs_datetime">
<span<?php echo $payment_plan_hs->datetime->viewAttributes() ?>>
<?php echo $payment_plan_hs->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_plan_hs_list->ListOptions->render("body", "right", $payment_plan_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_plan_hs->isGridAdd())
		$payment_plan_hs_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_plan_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_plan_hs_list->Recordset)
	$payment_plan_hs_list->Recordset->Close();
?>
<?php if (!$payment_plan_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_plan_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_hs_list->Pager)) $payment_plan_hs_list->Pager = new PrevNextPager($payment_plan_hs_list->StartRec, $payment_plan_hs_list->DisplayRecs, $payment_plan_hs_list->TotalRecs, $payment_plan_hs_list->AutoHidePager) ?>
<?php if ($payment_plan_hs_list->Pager->RecordCount > 0 && $payment_plan_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_hs_list->pageUrl() ?>start=<?php echo $payment_plan_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_hs_list->pageUrl() ?>start=<?php echo $payment_plan_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_hs_list->pageUrl() ?>start=<?php echo $payment_plan_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_hs_list->pageUrl() ?>start=<?php echo $payment_plan_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_hs_list->TotalRecs > 0 && (!$payment_plan_hs_list->AutoHidePageSizeSelector || $payment_plan_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_plan_hs_list->TotalRecs == 0 && !$payment_plan_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_plan_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_plan_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_plan_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_plan_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_plan_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_plan_hs_list->terminate();
?>