<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_material_add = new payment_plan_material_add();

// Run the page
$payment_plan_material_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_material_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpayment_plan_materialadd = currentForm = new ew.Form("fpayment_plan_materialadd", "add");

// Validate form
fpayment_plan_materialadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($payment_plan_material_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->location->caption(), $payment_plan_material->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->type->caption(), $payment_plan_material->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->description->caption(), $payment_plan_material->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->from_date->Required) { ?>
			elm = this.getElements("x" + infix + "_from_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->from_date->caption(), $payment_plan_material->from_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_from_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan_material->from_date->errorMessage()) ?>");
		<?php if ($payment_plan_material_add->to_date->Required) { ?>
			elm = this.getElements("x" + infix + "_to_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->to_date->caption(), $payment_plan_material->to_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_to_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan_material->to_date->errorMessage()) ?>");
		<?php if ($payment_plan_material_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->grp->caption(), $payment_plan_material->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->s_grp->caption(), $payment_plan_material->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->varient->Required) { ?>
			elm = this.getElements("x" + infix + "_varient");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->varient->caption(), $payment_plan_material->varient->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->varient_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_varient_ref[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->varient_ref->caption(), $payment_plan_material->varient_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->product->caption(), $payment_plan_material->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->rid->caption(), $payment_plan_material->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->process->caption(), $payment_plan_material->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->yes_no->Required) { ?>
			elm = this.getElements("x" + infix + "_yes_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->yes_no->caption(), $payment_plan_material->yes_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->method->Required) { ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->method->caption(), $payment_plan_material->method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->process_method->Required) { ?>
			elm = this.getElements("x" + infix + "_process_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->process_method->caption(), $payment_plan_material->process_method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->input_type->Required) { ?>
			elm = this.getElements("x" + infix + "_input_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->input_type->caption(), $payment_plan_material->input_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->output_type->Required) { ?>
			elm = this.getElements("x" + infix + "_output_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->output_type->caption(), $payment_plan_material->output_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->ply->Required) { ?>
			elm = this.getElements("x" + infix + "_ply");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->ply->caption(), $payment_plan_material->ply->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ply");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan_material->ply->errorMessage()) ?>");
		<?php if ($payment_plan_material_add->_40->Required) { ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->_40->caption(), $payment_plan_material->_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan_material->_40->errorMessage()) ?>");
		<?php if ($payment_plan_material_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->status->caption(), $payment_plan_material->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->operator->caption(), $payment_plan_material->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->datetime->caption(), $payment_plan_material->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_material_add->uploads->Required) { ?>
			elm = this.getElements("x" + infix + "_uploads");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan_material->uploads->caption(), $payment_plan_material->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpayment_plan_materialadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_materialadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_materialadd.lists["x_location[]"] = <?php echo $payment_plan_material_add->location->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_location[]"].options = <?php echo JsonEncode($payment_plan_material_add->location->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_type"] = <?php echo $payment_plan_material_add->type->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_type"].options = <?php echo JsonEncode($payment_plan_material_add->type->options(FALSE, TRUE)) ?>;
fpayment_plan_materialadd.lists["x_grp"] = <?php echo $payment_plan_material_add->grp->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_grp"].options = <?php echo JsonEncode($payment_plan_material_add->grp->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_s_grp[]"] = <?php echo $payment_plan_material_add->s_grp->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_s_grp[]"].options = <?php echo JsonEncode($payment_plan_material_add->s_grp->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_varient"] = <?php echo $payment_plan_material_add->varient->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_varient"].options = <?php echo JsonEncode($payment_plan_material_add->varient->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_varient_ref[]"] = <?php echo $payment_plan_material_add->varient_ref->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_varient_ref[]"].options = <?php echo JsonEncode($payment_plan_material_add->varient_ref->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_product[]"] = <?php echo $payment_plan_material_add->product->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_product[]"].options = <?php echo JsonEncode($payment_plan_material_add->product->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_rid[]"] = <?php echo $payment_plan_material_add->rid->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_rid[]"].options = <?php echo JsonEncode($payment_plan_material_add->rid->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_process"] = <?php echo $payment_plan_material_add->process->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_process"].options = <?php echo JsonEncode($payment_plan_material_add->process->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_yes_no"] = <?php echo $payment_plan_material_add->yes_no->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_yes_no"].options = <?php echo JsonEncode($payment_plan_material_add->yes_no->options(FALSE, TRUE)) ?>;
fpayment_plan_materialadd.lists["x_method"] = <?php echo $payment_plan_material_add->method->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_method"].options = <?php echo JsonEncode($payment_plan_material_add->method->options(FALSE, TRUE)) ?>;
fpayment_plan_materialadd.lists["x_process_method"] = <?php echo $payment_plan_material_add->process_method->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_process_method"].options = <?php echo JsonEncode($payment_plan_material_add->process_method->options(FALSE, TRUE)) ?>;
fpayment_plan_materialadd.lists["x_input_type"] = <?php echo $payment_plan_material_add->input_type->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_input_type"].options = <?php echo JsonEncode($payment_plan_material_add->input_type->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_output_type"] = <?php echo $payment_plan_material_add->output_type->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_output_type"].options = <?php echo JsonEncode($payment_plan_material_add->output_type->lookupOptions()) ?>;
fpayment_plan_materialadd.lists["x_status"] = <?php echo $payment_plan_material_add->status->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_status"].options = <?php echo JsonEncode($payment_plan_material_add->status->options(FALSE, TRUE)) ?>;
fpayment_plan_materialadd.lists["x_operator"] = <?php echo $payment_plan_material_add->operator->Lookup->toClientList() ?>;
fpayment_plan_materialadd.lists["x_operator"].options = <?php echo JsonEncode($payment_plan_material_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_plan_material_add->showPageHeader(); ?>
<?php
$payment_plan_material_add->showMessage();
?>
<form name="fpayment_plan_materialadd" id="fpayment_plan_materialadd" class="<?php echo $payment_plan_material_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_material_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_material_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan_material">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$payment_plan_material_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($payment_plan_material->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_payment_plan_material_location" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->location->caption() ?><?php echo ($payment_plan_material->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->location->cellAttributes() ?>>
<span id="el_payment_plan_material_location">
<div id="tp_x_location" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan_material" data-field="x_location" data-value-separator="<?php echo $payment_plan_material->location->displayValueSeparatorAttribute() ?>" name="x_location[]" id="x_location[]" value="{value}"<?php echo $payment_plan_material->location->editAttributes() ?>></div>
<div id="dsl_x_location" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payment_plan_material->location->checkBoxListHtml(FALSE, "x_location[]") ?>
</div></div>
<?php echo $payment_plan_material->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $payment_plan_material->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_payment_plan_material_type" for="x_type" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->type->caption() ?><?php echo ($payment_plan_material->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->type->cellAttributes() ?>>
<span id="el_payment_plan_material_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_type" data-value-separator="<?php echo $payment_plan_material->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $payment_plan_material->type->editAttributes() ?>>
		<?php echo $payment_plan_material->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $payment_plan_material->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_payment_plan_material_description" for="x_description" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->description->caption() ?><?php echo ($payment_plan_material->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->description->cellAttributes() ?>>
<span id="el_payment_plan_material_description">
<input type="text" data-table="payment_plan_material" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($payment_plan_material->description->getPlaceHolder()) ?>" value="<?php echo $payment_plan_material->description->EditValue ?>"<?php echo $payment_plan_material->description->editAttributes() ?>>
</span>
<?php echo $payment_plan_material->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->from_date->Visible) { // from_date ?>
	<div id="r_from_date" class="form-group row">
		<label id="elh_payment_plan_material_from_date" for="x_from_date" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->from_date->caption() ?><?php echo ($payment_plan_material->from_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->from_date->cellAttributes() ?>>
<span id="el_payment_plan_material_from_date">
<input type="text" data-table="payment_plan_material" data-field="x_from_date" name="x_from_date" id="x_from_date" placeholder="<?php echo HtmlEncode($payment_plan_material->from_date->getPlaceHolder()) ?>" value="<?php echo $payment_plan_material->from_date->EditValue ?>"<?php echo $payment_plan_material->from_date->editAttributes() ?>>
<?php if (!$payment_plan_material->from_date->ReadOnly && !$payment_plan_material->from_date->Disabled && !isset($payment_plan_material->from_date->EditAttrs["readonly"]) && !isset($payment_plan_material->from_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_plan_materialadd", "x_from_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $payment_plan_material->from_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->to_date->Visible) { // to_date ?>
	<div id="r_to_date" class="form-group row">
		<label id="elh_payment_plan_material_to_date" for="x_to_date" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->to_date->caption() ?><?php echo ($payment_plan_material->to_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->to_date->cellAttributes() ?>>
<span id="el_payment_plan_material_to_date">
<input type="text" data-table="payment_plan_material" data-field="x_to_date" name="x_to_date" id="x_to_date" placeholder="<?php echo HtmlEncode($payment_plan_material->to_date->getPlaceHolder()) ?>" value="<?php echo $payment_plan_material->to_date->EditValue ?>"<?php echo $payment_plan_material->to_date->editAttributes() ?>>
<?php if (!$payment_plan_material->to_date->ReadOnly && !$payment_plan_material->to_date->Disabled && !isset($payment_plan_material->to_date->EditAttrs["readonly"]) && !isset($payment_plan_material->to_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_plan_materialadd", "x_to_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $payment_plan_material->to_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_payment_plan_material_grp" for="x_grp" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->grp->caption() ?><?php echo ($payment_plan_material->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->grp->cellAttributes() ?>>
<span id="el_payment_plan_material_grp">
<?php $payment_plan_material->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$payment_plan_material->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_grp" data-value-separator="<?php echo $payment_plan_material->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $payment_plan_material->grp->editAttributes() ?>>
		<?php echo $payment_plan_material->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $payment_plan_material->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $payment_plan_material->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_payment_plan_material_s_grp" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->s_grp->caption() ?><?php echo ($payment_plan_material->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->s_grp->cellAttributes() ?>>
<span id="el_payment_plan_material_s_grp">
<?php $payment_plan_material->s_grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$payment_plan_material->s_grp->EditAttrs["onclick"]; ?>
<div id="tp_x_s_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan_material" data-field="x_s_grp" data-value-separator="<?php echo $payment_plan_material->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp[]" id="x_s_grp[]" value="{value}"<?php echo $payment_plan_material->s_grp->editAttributes() ?>></div>
<div id="dsl_x_s_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payment_plan_material->s_grp->checkBoxListHtml(FALSE, "x_s_grp[]") ?>
</div></div>
<?php echo $payment_plan_material->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $payment_plan_material->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->varient->Visible) { // varient ?>
	<div id="r_varient" class="form-group row">
		<label id="elh_payment_plan_material_varient" for="x_varient" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->varient->caption() ?><?php echo ($payment_plan_material->varient->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->varient->cellAttributes() ?>>
<span id="el_payment_plan_material_varient">
<?php $payment_plan_material->varient->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$payment_plan_material->varient->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_varient" data-value-separator="<?php echo $payment_plan_material->varient->displayValueSeparatorAttribute() ?>" id="x_varient" name="x_varient"<?php echo $payment_plan_material->varient->editAttributes() ?>>
		<?php echo $payment_plan_material->varient->selectOptionListHtml("x_varient") ?>
	</select>
</div>
<?php echo $payment_plan_material->varient->Lookup->getParamTag("p_x_varient") ?>
</span>
<?php echo $payment_plan_material->varient->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->varient_ref->Visible) { // varient_ref ?>
	<div id="r_varient_ref" class="form-group row">
		<label id="elh_payment_plan_material_varient_ref" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->varient_ref->caption() ?><?php echo ($payment_plan_material->varient_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->varient_ref->cellAttributes() ?>>
<span id="el_payment_plan_material_varient_ref">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($payment_plan_material->varient_ref->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $payment_plan_material->varient_ref->ViewValue ?></button>
		<div id="dsl_x_varient_ref" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $payment_plan_material->varient_ref->checkBoxListHtml(TRUE, "x_varient_ref[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_varient_ref" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan_material" data-field="x_varient_ref" data-value-separator="<?php echo $payment_plan_material->varient_ref->displayValueSeparatorAttribute() ?>" name="x_varient_ref[]" id="x_varient_ref[]" value="{value}"<?php echo $payment_plan_material->varient_ref->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$payment_plan_material->varient_ref->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $payment_plan_material->varient_ref->Lookup->getParamTag("p_x_varient_ref") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
<?php echo $payment_plan_material->varient_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_payment_plan_material_product" for="x_product" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->product->caption() ?><?php echo ($payment_plan_material->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->product->cellAttributes() ?>>
<span id="el_payment_plan_material_product">
<?php $payment_plan_material->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$payment_plan_material->product->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_product"><?php echo strval($payment_plan_material->product->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($payment_plan_material->product->ViewValue) : $payment_plan_material->product->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_plan_material->product->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($payment_plan_material->product->ReadOnly || $payment_plan_material->product->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_product[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $payment_plan_material->product->Lookup->getParamTag("p_x_product") ?>
<input type="hidden" data-table="payment_plan_material" data-field="x_product" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $payment_plan_material->product->displayValueSeparatorAttribute() ?>" name="x_product[]" id="x_product[]" value="<?php echo $payment_plan_material->product->CurrentValue ?>"<?php echo $payment_plan_material->product->editAttributes() ?>>
</span>
<?php echo $payment_plan_material->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_payment_plan_material_rid" for="x_rid" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->rid->caption() ?><?php echo ($payment_plan_material->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->rid->cellAttributes() ?>>
<span id="el_payment_plan_material_rid">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid"><?php echo strval($payment_plan_material->rid->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($payment_plan_material->rid->ViewValue) : $payment_plan_material->rid->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_plan_material->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($payment_plan_material->rid->ReadOnly || $payment_plan_material->rid->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $payment_plan_material->rid->Lookup->getParamTag("p_x_rid") ?>
<input type="hidden" data-table="payment_plan_material" data-field="x_rid" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $payment_plan_material->rid->displayValueSeparatorAttribute() ?>" name="x_rid[]" id="x_rid[]" value="<?php echo $payment_plan_material->rid->CurrentValue ?>"<?php echo $payment_plan_material->rid->editAttributes() ?>>
</span>
<?php echo $payment_plan_material->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_payment_plan_material_process" for="x_process" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->process->caption() ?><?php echo ($payment_plan_material->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->process->cellAttributes() ?>>
<span id="el_payment_plan_material_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_process" data-value-separator="<?php echo $payment_plan_material->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $payment_plan_material->process->editAttributes() ?>>
		<?php echo $payment_plan_material->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $payment_plan_material->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $payment_plan_material->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->yes_no->Visible) { // yes_no ?>
	<div id="r_yes_no" class="form-group row">
		<label id="elh_payment_plan_material_yes_no" for="x_yes_no" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->yes_no->caption() ?><?php echo ($payment_plan_material->yes_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->yes_no->cellAttributes() ?>>
<span id="el_payment_plan_material_yes_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_yes_no" data-value-separator="<?php echo $payment_plan_material->yes_no->displayValueSeparatorAttribute() ?>" id="x_yes_no" name="x_yes_no"<?php echo $payment_plan_material->yes_no->editAttributes() ?>>
		<?php echo $payment_plan_material->yes_no->selectOptionListHtml("x_yes_no") ?>
	</select>
</div>
</span>
<?php echo $payment_plan_material->yes_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label id="elh_payment_plan_material_method" for="x_method" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->method->caption() ?><?php echo ($payment_plan_material->method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->method->cellAttributes() ?>>
<span id="el_payment_plan_material_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_method" data-value-separator="<?php echo $payment_plan_material->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $payment_plan_material->method->editAttributes() ?>>
		<?php echo $payment_plan_material->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
</span>
<?php echo $payment_plan_material->method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->process_method->Visible) { // process_method ?>
	<div id="r_process_method" class="form-group row">
		<label id="elh_payment_plan_material_process_method" for="x_process_method" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->process_method->caption() ?><?php echo ($payment_plan_material->process_method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->process_method->cellAttributes() ?>>
<span id="el_payment_plan_material_process_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_process_method" data-value-separator="<?php echo $payment_plan_material->process_method->displayValueSeparatorAttribute() ?>" id="x_process_method" name="x_process_method"<?php echo $payment_plan_material->process_method->editAttributes() ?>>
		<?php echo $payment_plan_material->process_method->selectOptionListHtml("x_process_method") ?>
	</select>
</div>
</span>
<?php echo $payment_plan_material->process_method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->input_type->Visible) { // input_type ?>
	<div id="r_input_type" class="form-group row">
		<label id="elh_payment_plan_material_input_type" for="x_input_type" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->input_type->caption() ?><?php echo ($payment_plan_material->input_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->input_type->cellAttributes() ?>>
<span id="el_payment_plan_material_input_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_input_type" data-value-separator="<?php echo $payment_plan_material->input_type->displayValueSeparatorAttribute() ?>" id="x_input_type" name="x_input_type"<?php echo $payment_plan_material->input_type->editAttributes() ?>>
		<?php echo $payment_plan_material->input_type->selectOptionListHtml("x_input_type") ?>
	</select>
</div>
<?php echo $payment_plan_material->input_type->Lookup->getParamTag("p_x_input_type") ?>
</span>
<?php echo $payment_plan_material->input_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->output_type->Visible) { // output_type ?>
	<div id="r_output_type" class="form-group row">
		<label id="elh_payment_plan_material_output_type" for="x_output_type" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->output_type->caption() ?><?php echo ($payment_plan_material->output_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->output_type->cellAttributes() ?>>
<span id="el_payment_plan_material_output_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_output_type" data-value-separator="<?php echo $payment_plan_material->output_type->displayValueSeparatorAttribute() ?>" id="x_output_type" name="x_output_type"<?php echo $payment_plan_material->output_type->editAttributes() ?>>
		<?php echo $payment_plan_material->output_type->selectOptionListHtml("x_output_type") ?>
	</select>
</div>
<?php echo $payment_plan_material->output_type->Lookup->getParamTag("p_x_output_type") ?>
</span>
<?php echo $payment_plan_material->output_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->ply->Visible) { // ply ?>
	<div id="r_ply" class="form-group row">
		<label id="elh_payment_plan_material_ply" for="x_ply" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->ply->caption() ?><?php echo ($payment_plan_material->ply->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->ply->cellAttributes() ?>>
<span id="el_payment_plan_material_ply">
<input type="text" data-table="payment_plan_material" data-field="x_ply" name="x_ply" id="x_ply" size="30" placeholder="<?php echo HtmlEncode($payment_plan_material->ply->getPlaceHolder()) ?>" value="<?php echo $payment_plan_material->ply->EditValue ?>"<?php echo $payment_plan_material->ply->editAttributes() ?>>
</span>
<?php echo $payment_plan_material->ply->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label id="elh_payment_plan_material__40" for="x__40" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->_40->caption() ?><?php echo ($payment_plan_material->_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->_40->cellAttributes() ?>>
<span id="el_payment_plan_material__40">
<input type="text" data-table="payment_plan_material" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($payment_plan_material->_40->getPlaceHolder()) ?>" value="<?php echo $payment_plan_material->_40->EditValue ?>"<?php echo $payment_plan_material->_40->editAttributes() ?>>
</span>
<?php echo $payment_plan_material->_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_payment_plan_material_status" for="x_status" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->status->caption() ?><?php echo ($payment_plan_material->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->status->cellAttributes() ?>>
<span id="el_payment_plan_material_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_status" data-value-separator="<?php echo $payment_plan_material->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $payment_plan_material->status->editAttributes() ?>>
		<?php echo $payment_plan_material->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $payment_plan_material->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_material->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_payment_plan_material_uploads" for="x_uploads" class="<?php echo $payment_plan_material_add->LeftColumnClass ?>"><?php echo $payment_plan_material->uploads->caption() ?><?php echo ($payment_plan_material->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_material_add->RightColumnClass ?>"><div<?php echo $payment_plan_material->uploads->cellAttributes() ?>>
<span id="el_payment_plan_material_uploads">
<textarea data-table="payment_plan_material" data-field="x_uploads" name="x_uploads" id="x_uploads" cols="35" rows="4" placeholder="<?php echo HtmlEncode($payment_plan_material->uploads->getPlaceHolder()) ?>"<?php echo $payment_plan_material->uploads->editAttributes() ?>><?php echo $payment_plan_material->uploads->EditValue ?></textarea>
</span>
<?php echo $payment_plan_material->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_plan_material_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_plan_material_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payment_plan_material_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_plan_material_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		$("#r_ply").hide()
		var type = $("#x_type").val();
		if (type == 2)
		{
		$("#r_product").hide();
		$("#r_rid").hide();	
		$("#r_varient").show();
		$("#r_varient_ref").show();
		} else if (type == 3) {
		$("#r_product").show();
		$("#r_rid").show();
		$("#r_varient").hide();
		$("#r_varient_ref").hide();
		} else {
		$("#r_product").hide();
		$("#r_rid").hide();
		$("#r_varient").hide();
		$("#r_varient_ref").hide();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$payment_plan_material_add->terminate();
?>