<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_material_list = new payment_plan_material_list();

// Run the page
$payment_plan_material_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_material_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_plan_material->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_plan_materiallist = currentForm = new ew.Form("fpayment_plan_materiallist", "list");
fpayment_plan_materiallist.formKeyCountName = '<?php echo $payment_plan_material_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_plan_materiallist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_materiallist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_materiallist.lists["x_location[]"] = <?php echo $payment_plan_material_list->location->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_location[]"].options = <?php echo JsonEncode($payment_plan_material_list->location->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_type"] = <?php echo $payment_plan_material_list->type->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_type"].options = <?php echo JsonEncode($payment_plan_material_list->type->options(FALSE, TRUE)) ?>;
fpayment_plan_materiallist.lists["x_grp"] = <?php echo $payment_plan_material_list->grp->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_grp"].options = <?php echo JsonEncode($payment_plan_material_list->grp->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_s_grp[]"] = <?php echo $payment_plan_material_list->s_grp->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_s_grp[]"].options = <?php echo JsonEncode($payment_plan_material_list->s_grp->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_varient"] = <?php echo $payment_plan_material_list->varient->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_varient"].options = <?php echo JsonEncode($payment_plan_material_list->varient->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_varient_ref[]"] = <?php echo $payment_plan_material_list->varient_ref->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_varient_ref[]"].options = <?php echo JsonEncode($payment_plan_material_list->varient_ref->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_product[]"] = <?php echo $payment_plan_material_list->product->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_product[]"].options = <?php echo JsonEncode($payment_plan_material_list->product->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_rid[]"] = <?php echo $payment_plan_material_list->rid->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_rid[]"].options = <?php echo JsonEncode($payment_plan_material_list->rid->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_process"] = <?php echo $payment_plan_material_list->process->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_process"].options = <?php echo JsonEncode($payment_plan_material_list->process->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_yes_no"] = <?php echo $payment_plan_material_list->yes_no->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_yes_no"].options = <?php echo JsonEncode($payment_plan_material_list->yes_no->options(FALSE, TRUE)) ?>;
fpayment_plan_materiallist.lists["x_method"] = <?php echo $payment_plan_material_list->method->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_method"].options = <?php echo JsonEncode($payment_plan_material_list->method->options(FALSE, TRUE)) ?>;
fpayment_plan_materiallist.lists["x_process_method"] = <?php echo $payment_plan_material_list->process_method->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_process_method"].options = <?php echo JsonEncode($payment_plan_material_list->process_method->options(FALSE, TRUE)) ?>;
fpayment_plan_materiallist.lists["x_input_type"] = <?php echo $payment_plan_material_list->input_type->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_input_type"].options = <?php echo JsonEncode($payment_plan_material_list->input_type->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_output_type"] = <?php echo $payment_plan_material_list->output_type->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_output_type"].options = <?php echo JsonEncode($payment_plan_material_list->output_type->lookupOptions()) ?>;
fpayment_plan_materiallist.lists["x_status"] = <?php echo $payment_plan_material_list->status->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_status"].options = <?php echo JsonEncode($payment_plan_material_list->status->options(FALSE, TRUE)) ?>;
fpayment_plan_materiallist.lists["x_operator"] = <?php echo $payment_plan_material_list->operator->Lookup->toClientList() ?>;
fpayment_plan_materiallist.lists["x_operator"].options = <?php echo JsonEncode($payment_plan_material_list->operator->lookupOptions()) ?>;

// Form object for search
var fpayment_plan_materiallistsrch = currentSearchForm = new ew.Form("fpayment_plan_materiallistsrch");

// Validate function for search
fpayment_plan_materiallistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan_material->_40->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpayment_plan_materiallistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_materiallistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_materiallistsrch.lists["x_location[]"] = <?php echo $payment_plan_material_list->location->Lookup->toClientList() ?>;
fpayment_plan_materiallistsrch.lists["x_location[]"].options = <?php echo JsonEncode($payment_plan_material_list->location->lookupOptions()) ?>;
fpayment_plan_materiallistsrch.lists["x_type"] = <?php echo $payment_plan_material_list->type->Lookup->toClientList() ?>;
fpayment_plan_materiallistsrch.lists["x_type"].options = <?php echo JsonEncode($payment_plan_material_list->type->options(FALSE, TRUE)) ?>;
fpayment_plan_materiallistsrch.lists["x_process"] = <?php echo $payment_plan_material_list->process->Lookup->toClientList() ?>;
fpayment_plan_materiallistsrch.lists["x_process"].options = <?php echo JsonEncode($payment_plan_material_list->process->lookupOptions()) ?>;
fpayment_plan_materiallistsrch.lists["x_method"] = <?php echo $payment_plan_material_list->method->Lookup->toClientList() ?>;
fpayment_plan_materiallistsrch.lists["x_method"].options = <?php echo JsonEncode($payment_plan_material_list->method->options(FALSE, TRUE)) ?>;
fpayment_plan_materiallistsrch.lists["x_input_type"] = <?php echo $payment_plan_material_list->input_type->Lookup->toClientList() ?>;
fpayment_plan_materiallistsrch.lists["x_input_type"].options = <?php echo JsonEncode($payment_plan_material_list->input_type->lookupOptions()) ?>;
fpayment_plan_materiallistsrch.lists["x_output_type"] = <?php echo $payment_plan_material_list->output_type->Lookup->toClientList() ?>;
fpayment_plan_materiallistsrch.lists["x_output_type"].options = <?php echo JsonEncode($payment_plan_material_list->output_type->lookupOptions()) ?>;
fpayment_plan_materiallistsrch.lists["x_status"] = <?php echo $payment_plan_material_list->status->Lookup->toClientList() ?>;
fpayment_plan_materiallistsrch.lists["x_status"].options = <?php echo JsonEncode($payment_plan_material_list->status->options(FALSE, TRUE)) ?>;

// Filters
fpayment_plan_materiallistsrch.filterList = <?php echo $payment_plan_material_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_plan_materiallistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_plan_material->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_plan_material_list->TotalRecs > 0 && $payment_plan_material_list->ExportOptions->visible()) { ?>
<?php $payment_plan_material_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_material_list->ImportOptions->visible()) { ?>
<?php $payment_plan_material_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_material_list->SearchOptions->visible()) { ?>
<?php $payment_plan_material_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_material_list->FilterOptions->visible()) { ?>
<?php $payment_plan_material_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_plan_material_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_plan_material->isExport() && !$payment_plan_material->CurrentAction) { ?>
<form name="fpayment_plan_materiallistsrch" id="fpayment_plan_materiallistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_plan_material_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_plan_materiallistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_plan_material">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$payment_plan_material_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$payment_plan_material->RowType = ROWTYPE_SEARCH;

// Render row
$payment_plan_material->resetAttributes();
$payment_plan_material_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($payment_plan_material->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $payment_plan_material->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_location" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan_material" data-field="x_location" data-value-separator="<?php echo $payment_plan_material->location->displayValueSeparatorAttribute() ?>" name="x_location[]" id="x_location[]" value="{value}"<?php echo $payment_plan_material->location->editAttributes() ?>></div>
<div id="dsl_x_location" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payment_plan_material->location->checkBoxListHtml(FALSE, "x_location[]") ?>
</div></div>
<?php echo $payment_plan_material->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_material->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $payment_plan_material->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_type" data-value-separator="<?php echo $payment_plan_material->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $payment_plan_material->type->editAttributes() ?>>
		<?php echo $payment_plan_material->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_material->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $payment_plan_material->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_process" data-value-separator="<?php echo $payment_plan_material->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $payment_plan_material->process->editAttributes() ?>>
		<?php echo $payment_plan_material->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $payment_plan_material->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($payment_plan_material->method->Visible) { // method ?>
	<div id="xsc_method" class="ew-cell form-group">
		<label for="x_method" class="ew-search-caption ew-label"><?php echo $payment_plan_material->method->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_method" id="z_method" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_method" data-value-separator="<?php echo $payment_plan_material->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $payment_plan_material->method->editAttributes() ?>>
		<?php echo $payment_plan_material->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_material->input_type->Visible) { // input_type ?>
	<div id="xsc_input_type" class="ew-cell form-group">
		<label for="x_input_type" class="ew-search-caption ew-label"><?php echo $payment_plan_material->input_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_input_type" id="z_input_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_input_type" data-value-separator="<?php echo $payment_plan_material->input_type->displayValueSeparatorAttribute() ?>" id="x_input_type" name="x_input_type"<?php echo $payment_plan_material->input_type->editAttributes() ?>>
		<?php echo $payment_plan_material->input_type->selectOptionListHtml("x_input_type") ?>
	</select>
</div>
<?php echo $payment_plan_material->input_type->Lookup->getParamTag("p_x_input_type") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_material->output_type->Visible) { // output_type ?>
	<div id="xsc_output_type" class="ew-cell form-group">
		<label for="x_output_type" class="ew-search-caption ew-label"><?php echo $payment_plan_material->output_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_output_type" id="z_output_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_output_type" data-value-separator="<?php echo $payment_plan_material->output_type->displayValueSeparatorAttribute() ?>" id="x_output_type" name="x_output_type"<?php echo $payment_plan_material->output_type->editAttributes() ?>>
		<?php echo $payment_plan_material->output_type->selectOptionListHtml("x_output_type") ?>
	</select>
</div>
<?php echo $payment_plan_material->output_type->Lookup->getParamTag("p_x_output_type") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($payment_plan_material->_40->Visible) { // @ ?>
	<div id="xsc__40" class="ew-cell form-group">
		<label for="x__40" class="ew-search-caption ew-label"><?php echo $payment_plan_material->_40->caption() ?></label>
		<span class="ew-search-operator"><select name="z__40" id="z__40" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($payment_plan_material->_40->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="payment_plan_material" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($payment_plan_material->_40->getPlaceHolder()) ?>" value="<?php echo $payment_plan_material->_40->EditValue ?>"<?php echo $payment_plan_material->_40->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__40 style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__40 style="d-none"">
<input type="text" data-table="payment_plan_material" data-field="x__40" name="y__40" id="y__40" size="30" placeholder="<?php echo HtmlEncode($payment_plan_material->_40->getPlaceHolder()) ?>" value="<?php echo $payment_plan_material->_40->EditValue2 ?>"<?php echo $payment_plan_material->_40->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_material->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $payment_plan_material->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_material" data-field="x_status" data-value-separator="<?php echo $payment_plan_material->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $payment_plan_material->status->editAttributes() ?>>
		<?php echo $payment_plan_material->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_plan_material_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_plan_material_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_plan_material_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_plan_material_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_material_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_material_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_material_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_plan_material_list->showPageHeader(); ?>
<?php
$payment_plan_material_list->showMessage();
?>
<?php if ($payment_plan_material_list->TotalRecs > 0 || $payment_plan_material->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_plan_material_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_plan_material">
<?php if (!$payment_plan_material->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_plan_material->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_material_list->Pager)) $payment_plan_material_list->Pager = new PrevNextPager($payment_plan_material_list->StartRec, $payment_plan_material_list->DisplayRecs, $payment_plan_material_list->TotalRecs, $payment_plan_material_list->AutoHidePager) ?>
<?php if ($payment_plan_material_list->Pager->RecordCount > 0 && $payment_plan_material_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_material_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_material_list->pageUrl() ?>start=<?php echo $payment_plan_material_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_material_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_material_list->pageUrl() ?>start=<?php echo $payment_plan_material_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_material_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_material_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_material_list->pageUrl() ?>start=<?php echo $payment_plan_material_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_material_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_material_list->pageUrl() ?>start=<?php echo $payment_plan_material_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_material_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_material_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_material_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_material_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_material_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_material_list->TotalRecs > 0 && (!$payment_plan_material_list->AutoHidePageSizeSelector || $payment_plan_material_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan_material">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_material_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_material_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_material_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_material_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_material_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan_material->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_material_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_plan_materiallist" id="fpayment_plan_materiallist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_material_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_material_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan_material">
<div id="gmp_payment_plan_material" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_plan_material_list->TotalRecs > 0 || $payment_plan_material->isGridEdit()) { ?>
<table id="tbl_payment_plan_materiallist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_plan_material_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_plan_material_list->renderListOptions();

// Render list options (header, left)
$payment_plan_material_list->ListOptions->render("header", "left");
?>
<?php if ($payment_plan_material->id->Visible) { // id ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->id) == "") { ?>
		<th data-name="id" class="<?php echo $payment_plan_material->id->headerCellClass() ?>"><div id="elh_payment_plan_material_id" class="payment_plan_material_id"><div class="ew-table-header-caption"><?php echo $payment_plan_material->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payment_plan_material->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->id) ?>',2);"><div id="elh_payment_plan_material_id" class="payment_plan_material_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->location->Visible) { // location ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->location) == "") { ?>
		<th data-name="location" class="<?php echo $payment_plan_material->location->headerCellClass() ?>"><div id="elh_payment_plan_material_location" class="payment_plan_material_location"><div class="ew-table-header-caption"><?php echo $payment_plan_material->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $payment_plan_material->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->location) ?>',2);"><div id="elh_payment_plan_material_location" class="payment_plan_material_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->type->Visible) { // type ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->type) == "") { ?>
		<th data-name="type" class="<?php echo $payment_plan_material->type->headerCellClass() ?>"><div id="elh_payment_plan_material_type" class="payment_plan_material_type"><div class="ew-table-header-caption"><?php echo $payment_plan_material->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $payment_plan_material->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->type) ?>',2);"><div id="elh_payment_plan_material_type" class="payment_plan_material_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->description->Visible) { // description ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->description) == "") { ?>
		<th data-name="description" class="<?php echo $payment_plan_material->description->headerCellClass() ?>"><div id="elh_payment_plan_material_description" class="payment_plan_material_description"><div class="ew-table-header-caption"><?php echo $payment_plan_material->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $payment_plan_material->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->description) ?>',2);"><div id="elh_payment_plan_material_description" class="payment_plan_material_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->from_date->Visible) { // from_date ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->from_date) == "") { ?>
		<th data-name="from_date" class="<?php echo $payment_plan_material->from_date->headerCellClass() ?>"><div id="elh_payment_plan_material_from_date" class="payment_plan_material_from_date"><div class="ew-table-header-caption"><?php echo $payment_plan_material->from_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from_date" class="<?php echo $payment_plan_material->from_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->from_date) ?>',2);"><div id="elh_payment_plan_material_from_date" class="payment_plan_material_from_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->from_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->from_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->from_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->to_date->Visible) { // to_date ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->to_date) == "") { ?>
		<th data-name="to_date" class="<?php echo $payment_plan_material->to_date->headerCellClass() ?>"><div id="elh_payment_plan_material_to_date" class="payment_plan_material_to_date"><div class="ew-table-header-caption"><?php echo $payment_plan_material->to_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_date" class="<?php echo $payment_plan_material->to_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->to_date) ?>',2);"><div id="elh_payment_plan_material_to_date" class="payment_plan_material_to_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->to_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->to_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->to_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->grp->Visible) { // grp ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $payment_plan_material->grp->headerCellClass() ?>"><div id="elh_payment_plan_material_grp" class="payment_plan_material_grp"><div class="ew-table-header-caption"><?php echo $payment_plan_material->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $payment_plan_material->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->grp) ?>',2);"><div id="elh_payment_plan_material_grp" class="payment_plan_material_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->s_grp->Visible) { // s_grp ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $payment_plan_material->s_grp->headerCellClass() ?>"><div id="elh_payment_plan_material_s_grp" class="payment_plan_material_s_grp"><div class="ew-table-header-caption"><?php echo $payment_plan_material->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $payment_plan_material->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->s_grp) ?>',2);"><div id="elh_payment_plan_material_s_grp" class="payment_plan_material_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->varient->Visible) { // varient ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->varient) == "") { ?>
		<th data-name="varient" class="<?php echo $payment_plan_material->varient->headerCellClass() ?>"><div id="elh_payment_plan_material_varient" class="payment_plan_material_varient"><div class="ew-table-header-caption"><?php echo $payment_plan_material->varient->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="varient" class="<?php echo $payment_plan_material->varient->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->varient) ?>',2);"><div id="elh_payment_plan_material_varient" class="payment_plan_material_varient">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->varient->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->varient->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->varient->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->varient_ref->Visible) { // varient_ref ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->varient_ref) == "") { ?>
		<th data-name="varient_ref" class="<?php echo $payment_plan_material->varient_ref->headerCellClass() ?>"><div id="elh_payment_plan_material_varient_ref" class="payment_plan_material_varient_ref"><div class="ew-table-header-caption"><?php echo $payment_plan_material->varient_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="varient_ref" class="<?php echo $payment_plan_material->varient_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->varient_ref) ?>',2);"><div id="elh_payment_plan_material_varient_ref" class="payment_plan_material_varient_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->varient_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->varient_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->varient_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->product->Visible) { // product ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->product) == "") { ?>
		<th data-name="product" class="<?php echo $payment_plan_material->product->headerCellClass() ?>"><div id="elh_payment_plan_material_product" class="payment_plan_material_product"><div class="ew-table-header-caption"><?php echo $payment_plan_material->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $payment_plan_material->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->product) ?>',2);"><div id="elh_payment_plan_material_product" class="payment_plan_material_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->rid->Visible) { // rid ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $payment_plan_material->rid->headerCellClass() ?>"><div id="elh_payment_plan_material_rid" class="payment_plan_material_rid"><div class="ew-table-header-caption"><?php echo $payment_plan_material->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $payment_plan_material->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->rid) ?>',2);"><div id="elh_payment_plan_material_rid" class="payment_plan_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->process->Visible) { // process ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->process) == "") { ?>
		<th data-name="process" class="<?php echo $payment_plan_material->process->headerCellClass() ?>"><div id="elh_payment_plan_material_process" class="payment_plan_material_process"><div class="ew-table-header-caption"><?php echo $payment_plan_material->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $payment_plan_material->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->process) ?>',2);"><div id="elh_payment_plan_material_process" class="payment_plan_material_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->yes_no->Visible) { // yes_no ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->yes_no) == "") { ?>
		<th data-name="yes_no" class="<?php echo $payment_plan_material->yes_no->headerCellClass() ?>"><div id="elh_payment_plan_material_yes_no" class="payment_plan_material_yes_no"><div class="ew-table-header-caption"><?php echo $payment_plan_material->yes_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="yes_no" class="<?php echo $payment_plan_material->yes_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->yes_no) ?>',2);"><div id="elh_payment_plan_material_yes_no" class="payment_plan_material_yes_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->yes_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->yes_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->yes_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->method->Visible) { // method ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->method) == "") { ?>
		<th data-name="method" class="<?php echo $payment_plan_material->method->headerCellClass() ?>"><div id="elh_payment_plan_material_method" class="payment_plan_material_method"><div class="ew-table-header-caption"><?php echo $payment_plan_material->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $payment_plan_material->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->method) ?>',2);"><div id="elh_payment_plan_material_method" class="payment_plan_material_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->process_method->Visible) { // process_method ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->process_method) == "") { ?>
		<th data-name="process_method" class="<?php echo $payment_plan_material->process_method->headerCellClass() ?>"><div id="elh_payment_plan_material_process_method" class="payment_plan_material_process_method"><div class="ew-table-header-caption"><?php echo $payment_plan_material->process_method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_method" class="<?php echo $payment_plan_material->process_method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->process_method) ?>',2);"><div id="elh_payment_plan_material_process_method" class="payment_plan_material_process_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->process_method->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->process_method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->process_method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->input_type->Visible) { // input_type ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->input_type) == "") { ?>
		<th data-name="input_type" class="<?php echo $payment_plan_material->input_type->headerCellClass() ?>"><div id="elh_payment_plan_material_input_type" class="payment_plan_material_input_type"><div class="ew-table-header-caption"><?php echo $payment_plan_material->input_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="input_type" class="<?php echo $payment_plan_material->input_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->input_type) ?>',2);"><div id="elh_payment_plan_material_input_type" class="payment_plan_material_input_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->input_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->input_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->input_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->output_type->Visible) { // output_type ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->output_type) == "") { ?>
		<th data-name="output_type" class="<?php echo $payment_plan_material->output_type->headerCellClass() ?>"><div id="elh_payment_plan_material_output_type" class="payment_plan_material_output_type"><div class="ew-table-header-caption"><?php echo $payment_plan_material->output_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="output_type" class="<?php echo $payment_plan_material->output_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->output_type) ?>',2);"><div id="elh_payment_plan_material_output_type" class="payment_plan_material_output_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->output_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->output_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->output_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->ply->Visible) { // ply ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->ply) == "") { ?>
		<th data-name="ply" class="<?php echo $payment_plan_material->ply->headerCellClass() ?>"><div id="elh_payment_plan_material_ply" class="payment_plan_material_ply"><div class="ew-table-header-caption"><?php echo $payment_plan_material->ply->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply" class="<?php echo $payment_plan_material->ply->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->ply) ?>',2);"><div id="elh_payment_plan_material_ply" class="payment_plan_material_ply">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->ply->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->ply->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->ply->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->_40->Visible) { // @ ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $payment_plan_material->_40->headerCellClass() ?>"><div id="elh_payment_plan_material__40" class="payment_plan_material__40"><div class="ew-table-header-caption"><?php echo $payment_plan_material->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $payment_plan_material->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->_40) ?>',2);"><div id="elh_payment_plan_material__40" class="payment_plan_material__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->status->Visible) { // status ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->status) == "") { ?>
		<th data-name="status" class="<?php echo $payment_plan_material->status->headerCellClass() ?>"><div id="elh_payment_plan_material_status" class="payment_plan_material_status"><div class="ew-table-header-caption"><?php echo $payment_plan_material->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $payment_plan_material->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->status) ?>',2);"><div id="elh_payment_plan_material_status" class="payment_plan_material_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->operator->Visible) { // operator ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $payment_plan_material->operator->headerCellClass() ?>"><div id="elh_payment_plan_material_operator" class="payment_plan_material_operator"><div class="ew-table-header-caption"><?php echo $payment_plan_material->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $payment_plan_material->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->operator) ?>',2);"><div id="elh_payment_plan_material_operator" class="payment_plan_material_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_material->datetime->Visible) { // datetime ?>
	<?php if ($payment_plan_material->sortUrl($payment_plan_material->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payment_plan_material->datetime->headerCellClass() ?>"><div id="elh_payment_plan_material_datetime" class="payment_plan_material_datetime"><div class="ew-table-header-caption"><?php echo $payment_plan_material->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payment_plan_material->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_material->SortUrl($payment_plan_material->datetime) ?>',2);"><div id="elh_payment_plan_material_datetime" class="payment_plan_material_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_material->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_material->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_material->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_plan_material_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_plan_material->ExportAll && $payment_plan_material->isExport()) {
	$payment_plan_material_list->StopRec = $payment_plan_material_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_plan_material_list->TotalRecs > $payment_plan_material_list->StartRec + $payment_plan_material_list->DisplayRecs - 1)
		$payment_plan_material_list->StopRec = $payment_plan_material_list->StartRec + $payment_plan_material_list->DisplayRecs - 1;
	else
		$payment_plan_material_list->StopRec = $payment_plan_material_list->TotalRecs;
}
$payment_plan_material_list->RecCnt = $payment_plan_material_list->StartRec - 1;
if ($payment_plan_material_list->Recordset && !$payment_plan_material_list->Recordset->EOF) {
	$payment_plan_material_list->Recordset->moveFirst();
	$selectLimit = $payment_plan_material_list->UseSelectLimit;
	if (!$selectLimit && $payment_plan_material_list->StartRec > 1)
		$payment_plan_material_list->Recordset->move($payment_plan_material_list->StartRec - 1);
} elseif (!$payment_plan_material->AllowAddDeleteRow && $payment_plan_material_list->StopRec == 0) {
	$payment_plan_material_list->StopRec = $payment_plan_material->GridAddRowCount;
}

// Initialize aggregate
$payment_plan_material->RowType = ROWTYPE_AGGREGATEINIT;
$payment_plan_material->resetAttributes();
$payment_plan_material_list->renderRow();
while ($payment_plan_material_list->RecCnt < $payment_plan_material_list->StopRec) {
	$payment_plan_material_list->RecCnt++;
	if ($payment_plan_material_list->RecCnt >= $payment_plan_material_list->StartRec) {
		$payment_plan_material_list->RowCnt++;

		// Set up key count
		$payment_plan_material_list->KeyCount = $payment_plan_material_list->RowIndex;

		// Init row class and style
		$payment_plan_material->resetAttributes();
		$payment_plan_material->CssClass = "";
		if ($payment_plan_material->isGridAdd()) {
		} else {
			$payment_plan_material_list->loadRowValues($payment_plan_material_list->Recordset); // Load row values
		}
		$payment_plan_material->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_plan_material->RowAttrs = array_merge($payment_plan_material->RowAttrs, array('data-rowindex'=>$payment_plan_material_list->RowCnt, 'id'=>'r' . $payment_plan_material_list->RowCnt . '_payment_plan_material', 'data-rowtype'=>$payment_plan_material->RowType));

		// Render row
		$payment_plan_material_list->renderRow();

		// Render list options
		$payment_plan_material_list->renderListOptions();
?>
	<tr<?php echo $payment_plan_material->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_plan_material_list->ListOptions->render("body", "left", $payment_plan_material_list->RowCnt);
?>
	<?php if ($payment_plan_material->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payment_plan_material->id->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_id" class="payment_plan_material_id">
<span<?php echo $payment_plan_material->id->viewAttributes() ?>>
<?php echo $payment_plan_material->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->location->Visible) { // location ?>
		<td data-name="location"<?php echo $payment_plan_material->location->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_location" class="payment_plan_material_location">
<span<?php echo $payment_plan_material->location->viewAttributes() ?>>
<?php echo $payment_plan_material->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->type->Visible) { // type ?>
		<td data-name="type"<?php echo $payment_plan_material->type->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_type" class="payment_plan_material_type">
<span<?php echo $payment_plan_material->type->viewAttributes() ?>>
<?php if ((!EmptyString($payment_plan_material->type->getViewValue())) && $payment_plan_material->type->linkAttributes() <> "") { ?>
<a<?php echo $payment_plan_material->type->linkAttributes() ?>><?php echo $payment_plan_material->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_plan_material->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->description->Visible) { // description ?>
		<td data-name="description"<?php echo $payment_plan_material->description->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_description" class="payment_plan_material_description">
<span<?php echo $payment_plan_material->description->viewAttributes() ?>>
<?php echo $payment_plan_material->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->from_date->Visible) { // from_date ?>
		<td data-name="from_date"<?php echo $payment_plan_material->from_date->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_from_date" class="payment_plan_material_from_date">
<span<?php echo $payment_plan_material->from_date->viewAttributes() ?>>
<?php echo $payment_plan_material->from_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->to_date->Visible) { // to_date ?>
		<td data-name="to_date"<?php echo $payment_plan_material->to_date->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_to_date" class="payment_plan_material_to_date">
<span<?php echo $payment_plan_material->to_date->viewAttributes() ?>>
<?php echo $payment_plan_material->to_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $payment_plan_material->grp->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_grp" class="payment_plan_material_grp">
<span<?php echo $payment_plan_material->grp->viewAttributes() ?>>
<?php echo $payment_plan_material->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $payment_plan_material->s_grp->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_s_grp" class="payment_plan_material_s_grp">
<span<?php echo $payment_plan_material->s_grp->viewAttributes() ?>>
<?php echo $payment_plan_material->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->varient->Visible) { // varient ?>
		<td data-name="varient"<?php echo $payment_plan_material->varient->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_varient" class="payment_plan_material_varient">
<span<?php echo $payment_plan_material->varient->viewAttributes() ?>>
<?php echo $payment_plan_material->varient->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->varient_ref->Visible) { // varient_ref ?>
		<td data-name="varient_ref"<?php echo $payment_plan_material->varient_ref->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_varient_ref" class="payment_plan_material_varient_ref">
<span<?php echo $payment_plan_material->varient_ref->viewAttributes() ?>>
<?php echo $payment_plan_material->varient_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->product->Visible) { // product ?>
		<td data-name="product"<?php echo $payment_plan_material->product->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_product" class="payment_plan_material_product">
<span<?php echo $payment_plan_material->product->viewAttributes() ?>>
<?php echo $payment_plan_material->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $payment_plan_material->rid->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_rid" class="payment_plan_material_rid">
<span<?php echo $payment_plan_material->rid->viewAttributes() ?>>
<?php echo $payment_plan_material->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->process->Visible) { // process ?>
		<td data-name="process"<?php echo $payment_plan_material->process->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_process" class="payment_plan_material_process">
<span<?php echo $payment_plan_material->process->viewAttributes() ?>>
<?php if ((!EmptyString($payment_plan_material->process->getViewValue())) && $payment_plan_material->process->linkAttributes() <> "") { ?>
<a<?php echo $payment_plan_material->process->linkAttributes() ?>><?php echo $payment_plan_material->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_plan_material->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->yes_no->Visible) { // yes_no ?>
		<td data-name="yes_no"<?php echo $payment_plan_material->yes_no->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_yes_no" class="payment_plan_material_yes_no">
<span<?php echo $payment_plan_material->yes_no->viewAttributes() ?>>
<?php echo $payment_plan_material->yes_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->method->Visible) { // method ?>
		<td data-name="method"<?php echo $payment_plan_material->method->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_method" class="payment_plan_material_method">
<span<?php echo $payment_plan_material->method->viewAttributes() ?>>
<?php echo $payment_plan_material->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->process_method->Visible) { // process_method ?>
		<td data-name="process_method"<?php echo $payment_plan_material->process_method->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_process_method" class="payment_plan_material_process_method">
<span<?php echo $payment_plan_material->process_method->viewAttributes() ?>>
<?php echo $payment_plan_material->process_method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->input_type->Visible) { // input_type ?>
		<td data-name="input_type"<?php echo $payment_plan_material->input_type->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_input_type" class="payment_plan_material_input_type">
<span<?php echo $payment_plan_material->input_type->viewAttributes() ?>>
<?php echo $payment_plan_material->input_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->output_type->Visible) { // output_type ?>
		<td data-name="output_type"<?php echo $payment_plan_material->output_type->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_output_type" class="payment_plan_material_output_type">
<span<?php echo $payment_plan_material->output_type->viewAttributes() ?>>
<?php echo $payment_plan_material->output_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->ply->Visible) { // ply ?>
		<td data-name="ply"<?php echo $payment_plan_material->ply->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_ply" class="payment_plan_material_ply">
<span<?php echo $payment_plan_material->ply->viewAttributes() ?>>
<?php echo $payment_plan_material->ply->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $payment_plan_material->_40->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material__40" class="payment_plan_material__40">
<span<?php echo $payment_plan_material->_40->viewAttributes() ?>>
<?php echo $payment_plan_material->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->status->Visible) { // status ?>
		<td data-name="status"<?php echo $payment_plan_material->status->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_status" class="payment_plan_material_status">
<span<?php echo $payment_plan_material->status->viewAttributes() ?>>
<?php echo $payment_plan_material->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $payment_plan_material->operator->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_operator" class="payment_plan_material_operator">
<span<?php echo $payment_plan_material->operator->viewAttributes() ?>>
<?php echo $payment_plan_material->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_material->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payment_plan_material->datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_material_list->RowCnt ?>_payment_plan_material_datetime" class="payment_plan_material_datetime">
<span<?php echo $payment_plan_material->datetime->viewAttributes() ?>>
<?php echo $payment_plan_material->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_plan_material_list->ListOptions->render("body", "right", $payment_plan_material_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_plan_material->isGridAdd())
		$payment_plan_material_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_plan_material->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_plan_material_list->Recordset)
	$payment_plan_material_list->Recordset->Close();
?>
<?php if (!$payment_plan_material->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_plan_material->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_material_list->Pager)) $payment_plan_material_list->Pager = new PrevNextPager($payment_plan_material_list->StartRec, $payment_plan_material_list->DisplayRecs, $payment_plan_material_list->TotalRecs, $payment_plan_material_list->AutoHidePager) ?>
<?php if ($payment_plan_material_list->Pager->RecordCount > 0 && $payment_plan_material_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_material_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_material_list->pageUrl() ?>start=<?php echo $payment_plan_material_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_material_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_material_list->pageUrl() ?>start=<?php echo $payment_plan_material_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_material_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_material_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_material_list->pageUrl() ?>start=<?php echo $payment_plan_material_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_material_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_material_list->pageUrl() ?>start=<?php echo $payment_plan_material_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_material_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_material_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_material_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_material_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_material_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_material_list->TotalRecs > 0 && (!$payment_plan_material_list->AutoHidePageSizeSelector || $payment_plan_material_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan_material">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_material_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_material_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_material_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_material_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_material_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan_material->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_material_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_plan_material_list->TotalRecs == 0 && !$payment_plan_material->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_plan_material_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_plan_material_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_plan_material->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_plan_material->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_plan_material", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_plan_material_list->terminate();
?>